% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_traveltime.R
\docType{data}
\name{traveltime}
\alias{traveltime}
\title{Accessibility to Cities layer}
\format{
Global raster layer available for year 2015.
}
\source{
\url{https://figshare.com/articles/dataset/Travel_time_to_cities_and_ports_in_the_year_2015/7638134/3}
}
\description{
This resource is published by Weiss et al. (2018) "A global map of travel
time to cities to assess inequalities in accessibility in 2015" on journal
nature. Accessibility is the ease with which larger cities can be reached
from a certain location. This resource represents the travel time to major
cities in the year 2015. Encoded as minutes, representing the time needed
to reach that particular cell from nearby city of target population range.
The following ranges to nearby cities are available:
\itemize{
\item "5k_10k"
\item "10k_20k"
\item "20k_50k"
\item "50k_100k"
\item "100k_200k"
\item "200k_500k"
\item "500k_1mio"
\item "1mio_5mio"
\item "50k_50mio"
\item "5k_110mio"
\item "20k_110mio"
}
}
\details{
The following argument should be specified by users:

\describe{
\item{range_traveltime}{A character vector indicating one or more ranges
to download.}
}
}
\references{
Weiss, D. J., Nelson, A., Gibson, H. S., Temperley, W., Peedell,
S., Lieber, A., … & Gething, P. W. (2018). A global map of travel time to cities
to assess inequalities in accessibility in 2015. Nature, 553(7688), 333-336.
}
\keyword{resource}
