/**
 * MapLibre GL JS
 * @license 3-Clause BSD. Full text of license: https://github.com/maplibre/maplibre-gl-js/blob/v4.6.0/LICENSE.txt
 */
(function (global, factory) {
typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory() :
typeof define === 'function' && define.amd ? define(factory) :
(global = typeof globalThis !== 'undefined' ? globalThis : global || self, global.maplibregl = factory());
})(this, (function () { 'use strict';

/* eslint-disable */

var maplibregl = {};
var modules = {};
function define(moduleName, _dependencies, moduleFactory) {
    modules[moduleName] = moduleFactory;

    // to get the list of modules see generated dist/maplibre-gl-dev.js file (look for `define(` calls)
    if (moduleName !== 'index') {
        return;
    }

    // we assume that when an index module is initializing then other modules are loaded already
    var workerBundleString = 'var sharedModule = {}; (' + modules.shared + ')(sharedModule); (' + modules.worker + ')(sharedModule);'

    var sharedModule = {};
    // the order of arguments of a module factory depends on rollup (it decides who is whose dependency)
    // to check the correct order, see dist/maplibre-gl-dev.js file (look for `define(` calls)
    // we assume that for our 3 chunks it will generate 3 modules and their order is predefined like the following
    modules.shared(sharedModule);
    modules.index(maplibregl, sharedModule);

    if (typeof window !== 'undefined') {
        maplibregl.setWorkerUrl(window.URL.createObjectURL(new Blob([workerBundleString], { type: 'text/javascript' })));
    }

    return maplibregl;
};



define("shared",["exports"],(function(t){"use strict";function e(t,e,r,n){return new(r||(r=Promise))((function(i,s){function a(t){try{l(n.next(t));}catch(t){s(t);}}function o(t){try{l(n.throw(t));}catch(t){s(t);}}function l(t){var e;t.done?i(t.value):(e=t.value,e instanceof r?e:new r((function(t){t(e);}))).then(a,o);}l((n=n.apply(t,e||[])).next());}))}function r(t){return t&&t.__esModule&&Object.prototype.hasOwnProperty.call(t,"default")?t.default:t}"function"==typeof SuppressedError&&SuppressedError;var n=i;function i(t,e){this.x=t,this.y=e;}i.prototype={clone:function(){return new i(this.x,this.y)},add:function(t){return this.clone()._add(t)},sub:function(t){return this.clone()._sub(t)},multByPoint:function(t){return this.clone()._multByPoint(t)},divByPoint:function(t){return this.clone()._divByPoint(t)},mult:function(t){return this.clone()._mult(t)},div:function(t){return this.clone()._div(t)},rotate:function(t){return this.clone()._rotate(t)},rotateAround:function(t,e){return this.clone()._rotateAround(t,e)},matMult:function(t){return this.clone()._matMult(t)},unit:function(){return this.clone()._unit()},perp:function(){return this.clone()._perp()},round:function(){return this.clone()._round()},mag:function(){return Math.sqrt(this.x*this.x+this.y*this.y)},equals:function(t){return this.x===t.x&&this.y===t.y},dist:function(t){return Math.sqrt(this.distSqr(t))},distSqr:function(t){var e=t.x-this.x,r=t.y-this.y;return e*e+r*r},angle:function(){return Math.atan2(this.y,this.x)},angleTo:function(t){return Math.atan2(this.y-t.y,this.x-t.x)},angleWith:function(t){return this.angleWithSep(t.x,t.y)},angleWithSep:function(t,e){return Math.atan2(this.x*e-this.y*t,this.x*t+this.y*e)},_matMult:function(t){var e=t[2]*this.x+t[3]*this.y;return this.x=t[0]*this.x+t[1]*this.y,this.y=e,this},_add:function(t){return this.x+=t.x,this.y+=t.y,this},_sub:function(t){return this.x-=t.x,this.y-=t.y,this},_mult:function(t){return this.x*=t,this.y*=t,this},_div:function(t){return this.x/=t,this.y/=t,this},_multByPoint:function(t){return this.x*=t.x,this.y*=t.y,this},_divByPoint:function(t){return this.x/=t.x,this.y/=t.y,this},_unit:function(){return this._div(this.mag()),this},_perp:function(){var t=this.y;return this.y=this.x,this.x=-t,this},_rotate:function(t){var e=Math.cos(t),r=Math.sin(t),n=r*this.x+e*this.y;return this.x=e*this.x-r*this.y,this.y=n,this},_rotateAround:function(t,e){var r=Math.cos(t),n=Math.sin(t),i=e.y+n*(this.x-e.x)+r*(this.y-e.y);return this.x=e.x+r*(this.x-e.x)-n*(this.y-e.y),this.y=i,this},_round:function(){return this.x=Math.round(this.x),this.y=Math.round(this.y),this}},i.convert=function(t){return t instanceof i?t:Array.isArray(t)?new i(t[0],t[1]):t};var s=r(n),a=o;function o(t,e,r,n){this.cx=3*t,this.bx=3*(r-t)-this.cx,this.ax=1-this.cx-this.bx,this.cy=3*e,this.by=3*(n-e)-this.cy,this.ay=1-this.cy-this.by,this.p1x=t,this.p1y=e,this.p2x=r,this.p2y=n;}o.prototype={sampleCurveX:function(t){return ((this.ax*t+this.bx)*t+this.cx)*t},sampleCurveY:function(t){return ((this.ay*t+this.by)*t+this.cy)*t},sampleCurveDerivativeX:function(t){return (3*this.ax*t+2*this.bx)*t+this.cx},solveCurveX:function(t,e){if(void 0===e&&(e=1e-6),t<0)return 0;if(t>1)return 1;for(var r=t,n=0;n<8;n++){var i=this.sampleCurveX(r)-t;if(Math.abs(i)<e)return r;var s=this.sampleCurveDerivativeX(r);if(Math.abs(s)<1e-6)break;r-=i/s;}var a=0,o=1;for(r=t,n=0;n<20&&(i=this.sampleCurveX(r),!(Math.abs(i-t)<e));n++)t>i?a=r:o=r,r=.5*(o-a)+a;return r},solve:function(t,e){return this.sampleCurveY(this.solveCurveX(t,e))}};var l=r(a);let u,c;function h(){return null==u&&(u="undefined"!=typeof OffscreenCanvas&&new OffscreenCanvas(1,1).getContext("2d")&&"function"==typeof createImageBitmap),u}function p(){if(null==c&&(c=!1,h())){const t=5,e=new OffscreenCanvas(t,t).getContext("2d",{willReadFrequently:!0});if(e){for(let r=0;r<t*t;r++){const n=4*r;e.fillStyle=`rgb(${n},${n+1},${n+2})`,e.fillRect(r%t,Math.floor(r/t),1,1);}const r=e.getImageData(0,0,t,t).data;for(let e=0;e<t*t*4;e++)if(e%4!=3&&r[e]!==e){c=!0;break}}}return c||!1}function f(t,e,r,n){const i=new l(t,e,r,n);return t=>i.solve(t)}const d=f(.25,.1,.25,1);function y(t,e,r){return Math.min(r,Math.max(e,t))}function m(t,e,r){const n=r-e,i=((t-e)%n+n)%n+e;return i===e?r:i}function g(t,...e){for(const r of e)for(const e in r)t[e]=r[e];return t}let x=1;function v(t,e,r){const n={};for(const r in t)n[r]=e.call(this,t[r],r,t);return n}function b(t,e,r){const n={};for(const r in t)e.call(this,t[r],r,t)&&(n[r]=t[r]);return n}function w(t){return Array.isArray(t)?t.map(w):"object"==typeof t&&t?v(t,w):t}const _={};function A(t){_[t]||("undefined"!=typeof console&&console.warn(t),_[t]=!0);}function S(t,e,r){return (r.y-t.y)*(e.x-t.x)>(e.y-t.y)*(r.x-t.x)}function k(t){return "undefined"!=typeof WorkerGlobalScope&&void 0!==t&&t instanceof WorkerGlobalScope}let M=null;function I(t){return "undefined"!=typeof ImageBitmap&&t instanceof ImageBitmap}const z="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAYAAAAfFcSJAAAAC0lEQVQYV2NgAAIAAAUAAarVyFEAAAAASUVORK5CYII=";function P(t,r,n,i,s){return e(this,void 0,void 0,(function*(){if("undefined"==typeof VideoFrame)throw new Error("VideoFrame not supported");const e=new VideoFrame(t,{timestamp:0});try{const a=null==e?void 0:e.format;if(!a||!a.startsWith("BGR")&&!a.startsWith("RGB"))throw new Error(`Unrecognized format ${a}`);const o=a.startsWith("BGR"),l=new Uint8ClampedArray(i*s*4);if(yield e.copyTo(l,function(t,e,r,n,i){const s=4*Math.max(-e,0),a=(Math.max(0,r)-r)*n*4+s,o=4*n,l=Math.max(0,e),u=Math.max(0,r);return {rect:{x:l,y:u,width:Math.min(t.width,e+n)-l,height:Math.min(t.height,r+i)-u},layout:[{offset:a,stride:o}]}}(t,r,n,i,s)),o)for(let t=0;t<l.length;t+=4){const e=l[t];l[t]=l[t+2],l[t+2]=e;}return l}finally{e.close();}}))}let C,B;const V="AbortError";function E(){return new Error(V)}const F={MAX_PARALLEL_IMAGE_REQUESTS:16,MAX_PARALLEL_IMAGE_REQUESTS_PER_FRAME:8,MAX_TILE_CACHE_ZOOM_LEVELS:5,REGISTERED_PROTOCOLS:{},WORKER_URL:""};function T(t){return F.REGISTERED_PROTOCOLS[t.substring(0,t.indexOf("://"))]}const $="global-dispatcher";class L extends Error{constructor(t,e,r,n){super(`AJAXError: ${e} (${t}): ${r}`),this.status=t,this.statusText=e,this.url=r,this.body=n;}}const D=()=>k(self)?self.worker&&self.worker.referrer:("blob:"===window.location.protocol?window.parent:window).location.href,O=function(t,r){if(/:\/\//.test(t.url)&&!/^https?:|^file:/.test(t.url)){const e=T(t.url);if(e)return e(t,r);if(k(self)&&self.worker&&self.worker.actor)return self.worker.actor.sendAsync({type:"GR",data:t,targetMapId:$},r)}if(!(/^file:/.test(n=t.url)||/^file:/.test(D())&&!/^\w+:/.test(n))){if(fetch&&Request&&AbortController&&Object.prototype.hasOwnProperty.call(Request.prototype,"signal"))return function(t,r){return e(this,void 0,void 0,(function*(){const e=new Request(t.url,{method:t.method||"GET",body:t.body,credentials:t.credentials,headers:t.headers,cache:t.cache,referrer:D(),signal:r.signal});"json"!==t.type||e.headers.has("Accept")||e.headers.set("Accept","application/json");const n=yield fetch(e);if(!n.ok){const e=yield n.blob();throw new L(n.status,n.statusText,t.url,e)}let i;i="arrayBuffer"===t.type||"image"===t.type?n.arrayBuffer():"json"===t.type?n.json():n.text();const s=yield i;if(r.signal.aborted)throw E();return {data:s,cacheControl:n.headers.get("Cache-Control"),expires:n.headers.get("Expires")}}))}(t,r);if(k(self)&&self.worker&&self.worker.actor)return self.worker.actor.sendAsync({type:"GR",data:t,mustQueue:!0,targetMapId:$},r)}var n;return function(t,e){return new Promise(((r,n)=>{var i;const s=new XMLHttpRequest;s.open(t.method||"GET",t.url,!0),"arrayBuffer"!==t.type&&"image"!==t.type||(s.responseType="arraybuffer");for(const e in t.headers)s.setRequestHeader(e,t.headers[e]);"json"===t.type&&(s.responseType="text",(null===(i=t.headers)||void 0===i?void 0:i.Accept)||s.setRequestHeader("Accept","application/json")),s.withCredentials="include"===t.credentials,s.onerror=()=>{n(new Error(s.statusText));},s.onload=()=>{if(!e.signal.aborted)if((s.status>=200&&s.status<300||0===s.status)&&null!==s.response){let e=s.response;if("json"===t.type)try{e=JSON.parse(s.response);}catch(t){return void n(t)}r({data:e,cacheControl:s.getResponseHeader("Cache-Control"),expires:s.getResponseHeader("Expires")});}else {const e=new Blob([s.response],{type:s.getResponseHeader("Content-Type")});n(new L(s.status,s.statusText,t.url,e));}},e.signal.addEventListener("abort",(()=>{s.abort(),n(E());})),s.send(t.body);}))}(t,r)};function j(t){if(!t||t.indexOf("://")<=0||0===t.indexOf("data:image/")||0===t.indexOf("blob:"))return !0;const e=new URL(t),r=window.location;return e.protocol===r.protocol&&e.host===r.host}function R(t,e,r){r[t]&&-1!==r[t].indexOf(e)||(r[t]=r[t]||[],r[t].push(e));}function U(t,e,r){if(r&&r[t]){const n=r[t].indexOf(e);-1!==n&&r[t].splice(n,1);}}class q{constructor(t,e={}){g(this,e),this.type=t;}}class N extends q{constructor(t,e={}){super("error",g({error:t},e));}}class Z{on(t,e){return this._listeners=this._listeners||{},R(t,e,this._listeners),this}off(t,e){return U(t,e,this._listeners),U(t,e,this._oneTimeListeners),this}once(t,e){return e?(this._oneTimeListeners=this._oneTimeListeners||{},R(t,e,this._oneTimeListeners),this):new Promise((e=>this.once(t,e)))}fire(t,e){"string"==typeof t&&(t=new q(t,e||{}));const r=t.type;if(this.listens(r)){t.target=this;const e=this._listeners&&this._listeners[r]?this._listeners[r].slice():[];for(const r of e)r.call(this,t);const n=this._oneTimeListeners&&this._oneTimeListeners[r]?this._oneTimeListeners[r].slice():[];for(const e of n)U(r,e,this._oneTimeListeners),e.call(this,t);const i=this._eventedParent;i&&(g(t,"function"==typeof this._eventedParentData?this._eventedParentData():this._eventedParentData),i.fire(t));}else t instanceof N&&console.error(t.error);return this}listens(t){return this._listeners&&this._listeners[t]&&this._listeners[t].length>0||this._oneTimeListeners&&this._oneTimeListeners[t]&&this._oneTimeListeners[t].length>0||this._eventedParent&&this._eventedParent.listens(t)}setEventedParent(t,e){return this._eventedParent=t,this._eventedParentData=e,this}}var G={$version:8,$root:{version:{required:!0,type:"enum",values:[8]},name:{type:"string"},metadata:{type:"*"},center:{type:"array",value:"number"},zoom:{type:"number"},bearing:{type:"number",default:0,period:360,units:"degrees"},pitch:{type:"number",default:0,units:"degrees"},light:{type:"light"},sky:{type:"sky"},projection:{type:"projection"},terrain:{type:"terrain"},sources:{required:!0,type:"sources"},sprite:{type:"sprite"},glyphs:{type:"string"},transition:{type:"transition"},layers:{required:!0,type:"array",value:"layer"}},sources:{"*":{type:"source"}},source:["source_vector","source_raster","source_raster_dem","source_geojson","source_video","source_image"],source_vector:{type:{required:!0,type:"enum",values:{vector:{}}},url:{type:"string"},tiles:{type:"array",value:"string"},bounds:{type:"array",value:"number",length:4,default:[-180,-85.051129,180,85.051129]},scheme:{type:"enum",values:{xyz:{},tms:{}},default:"xyz"},minzoom:{type:"number",default:0},maxzoom:{type:"number",default:22},attribution:{type:"string"},promoteId:{type:"promoteId"},volatile:{type:"boolean",default:!1},"*":{type:"*"}},source_raster:{type:{required:!0,type:"enum",values:{raster:{}}},url:{type:"string"},tiles:{type:"array",value:"string"},bounds:{type:"array",value:"number",length:4,default:[-180,-85.051129,180,85.051129]},minzoom:{type:"number",default:0},maxzoom:{type:"number",default:22},tileSize:{type:"number",default:512,units:"pixels"},scheme:{type:"enum",values:{xyz:{},tms:{}},default:"xyz"},attribution:{type:"string"},volatile:{type:"boolean",default:!1},"*":{type:"*"}},source_raster_dem:{type:{required:!0,type:"enum",values:{"raster-dem":{}}},url:{type:"string"},tiles:{type:"array",value:"string"},bounds:{type:"array",value:"number",length:4,default:[-180,-85.051129,180,85.051129]},minzoom:{type:"number",default:0},maxzoom:{type:"number",default:22},tileSize:{type:"number",default:512,units:"pixels"},attribution:{type:"string"},encoding:{type:"enum",values:{terrarium:{},mapbox:{},custom:{}},default:"mapbox"},redFactor:{type:"number",default:1},blueFactor:{type:"number",default:1},greenFactor:{type:"number",default:1},baseShift:{type:"number",default:0},volatile:{type:"boolean",default:!1},"*":{type:"*"}},source_geojson:{type:{required:!0,type:"enum",values:{geojson:{}}},data:{required:!0,type:"*"},maxzoom:{type:"number",default:18},attribution:{type:"string"},buffer:{type:"number",default:128,maximum:512,minimum:0},filter:{type:"*"},tolerance:{type:"number",default:.375},cluster:{type:"boolean",default:!1},clusterRadius:{type:"number",default:50,minimum:0},clusterMaxZoom:{type:"number"},clusterMinPoints:{type:"number"},clusterProperties:{type:"*"},lineMetrics:{type:"boolean",default:!1},generateId:{type:"boolean",default:!1},promoteId:{type:"promoteId"}},source_video:{type:{required:!0,type:"enum",values:{video:{}}},urls:{required:!0,type:"array",value:"string"},coordinates:{required:!0,type:"array",length:4,value:{type:"array",length:2,value:"number"}}},source_image:{type:{required:!0,type:"enum",values:{image:{}}},url:{required:!0,type:"string"},coordinates:{required:!0,type:"array",length:4,value:{type:"array",length:2,value:"number"}}},layer:{id:{type:"string",required:!0},type:{type:"enum",values:{fill:{},line:{},symbol:{},circle:{},heatmap:{},"fill-extrusion":{},raster:{},hillshade:{},background:{}},required:!0},metadata:{type:"*"},source:{type:"string"},"source-layer":{type:"string"},minzoom:{type:"number",minimum:0,maximum:24},maxzoom:{type:"number",minimum:0,maximum:24},filter:{type:"filter"},layout:{type:"layout"},paint:{type:"paint"}},layout:["layout_fill","layout_line","layout_circle","layout_heatmap","layout_fill-extrusion","layout_symbol","layout_raster","layout_hillshade","layout_background"],layout_background:{visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},layout_fill:{"fill-sort-key":{type:"number",expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},layout_circle:{"circle-sort-key":{type:"number",expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},layout_heatmap:{visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},"layout_fill-extrusion":{visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},layout_line:{"line-cap":{type:"enum",values:{butt:{},round:{},square:{}},default:"butt",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"line-join":{type:"enum",values:{bevel:{},round:{},miter:{}},default:"miter",expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"line-miter-limit":{type:"number",default:2,requires:[{"line-join":"miter"}],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"line-round-limit":{type:"number",default:1.05,requires:[{"line-join":"round"}],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"line-sort-key":{type:"number",expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},layout_symbol:{"symbol-placement":{type:"enum",values:{point:{},line:{},"line-center":{}},default:"point",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"symbol-spacing":{type:"number",default:250,minimum:1,units:"pixels",requires:[{"symbol-placement":"line"}],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"symbol-avoid-edges":{type:"boolean",default:!1,expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"symbol-sort-key":{type:"number",expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"symbol-z-order":{type:"enum",values:{auto:{},"viewport-y":{},source:{}},default:"auto",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-allow-overlap":{type:"boolean",default:!1,requires:["icon-image",{"!":"icon-overlap"}],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-overlap":{type:"enum",values:{never:{},always:{},cooperative:{}},requires:["icon-image"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-ignore-placement":{type:"boolean",default:!1,requires:["icon-image"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-optional":{type:"boolean",default:!1,requires:["icon-image","text-field"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-rotation-alignment":{type:"enum",values:{map:{},viewport:{},auto:{}},default:"auto",requires:["icon-image"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-size":{type:"number",default:1,minimum:0,units:"factor of the original icon size",requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"icon-text-fit":{type:"enum",values:{none:{},width:{},height:{},both:{}},default:"none",requires:["icon-image","text-field"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-text-fit-padding":{type:"array",value:"number",length:4,default:[0,0,0,0],units:"pixels",requires:["icon-image","text-field",{"icon-text-fit":["both","width","height"]}],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"icon-image":{type:"resolvedImage",tokens:!0,expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"icon-rotate":{type:"number",default:0,period:360,units:"degrees",requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"icon-padding":{type:"padding",default:[2],units:"pixels",requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"icon-keep-upright":{type:"boolean",default:!1,requires:["icon-image",{"icon-rotation-alignment":"map"},{"symbol-placement":["line","line-center"]}],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-offset":{type:"array",value:"number",length:2,default:[0,0],requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"icon-anchor":{type:"enum",values:{center:{},left:{},right:{},top:{},bottom:{},"top-left":{},"top-right":{},"bottom-left":{},"bottom-right":{}},default:"center",requires:["icon-image"],expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"icon-pitch-alignment":{type:"enum",values:{map:{},viewport:{},auto:{}},default:"auto",requires:["icon-image"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-pitch-alignment":{type:"enum",values:{map:{},viewport:{},auto:{}},default:"auto",requires:["text-field"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-rotation-alignment":{type:"enum",values:{map:{},viewport:{},"viewport-glyph":{},auto:{}},default:"auto",requires:["text-field"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-field":{type:"formatted",default:"",tokens:!0,expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-font":{type:"array",value:"string",default:["Open Sans Regular","Arial Unicode MS Regular"],requires:["text-field"],expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-size":{type:"number",default:16,minimum:0,units:"pixels",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-max-width":{type:"number",default:10,minimum:0,units:"ems",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-line-height":{type:"number",default:1.2,units:"ems",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"text-letter-spacing":{type:"number",default:0,units:"ems",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-justify":{type:"enum",values:{auto:{},left:{},center:{},right:{}},default:"center",requires:["text-field"],expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-radial-offset":{type:"number",units:"ems",default:0,requires:["text-field"],"property-type":"data-driven",expression:{interpolated:!0,parameters:["zoom","feature"]}},"text-variable-anchor":{type:"array",value:"enum",values:{center:{},left:{},right:{},top:{},bottom:{},"top-left":{},"top-right":{},"bottom-left":{},"bottom-right":{}},requires:["text-field",{"symbol-placement":["point"]}],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-variable-anchor-offset":{type:"variableAnchorOffsetCollection",requires:["text-field",{"symbol-placement":["point"]}],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-anchor":{type:"enum",values:{center:{},left:{},right:{},top:{},bottom:{},"top-left":{},"top-right":{},"bottom-left":{},"bottom-right":{}},default:"center",requires:["text-field",{"!":"text-variable-anchor"}],expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-max-angle":{type:"number",default:45,units:"degrees",requires:["text-field",{"symbol-placement":["line","line-center"]}],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"text-writing-mode":{type:"array",value:"enum",values:{horizontal:{},vertical:{}},requires:["text-field",{"symbol-placement":["point"]}],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-rotate":{type:"number",default:0,period:360,units:"degrees",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-padding":{type:"number",default:2,minimum:0,units:"pixels",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"text-keep-upright":{type:"boolean",default:!0,requires:["text-field",{"text-rotation-alignment":"map"},{"symbol-placement":["line","line-center"]}],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-transform":{type:"enum",values:{none:{},uppercase:{},lowercase:{}},default:"none",requires:["text-field"],expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-offset":{type:"array",value:"number",units:"ems",length:2,default:[0,0],requires:["text-field",{"!":"text-radial-offset"}],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-allow-overlap":{type:"boolean",default:!1,requires:["text-field",{"!":"text-overlap"}],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-overlap":{type:"enum",values:{never:{},always:{},cooperative:{}},requires:["text-field"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-ignore-placement":{type:"boolean",default:!1,requires:["text-field"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-optional":{type:"boolean",default:!1,requires:["text-field","icon-image"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},layout_raster:{visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},layout_hillshade:{visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},filter:{type:"array",value:"*"},filter_operator:{type:"enum",values:{"==":{},"!=":{},">":{},">=":{},"<":{},"<=":{},in:{},"!in":{},all:{},any:{},none:{},has:{},"!has":{}}},geometry_type:{type:"enum",values:{Point:{},LineString:{},Polygon:{}}},function:{expression:{type:"expression"},stops:{type:"array",value:"function_stop"},base:{type:"number",default:1,minimum:0},property:{type:"string",default:"$zoom"},type:{type:"enum",values:{identity:{},exponential:{},interval:{},categorical:{}},default:"exponential"},colorSpace:{type:"enum",values:{rgb:{},lab:{},hcl:{}},default:"rgb"},default:{type:"*",required:!1}},function_stop:{type:"array",minimum:0,maximum:24,value:["number","color"],length:2},expression:{type:"array",value:"*",minimum:1},light:{anchor:{type:"enum",default:"viewport",values:{map:{},viewport:{}},"property-type":"data-constant",transition:!1,expression:{interpolated:!1,parameters:["zoom"]}},position:{type:"array",default:[1.15,210,30],length:3,value:"number","property-type":"data-constant",transition:!0,expression:{interpolated:!0,parameters:["zoom"]}},color:{type:"color","property-type":"data-constant",default:"#ffffff",expression:{interpolated:!0,parameters:["zoom"]},transition:!0},intensity:{type:"number","property-type":"data-constant",default:.5,minimum:0,maximum:1,expression:{interpolated:!0,parameters:["zoom"]},transition:!0}},sky:{"sky-color":{type:"color","property-type":"data-constant",default:"#88C6FC",expression:{interpolated:!0,parameters:["zoom"]},transition:!0},"horizon-color":{type:"color","property-type":"data-constant",default:"#ffffff",expression:{interpolated:!0,parameters:["zoom"]},transition:!0},"fog-color":{type:"color","property-type":"data-constant",default:"#ffffff",expression:{interpolated:!0,parameters:["zoom"]},transition:!0},"fog-ground-blend":{type:"number","property-type":"data-constant",default:.5,minimum:0,maximum:1,expression:{interpolated:!0,parameters:["zoom"]},transition:!0},"horizon-fog-blend":{type:"number","property-type":"data-constant",default:.8,minimum:0,maximum:1,expression:{interpolated:!0,parameters:["zoom"]},transition:!0},"sky-horizon-blend":{type:"number","property-type":"data-constant",default:.8,minimum:0,maximum:1,expression:{interpolated:!0,parameters:["zoom"]},transition:!0},"atmosphere-blend":{type:"number","property-type":"data-constant",default:.8,minimum:0,maximum:1,expression:{interpolated:!0,parameters:["zoom"]},transition:!0}},terrain:{source:{type:"string",required:!0},exaggeration:{type:"number",minimum:0,default:1}},projection:{type:{type:"enum",default:"mercator",values:{mercator:{},globe:{}}}},paint:["paint_fill","paint_line","paint_circle","paint_heatmap","paint_fill-extrusion","paint_symbol","paint_raster","paint_hillshade","paint_background"],paint_fill:{"fill-antialias":{type:"boolean",default:!0,expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"fill-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-color":{type:"color",default:"#000000",transition:!0,requires:[{"!":"fill-pattern"}],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-outline-color":{type:"color",transition:!0,requires:[{"!":"fill-pattern"},{"fill-antialias":!0}],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-translate":{type:"array",value:"number",length:2,default:[0,0],transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"fill-translate-anchor":{type:"enum",values:{map:{},viewport:{}},default:"map",requires:["fill-translate"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"fill-pattern":{type:"resolvedImage",transition:!0,expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"cross-faded-data-driven"}},"paint_fill-extrusion":{"fill-extrusion-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"fill-extrusion-color":{type:"color",default:"#000000",transition:!0,requires:[{"!":"fill-extrusion-pattern"}],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-extrusion-translate":{type:"array",value:"number",length:2,default:[0,0],transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"fill-extrusion-translate-anchor":{type:"enum",values:{map:{},viewport:{}},default:"map",requires:["fill-extrusion-translate"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"fill-extrusion-pattern":{type:"resolvedImage",transition:!0,expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"cross-faded-data-driven"},"fill-extrusion-height":{type:"number",default:0,minimum:0,units:"meters",transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-extrusion-base":{type:"number",default:0,minimum:0,units:"meters",transition:!0,requires:["fill-extrusion-height"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-extrusion-vertical-gradient":{type:"boolean",default:!0,transition:!1,expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"}},paint_line:{"line-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-color":{type:"color",default:"#000000",transition:!0,requires:[{"!":"line-pattern"}],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-translate":{type:"array",value:"number",length:2,default:[0,0],transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"line-translate-anchor":{type:"enum",values:{map:{},viewport:{}},default:"map",requires:["line-translate"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"line-width":{type:"number",default:1,minimum:0,transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-gap-width":{type:"number",default:0,minimum:0,transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-offset":{type:"number",default:0,transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-blur":{type:"number",default:0,minimum:0,transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-dasharray":{type:"array",value:"number",minimum:0,transition:!0,units:"line widths",requires:[{"!":"line-pattern"}],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"cross-faded"},"line-pattern":{type:"resolvedImage",transition:!0,expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"cross-faded-data-driven"},"line-gradient":{type:"color",transition:!1,requires:[{"!":"line-dasharray"},{"!":"line-pattern"},{source:"geojson",has:{lineMetrics:!0}}],expression:{interpolated:!0,parameters:["line-progress"]},"property-type":"color-ramp"}},paint_circle:{"circle-radius":{type:"number",default:5,minimum:0,transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"circle-color":{type:"color",default:"#000000",transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"circle-blur":{type:"number",default:0,transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"circle-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"circle-translate":{type:"array",value:"number",length:2,default:[0,0],transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"circle-translate-anchor":{type:"enum",values:{map:{},viewport:{}},default:"map",requires:["circle-translate"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"circle-pitch-scale":{type:"enum",values:{map:{},viewport:{}},default:"map",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"circle-pitch-alignment":{type:"enum",values:{map:{},viewport:{}},default:"viewport",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"circle-stroke-width":{type:"number",default:0,minimum:0,transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"circle-stroke-color":{type:"color",default:"#000000",transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"circle-stroke-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"}},paint_heatmap:{"heatmap-radius":{type:"number",default:30,minimum:1,transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"heatmap-weight":{type:"number",default:1,minimum:0,transition:!1,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"heatmap-intensity":{type:"number",default:1,minimum:0,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"heatmap-color":{type:"color",default:["interpolate",["linear"],["heatmap-density"],0,"rgba(0, 0, 255, 0)",.1,"royalblue",.3,"cyan",.5,"lime",.7,"yellow",1,"red"],transition:!1,expression:{interpolated:!0,parameters:["heatmap-density"]},"property-type":"color-ramp"},"heatmap-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"}},paint_symbol:{"icon-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"icon-color":{type:"color",default:"#000000",transition:!0,requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"icon-halo-color":{type:"color",default:"rgba(0, 0, 0, 0)",transition:!0,requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"icon-halo-width":{type:"number",default:0,minimum:0,transition:!0,units:"pixels",requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"icon-halo-blur":{type:"number",default:0,minimum:0,transition:!0,units:"pixels",requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"icon-translate":{type:"array",value:"number",length:2,default:[0,0],transition:!0,units:"pixels",requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"icon-translate-anchor":{type:"enum",values:{map:{},viewport:{}},default:"map",requires:["icon-image","icon-translate"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"text-color":{type:"color",default:"#000000",transition:!0,overridable:!0,requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"text-halo-color":{type:"color",default:"rgba(0, 0, 0, 0)",transition:!0,requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"text-halo-width":{type:"number",default:0,minimum:0,transition:!0,units:"pixels",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"text-halo-blur":{type:"number",default:0,minimum:0,transition:!0,units:"pixels",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"text-translate":{type:"array",value:"number",length:2,default:[0,0],transition:!0,units:"pixels",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"text-translate-anchor":{type:"enum",values:{map:{},viewport:{}},default:"map",requires:["text-field","text-translate"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"}},paint_raster:{"raster-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"raster-hue-rotate":{type:"number",default:0,period:360,transition:!0,units:"degrees",expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"raster-brightness-min":{type:"number",default:0,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"raster-brightness-max":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"raster-saturation":{type:"number",default:0,minimum:-1,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"raster-contrast":{type:"number",default:0,minimum:-1,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"raster-resampling":{type:"enum",values:{linear:{},nearest:{}},default:"linear",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"raster-fade-duration":{type:"number",default:300,minimum:0,transition:!1,units:"milliseconds",expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"}},paint_hillshade:{"hillshade-illumination-direction":{type:"number",default:335,minimum:0,maximum:359,transition:!1,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"hillshade-illumination-anchor":{type:"enum",values:{map:{},viewport:{}},default:"viewport",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"hillshade-exaggeration":{type:"number",default:.5,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"hillshade-shadow-color":{type:"color",default:"#000000",transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"hillshade-highlight-color":{type:"color",default:"#FFFFFF",transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"hillshade-accent-color":{type:"color",default:"#000000",transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"}},paint_background:{"background-color":{type:"color",default:"#000000",transition:!0,requires:[{"!":"background-pattern"}],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"background-pattern":{type:"resolvedImage",transition:!0,expression:{interpolated:!1,parameters:["zoom"]},"property-type":"cross-faded"},"background-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"}},transition:{duration:{type:"number",default:300,minimum:0,units:"milliseconds"},delay:{type:"number",default:0,minimum:0,units:"milliseconds"}},"property-type":{"data-driven":{type:"property-type"},"cross-faded":{type:"property-type"},"cross-faded-data-driven":{type:"property-type"},"color-ramp":{type:"property-type"},"data-constant":{type:"property-type"},constant:{type:"property-type"}},promoteId:{"*":{type:"string"}}};const K=["type","source","source-layer","minzoom","maxzoom","filter","layout"];function X(t,e){const r={};for(const e in t)"ref"!==e&&(r[e]=t[e]);return K.forEach((t=>{t in e&&(r[t]=e[t]);})),r}function H(t,e){if(Array.isArray(t)){if(!Array.isArray(e)||t.length!==e.length)return !1;for(let r=0;r<t.length;r++)if(!H(t[r],e[r]))return !1;return !0}if("object"==typeof t&&null!==t&&null!==e){if("object"!=typeof e)return !1;if(Object.keys(t).length!==Object.keys(e).length)return !1;for(const r in t)if(!H(t[r],e[r]))return !1;return !0}return t===e}function Y(t,e){t.push(e);}function J(t,e,r){Y(r,{command:"addSource",args:[t,e[t]]});}function W(t,e,r){Y(e,{command:"removeSource",args:[t]}),r[t]=!0;}function Q(t,e,r,n){W(t,r,n),J(t,e,r);}function tt(t,e,r){let n;for(n in t[r])if(Object.prototype.hasOwnProperty.call(t[r],n)&&"data"!==n&&!H(t[r][n],e[r][n]))return !1;for(n in e[r])if(Object.prototype.hasOwnProperty.call(e[r],n)&&"data"!==n&&!H(t[r][n],e[r][n]))return !1;return !0}function et(t,e,r,n,i,s){t=t||{},e=e||{};for(const a in t)Object.prototype.hasOwnProperty.call(t,a)&&(H(t[a],e[a])||r.push({command:s,args:[n,a,e[a],i]}));for(const a in e)Object.prototype.hasOwnProperty.call(e,a)&&!Object.prototype.hasOwnProperty.call(t,a)&&(H(t[a],e[a])||r.push({command:s,args:[n,a,e[a],i]}));}function rt(t){return t.id}function nt(t,e){return t[e.id]=e,t}class it{constructor(t,e,r,n){this.message=(t?`${t}: `:"")+r,n&&(this.identifier=n),null!=e&&e.__line__&&(this.line=e.__line__);}}function st(t,...e){for(const r of e)for(const e in r)t[e]=r[e];return t}class at extends Error{constructor(t,e){super(e),this.message=e,this.key=t;}}class ot{constructor(t,e=[]){this.parent=t,this.bindings={};for(const[t,r]of e)this.bindings[t]=r;}concat(t){return new ot(this,t)}get(t){if(this.bindings[t])return this.bindings[t];if(this.parent)return this.parent.get(t);throw new Error(`${t} not found in scope.`)}has(t){return !!this.bindings[t]||!!this.parent&&this.parent.has(t)}}const lt={kind:"null"},ut={kind:"number"},ct={kind:"string"},ht={kind:"boolean"},pt={kind:"color"},ft={kind:"object"},dt={kind:"value"},yt={kind:"collator"},mt={kind:"formatted"},gt={kind:"padding"},xt={kind:"resolvedImage"},vt={kind:"variableAnchorOffsetCollection"};function bt(t,e){return {kind:"array",itemType:t,N:e}}function wt(t){if("array"===t.kind){const e=wt(t.itemType);return "number"==typeof t.N?`array<${e}, ${t.N}>`:"value"===t.itemType.kind?"array":`array<${e}>`}return t.kind}const _t=[lt,ut,ct,ht,pt,mt,ft,bt(dt),gt,xt,vt];function At(t,e){if("error"===e.kind)return null;if("array"===t.kind){if("array"===e.kind&&(0===e.N&&"value"===e.itemType.kind||!At(t.itemType,e.itemType))&&("number"!=typeof t.N||t.N===e.N))return null}else {if(t.kind===e.kind)return null;if("value"===t.kind)for(const t of _t)if(!At(t,e))return null}return `Expected ${wt(t)} but found ${wt(e)} instead.`}function St(t,e){return e.some((e=>e.kind===t.kind))}function kt(t,e){return e.some((e=>"null"===e?null===t:"array"===e?Array.isArray(t):"object"===e?t&&!Array.isArray(t)&&"object"==typeof t:e===typeof t))}function Mt(t,e){return "array"===t.kind&&"array"===e.kind?t.itemType.kind===e.itemType.kind&&"number"==typeof t.N:t.kind===e.kind}const It=.96422,zt=.82521,Pt=4/29,Ct=6/29,Bt=3*Ct*Ct,Vt=Ct*Ct*Ct,Et=Math.PI/180,Ft=180/Math.PI;function Tt(t){return (t%=360)<0&&(t+=360),t}function $t([t,e,r,n]){let i,s;const a=Dt((.2225045*(t=Lt(t))+.7168786*(e=Lt(e))+.0606169*(r=Lt(r)))/1);t===e&&e===r?i=s=a:(i=Dt((.4360747*t+.3850649*e+.1430804*r)/It),s=Dt((.0139322*t+.0971045*e+.7141733*r)/zt));const o=116*a-16;return [o<0?0:o,500*(i-a),200*(a-s),n]}function Lt(t){return t<=.04045?t/12.92:Math.pow((t+.055)/1.055,2.4)}function Dt(t){return t>Vt?Math.pow(t,1/3):t/Bt+Pt}function Ot([t,e,r,n]){let i=(t+16)/116,s=isNaN(e)?i:i+e/500,a=isNaN(r)?i:i-r/200;return i=1*Rt(i),s=It*Rt(s),a=zt*Rt(a),[jt(3.1338561*s-1.6168667*i-.4906146*a),jt(-.9787684*s+1.9161415*i+.033454*a),jt(.0719453*s-.2289914*i+1.4052427*a),n]}function jt(t){return (t=t<=.00304?12.92*t:1.055*Math.pow(t,1/2.4)-.055)<0?0:t>1?1:t}function Rt(t){return t>Ct?t*t*t:Bt*(t-Pt)}function Ut(t){return parseInt(t.padEnd(2,t),16)/255}function qt(t,e){return Nt(e?t/100:t,0,1)}function Nt(t,e,r){return Math.min(Math.max(e,t),r)}function Zt(t){return !t.some(Number.isNaN)}const Gt={aliceblue:[240,248,255],antiquewhite:[250,235,215],aqua:[0,255,255],aquamarine:[127,255,212],azure:[240,255,255],beige:[245,245,220],bisque:[255,228,196],black:[0,0,0],blanchedalmond:[255,235,205],blue:[0,0,255],blueviolet:[138,43,226],brown:[165,42,42],burlywood:[222,184,135],cadetblue:[95,158,160],chartreuse:[127,255,0],chocolate:[210,105,30],coral:[255,127,80],cornflowerblue:[100,149,237],cornsilk:[255,248,220],crimson:[220,20,60],cyan:[0,255,255],darkblue:[0,0,139],darkcyan:[0,139,139],darkgoldenrod:[184,134,11],darkgray:[169,169,169],darkgreen:[0,100,0],darkgrey:[169,169,169],darkkhaki:[189,183,107],darkmagenta:[139,0,139],darkolivegreen:[85,107,47],darkorange:[255,140,0],darkorchid:[153,50,204],darkred:[139,0,0],darksalmon:[233,150,122],darkseagreen:[143,188,143],darkslateblue:[72,61,139],darkslategray:[47,79,79],darkslategrey:[47,79,79],darkturquoise:[0,206,209],darkviolet:[148,0,211],deeppink:[255,20,147],deepskyblue:[0,191,255],dimgray:[105,105,105],dimgrey:[105,105,105],dodgerblue:[30,144,255],firebrick:[178,34,34],floralwhite:[255,250,240],forestgreen:[34,139,34],fuchsia:[255,0,255],gainsboro:[220,220,220],ghostwhite:[248,248,255],gold:[255,215,0],goldenrod:[218,165,32],gray:[128,128,128],green:[0,128,0],greenyellow:[173,255,47],grey:[128,128,128],honeydew:[240,255,240],hotpink:[255,105,180],indianred:[205,92,92],indigo:[75,0,130],ivory:[255,255,240],khaki:[240,230,140],lavender:[230,230,250],lavenderblush:[255,240,245],lawngreen:[124,252,0],lemonchiffon:[255,250,205],lightblue:[173,216,230],lightcoral:[240,128,128],lightcyan:[224,255,255],lightgoldenrodyellow:[250,250,210],lightgray:[211,211,211],lightgreen:[144,238,144],lightgrey:[211,211,211],lightpink:[255,182,193],lightsalmon:[255,160,122],lightseagreen:[32,178,170],lightskyblue:[135,206,250],lightslategray:[119,136,153],lightslategrey:[119,136,153],lightsteelblue:[176,196,222],lightyellow:[255,255,224],lime:[0,255,0],limegreen:[50,205,50],linen:[250,240,230],magenta:[255,0,255],maroon:[128,0,0],mediumaquamarine:[102,205,170],mediumblue:[0,0,205],mediumorchid:[186,85,211],mediumpurple:[147,112,219],mediumseagreen:[60,179,113],mediumslateblue:[123,104,238],mediumspringgreen:[0,250,154],mediumturquoise:[72,209,204],mediumvioletred:[199,21,133],midnightblue:[25,25,112],mintcream:[245,255,250],mistyrose:[255,228,225],moccasin:[255,228,181],navajowhite:[255,222,173],navy:[0,0,128],oldlace:[253,245,230],olive:[128,128,0],olivedrab:[107,142,35],orange:[255,165,0],orangered:[255,69,0],orchid:[218,112,214],palegoldenrod:[238,232,170],palegreen:[152,251,152],paleturquoise:[175,238,238],palevioletred:[219,112,147],papayawhip:[255,239,213],peachpuff:[255,218,185],peru:[205,133,63],pink:[255,192,203],plum:[221,160,221],powderblue:[176,224,230],purple:[128,0,128],rebeccapurple:[102,51,153],red:[255,0,0],rosybrown:[188,143,143],royalblue:[65,105,225],saddlebrown:[139,69,19],salmon:[250,128,114],sandybrown:[244,164,96],seagreen:[46,139,87],seashell:[255,245,238],sienna:[160,82,45],silver:[192,192,192],skyblue:[135,206,235],slateblue:[106,90,205],slategray:[112,128,144],slategrey:[112,128,144],snow:[255,250,250],springgreen:[0,255,127],steelblue:[70,130,180],tan:[210,180,140],teal:[0,128,128],thistle:[216,191,216],tomato:[255,99,71],turquoise:[64,224,208],violet:[238,130,238],wheat:[245,222,179],white:[255,255,255],whitesmoke:[245,245,245],yellow:[255,255,0],yellowgreen:[154,205,50]};class Kt{constructor(t,e,r,n=1,i=!0){this.r=t,this.g=e,this.b=r,this.a=n,i||(this.r*=n,this.g*=n,this.b*=n,n||this.overwriteGetter("rgb",[t,e,r,n]));}static parse(t){if(t instanceof Kt)return t;if("string"!=typeof t)return;const e=function(t){if("transparent"===(t=t.toLowerCase().trim()))return [0,0,0,0];const e=Gt[t];if(e){const[t,r,n]=e;return [t/255,r/255,n/255,1]}if(t.startsWith("#")&&/^#(?:[0-9a-f]{3,4}|[0-9a-f]{6}|[0-9a-f]{8})$/.test(t)){const e=t.length<6?1:2;let r=1;return [Ut(t.slice(r,r+=e)),Ut(t.slice(r,r+=e)),Ut(t.slice(r,r+=e)),Ut(t.slice(r,r+e)||"ff")]}if(t.startsWith("rgb")){const e=t.match(/^rgba?\(\s*([\de.+-]+)(%)?(?:\s+|\s*(,)\s*)([\de.+-]+)(%)?(?:\s+|\s*(,)\s*)([\de.+-]+)(%)?(?:\s*([,\/])\s*([\de.+-]+)(%)?)?\s*\)$/);if(e){const[t,r,n,i,s,a,o,l,u,c,h,p]=e,f=[i||" ",o||" ",c].join("");if("  "===f||"  /"===f||",,"===f||",,,"===f){const t=[n,a,u].join(""),e="%%%"===t?100:""===t?255:0;if(e){const t=[Nt(+r/e,0,1),Nt(+s/e,0,1),Nt(+l/e,0,1),h?qt(+h,p):1];if(Zt(t))return t}}return}}const r=t.match(/^hsla?\(\s*([\de.+-]+)(?:deg)?(?:\s+|\s*(,)\s*)([\de.+-]+)%(?:\s+|\s*(,)\s*)([\de.+-]+)%(?:\s*([,\/])\s*([\de.+-]+)(%)?)?\s*\)$/);if(r){const[t,e,n,i,s,a,o,l,u]=r,c=[n||" ",s||" ",o].join("");if("  "===c||"  /"===c||",,"===c||",,,"===c){const t=[+e,Nt(+i,0,100),Nt(+a,0,100),l?qt(+l,u):1];if(Zt(t))return function([t,e,r,n]){function i(n){const i=(n+t/30)%12,s=e*Math.min(r,1-r);return r-s*Math.max(-1,Math.min(i-3,9-i,1))}return t=Tt(t),e/=100,r/=100,[i(0),i(8),i(4),n]}(t)}}}(t);return e?new Kt(...e,!1):void 0}get rgb(){const{r:t,g:e,b:r,a:n}=this,i=n||1/0;return this.overwriteGetter("rgb",[t/i,e/i,r/i,n])}get hcl(){return this.overwriteGetter("hcl",function(t){const[e,r,n,i]=$t(t),s=Math.sqrt(r*r+n*n);return [Math.round(1e4*s)?Tt(Math.atan2(n,r)*Ft):NaN,s,e,i]}(this.rgb))}get lab(){return this.overwriteGetter("lab",$t(this.rgb))}overwriteGetter(t,e){return Object.defineProperty(this,t,{value:e}),e}toString(){const[t,e,r,n]=this.rgb;return `rgba(${[t,e,r].map((t=>Math.round(255*t))).join(",")},${n})`}}Kt.black=new Kt(0,0,0,1),Kt.white=new Kt(1,1,1,1),Kt.transparent=new Kt(0,0,0,0),Kt.red=new Kt(1,0,0,1);class Xt{constructor(t,e,r){this.sensitivity=t?e?"variant":"case":e?"accent":"base",this.locale=r,this.collator=new Intl.Collator(this.locale?this.locale:[],{sensitivity:this.sensitivity,usage:"search"});}compare(t,e){return this.collator.compare(t,e)}resolvedLocale(){return new Intl.Collator(this.locale?this.locale:[]).resolvedOptions().locale}}class Ht{constructor(t,e,r,n,i){this.text=t,this.image=e,this.scale=r,this.fontStack=n,this.textColor=i;}}class Yt{constructor(t){this.sections=t;}static fromString(t){return new Yt([new Ht(t,null,null,null,null)])}isEmpty(){return 0===this.sections.length||!this.sections.some((t=>0!==t.text.length||t.image&&0!==t.image.name.length))}static factory(t){return t instanceof Yt?t:Yt.fromString(t)}toString(){return 0===this.sections.length?"":this.sections.map((t=>t.text)).join("")}}class Jt{constructor(t){this.values=t.slice();}static parse(t){if(t instanceof Jt)return t;if("number"==typeof t)return new Jt([t,t,t,t]);if(Array.isArray(t)&&!(t.length<1||t.length>4)){for(const e of t)if("number"!=typeof e)return;switch(t.length){case 1:t=[t[0],t[0],t[0],t[0]];break;case 2:t=[t[0],t[1],t[0],t[1]];break;case 3:t=[t[0],t[1],t[2],t[1]];}return new Jt(t)}}toString(){return JSON.stringify(this.values)}}const Wt=new Set(["center","left","right","top","bottom","top-left","top-right","bottom-left","bottom-right"]);class Qt{constructor(t){this.values=t.slice();}static parse(t){if(t instanceof Qt)return t;if(Array.isArray(t)&&!(t.length<1)&&t.length%2==0){for(let e=0;e<t.length;e+=2){const r=t[e],n=t[e+1];if("string"!=typeof r||!Wt.has(r))return;if(!Array.isArray(n)||2!==n.length||"number"!=typeof n[0]||"number"!=typeof n[1])return}return new Qt(t)}}toString(){return JSON.stringify(this.values)}}class te{constructor(t){this.name=t.name,this.available=t.available;}toString(){return this.name}static fromString(t){return t?new te({name:t,available:!1}):null}}function ee(t,e,r,n){return "number"==typeof t&&t>=0&&t<=255&&"number"==typeof e&&e>=0&&e<=255&&"number"==typeof r&&r>=0&&r<=255?void 0===n||"number"==typeof n&&n>=0&&n<=1?null:`Invalid rgba value [${[t,e,r,n].join(", ")}]: 'a' must be between 0 and 1.`:`Invalid rgba value [${("number"==typeof n?[t,e,r,n]:[t,e,r]).join(", ")}]: 'r', 'g', and 'b' must be between 0 and 255.`}function re(t){if(null===t||"string"==typeof t||"boolean"==typeof t||"number"==typeof t||t instanceof Kt||t instanceof Xt||t instanceof Yt||t instanceof Jt||t instanceof Qt||t instanceof te)return !0;if(Array.isArray(t)){for(const e of t)if(!re(e))return !1;return !0}if("object"==typeof t){for(const e in t)if(!re(t[e]))return !1;return !0}return !1}function ne(t){if(null===t)return lt;if("string"==typeof t)return ct;if("boolean"==typeof t)return ht;if("number"==typeof t)return ut;if(t instanceof Kt)return pt;if(t instanceof Xt)return yt;if(t instanceof Yt)return mt;if(t instanceof Jt)return gt;if(t instanceof Qt)return vt;if(t instanceof te)return xt;if(Array.isArray(t)){const e=t.length;let r;for(const e of t){const t=ne(e);if(r){if(r===t)continue;r=dt;break}r=t;}return bt(r||dt,e)}return ft}function ie(t){const e=typeof t;return null===t?"":"string"===e||"number"===e||"boolean"===e?String(t):t instanceof Kt||t instanceof Yt||t instanceof Jt||t instanceof Qt||t instanceof te?t.toString():JSON.stringify(t)}class se{constructor(t,e){this.type=t,this.value=e;}static parse(t,e){if(2!==t.length)return e.error(`'literal' expression requires exactly one argument, but found ${t.length-1} instead.`);if(!re(t[1]))return e.error("invalid value");const r=t[1];let n=ne(r);const i=e.expectedType;return "array"!==n.kind||0!==n.N||!i||"array"!==i.kind||"number"==typeof i.N&&0!==i.N||(n=i),new se(n,r)}evaluate(){return this.value}eachChild(){}outputDefined(){return !0}}class ae{constructor(t){this.name="ExpressionEvaluationError",this.message=t;}toJSON(){return this.message}}const oe={string:ct,number:ut,boolean:ht,object:ft};class le{constructor(t,e){this.type=t,this.args=e;}static parse(t,e){if(t.length<2)return e.error("Expected at least one argument.");let r,n=1;const i=t[0];if("array"===i){let i,s;if(t.length>2){const r=t[1];if("string"!=typeof r||!(r in oe)||"object"===r)return e.error('The item type argument of "array" must be one of string, number, boolean',1);i=oe[r],n++;}else i=dt;if(t.length>3){if(null!==t[2]&&("number"!=typeof t[2]||t[2]<0||t[2]!==Math.floor(t[2])))return e.error('The length argument to "array" must be a positive integer literal',2);s=t[2],n++;}r=bt(i,s);}else {if(!oe[i])throw new Error(`Types doesn't contain name = ${i}`);r=oe[i];}const s=[];for(;n<t.length;n++){const r=e.parse(t[n],n,dt);if(!r)return null;s.push(r);}return new le(r,s)}evaluate(t){for(let e=0;e<this.args.length;e++){const r=this.args[e].evaluate(t);if(!At(this.type,ne(r)))return r;if(e===this.args.length-1)throw new ae(`Expected value to be of type ${wt(this.type)}, but found ${wt(ne(r))} instead.`)}throw new Error}eachChild(t){this.args.forEach(t);}outputDefined(){return this.args.every((t=>t.outputDefined()))}}const ue={"to-boolean":ht,"to-color":pt,"to-number":ut,"to-string":ct};class ce{constructor(t,e){this.type=t,this.args=e;}static parse(t,e){if(t.length<2)return e.error("Expected at least one argument.");const r=t[0];if(!ue[r])throw new Error(`Can't parse ${r} as it is not part of the known types`);if(("to-boolean"===r||"to-string"===r)&&2!==t.length)return e.error("Expected one argument.");const n=ue[r],i=[];for(let r=1;r<t.length;r++){const n=e.parse(t[r],r,dt);if(!n)return null;i.push(n);}return new ce(n,i)}evaluate(t){switch(this.type.kind){case"boolean":return Boolean(this.args[0].evaluate(t));case"color":{let e,r;for(const n of this.args){if(e=n.evaluate(t),r=null,e instanceof Kt)return e;if("string"==typeof e){const r=t.parseColor(e);if(r)return r}else if(Array.isArray(e)&&(r=e.length<3||e.length>4?`Invalid rbga value ${JSON.stringify(e)}: expected an array containing either three or four numeric values.`:ee(e[0],e[1],e[2],e[3]),!r))return new Kt(e[0]/255,e[1]/255,e[2]/255,e[3])}throw new ae(r||`Could not parse color from value '${"string"==typeof e?e:JSON.stringify(e)}'`)}case"padding":{let e;for(const r of this.args){e=r.evaluate(t);const n=Jt.parse(e);if(n)return n}throw new ae(`Could not parse padding from value '${"string"==typeof e?e:JSON.stringify(e)}'`)}case"variableAnchorOffsetCollection":{let e;for(const r of this.args){e=r.evaluate(t);const n=Qt.parse(e);if(n)return n}throw new ae(`Could not parse variableAnchorOffsetCollection from value '${"string"==typeof e?e:JSON.stringify(e)}'`)}case"number":{let e=null;for(const r of this.args){if(e=r.evaluate(t),null===e)return 0;const n=Number(e);if(!isNaN(n))return n}throw new ae(`Could not convert ${JSON.stringify(e)} to number.`)}case"formatted":return Yt.fromString(ie(this.args[0].evaluate(t)));case"resolvedImage":return te.fromString(ie(this.args[0].evaluate(t)));default:return ie(this.args[0].evaluate(t))}}eachChild(t){this.args.forEach(t);}outputDefined(){return this.args.every((t=>t.outputDefined()))}}const he=["Unknown","Point","LineString","Polygon"];class pe{constructor(){this.globals=null,this.feature=null,this.featureState=null,this.formattedSection=null,this._parseColorCache={},this.availableImages=null,this.canonical=null;}id(){return this.feature&&"id"in this.feature?this.feature.id:null}geometryType(){return this.feature?"number"==typeof this.feature.type?he[this.feature.type]:this.feature.type:null}geometry(){return this.feature&&"geometry"in this.feature?this.feature.geometry:null}canonicalID(){return this.canonical}properties(){return this.feature&&this.feature.properties||{}}parseColor(t){let e=this._parseColorCache[t];return e||(e=this._parseColorCache[t]=Kt.parse(t)),e}}class fe{constructor(t,e,r=[],n,i=new ot,s=[]){this.registry=t,this.path=r,this.key=r.map((t=>`[${t}]`)).join(""),this.scope=i,this.errors=s,this.expectedType=n,this._isConstant=e;}parse(t,e,r,n,i={}){return e?this.concat(e,r,n)._parse(t,i):this._parse(t,i)}_parse(t,e){function r(t,e,r){return "assert"===r?new le(e,[t]):"coerce"===r?new ce(e,[t]):t}if(null!==t&&"string"!=typeof t&&"boolean"!=typeof t&&"number"!=typeof t||(t=["literal",t]),Array.isArray(t)){if(0===t.length)return this.error('Expected an array with at least one element. If you wanted a literal array, use ["literal", []].');const n=t[0];if("string"!=typeof n)return this.error(`Expression name must be a string, but found ${typeof n} instead. If you wanted a literal array, use ["literal", [...]].`,0),null;const i=this.registry[n];if(i){let n=i.parse(t,this);if(!n)return null;if(this.expectedType){const t=this.expectedType,i=n.type;if("string"!==t.kind&&"number"!==t.kind&&"boolean"!==t.kind&&"object"!==t.kind&&"array"!==t.kind||"value"!==i.kind)if("color"!==t.kind&&"formatted"!==t.kind&&"resolvedImage"!==t.kind||"value"!==i.kind&&"string"!==i.kind)if("padding"!==t.kind||"value"!==i.kind&&"number"!==i.kind&&"array"!==i.kind)if("variableAnchorOffsetCollection"!==t.kind||"value"!==i.kind&&"array"!==i.kind){if(this.checkSubtype(t,i))return null}else n=r(n,t,e.typeAnnotation||"coerce");else n=r(n,t,e.typeAnnotation||"coerce");else n=r(n,t,e.typeAnnotation||"coerce");else n=r(n,t,e.typeAnnotation||"assert");}if(!(n instanceof se)&&"resolvedImage"!==n.type.kind&&this._isConstant(n)){const t=new pe;try{n=new se(n.type,n.evaluate(t));}catch(t){return this.error(t.message),null}}return n}return this.error(`Unknown expression "${n}". If you wanted a literal array, use ["literal", [...]].`,0)}return this.error(void 0===t?"'undefined' value invalid. Use null instead.":"object"==typeof t?'Bare objects invalid. Use ["literal", {...}] instead.':`Expected an array, but found ${typeof t} instead.`)}concat(t,e,r){const n="number"==typeof t?this.path.concat(t):this.path,i=r?this.scope.concat(r):this.scope;return new fe(this.registry,this._isConstant,n,e||null,i,this.errors)}error(t,...e){const r=`${this.key}${e.map((t=>`[${t}]`)).join("")}`;this.errors.push(new at(r,t));}checkSubtype(t,e){const r=At(t,e);return r&&this.error(r),r}}class de{constructor(t,e){this.type=e.type,this.bindings=[].concat(t),this.result=e;}evaluate(t){return this.result.evaluate(t)}eachChild(t){for(const e of this.bindings)t(e[1]);t(this.result);}static parse(t,e){if(t.length<4)return e.error(`Expected at least 3 arguments, but found ${t.length-1} instead.`);const r=[];for(let n=1;n<t.length-1;n+=2){const i=t[n];if("string"!=typeof i)return e.error(`Expected string, but found ${typeof i} instead.`,n);if(/[^a-zA-Z0-9_]/.test(i))return e.error("Variable names must contain only alphanumeric characters or '_'.",n);const s=e.parse(t[n+1],n+1);if(!s)return null;r.push([i,s]);}const n=e.parse(t[t.length-1],t.length-1,e.expectedType,r);return n?new de(r,n):null}outputDefined(){return this.result.outputDefined()}}class ye{constructor(t,e){this.type=e.type,this.name=t,this.boundExpression=e;}static parse(t,e){if(2!==t.length||"string"!=typeof t[1])return e.error("'var' expression requires exactly one string literal argument.");const r=t[1];return e.scope.has(r)?new ye(r,e.scope.get(r)):e.error(`Unknown variable "${r}". Make sure "${r}" has been bound in an enclosing "let" expression before using it.`,1)}evaluate(t){return this.boundExpression.evaluate(t)}eachChild(){}outputDefined(){return !1}}class me{constructor(t,e,r){this.type=t,this.index=e,this.input=r;}static parse(t,e){if(3!==t.length)return e.error(`Expected 2 arguments, but found ${t.length-1} instead.`);const r=e.parse(t[1],1,ut),n=e.parse(t[2],2,bt(e.expectedType||dt));return r&&n?new me(n.type.itemType,r,n):null}evaluate(t){const e=this.index.evaluate(t),r=this.input.evaluate(t);if(e<0)throw new ae(`Array index out of bounds: ${e} < 0.`);if(e>=r.length)throw new ae(`Array index out of bounds: ${e} > ${r.length-1}.`);if(e!==Math.floor(e))throw new ae(`Array index must be an integer, but found ${e} instead.`);return r[e]}eachChild(t){t(this.index),t(this.input);}outputDefined(){return !1}}class ge{constructor(t,e){this.type=ht,this.needle=t,this.haystack=e;}static parse(t,e){if(3!==t.length)return e.error(`Expected 2 arguments, but found ${t.length-1} instead.`);const r=e.parse(t[1],1,dt),n=e.parse(t[2],2,dt);return r&&n?St(r.type,[ht,ct,ut,lt,dt])?new ge(r,n):e.error(`Expected first argument to be of type boolean, string, number or null, but found ${wt(r.type)} instead`):null}evaluate(t){const e=this.needle.evaluate(t),r=this.haystack.evaluate(t);if(!r)return !1;if(!kt(e,["boolean","string","number","null"]))throw new ae(`Expected first argument to be of type boolean, string, number or null, but found ${wt(ne(e))} instead.`);if(!kt(r,["string","array"]))throw new ae(`Expected second argument to be of type array or string, but found ${wt(ne(r))} instead.`);return r.indexOf(e)>=0}eachChild(t){t(this.needle),t(this.haystack);}outputDefined(){return !0}}class xe{constructor(t,e,r){this.type=ut,this.needle=t,this.haystack=e,this.fromIndex=r;}static parse(t,e){if(t.length<=2||t.length>=5)return e.error(`Expected 3 or 4 arguments, but found ${t.length-1} instead.`);const r=e.parse(t[1],1,dt),n=e.parse(t[2],2,dt);if(!r||!n)return null;if(!St(r.type,[ht,ct,ut,lt,dt]))return e.error(`Expected first argument to be of type boolean, string, number or null, but found ${wt(r.type)} instead`);if(4===t.length){const i=e.parse(t[3],3,ut);return i?new xe(r,n,i):null}return new xe(r,n)}evaluate(t){const e=this.needle.evaluate(t),r=this.haystack.evaluate(t);if(!kt(e,["boolean","string","number","null"]))throw new ae(`Expected first argument to be of type boolean, string, number or null, but found ${wt(ne(e))} instead.`);let n;if(this.fromIndex&&(n=this.fromIndex.evaluate(t)),kt(r,["string"])){const t=r.indexOf(e,n);return -1===t?-1:[...r.slice(0,t)].length}if(kt(r,["array"]))return r.indexOf(e,n);throw new ae(`Expected second argument to be of type array or string, but found ${wt(ne(r))} instead.`)}eachChild(t){t(this.needle),t(this.haystack),this.fromIndex&&t(this.fromIndex);}outputDefined(){return !1}}class ve{constructor(t,e,r,n,i,s){this.inputType=t,this.type=e,this.input=r,this.cases=n,this.outputs=i,this.otherwise=s;}static parse(t,e){if(t.length<5)return e.error(`Expected at least 4 arguments, but found only ${t.length-1}.`);if(t.length%2!=1)return e.error("Expected an even number of arguments.");let r,n;e.expectedType&&"value"!==e.expectedType.kind&&(n=e.expectedType);const i={},s=[];for(let a=2;a<t.length-1;a+=2){let o=t[a];const l=t[a+1];Array.isArray(o)||(o=[o]);const u=e.concat(a);if(0===o.length)return u.error("Expected at least one branch label.");for(const t of o){if("number"!=typeof t&&"string"!=typeof t)return u.error("Branch labels must be numbers or strings.");if("number"==typeof t&&Math.abs(t)>Number.MAX_SAFE_INTEGER)return u.error(`Branch labels must be integers no larger than ${Number.MAX_SAFE_INTEGER}.`);if("number"==typeof t&&Math.floor(t)!==t)return u.error("Numeric branch labels must be integer values.");if(r){if(u.checkSubtype(r,ne(t)))return null}else r=ne(t);if(void 0!==i[String(t)])return u.error("Branch labels must be unique.");i[String(t)]=s.length;}const c=e.parse(l,a,n);if(!c)return null;n=n||c.type,s.push(c);}const a=e.parse(t[1],1,dt);if(!a)return null;const o=e.parse(t[t.length-1],t.length-1,n);return o?"value"!==a.type.kind&&e.concat(1).checkSubtype(r,a.type)?null:new ve(r,n,a,i,s,o):null}evaluate(t){const e=this.input.evaluate(t);return (ne(e)===this.inputType&&this.outputs[this.cases[e]]||this.otherwise).evaluate(t)}eachChild(t){t(this.input),this.outputs.forEach(t),t(this.otherwise);}outputDefined(){return this.outputs.every((t=>t.outputDefined()))&&this.otherwise.outputDefined()}}class be{constructor(t,e,r){this.type=t,this.branches=e,this.otherwise=r;}static parse(t,e){if(t.length<4)return e.error(`Expected at least 3 arguments, but found only ${t.length-1}.`);if(t.length%2!=0)return e.error("Expected an odd number of arguments.");let r;e.expectedType&&"value"!==e.expectedType.kind&&(r=e.expectedType);const n=[];for(let i=1;i<t.length-1;i+=2){const s=e.parse(t[i],i,ht);if(!s)return null;const a=e.parse(t[i+1],i+1,r);if(!a)return null;n.push([s,a]),r=r||a.type;}const i=e.parse(t[t.length-1],t.length-1,r);if(!i)return null;if(!r)throw new Error("Can't infer output type");return new be(r,n,i)}evaluate(t){for(const[e,r]of this.branches)if(e.evaluate(t))return r.evaluate(t);return this.otherwise.evaluate(t)}eachChild(t){for(const[e,r]of this.branches)t(e),t(r);t(this.otherwise);}outputDefined(){return this.branches.every((([t,e])=>e.outputDefined()))&&this.otherwise.outputDefined()}}class we{constructor(t,e,r,n){this.type=t,this.input=e,this.beginIndex=r,this.endIndex=n;}static parse(t,e){if(t.length<=2||t.length>=5)return e.error(`Expected 3 or 4 arguments, but found ${t.length-1} instead.`);const r=e.parse(t[1],1,dt),n=e.parse(t[2],2,ut);if(!r||!n)return null;if(!St(r.type,[bt(dt),ct,dt]))return e.error(`Expected first argument to be of type array or string, but found ${wt(r.type)} instead`);if(4===t.length){const i=e.parse(t[3],3,ut);return i?new we(r.type,r,n,i):null}return new we(r.type,r,n)}evaluate(t){const e=this.input.evaluate(t),r=this.beginIndex.evaluate(t);let n;if(this.endIndex&&(n=this.endIndex.evaluate(t)),kt(e,["string"]))return [...e].slice(r,n).join("");if(kt(e,["array"]))return e.slice(r,n);throw new ae(`Expected first argument to be of type array or string, but found ${wt(ne(e))} instead.`)}eachChild(t){t(this.input),t(this.beginIndex),this.endIndex&&t(this.endIndex);}outputDefined(){return !1}}function _e(t,e){const r=t.length-1;let n,i,s=0,a=r,o=0;for(;s<=a;)if(o=Math.floor((s+a)/2),n=t[o],i=t[o+1],n<=e){if(o===r||e<i)return o;s=o+1;}else {if(!(n>e))throw new ae("Input is not a number.");a=o-1;}return 0}class Ae{constructor(t,e,r){this.type=t,this.input=e,this.labels=[],this.outputs=[];for(const[t,e]of r)this.labels.push(t),this.outputs.push(e);}static parse(t,e){if(t.length-1<4)return e.error(`Expected at least 4 arguments, but found only ${t.length-1}.`);if((t.length-1)%2!=0)return e.error("Expected an even number of arguments.");const r=e.parse(t[1],1,ut);if(!r)return null;const n=[];let i=null;e.expectedType&&"value"!==e.expectedType.kind&&(i=e.expectedType);for(let r=1;r<t.length;r+=2){const s=1===r?-1/0:t[r],a=t[r+1],o=r,l=r+1;if("number"!=typeof s)return e.error('Input/output pairs for "step" expressions must be defined using literal numeric values (not computed expressions) for the input values.',o);if(n.length&&n[n.length-1][0]>=s)return e.error('Input/output pairs for "step" expressions must be arranged with input values in strictly ascending order.',o);const u=e.parse(a,l,i);if(!u)return null;i=i||u.type,n.push([s,u]);}return new Ae(i,r,n)}evaluate(t){const e=this.labels,r=this.outputs;if(1===e.length)return r[0].evaluate(t);const n=this.input.evaluate(t);if(n<=e[0])return r[0].evaluate(t);const i=e.length;return n>=e[i-1]?r[i-1].evaluate(t):r[_e(e,n)].evaluate(t)}eachChild(t){t(this.input);for(const e of this.outputs)t(e);}outputDefined(){return this.outputs.every((t=>t.outputDefined()))}}function Se(t){return t&&t.__esModule&&Object.prototype.hasOwnProperty.call(t,"default")?t.default:t}var ke=Me;function Me(t,e,r,n){this.cx=3*t,this.bx=3*(r-t)-this.cx,this.ax=1-this.cx-this.bx,this.cy=3*e,this.by=3*(n-e)-this.cy,this.ay=1-this.cy-this.by,this.p1x=t,this.p1y=e,this.p2x=r,this.p2y=n;}Me.prototype={sampleCurveX:function(t){return ((this.ax*t+this.bx)*t+this.cx)*t},sampleCurveY:function(t){return ((this.ay*t+this.by)*t+this.cy)*t},sampleCurveDerivativeX:function(t){return (3*this.ax*t+2*this.bx)*t+this.cx},solveCurveX:function(t,e){if(void 0===e&&(e=1e-6),t<0)return 0;if(t>1)return 1;for(var r=t,n=0;n<8;n++){var i=this.sampleCurveX(r)-t;if(Math.abs(i)<e)return r;var s=this.sampleCurveDerivativeX(r);if(Math.abs(s)<1e-6)break;r-=i/s;}var a=0,o=1;for(r=t,n=0;n<20&&(i=this.sampleCurveX(r),!(Math.abs(i-t)<e));n++)t>i?a=r:o=r,r=.5*(o-a)+a;return r},solve:function(t,e){return this.sampleCurveY(this.solveCurveX(t,e))}};var Ie=Se(ke);function ze(t,e,r){return t+r*(e-t)}function Pe(t,e,r){return t.map(((t,n)=>ze(t,e[n],r)))}const Ce={number:ze,color:function(t,e,r,n="rgb"){switch(n){case"rgb":{const[n,i,s,a]=Pe(t.rgb,e.rgb,r);return new Kt(n,i,s,a,!1)}case"hcl":{const[n,i,s,a]=t.hcl,[o,l,u,c]=e.hcl;let h,p;if(isNaN(n)||isNaN(o))isNaN(n)?isNaN(o)?h=NaN:(h=o,1!==s&&0!==s||(p=l)):(h=n,1!==u&&0!==u||(p=i));else {let t=o-n;o>n&&t>180?t-=360:o<n&&n-o>180&&(t+=360),h=n+r*t;}const[f,d,y,m]=function([t,e,r,n]){return t=isNaN(t)?0:t*Et,Ot([r,Math.cos(t)*e,Math.sin(t)*e,n])}([h,null!=p?p:ze(i,l,r),ze(s,u,r),ze(a,c,r)]);return new Kt(f,d,y,m,!1)}case"lab":{const[n,i,s,a]=Ot(Pe(t.lab,e.lab,r));return new Kt(n,i,s,a,!1)}}},array:Pe,padding:function(t,e,r){return new Jt(Pe(t.values,e.values,r))},variableAnchorOffsetCollection:function(t,e,r){const n=t.values,i=e.values;if(n.length!==i.length)throw new ae(`Cannot interpolate values of different length. from: ${t.toString()}, to: ${e.toString()}`);const s=[];for(let t=0;t<n.length;t+=2){if(n[t]!==i[t])throw new ae(`Cannot interpolate values containing mismatched anchors. from[${t}]: ${n[t]}, to[${t}]: ${i[t]}`);s.push(n[t]);const[e,a]=n[t+1],[o,l]=i[t+1];s.push([ze(e,o,r),ze(a,l,r)]);}return new Qt(s)}};class Be{constructor(t,e,r,n,i){this.type=t,this.operator=e,this.interpolation=r,this.input=n,this.labels=[],this.outputs=[];for(const[t,e]of i)this.labels.push(t),this.outputs.push(e);}static interpolationFactor(t,e,r,n){let i=0;if("exponential"===t.name)i=Ve(e,t.base,r,n);else if("linear"===t.name)i=Ve(e,1,r,n);else if("cubic-bezier"===t.name){const s=t.controlPoints;i=new Ie(s[0],s[1],s[2],s[3]).solve(Ve(e,1,r,n));}return i}static parse(t,e){let[r,n,i,...s]=t;if(!Array.isArray(n)||0===n.length)return e.error("Expected an interpolation type expression.",1);if("linear"===n[0])n={name:"linear"};else if("exponential"===n[0]){const t=n[1];if("number"!=typeof t)return e.error("Exponential interpolation requires a numeric base.",1,1);n={name:"exponential",base:t};}else {if("cubic-bezier"!==n[0])return e.error(`Unknown interpolation type ${String(n[0])}`,1,0);{const t=n.slice(1);if(4!==t.length||t.some((t=>"number"!=typeof t||t<0||t>1)))return e.error("Cubic bezier interpolation requires four numeric arguments with values between 0 and 1.",1);n={name:"cubic-bezier",controlPoints:t};}}if(t.length-1<4)return e.error(`Expected at least 4 arguments, but found only ${t.length-1}.`);if((t.length-1)%2!=0)return e.error("Expected an even number of arguments.");if(i=e.parse(i,2,ut),!i)return null;const a=[];let o=null;"interpolate-hcl"===r||"interpolate-lab"===r?o=pt:e.expectedType&&"value"!==e.expectedType.kind&&(o=e.expectedType);for(let t=0;t<s.length;t+=2){const r=s[t],n=s[t+1],i=t+3,l=t+4;if("number"!=typeof r)return e.error('Input/output pairs for "interpolate" expressions must be defined using literal numeric values (not computed expressions) for the input values.',i);if(a.length&&a[a.length-1][0]>=r)return e.error('Input/output pairs for "interpolate" expressions must be arranged with input values in strictly ascending order.',i);const u=e.parse(n,l,o);if(!u)return null;o=o||u.type,a.push([r,u]);}return Mt(o,ut)||Mt(o,pt)||Mt(o,gt)||Mt(o,vt)||Mt(o,bt(ut))?new Be(o,r,n,i,a):e.error(`Type ${wt(o)} is not interpolatable.`)}evaluate(t){const e=this.labels,r=this.outputs;if(1===e.length)return r[0].evaluate(t);const n=this.input.evaluate(t);if(n<=e[0])return r[0].evaluate(t);const i=e.length;if(n>=e[i-1])return r[i-1].evaluate(t);const s=_e(e,n),a=Be.interpolationFactor(this.interpolation,n,e[s],e[s+1]),o=r[s].evaluate(t),l=r[s+1].evaluate(t);switch(this.operator){case"interpolate":return Ce[this.type.kind](o,l,a);case"interpolate-hcl":return Ce.color(o,l,a,"hcl");case"interpolate-lab":return Ce.color(o,l,a,"lab")}}eachChild(t){t(this.input);for(const e of this.outputs)t(e);}outputDefined(){return this.outputs.every((t=>t.outputDefined()))}}function Ve(t,e,r,n){const i=n-r,s=t-r;return 0===i?0:1===e?s/i:(Math.pow(e,s)-1)/(Math.pow(e,i)-1)}class Ee{constructor(t,e){this.type=t,this.args=e;}static parse(t,e){if(t.length<2)return e.error("Expectected at least one argument.");let r=null;const n=e.expectedType;n&&"value"!==n.kind&&(r=n);const i=[];for(const n of t.slice(1)){const t=e.parse(n,1+i.length,r,void 0,{typeAnnotation:"omit"});if(!t)return null;r=r||t.type,i.push(t);}if(!r)throw new Error("No output type");const s=n&&i.some((t=>At(n,t.type)));return new Ee(s?dt:r,i)}evaluate(t){let e,r=null,n=0;for(const i of this.args)if(n++,r=i.evaluate(t),r&&r instanceof te&&!r.available&&(e||(e=r.name),r=null,n===this.args.length&&(r=e)),null!==r)break;return r}eachChild(t){this.args.forEach(t);}outputDefined(){return this.args.every((t=>t.outputDefined()))}}function Fe(t,e){return "=="===t||"!="===t?"boolean"===e.kind||"string"===e.kind||"number"===e.kind||"null"===e.kind||"value"===e.kind:"string"===e.kind||"number"===e.kind||"value"===e.kind}function Te(t,e,r,n){return 0===n.compare(e,r)}function $e(t,e,r){const n="=="!==t&&"!="!==t;return class i{constructor(t,e,r){this.type=ht,this.lhs=t,this.rhs=e,this.collator=r,this.hasUntypedArgument="value"===t.type.kind||"value"===e.type.kind;}static parse(t,e){if(3!==t.length&&4!==t.length)return e.error("Expected two or three arguments.");const r=t[0];let s=e.parse(t[1],1,dt);if(!s)return null;if(!Fe(r,s.type))return e.concat(1).error(`"${r}" comparisons are not supported for type '${wt(s.type)}'.`);let a=e.parse(t[2],2,dt);if(!a)return null;if(!Fe(r,a.type))return e.concat(2).error(`"${r}" comparisons are not supported for type '${wt(a.type)}'.`);if(s.type.kind!==a.type.kind&&"value"!==s.type.kind&&"value"!==a.type.kind)return e.error(`Cannot compare types '${wt(s.type)}' and '${wt(a.type)}'.`);n&&("value"===s.type.kind&&"value"!==a.type.kind?s=new le(a.type,[s]):"value"!==s.type.kind&&"value"===a.type.kind&&(a=new le(s.type,[a])));let o=null;if(4===t.length){if("string"!==s.type.kind&&"string"!==a.type.kind&&"value"!==s.type.kind&&"value"!==a.type.kind)return e.error("Cannot use collator to compare non-string types.");if(o=e.parse(t[3],3,yt),!o)return null}return new i(s,a,o)}evaluate(i){const s=this.lhs.evaluate(i),a=this.rhs.evaluate(i);if(n&&this.hasUntypedArgument){const e=ne(s),r=ne(a);if(e.kind!==r.kind||"string"!==e.kind&&"number"!==e.kind)throw new ae(`Expected arguments for "${t}" to be (string, string) or (number, number), but found (${e.kind}, ${r.kind}) instead.`)}if(this.collator&&!n&&this.hasUntypedArgument){const t=ne(s),r=ne(a);if("string"!==t.kind||"string"!==r.kind)return e(i,s,a)}return this.collator?r(i,s,a,this.collator.evaluate(i)):e(i,s,a)}eachChild(t){t(this.lhs),t(this.rhs),this.collator&&t(this.collator);}outputDefined(){return !0}}}const Le=$e("==",(function(t,e,r){return e===r}),Te),De=$e("!=",(function(t,e,r){return e!==r}),(function(t,e,r,n){return !Te(0,e,r,n)})),Oe=$e("<",(function(t,e,r){return e<r}),(function(t,e,r,n){return n.compare(e,r)<0})),je=$e(">",(function(t,e,r){return e>r}),(function(t,e,r,n){return n.compare(e,r)>0})),Re=$e("<=",(function(t,e,r){return e<=r}),(function(t,e,r,n){return n.compare(e,r)<=0})),Ue=$e(">=",(function(t,e,r){return e>=r}),(function(t,e,r,n){return n.compare(e,r)>=0}));class qe{constructor(t,e,r){this.type=yt,this.locale=r,this.caseSensitive=t,this.diacriticSensitive=e;}static parse(t,e){if(2!==t.length)return e.error("Expected one argument.");const r=t[1];if("object"!=typeof r||Array.isArray(r))return e.error("Collator options argument must be an object.");const n=e.parse(void 0!==r["case-sensitive"]&&r["case-sensitive"],1,ht);if(!n)return null;const i=e.parse(void 0!==r["diacritic-sensitive"]&&r["diacritic-sensitive"],1,ht);if(!i)return null;let s=null;return r.locale&&(s=e.parse(r.locale,1,ct),!s)?null:new qe(n,i,s)}evaluate(t){return new Xt(this.caseSensitive.evaluate(t),this.diacriticSensitive.evaluate(t),this.locale?this.locale.evaluate(t):null)}eachChild(t){t(this.caseSensitive),t(this.diacriticSensitive),this.locale&&t(this.locale);}outputDefined(){return !1}}class Ne{constructor(t,e,r,n,i){this.type=ct,this.number=t,this.locale=e,this.currency=r,this.minFractionDigits=n,this.maxFractionDigits=i;}static parse(t,e){if(3!==t.length)return e.error("Expected two arguments.");const r=e.parse(t[1],1,ut);if(!r)return null;const n=t[2];if("object"!=typeof n||Array.isArray(n))return e.error("NumberFormat options argument must be an object.");let i=null;if(n.locale&&(i=e.parse(n.locale,1,ct),!i))return null;let s=null;if(n.currency&&(s=e.parse(n.currency,1,ct),!s))return null;let a=null;if(n["min-fraction-digits"]&&(a=e.parse(n["min-fraction-digits"],1,ut),!a))return null;let o=null;return n["max-fraction-digits"]&&(o=e.parse(n["max-fraction-digits"],1,ut),!o)?null:new Ne(r,i,s,a,o)}evaluate(t){return new Intl.NumberFormat(this.locale?this.locale.evaluate(t):[],{style:this.currency?"currency":"decimal",currency:this.currency?this.currency.evaluate(t):void 0,minimumFractionDigits:this.minFractionDigits?this.minFractionDigits.evaluate(t):void 0,maximumFractionDigits:this.maxFractionDigits?this.maxFractionDigits.evaluate(t):void 0}).format(this.number.evaluate(t))}eachChild(t){t(this.number),this.locale&&t(this.locale),this.currency&&t(this.currency),this.minFractionDigits&&t(this.minFractionDigits),this.maxFractionDigits&&t(this.maxFractionDigits);}outputDefined(){return !1}}class Ze{constructor(t){this.type=mt,this.sections=t;}static parse(t,e){if(t.length<2)return e.error("Expected at least one argument.");const r=t[1];if(!Array.isArray(r)&&"object"==typeof r)return e.error("First argument must be an image or text section.");const n=[];let i=!1;for(let r=1;r<=t.length-1;++r){const s=t[r];if(i&&"object"==typeof s&&!Array.isArray(s)){i=!1;let t=null;if(s["font-scale"]&&(t=e.parse(s["font-scale"],1,ut),!t))return null;let r=null;if(s["text-font"]&&(r=e.parse(s["text-font"],1,bt(ct)),!r))return null;let a=null;if(s["text-color"]&&(a=e.parse(s["text-color"],1,pt),!a))return null;const o=n[n.length-1];o.scale=t,o.font=r,o.textColor=a;}else {const s=e.parse(t[r],1,dt);if(!s)return null;const a=s.type.kind;if("string"!==a&&"value"!==a&&"null"!==a&&"resolvedImage"!==a)return e.error("Formatted text type must be 'string', 'value', 'image' or 'null'.");i=!0,n.push({content:s,scale:null,font:null,textColor:null});}}return new Ze(n)}evaluate(t){return new Yt(this.sections.map((e=>{const r=e.content.evaluate(t);return ne(r)===xt?new Ht("",r,null,null,null):new Ht(ie(r),null,e.scale?e.scale.evaluate(t):null,e.font?e.font.evaluate(t).join(","):null,e.textColor?e.textColor.evaluate(t):null)})))}eachChild(t){for(const e of this.sections)t(e.content),e.scale&&t(e.scale),e.font&&t(e.font),e.textColor&&t(e.textColor);}outputDefined(){return !1}}class Ge{constructor(t){this.type=xt,this.input=t;}static parse(t,e){if(2!==t.length)return e.error("Expected two arguments.");const r=e.parse(t[1],1,ct);return r?new Ge(r):e.error("No image name provided.")}evaluate(t){const e=this.input.evaluate(t),r=te.fromString(e);return r&&t.availableImages&&(r.available=t.availableImages.indexOf(e)>-1),r}eachChild(t){t(this.input);}outputDefined(){return !1}}class Ke{constructor(t){this.type=ut,this.input=t;}static parse(t,e){if(2!==t.length)return e.error(`Expected 1 argument, but found ${t.length-1} instead.`);const r=e.parse(t[1],1);return r?"array"!==r.type.kind&&"string"!==r.type.kind&&"value"!==r.type.kind?e.error(`Expected argument of type string or array, but found ${wt(r.type)} instead.`):new Ke(r):null}evaluate(t){const e=this.input.evaluate(t);if("string"==typeof e)return [...e].length;if(Array.isArray(e))return e.length;throw new ae(`Expected value to be of type string or array, but found ${wt(ne(e))} instead.`)}eachChild(t){t(this.input);}outputDefined(){return !1}}const Xe=8192;function He(t,e){const r=(180+t[0])/360,n=(180-180/Math.PI*Math.log(Math.tan(Math.PI/4+t[1]*Math.PI/360)))/360,i=Math.pow(2,e.z);return [Math.round(r*i*Xe),Math.round(n*i*Xe)]}function Ye(t,e){const r=Math.pow(2,e.z);return [(i=(t[0]/Xe+e.x)/r,360*i-180),(n=(t[1]/Xe+e.y)/r,360/Math.PI*Math.atan(Math.exp((180-360*n)*Math.PI/180))-90)];var n,i;}function Je(t,e){t[0]=Math.min(t[0],e[0]),t[1]=Math.min(t[1],e[1]),t[2]=Math.max(t[2],e[0]),t[3]=Math.max(t[3],e[1]);}function We(t,e){return !(t[0]<=e[0]||t[2]>=e[2]||t[1]<=e[1]||t[3]>=e[3])}function Qe(t,e,r){const n=t[0]-e[0],i=t[1]-e[1],s=t[0]-r[0],a=t[1]-r[1];return n*a-s*i==0&&n*s<=0&&i*a<=0}function tr(t,e,r,n){return 0!=(i=[n[0]-r[0],n[1]-r[1]])[0]*(s=[e[0]-t[0],e[1]-t[1]])[1]-i[1]*s[0]&&!(!ar(t,e,r,n)||!ar(r,n,t,e));var i,s;}function er(t,e,r){for(const n of r)for(let r=0;r<n.length-1;++r)if(tr(t,e,n[r],n[r+1]))return !0;return !1}function rr(t,e,r=!1){let n=!1;for(const o of e)for(let e=0;e<o.length-1;e++){if(Qe(t,o[e],o[e+1]))return r;(s=o[e])[1]>(i=t)[1]!=(a=o[e+1])[1]>i[1]&&i[0]<(a[0]-s[0])*(i[1]-s[1])/(a[1]-s[1])+s[0]&&(n=!n);}var i,s,a;return n}function nr(t,e){for(const r of e)if(rr(t,r))return !0;return !1}function ir(t,e){for(const r of t)if(!rr(r,e))return !1;for(let r=0;r<t.length-1;++r)if(er(t[r],t[r+1],e))return !1;return !0}function sr(t,e){for(const r of e)if(ir(t,r))return !0;return !1}function ar(t,e,r,n){const i=n[0]-r[0],s=n[1]-r[1],a=(t[0]-r[0])*s-i*(t[1]-r[1]),o=(e[0]-r[0])*s-i*(e[1]-r[1]);return a>0&&o<0||a<0&&o>0}function or(t,e,r){const n=[];for(let i=0;i<t.length;i++){const s=[];for(let n=0;n<t[i].length;n++){const a=He(t[i][n],r);Je(e,a),s.push(a);}n.push(s);}return n}function lr(t,e,r){const n=[];for(let i=0;i<t.length;i++){const s=or(t[i],e,r);n.push(s);}return n}function ur(t,e,r,n){if(t[0]<r[0]||t[0]>r[2]){const e=.5*n;let i=t[0]-r[0]>e?-n:r[0]-t[0]>e?n:0;0===i&&(i=t[0]-r[2]>e?-n:r[2]-t[0]>e?n:0),t[0]+=i;}Je(e,t);}function cr(t,e,r,n){const i=Math.pow(2,n.z)*Xe,s=[n.x*Xe,n.y*Xe],a=[];for(const n of t)for(const t of n){const n=[t.x+s[0],t.y+s[1]];ur(n,e,r,i),a.push(n);}return a}function hr(t,e,r,n){const i=Math.pow(2,n.z)*Xe,s=[n.x*Xe,n.y*Xe],a=[];for(const r of t){const t=[];for(const n of r){const r=[n.x+s[0],n.y+s[1]];Je(e,r),t.push(r);}a.push(t);}if(e[2]-e[0]<=i/2){(o=e)[0]=o[1]=1/0,o[2]=o[3]=-1/0;for(const t of a)for(const n of t)ur(n,e,r,i);}var o;return a}class pr{constructor(t,e){this.type=ht,this.geojson=t,this.geometries=e;}static parse(t,e){if(2!==t.length)return e.error(`'within' expression requires exactly one argument, but found ${t.length-1} instead.`);if(re(t[1])){const e=t[1];if("FeatureCollection"===e.type){const t=[];for(const r of e.features){const{type:e,coordinates:n}=r.geometry;"Polygon"===e&&t.push(n),"MultiPolygon"===e&&t.push(...n);}if(t.length)return new pr(e,{type:"MultiPolygon",coordinates:t})}else if("Feature"===e.type){const t=e.geometry.type;if("Polygon"===t||"MultiPolygon"===t)return new pr(e,e.geometry)}else if("Polygon"===e.type||"MultiPolygon"===e.type)return new pr(e,e)}return e.error("'within' expression requires valid geojson object that contains polygon geometry type.")}evaluate(t){if(null!=t.geometry()&&null!=t.canonicalID()){if("Point"===t.geometryType())return function(t,e){const r=[1/0,1/0,-1/0,-1/0],n=[1/0,1/0,-1/0,-1/0],i=t.canonicalID();if("Polygon"===e.type){const s=or(e.coordinates,n,i),a=cr(t.geometry(),r,n,i);if(!We(r,n))return !1;for(const t of a)if(!rr(t,s))return !1}if("MultiPolygon"===e.type){const s=lr(e.coordinates,n,i),a=cr(t.geometry(),r,n,i);if(!We(r,n))return !1;for(const t of a)if(!nr(t,s))return !1}return !0}(t,this.geometries);if("LineString"===t.geometryType())return function(t,e){const r=[1/0,1/0,-1/0,-1/0],n=[1/0,1/0,-1/0,-1/0],i=t.canonicalID();if("Polygon"===e.type){const s=or(e.coordinates,n,i),a=hr(t.geometry(),r,n,i);if(!We(r,n))return !1;for(const t of a)if(!ir(t,s))return !1}if("MultiPolygon"===e.type){const s=lr(e.coordinates,n,i),a=hr(t.geometry(),r,n,i);if(!We(r,n))return !1;for(const t of a)if(!sr(t,s))return !1}return !0}(t,this.geometries)}return !1}eachChild(){}outputDefined(){return !0}}let fr=class{constructor(t=[],e=((t,e)=>t<e?-1:t>e?1:0)){if(this.data=t,this.length=this.data.length,this.compare=e,this.length>0)for(let t=(this.length>>1)-1;t>=0;t--)this._down(t);}push(t){this.data.push(t),this._up(this.length++);}pop(){if(0===this.length)return;const t=this.data[0],e=this.data.pop();return --this.length>0&&(this.data[0]=e,this._down(0)),t}peek(){return this.data[0]}_up(t){const{data:e,compare:r}=this,n=e[t];for(;t>0;){const i=t-1>>1,s=e[i];if(r(n,s)>=0)break;e[t]=s,t=i;}e[t]=n;}_down(t){const{data:e,compare:r}=this,n=this.length>>1,i=e[t];for(;t<n;){let n=1+(t<<1);const s=n+1;if(s<this.length&&r(e[s],e[n])<0&&(n=s),r(e[n],i)>=0)break;e[t]=e[n],t=n;}e[t]=i;}};function dr(t,e,r,n,i){yr(t,e,r,n||t.length-1,i||gr);}function yr(t,e,r,n,i){for(;n>r;){if(n-r>600){var s=n-r+1,a=e-r+1,o=Math.log(s),l=.5*Math.exp(2*o/3),u=.5*Math.sqrt(o*l*(s-l)/s)*(a-s/2<0?-1:1);yr(t,e,Math.max(r,Math.floor(e-a*l/s+u)),Math.min(n,Math.floor(e+(s-a)*l/s+u)),i);}var c=t[e],h=r,p=n;for(mr(t,r,e),i(t[n],c)>0&&mr(t,r,n);h<p;){for(mr(t,h,p),h++,p--;i(t[h],c)<0;)h++;for(;i(t[p],c)>0;)p--;}0===i(t[r],c)?mr(t,r,p):mr(t,++p,n),p<=e&&(r=p+1),e<=p&&(n=p-1);}}function mr(t,e,r){var n=t[e];t[e]=t[r],t[r]=n;}function gr(t,e){return t<e?-1:t>e?1:0}function xr(t,e){if(t.length<=1)return [t];const r=[];let n,i;for(const e of t){const t=br(e);0!==t&&(e.area=Math.abs(t),void 0===i&&(i=t<0),i===t<0?(n&&r.push(n),n=[e]):n.push(e));}if(n&&r.push(n),e>1)for(let t=0;t<r.length;t++)r[t].length<=e||(dr(r[t],e,1,r[t].length-1,vr),r[t]=r[t].slice(0,e));return r}function vr(t,e){return e.area-t.area}function br(t){let e=0;for(let r,n,i=0,s=t.length,a=s-1;i<s;a=i++)r=t[i],n=t[a],e+=(n.x-r.x)*(r.y+n.y);return e}const wr=1/298.257223563,_r=wr*(2-wr),Ar=Math.PI/180;class Sr{constructor(t){const e=6378.137*Ar*1e3,r=Math.cos(t*Ar),n=1/(1-_r*(1-r*r)),i=Math.sqrt(n);this.kx=e*i*r,this.ky=e*i*n*(1-_r);}distance(t,e){const r=this.wrap(t[0]-e[0])*this.kx,n=(t[1]-e[1])*this.ky;return Math.sqrt(r*r+n*n)}pointOnLine(t,e){let r,n,i,s,a=1/0;for(let o=0;o<t.length-1;o++){let l=t[o][0],u=t[o][1],c=this.wrap(t[o+1][0]-l)*this.kx,h=(t[o+1][1]-u)*this.ky,p=0;0===c&&0===h||(p=(this.wrap(e[0]-l)*this.kx*c+(e[1]-u)*this.ky*h)/(c*c+h*h),p>1?(l=t[o+1][0],u=t[o+1][1]):p>0&&(l+=c/this.kx*p,u+=h/this.ky*p)),c=this.wrap(e[0]-l)*this.kx,h=(e[1]-u)*this.ky;const f=c*c+h*h;f<a&&(a=f,r=l,n=u,i=o,s=p);}return {point:[r,n],index:i,t:Math.max(0,Math.min(1,s))}}wrap(t){for(;t<-180;)t+=360;for(;t>180;)t-=360;return t}}function kr(t,e){return e[0]-t[0]}function Mr(t){return t[1]-t[0]+1}function Ir(t,e){return t[1]>=t[0]&&t[1]<e}function zr(t,e){if(t[0]>t[1])return [null,null];const r=Mr(t);if(e){if(2===r)return [t,null];const e=Math.floor(r/2);return [[t[0],t[0]+e],[t[0]+e,t[1]]]}if(1===r)return [t,null];const n=Math.floor(r/2)-1;return [[t[0],t[0]+n],[t[0]+n+1,t[1]]]}function Pr(t,e){if(!Ir(e,t.length))return [1/0,1/0,-1/0,-1/0];const r=[1/0,1/0,-1/0,-1/0];for(let n=e[0];n<=e[1];++n)Je(r,t[n]);return r}function Cr(t){const e=[1/0,1/0,-1/0,-1/0];for(const r of t)for(const t of r)Je(e,t);return e}function Br(t){return t[0]!==-1/0&&t[1]!==-1/0&&t[2]!==1/0&&t[3]!==1/0}function Vr(t,e,r){if(!Br(t)||!Br(e))return NaN;let n=0,i=0;return t[2]<e[0]&&(n=e[0]-t[2]),t[0]>e[2]&&(n=t[0]-e[2]),t[1]>e[3]&&(i=t[1]-e[3]),t[3]<e[1]&&(i=e[1]-t[3]),r.distance([0,0],[n,i])}function Er(t,e,r){const n=r.pointOnLine(e,t);return r.distance(t,n.point)}function Fr(t,e,r,n,i){const s=Math.min(Er(t,[r,n],i),Er(e,[r,n],i)),a=Math.min(Er(r,[t,e],i),Er(n,[t,e],i));return Math.min(s,a)}function Tr(t,e,r,n,i){if(!Ir(e,t.length)||!Ir(n,r.length))return 1/0;let s=1/0;for(let a=e[0];a<e[1];++a){const e=t[a],o=t[a+1];for(let t=n[0];t<n[1];++t){const n=r[t],a=r[t+1];if(tr(e,o,n,a))return 0;s=Math.min(s,Fr(e,o,n,a,i));}}return s}function $r(t,e,r,n,i){if(!Ir(e,t.length)||!Ir(n,r.length))return NaN;let s=1/0;for(let a=e[0];a<=e[1];++a)for(let e=n[0];e<=n[1];++e)if(s=Math.min(s,i.distance(t[a],r[e])),0===s)return s;return s}function Lr(t,e,r){if(rr(t,e,!0))return 0;let n=1/0;for(const i of e){const e=i[0],s=i[i.length-1];if(e!==s&&(n=Math.min(n,Er(t,[s,e],r)),0===n))return n;const a=r.pointOnLine(i,t);if(n=Math.min(n,r.distance(t,a.point)),0===n)return n}return n}function Dr(t,e,r,n){if(!Ir(e,t.length))return NaN;for(let n=e[0];n<=e[1];++n)if(rr(t[n],r,!0))return 0;let i=1/0;for(let s=e[0];s<e[1];++s){const e=t[s],a=t[s+1];for(const t of r)for(let r=0,s=t.length,o=s-1;r<s;o=r++){const s=t[o],l=t[r];if(tr(e,a,s,l))return 0;i=Math.min(i,Fr(e,a,s,l,n));}}return i}function Or(t,e){for(const r of t)for(const t of r)if(rr(t,e,!0))return !0;return !1}function jr(t,e,r,n=1/0){const i=Cr(t),s=Cr(e);if(n!==1/0&&Vr(i,s,r)>=n)return n;if(We(i,s)){if(Or(t,e))return 0}else if(Or(e,t))return 0;let a=1/0;for(const n of t)for(let t=0,i=n.length,s=i-1;t<i;s=t++){const i=n[s],o=n[t];for(const t of e)for(let e=0,n=t.length,s=n-1;e<n;s=e++){const n=t[s],l=t[e];if(tr(i,o,n,l))return 0;a=Math.min(a,Fr(i,o,n,l,r));}}return a}function Rr(t,e,r,n,i,s){if(!s)return;const a=Vr(Pr(n,s),i,r);a<e&&t.push([a,s,[0,0]]);}function Ur(t,e,r,n,i,s,a){if(!s||!a)return;const o=Vr(Pr(n,s),Pr(i,a),r);o<e&&t.push([o,s,a]);}function qr(t,e,r,n,i=1/0){let s=Math.min(n.distance(t[0],r[0][0]),i);if(0===s)return s;const a=new fr([[0,[0,t.length-1],[0,0]]],kr),o=Cr(r);for(;a.length>0;){const i=a.pop();if(i[0]>=s)continue;const l=i[1],u=e?50:100;if(Mr(l)<=u){if(!Ir(l,t.length))return NaN;if(e){const e=Dr(t,l,r,n);if(isNaN(e)||0===e)return e;s=Math.min(s,e);}else for(let e=l[0];e<=l[1];++e){const i=Lr(t[e],r,n);if(s=Math.min(s,i),0===s)return 0}}else {const r=zr(l,e);Rr(a,s,n,t,o,r[0]),Rr(a,s,n,t,o,r[1]);}}return s}function Nr(t,e,r,n,i,s=1/0){let a=Math.min(s,i.distance(t[0],r[0]));if(0===a)return a;const o=new fr([[0,[0,t.length-1],[0,r.length-1]]],kr);for(;o.length>0;){const s=o.pop();if(s[0]>=a)continue;const l=s[1],u=s[2],c=e?50:100,h=n?50:100;if(Mr(l)<=c&&Mr(u)<=h){if(!Ir(l,t.length)&&Ir(u,r.length))return NaN;let s;if(e&&n)s=Tr(t,l,r,u,i),a=Math.min(a,s);else if(e&&!n){const e=t.slice(l[0],l[1]+1);for(let t=u[0];t<=u[1];++t)if(s=Er(r[t],e,i),a=Math.min(a,s),0===a)return a}else if(!e&&n){const e=r.slice(u[0],u[1]+1);for(let r=l[0];r<=l[1];++r)if(s=Er(t[r],e,i),a=Math.min(a,s),0===a)return a}else s=$r(t,l,r,u,i),a=Math.min(a,s);}else {const s=zr(l,e),c=zr(u,n);Ur(o,a,i,t,r,s[0],c[0]),Ur(o,a,i,t,r,s[0],c[1]),Ur(o,a,i,t,r,s[1],c[0]),Ur(o,a,i,t,r,s[1],c[1]);}}return a}function Zr(t){return "MultiPolygon"===t.type?t.coordinates.map((t=>({type:"Polygon",coordinates:t}))):"MultiLineString"===t.type?t.coordinates.map((t=>({type:"LineString",coordinates:t}))):"MultiPoint"===t.type?t.coordinates.map((t=>({type:"Point",coordinates:t}))):[t]}class Gr{constructor(t,e){this.type=ut,this.geojson=t,this.geometries=e;}static parse(t,e){if(2!==t.length)return e.error(`'distance' expression requires exactly one argument, but found ${t.length-1} instead.`);if(re(t[1])){const e=t[1];if("FeatureCollection"===e.type)return new Gr(e,e.features.map((t=>Zr(t.geometry))).flat());if("Feature"===e.type)return new Gr(e,Zr(e.geometry));if("type"in e&&"coordinates"in e)return new Gr(e,Zr(e))}return e.error("'distance' expression requires valid geojson object that contains polygon geometry type.")}evaluate(t){if(null!=t.geometry()&&null!=t.canonicalID()){if("Point"===t.geometryType())return function(t,e){const r=t.geometry(),n=r.flat().map((e=>Ye([e.x,e.y],t.canonical)));if(0===r.length)return NaN;const i=new Sr(n[0][1]);let s=1/0;for(const t of e){switch(t.type){case"Point":s=Math.min(s,Nr(n,!1,[t.coordinates],!1,i,s));break;case"LineString":s=Math.min(s,Nr(n,!1,t.coordinates,!0,i,s));break;case"Polygon":s=Math.min(s,qr(n,!1,t.coordinates,i,s));}if(0===s)return s}return s}(t,this.geometries);if("LineString"===t.geometryType())return function(t,e){const r=t.geometry(),n=r.flat().map((e=>Ye([e.x,e.y],t.canonical)));if(0===r.length)return NaN;const i=new Sr(n[0][1]);let s=1/0;for(const t of e){switch(t.type){case"Point":s=Math.min(s,Nr(n,!0,[t.coordinates],!1,i,s));break;case"LineString":s=Math.min(s,Nr(n,!0,t.coordinates,!0,i,s));break;case"Polygon":s=Math.min(s,qr(n,!0,t.coordinates,i,s));}if(0===s)return s}return s}(t,this.geometries);if("Polygon"===t.geometryType())return function(t,e){const r=t.geometry();if(0===r.length||0===r[0].length)return NaN;const n=xr(r,0).map((e=>e.map((e=>e.map((e=>Ye([e.x,e.y],t.canonical))))))),i=new Sr(n[0][0][0][1]);let s=1/0;for(const t of e)for(const e of n){switch(t.type){case"Point":s=Math.min(s,qr([t.coordinates],!1,e,i,s));break;case"LineString":s=Math.min(s,qr(t.coordinates,!0,e,i,s));break;case"Polygon":s=Math.min(s,jr(e,t.coordinates,i,s));}if(0===s)return s}return s}(t,this.geometries)}return NaN}eachChild(){}outputDefined(){return !0}}const Kr={"==":Le,"!=":De,">":je,"<":Oe,">=":Ue,"<=":Re,array:le,at:me,boolean:le,case:be,coalesce:Ee,collator:qe,format:Ze,image:Ge,in:ge,"index-of":xe,interpolate:Be,"interpolate-hcl":Be,"interpolate-lab":Be,length:Ke,let:de,literal:se,match:ve,number:le,"number-format":Ne,object:le,slice:we,step:Ae,string:le,"to-boolean":ce,"to-color":ce,"to-number":ce,"to-string":ce,var:ye,within:pr,distance:Gr};class Xr{constructor(t,e,r,n){this.name=t,this.type=e,this._evaluate=r,this.args=n;}evaluate(t){return this._evaluate(t,this.args)}eachChild(t){this.args.forEach(t);}outputDefined(){return !1}static parse(t,e){const r=t[0],n=Xr.definitions[r];if(!n)return e.error(`Unknown expression "${r}". If you wanted a literal array, use ["literal", [...]].`,0);const i=Array.isArray(n)?n[0]:n.type,s=Array.isArray(n)?[[n[1],n[2]]]:n.overloads,a=s.filter((([e])=>!Array.isArray(e)||e.length===t.length-1));let o=null;for(const[n,s]of a){o=new fe(e.registry,Qr,e.path,null,e.scope);const a=[];let l=!1;for(let e=1;e<t.length;e++){const r=t[e],i=Array.isArray(n)?n[e-1]:n.type,s=o.parse(r,1+a.length,i);if(!s){l=!0;break}a.push(s);}if(!l)if(Array.isArray(n)&&n.length!==a.length)o.error(`Expected ${n.length} arguments, but found ${a.length} instead.`);else {for(let t=0;t<a.length;t++){const e=Array.isArray(n)?n[t]:n.type,r=a[t];o.concat(t+1).checkSubtype(e,r.type);}if(0===o.errors.length)return new Xr(r,i,s,a)}}if(1===a.length)e.errors.push(...o.errors);else {const r=(a.length?a:s).map((([t])=>{return e=t,Array.isArray(e)?`(${e.map(wt).join(", ")})`:`(${wt(e.type)}...)`;var e;})).join(" | "),n=[];for(let r=1;r<t.length;r++){const i=e.parse(t[r],1+n.length);if(!i)return null;n.push(wt(i.type));}e.error(`Expected arguments of type ${r}, but found (${n.join(", ")}) instead.`);}return null}static register(t,e){Xr.definitions=e;for(const r in e)t[r]=Xr;}}function Hr(t,[e,r,n,i]){e=e.evaluate(t),r=r.evaluate(t),n=n.evaluate(t);const s=i?i.evaluate(t):1,a=ee(e,r,n,s);if(a)throw new ae(a);return new Kt(e/255,r/255,n/255,s,!1)}function Yr(t,e){return t in e}function Jr(t,e){const r=e[t];return void 0===r?null:r}function Wr(t){return {type:t}}function Qr(t){if(t instanceof ye)return Qr(t.boundExpression);if(t instanceof Xr&&"error"===t.name)return !1;if(t instanceof qe)return !1;if(t instanceof pr)return !1;if(t instanceof Gr)return !1;const e=t instanceof ce||t instanceof le;let r=!0;return t.eachChild((t=>{r=e?r&&Qr(t):r&&t instanceof se;})),!!r&&tn(t)&&rn(t,["zoom","heatmap-density","line-progress","accumulated","is-supported-script"])}function tn(t){if(t instanceof Xr){if("get"===t.name&&1===t.args.length)return !1;if("feature-state"===t.name)return !1;if("has"===t.name&&1===t.args.length)return !1;if("properties"===t.name||"geometry-type"===t.name||"id"===t.name)return !1;if(/^filter-/.test(t.name))return !1}if(t instanceof pr)return !1;if(t instanceof Gr)return !1;let e=!0;return t.eachChild((t=>{e&&!tn(t)&&(e=!1);})),e}function en(t){if(t instanceof Xr&&"feature-state"===t.name)return !1;let e=!0;return t.eachChild((t=>{e&&!en(t)&&(e=!1);})),e}function rn(t,e){if(t instanceof Xr&&e.indexOf(t.name)>=0)return !1;let r=!0;return t.eachChild((t=>{r&&!rn(t,e)&&(r=!1);})),r}function nn(t){return {result:"success",value:t}}function sn(t){return {result:"error",value:t}}function an(t){return "data-driven"===t["property-type"]||"cross-faded-data-driven"===t["property-type"]}function on(t){return !!t.expression&&t.expression.parameters.indexOf("zoom")>-1}function ln(t){return !!t.expression&&t.expression.interpolated}function un(t){return t instanceof Number?"number":t instanceof String?"string":t instanceof Boolean?"boolean":Array.isArray(t)?"array":null===t?"null":typeof t}function cn(t){return "object"==typeof t&&null!==t&&!Array.isArray(t)}function hn(t){return t}function pn(t,e){const r="color"===e.type,n=t.stops&&"object"==typeof t.stops[0][0],i=n||!(n||void 0!==t.property),s=t.type||(ln(e)?"exponential":"interval");if(r||"padding"===e.type){const n=r?Kt.parse:Jt.parse;(t=st({},t)).stops&&(t.stops=t.stops.map((t=>[t[0],n(t[1])]))),t.default=n(t.default?t.default:e.default);}if(t.colorSpace&&"rgb"!==(a=t.colorSpace)&&"hcl"!==a&&"lab"!==a)throw new Error(`Unknown color space: "${t.colorSpace}"`);var a;let o,l,u;if("exponential"===s)o=mn;else if("interval"===s)o=yn;else if("categorical"===s){o=dn,l=Object.create(null);for(const e of t.stops)l[e[0]]=e[1];u=typeof t.stops[0][0];}else {if("identity"!==s)throw new Error(`Unknown function type "${s}"`);o=gn;}if(n){const r={},n=[];for(let e=0;e<t.stops.length;e++){const i=t.stops[e],s=i[0].zoom;void 0===r[s]&&(r[s]={zoom:s,type:t.type,property:t.property,default:t.default,stops:[]},n.push(s)),r[s].stops.push([i[0].value,i[1]]);}const i=[];for(const t of n)i.push([r[t].zoom,pn(r[t],e)]);const s={name:"linear"};return {kind:"composite",interpolationType:s,interpolationFactor:Be.interpolationFactor.bind(void 0,s),zoomStops:i.map((t=>t[0])),evaluate:({zoom:r},n)=>mn({stops:i,base:t.base},e,r).evaluate(r,n)}}if(i){const r="exponential"===s?{name:"exponential",base:void 0!==t.base?t.base:1}:null;return {kind:"camera",interpolationType:r,interpolationFactor:Be.interpolationFactor.bind(void 0,r),zoomStops:t.stops.map((t=>t[0])),evaluate:({zoom:r})=>o(t,e,r,l,u)}}return {kind:"source",evaluate(r,n){const i=n&&n.properties?n.properties[t.property]:void 0;return void 0===i?fn(t.default,e.default):o(t,e,i,l,u)}}}function fn(t,e,r){return void 0!==t?t:void 0!==e?e:void 0!==r?r:void 0}function dn(t,e,r,n,i){return fn(typeof r===i?n[r]:void 0,t.default,e.default)}function yn(t,e,r){if("number"!==un(r))return fn(t.default,e.default);const n=t.stops.length;if(1===n)return t.stops[0][1];if(r<=t.stops[0][0])return t.stops[0][1];if(r>=t.stops[n-1][0])return t.stops[n-1][1];const i=_e(t.stops.map((t=>t[0])),r);return t.stops[i][1]}function mn(t,e,r){const n=void 0!==t.base?t.base:1;if("number"!==un(r))return fn(t.default,e.default);const i=t.stops.length;if(1===i)return t.stops[0][1];if(r<=t.stops[0][0])return t.stops[0][1];if(r>=t.stops[i-1][0])return t.stops[i-1][1];const s=_e(t.stops.map((t=>t[0])),r),a=function(t,e,r,n){const i=n-r,s=t-r;return 0===i?0:1===e?s/i:(Math.pow(e,s)-1)/(Math.pow(e,i)-1)}(r,n,t.stops[s][0],t.stops[s+1][0]),o=t.stops[s][1],l=t.stops[s+1][1],u=Ce[e.type]||hn;return "function"==typeof o.evaluate?{evaluate(...e){const r=o.evaluate.apply(void 0,e),n=l.evaluate.apply(void 0,e);if(void 0!==r&&void 0!==n)return u(r,n,a,t.colorSpace)}}:u(o,l,a,t.colorSpace)}function gn(t,e,r){switch(e.type){case"color":r=Kt.parse(r);break;case"formatted":r=Yt.fromString(r.toString());break;case"resolvedImage":r=te.fromString(r.toString());break;case"padding":r=Jt.parse(r);break;default:un(r)===e.type||"enum"===e.type&&e.values[r]||(r=void 0);}return fn(r,t.default,e.default)}Xr.register(Kr,{error:[{kind:"error"},[ct],(t,[e])=>{throw new ae(e.evaluate(t))}],typeof:[ct,[dt],(t,[e])=>wt(ne(e.evaluate(t)))],"to-rgba":[bt(ut,4),[pt],(t,[e])=>{const[r,n,i,s]=e.evaluate(t).rgb;return [255*r,255*n,255*i,s]}],rgb:[pt,[ut,ut,ut],Hr],rgba:[pt,[ut,ut,ut,ut],Hr],has:{type:ht,overloads:[[[ct],(t,[e])=>Yr(e.evaluate(t),t.properties())],[[ct,ft],(t,[e,r])=>Yr(e.evaluate(t),r.evaluate(t))]]},get:{type:dt,overloads:[[[ct],(t,[e])=>Jr(e.evaluate(t),t.properties())],[[ct,ft],(t,[e,r])=>Jr(e.evaluate(t),r.evaluate(t))]]},"feature-state":[dt,[ct],(t,[e])=>Jr(e.evaluate(t),t.featureState||{})],properties:[ft,[],t=>t.properties()],"geometry-type":[ct,[],t=>t.geometryType()],id:[dt,[],t=>t.id()],zoom:[ut,[],t=>t.globals.zoom],"heatmap-density":[ut,[],t=>t.globals.heatmapDensity||0],"line-progress":[ut,[],t=>t.globals.lineProgress||0],accumulated:[dt,[],t=>void 0===t.globals.accumulated?null:t.globals.accumulated],"+":[ut,Wr(ut),(t,e)=>{let r=0;for(const n of e)r+=n.evaluate(t);return r}],"*":[ut,Wr(ut),(t,e)=>{let r=1;for(const n of e)r*=n.evaluate(t);return r}],"-":{type:ut,overloads:[[[ut,ut],(t,[e,r])=>e.evaluate(t)-r.evaluate(t)],[[ut],(t,[e])=>-e.evaluate(t)]]},"/":[ut,[ut,ut],(t,[e,r])=>e.evaluate(t)/r.evaluate(t)],"%":[ut,[ut,ut],(t,[e,r])=>e.evaluate(t)%r.evaluate(t)],ln2:[ut,[],()=>Math.LN2],pi:[ut,[],()=>Math.PI],e:[ut,[],()=>Math.E],"^":[ut,[ut,ut],(t,[e,r])=>Math.pow(e.evaluate(t),r.evaluate(t))],sqrt:[ut,[ut],(t,[e])=>Math.sqrt(e.evaluate(t))],log10:[ut,[ut],(t,[e])=>Math.log(e.evaluate(t))/Math.LN10],ln:[ut,[ut],(t,[e])=>Math.log(e.evaluate(t))],log2:[ut,[ut],(t,[e])=>Math.log(e.evaluate(t))/Math.LN2],sin:[ut,[ut],(t,[e])=>Math.sin(e.evaluate(t))],cos:[ut,[ut],(t,[e])=>Math.cos(e.evaluate(t))],tan:[ut,[ut],(t,[e])=>Math.tan(e.evaluate(t))],asin:[ut,[ut],(t,[e])=>Math.asin(e.evaluate(t))],acos:[ut,[ut],(t,[e])=>Math.acos(e.evaluate(t))],atan:[ut,[ut],(t,[e])=>Math.atan(e.evaluate(t))],min:[ut,Wr(ut),(t,e)=>Math.min(...e.map((e=>e.evaluate(t))))],max:[ut,Wr(ut),(t,e)=>Math.max(...e.map((e=>e.evaluate(t))))],abs:[ut,[ut],(t,[e])=>Math.abs(e.evaluate(t))],round:[ut,[ut],(t,[e])=>{const r=e.evaluate(t);return r<0?-Math.round(-r):Math.round(r)}],floor:[ut,[ut],(t,[e])=>Math.floor(e.evaluate(t))],ceil:[ut,[ut],(t,[e])=>Math.ceil(e.evaluate(t))],"filter-==":[ht,[ct,dt],(t,[e,r])=>t.properties()[e.value]===r.value],"filter-id-==":[ht,[dt],(t,[e])=>t.id()===e.value],"filter-type-==":[ht,[ct],(t,[e])=>t.geometryType()===e.value],"filter-<":[ht,[ct,dt],(t,[e,r])=>{const n=t.properties()[e.value],i=r.value;return typeof n==typeof i&&n<i}],"filter-id-<":[ht,[dt],(t,[e])=>{const r=t.id(),n=e.value;return typeof r==typeof n&&r<n}],"filter->":[ht,[ct,dt],(t,[e,r])=>{const n=t.properties()[e.value],i=r.value;return typeof n==typeof i&&n>i}],"filter-id->":[ht,[dt],(t,[e])=>{const r=t.id(),n=e.value;return typeof r==typeof n&&r>n}],"filter-<=":[ht,[ct,dt],(t,[e,r])=>{const n=t.properties()[e.value],i=r.value;return typeof n==typeof i&&n<=i}],"filter-id-<=":[ht,[dt],(t,[e])=>{const r=t.id(),n=e.value;return typeof r==typeof n&&r<=n}],"filter->=":[ht,[ct,dt],(t,[e,r])=>{const n=t.properties()[e.value],i=r.value;return typeof n==typeof i&&n>=i}],"filter-id->=":[ht,[dt],(t,[e])=>{const r=t.id(),n=e.value;return typeof r==typeof n&&r>=n}],"filter-has":[ht,[dt],(t,[e])=>e.value in t.properties()],"filter-has-id":[ht,[],t=>null!==t.id()&&void 0!==t.id()],"filter-type-in":[ht,[bt(ct)],(t,[e])=>e.value.indexOf(t.geometryType())>=0],"filter-id-in":[ht,[bt(dt)],(t,[e])=>e.value.indexOf(t.id())>=0],"filter-in-small":[ht,[ct,bt(dt)],(t,[e,r])=>r.value.indexOf(t.properties()[e.value])>=0],"filter-in-large":[ht,[ct,bt(dt)],(t,[e,r])=>function(t,e,r,n){for(;r<=n;){const i=r+n>>1;if(e[i]===t)return !0;e[i]>t?n=i-1:r=i+1;}return !1}(t.properties()[e.value],r.value,0,r.value.length-1)],all:{type:ht,overloads:[[[ht,ht],(t,[e,r])=>e.evaluate(t)&&r.evaluate(t)],[Wr(ht),(t,e)=>{for(const r of e)if(!r.evaluate(t))return !1;return !0}]]},any:{type:ht,overloads:[[[ht,ht],(t,[e,r])=>e.evaluate(t)||r.evaluate(t)],[Wr(ht),(t,e)=>{for(const r of e)if(r.evaluate(t))return !0;return !1}]]},"!":[ht,[ht],(t,[e])=>!e.evaluate(t)],"is-supported-script":[ht,[ct],(t,[e])=>{const r=t.globals&&t.globals.isSupportedScript;return !r||r(e.evaluate(t))}],upcase:[ct,[ct],(t,[e])=>e.evaluate(t).toUpperCase()],downcase:[ct,[ct],(t,[e])=>e.evaluate(t).toLowerCase()],concat:[ct,Wr(dt),(t,e)=>e.map((e=>ie(e.evaluate(t)))).join("")],"resolved-locale":[ct,[yt],(t,[e])=>e.evaluate(t).resolvedLocale()]});class xn{constructor(t,e){var r;this.expression=t,this._warningHistory={},this._evaluator=new pe,this._defaultValue=e?"color"===(r=e).type&&cn(r.default)?new Kt(0,0,0,0):"color"===r.type?Kt.parse(r.default)||null:"padding"===r.type?Jt.parse(r.default)||null:"variableAnchorOffsetCollection"===r.type?Qt.parse(r.default)||null:void 0===r.default?null:r.default:null,this._enumValues=e&&"enum"===e.type?e.values:null;}evaluateWithoutErrorHandling(t,e,r,n,i,s){return this._evaluator.globals=t,this._evaluator.feature=e,this._evaluator.featureState=r,this._evaluator.canonical=n,this._evaluator.availableImages=i||null,this._evaluator.formattedSection=s,this.expression.evaluate(this._evaluator)}evaluate(t,e,r,n,i,s){this._evaluator.globals=t,this._evaluator.feature=e||null,this._evaluator.featureState=r||null,this._evaluator.canonical=n,this._evaluator.availableImages=i||null,this._evaluator.formattedSection=s||null;try{const t=this.expression.evaluate(this._evaluator);if(null==t||"number"==typeof t&&t!=t)return this._defaultValue;if(this._enumValues&&!(t in this._enumValues))throw new ae(`Expected value to be one of ${Object.keys(this._enumValues).map((t=>JSON.stringify(t))).join(", ")}, but found ${JSON.stringify(t)} instead.`);return t}catch(t){return this._warningHistory[t.message]||(this._warningHistory[t.message]=!0,"undefined"!=typeof console&&console.warn(t.message)),this._defaultValue}}}function vn(t){return Array.isArray(t)&&t.length>0&&"string"==typeof t[0]&&t[0]in Kr}function bn(t,e){const r=new fe(Kr,Qr,[],e?function(t){const e={color:pt,string:ct,number:ut,enum:ct,boolean:ht,formatted:mt,padding:gt,resolvedImage:xt,variableAnchorOffsetCollection:vt};return "array"===t.type?bt(e[t.value]||dt,t.length):e[t.type]}(e):void 0),n=r.parse(t,void 0,void 0,void 0,e&&"string"===e.type?{typeAnnotation:"coerce"}:void 0);return n?nn(new xn(n,e)):sn(r.errors)}class wn{constructor(t,e){this.kind=t,this._styleExpression=e,this.isStateDependent="constant"!==t&&!en(e.expression);}evaluateWithoutErrorHandling(t,e,r,n,i,s){return this._styleExpression.evaluateWithoutErrorHandling(t,e,r,n,i,s)}evaluate(t,e,r,n,i,s){return this._styleExpression.evaluate(t,e,r,n,i,s)}}class _n{constructor(t,e,r,n){this.kind=t,this.zoomStops=r,this._styleExpression=e,this.isStateDependent="camera"!==t&&!en(e.expression),this.interpolationType=n;}evaluateWithoutErrorHandling(t,e,r,n,i,s){return this._styleExpression.evaluateWithoutErrorHandling(t,e,r,n,i,s)}evaluate(t,e,r,n,i,s){return this._styleExpression.evaluate(t,e,r,n,i,s)}interpolationFactor(t,e,r){return this.interpolationType?Be.interpolationFactor(this.interpolationType,t,e,r):0}}function An(t,e){const r=bn(t,e);if("error"===r.result)return r;const n=r.value.expression,i=tn(n);if(!i&&!an(e))return sn([new at("","data expressions not supported")]);const s=rn(n,["zoom"]);if(!s&&!on(e))return sn([new at("","zoom expressions not supported")]);const a=kn(n);return a||s?a instanceof at?sn([a]):a instanceof Be&&!ln(e)?sn([new at("",'"interpolate" expressions cannot be used with this property')]):nn(a?new _n(i?"camera":"composite",r.value,a.labels,a instanceof Be?a.interpolation:void 0):new wn(i?"constant":"source",r.value)):sn([new at("",'"zoom" expression may only be used as input to a top-level "step" or "interpolate" expression.')])}class Sn{constructor(t,e){this._parameters=t,this._specification=e,st(this,pn(this._parameters,this._specification));}static deserialize(t){return new Sn(t._parameters,t._specification)}static serialize(t){return {_parameters:t._parameters,_specification:t._specification}}}function kn(t){let e=null;if(t instanceof de)e=kn(t.result);else if(t instanceof Ee){for(const r of t.args)if(e=kn(r),e)break}else (t instanceof Ae||t instanceof Be)&&t.input instanceof Xr&&"zoom"===t.input.name&&(e=t);return e instanceof at||t.eachChild((t=>{const r=kn(t);r instanceof at?e=r:!e&&r?e=new at("",'"zoom" expression may only be used as input to a top-level "step" or "interpolate" expression.'):e&&r&&e!==r&&(e=new at("",'Only one zoom-based "step" or "interpolate" subexpression may be used in an expression.'));})),e}function Mn(t){if(!0===t||!1===t)return !0;if(!Array.isArray(t)||0===t.length)return !1;switch(t[0]){case"has":return t.length>=2&&"$id"!==t[1]&&"$type"!==t[1];case"in":return t.length>=3&&("string"!=typeof t[1]||Array.isArray(t[2]));case"!in":case"!has":case"none":return !1;case"==":case"!=":case">":case">=":case"<":case"<=":return 3!==t.length||Array.isArray(t[1])||Array.isArray(t[2]);case"any":case"all":for(const e of t.slice(1))if(!Mn(e)&&"boolean"!=typeof e)return !1;return !0;default:return !0}}const In={type:"boolean",default:!1,transition:!1,"property-type":"data-driven",expression:{interpolated:!1,parameters:["zoom","feature"]}};function zn(t){if(null==t)return {filter:()=>!0,needGeometry:!1};Mn(t)||(t=Bn(t));const e=bn(t,In);if("error"===e.result)throw new Error(e.value.map((t=>`${t.key}: ${t.message}`)).join(", "));return {filter:(t,r,n)=>e.value.evaluate(t,r,{},n),needGeometry:Cn(t)}}function Pn(t,e){return t<e?-1:t>e?1:0}function Cn(t){if(!Array.isArray(t))return !1;if("within"===t[0]||"distance"===t[0])return !0;for(let e=1;e<t.length;e++)if(Cn(t[e]))return !0;return !1}function Bn(t){if(!t)return !0;const e=t[0];return t.length<=1?"any"!==e:"=="===e?Vn(t[1],t[2],"=="):"!="===e?Tn(Vn(t[1],t[2],"==")):"<"===e||">"===e||"<="===e||">="===e?Vn(t[1],t[2],e):"any"===e?(r=t.slice(1),["any"].concat(r.map(Bn))):"all"===e?["all"].concat(t.slice(1).map(Bn)):"none"===e?["all"].concat(t.slice(1).map(Bn).map(Tn)):"in"===e?En(t[1],t.slice(2)):"!in"===e?Tn(En(t[1],t.slice(2))):"has"===e?Fn(t[1]):"!has"!==e||Tn(Fn(t[1]));var r;}function Vn(t,e,r){switch(t){case"$type":return [`filter-type-${r}`,e];case"$id":return [`filter-id-${r}`,e];default:return [`filter-${r}`,t,e]}}function En(t,e){if(0===e.length)return !1;switch(t){case"$type":return ["filter-type-in",["literal",e]];case"$id":return ["filter-id-in",["literal",e]];default:return e.length>200&&!e.some((t=>typeof t!=typeof e[0]))?["filter-in-large",t,["literal",e.sort(Pn)]]:["filter-in-small",t,["literal",e]]}}function Fn(t){switch(t){case"$type":return !0;case"$id":return ["filter-has-id"];default:return ["filter-has",t]}}function Tn(t){return ["!",t]}function $n(t){const e=typeof t;if("number"===e||"boolean"===e||"string"===e||null==t)return JSON.stringify(t);if(Array.isArray(t)){let e="[";for(const r of t)e+=`${$n(r)},`;return `${e}]`}const r=Object.keys(t).sort();let n="{";for(let e=0;e<r.length;e++)n+=`${JSON.stringify(r[e])}:${$n(t[r[e]])},`;return `${n}}`}function Ln(t){let e="";for(const r of K)e+=`/${$n(t[r])}`;return e}function Dn(t){const e=t.value;return e?[new it(t.key,e,"constants have been deprecated as of v8")]:[]}function On(t){return t instanceof Number||t instanceof String||t instanceof Boolean?t.valueOf():t}function jn(t){if(Array.isArray(t))return t.map(jn);if(t instanceof Object&&!(t instanceof Number||t instanceof String||t instanceof Boolean)){const e={};for(const r in t)e[r]=jn(t[r]);return e}return On(t)}function Rn(t){const e=t.key,r=t.value,n=t.valueSpec||{},i=t.objectElementValidators||{},s=t.style,a=t.styleSpec,o=t.validateSpec;let l=[];const u=un(r);if("object"!==u)return [new it(e,r,`object expected, ${u} found`)];for(const t in r){const u=t.split(".")[0],c=n[u]||n["*"];let h;if(i[u])h=i[u];else if(n[u])h=o;else if(i["*"])h=i["*"];else {if(!n["*"]){l.push(new it(e,r[t],`unknown property "${t}"`));continue}h=o;}l=l.concat(h({key:(e?`${e}.`:e)+t,value:r[t],valueSpec:c,style:s,styleSpec:a,object:r,objectKey:t,validateSpec:o},r));}for(const t in n)i[t]||n[t].required&&void 0===n[t].default&&void 0===r[t]&&l.push(new it(e,r,`missing required property "${t}"`));return l}function Un(t){const e=t.value,r=t.valueSpec,n=t.style,i=t.styleSpec,s=t.key,a=t.arrayElementValidator||t.validateSpec;if("array"!==un(e))return [new it(s,e,`array expected, ${un(e)} found`)];if(r.length&&e.length!==r.length)return [new it(s,e,`array length ${r.length} expected, length ${e.length} found`)];if(r["min-length"]&&e.length<r["min-length"])return [new it(s,e,`array length at least ${r["min-length"]} expected, length ${e.length} found`)];let o={type:r.value,values:r.values};i.$version<7&&(o.function=r.function),"object"===un(r.value)&&(o=r.value);let l=[];for(let r=0;r<e.length;r++)l=l.concat(a({array:e,arrayIndex:r,value:e[r],valueSpec:o,validateSpec:t.validateSpec,style:n,styleSpec:i,key:`${s}[${r}]`}));return l}function qn(t){const e=t.key,r=t.value,n=t.valueSpec;let i=un(r);return "number"===i&&r!=r&&(i="NaN"),"number"!==i?[new it(e,r,`number expected, ${i} found`)]:"minimum"in n&&r<n.minimum?[new it(e,r,`${r} is less than the minimum value ${n.minimum}`)]:"maximum"in n&&r>n.maximum?[new it(e,r,`${r} is greater than the maximum value ${n.maximum}`)]:[]}function Nn(t){const e=t.valueSpec,r=On(t.value.type);let n,i,s,a={};const o="categorical"!==r&&void 0===t.value.property,l=!o,u="array"===un(t.value.stops)&&"array"===un(t.value.stops[0])&&"object"===un(t.value.stops[0][0]),c=Rn({key:t.key,value:t.value,valueSpec:t.styleSpec.function,validateSpec:t.validateSpec,style:t.style,styleSpec:t.styleSpec,objectElementValidators:{stops:function(t){if("identity"===r)return [new it(t.key,t.value,'identity function may not have a "stops" property')];let e=[];const n=t.value;return e=e.concat(Un({key:t.key,value:n,valueSpec:t.valueSpec,validateSpec:t.validateSpec,style:t.style,styleSpec:t.styleSpec,arrayElementValidator:h})),"array"===un(n)&&0===n.length&&e.push(new it(t.key,n,"array must have at least one stop")),e},default:function(t){return t.validateSpec({key:t.key,value:t.value,valueSpec:e,validateSpec:t.validateSpec,style:t.style,styleSpec:t.styleSpec})}}});return "identity"===r&&o&&c.push(new it(t.key,t.value,'missing required property "property"')),"identity"===r||t.value.stops||c.push(new it(t.key,t.value,'missing required property "stops"')),"exponential"===r&&t.valueSpec.expression&&!ln(t.valueSpec)&&c.push(new it(t.key,t.value,"exponential functions not supported")),t.styleSpec.$version>=8&&(l&&!an(t.valueSpec)?c.push(new it(t.key,t.value,"property functions not supported")):o&&!on(t.valueSpec)&&c.push(new it(t.key,t.value,"zoom functions not supported"))),"categorical"!==r&&!u||void 0!==t.value.property||c.push(new it(t.key,t.value,'"property" property is required')),c;function h(t){let r=[];const n=t.value,o=t.key;if("array"!==un(n))return [new it(o,n,`array expected, ${un(n)} found`)];if(2!==n.length)return [new it(o,n,`array length 2 expected, length ${n.length} found`)];if(u){if("object"!==un(n[0]))return [new it(o,n,`object expected, ${un(n[0])} found`)];if(void 0===n[0].zoom)return [new it(o,n,"object stop key must have zoom")];if(void 0===n[0].value)return [new it(o,n,"object stop key must have value")];if(s&&s>On(n[0].zoom))return [new it(o,n[0].zoom,"stop zoom values must appear in ascending order")];On(n[0].zoom)!==s&&(s=On(n[0].zoom),i=void 0,a={}),r=r.concat(Rn({key:`${o}[0]`,value:n[0],valueSpec:{zoom:{}},validateSpec:t.validateSpec,style:t.style,styleSpec:t.styleSpec,objectElementValidators:{zoom:qn,value:p}}));}else r=r.concat(p({key:`${o}[0]`,value:n[0],valueSpec:{},validateSpec:t.validateSpec,style:t.style,styleSpec:t.styleSpec},n));return vn(jn(n[1]))?r.concat([new it(`${o}[1]`,n[1],"expressions are not allowed in function stops.")]):r.concat(t.validateSpec({key:`${o}[1]`,value:n[1],valueSpec:e,validateSpec:t.validateSpec,style:t.style,styleSpec:t.styleSpec}))}function p(t,s){const o=un(t.value),l=On(t.value),u=null!==t.value?t.value:s;if(n){if(o!==n)return [new it(t.key,u,`${o} stop domain type must match previous stop domain type ${n}`)]}else n=o;if("number"!==o&&"string"!==o&&"boolean"!==o)return [new it(t.key,u,"stop domain value must be a number, string, or boolean")];if("number"!==o&&"categorical"!==r){let n=`number expected, ${o} found`;return an(e)&&void 0===r&&(n+='\nIf you intended to use a categorical function, specify `"type": "categorical"`.'),[new it(t.key,u,n)]}return "categorical"!==r||"number"!==o||isFinite(l)&&Math.floor(l)===l?"categorical"!==r&&"number"===o&&void 0!==i&&l<i?[new it(t.key,u,"stop domain values must appear in ascending order")]:(i=l,"categorical"===r&&l in a?[new it(t.key,u,"stop domain values must be unique")]:(a[l]=!0,[])):[new it(t.key,u,`integer expected, found ${l}`)]}}function Zn(t){const e=("property"===t.expressionContext?An:bn)(jn(t.value),t.valueSpec);if("error"===e.result)return e.value.map((e=>new it(`${t.key}${e.key}`,t.value,e.message)));const r=e.value.expression||e.value._styleExpression.expression;if("property"===t.expressionContext&&"text-font"===t.propertyKey&&!r.outputDefined())return [new it(t.key,t.value,`Invalid data expression for "${t.propertyKey}". Output values must be contained as literals within the expression.`)];if("property"===t.expressionContext&&"layout"===t.propertyType&&!en(r))return [new it(t.key,t.value,'"feature-state" data expressions are not supported with layout properties.')];if("filter"===t.expressionContext&&!en(r))return [new it(t.key,t.value,'"feature-state" data expressions are not supported with filters.')];if(t.expressionContext&&0===t.expressionContext.indexOf("cluster")){if(!rn(r,["zoom","feature-state"]))return [new it(t.key,t.value,'"zoom" and "feature-state" expressions are not supported with cluster properties.')];if("cluster-initial"===t.expressionContext&&!tn(r))return [new it(t.key,t.value,"Feature data expressions are not supported with initial expression part of cluster properties.")]}return []}function Gn(t){const e=t.key,r=t.value,n=t.valueSpec,i=[];return Array.isArray(n.values)?-1===n.values.indexOf(On(r))&&i.push(new it(e,r,`expected one of [${n.values.join(", ")}], ${JSON.stringify(r)} found`)):-1===Object.keys(n.values).indexOf(On(r))&&i.push(new it(e,r,`expected one of [${Object.keys(n.values).join(", ")}], ${JSON.stringify(r)} found`)),i}function Kn(t){return Mn(jn(t.value))?Zn(st({},t,{expressionContext:"filter",valueSpec:{value:"boolean"}})):Xn(t)}function Xn(t){const e=t.value,r=t.key;if("array"!==un(e))return [new it(r,e,`array expected, ${un(e)} found`)];const n=t.styleSpec;let i,s=[];if(e.length<1)return [new it(r,e,"filter array must have at least 1 element")];switch(s=s.concat(Gn({key:`${r}[0]`,value:e[0],valueSpec:n.filter_operator,style:t.style,styleSpec:t.styleSpec})),On(e[0])){case"<":case"<=":case">":case">=":e.length>=2&&"$type"===On(e[1])&&s.push(new it(r,e,`"$type" cannot be use with operator "${e[0]}"`));case"==":case"!=":3!==e.length&&s.push(new it(r,e,`filter array for operator "${e[0]}" must have 3 elements`));case"in":case"!in":e.length>=2&&(i=un(e[1]),"string"!==i&&s.push(new it(`${r}[1]`,e[1],`string expected, ${i} found`)));for(let a=2;a<e.length;a++)i=un(e[a]),"$type"===On(e[1])?s=s.concat(Gn({key:`${r}[${a}]`,value:e[a],valueSpec:n.geometry_type,style:t.style,styleSpec:t.styleSpec})):"string"!==i&&"number"!==i&&"boolean"!==i&&s.push(new it(`${r}[${a}]`,e[a],`string, number, or boolean expected, ${i} found`));break;case"any":case"all":case"none":for(let n=1;n<e.length;n++)s=s.concat(Xn({key:`${r}[${n}]`,value:e[n],style:t.style,styleSpec:t.styleSpec}));break;case"has":case"!has":i=un(e[1]),2!==e.length?s.push(new it(r,e,`filter array for "${e[0]}" operator must have 2 elements`)):"string"!==i&&s.push(new it(`${r}[1]`,e[1],`string expected, ${i} found`));}return s}function Hn(t,e){const r=t.key,n=t.validateSpec,i=t.style,s=t.styleSpec,a=t.value,o=t.objectKey,l=s[`${e}_${t.layerType}`];if(!l)return [];const u=o.match(/^(.*)-transition$/);if("paint"===e&&u&&l[u[1]]&&l[u[1]].transition)return n({key:r,value:a,valueSpec:s.transition,style:i,styleSpec:s});const c=t.valueSpec||l[o];if(!c)return [new it(r,a,`unknown property "${o}"`)];let h;if("string"===un(a)&&an(c)&&!c.tokens&&(h=/^{([^}]+)}$/.exec(a)))return [new it(r,a,`"${o}" does not support interpolation syntax\nUse an identity property function instead: \`{ "type": "identity", "property": ${JSON.stringify(h[1])} }\`.`)];const p=[];return "symbol"===t.layerType&&("text-field"===o&&i&&!i.glyphs&&p.push(new it(r,a,'use of "text-field" requires a style "glyphs" property')),"text-font"===o&&cn(jn(a))&&"identity"===On(a.type)&&p.push(new it(r,a,'"text-font" does not support identity functions'))),p.concat(n({key:t.key,value:a,valueSpec:c,style:i,styleSpec:s,expressionContext:"property",propertyType:e,propertyKey:o}))}function Yn(t){return Hn(t,"paint")}function Jn(t){return Hn(t,"layout")}function Wn(t){let e=[];const r=t.value,n=t.key,i=t.style,s=t.styleSpec;r.type||r.ref||e.push(new it(n,r,'either "type" or "ref" is required'));let a=On(r.type);const o=On(r.ref);if(r.id){const s=On(r.id);for(let a=0;a<t.arrayIndex;a++){const t=i.layers[a];On(t.id)===s&&e.push(new it(n,r.id,`duplicate layer id "${r.id}", previously used at line ${t.id.__line__}`));}}if("ref"in r){let t;["type","source","source-layer","filter","layout"].forEach((t=>{t in r&&e.push(new it(n,r[t],`"${t}" is prohibited for ref layers`));})),i.layers.forEach((e=>{On(e.id)===o&&(t=e);})),t?t.ref?e.push(new it(n,r.ref,"ref cannot reference another ref layer")):a=On(t.type):e.push(new it(n,r.ref,`ref layer "${o}" not found`));}else if("background"!==a)if(r.source){const t=i.sources&&i.sources[r.source],s=t&&On(t.type);t?"vector"===s&&"raster"===a?e.push(new it(n,r.source,`layer "${r.id}" requires a raster source`)):"raster-dem"!==s&&"hillshade"===a?e.push(new it(n,r.source,`layer "${r.id}" requires a raster-dem source`)):"raster"===s&&"raster"!==a?e.push(new it(n,r.source,`layer "${r.id}" requires a vector source`)):"vector"!==s||r["source-layer"]?"raster-dem"===s&&"hillshade"!==a?e.push(new it(n,r.source,"raster-dem source can only be used with layer type 'hillshade'.")):"line"!==a||!r.paint||!r.paint["line-gradient"]||"geojson"===s&&t.lineMetrics||e.push(new it(n,r,`layer "${r.id}" specifies a line-gradient, which requires a GeoJSON source with \`lineMetrics\` enabled.`)):e.push(new it(n,r,`layer "${r.id}" must specify a "source-layer"`)):e.push(new it(n,r.source,`source "${r.source}" not found`));}else e.push(new it(n,r,'missing required property "source"'));return e=e.concat(Rn({key:n,value:r,valueSpec:s.layer,style:t.style,styleSpec:t.styleSpec,validateSpec:t.validateSpec,objectElementValidators:{"*":()=>[],type:()=>t.validateSpec({key:`${n}.type`,value:r.type,valueSpec:s.layer.type,style:t.style,styleSpec:t.styleSpec,validateSpec:t.validateSpec,object:r,objectKey:"type"}),filter:Kn,layout:t=>Rn({layer:r,key:t.key,value:t.value,style:t.style,styleSpec:t.styleSpec,validateSpec:t.validateSpec,objectElementValidators:{"*":t=>Jn(st({layerType:a},t))}}),paint:t=>Rn({layer:r,key:t.key,value:t.value,style:t.style,styleSpec:t.styleSpec,validateSpec:t.validateSpec,objectElementValidators:{"*":t=>Yn(st({layerType:a},t))}})}})),e}function Qn(t){const e=t.value,r=t.key,n=un(e);return "string"!==n?[new it(r,e,`string expected, ${n} found`)]:[]}const ti={promoteId:function({key:t,value:e}){if("string"===un(e))return Qn({key:t,value:e});{const r=[];for(const n in e)r.push(...Qn({key:`${t}.${n}`,value:e[n]}));return r}}};function ei(t){const e=t.value,r=t.key,n=t.styleSpec,i=t.style,s=t.validateSpec;if(!e.type)return [new it(r,e,'"type" is required')];const a=On(e.type);let o;switch(a){case"vector":case"raster":return o=Rn({key:r,value:e,valueSpec:n[`source_${a.replace("-","_")}`],style:t.style,styleSpec:n,objectElementValidators:ti,validateSpec:s}),o;case"raster-dem":return o=function(t){var e;const r=null!==(e=t.sourceName)&&void 0!==e?e:"",n=t.value,i=t.styleSpec,s=i.source_raster_dem,a=t.style;let o=[];const l=un(n);if(void 0===n)return o;if("object"!==l)return o.push(new it("source_raster_dem",n,`object expected, ${l} found`)),o;const u="custom"===On(n.encoding),c=["redFactor","greenFactor","blueFactor","baseShift"],h=t.value.encoding?`"${t.value.encoding}"`:"Default";for(const e in n)!u&&c.includes(e)?o.push(new it(e,n[e],`In "${r}": "${e}" is only valid when "encoding" is set to "custom". ${h} encoding found`)):s[e]?o=o.concat(t.validateSpec({key:e,value:n[e],valueSpec:s[e],validateSpec:t.validateSpec,style:a,styleSpec:i})):o.push(new it(e,n[e],`unknown property "${e}"`));return o}({sourceName:r,value:e,style:t.style,styleSpec:n,validateSpec:s}),o;case"geojson":if(o=Rn({key:r,value:e,valueSpec:n.source_geojson,style:i,styleSpec:n,validateSpec:s,objectElementValidators:ti}),e.cluster)for(const t in e.clusterProperties){const[n,i]=e.clusterProperties[t],a="string"==typeof n?[n,["accumulated"],["get",t]]:n;o.push(...Zn({key:`${r}.${t}.map`,value:i,validateSpec:s,expressionContext:"cluster-map"})),o.push(...Zn({key:`${r}.${t}.reduce`,value:a,validateSpec:s,expressionContext:"cluster-reduce"}));}return o;case"video":return Rn({key:r,value:e,valueSpec:n.source_video,style:i,validateSpec:s,styleSpec:n});case"image":return Rn({key:r,value:e,valueSpec:n.source_image,style:i,validateSpec:s,styleSpec:n});case"canvas":return [new it(r,null,"Please use runtime APIs to add canvas sources, rather than including them in stylesheets.","source.canvas")];default:return Gn({key:`${r}.type`,value:e.type,valueSpec:{values:["vector","raster","raster-dem","geojson","video","image"]},style:i,validateSpec:s,styleSpec:n})}}function ri(t){const e=t.value,r=t.styleSpec,n=r.light,i=t.style;let s=[];const a=un(e);if(void 0===e)return s;if("object"!==a)return s=s.concat([new it("light",e,`object expected, ${a} found`)]),s;for(const a in e){const o=a.match(/^(.*)-transition$/);s=s.concat(o&&n[o[1]]&&n[o[1]].transition?t.validateSpec({key:a,value:e[a],valueSpec:r.transition,validateSpec:t.validateSpec,style:i,styleSpec:r}):n[a]?t.validateSpec({key:a,value:e[a],valueSpec:n[a],validateSpec:t.validateSpec,style:i,styleSpec:r}):[new it(a,e[a],`unknown property "${a}"`)]);}return s}function ni(t){const e=t.value,r=t.styleSpec,n=r.sky,i=t.style,s=un(e);if(void 0===e)return [];if("object"!==s)return [new it("sky",e,`object expected, ${s} found`)];let a=[];for(const s in e)a=a.concat(n[s]?t.validateSpec({key:s,value:e[s],valueSpec:n[s],style:i,styleSpec:r}):[new it(s,e[s],`unknown property "${s}"`)]);return a}function ii(t){const e=t.value,r=t.styleSpec,n=r.terrain,i=t.style;let s=[];const a=un(e);if(void 0===e)return s;if("object"!==a)return s=s.concat([new it("terrain",e,`object expected, ${a} found`)]),s;for(const a in e)s=s.concat(n[a]?t.validateSpec({key:a,value:e[a],valueSpec:n[a],validateSpec:t.validateSpec,style:i,styleSpec:r}):[new it(a,e[a],`unknown property "${a}"`)]);return s}function si(t){let e=[];const r=t.value,n=t.key;if(Array.isArray(r)){const i=[],s=[];for(const a in r)r[a].id&&i.includes(r[a].id)&&e.push(new it(n,r,`all the sprites' ids must be unique, but ${r[a].id} is duplicated`)),i.push(r[a].id),r[a].url&&s.includes(r[a].url)&&e.push(new it(n,r,`all the sprites' URLs must be unique, but ${r[a].url} is duplicated`)),s.push(r[a].url),e=e.concat(Rn({key:`${n}[${a}]`,value:r[a],valueSpec:{id:{type:"string",required:!0},url:{type:"string",required:!0}},validateSpec:t.validateSpec}));return e}return Qn({key:n,value:r})}const ai={"*":()=>[],array:Un,boolean:function(t){const e=t.value,r=t.key,n=un(e);return "boolean"!==n?[new it(r,e,`boolean expected, ${n} found`)]:[]},number:qn,color:function(t){const e=t.key,r=t.value,n=un(r);return "string"!==n?[new it(e,r,`color expected, ${n} found`)]:Kt.parse(String(r))?[]:[new it(e,r,`color expected, "${r}" found`)]},constants:Dn,enum:Gn,filter:Kn,function:Nn,layer:Wn,object:Rn,source:ei,light:ri,sky:ni,terrain:ii,projection:function(t){const e=t.value,r=t.styleSpec,n=r.projection,i=t.style,s=un(e);if(void 0===e)return [];if("object"!==s)return [new it("projection",e,`object expected, ${s} found`)];let a=[];for(const s in e)a=a.concat(n[s]?t.validateSpec({key:s,value:e[s],valueSpec:n[s],style:i,styleSpec:r}):[new it(s,e[s],`unknown property "${s}"`)]);return a},string:Qn,formatted:function(t){return 0===Qn(t).length?[]:Zn(t)},resolvedImage:function(t){return 0===Qn(t).length?[]:Zn(t)},padding:function(t){const e=t.key,r=t.value;if("array"===un(r)){if(r.length<1||r.length>4)return [new it(e,r,`padding requires 1 to 4 values; ${r.length} values found`)];const n={type:"number"};let i=[];for(let s=0;s<r.length;s++)i=i.concat(t.validateSpec({key:`${e}[${s}]`,value:r[s],validateSpec:t.validateSpec,valueSpec:n}));return i}return qn({key:e,value:r,valueSpec:{}})},variableAnchorOffsetCollection:function(t){const e=t.key,r=t.value,n=un(r),i=t.styleSpec;if("array"!==n||r.length<1||r.length%2!=0)return [new it(e,r,"variableAnchorOffsetCollection requires a non-empty array of even length")];let s=[];for(let n=0;n<r.length;n+=2)s=s.concat(Gn({key:`${e}[${n}]`,value:r[n],valueSpec:i.layout_symbol["text-anchor"]})),s=s.concat(Un({key:`${e}[${n+1}]`,value:r[n+1],valueSpec:{length:2,value:"number"},validateSpec:t.validateSpec,style:t.style,styleSpec:i}));return s},sprite:si};function oi(t){const e=t.value,r=t.valueSpec,n=t.styleSpec;return t.validateSpec=oi,r.expression&&cn(On(e))?Nn(t):r.expression&&vn(jn(e))?Zn(t):r.type&&ai[r.type]?ai[r.type](t):Rn(st({},t,{valueSpec:r.type?n[r.type]:r}))}function li(t){const e=t.value,r=t.key,n=Qn(t);return n.length||(-1===e.indexOf("{fontstack}")&&n.push(new it(r,e,'"glyphs" url must include a "{fontstack}" token')),-1===e.indexOf("{range}")&&n.push(new it(r,e,'"glyphs" url must include a "{range}" token'))),n}function ui(t,e=G){let r=[];return r=r.concat(oi({key:"",value:t,valueSpec:e.$root,styleSpec:e,style:t,validateSpec:oi,objectElementValidators:{glyphs:li,"*":()=>[]}})),t.constants&&(r=r.concat(Dn({key:"constants",value:t.constants,style:t,styleSpec:e,validateSpec:oi}))),hi(r)}function ci(t){return function(e){return t({...e,validateSpec:oi})}}function hi(t){return [].concat(t).sort(((t,e)=>t.line-e.line))}function pi(t){return function(...e){return hi(t.apply(this,e))}}ui.source=pi(ci(ei)),ui.sprite=pi(ci(si)),ui.glyphs=pi(ci(li)),ui.light=pi(ci(ri)),ui.sky=pi(ci(ni)),ui.terrain=pi(ci(ii)),ui.layer=pi(ci(Wn)),ui.filter=pi(ci(Kn)),ui.paintProperty=pi(ci(Yn)),ui.layoutProperty=pi(ci(Jn));const fi=ui,di=fi.light,yi=fi.sky,mi=fi.paintProperty,gi=fi.layoutProperty;function xi(t,e){let r=!1;if(e&&e.length)for(const n of e)t.fire(new N(new Error(n.message))),r=!0;return r}class vi{constructor(t,e,r){const n=this.cells=[];if(t instanceof ArrayBuffer){this.arrayBuffer=t;const i=new Int32Array(this.arrayBuffer);t=i[0],this.d=(e=i[1])+2*(r=i[2]);for(let t=0;t<this.d*this.d;t++){const e=i[3+t],r=i[3+t+1];n.push(e===r?null:i.subarray(e,r));}const s=i[3+n.length+1];this.keys=i.subarray(i[3+n.length],s),this.bboxes=i.subarray(s),this.insert=this._insertReadonly;}else {this.d=e+2*r;for(let t=0;t<this.d*this.d;t++)n.push([]);this.keys=[],this.bboxes=[];}this.n=e,this.extent=t,this.padding=r,this.scale=e/t,this.uid=0;const i=r/e*t;this.min=-i,this.max=t+i;}insert(t,e,r,n,i){this._forEachCell(e,r,n,i,this._insertCell,this.uid++,void 0,void 0),this.keys.push(t),this.bboxes.push(e),this.bboxes.push(r),this.bboxes.push(n),this.bboxes.push(i);}_insertReadonly(){throw new Error("Cannot insert into a GridIndex created from an ArrayBuffer.")}_insertCell(t,e,r,n,i,s){this.cells[i].push(s);}query(t,e,r,n,i){const s=this.min,a=this.max;if(t<=s&&e<=s&&a<=r&&a<=n&&!i)return Array.prototype.slice.call(this.keys);{const s=[];return this._forEachCell(t,e,r,n,this._queryCell,s,{},i),s}}_queryCell(t,e,r,n,i,s,a,o){const l=this.cells[i];if(null!==l){const i=this.keys,u=this.bboxes;for(let c=0;c<l.length;c++){const h=l[c];if(void 0===a[h]){const l=4*h;(o?o(u[l+0],u[l+1],u[l+2],u[l+3]):t<=u[l+2]&&e<=u[l+3]&&r>=u[l+0]&&n>=u[l+1])?(a[h]=!0,s.push(i[h])):a[h]=!1;}}}}_forEachCell(t,e,r,n,i,s,a,o){const l=this._convertToCellCoord(t),u=this._convertToCellCoord(e),c=this._convertToCellCoord(r),h=this._convertToCellCoord(n);for(let p=l;p<=c;p++)for(let l=u;l<=h;l++){const u=this.d*l+p;if((!o||o(this._convertFromCellCoord(p),this._convertFromCellCoord(l),this._convertFromCellCoord(p+1),this._convertFromCellCoord(l+1)))&&i.call(this,t,e,r,n,u,s,a,o))return}}_convertFromCellCoord(t){return (t-this.padding)/this.scale}_convertToCellCoord(t){return Math.max(0,Math.min(this.d-1,Math.floor(t*this.scale)+this.padding))}toArrayBuffer(){if(this.arrayBuffer)return this.arrayBuffer;const t=this.cells,e=3+this.cells.length+1+1;let r=0;for(let t=0;t<this.cells.length;t++)r+=this.cells[t].length;const n=new Int32Array(e+r+this.keys.length+this.bboxes.length);n[0]=this.extent,n[1]=this.n,n[2]=this.padding;let i=e;for(let e=0;e<t.length;e++){const r=t[e];n[3+e]=i,n.set(r,i),i+=r.length;}return n[3+t.length]=i,n.set(this.keys,i),i+=this.keys.length,n[3+t.length+1]=i,n.set(this.bboxes,i),i+=this.bboxes.length,n.buffer}static serialize(t,e){const r=t.toArrayBuffer();return e&&e.push(r),{buffer:r}}static deserialize(t){return new vi(t.buffer)}}const bi={};function wi(t,e,r={}){if(bi[t])throw new Error(`${t} is already registered.`);Object.defineProperty(e,"_classRegistryKey",{value:t,writeable:!1}),bi[t]={klass:e,omit:r.omit||[],shallow:r.shallow||[]};}wi("Object",Object),wi("TransferableGridIndex",vi),wi("Color",Kt),wi("Error",Error),wi("AJAXError",L),wi("ResolvedImage",te),wi("StylePropertyFunction",Sn),wi("StyleExpression",xn,{omit:["_evaluator"]}),wi("ZoomDependentExpression",_n),wi("ZoomConstantExpression",wn),wi("CompoundExpression",Xr,{omit:["_evaluate"]});for(const t in Kr)Kr[t]._classRegistryKey||wi(`Expression_${t}`,Kr[t]);function _i(t){return t&&"undefined"!=typeof ArrayBuffer&&(t instanceof ArrayBuffer||t.constructor&&"ArrayBuffer"===t.constructor.name)}function Ai(t){return t.$name||t.constructor._classRegistryKey}function Si(t){return !function(t){if(null===t||"object"!=typeof t)return !1;const e=Ai(t);return !(!e||"Object"===e)}(t)&&(null==t||"boolean"==typeof t||"number"==typeof t||"string"==typeof t||t instanceof Boolean||t instanceof Number||t instanceof String||t instanceof Date||t instanceof RegExp||t instanceof Blob||t instanceof Error||_i(t)||I(t)||ArrayBuffer.isView(t)||t instanceof ImageData)}function ki(t,e){if(Si(t))return (_i(t)||I(t))&&e&&e.push(t),ArrayBuffer.isView(t)&&e&&e.push(t.buffer),t instanceof ImageData&&e&&e.push(t.data.buffer),t;if(Array.isArray(t)){const r=[];for(const n of t)r.push(ki(n,e));return r}if("object"!=typeof t)throw new Error("can't serialize object of type "+typeof t);const r=Ai(t);if(!r)throw new Error(`can't serialize object of unregistered class ${t.constructor.name}`);if(!bi[r])throw new Error(`${r} is not registered.`);const{klass:n}=bi[r],i=n.serialize?n.serialize(t,e):{};if(n.serialize){if(e&&i===e[e.length-1])throw new Error("statically serialized object won't survive transfer of $name property")}else {for(const n in t){if(!t.hasOwnProperty(n))continue;if(bi[r].omit.indexOf(n)>=0)continue;const s=t[n];i[n]=bi[r].shallow.indexOf(n)>=0?s:ki(s,e);}t instanceof Error&&(i.message=t.message);}if(i.$name)throw new Error("$name property is reserved for worker serialization logic.");return "Object"!==r&&(i.$name=r),i}function Mi(t){if(Si(t))return t;if(Array.isArray(t))return t.map(Mi);if("object"!=typeof t)throw new Error("can't deserialize object of type "+typeof t);const e=Ai(t)||"Object";if(!bi[e])throw new Error(`can't deserialize unregistered class ${e}`);const{klass:r}=bi[e];if(!r)throw new Error(`can't deserialize unregistered class ${e}`);if(r.deserialize)return r.deserialize(t);const n=Object.create(r.prototype);for(const r of Object.keys(t)){if("$name"===r)continue;const i=t[r];n[r]=bi[e].shallow.indexOf(r)>=0?i:Mi(i);}return n}class Ii{constructor(){this.first=!0;}update(t,e){const r=Math.floor(t);return this.first?(this.first=!1,this.lastIntegerZoom=r,this.lastIntegerZoomTime=0,this.lastZoom=t,this.lastFloorZoom=r,!0):(this.lastFloorZoom>r?(this.lastIntegerZoom=r+1,this.lastIntegerZoomTime=e):this.lastFloorZoom<r&&(this.lastIntegerZoom=r,this.lastIntegerZoomTime=e),t!==this.lastZoom&&(this.lastZoom=t,this.lastFloorZoom=r,!0))}}const zi={"Latin-1 Supplement":t=>t>=128&&t<=255,"Hangul Jamo":t=>t>=4352&&t<=4607,Khmer:t=>t>=6016&&t<=6143,"General Punctuation":t=>t>=8192&&t<=8303,"Letterlike Symbols":t=>t>=8448&&t<=8527,"Number Forms":t=>t>=8528&&t<=8591,"Miscellaneous Technical":t=>t>=8960&&t<=9215,"Control Pictures":t=>t>=9216&&t<=9279,"Optical Character Recognition":t=>t>=9280&&t<=9311,"Enclosed Alphanumerics":t=>t>=9312&&t<=9471,"Geometric Shapes":t=>t>=9632&&t<=9727,"Miscellaneous Symbols":t=>t>=9728&&t<=9983,"Miscellaneous Symbols and Arrows":t=>t>=11008&&t<=11263,"Ideographic Description Characters":t=>t>=12272&&t<=12287,"CJK Symbols and Punctuation":t=>t>=12288&&t<=12351,Katakana:t=>t>=12448&&t<=12543,Kanbun:t=>t>=12688&&t<=12703,"CJK Strokes":t=>t>=12736&&t<=12783,"Enclosed CJK Letters and Months":t=>t>=12800&&t<=13055,"CJK Compatibility":t=>t>=13056&&t<=13311,"Yijing Hexagram Symbols":t=>t>=19904&&t<=19967,"Private Use Area":t=>t>=57344&&t<=63743,"Vertical Forms":t=>t>=65040&&t<=65055,"CJK Compatibility Forms":t=>t>=65072&&t<=65103,"Small Form Variants":t=>t>=65104&&t<=65135,"Halfwidth and Fullwidth Forms":t=>t>=65280&&t<=65519};function Pi(t){for(const e of t)if(Ti(e.charCodeAt(0)))return !0;return !1}function Ci(t){for(const e of t)if(!Ei(e.charCodeAt(0)))return !1;return !0}function Bi(t){const e=t.map((t=>{try{return new RegExp(`\\p{sc=${t}}`,"u").source}catch(t){return null}})).filter((t=>t));return new RegExp(e.join("|"),"u")}const Vi=Bi(["Arab","Dupl","Mong","Ougr","Syrc"]);function Ei(t){return !Vi.test(String.fromCodePoint(t))}const Fi=Bi(["Bopo","Hani","Hira","Kana","Kits","Nshu","Tang","Yiii"]);function Ti(t){return !(746!==t&&747!==t&&(t<4352||!(zi["CJK Compatibility Forms"](t)&&!(t>=65097&&t<=65103)||zi["CJK Compatibility"](t)||zi["CJK Strokes"](t)||!(!zi["CJK Symbols and Punctuation"](t)||t>=12296&&t<=12305||t>=12308&&t<=12319||12336===t)||zi["Enclosed CJK Letters and Months"](t)||zi["Ideographic Description Characters"](t)||zi.Kanbun(t)||zi.Katakana(t)&&12540!==t||!(!zi["Halfwidth and Fullwidth Forms"](t)||65288===t||65289===t||65293===t||t>=65306&&t<=65310||65339===t||65341===t||65343===t||t>=65371&&t<=65503||65507===t||t>=65512&&t<=65519)||!(!zi["Small Form Variants"](t)||t>=65112&&t<=65118||t>=65123&&t<=65126)||zi["Vertical Forms"](t)||zi["Yijing Hexagram Symbols"](t)||/\p{sc=Cans}/u.test(String.fromCodePoint(t))||/\p{sc=Hang}/u.test(String.fromCodePoint(t))||Fi.test(String.fromCodePoint(t)))))}function $i(t){return !(Ti(t)||function(t){return !!(zi["Latin-1 Supplement"](t)&&(167===t||169===t||174===t||177===t||188===t||189===t||190===t||215===t||247===t)||zi["General Punctuation"](t)&&(8214===t||8224===t||8225===t||8240===t||8241===t||8251===t||8252===t||8258===t||8263===t||8264===t||8265===t||8273===t)||zi["Letterlike Symbols"](t)||zi["Number Forms"](t)||zi["Miscellaneous Technical"](t)&&(t>=8960&&t<=8967||t>=8972&&t<=8991||t>=8996&&t<=9e3||9003===t||t>=9085&&t<=9114||t>=9150&&t<=9165||9167===t||t>=9169&&t<=9179||t>=9186&&t<=9215)||zi["Control Pictures"](t)&&9251!==t||zi["Optical Character Recognition"](t)||zi["Enclosed Alphanumerics"](t)||zi["Geometric Shapes"](t)||zi["Miscellaneous Symbols"](t)&&!(t>=9754&&t<=9759)||zi["Miscellaneous Symbols and Arrows"](t)&&(t>=11026&&t<=11055||t>=11088&&t<=11097||t>=11192&&t<=11243)||zi["CJK Symbols and Punctuation"](t)||zi.Katakana(t)||zi["Private Use Area"](t)||zi["CJK Compatibility Forms"](t)||zi["Small Form Variants"](t)||zi["Halfwidth and Fullwidth Forms"](t)||8734===t||8756===t||8757===t||t>=9984&&t<=10087||t>=10102&&t<=10131||65532===t||65533===t)}(t))}const Li=Bi(["Adlm","Arab","Armi","Avst","Chrs","Cprt","Egyp","Elym","Gara","Hatr","Hebr","Hung","Khar","Lydi","Mand","Mani","Mend","Merc","Mero","Narb","Nbat","Nkoo","Orkh","Palm","Phli","Phlp","Phnx","Prti","Rohg","Samr","Sarb","Sogo","Syrc","Thaa","Todr","Yezi"]);function Di(t){return Li.test(String.fromCodePoint(t))}function Oi(t,e){return !(!e&&Di(t)||t>=2304&&t<=3583||t>=3840&&t<=4255||zi.Khmer(t))}function ji(t){for(const e of t)if(Di(e.charCodeAt(0)))return !0;return !1}const Ri=new class{constructor(){this.applyArabicShaping=null,this.processBidirectionalText=null,this.processStyledBidirectionalText=null,this.pluginStatus="unavailable",this.pluginURL=null;}setState(t){this.pluginStatus=t.pluginStatus,this.pluginURL=t.pluginURL;}getState(){return {pluginStatus:this.pluginStatus,pluginURL:this.pluginURL}}setMethods(t){this.applyArabicShaping=t.applyArabicShaping,this.processBidirectionalText=t.processBidirectionalText,this.processStyledBidirectionalText=t.processStyledBidirectionalText;}isParsed(){return null!=this.applyArabicShaping&&null!=this.processBidirectionalText&&null!=this.processStyledBidirectionalText}getPluginURL(){return this.pluginURL}getRTLTextPluginStatus(){return this.pluginStatus}};class Ui{constructor(t,e){this.zoom=t,e?(this.now=e.now,this.fadeDuration=e.fadeDuration,this.zoomHistory=e.zoomHistory,this.transition=e.transition):(this.now=0,this.fadeDuration=0,this.zoomHistory=new Ii,this.transition={});}isSupportedScript(t){return function(t,e){for(const r of t)if(!Oi(r.charCodeAt(0),e))return !1;return !0}(t,"loaded"===Ri.getRTLTextPluginStatus())}crossFadingFactor(){return 0===this.fadeDuration?1:Math.min((this.now-this.zoomHistory.lastIntegerZoomTime)/this.fadeDuration,1)}getCrossfadeParameters(){const t=this.zoom,e=t-Math.floor(t),r=this.crossFadingFactor();return t>this.zoomHistory.lastIntegerZoom?{fromScale:2,toScale:1,t:e+(1-e)*r}:{fromScale:.5,toScale:1,t:1-(1-r)*e}}}class qi{constructor(t,e){this.property=t,this.value=e,this.expression=function(t,e){if(cn(t))return new Sn(t,e);if(vn(t)){const r=An(t,e);if("error"===r.result)throw new Error(r.value.map((t=>`${t.key}: ${t.message}`)).join(", "));return r.value}{let r=t;return "color"===e.type&&"string"==typeof t?r=Kt.parse(t):"padding"!==e.type||"number"!=typeof t&&!Array.isArray(t)?"variableAnchorOffsetCollection"===e.type&&Array.isArray(t)&&(r=Qt.parse(t)):r=Jt.parse(t),{kind:"constant",evaluate:()=>r}}}(void 0===e?t.specification.default:e,t.specification);}isDataDriven(){return "source"===this.expression.kind||"composite"===this.expression.kind}possiblyEvaluate(t,e,r){return this.property.possiblyEvaluate(this,t,e,r)}}class Ni{constructor(t){this.property=t,this.value=new qi(t,void 0);}transitioned(t,e){return new Gi(this.property,this.value,e,g({},t.transition,this.transition),t.now)}untransitioned(){return new Gi(this.property,this.value,null,{},0)}}class Zi{constructor(t){this._properties=t,this._values=Object.create(t.defaultTransitionablePropertyValues);}getValue(t){return w(this._values[t].value.value)}setValue(t,e){Object.prototype.hasOwnProperty.call(this._values,t)||(this._values[t]=new Ni(this._values[t].property)),this._values[t].value=new qi(this._values[t].property,null===e?void 0:w(e));}getTransition(t){return w(this._values[t].transition)}setTransition(t,e){Object.prototype.hasOwnProperty.call(this._values,t)||(this._values[t]=new Ni(this._values[t].property)),this._values[t].transition=w(e)||void 0;}serialize(){const t={};for(const e of Object.keys(this._values)){const r=this.getValue(e);void 0!==r&&(t[e]=r);const n=this.getTransition(e);void 0!==n&&(t[`${e}-transition`]=n);}return t}transitioned(t,e){const r=new Ki(this._properties);for(const n of Object.keys(this._values))r._values[n]=this._values[n].transitioned(t,e._values[n]);return r}untransitioned(){const t=new Ki(this._properties);for(const e of Object.keys(this._values))t._values[e]=this._values[e].untransitioned();return t}}class Gi{constructor(t,e,r,n,i){this.property=t,this.value=e,this.begin=i+n.delay||0,this.end=this.begin+n.duration||0,t.specification.transition&&(n.delay||n.duration)&&(this.prior=r);}possiblyEvaluate(t,e,r){const n=t.now||0,i=this.value.possiblyEvaluate(t,e,r),s=this.prior;if(s){if(n>this.end)return this.prior=null,i;if(this.value.isDataDriven())return this.prior=null,i;if(n<this.begin)return s.possiblyEvaluate(t,e,r);{const a=(n-this.begin)/(this.end-this.begin);return this.property.interpolate(s.possiblyEvaluate(t,e,r),i,function(t){if(t<=0)return 0;if(t>=1)return 1;const e=t*t,r=e*t;return 4*(t<.5?r:3*(t-e)+r-.75)}(a))}}return i}}class Ki{constructor(t){this._properties=t,this._values=Object.create(t.defaultTransitioningPropertyValues);}possiblyEvaluate(t,e,r){const n=new Yi(this._properties);for(const i of Object.keys(this._values))n._values[i]=this._values[i].possiblyEvaluate(t,e,r);return n}hasTransition(){for(const t of Object.keys(this._values))if(this._values[t].prior)return !0;return !1}}class Xi{constructor(t){this._properties=t,this._values=Object.create(t.defaultPropertyValues);}hasValue(t){return void 0!==this._values[t].value}getValue(t){return w(this._values[t].value)}setValue(t,e){this._values[t]=new qi(this._values[t].property,null===e?void 0:w(e));}serialize(){const t={};for(const e of Object.keys(this._values)){const r=this.getValue(e);void 0!==r&&(t[e]=r);}return t}possiblyEvaluate(t,e,r){const n=new Yi(this._properties);for(const i of Object.keys(this._values))n._values[i]=this._values[i].possiblyEvaluate(t,e,r);return n}}class Hi{constructor(t,e,r){this.property=t,this.value=e,this.parameters=r;}isConstant(){return "constant"===this.value.kind}constantOr(t){return "constant"===this.value.kind?this.value.value:t}evaluate(t,e,r,n){return this.property.evaluate(this.value,this.parameters,t,e,r,n)}}class Yi{constructor(t){this._properties=t,this._values=Object.create(t.defaultPossiblyEvaluatedValues);}get(t){return this._values[t]}}class Ji{constructor(t){this.specification=t;}possiblyEvaluate(t,e){if(t.isDataDriven())throw new Error("Value should not be data driven");return t.expression.evaluate(e)}interpolate(t,e,r){const n=Ce[this.specification.type];return n?n(t,e,r):t}}class Wi{constructor(t,e){this.specification=t,this.overrides=e;}possiblyEvaluate(t,e,r,n){return new Hi(this,"constant"===t.expression.kind||"camera"===t.expression.kind?{kind:"constant",value:t.expression.evaluate(e,null,{},r,n)}:t.expression,e)}interpolate(t,e,r){if("constant"!==t.value.kind||"constant"!==e.value.kind)return t;if(void 0===t.value.value||void 0===e.value.value)return new Hi(this,{kind:"constant",value:void 0},t.parameters);const n=Ce[this.specification.type];if(n){const i=n(t.value.value,e.value.value,r);return new Hi(this,{kind:"constant",value:i},t.parameters)}return t}evaluate(t,e,r,n,i,s){return "constant"===t.kind?t.value:t.evaluate(e,r,n,i,s)}}class Qi extends Wi{possiblyEvaluate(t,e,r,n){if(void 0===t.value)return new Hi(this,{kind:"constant",value:void 0},e);if("constant"===t.expression.kind){const i=t.expression.evaluate(e,null,{},r,n),s="resolvedImage"===t.property.specification.type&&"string"!=typeof i?i.name:i,a=this._calculate(s,s,s,e);return new Hi(this,{kind:"constant",value:a},e)}if("camera"===t.expression.kind){const r=this._calculate(t.expression.evaluate({zoom:e.zoom-1}),t.expression.evaluate({zoom:e.zoom}),t.expression.evaluate({zoom:e.zoom+1}),e);return new Hi(this,{kind:"constant",value:r},e)}return new Hi(this,t.expression,e)}evaluate(t,e,r,n,i,s){if("source"===t.kind){const a=t.evaluate(e,r,n,i,s);return this._calculate(a,a,a,e)}return "composite"===t.kind?this._calculate(t.evaluate({zoom:Math.floor(e.zoom)-1},r,n),t.evaluate({zoom:Math.floor(e.zoom)},r,n),t.evaluate({zoom:Math.floor(e.zoom)+1},r,n),e):t.value}_calculate(t,e,r,n){return n.zoom>n.zoomHistory.lastIntegerZoom?{from:t,to:e}:{from:r,to:e}}interpolate(t){return t}}class ts{constructor(t){this.specification=t;}possiblyEvaluate(t,e,r,n){if(void 0!==t.value){if("constant"===t.expression.kind){const i=t.expression.evaluate(e,null,{},r,n);return this._calculate(i,i,i,e)}return this._calculate(t.expression.evaluate(new Ui(Math.floor(e.zoom-1),e)),t.expression.evaluate(new Ui(Math.floor(e.zoom),e)),t.expression.evaluate(new Ui(Math.floor(e.zoom+1),e)),e)}}_calculate(t,e,r,n){return n.zoom>n.zoomHistory.lastIntegerZoom?{from:t,to:e}:{from:r,to:e}}interpolate(t){return t}}class es{constructor(t){this.specification=t;}possiblyEvaluate(t,e,r,n){return !!t.expression.evaluate(e,null,{},r,n)}interpolate(){return !1}}class rs{constructor(t){this.properties=t,this.defaultPropertyValues={},this.defaultTransitionablePropertyValues={},this.defaultTransitioningPropertyValues={},this.defaultPossiblyEvaluatedValues={},this.overridableProperties=[];for(const e in t){const r=t[e];r.specification.overridable&&this.overridableProperties.push(e);const n=this.defaultPropertyValues[e]=new qi(r,void 0),i=this.defaultTransitionablePropertyValues[e]=new Ni(r);this.defaultTransitioningPropertyValues[e]=i.untransitioned(),this.defaultPossiblyEvaluatedValues[e]=n.possiblyEvaluate({});}}}wi("DataDrivenProperty",Wi),wi("DataConstantProperty",Ji),wi("CrossFadedDataDrivenProperty",Qi),wi("CrossFadedProperty",ts),wi("ColorRampProperty",es);const ns="-transition";class is extends Z{constructor(t,e){if(super(),this.id=t.id,this.type=t.type,this._featureFilter={filter:()=>!0,needGeometry:!1},"custom"!==t.type&&(this.metadata=t.metadata,this.minzoom=t.minzoom,this.maxzoom=t.maxzoom,"background"!==t.type&&(this.source=t.source,this.sourceLayer=t["source-layer"],this.filter=t.filter),e.layout&&(this._unevaluatedLayout=new Xi(e.layout)),e.paint)){this._transitionablePaint=new Zi(e.paint);for(const e in t.paint)this.setPaintProperty(e,t.paint[e],{validate:!1});for(const e in t.layout)this.setLayoutProperty(e,t.layout[e],{validate:!1});this._transitioningPaint=this._transitionablePaint.untransitioned(),this.paint=new Yi(e.paint);}}getCrossfadeParameters(){return this._crossfadeParameters}getLayoutProperty(t){return "visibility"===t?this.visibility:this._unevaluatedLayout.getValue(t)}setLayoutProperty(t,e,r={}){null!=e&&this._validate(gi,`layers.${this.id}.layout.${t}`,t,e,r)||("visibility"!==t?this._unevaluatedLayout.setValue(t,e):this.visibility=e);}getPaintProperty(t){return t.endsWith(ns)?this._transitionablePaint.getTransition(t.slice(0,-11)):this._transitionablePaint.getValue(t)}setPaintProperty(t,e,r={}){if(null!=e&&this._validate(mi,`layers.${this.id}.paint.${t}`,t,e,r))return !1;if(t.endsWith(ns))return this._transitionablePaint.setTransition(t.slice(0,-11),e||void 0),!1;{const r=this._transitionablePaint._values[t],n="cross-faded-data-driven"===r.property.specification["property-type"],i=r.value.isDataDriven(),s=r.value;this._transitionablePaint.setValue(t,e),this._handleSpecialPaintPropertyUpdate(t);const a=this._transitionablePaint._values[t].value;return a.isDataDriven()||i||n||this._handleOverridablePaintPropertyUpdate(t,s,a)}}_handleSpecialPaintPropertyUpdate(t){}_handleOverridablePaintPropertyUpdate(t,e,r){return !1}isHidden(t){return !!(this.minzoom&&t<this.minzoom)||!!(this.maxzoom&&t>=this.maxzoom)||"none"===this.visibility}updateTransitions(t){this._transitioningPaint=this._transitionablePaint.transitioned(t,this._transitioningPaint);}hasTransition(){return this._transitioningPaint.hasTransition()}recalculate(t,e){t.getCrossfadeParameters&&(this._crossfadeParameters=t.getCrossfadeParameters()),this._unevaluatedLayout&&(this.layout=this._unevaluatedLayout.possiblyEvaluate(t,void 0,e)),this.paint=this._transitioningPaint.possiblyEvaluate(t,void 0,e);}serialize(){const t={id:this.id,type:this.type,source:this.source,"source-layer":this.sourceLayer,metadata:this.metadata,minzoom:this.minzoom,maxzoom:this.maxzoom,filter:this.filter,layout:this._unevaluatedLayout&&this._unevaluatedLayout.serialize(),paint:this._transitionablePaint&&this._transitionablePaint.serialize()};return this.visibility&&(t.layout=t.layout||{},t.layout.visibility=this.visibility),b(t,((t,e)=>!(void 0===t||"layout"===e&&!Object.keys(t).length||"paint"===e&&!Object.keys(t).length)))}_validate(t,e,r,n,i={}){return (!i||!1!==i.validate)&&xi(this,t.call(fi,{key:e,layerType:this.type,objectKey:r,value:n,styleSpec:G,style:{glyphs:!0,sprite:!0}}))}is3D(){return !1}isTileClipped(){return !1}hasOffscreenPass(){return !1}resize(){}isStateDependent(){for(const t in this.paint._values){const e=this.paint.get(t);if(e instanceof Hi&&an(e.property.specification)&&("source"===e.value.kind||"composite"===e.value.kind)&&e.value.isStateDependent)return !0}return !1}}const ss={Int8:Int8Array,Uint8:Uint8Array,Int16:Int16Array,Uint16:Uint16Array,Int32:Int32Array,Uint32:Uint32Array,Float32:Float32Array};class as{constructor(t,e){this._structArray=t,this._pos1=e*this.size,this._pos2=this._pos1/2,this._pos4=this._pos1/4,this._pos8=this._pos1/8;}}class os{constructor(){this.isTransferred=!1,this.capacity=-1,this.resize(0);}static serialize(t,e){return t._trim(),e&&(t.isTransferred=!0,e.push(t.arrayBuffer)),{length:t.length,arrayBuffer:t.arrayBuffer}}static deserialize(t){const e=Object.create(this.prototype);return e.arrayBuffer=t.arrayBuffer,e.length=t.length,e.capacity=t.arrayBuffer.byteLength/e.bytesPerElement,e._refreshViews(),e}_trim(){this.length!==this.capacity&&(this.capacity=this.length,this.arrayBuffer=this.arrayBuffer.slice(0,this.length*this.bytesPerElement),this._refreshViews());}clear(){this.length=0;}resize(t){this.reserve(t),this.length=t;}reserve(t){if(t>this.capacity){this.capacity=Math.max(t,Math.floor(5*this.capacity),128),this.arrayBuffer=new ArrayBuffer(this.capacity*this.bytesPerElement);const e=this.uint8;this._refreshViews(),e&&this.uint8.set(e);}}_refreshViews(){throw new Error("_refreshViews() must be implemented by each concrete StructArray layout")}}function ls(t,e=1){let r=0,n=0;return {members:t.map((t=>{const i=ss[t.type].BYTES_PER_ELEMENT,s=r=us(r,Math.max(e,i)),a=t.components||1;return n=Math.max(n,i),r+=i*a,{name:t.name,type:t.type,components:a,offset:s}})),size:us(r,Math.max(n,e)),alignment:e}}function us(t,e){return Math.ceil(t/e)*e}class cs extends os{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer);}emplaceBack(t,e){const r=this.length;return this.resize(r+1),this.emplace(r,t,e)}emplace(t,e,r){const n=2*t;return this.int16[n+0]=e,this.int16[n+1]=r,t}}cs.prototype.bytesPerElement=4,wi("StructArrayLayout2i4",cs);class hs extends os{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer);}emplaceBack(t,e,r){const n=this.length;return this.resize(n+1),this.emplace(n,t,e,r)}emplace(t,e,r,n){const i=3*t;return this.int16[i+0]=e,this.int16[i+1]=r,this.int16[i+2]=n,t}}hs.prototype.bytesPerElement=6,wi("StructArrayLayout3i6",hs);class ps extends os{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer);}emplaceBack(t,e,r,n){const i=this.length;return this.resize(i+1),this.emplace(i,t,e,r,n)}emplace(t,e,r,n,i){const s=4*t;return this.int16[s+0]=e,this.int16[s+1]=r,this.int16[s+2]=n,this.int16[s+3]=i,t}}ps.prototype.bytesPerElement=8,wi("StructArrayLayout4i8",ps);class fs extends os{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,s){const a=this.length;return this.resize(a+1),this.emplace(a,t,e,r,n,i,s)}emplace(t,e,r,n,i,s,a){const o=6*t;return this.int16[o+0]=e,this.int16[o+1]=r,this.int16[o+2]=n,this.int16[o+3]=i,this.int16[o+4]=s,this.int16[o+5]=a,t}}fs.prototype.bytesPerElement=12,wi("StructArrayLayout2i4i12",fs);class ds extends os{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,s){const a=this.length;return this.resize(a+1),this.emplace(a,t,e,r,n,i,s)}emplace(t,e,r,n,i,s,a){const o=4*t,l=8*t;return this.int16[o+0]=e,this.int16[o+1]=r,this.uint8[l+4]=n,this.uint8[l+5]=i,this.uint8[l+6]=s,this.uint8[l+7]=a,t}}ds.prototype.bytesPerElement=8,wi("StructArrayLayout2i4ub8",ds);class ys extends os{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e){const r=this.length;return this.resize(r+1),this.emplace(r,t,e)}emplace(t,e,r){const n=2*t;return this.float32[n+0]=e,this.float32[n+1]=r,t}}ys.prototype.bytesPerElement=8,wi("StructArrayLayout2f8",ys);class ms extends os{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,s,a,o,l,u){const c=this.length;return this.resize(c+1),this.emplace(c,t,e,r,n,i,s,a,o,l,u)}emplace(t,e,r,n,i,s,a,o,l,u,c){const h=10*t;return this.uint16[h+0]=e,this.uint16[h+1]=r,this.uint16[h+2]=n,this.uint16[h+3]=i,this.uint16[h+4]=s,this.uint16[h+5]=a,this.uint16[h+6]=o,this.uint16[h+7]=l,this.uint16[h+8]=u,this.uint16[h+9]=c,t}}ms.prototype.bytesPerElement=20,wi("StructArrayLayout10ui20",ms);class gs extends os{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,s,a,o,l,u,c,h){const p=this.length;return this.resize(p+1),this.emplace(p,t,e,r,n,i,s,a,o,l,u,c,h)}emplace(t,e,r,n,i,s,a,o,l,u,c,h,p){const f=12*t;return this.int16[f+0]=e,this.int16[f+1]=r,this.int16[f+2]=n,this.int16[f+3]=i,this.uint16[f+4]=s,this.uint16[f+5]=a,this.uint16[f+6]=o,this.uint16[f+7]=l,this.int16[f+8]=u,this.int16[f+9]=c,this.int16[f+10]=h,this.int16[f+11]=p,t}}gs.prototype.bytesPerElement=24,wi("StructArrayLayout4i4ui4i24",gs);class xs extends os{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e,r){const n=this.length;return this.resize(n+1),this.emplace(n,t,e,r)}emplace(t,e,r,n){const i=3*t;return this.float32[i+0]=e,this.float32[i+1]=r,this.float32[i+2]=n,t}}xs.prototype.bytesPerElement=12,wi("StructArrayLayout3f12",xs);class vs extends os{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer);}emplaceBack(t){const e=this.length;return this.resize(e+1),this.emplace(e,t)}emplace(t,e){return this.uint32[1*t+0]=e,t}}vs.prototype.bytesPerElement=4,wi("StructArrayLayout1ul4",vs);class bs extends os{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,s,a,o,l){const u=this.length;return this.resize(u+1),this.emplace(u,t,e,r,n,i,s,a,o,l)}emplace(t,e,r,n,i,s,a,o,l,u){const c=10*t,h=5*t;return this.int16[c+0]=e,this.int16[c+1]=r,this.int16[c+2]=n,this.int16[c+3]=i,this.int16[c+4]=s,this.int16[c+5]=a,this.uint32[h+3]=o,this.uint16[c+8]=l,this.uint16[c+9]=u,t}}bs.prototype.bytesPerElement=20,wi("StructArrayLayout6i1ul2ui20",bs);class ws extends os{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,s){const a=this.length;return this.resize(a+1),this.emplace(a,t,e,r,n,i,s)}emplace(t,e,r,n,i,s,a){const o=6*t;return this.int16[o+0]=e,this.int16[o+1]=r,this.int16[o+2]=n,this.int16[o+3]=i,this.int16[o+4]=s,this.int16[o+5]=a,t}}ws.prototype.bytesPerElement=12,wi("StructArrayLayout2i2i2i12",ws);class _s extends os{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i){const s=this.length;return this.resize(s+1),this.emplace(s,t,e,r,n,i)}emplace(t,e,r,n,i,s){const a=4*t,o=8*t;return this.float32[a+0]=e,this.float32[a+1]=r,this.float32[a+2]=n,this.int16[o+6]=i,this.int16[o+7]=s,t}}_s.prototype.bytesPerElement=16,wi("StructArrayLayout2f1f2i16",_s);class As extends os{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,s){const a=this.length;return this.resize(a+1),this.emplace(a,t,e,r,n,i,s)}emplace(t,e,r,n,i,s,a){const o=16*t,l=4*t,u=8*t;return this.uint8[o+0]=e,this.uint8[o+1]=r,this.float32[l+1]=n,this.float32[l+2]=i,this.int16[u+6]=s,this.int16[u+7]=a,t}}As.prototype.bytesPerElement=16,wi("StructArrayLayout2ub2f2i16",As);class Ss extends os{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer);}emplaceBack(t,e,r){const n=this.length;return this.resize(n+1),this.emplace(n,t,e,r)}emplace(t,e,r,n){const i=3*t;return this.uint16[i+0]=e,this.uint16[i+1]=r,this.uint16[i+2]=n,t}}Ss.prototype.bytesPerElement=6,wi("StructArrayLayout3ui6",Ss);class ks extends os{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,s,a,o,l,u,c,h,p,f,d,y,m){const g=this.length;return this.resize(g+1),this.emplace(g,t,e,r,n,i,s,a,o,l,u,c,h,p,f,d,y,m)}emplace(t,e,r,n,i,s,a,o,l,u,c,h,p,f,d,y,m,g){const x=24*t,v=12*t,b=48*t;return this.int16[x+0]=e,this.int16[x+1]=r,this.uint16[x+2]=n,this.uint16[x+3]=i,this.uint32[v+2]=s,this.uint32[v+3]=a,this.uint32[v+4]=o,this.uint16[x+10]=l,this.uint16[x+11]=u,this.uint16[x+12]=c,this.float32[v+7]=h,this.float32[v+8]=p,this.uint8[b+36]=f,this.uint8[b+37]=d,this.uint8[b+38]=y,this.uint32[v+10]=m,this.int16[x+22]=g,t}}ks.prototype.bytesPerElement=48,wi("StructArrayLayout2i2ui3ul3ui2f3ub1ul1i48",ks);class Ms extends os{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,s,a,o,l,u,c,h,p,f,d,y,m,g,x,v,b,w,_,A,S,k,M,I){const z=this.length;return this.resize(z+1),this.emplace(z,t,e,r,n,i,s,a,o,l,u,c,h,p,f,d,y,m,g,x,v,b,w,_,A,S,k,M,I)}emplace(t,e,r,n,i,s,a,o,l,u,c,h,p,f,d,y,m,g,x,v,b,w,_,A,S,k,M,I,z){const P=32*t,C=16*t;return this.int16[P+0]=e,this.int16[P+1]=r,this.int16[P+2]=n,this.int16[P+3]=i,this.int16[P+4]=s,this.int16[P+5]=a,this.int16[P+6]=o,this.int16[P+7]=l,this.uint16[P+8]=u,this.uint16[P+9]=c,this.uint16[P+10]=h,this.uint16[P+11]=p,this.uint16[P+12]=f,this.uint16[P+13]=d,this.uint16[P+14]=y,this.uint16[P+15]=m,this.uint16[P+16]=g,this.uint16[P+17]=x,this.uint16[P+18]=v,this.uint16[P+19]=b,this.uint16[P+20]=w,this.uint16[P+21]=_,this.uint16[P+22]=A,this.uint32[C+12]=S,this.float32[C+13]=k,this.float32[C+14]=M,this.uint16[P+30]=I,this.uint16[P+31]=z,t}}Ms.prototype.bytesPerElement=64,wi("StructArrayLayout8i15ui1ul2f2ui64",Ms);class Is extends os{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t){const e=this.length;return this.resize(e+1),this.emplace(e,t)}emplace(t,e){return this.float32[1*t+0]=e,t}}Is.prototype.bytesPerElement=4,wi("StructArrayLayout1f4",Is);class zs extends os{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e,r){const n=this.length;return this.resize(n+1),this.emplace(n,t,e,r)}emplace(t,e,r,n){const i=3*t;return this.uint16[6*t+0]=e,this.float32[i+1]=r,this.float32[i+2]=n,t}}zs.prototype.bytesPerElement=12,wi("StructArrayLayout1ui2f12",zs);class Ps extends os{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer);}emplaceBack(t,e,r){const n=this.length;return this.resize(n+1),this.emplace(n,t,e,r)}emplace(t,e,r,n){const i=4*t;return this.uint32[2*t+0]=e,this.uint16[i+2]=r,this.uint16[i+3]=n,t}}Ps.prototype.bytesPerElement=8,wi("StructArrayLayout1ul2ui8",Ps);class Cs extends os{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer);}emplaceBack(t,e){const r=this.length;return this.resize(r+1),this.emplace(r,t,e)}emplace(t,e,r){const n=2*t;return this.uint16[n+0]=e,this.uint16[n+1]=r,t}}Cs.prototype.bytesPerElement=4,wi("StructArrayLayout2ui4",Cs);class Bs extends os{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer);}emplaceBack(t){const e=this.length;return this.resize(e+1),this.emplace(e,t)}emplace(t,e){return this.uint16[1*t+0]=e,t}}Bs.prototype.bytesPerElement=2,wi("StructArrayLayout1ui2",Bs);class Vs extends os{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e,r,n){const i=this.length;return this.resize(i+1),this.emplace(i,t,e,r,n)}emplace(t,e,r,n,i){const s=4*t;return this.float32[s+0]=e,this.float32[s+1]=r,this.float32[s+2]=n,this.float32[s+3]=i,t}}Vs.prototype.bytesPerElement=16,wi("StructArrayLayout4f16",Vs);class Es extends as{get anchorPointX(){return this._structArray.int16[this._pos2+0]}get anchorPointY(){return this._structArray.int16[this._pos2+1]}get x1(){return this._structArray.int16[this._pos2+2]}get y1(){return this._structArray.int16[this._pos2+3]}get x2(){return this._structArray.int16[this._pos2+4]}get y2(){return this._structArray.int16[this._pos2+5]}get featureIndex(){return this._structArray.uint32[this._pos4+3]}get sourceLayerIndex(){return this._structArray.uint16[this._pos2+8]}get bucketIndex(){return this._structArray.uint16[this._pos2+9]}get anchorPoint(){return new s(this.anchorPointX,this.anchorPointY)}}Es.prototype.size=20;class Fs extends bs{get(t){return new Es(this,t)}}wi("CollisionBoxArray",Fs);class Ts extends as{get anchorX(){return this._structArray.int16[this._pos2+0]}get anchorY(){return this._structArray.int16[this._pos2+1]}get glyphStartIndex(){return this._structArray.uint16[this._pos2+2]}get numGlyphs(){return this._structArray.uint16[this._pos2+3]}get vertexStartIndex(){return this._structArray.uint32[this._pos4+2]}get lineStartIndex(){return this._structArray.uint32[this._pos4+3]}get lineLength(){return this._structArray.uint32[this._pos4+4]}get segment(){return this._structArray.uint16[this._pos2+10]}get lowerSize(){return this._structArray.uint16[this._pos2+11]}get upperSize(){return this._structArray.uint16[this._pos2+12]}get lineOffsetX(){return this._structArray.float32[this._pos4+7]}get lineOffsetY(){return this._structArray.float32[this._pos4+8]}get writingMode(){return this._structArray.uint8[this._pos1+36]}get placedOrientation(){return this._structArray.uint8[this._pos1+37]}set placedOrientation(t){this._structArray.uint8[this._pos1+37]=t;}get hidden(){return this._structArray.uint8[this._pos1+38]}set hidden(t){this._structArray.uint8[this._pos1+38]=t;}get crossTileID(){return this._structArray.uint32[this._pos4+10]}set crossTileID(t){this._structArray.uint32[this._pos4+10]=t;}get associatedIconIndex(){return this._structArray.int16[this._pos2+22]}}Ts.prototype.size=48;class $s extends ks{get(t){return new Ts(this,t)}}wi("PlacedSymbolArray",$s);class Ls extends as{get anchorX(){return this._structArray.int16[this._pos2+0]}get anchorY(){return this._structArray.int16[this._pos2+1]}get rightJustifiedTextSymbolIndex(){return this._structArray.int16[this._pos2+2]}get centerJustifiedTextSymbolIndex(){return this._structArray.int16[this._pos2+3]}get leftJustifiedTextSymbolIndex(){return this._structArray.int16[this._pos2+4]}get verticalPlacedTextSymbolIndex(){return this._structArray.int16[this._pos2+5]}get placedIconSymbolIndex(){return this._structArray.int16[this._pos2+6]}get verticalPlacedIconSymbolIndex(){return this._structArray.int16[this._pos2+7]}get key(){return this._structArray.uint16[this._pos2+8]}get textBoxStartIndex(){return this._structArray.uint16[this._pos2+9]}get textBoxEndIndex(){return this._structArray.uint16[this._pos2+10]}get verticalTextBoxStartIndex(){return this._structArray.uint16[this._pos2+11]}get verticalTextBoxEndIndex(){return this._structArray.uint16[this._pos2+12]}get iconBoxStartIndex(){return this._structArray.uint16[this._pos2+13]}get iconBoxEndIndex(){return this._structArray.uint16[this._pos2+14]}get verticalIconBoxStartIndex(){return this._structArray.uint16[this._pos2+15]}get verticalIconBoxEndIndex(){return this._structArray.uint16[this._pos2+16]}get featureIndex(){return this._structArray.uint16[this._pos2+17]}get numHorizontalGlyphVertices(){return this._structArray.uint16[this._pos2+18]}get numVerticalGlyphVertices(){return this._structArray.uint16[this._pos2+19]}get numIconVertices(){return this._structArray.uint16[this._pos2+20]}get numVerticalIconVertices(){return this._structArray.uint16[this._pos2+21]}get useRuntimeCollisionCircles(){return this._structArray.uint16[this._pos2+22]}get crossTileID(){return this._structArray.uint32[this._pos4+12]}set crossTileID(t){this._structArray.uint32[this._pos4+12]=t;}get textBoxScale(){return this._structArray.float32[this._pos4+13]}get collisionCircleDiameter(){return this._structArray.float32[this._pos4+14]}get textAnchorOffsetStartIndex(){return this._structArray.uint16[this._pos2+30]}get textAnchorOffsetEndIndex(){return this._structArray.uint16[this._pos2+31]}}Ls.prototype.size=64;class Ds extends Ms{get(t){return new Ls(this,t)}}wi("SymbolInstanceArray",Ds);class Os extends Is{getoffsetX(t){return this.float32[1*t+0]}}wi("GlyphOffsetArray",Os);class js extends hs{getx(t){return this.int16[3*t+0]}gety(t){return this.int16[3*t+1]}gettileUnitDistanceFromAnchor(t){return this.int16[3*t+2]}}wi("SymbolLineVertexArray",js);class Rs extends as{get textAnchor(){return this._structArray.uint16[this._pos2+0]}get textOffset0(){return this._structArray.float32[this._pos4+1]}get textOffset1(){return this._structArray.float32[this._pos4+2]}}Rs.prototype.size=12;class Us extends zs{get(t){return new Rs(this,t)}}wi("TextAnchorOffsetArray",Us);class qs extends as{get featureIndex(){return this._structArray.uint32[this._pos4+0]}get sourceLayerIndex(){return this._structArray.uint16[this._pos2+2]}get bucketIndex(){return this._structArray.uint16[this._pos2+3]}}qs.prototype.size=8;class Ns extends Ps{get(t){return new qs(this,t)}}wi("FeatureIndexArray",Ns);class Zs extends cs{}class Gs extends cs{}class Ks extends cs{}class Xs extends fs{}class Hs extends ds{}class Ys extends ys{}class Js extends ms{}class Ws extends gs{}class Qs extends xs{}class ta extends vs{}class ea extends ws{}class ra extends As{}class na extends Ss{}class ia extends Cs{}const sa=ls([{name:"a_pos",components:2,type:"Int16"}],4),{members:aa}=sa;class oa{constructor(t=[]){this.segments=t;}prepareSegment(t,e,r,n){let i=this.segments[this.segments.length-1];return t>oa.MAX_VERTEX_ARRAY_LENGTH&&A(`Max vertices per segment is ${oa.MAX_VERTEX_ARRAY_LENGTH}: bucket requested ${t}`),(!i||i.vertexLength+t>oa.MAX_VERTEX_ARRAY_LENGTH||i.sortKey!==n)&&(i={vertexOffset:e.length,primitiveOffset:r.length,vertexLength:0,primitiveLength:0},void 0!==n&&(i.sortKey=n),this.segments.push(i)),i}get(){return this.segments}destroy(){for(const t of this.segments)for(const e in t.vaos)t.vaos[e].destroy();}static simpleSegment(t,e,r,n){return new oa([{vertexOffset:t,primitiveOffset:e,vertexLength:r,primitiveLength:n,vaos:{},sortKey:0}])}}function la(t,e){return 256*(t=y(Math.floor(t),0,255))+y(Math.floor(e),0,255)}oa.MAX_VERTEX_ARRAY_LENGTH=Math.pow(2,16)-1,wi("SegmentVector",oa);const ua=ls([{name:"a_pattern_from",components:4,type:"Uint16"},{name:"a_pattern_to",components:4,type:"Uint16"},{name:"a_pixel_ratio_from",components:1,type:"Uint16"},{name:"a_pixel_ratio_to",components:1,type:"Uint16"}]);var ca={exports:{}},ha={exports:{}};ha.exports=function(t,e){var r,n,i,s,a,o,l,u;for(n=t.length-(r=3&t.length),i=e,a=3432918353,o=461845907,u=0;u<n;)l=255&t.charCodeAt(u)|(255&t.charCodeAt(++u))<<8|(255&t.charCodeAt(++u))<<16|(255&t.charCodeAt(++u))<<24,++u,i=27492+(65535&(s=5*(65535&(i=(i^=l=(65535&(l=(l=(65535&l)*a+(((l>>>16)*a&65535)<<16)&4294967295)<<15|l>>>17))*o+(((l>>>16)*o&65535)<<16)&4294967295)<<13|i>>>19))+((5*(i>>>16)&65535)<<16)&4294967295))+((58964+(s>>>16)&65535)<<16);switch(l=0,r){case 3:l^=(255&t.charCodeAt(u+2))<<16;case 2:l^=(255&t.charCodeAt(u+1))<<8;case 1:i^=l=(65535&(l=(l=(65535&(l^=255&t.charCodeAt(u)))*a+(((l>>>16)*a&65535)<<16)&4294967295)<<15|l>>>17))*o+(((l>>>16)*o&65535)<<16)&4294967295;}return i^=t.length,i=2246822507*(65535&(i^=i>>>16))+((2246822507*(i>>>16)&65535)<<16)&4294967295,i=3266489909*(65535&(i^=i>>>13))+((3266489909*(i>>>16)&65535)<<16)&4294967295,(i^=i>>>16)>>>0};var pa=ha.exports,fa={exports:{}};fa.exports=function(t,e){for(var r,n=t.length,i=e^n,s=0;n>=4;)r=1540483477*(65535&(r=255&t.charCodeAt(s)|(255&t.charCodeAt(++s))<<8|(255&t.charCodeAt(++s))<<16|(255&t.charCodeAt(++s))<<24))+((1540483477*(r>>>16)&65535)<<16),i=1540483477*(65535&i)+((1540483477*(i>>>16)&65535)<<16)^(r=1540483477*(65535&(r^=r>>>24))+((1540483477*(r>>>16)&65535)<<16)),n-=4,++s;switch(n){case 3:i^=(255&t.charCodeAt(s+2))<<16;case 2:i^=(255&t.charCodeAt(s+1))<<8;case 1:i=1540483477*(65535&(i^=255&t.charCodeAt(s)))+((1540483477*(i>>>16)&65535)<<16);}return i=1540483477*(65535&(i^=i>>>13))+((1540483477*(i>>>16)&65535)<<16),(i^=i>>>15)>>>0};var da=pa,ya=fa.exports;ca.exports=da,ca.exports.murmur3=da,ca.exports.murmur2=ya;var ma=r(ca.exports);class ga{constructor(){this.ids=[],this.positions=[],this.indexed=!1;}add(t,e,r,n){this.ids.push(xa(t)),this.positions.push(e,r,n);}getPositions(t){if(!this.indexed)throw new Error("Trying to get index, but feature positions are not indexed");const e=xa(t);let r=0,n=this.ids.length-1;for(;r<n;){const t=r+n>>1;this.ids[t]>=e?n=t:r=t+1;}const i=[];for(;this.ids[r]===e;)i.push({index:this.positions[3*r],start:this.positions[3*r+1],end:this.positions[3*r+2]}),r++;return i}static serialize(t,e){const r=new Float64Array(t.ids),n=new Uint32Array(t.positions);return va(r,n,0,r.length-1),e&&e.push(r.buffer,n.buffer),{ids:r,positions:n}}static deserialize(t){const e=new ga;return e.ids=t.ids,e.positions=t.positions,e.indexed=!0,e}}function xa(t){const e=+t;return !isNaN(e)&&e<=Number.MAX_SAFE_INTEGER?e:ma(String(t))}function va(t,e,r,n){for(;r<n;){const i=t[r+n>>1];let s=r-1,a=n+1;for(;;){do{s++;}while(t[s]<i);do{a--;}while(t[a]>i);if(s>=a)break;ba(t,s,a),ba(e,3*s,3*a),ba(e,3*s+1,3*a+1),ba(e,3*s+2,3*a+2);}a-r<n-a?(va(t,e,r,a),r=a+1):(va(t,e,a+1,n),n=a);}}function ba(t,e,r){const n=t[e];t[e]=t[r],t[r]=n;}wi("FeaturePositionMap",ga);class wa{constructor(t,e){this.gl=t.gl,this.location=e;}}class _a extends wa{constructor(t,e){super(t,e),this.current=0;}set(t){this.current!==t&&(this.current=t,this.gl.uniform1f(this.location,t));}}class Aa extends wa{constructor(t,e){super(t,e),this.current=[0,0,0,0];}set(t){t[0]===this.current[0]&&t[1]===this.current[1]&&t[2]===this.current[2]&&t[3]===this.current[3]||(this.current=t,this.gl.uniform4f(this.location,t[0],t[1],t[2],t[3]));}}class Sa extends wa{constructor(t,e){super(t,e),this.current=Kt.transparent;}set(t){t.r===this.current.r&&t.g===this.current.g&&t.b===this.current.b&&t.a===this.current.a||(this.current=t,this.gl.uniform4f(this.location,t.r,t.g,t.b,t.a));}}const ka=new Float32Array(16);function Ma(t){return [la(255*t.r,255*t.g),la(255*t.b,255*t.a)]}class Ia{constructor(t,e,r){this.value=t,this.uniformNames=e.map((t=>`u_${t}`)),this.type=r;}setUniform(t,e,r){t.set(r.constantOr(this.value));}getBinding(t,e,r){return "color"===this.type?new Sa(t,e):new _a(t,e)}}class za{constructor(t,e){this.uniformNames=e.map((t=>`u_${t}`)),this.patternFrom=null,this.patternTo=null,this.pixelRatioFrom=1,this.pixelRatioTo=1;}setConstantPatternPositions(t,e){this.pixelRatioFrom=e.pixelRatio,this.pixelRatioTo=t.pixelRatio,this.patternFrom=e.tlbr,this.patternTo=t.tlbr;}setUniform(t,e,r,n){const i="u_pattern_to"===n?this.patternTo:"u_pattern_from"===n?this.patternFrom:"u_pixel_ratio_to"===n?this.pixelRatioTo:"u_pixel_ratio_from"===n?this.pixelRatioFrom:null;i&&t.set(i);}getBinding(t,e,r){return "u_pattern"===r.substr(0,9)?new Aa(t,e):new _a(t,e)}}class Pa{constructor(t,e,r,n){this.expression=t,this.type=r,this.maxValue=0,this.paintVertexAttributes=e.map((t=>({name:`a_${t}`,type:"Float32",components:"color"===r?2:1,offset:0}))),this.paintVertexArray=new n;}populatePaintArray(t,e,r,n,i){const s=this.paintVertexArray.length,a=this.expression.evaluate(new Ui(0),e,{},n,[],i);this.paintVertexArray.resize(t),this._setPaintValue(s,t,a);}updatePaintArray(t,e,r,n){const i=this.expression.evaluate({zoom:0},r,n);this._setPaintValue(t,e,i);}_setPaintValue(t,e,r){if("color"===this.type){const n=Ma(r);for(let r=t;r<e;r++)this.paintVertexArray.emplace(r,n[0],n[1]);}else {for(let n=t;n<e;n++)this.paintVertexArray.emplace(n,r);this.maxValue=Math.max(this.maxValue,Math.abs(r));}}upload(t){this.paintVertexArray&&this.paintVertexArray.arrayBuffer&&(this.paintVertexBuffer&&this.paintVertexBuffer.buffer?this.paintVertexBuffer.updateData(this.paintVertexArray):this.paintVertexBuffer=t.createVertexBuffer(this.paintVertexArray,this.paintVertexAttributes,this.expression.isStateDependent));}destroy(){this.paintVertexBuffer&&this.paintVertexBuffer.destroy();}}class Ca{constructor(t,e,r,n,i,s){this.expression=t,this.uniformNames=e.map((t=>`u_${t}_t`)),this.type=r,this.useIntegerZoom=n,this.zoom=i,this.maxValue=0,this.paintVertexAttributes=e.map((t=>({name:`a_${t}`,type:"Float32",components:"color"===r?4:2,offset:0}))),this.paintVertexArray=new s;}populatePaintArray(t,e,r,n,i){const s=this.expression.evaluate(new Ui(this.zoom),e,{},n,[],i),a=this.expression.evaluate(new Ui(this.zoom+1),e,{},n,[],i),o=this.paintVertexArray.length;this.paintVertexArray.resize(t),this._setPaintValue(o,t,s,a);}updatePaintArray(t,e,r,n){const i=this.expression.evaluate({zoom:this.zoom},r,n),s=this.expression.evaluate({zoom:this.zoom+1},r,n);this._setPaintValue(t,e,i,s);}_setPaintValue(t,e,r,n){if("color"===this.type){const i=Ma(r),s=Ma(n);for(let r=t;r<e;r++)this.paintVertexArray.emplace(r,i[0],i[1],s[0],s[1]);}else {for(let i=t;i<e;i++)this.paintVertexArray.emplace(i,r,n);this.maxValue=Math.max(this.maxValue,Math.abs(r),Math.abs(n));}}upload(t){this.paintVertexArray&&this.paintVertexArray.arrayBuffer&&(this.paintVertexBuffer&&this.paintVertexBuffer.buffer?this.paintVertexBuffer.updateData(this.paintVertexArray):this.paintVertexBuffer=t.createVertexBuffer(this.paintVertexArray,this.paintVertexAttributes,this.expression.isStateDependent));}destroy(){this.paintVertexBuffer&&this.paintVertexBuffer.destroy();}setUniform(t,e){const r=this.useIntegerZoom?Math.floor(e.zoom):e.zoom,n=y(this.expression.interpolationFactor(r,this.zoom,this.zoom+1),0,1);t.set(n);}getBinding(t,e,r){return new _a(t,e)}}class Ba{constructor(t,e,r,n,i,s){this.expression=t,this.type=e,this.useIntegerZoom=r,this.zoom=n,this.layerId=s,this.zoomInPaintVertexArray=new i,this.zoomOutPaintVertexArray=new i;}populatePaintArray(t,e,r){const n=this.zoomInPaintVertexArray.length;this.zoomInPaintVertexArray.resize(t),this.zoomOutPaintVertexArray.resize(t),this._setPaintValues(n,t,e.patterns&&e.patterns[this.layerId],r);}updatePaintArray(t,e,r,n,i){this._setPaintValues(t,e,r.patterns&&r.patterns[this.layerId],i);}_setPaintValues(t,e,r,n){if(!n||!r)return;const{min:i,mid:s,max:a}=r,o=n[i],l=n[s],u=n[a];if(o&&l&&u)for(let r=t;r<e;r++)this.zoomInPaintVertexArray.emplace(r,l.tl[0],l.tl[1],l.br[0],l.br[1],o.tl[0],o.tl[1],o.br[0],o.br[1],l.pixelRatio,o.pixelRatio),this.zoomOutPaintVertexArray.emplace(r,l.tl[0],l.tl[1],l.br[0],l.br[1],u.tl[0],u.tl[1],u.br[0],u.br[1],l.pixelRatio,u.pixelRatio);}upload(t){this.zoomInPaintVertexArray&&this.zoomInPaintVertexArray.arrayBuffer&&this.zoomOutPaintVertexArray&&this.zoomOutPaintVertexArray.arrayBuffer&&(this.zoomInPaintVertexBuffer=t.createVertexBuffer(this.zoomInPaintVertexArray,ua.members,this.expression.isStateDependent),this.zoomOutPaintVertexBuffer=t.createVertexBuffer(this.zoomOutPaintVertexArray,ua.members,this.expression.isStateDependent));}destroy(){this.zoomOutPaintVertexBuffer&&this.zoomOutPaintVertexBuffer.destroy(),this.zoomInPaintVertexBuffer&&this.zoomInPaintVertexBuffer.destroy();}}class Va{constructor(t,e,r){this.binders={},this._buffers=[];const n=[];for(const i in t.paint._values){if(!r(i))continue;const s=t.paint.get(i);if(!(s instanceof Hi&&an(s.property.specification)))continue;const a=Fa(i,t.type),o=s.value,l=s.property.specification.type,u=s.property.useIntegerZoom,c=s.property.specification["property-type"],h="cross-faded"===c||"cross-faded-data-driven"===c;if("constant"===o.kind)this.binders[i]=h?new za(o.value,a):new Ia(o.value,a,l),n.push(`/u_${i}`);else if("source"===o.kind||h){const r=Ta(i,l,"source");this.binders[i]=h?new Ba(o,l,u,e,r,t.id):new Pa(o,a,l,r),n.push(`/a_${i}`);}else {const t=Ta(i,l,"composite");this.binders[i]=new Ca(o,a,l,u,e,t),n.push(`/z_${i}`);}}this.cacheKey=n.sort().join("");}getMaxValue(t){const e=this.binders[t];return e instanceof Pa||e instanceof Ca?e.maxValue:0}populatePaintArrays(t,e,r,n,i){for(const s in this.binders){const a=this.binders[s];(a instanceof Pa||a instanceof Ca||a instanceof Ba)&&a.populatePaintArray(t,e,r,n,i);}}setConstantPatternPositions(t,e){for(const r in this.binders){const n=this.binders[r];n instanceof za&&n.setConstantPatternPositions(t,e);}}updatePaintArrays(t,e,r,n,i){let s=!1;for(const a in t){const o=e.getPositions(a);for(const e of o){const o=r.feature(e.index);for(const r in this.binders){const l=this.binders[r];if((l instanceof Pa||l instanceof Ca||l instanceof Ba)&&!0===l.expression.isStateDependent){const u=n.paint.get(r);l.expression=u.value,l.updatePaintArray(e.start,e.end,o,t[a],i),s=!0;}}}}return s}defines(){const t=[];for(const e in this.binders){const r=this.binders[e];(r instanceof Ia||r instanceof za)&&t.push(...r.uniformNames.map((t=>`#define HAS_UNIFORM_${t}`)));}return t}getBinderAttributes(){const t=[];for(const e in this.binders){const r=this.binders[e];if(r instanceof Pa||r instanceof Ca)for(let e=0;e<r.paintVertexAttributes.length;e++)t.push(r.paintVertexAttributes[e].name);else if(r instanceof Ba)for(let e=0;e<ua.members.length;e++)t.push(ua.members[e].name);}return t}getBinderUniforms(){const t=[];for(const e in this.binders){const r=this.binders[e];if(r instanceof Ia||r instanceof za||r instanceof Ca)for(const e of r.uniformNames)t.push(e);}return t}getPaintVertexBuffers(){return this._buffers}getUniforms(t,e){const r=[];for(const n in this.binders){const i=this.binders[n];if(i instanceof Ia||i instanceof za||i instanceof Ca)for(const s of i.uniformNames)if(e[s]){const a=i.getBinding(t,e[s],s);r.push({name:s,property:n,binding:a});}}return r}setUniforms(t,e,r,n){for(const{name:t,property:i,binding:s}of e)this.binders[i].setUniform(s,n,r.get(i),t);}updatePaintBuffers(t){this._buffers=[];for(const e in this.binders){const r=this.binders[e];if(t&&r instanceof Ba){const e=2===t.fromScale?r.zoomInPaintVertexBuffer:r.zoomOutPaintVertexBuffer;e&&this._buffers.push(e);}else (r instanceof Pa||r instanceof Ca)&&r.paintVertexBuffer&&this._buffers.push(r.paintVertexBuffer);}}upload(t){for(const e in this.binders){const r=this.binders[e];(r instanceof Pa||r instanceof Ca||r instanceof Ba)&&r.upload(t);}this.updatePaintBuffers();}destroy(){for(const t in this.binders){const e=this.binders[t];(e instanceof Pa||e instanceof Ca||e instanceof Ba)&&e.destroy();}}}class Ea{constructor(t,e,r=(()=>!0)){this.programConfigurations={};for(const n of t)this.programConfigurations[n.id]=new Va(n,e,r);this.needsUpload=!1,this._featureMap=new ga,this._bufferOffset=0;}populatePaintArrays(t,e,r,n,i,s){for(const r in this.programConfigurations)this.programConfigurations[r].populatePaintArrays(t,e,n,i,s);void 0!==e.id&&this._featureMap.add(e.id,r,this._bufferOffset,t),this._bufferOffset=t,this.needsUpload=!0;}updatePaintArrays(t,e,r,n){for(const i of r)this.needsUpload=this.programConfigurations[i.id].updatePaintArrays(t,this._featureMap,e,i,n)||this.needsUpload;}get(t){return this.programConfigurations[t]}upload(t){if(this.needsUpload){for(const e in this.programConfigurations)this.programConfigurations[e].upload(t);this.needsUpload=!1;}}destroy(){for(const t in this.programConfigurations)this.programConfigurations[t].destroy();}}function Fa(t,e){return {"text-opacity":["opacity"],"icon-opacity":["opacity"],"text-color":["fill_color"],"icon-color":["fill_color"],"text-halo-color":["halo_color"],"icon-halo-color":["halo_color"],"text-halo-blur":["halo_blur"],"icon-halo-blur":["halo_blur"],"text-halo-width":["halo_width"],"icon-halo-width":["halo_width"],"line-gap-width":["gapwidth"],"line-pattern":["pattern_to","pattern_from","pixel_ratio_to","pixel_ratio_from"],"fill-pattern":["pattern_to","pattern_from","pixel_ratio_to","pixel_ratio_from"],"fill-extrusion-pattern":["pattern_to","pattern_from","pixel_ratio_to","pixel_ratio_from"]}[t]||[t.replace(`${e}-`,"").replace(/-/g,"_")]}function Ta(t,e,r){const n={color:{source:ys,composite:Vs},number:{source:Is,composite:ys}},i=function(t){return {"line-pattern":{source:Js,composite:Js},"fill-pattern":{source:Js,composite:Js},"fill-extrusion-pattern":{source:Js,composite:Js}}[t]}(t);return i&&i[r]||n[e][r]}wi("ConstantBinder",Ia),wi("CrossFadedConstantBinder",za),wi("SourceExpressionBinder",Pa),wi("CrossFadedCompositeBinder",Ba),wi("CompositeExpressionBinder",Ca),wi("ProgramConfiguration",Va,{omit:["_buffers"]}),wi("ProgramConfigurationSet",Ea);const $a=8192,La=Math.pow(2,14)-1,Da=-La-1;function Oa(t){const e=$a/t.extent,r=t.loadGeometry();for(let t=0;t<r.length;t++){const n=r[t];for(let t=0;t<n.length;t++){const r=n[t],i=Math.round(r.x*e),s=Math.round(r.y*e);r.x=y(i,Da,La),r.y=y(s,Da,La),(i<r.x||i>r.x+1||s<r.y||s>r.y+1)&&A("Geometry exceeds allowed extent, reduce your vector tile buffer size");}}return r}function ja(t,e){return {type:t.type,id:t.id,properties:t.properties,geometry:e?Oa(t):[]}}function Ra(t,e,r,n,i){t.emplaceBack(2*e+(n+1)/2,2*r+(i+1)/2);}class Ua{constructor(t){this.zoom=t.zoom,this.overscaling=t.overscaling,this.layers=t.layers,this.layerIds=this.layers.map((t=>t.id)),this.index=t.index,this.hasPattern=!1,this.layoutVertexArray=new Gs,this.indexArray=new na,this.segments=new oa,this.programConfigurations=new Ea(t.layers,t.zoom),this.stateDependentLayerIds=this.layers.filter((t=>t.isStateDependent())).map((t=>t.id));}populate(t,e,r){const n=this.layers[0],i=[];let s=null,a=!1;"circle"===n.type&&(s=n.layout.get("circle-sort-key"),a=!s.isConstant());for(const{feature:e,id:n,index:o,sourceLayerIndex:l}of t){const t=this.layers[0]._featureFilter.needGeometry,u=ja(e,t);if(!this.layers[0]._featureFilter.filter(new Ui(this.zoom),u,r))continue;const c=a?s.evaluate(u,{},r):void 0,h={id:n,properties:e.properties,type:e.type,sourceLayerIndex:l,index:o,geometry:t?u.geometry:Oa(e),patterns:{},sortKey:c};i.push(h);}a&&i.sort(((t,e)=>t.sortKey-e.sortKey));for(const n of i){const{geometry:i,index:s,sourceLayerIndex:a}=n,o=t[s].feature;this.addFeature(n,i,s,r),e.featureIndex.insert(o,i,s,a,this.index);}}update(t,e,r){this.stateDependentLayers.length&&this.programConfigurations.updatePaintArrays(t,e,this.stateDependentLayers,r);}isEmpty(){return 0===this.layoutVertexArray.length}uploadPending(){return !this.uploaded||this.programConfigurations.needsUpload}upload(t){this.uploaded||(this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,aa),this.indexBuffer=t.createIndexBuffer(this.indexArray)),this.programConfigurations.upload(t),this.uploaded=!0;}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.programConfigurations.destroy(),this.segments.destroy());}addFeature(t,e,r,n){for(const r of e)for(const e of r){const r=e.x,n=e.y;if(r<0||r>=$a||n<0||n>=$a)continue;const i=this.segments.prepareSegment(4,this.layoutVertexArray,this.indexArray,t.sortKey),s=i.vertexLength;Ra(this.layoutVertexArray,r,n,-1,-1),Ra(this.layoutVertexArray,r,n,1,-1),Ra(this.layoutVertexArray,r,n,1,1),Ra(this.layoutVertexArray,r,n,-1,1),this.indexArray.emplaceBack(s,s+1,s+2),this.indexArray.emplaceBack(s,s+3,s+2),i.vertexLength+=4,i.primitiveLength+=2;}this.programConfigurations.populatePaintArrays(this.layoutVertexArray.length,t,r,{},n);}}function qa(t,e){for(let r=0;r<t.length;r++)if(Wa(e,t[r]))return !0;for(let r=0;r<e.length;r++)if(Wa(t,e[r]))return !0;return !!Ka(t,e)}function Na(t,e,r){return !!Wa(t,e)||!!Ha(e,t,r)}function Za(t,e){if(1===t.length)return Ja(e,t[0]);for(let r=0;r<e.length;r++){const n=e[r];for(let e=0;e<n.length;e++)if(Wa(t,n[e]))return !0}for(let r=0;r<t.length;r++)if(Ja(e,t[r]))return !0;for(let r=0;r<e.length;r++)if(Ka(t,e[r]))return !0;return !1}function Ga(t,e,r){if(t.length>1){if(Ka(t,e))return !0;for(let n=0;n<e.length;n++)if(Ha(e[n],t,r))return !0}for(let n=0;n<t.length;n++)if(Ha(t[n],e,r))return !0;return !1}function Ka(t,e){if(0===t.length||0===e.length)return !1;for(let r=0;r<t.length-1;r++){const n=t[r],i=t[r+1];for(let t=0;t<e.length-1;t++)if(Xa(n,i,e[t],e[t+1]))return !0}return !1}function Xa(t,e,r,n){return S(t,r,n)!==S(e,r,n)&&S(t,e,r)!==S(t,e,n)}function Ha(t,e,r){const n=r*r;if(1===e.length)return t.distSqr(e[0])<n;for(let r=1;r<e.length;r++)if(Ya(t,e[r-1],e[r])<n)return !0;return !1}function Ya(t,e,r){const n=e.distSqr(r);if(0===n)return t.distSqr(e);const i=((t.x-e.x)*(r.x-e.x)+(t.y-e.y)*(r.y-e.y))/n;return t.distSqr(i<0?e:i>1?r:r.sub(e)._mult(i)._add(e))}function Ja(t,e){let r,n,i,s=!1;for(let a=0;a<t.length;a++){r=t[a];for(let t=0,a=r.length-1;t<r.length;a=t++)n=r[t],i=r[a],n.y>e.y!=i.y>e.y&&e.x<(i.x-n.x)*(e.y-n.y)/(i.y-n.y)+n.x&&(s=!s);}return s}function Wa(t,e){let r=!1;for(let n=0,i=t.length-1;n<t.length;i=n++){const s=t[n],a=t[i];s.y>e.y!=a.y>e.y&&e.x<(a.x-s.x)*(e.y-s.y)/(a.y-s.y)+s.x&&(r=!r);}return r}function Qa(t,e,r){const n=r[0],i=r[2];if(t.x<n.x&&e.x<n.x||t.x>i.x&&e.x>i.x||t.y<n.y&&e.y<n.y||t.y>i.y&&e.y>i.y)return !1;const s=S(t,e,r[0]);return s!==S(t,e,r[1])||s!==S(t,e,r[2])||s!==S(t,e,r[3])}function to(t,e,r){const n=e.paint.get(t).value;return "constant"===n.kind?n.value:r.programConfigurations.get(e.id).getMaxValue(t)}function eo(t){return Math.sqrt(t[0]*t[0]+t[1]*t[1])}function ro(t,e,r,n,i){if(!e[0]&&!e[1])return t;const a=s.convert(e)._mult(i);"viewport"===r&&a._rotate(-n);const o=[];for(let e=0;e<t.length;e++)o.push(t[e].sub(a));return o}let no,io;wi("CircleBucket",Ua,{omit:["layers"]});var so={get paint(){return io=io||new rs({"circle-radius":new Wi(G.paint_circle["circle-radius"]),"circle-color":new Wi(G.paint_circle["circle-color"]),"circle-blur":new Wi(G.paint_circle["circle-blur"]),"circle-opacity":new Wi(G.paint_circle["circle-opacity"]),"circle-translate":new Ji(G.paint_circle["circle-translate"]),"circle-translate-anchor":new Ji(G.paint_circle["circle-translate-anchor"]),"circle-pitch-scale":new Ji(G.paint_circle["circle-pitch-scale"]),"circle-pitch-alignment":new Ji(G.paint_circle["circle-pitch-alignment"]),"circle-stroke-width":new Wi(G.paint_circle["circle-stroke-width"]),"circle-stroke-color":new Wi(G.paint_circle["circle-stroke-color"]),"circle-stroke-opacity":new Wi(G.paint_circle["circle-stroke-opacity"])})},get layout(){return no=no||new rs({"circle-sort-key":new Wi(G.layout_circle["circle-sort-key"])})}},ao=1e-6,oo="undefined"!=typeof Float32Array?Float32Array:Array;function lo(t){return t[0]=1,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=1,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=1,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t}function uo(t,e,r){var n=e[0],i=e[1],s=e[2],a=e[3],o=e[4],l=e[5],u=e[6],c=e[7],h=e[8],p=e[9],f=e[10],d=e[11],y=e[12],m=e[13],g=e[14],x=e[15],v=r[0],b=r[1],w=r[2],_=r[3];return t[0]=v*n+b*o+w*h+_*y,t[1]=v*i+b*l+w*p+_*m,t[2]=v*s+b*u+w*f+_*g,t[3]=v*a+b*c+w*d+_*x,t[4]=(v=r[4])*n+(b=r[5])*o+(w=r[6])*h+(_=r[7])*y,t[5]=v*i+b*l+w*p+_*m,t[6]=v*s+b*u+w*f+_*g,t[7]=v*a+b*c+w*d+_*x,t[8]=(v=r[8])*n+(b=r[9])*o+(w=r[10])*h+(_=r[11])*y,t[9]=v*i+b*l+w*p+_*m,t[10]=v*s+b*u+w*f+_*g,t[11]=v*a+b*c+w*d+_*x,t[12]=(v=r[12])*n+(b=r[13])*o+(w=r[14])*h+(_=r[15])*y,t[13]=v*i+b*l+w*p+_*m,t[14]=v*s+b*u+w*f+_*g,t[15]=v*a+b*c+w*d+_*x,t}Math.hypot||(Math.hypot=function(){for(var t=0,e=arguments.length;e--;)t+=arguments[e]*arguments[e];return Math.sqrt(t)});var co,ho=uo;function po(t,e,r){var n=e[0],i=e[1],s=e[2],a=e[3];return t[0]=r[0]*n+r[4]*i+r[8]*s+r[12]*a,t[1]=r[1]*n+r[5]*i+r[9]*s+r[13]*a,t[2]=r[2]*n+r[6]*i+r[10]*s+r[14]*a,t[3]=r[3]*n+r[7]*i+r[11]*s+r[15]*a,t}co=new oo(4),oo!=Float32Array&&(co[0]=0,co[1]=0,co[2]=0,co[3]=0);class fo extends is{constructor(t){super(t,so);}createBucket(t){return new Ua(t)}queryRadius(t){const e=t;return to("circle-radius",this,e)+to("circle-stroke-width",this,e)+eo(this.paint.get("circle-translate"))}queryIntersectsFeature(t,e,r,n,i,s,a,o){const l=ro(t,this.paint.get("circle-translate"),this.paint.get("circle-translate-anchor"),s.angle,a),u=this.paint.get("circle-radius").evaluate(e,r)+this.paint.get("circle-stroke-width").evaluate(e,r),c="map"===this.paint.get("circle-pitch-alignment"),h=c?l:function(t,e){return t.map((t=>yo(t,e)))}(l,o),p=c?u*a:u;for(const t of n)for(const e of t){const t=c?e:yo(e,o);let r=p;const n=po([],[e.x,e.y,0,1],o);if("viewport"===this.paint.get("circle-pitch-scale")&&"map"===this.paint.get("circle-pitch-alignment")?r*=n[3]/s.cameraToCenterDistance:"map"===this.paint.get("circle-pitch-scale")&&"viewport"===this.paint.get("circle-pitch-alignment")&&(r*=s.cameraToCenterDistance/n[3]),Na(h,t,r))return !0}return !1}}function yo(t,e){const r=po([],[t.x,t.y,0,1],e);return new s(r[0]/r[3],r[1]/r[3])}class mo extends Ua{}let go;wi("HeatmapBucket",mo,{omit:["layers"]});var xo={get paint(){return go=go||new rs({"heatmap-radius":new Wi(G.paint_heatmap["heatmap-radius"]),"heatmap-weight":new Wi(G.paint_heatmap["heatmap-weight"]),"heatmap-intensity":new Ji(G.paint_heatmap["heatmap-intensity"]),"heatmap-color":new es(G.paint_heatmap["heatmap-color"]),"heatmap-opacity":new Ji(G.paint_heatmap["heatmap-opacity"])})}};function vo(t,{width:e,height:r},n,i){if(i){if(i instanceof Uint8ClampedArray)i=new Uint8Array(i.buffer);else if(i.length!==e*r*n)throw new RangeError(`mismatched image size. expected: ${i.length} but got: ${e*r*n}`)}else i=new Uint8Array(e*r*n);return t.width=e,t.height=r,t.data=i,t}function bo(t,{width:e,height:r},n){if(e===t.width&&r===t.height)return;const i=vo({},{width:e,height:r},n);wo(t,i,{x:0,y:0},{x:0,y:0},{width:Math.min(t.width,e),height:Math.min(t.height,r)},n),t.width=e,t.height=r,t.data=i.data;}function wo(t,e,r,n,i,s){if(0===i.width||0===i.height)return e;if(i.width>t.width||i.height>t.height||r.x>t.width-i.width||r.y>t.height-i.height)throw new RangeError("out of range source coordinates for image copy");if(i.width>e.width||i.height>e.height||n.x>e.width-i.width||n.y>e.height-i.height)throw new RangeError("out of range destination coordinates for image copy");const a=t.data,o=e.data;if(a===o)throw new Error("srcData equals dstData, so image is already copied");for(let l=0;l<i.height;l++){const u=((r.y+l)*t.width+r.x)*s,c=((n.y+l)*e.width+n.x)*s;for(let t=0;t<i.width*s;t++)o[c+t]=a[u+t];}return e}class _o{constructor(t,e){vo(this,t,1,e);}resize(t){bo(this,t,1);}clone(){return new _o({width:this.width,height:this.height},new Uint8Array(this.data))}static copy(t,e,r,n,i){wo(t,e,r,n,i,1);}}class Ao{constructor(t,e){vo(this,t,4,e);}resize(t){bo(this,t,4);}replace(t,e){e?this.data.set(t):this.data=t instanceof Uint8ClampedArray?new Uint8Array(t.buffer):t;}clone(){return new Ao({width:this.width,height:this.height},new Uint8Array(this.data))}static copy(t,e,r,n,i){wo(t,e,r,n,i,4);}}function So(t){const e={},r=t.resolution||256,n=t.clips?t.clips.length:1,i=t.image||new Ao({width:r,height:n});if(Math.log(r)/Math.LN2%1!=0)throw new Error(`width is not a power of 2 - ${r}`);const s=(r,n,s)=>{e[t.evaluationKey]=s;const a=t.expression.evaluate(e);i.data[r+n+0]=Math.floor(255*a.r/a.a),i.data[r+n+1]=Math.floor(255*a.g/a.a),i.data[r+n+2]=Math.floor(255*a.b/a.a),i.data[r+n+3]=Math.floor(255*a.a);};if(t.clips)for(let e=0,i=0;e<n;++e,i+=4*r)for(let n=0,a=0;n<r;n++,a+=4){const o=n/(r-1),{start:l,end:u}=t.clips[e];s(i,a,l*(1-o)+u*o);}else for(let t=0,e=0;t<r;t++,e+=4)s(0,e,t/(r-1));return i}wi("AlphaImage",_o),wi("RGBAImage",Ao);class ko extends is{createBucket(t){return new mo(t)}constructor(t){super(t,xo),this._updateColorRamp();}_handleSpecialPaintPropertyUpdate(t){"heatmap-color"===t&&this._updateColorRamp();}_updateColorRamp(){this.colorRamp=So({expression:this._transitionablePaint._values["heatmap-color"].value.expression,evaluationKey:"heatmapDensity",image:this.colorRamp}),this.colorRampTexture=null;}resize(){this.heatmapFbo&&(this.heatmapFbo.destroy(),this.heatmapFbo=null);}queryRadius(){return 0}queryIntersectsFeature(){return !1}hasOffscreenPass(){return 0!==this.paint.get("heatmap-opacity")&&"none"!==this.visibility}}let Mo;var Io={get paint(){return Mo=Mo||new rs({"hillshade-illumination-direction":new Ji(G.paint_hillshade["hillshade-illumination-direction"]),"hillshade-illumination-anchor":new Ji(G.paint_hillshade["hillshade-illumination-anchor"]),"hillshade-exaggeration":new Ji(G.paint_hillshade["hillshade-exaggeration"]),"hillshade-shadow-color":new Ji(G.paint_hillshade["hillshade-shadow-color"]),"hillshade-highlight-color":new Ji(G.paint_hillshade["hillshade-highlight-color"]),"hillshade-accent-color":new Ji(G.paint_hillshade["hillshade-accent-color"])})}};class zo extends is{constructor(t){super(t,Io);}hasOffscreenPass(){return 0!==this.paint.get("hillshade-exaggeration")&&"none"!==this.visibility}}const Po=ls([{name:"a_pos",components:2,type:"Int16"}],4),{members:Co}=Po;function Bo(t,e,r=2){const n=e&&e.length,i=n?e[0]*r:t.length;let s=Vo(t,0,i,r,!0);const a=[];if(!s||s.next===s.prev)return a;let o,l,u;if(n&&(s=function(t,e,r,n){const i=[];for(let r=0,s=e.length;r<s;r++){const a=Vo(t,e[r]*n,r<s-1?e[r+1]*n:t.length,n,!1);a===a.next&&(a.steiner=!0),i.push(qo(a));}i.sort(Oo);for(let t=0;t<i.length;t++)r=jo(i[t],r);return r}(t,e,s,r)),t.length>80*r){o=1/0,l=1/0;let e=-1/0,n=-1/0;for(let s=r;s<i;s+=r){const r=t[s],i=t[s+1];r<o&&(o=r),i<l&&(l=i),r>e&&(e=r),i>n&&(n=i);}u=Math.max(e-o,n-l),u=0!==u?32767/u:0;}return Fo(s,a,r,o,l,u,0),a}function Vo(t,e,r,n,i){let s;if(i===function(t,e,r,n){let i=0;for(let s=e,a=r-n;s<r;s+=n)i+=(t[a]-t[s])*(t[s+1]+t[a+1]),a=s;return i}(t,e,r,n)>0)for(let i=e;i<r;i+=n)s=Qo(i/n|0,t[i],t[i+1],s);else for(let i=r-n;i>=e;i-=n)s=Qo(i/n|0,t[i],t[i+1],s);return s&&Ko(s,s.next)&&(tl(s),s=s.next),s}function Eo(t,e){if(!t)return t;e||(e=t);let r,n=t;do{if(r=!1,n.steiner||!Ko(n,n.next)&&0!==Go(n.prev,n,n.next))n=n.next;else {if(tl(n),n=e=n.prev,n===n.next)break;r=!0;}}while(r||n!==e);return e}function Fo(t,e,r,n,i,s,a){if(!t)return;!a&&s&&function(t,e,r,n){let i=t;do{0===i.z&&(i.z=Uo(i.x,i.y,e,r,n)),i.prevZ=i.prev,i.nextZ=i.next,i=i.next;}while(i!==t);i.prevZ.nextZ=null,i.prevZ=null,function(t){let e,r=1;do{let n,i=t;t=null;let s=null;for(e=0;i;){e++;let a=i,o=0;for(let t=0;t<r&&(o++,a=a.nextZ,a);t++);let l=r;for(;o>0||l>0&&a;)0!==o&&(0===l||!a||i.z<=a.z)?(n=i,i=i.nextZ,o--):(n=a,a=a.nextZ,l--),s?s.nextZ=n:t=n,n.prevZ=s,s=n;i=a;}s.nextZ=null,r*=2;}while(e>1)}(i);}(t,n,i,s);let o=t;for(;t.prev!==t.next;){const l=t.prev,u=t.next;if(s?$o(t,n,i,s):To(t))e.push(l.i,t.i,u.i),tl(t),t=u.next,o=u.next;else if((t=u)===o){a?1===a?Fo(t=Lo(Eo(t),e),e,r,n,i,s,2):2===a&&Do(t,e,r,n,i,s):Fo(Eo(t),e,r,n,i,s,1);break}}}function To(t){const e=t.prev,r=t,n=t.next;if(Go(e,r,n)>=0)return !1;const i=e.x,s=r.x,a=n.x,o=e.y,l=r.y,u=n.y,c=i<s?i<a?i:a:s<a?s:a,h=o<l?o<u?o:u:l<u?l:u,p=i>s?i>a?i:a:s>a?s:a,f=o>l?o>u?o:u:l>u?l:u;let d=n.next;for(;d!==e;){if(d.x>=c&&d.x<=p&&d.y>=h&&d.y<=f&&No(i,o,s,l,a,u,d.x,d.y)&&Go(d.prev,d,d.next)>=0)return !1;d=d.next;}return !0}function $o(t,e,r,n){const i=t.prev,s=t,a=t.next;if(Go(i,s,a)>=0)return !1;const o=i.x,l=s.x,u=a.x,c=i.y,h=s.y,p=a.y,f=o<l?o<u?o:u:l<u?l:u,d=c<h?c<p?c:p:h<p?h:p,y=o>l?o>u?o:u:l>u?l:u,m=c>h?c>p?c:p:h>p?h:p,g=Uo(f,d,e,r,n),x=Uo(y,m,e,r,n);let v=t.prevZ,b=t.nextZ;for(;v&&v.z>=g&&b&&b.z<=x;){if(v.x>=f&&v.x<=y&&v.y>=d&&v.y<=m&&v!==i&&v!==a&&No(o,c,l,h,u,p,v.x,v.y)&&Go(v.prev,v,v.next)>=0)return !1;if(v=v.prevZ,b.x>=f&&b.x<=y&&b.y>=d&&b.y<=m&&b!==i&&b!==a&&No(o,c,l,h,u,p,b.x,b.y)&&Go(b.prev,b,b.next)>=0)return !1;b=b.nextZ;}for(;v&&v.z>=g;){if(v.x>=f&&v.x<=y&&v.y>=d&&v.y<=m&&v!==i&&v!==a&&No(o,c,l,h,u,p,v.x,v.y)&&Go(v.prev,v,v.next)>=0)return !1;v=v.prevZ;}for(;b&&b.z<=x;){if(b.x>=f&&b.x<=y&&b.y>=d&&b.y<=m&&b!==i&&b!==a&&No(o,c,l,h,u,p,b.x,b.y)&&Go(b.prev,b,b.next)>=0)return !1;b=b.nextZ;}return !0}function Lo(t,e){let r=t;do{const n=r.prev,i=r.next.next;!Ko(n,i)&&Xo(n,r,r.next,i)&&Jo(n,i)&&Jo(i,n)&&(e.push(n.i,r.i,i.i),tl(r),tl(r.next),r=t=i),r=r.next;}while(r!==t);return Eo(r)}function Do(t,e,r,n,i,s){let a=t;do{let t=a.next.next;for(;t!==a.prev;){if(a.i!==t.i&&Zo(a,t)){let o=Wo(a,t);return a=Eo(a,a.next),o=Eo(o,o.next),Fo(a,e,r,n,i,s,0),void Fo(o,e,r,n,i,s,0)}t=t.next;}a=a.next;}while(a!==t)}function Oo(t,e){return t.x-e.x}function jo(t,e){const r=function(t,e){let r=e;const n=t.x,i=t.y;let s,a=-1/0;do{if(i<=r.y&&i>=r.next.y&&r.next.y!==r.y){const t=r.x+(i-r.y)*(r.next.x-r.x)/(r.next.y-r.y);if(t<=n&&t>a&&(a=t,s=r.x<r.next.x?r:r.next,t===n))return s}r=r.next;}while(r!==e);if(!s)return null;const o=s,l=s.x,u=s.y;let c=1/0;r=s;do{if(n>=r.x&&r.x>=l&&n!==r.x&&No(i<u?n:a,i,l,u,i<u?a:n,i,r.x,r.y)){const e=Math.abs(i-r.y)/(n-r.x);Jo(r,t)&&(e<c||e===c&&(r.x>s.x||r.x===s.x&&Ro(s,r)))&&(s=r,c=e);}r=r.next;}while(r!==o);return s}(t,e);if(!r)return e;const n=Wo(r,t);return Eo(n,n.next),Eo(r,r.next)}function Ro(t,e){return Go(t.prev,t,e.prev)<0&&Go(e.next,t,t.next)<0}function Uo(t,e,r,n,i){return (t=1431655765&((t=858993459&((t=252645135&((t=16711935&((t=(t-r)*i|0)|t<<8))|t<<4))|t<<2))|t<<1))|(e=1431655765&((e=858993459&((e=252645135&((e=16711935&((e=(e-n)*i|0)|e<<8))|e<<4))|e<<2))|e<<1))<<1}function qo(t){let e=t,r=t;do{(e.x<r.x||e.x===r.x&&e.y<r.y)&&(r=e),e=e.next;}while(e!==t);return r}function No(t,e,r,n,i,s,a,o){return (i-a)*(e-o)>=(t-a)*(s-o)&&(t-a)*(n-o)>=(r-a)*(e-o)&&(r-a)*(s-o)>=(i-a)*(n-o)}function Zo(t,e){return t.next.i!==e.i&&t.prev.i!==e.i&&!function(t,e){let r=t;do{if(r.i!==t.i&&r.next.i!==t.i&&r.i!==e.i&&r.next.i!==e.i&&Xo(r,r.next,t,e))return !0;r=r.next;}while(r!==t);return !1}(t,e)&&(Jo(t,e)&&Jo(e,t)&&function(t,e){let r=t,n=!1;const i=(t.x+e.x)/2,s=(t.y+e.y)/2;do{r.y>s!=r.next.y>s&&r.next.y!==r.y&&i<(r.next.x-r.x)*(s-r.y)/(r.next.y-r.y)+r.x&&(n=!n),r=r.next;}while(r!==t);return n}(t,e)&&(Go(t.prev,t,e.prev)||Go(t,e.prev,e))||Ko(t,e)&&Go(t.prev,t,t.next)>0&&Go(e.prev,e,e.next)>0)}function Go(t,e,r){return (e.y-t.y)*(r.x-e.x)-(e.x-t.x)*(r.y-e.y)}function Ko(t,e){return t.x===e.x&&t.y===e.y}function Xo(t,e,r,n){const i=Yo(Go(t,e,r)),s=Yo(Go(t,e,n)),a=Yo(Go(r,n,t)),o=Yo(Go(r,n,e));return i!==s&&a!==o||!(0!==i||!Ho(t,r,e))||!(0!==s||!Ho(t,n,e))||!(0!==a||!Ho(r,t,n))||!(0!==o||!Ho(r,e,n))}function Ho(t,e,r){return e.x<=Math.max(t.x,r.x)&&e.x>=Math.min(t.x,r.x)&&e.y<=Math.max(t.y,r.y)&&e.y>=Math.min(t.y,r.y)}function Yo(t){return t>0?1:t<0?-1:0}function Jo(t,e){return Go(t.prev,t,t.next)<0?Go(t,e,t.next)>=0&&Go(t,t.prev,e)>=0:Go(t,e,t.prev)<0||Go(t,t.next,e)<0}function Wo(t,e){const r=el(t.i,t.x,t.y),n=el(e.i,e.x,e.y),i=t.next,s=e.prev;return t.next=e,e.prev=t,r.next=i,i.prev=r,n.next=r,r.prev=n,s.next=n,n.prev=s,n}function Qo(t,e,r,n){const i=el(t,e,r);return n?(i.next=n.next,i.prev=n,n.next.prev=i,n.next=i):(i.prev=i,i.next=i),i}function tl(t){t.next.prev=t.prev,t.prev.next=t.next,t.prevZ&&(t.prevZ.nextZ=t.nextZ),t.nextZ&&(t.nextZ.prevZ=t.prevZ);}function el(t,e,r){return {i:t,x:e,y:r,prev:null,next:null,z:0,prevZ:null,nextZ:null,steiner:!1}}function rl(t,e,r){const n=r.patternDependencies;let i=!1;for(const r of e){const e=r.paint.get(`${t}-pattern`);e.isConstant()||(i=!0);const s=e.constantOr(null);s&&(i=!0,n[s.to]=!0,n[s.from]=!0);}return i}function nl(t,e,r,n,i){const s=i.patternDependencies;for(const a of e){const e=a.paint.get(`${t}-pattern`).value;if("constant"!==e.kind){let t=e.evaluate({zoom:n-1},r,{},i.availableImages),o=e.evaluate({zoom:n},r,{},i.availableImages),l=e.evaluate({zoom:n+1},r,{},i.availableImages);t=t&&t.name?t.name:t,o=o&&o.name?o.name:o,l=l&&l.name?l.name:l,s[t]=!0,s[o]=!0,s[l]=!0,r.patterns[a.id]={min:t,mid:o,max:l};}}return r}class il{constructor(t){this.zoom=t.zoom,this.overscaling=t.overscaling,this.layers=t.layers,this.layerIds=this.layers.map((t=>t.id)),this.index=t.index,this.hasPattern=!1,this.patternFeatures=[],this.layoutVertexArray=new Ks,this.indexArray=new na,this.indexArray2=new ia,this.programConfigurations=new Ea(t.layers,t.zoom),this.segments=new oa,this.segments2=new oa,this.stateDependentLayerIds=this.layers.filter((t=>t.isStateDependent())).map((t=>t.id));}populate(t,e,r){this.hasPattern=rl("fill",this.layers,e);const n=this.layers[0].layout.get("fill-sort-key"),i=!n.isConstant(),s=[];for(const{feature:a,id:o,index:l,sourceLayerIndex:u}of t){const t=this.layers[0]._featureFilter.needGeometry,c=ja(a,t);if(!this.layers[0]._featureFilter.filter(new Ui(this.zoom),c,r))continue;const h=i?n.evaluate(c,{},r,e.availableImages):void 0,p={id:o,properties:a.properties,type:a.type,sourceLayerIndex:u,index:l,geometry:t?c.geometry:Oa(a),patterns:{},sortKey:h};s.push(p);}i&&s.sort(((t,e)=>t.sortKey-e.sortKey));for(const n of s){const{geometry:i,index:s,sourceLayerIndex:a}=n;if(this.hasPattern){const t=nl("fill",this.layers,n,this.zoom,e);this.patternFeatures.push(t);}else this.addFeature(n,i,s,r,{});e.featureIndex.insert(t[s].feature,i,s,a,this.index);}}update(t,e,r){this.stateDependentLayers.length&&this.programConfigurations.updatePaintArrays(t,e,this.stateDependentLayers,r);}addFeatures(t,e,r){for(const t of this.patternFeatures)this.addFeature(t,t.geometry,t.index,e,r);}isEmpty(){return 0===this.layoutVertexArray.length}uploadPending(){return !this.uploaded||this.programConfigurations.needsUpload}upload(t){this.uploaded||(this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,Co),this.indexBuffer=t.createIndexBuffer(this.indexArray),this.indexBuffer2=t.createIndexBuffer(this.indexArray2)),this.programConfigurations.upload(t),this.uploaded=!0;}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.indexBuffer2.destroy(),this.programConfigurations.destroy(),this.segments.destroy(),this.segments2.destroy());}addFeature(t,e,r,n,i){for(const t of xr(e,500)){let e=0;for(const r of t)e+=r.length;const r=this.segments.prepareSegment(e,this.layoutVertexArray,this.indexArray),n=r.vertexLength,i=[],s=[];for(const e of t){if(0===e.length)continue;e!==t[0]&&s.push(i.length/2);const r=this.segments2.prepareSegment(e.length,this.layoutVertexArray,this.indexArray2),n=r.vertexLength;this.layoutVertexArray.emplaceBack(e[0].x,e[0].y),this.indexArray2.emplaceBack(n+e.length-1,n),i.push(e[0].x),i.push(e[0].y);for(let t=1;t<e.length;t++)this.layoutVertexArray.emplaceBack(e[t].x,e[t].y),this.indexArray2.emplaceBack(n+t-1,n+t),i.push(e[t].x),i.push(e[t].y);r.vertexLength+=e.length,r.primitiveLength+=e.length;}const a=Bo(i,s);for(let t=0;t<a.length;t+=3)this.indexArray.emplaceBack(n+a[t],n+a[t+1],n+a[t+2]);r.vertexLength+=e,r.primitiveLength+=a.length/3;}this.programConfigurations.populatePaintArrays(this.layoutVertexArray.length,t,r,i,n);}}let sl,al;wi("FillBucket",il,{omit:["layers","patternFeatures"]});var ol={get paint(){return al=al||new rs({"fill-antialias":new Ji(G.paint_fill["fill-antialias"]),"fill-opacity":new Wi(G.paint_fill["fill-opacity"]),"fill-color":new Wi(G.paint_fill["fill-color"]),"fill-outline-color":new Wi(G.paint_fill["fill-outline-color"]),"fill-translate":new Ji(G.paint_fill["fill-translate"]),"fill-translate-anchor":new Ji(G.paint_fill["fill-translate-anchor"]),"fill-pattern":new Qi(G.paint_fill["fill-pattern"])})},get layout(){return sl=sl||new rs({"fill-sort-key":new Wi(G.layout_fill["fill-sort-key"])})}};class ll extends is{constructor(t){super(t,ol);}recalculate(t,e){super.recalculate(t,e);const r=this.paint._values["fill-outline-color"];"constant"===r.value.kind&&void 0===r.value.value&&(this.paint._values["fill-outline-color"]=this.paint._values["fill-color"]);}createBucket(t){return new il(t)}queryRadius(){return eo(this.paint.get("fill-translate"))}queryIntersectsFeature(t,e,r,n,i,s,a){return Za(ro(t,this.paint.get("fill-translate"),this.paint.get("fill-translate-anchor"),s.angle,a),n)}isTileClipped(){return !0}}const ul=ls([{name:"a_pos",components:2,type:"Int16"},{name:"a_normal_ed",components:4,type:"Int16"}],4),cl=ls([{name:"a_centroid",components:2,type:"Int16"}],4),{members:hl}=ul;var pl={},fl=n,dl=yl;function yl(t,e,r,n,i){this.properties={},this.extent=r,this.type=0,this._pbf=t,this._geometry=-1,this._keys=n,this._values=i,t.readFields(ml,this,e);}function ml(t,e,r){1==t?e.id=r.readVarint():2==t?function(t,e){for(var r=t.readVarint()+t.pos;t.pos<r;){var n=e._keys[t.readVarint()],i=e._values[t.readVarint()];e.properties[n]=i;}}(r,e):3==t?e.type=r.readVarint():4==t&&(e._geometry=r.pos);}function gl(t){for(var e,r,n=0,i=0,s=t.length,a=s-1;i<s;a=i++)n+=((r=t[a]).x-(e=t[i]).x)*(e.y+r.y);return n}yl.types=["Unknown","Point","LineString","Polygon"],yl.prototype.loadGeometry=function(){var t=this._pbf;t.pos=this._geometry;for(var e,r=t.readVarint()+t.pos,n=1,i=0,s=0,a=0,o=[];t.pos<r;){if(i<=0){var l=t.readVarint();n=7&l,i=l>>3;}if(i--,1===n||2===n)s+=t.readSVarint(),a+=t.readSVarint(),1===n&&(e&&o.push(e),e=[]),e.push(new fl(s,a));else {if(7!==n)throw new Error("unknown command "+n);e&&e.push(e[0].clone());}}return e&&o.push(e),o},yl.prototype.bbox=function(){var t=this._pbf;t.pos=this._geometry;for(var e=t.readVarint()+t.pos,r=1,n=0,i=0,s=0,a=1/0,o=-1/0,l=1/0,u=-1/0;t.pos<e;){if(n<=0){var c=t.readVarint();r=7&c,n=c>>3;}if(n--,1===r||2===r)(i+=t.readSVarint())<a&&(a=i),i>o&&(o=i),(s+=t.readSVarint())<l&&(l=s),s>u&&(u=s);else if(7!==r)throw new Error("unknown command "+r)}return [a,l,o,u]},yl.prototype.toGeoJSON=function(t,e,r){var n,i,s=this.extent*Math.pow(2,r),a=this.extent*t,o=this.extent*e,l=this.loadGeometry(),u=yl.types[this.type];function c(t){for(var e=0;e<t.length;e++){var r=t[e];t[e]=[360*(r.x+a)/s-180,360/Math.PI*Math.atan(Math.exp((180-360*(r.y+o)/s)*Math.PI/180))-90];}}switch(this.type){case 1:var h=[];for(n=0;n<l.length;n++)h[n]=l[n][0];c(l=h);break;case 2:for(n=0;n<l.length;n++)c(l[n]);break;case 3:for(l=function(t){var e=t.length;if(e<=1)return [t];for(var r,n,i=[],s=0;s<e;s++){var a=gl(t[s]);0!==a&&(void 0===n&&(n=a<0),n===a<0?(r&&i.push(r),r=[t[s]]):r.push(t[s]));}return r&&i.push(r),i}(l),n=0;n<l.length;n++)for(i=0;i<l[n].length;i++)c(l[n][i]);}1===l.length?l=l[0]:u="Multi"+u;var p={type:"Feature",geometry:{type:u,coordinates:l},properties:this.properties};return "id"in this&&(p.id=this.id),p};var xl=dl,vl=bl;function bl(t,e){this.version=1,this.name=null,this.extent=4096,this.length=0,this._pbf=t,this._keys=[],this._values=[],this._features=[],t.readFields(wl,this,e),this.length=this._features.length;}function wl(t,e,r){15===t?e.version=r.readVarint():1===t?e.name=r.readString():5===t?e.extent=r.readVarint():2===t?e._features.push(r.pos):3===t?e._keys.push(r.readString()):4===t&&e._values.push(function(t){for(var e=null,r=t.readVarint()+t.pos;t.pos<r;){var n=t.readVarint()>>3;e=1===n?t.readString():2===n?t.readFloat():3===n?t.readDouble():4===n?t.readVarint64():5===n?t.readVarint():6===n?t.readSVarint():7===n?t.readBoolean():null;}return e}(r));}bl.prototype.feature=function(t){if(t<0||t>=this._features.length)throw new Error("feature index out of bounds");this._pbf.pos=this._features[t];var e=this._pbf.readVarint()+this._pbf.pos;return new xl(this._pbf,e,this.extent,this._keys,this._values)};var _l=vl;function Al(t,e,r){if(3===t){var n=new _l(r,r.readVarint()+r.pos);n.length&&(e[n.name]=n);}}pl.VectorTile=function(t,e){this.layers=t.readFields(Al,{},e);},pl.VectorTileFeature=dl,pl.VectorTileLayer=vl;const Sl=pl.VectorTileFeature.types,kl=Math.pow(2,13);function Ml(t,e,r,n,i,s,a,o){t.emplaceBack(e,r,2*Math.floor(n*kl)+a,i*kl*2,s*kl*2,Math.round(o));}class Il{constructor(t){this.zoom=t.zoom,this.overscaling=t.overscaling,this.layers=t.layers,this.layerIds=this.layers.map((t=>t.id)),this.index=t.index,this.hasPattern=!1,this.layoutVertexArray=new Xs,this.centroidVertexArray=new Zs,this.indexArray=new na,this.programConfigurations=new Ea(t.layers,t.zoom),this.segments=new oa,this.stateDependentLayerIds=this.layers.filter((t=>t.isStateDependent())).map((t=>t.id));}populate(t,e,r){this.features=[],this.hasPattern=rl("fill-extrusion",this.layers,e);for(const{feature:n,id:i,index:s,sourceLayerIndex:a}of t){const t=this.layers[0]._featureFilter.needGeometry,o=ja(n,t);if(!this.layers[0]._featureFilter.filter(new Ui(this.zoom),o,r))continue;const l={id:i,sourceLayerIndex:a,index:s,geometry:t?o.geometry:Oa(n),properties:n.properties,type:n.type,patterns:{}};this.hasPattern?this.features.push(nl("fill-extrusion",this.layers,l,this.zoom,e)):this.addFeature(l,l.geometry,s,r,{}),e.featureIndex.insert(n,l.geometry,s,a,this.index,!0);}}addFeatures(t,e,r){for(const t of this.features){const{geometry:n}=t;this.addFeature(t,n,t.index,e,r);}}update(t,e,r){this.stateDependentLayers.length&&this.programConfigurations.updatePaintArrays(t,e,this.stateDependentLayers,r);}isEmpty(){return 0===this.layoutVertexArray.length&&0===this.centroidVertexArray.length}uploadPending(){return !this.uploaded||this.programConfigurations.needsUpload}upload(t){this.uploaded||(this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,hl),this.centroidVertexBuffer=t.createVertexBuffer(this.centroidVertexArray,cl.members,!0),this.indexBuffer=t.createIndexBuffer(this.indexArray)),this.programConfigurations.upload(t),this.uploaded=!0;}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.programConfigurations.destroy(),this.segments.destroy(),this.centroidVertexBuffer.destroy());}addFeature(t,e,r,n,i){for(const r of xr(e,500)){const e={x:0,y:0,vertexCount:0};let n=0;for(const t of r)n+=t.length;let i=this.segments.prepareSegment(4,this.layoutVertexArray,this.indexArray);for(const t of r){if(0===t.length)continue;if(Pl(t))continue;let r=0;for(let n=0;n<t.length;n++){const s=t[n];if(n>=1){const a=t[n-1];if(!zl(s,a)){i.vertexLength+4>oa.MAX_VERTEX_ARRAY_LENGTH&&(i=this.segments.prepareSegment(4,this.layoutVertexArray,this.indexArray));const t=s.sub(a)._perp()._unit(),n=a.dist(s);r+n>32768&&(r=0),Ml(this.layoutVertexArray,s.x,s.y,t.x,t.y,0,0,r),Ml(this.layoutVertexArray,s.x,s.y,t.x,t.y,0,1,r),e.x+=2*s.x,e.y+=2*s.y,e.vertexCount+=2,r+=n,Ml(this.layoutVertexArray,a.x,a.y,t.x,t.y,0,0,r),Ml(this.layoutVertexArray,a.x,a.y,t.x,t.y,0,1,r),e.x+=2*a.x,e.y+=2*a.y,e.vertexCount+=2;const o=i.vertexLength;this.indexArray.emplaceBack(o,o+2,o+1),this.indexArray.emplaceBack(o+1,o+2,o+3),i.vertexLength+=4,i.primitiveLength+=2;}}}}if(i.vertexLength+n>oa.MAX_VERTEX_ARRAY_LENGTH&&(i=this.segments.prepareSegment(n,this.layoutVertexArray,this.indexArray)),"Polygon"!==Sl[t.type])continue;const s=[],a=[],o=i.vertexLength;for(const t of r)if(0!==t.length){t!==r[0]&&a.push(s.length/2);for(let r=0;r<t.length;r++){const n=t[r];Ml(this.layoutVertexArray,n.x,n.y,0,0,1,1,0),e.x+=n.x,e.y+=n.y,e.vertexCount+=1,s.push(n.x),s.push(n.y);}}const l=Bo(s,a);for(let t=0;t<l.length;t+=3)this.indexArray.emplaceBack(o+l[t],o+l[t+2],o+l[t+1]);i.primitiveLength+=l.length/3,i.vertexLength+=n;for(let t=0;t<e.vertexCount;t++){const t=Math.floor(e.x/e.vertexCount),r=Math.floor(e.y/e.vertexCount);this.centroidVertexArray.emplaceBack(t,r);}}this.programConfigurations.populatePaintArrays(this.layoutVertexArray.length,t,r,i,n);}}function zl(t,e){return t.x===e.x&&(t.x<0||t.x>$a)||t.y===e.y&&(t.y<0||t.y>$a)}function Pl(t){return t.every((t=>t.x<0))||t.every((t=>t.x>$a))||t.every((t=>t.y<0))||t.every((t=>t.y>$a))}let Cl;wi("FillExtrusionBucket",Il,{omit:["layers","features"]});var Bl={get paint(){return Cl=Cl||new rs({"fill-extrusion-opacity":new Ji(G["paint_fill-extrusion"]["fill-extrusion-opacity"]),"fill-extrusion-color":new Wi(G["paint_fill-extrusion"]["fill-extrusion-color"]),"fill-extrusion-translate":new Ji(G["paint_fill-extrusion"]["fill-extrusion-translate"]),"fill-extrusion-translate-anchor":new Ji(G["paint_fill-extrusion"]["fill-extrusion-translate-anchor"]),"fill-extrusion-pattern":new Qi(G["paint_fill-extrusion"]["fill-extrusion-pattern"]),"fill-extrusion-height":new Wi(G["paint_fill-extrusion"]["fill-extrusion-height"]),"fill-extrusion-base":new Wi(G["paint_fill-extrusion"]["fill-extrusion-base"]),"fill-extrusion-vertical-gradient":new Ji(G["paint_fill-extrusion"]["fill-extrusion-vertical-gradient"])})}};class Vl extends is{constructor(t){super(t,Bl);}createBucket(t){return new Il(t)}queryRadius(){return eo(this.paint.get("fill-extrusion-translate"))}is3D(){return !0}queryIntersectsFeature(t,e,r,n,i,a,o,l){const u=ro(t,this.paint.get("fill-extrusion-translate"),this.paint.get("fill-extrusion-translate-anchor"),a.angle,o),c=this.paint.get("fill-extrusion-height").evaluate(e,r),h=this.paint.get("fill-extrusion-base").evaluate(e,r),p=function(t,e,r,n){const i=[];for(const r of t){const t=[r.x,r.y,0,1];po(t,t,e),i.push(new s(t[0]/t[3],t[1]/t[3]));}return i}(u,l),f=function(t,e,r,n){const i=[],a=[],o=n[8]*e,l=n[9]*e,u=n[10]*e,c=n[11]*e,h=n[8]*r,p=n[9]*r,f=n[10]*r,d=n[11]*r;for(const e of t){const t=[],r=[];for(const i of e){const e=i.x,a=i.y,y=n[0]*e+n[4]*a+n[12],m=n[1]*e+n[5]*a+n[13],g=n[2]*e+n[6]*a+n[14],x=n[3]*e+n[7]*a+n[15],v=g+u,b=x+c,w=y+h,_=m+p,A=g+f,S=x+d,k=new s((y+o)/b,(m+l)/b);k.z=v/b,t.push(k);const M=new s(w/S,_/S);M.z=A/S,r.push(M);}i.push(t),a.push(r);}return [i,a]}(n,h,c,l);return function(t,e,r){let n=1/0;Za(r,e)&&(n=Fl(r,e[0]));for(let i=0;i<e.length;i++){const s=e[i],a=t[i];for(let t=0;t<s.length-1;t++){const e=s[t],i=[e,s[t+1],a[t+1],a[t],e];qa(r,i)&&(n=Math.min(n,Fl(r,i)));}}return n!==1/0&&n}(f[0],f[1],p)}}function El(t,e){return t.x*e.x+t.y*e.y}function Fl(t,e){if(1===t.length){let r=0;const n=e[r++];let i;for(;!i||n.equals(i);)if(i=e[r++],!i)return 1/0;for(;r<e.length;r++){const s=e[r],a=t[0],o=i.sub(n),l=s.sub(n),u=a.sub(n),c=El(o,o),h=El(o,l),p=El(l,l),f=El(u,o),d=El(u,l),y=c*p-h*h,m=(p*f-h*d)/y,g=(c*d-h*f)/y,x=n.z*(1-m-g)+i.z*m+s.z*g;if(isFinite(x))return x}return 1/0}{let t=1/0;for(const r of e)t=Math.min(t,r.z);return t}}const Tl=ls([{name:"a_pos_normal",components:2,type:"Int16"},{name:"a_data",components:4,type:"Uint8"}],4),{members:$l}=Tl,Ll=ls([{name:"a_uv_x",components:1,type:"Float32"},{name:"a_split_index",components:1,type:"Float32"}]),{members:Dl}=Ll,Ol=pl.VectorTileFeature.types,jl=Math.cos(Math.PI/180*37.5),Rl=Math.pow(2,14)/.5;class Ul{constructor(t){this.zoom=t.zoom,this.overscaling=t.overscaling,this.layers=t.layers,this.layerIds=this.layers.map((t=>t.id)),this.index=t.index,this.hasPattern=!1,this.patternFeatures=[],this.lineClipsArray=[],this.gradients={},this.layers.forEach((t=>{this.gradients[t.id]={};})),this.layoutVertexArray=new Hs,this.layoutVertexArray2=new Ys,this.indexArray=new na,this.programConfigurations=new Ea(t.layers,t.zoom),this.segments=new oa,this.maxLineLength=0,this.stateDependentLayerIds=this.layers.filter((t=>t.isStateDependent())).map((t=>t.id));}populate(t,e,r){this.hasPattern=rl("line",this.layers,e);const n=this.layers[0].layout.get("line-sort-key"),i=!n.isConstant(),s=[];for(const{feature:e,id:a,index:o,sourceLayerIndex:l}of t){const t=this.layers[0]._featureFilter.needGeometry,u=ja(e,t);if(!this.layers[0]._featureFilter.filter(new Ui(this.zoom),u,r))continue;const c=i?n.evaluate(u,{},r):void 0,h={id:a,properties:e.properties,type:e.type,sourceLayerIndex:l,index:o,geometry:t?u.geometry:Oa(e),patterns:{},sortKey:c};s.push(h);}i&&s.sort(((t,e)=>t.sortKey-e.sortKey));for(const n of s){const{geometry:i,index:s,sourceLayerIndex:a}=n;if(this.hasPattern){const t=nl("line",this.layers,n,this.zoom,e);this.patternFeatures.push(t);}else this.addFeature(n,i,s,r,{});e.featureIndex.insert(t[s].feature,i,s,a,this.index);}}update(t,e,r){this.stateDependentLayers.length&&this.programConfigurations.updatePaintArrays(t,e,this.stateDependentLayers,r);}addFeatures(t,e,r){for(const t of this.patternFeatures)this.addFeature(t,t.geometry,t.index,e,r);}isEmpty(){return 0===this.layoutVertexArray.length}uploadPending(){return !this.uploaded||this.programConfigurations.needsUpload}upload(t){this.uploaded||(0!==this.layoutVertexArray2.length&&(this.layoutVertexBuffer2=t.createVertexBuffer(this.layoutVertexArray2,Dl)),this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,$l),this.indexBuffer=t.createIndexBuffer(this.indexArray)),this.programConfigurations.upload(t),this.uploaded=!0;}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.programConfigurations.destroy(),this.segments.destroy());}lineFeatureClips(t){if(t.properties&&Object.prototype.hasOwnProperty.call(t.properties,"mapbox_clip_start")&&Object.prototype.hasOwnProperty.call(t.properties,"mapbox_clip_end"))return {start:+t.properties.mapbox_clip_start,end:+t.properties.mapbox_clip_end}}addFeature(t,e,r,n,i){const s=this.layers[0].layout,a=s.get("line-join").evaluate(t,{}),o=s.get("line-cap"),l=s.get("line-miter-limit"),u=s.get("line-round-limit");this.lineClips=this.lineFeatureClips(t);for(const r of e)this.addLine(r,t,a,o,l,u);this.programConfigurations.populatePaintArrays(this.layoutVertexArray.length,t,r,i,n);}addLine(t,e,r,n,i,s){if(this.distance=0,this.scaledDistance=0,this.totalDistance=0,this.lineClips){this.lineClipsArray.push(this.lineClips);for(let e=0;e<t.length-1;e++)this.totalDistance+=t[e].dist(t[e+1]);this.updateScaledDistance(),this.maxLineLength=Math.max(this.maxLineLength,this.totalDistance);}const a="Polygon"===Ol[e.type];let o=t.length;for(;o>=2&&t[o-1].equals(t[o-2]);)o--;let l=0;for(;l<o-1&&t[l].equals(t[l+1]);)l++;if(o<(a?3:2))return;"bevel"===r&&(i=1.05);const u=this.overscaling<=16?15*$a/(512*this.overscaling):0,c=this.segments.prepareSegment(10*o,this.layoutVertexArray,this.indexArray);let h,p,f,d,y;this.e1=this.e2=-1,a&&(h=t[o-2],y=t[l].sub(h)._unit()._perp());for(let e=l;e<o;e++){if(f=e===o-1?a?t[l+1]:void 0:t[e+1],f&&t[e].equals(f))continue;y&&(d=y),h&&(p=h),h=t[e],y=f?f.sub(h)._unit()._perp():d,d=d||y;let m=d.add(y);0===m.x&&0===m.y||m._unit();const g=d.x*y.x+d.y*y.y,x=m.x*y.x+m.y*y.y,v=0!==x?1/x:1/0,b=2*Math.sqrt(2-2*x),w=x<jl&&p&&f,_=d.x*y.y-d.y*y.x>0;if(w&&e>l){const t=h.dist(p);if(t>2*u){const e=h.sub(h.sub(p)._mult(u/t)._round());this.updateDistance(p,e),this.addCurrentVertex(e,d,0,0,c),p=e;}}const A=p&&f;let S=A?r:a?"butt":n;if(A&&"round"===S&&(v<s?S="miter":v<=2&&(S="fakeround")),"miter"===S&&v>i&&(S="bevel"),"bevel"===S&&(v>2&&(S="flipbevel"),v<i&&(S="miter")),p&&this.updateDistance(p,h),"miter"===S)m._mult(v),this.addCurrentVertex(h,m,0,0,c);else if("flipbevel"===S){if(v>100)m=y.mult(-1);else {const t=v*d.add(y).mag()/d.sub(y).mag();m._perp()._mult(t*(_?-1:1));}this.addCurrentVertex(h,m,0,0,c),this.addCurrentVertex(h,m.mult(-1),0,0,c);}else if("bevel"===S||"fakeround"===S){const t=-Math.sqrt(v*v-1),e=_?t:0,r=_?0:t;if(p&&this.addCurrentVertex(h,d,e,r,c),"fakeround"===S){const t=Math.round(180*b/Math.PI/20);for(let e=1;e<t;e++){let r=e/t;if(.5!==r){const t=r-.5;r+=r*t*(r-1)*((1.0904+g*(g*(3.55645-1.43519*g)-3.2452))*t*t+(.848013+g*(.215638*g-1.06021)));}const n=y.sub(d)._mult(r)._add(d)._unit()._mult(_?-1:1);this.addHalfVertex(h,n.x,n.y,!1,_,0,c);}}f&&this.addCurrentVertex(h,y,-e,-r,c);}else if("butt"===S)this.addCurrentVertex(h,m,0,0,c);else if("square"===S){const t=p?1:-1;this.addCurrentVertex(h,m,t,t,c);}else "round"===S&&(p&&(this.addCurrentVertex(h,d,0,0,c),this.addCurrentVertex(h,d,1,1,c,!0)),f&&(this.addCurrentVertex(h,y,-1,-1,c,!0),this.addCurrentVertex(h,y,0,0,c)));if(w&&e<o-1){const t=h.dist(f);if(t>2*u){const e=h.add(f.sub(h)._mult(u/t)._round());this.updateDistance(h,e),this.addCurrentVertex(e,y,0,0,c),h=e;}}}}addCurrentVertex(t,e,r,n,i,s=!1){const a=e.y*n-e.x,o=-e.y-e.x*n;this.addHalfVertex(t,e.x+e.y*r,e.y-e.x*r,s,!1,r,i),this.addHalfVertex(t,a,o,s,!0,-n,i),this.distance>Rl/2&&0===this.totalDistance&&(this.distance=0,this.updateScaledDistance(),this.addCurrentVertex(t,e,r,n,i,s));}addHalfVertex({x:t,y:e},r,n,i,s,a,o){const l=.5*(this.lineClips?this.scaledDistance*(Rl-1):this.scaledDistance);this.layoutVertexArray.emplaceBack((t<<1)+(i?1:0),(e<<1)+(s?1:0),Math.round(63*r)+128,Math.round(63*n)+128,1+(0===a?0:a<0?-1:1)|(63&l)<<2,l>>6),this.lineClips&&this.layoutVertexArray2.emplaceBack((this.scaledDistance-this.lineClips.start)/(this.lineClips.end-this.lineClips.start),this.lineClipsArray.length);const u=o.vertexLength++;this.e1>=0&&this.e2>=0&&(this.indexArray.emplaceBack(this.e1,this.e2,u),o.primitiveLength++),s?this.e2=u:this.e1=u;}updateScaledDistance(){this.scaledDistance=this.lineClips?this.lineClips.start+(this.lineClips.end-this.lineClips.start)*this.distance/this.totalDistance:this.distance;}updateDistance(t,e){this.distance+=t.dist(e),this.updateScaledDistance();}}let ql,Nl;wi("LineBucket",Ul,{omit:["layers","patternFeatures"]});var Zl={get paint(){return Nl=Nl||new rs({"line-opacity":new Wi(G.paint_line["line-opacity"]),"line-color":new Wi(G.paint_line["line-color"]),"line-translate":new Ji(G.paint_line["line-translate"]),"line-translate-anchor":new Ji(G.paint_line["line-translate-anchor"]),"line-width":new Wi(G.paint_line["line-width"]),"line-gap-width":new Wi(G.paint_line["line-gap-width"]),"line-offset":new Wi(G.paint_line["line-offset"]),"line-blur":new Wi(G.paint_line["line-blur"]),"line-dasharray":new ts(G.paint_line["line-dasharray"]),"line-pattern":new Qi(G.paint_line["line-pattern"]),"line-gradient":new es(G.paint_line["line-gradient"])})},get layout(){return ql=ql||new rs({"line-cap":new Ji(G.layout_line["line-cap"]),"line-join":new Wi(G.layout_line["line-join"]),"line-miter-limit":new Ji(G.layout_line["line-miter-limit"]),"line-round-limit":new Ji(G.layout_line["line-round-limit"]),"line-sort-key":new Wi(G.layout_line["line-sort-key"])})}};class Gl extends Wi{possiblyEvaluate(t,e){return e=new Ui(Math.floor(e.zoom),{now:e.now,fadeDuration:e.fadeDuration,zoomHistory:e.zoomHistory,transition:e.transition}),super.possiblyEvaluate(t,e)}evaluate(t,e,r,n){return e=g({},e,{zoom:Math.floor(e.zoom)}),super.evaluate(t,e,r,n)}}let Kl;class Xl extends is{constructor(t){super(t,Zl),this.gradientVersion=0,Kl||(Kl=new Gl(Zl.paint.properties["line-width"].specification),Kl.useIntegerZoom=!0);}_handleSpecialPaintPropertyUpdate(t){if("line-gradient"===t){const t=this.gradientExpression();this.stepInterpolant=!!function(t){return void 0!==t._styleExpression}(t)&&t._styleExpression.expression instanceof Ae,this.gradientVersion=(this.gradientVersion+1)%Number.MAX_SAFE_INTEGER;}}gradientExpression(){return this._transitionablePaint._values["line-gradient"].value.expression}recalculate(t,e){super.recalculate(t,e),this.paint._values["line-floorwidth"]=Kl.possiblyEvaluate(this._transitioningPaint._values["line-width"].value,t);}createBucket(t){return new Ul(t)}queryRadius(t){const e=t,r=Hl(to("line-width",this,e),to("line-gap-width",this,e)),n=to("line-offset",this,e);return r/2+Math.abs(n)+eo(this.paint.get("line-translate"))}queryIntersectsFeature(t,e,r,n,i,a,o){const l=ro(t,this.paint.get("line-translate"),this.paint.get("line-translate-anchor"),a.angle,o),u=o/2*Hl(this.paint.get("line-width").evaluate(e,r),this.paint.get("line-gap-width").evaluate(e,r)),c=this.paint.get("line-offset").evaluate(e,r);return c&&(n=function(t,e){const r=[];for(let n=0;n<t.length;n++){const i=t[n],a=[];for(let t=0;t<i.length;t++){const r=i[t-1],n=i[t],o=i[t+1],l=0===t?new s(0,0):n.sub(r)._unit()._perp(),u=t===i.length-1?new s(0,0):o.sub(n)._unit()._perp(),c=l._add(u)._unit(),h=c.x*u.x+c.y*u.y;0!==h&&c._mult(1/h),a.push(c._mult(e)._add(n));}r.push(a);}return r}(n,c*o)),function(t,e,r){for(let n=0;n<e.length;n++){const i=e[n];if(t.length>=3)for(let e=0;e<i.length;e++)if(Wa(t,i[e]))return !0;if(Ga(t,i,r))return !0}return !1}(l,n,u)}isTileClipped(){return !0}}function Hl(t,e){return e>0?e+2*t:t}const Yl=ls([{name:"a_pos_offset",components:4,type:"Int16"},{name:"a_data",components:4,type:"Uint16"},{name:"a_pixeloffset",components:4,type:"Int16"}],4),Jl=ls([{name:"a_projected_pos",components:3,type:"Float32"}],4);ls([{name:"a_fade_opacity",components:1,type:"Uint32"}],4);const Wl=ls([{name:"a_placed",components:2,type:"Uint8"},{name:"a_shift",components:2,type:"Float32"},{name:"a_box_real",components:2,type:"Int16"}]);ls([{type:"Int16",name:"anchorPointX"},{type:"Int16",name:"anchorPointY"},{type:"Int16",name:"x1"},{type:"Int16",name:"y1"},{type:"Int16",name:"x2"},{type:"Int16",name:"y2"},{type:"Uint32",name:"featureIndex"},{type:"Uint16",name:"sourceLayerIndex"},{type:"Uint16",name:"bucketIndex"}]);const Ql=ls([{name:"a_pos",components:2,type:"Int16"},{name:"a_anchor_pos",components:2,type:"Int16"},{name:"a_extrude",components:2,type:"Int16"}],4),tu=ls([{name:"a_pos",components:2,type:"Float32"},{name:"a_radius",components:1,type:"Float32"},{name:"a_flags",components:2,type:"Int16"}],4);function eu(t,e,r){return t.sections.forEach((t=>{t.text=function(t,e,r){const n=e.layout.get("text-transform").evaluate(r,{});return "uppercase"===n?t=t.toLocaleUpperCase():"lowercase"===n&&(t=t.toLocaleLowerCase()),Ri.applyArabicShaping&&(t=Ri.applyArabicShaping(t)),t}(t.text,e,r);})),t}ls([{name:"triangle",components:3,type:"Uint16"}]),ls([{type:"Int16",name:"anchorX"},{type:"Int16",name:"anchorY"},{type:"Uint16",name:"glyphStartIndex"},{type:"Uint16",name:"numGlyphs"},{type:"Uint32",name:"vertexStartIndex"},{type:"Uint32",name:"lineStartIndex"},{type:"Uint32",name:"lineLength"},{type:"Uint16",name:"segment"},{type:"Uint16",name:"lowerSize"},{type:"Uint16",name:"upperSize"},{type:"Float32",name:"lineOffsetX"},{type:"Float32",name:"lineOffsetY"},{type:"Uint8",name:"writingMode"},{type:"Uint8",name:"placedOrientation"},{type:"Uint8",name:"hidden"},{type:"Uint32",name:"crossTileID"},{type:"Int16",name:"associatedIconIndex"}]),ls([{type:"Int16",name:"anchorX"},{type:"Int16",name:"anchorY"},{type:"Int16",name:"rightJustifiedTextSymbolIndex"},{type:"Int16",name:"centerJustifiedTextSymbolIndex"},{type:"Int16",name:"leftJustifiedTextSymbolIndex"},{type:"Int16",name:"verticalPlacedTextSymbolIndex"},{type:"Int16",name:"placedIconSymbolIndex"},{type:"Int16",name:"verticalPlacedIconSymbolIndex"},{type:"Uint16",name:"key"},{type:"Uint16",name:"textBoxStartIndex"},{type:"Uint16",name:"textBoxEndIndex"},{type:"Uint16",name:"verticalTextBoxStartIndex"},{type:"Uint16",name:"verticalTextBoxEndIndex"},{type:"Uint16",name:"iconBoxStartIndex"},{type:"Uint16",name:"iconBoxEndIndex"},{type:"Uint16",name:"verticalIconBoxStartIndex"},{type:"Uint16",name:"verticalIconBoxEndIndex"},{type:"Uint16",name:"featureIndex"},{type:"Uint16",name:"numHorizontalGlyphVertices"},{type:"Uint16",name:"numVerticalGlyphVertices"},{type:"Uint16",name:"numIconVertices"},{type:"Uint16",name:"numVerticalIconVertices"},{type:"Uint16",name:"useRuntimeCollisionCircles"},{type:"Uint32",name:"crossTileID"},{type:"Float32",name:"textBoxScale"},{type:"Float32",name:"collisionCircleDiameter"},{type:"Uint16",name:"textAnchorOffsetStartIndex"},{type:"Uint16",name:"textAnchorOffsetEndIndex"}]),ls([{type:"Float32",name:"offsetX"}]),ls([{type:"Int16",name:"x"},{type:"Int16",name:"y"},{type:"Int16",name:"tileUnitDistanceFromAnchor"}]),ls([{type:"Uint16",name:"textAnchor"},{type:"Float32",components:2,name:"textOffset"}]);const ru={"!":"︕","#":"＃",$:"＄","%":"％","&":"＆","(":"︵",")":"︶","*":"＊","+":"＋",",":"︐","-":"︲",".":"・","/":"／",":":"︓",";":"︔","<":"︿","=":"＝",">":"﹀","?":"︖","@":"＠","[":"﹇","\\":"＼","]":"﹈","^":"＾",_:"︳","`":"｀","{":"︷","|":"―","}":"︸","~":"～","¢":"￠","£":"￡","¥":"￥","¦":"￤","¬":"￢","¯":"￣","–":"︲","—":"︱","‘":"﹃","’":"﹄","“":"﹁","”":"﹂","…":"︙","‧":"・","₩":"￦","、":"︑","。":"︒","〈":"︿","〉":"﹀","《":"︽","》":"︾","「":"﹁","」":"﹂","『":"﹃","』":"﹄","【":"︻","】":"︼","〔":"︹","〕":"︺","〖":"︗","〗":"︘","！":"︕","（":"︵","）":"︶","，":"︐","－":"︲","．":"・","：":"︓","；":"︔","＜":"︿","＞":"﹀","？":"︖","［":"﹇","］":"﹈","＿":"︳","｛":"︷","｜":"―","｝":"︸","｟":"︵","｠":"︶","｡":"︒","｢":"﹁","｣":"﹂"};var nu=24,iu=ou,su=function(t,e,r,n,i){var s,a,o=8*i-n-1,l=(1<<o)-1,u=l>>1,c=-7,h=r?i-1:0,p=r?-1:1,f=t[e+h];for(h+=p,s=f&(1<<-c)-1,f>>=-c,c+=o;c>0;s=256*s+t[e+h],h+=p,c-=8);for(a=s&(1<<-c)-1,s>>=-c,c+=n;c>0;a=256*a+t[e+h],h+=p,c-=8);if(0===s)s=1-u;else {if(s===l)return a?NaN:1/0*(f?-1:1);a+=Math.pow(2,n),s-=u;}return (f?-1:1)*a*Math.pow(2,s-n)},au=function(t,e,r,n,i,s){var a,o,l,u=8*s-i-1,c=(1<<u)-1,h=c>>1,p=23===i?Math.pow(2,-24)-Math.pow(2,-77):0,f=n?0:s-1,d=n?1:-1,y=e<0||0===e&&1/e<0?1:0;for(e=Math.abs(e),isNaN(e)||e===1/0?(o=isNaN(e)?1:0,a=c):(a=Math.floor(Math.log(e)/Math.LN2),e*(l=Math.pow(2,-a))<1&&(a--,l*=2),(e+=a+h>=1?p/l:p*Math.pow(2,1-h))*l>=2&&(a++,l/=2),a+h>=c?(o=0,a=c):a+h>=1?(o=(e*l-1)*Math.pow(2,i),a+=h):(o=e*Math.pow(2,h-1)*Math.pow(2,i),a=0));i>=8;t[r+f]=255&o,f+=d,o/=256,i-=8);for(a=a<<i|o,u+=i;u>0;t[r+f]=255&a,f+=d,a/=256,u-=8);t[r+f-d]|=128*y;};function ou(t){this.buf=ArrayBuffer.isView&&ArrayBuffer.isView(t)?t:new Uint8Array(t||0),this.pos=0,this.type=0,this.length=this.buf.length;}ou.Varint=0,ou.Fixed64=1,ou.Bytes=2,ou.Fixed32=5;var lu=4294967296,uu=1/lu,cu="undefined"==typeof TextDecoder?null:new TextDecoder("utf-8");function hu(t){return t.type===ou.Bytes?t.readVarint()+t.pos:t.pos+1}function pu(t,e,r){return r?4294967296*e+(t>>>0):4294967296*(e>>>0)+(t>>>0)}function fu(t,e,r){var n=e<=16383?1:e<=2097151?2:e<=268435455?3:Math.floor(Math.log(e)/(7*Math.LN2));r.realloc(n);for(var i=r.pos-1;i>=t;i--)r.buf[i+n]=r.buf[i];}function du(t,e){for(var r=0;r<t.length;r++)e.writeVarint(t[r]);}function yu(t,e){for(var r=0;r<t.length;r++)e.writeSVarint(t[r]);}function mu(t,e){for(var r=0;r<t.length;r++)e.writeFloat(t[r]);}function gu(t,e){for(var r=0;r<t.length;r++)e.writeDouble(t[r]);}function xu(t,e){for(var r=0;r<t.length;r++)e.writeBoolean(t[r]);}function vu(t,e){for(var r=0;r<t.length;r++)e.writeFixed32(t[r]);}function bu(t,e){for(var r=0;r<t.length;r++)e.writeSFixed32(t[r]);}function wu(t,e){for(var r=0;r<t.length;r++)e.writeFixed64(t[r]);}function _u(t,e){for(var r=0;r<t.length;r++)e.writeSFixed64(t[r]);}function Au(t,e){return (t[e]|t[e+1]<<8|t[e+2]<<16)+16777216*t[e+3]}function Su(t,e,r){t[r]=e,t[r+1]=e>>>8,t[r+2]=e>>>16,t[r+3]=e>>>24;}function ku(t,e){return (t[e]|t[e+1]<<8|t[e+2]<<16)+(t[e+3]<<24)}ou.prototype={destroy:function(){this.buf=null;},readFields:function(t,e,r){for(r=r||this.length;this.pos<r;){var n=this.readVarint(),i=n>>3,s=this.pos;this.type=7&n,t(i,e,this),this.pos===s&&this.skip(n);}return e},readMessage:function(t,e){return this.readFields(t,e,this.readVarint()+this.pos)},readFixed32:function(){var t=Au(this.buf,this.pos);return this.pos+=4,t},readSFixed32:function(){var t=ku(this.buf,this.pos);return this.pos+=4,t},readFixed64:function(){var t=Au(this.buf,this.pos)+Au(this.buf,this.pos+4)*lu;return this.pos+=8,t},readSFixed64:function(){var t=Au(this.buf,this.pos)+ku(this.buf,this.pos+4)*lu;return this.pos+=8,t},readFloat:function(){var t=su(this.buf,this.pos,!0,23,4);return this.pos+=4,t},readDouble:function(){var t=su(this.buf,this.pos,!0,52,8);return this.pos+=8,t},readVarint:function(t){var e,r,n=this.buf;return e=127&(r=n[this.pos++]),r<128?e:(e|=(127&(r=n[this.pos++]))<<7,r<128?e:(e|=(127&(r=n[this.pos++]))<<14,r<128?e:(e|=(127&(r=n[this.pos++]))<<21,r<128?e:function(t,e,r){var n,i,s=r.buf;if(n=(112&(i=s[r.pos++]))>>4,i<128)return pu(t,n,e);if(n|=(127&(i=s[r.pos++]))<<3,i<128)return pu(t,n,e);if(n|=(127&(i=s[r.pos++]))<<10,i<128)return pu(t,n,e);if(n|=(127&(i=s[r.pos++]))<<17,i<128)return pu(t,n,e);if(n|=(127&(i=s[r.pos++]))<<24,i<128)return pu(t,n,e);if(n|=(1&(i=s[r.pos++]))<<31,i<128)return pu(t,n,e);throw new Error("Expected varint not more than 10 bytes")}(e|=(15&(r=n[this.pos]))<<28,t,this))))},readVarint64:function(){return this.readVarint(!0)},readSVarint:function(){var t=this.readVarint();return t%2==1?(t+1)/-2:t/2},readBoolean:function(){return Boolean(this.readVarint())},readString:function(){var t=this.readVarint()+this.pos,e=this.pos;return this.pos=t,t-e>=12&&cu?function(t,e,r){return cu.decode(t.subarray(e,r))}(this.buf,e,t):function(t,e,r){for(var n="",i=e;i<r;){var s,a,o,l=t[i],u=null,c=l>239?4:l>223?3:l>191?2:1;if(i+c>r)break;1===c?l<128&&(u=l):2===c?128==(192&(s=t[i+1]))&&(u=(31&l)<<6|63&s)<=127&&(u=null):3===c?(a=t[i+2],128==(192&(s=t[i+1]))&&128==(192&a)&&((u=(15&l)<<12|(63&s)<<6|63&a)<=2047||u>=55296&&u<=57343)&&(u=null)):4===c&&(a=t[i+2],o=t[i+3],128==(192&(s=t[i+1]))&&128==(192&a)&&128==(192&o)&&((u=(15&l)<<18|(63&s)<<12|(63&a)<<6|63&o)<=65535||u>=1114112)&&(u=null)),null===u?(u=65533,c=1):u>65535&&(u-=65536,n+=String.fromCharCode(u>>>10&1023|55296),u=56320|1023&u),n+=String.fromCharCode(u),i+=c;}return n}(this.buf,e,t)},readBytes:function(){var t=this.readVarint()+this.pos,e=this.buf.subarray(this.pos,t);return this.pos=t,e},readPackedVarint:function(t,e){if(this.type!==ou.Bytes)return t.push(this.readVarint(e));var r=hu(this);for(t=t||[];this.pos<r;)t.push(this.readVarint(e));return t},readPackedSVarint:function(t){if(this.type!==ou.Bytes)return t.push(this.readSVarint());var e=hu(this);for(t=t||[];this.pos<e;)t.push(this.readSVarint());return t},readPackedBoolean:function(t){if(this.type!==ou.Bytes)return t.push(this.readBoolean());var e=hu(this);for(t=t||[];this.pos<e;)t.push(this.readBoolean());return t},readPackedFloat:function(t){if(this.type!==ou.Bytes)return t.push(this.readFloat());var e=hu(this);for(t=t||[];this.pos<e;)t.push(this.readFloat());return t},readPackedDouble:function(t){if(this.type!==ou.Bytes)return t.push(this.readDouble());var e=hu(this);for(t=t||[];this.pos<e;)t.push(this.readDouble());return t},readPackedFixed32:function(t){if(this.type!==ou.Bytes)return t.push(this.readFixed32());var e=hu(this);for(t=t||[];this.pos<e;)t.push(this.readFixed32());return t},readPackedSFixed32:function(t){if(this.type!==ou.Bytes)return t.push(this.readSFixed32());var e=hu(this);for(t=t||[];this.pos<e;)t.push(this.readSFixed32());return t},readPackedFixed64:function(t){if(this.type!==ou.Bytes)return t.push(this.readFixed64());var e=hu(this);for(t=t||[];this.pos<e;)t.push(this.readFixed64());return t},readPackedSFixed64:function(t){if(this.type!==ou.Bytes)return t.push(this.readSFixed64());var e=hu(this);for(t=t||[];this.pos<e;)t.push(this.readSFixed64());return t},skip:function(t){var e=7&t;if(e===ou.Varint)for(;this.buf[this.pos++]>127;);else if(e===ou.Bytes)this.pos=this.readVarint()+this.pos;else if(e===ou.Fixed32)this.pos+=4;else {if(e!==ou.Fixed64)throw new Error("Unimplemented type: "+e);this.pos+=8;}},writeTag:function(t,e){this.writeVarint(t<<3|e);},realloc:function(t){for(var e=this.length||16;e<this.pos+t;)e*=2;if(e!==this.length){var r=new Uint8Array(e);r.set(this.buf),this.buf=r,this.length=e;}},finish:function(){return this.length=this.pos,this.pos=0,this.buf.subarray(0,this.length)},writeFixed32:function(t){this.realloc(4),Su(this.buf,t,this.pos),this.pos+=4;},writeSFixed32:function(t){this.realloc(4),Su(this.buf,t,this.pos),this.pos+=4;},writeFixed64:function(t){this.realloc(8),Su(this.buf,-1&t,this.pos),Su(this.buf,Math.floor(t*uu),this.pos+4),this.pos+=8;},writeSFixed64:function(t){this.realloc(8),Su(this.buf,-1&t,this.pos),Su(this.buf,Math.floor(t*uu),this.pos+4),this.pos+=8;},writeVarint:function(t){(t=+t||0)>268435455||t<0?function(t,e){var r,n;if(t>=0?(r=t%4294967296|0,n=t/4294967296|0):(n=~(-t/4294967296),4294967295^(r=~(-t%4294967296))?r=r+1|0:(r=0,n=n+1|0)),t>=0x10000000000000000||t<-0x10000000000000000)throw new Error("Given varint doesn't fit into 10 bytes");e.realloc(10),function(t,e,r){r.buf[r.pos++]=127&t|128,t>>>=7,r.buf[r.pos++]=127&t|128,t>>>=7,r.buf[r.pos++]=127&t|128,t>>>=7,r.buf[r.pos++]=127&t|128,r.buf[r.pos]=127&(t>>>=7);}(r,0,e),function(t,e){var r=(7&t)<<4;e.buf[e.pos++]|=r|((t>>>=3)?128:0),t&&(e.buf[e.pos++]=127&t|((t>>>=7)?128:0),t&&(e.buf[e.pos++]=127&t|((t>>>=7)?128:0),t&&(e.buf[e.pos++]=127&t|((t>>>=7)?128:0),t&&(e.buf[e.pos++]=127&t|((t>>>=7)?128:0),t&&(e.buf[e.pos++]=127&t)))));}(n,e);}(t,this):(this.realloc(4),this.buf[this.pos++]=127&t|(t>127?128:0),t<=127||(this.buf[this.pos++]=127&(t>>>=7)|(t>127?128:0),t<=127||(this.buf[this.pos++]=127&(t>>>=7)|(t>127?128:0),t<=127||(this.buf[this.pos++]=t>>>7&127))));},writeSVarint:function(t){this.writeVarint(t<0?2*-t-1:2*t);},writeBoolean:function(t){this.writeVarint(Boolean(t));},writeString:function(t){t=String(t),this.realloc(4*t.length),this.pos++;var e=this.pos;this.pos=function(t,e,r){for(var n,i,s=0;s<e.length;s++){if((n=e.charCodeAt(s))>55295&&n<57344){if(!i){n>56319||s+1===e.length?(t[r++]=239,t[r++]=191,t[r++]=189):i=n;continue}if(n<56320){t[r++]=239,t[r++]=191,t[r++]=189,i=n;continue}n=i-55296<<10|n-56320|65536,i=null;}else i&&(t[r++]=239,t[r++]=191,t[r++]=189,i=null);n<128?t[r++]=n:(n<2048?t[r++]=n>>6|192:(n<65536?t[r++]=n>>12|224:(t[r++]=n>>18|240,t[r++]=n>>12&63|128),t[r++]=n>>6&63|128),t[r++]=63&n|128);}return r}(this.buf,t,this.pos);var r=this.pos-e;r>=128&&fu(e,r,this),this.pos=e-1,this.writeVarint(r),this.pos+=r;},writeFloat:function(t){this.realloc(4),au(this.buf,t,this.pos,!0,23,4),this.pos+=4;},writeDouble:function(t){this.realloc(8),au(this.buf,t,this.pos,!0,52,8),this.pos+=8;},writeBytes:function(t){var e=t.length;this.writeVarint(e),this.realloc(e);for(var r=0;r<e;r++)this.buf[this.pos++]=t[r];},writeRawMessage:function(t,e){this.pos++;var r=this.pos;t(e,this);var n=this.pos-r;n>=128&&fu(r,n,this),this.pos=r-1,this.writeVarint(n),this.pos+=n;},writeMessage:function(t,e,r){this.writeTag(t,ou.Bytes),this.writeRawMessage(e,r);},writePackedVarint:function(t,e){e.length&&this.writeMessage(t,du,e);},writePackedSVarint:function(t,e){e.length&&this.writeMessage(t,yu,e);},writePackedBoolean:function(t,e){e.length&&this.writeMessage(t,xu,e);},writePackedFloat:function(t,e){e.length&&this.writeMessage(t,mu,e);},writePackedDouble:function(t,e){e.length&&this.writeMessage(t,gu,e);},writePackedFixed32:function(t,e){e.length&&this.writeMessage(t,vu,e);},writePackedSFixed32:function(t,e){e.length&&this.writeMessage(t,bu,e);},writePackedFixed64:function(t,e){e.length&&this.writeMessage(t,wu,e);},writePackedSFixed64:function(t,e){e.length&&this.writeMessage(t,_u,e);},writeBytesField:function(t,e){this.writeTag(t,ou.Bytes),this.writeBytes(e);},writeFixed32Field:function(t,e){this.writeTag(t,ou.Fixed32),this.writeFixed32(e);},writeSFixed32Field:function(t,e){this.writeTag(t,ou.Fixed32),this.writeSFixed32(e);},writeFixed64Field:function(t,e){this.writeTag(t,ou.Fixed64),this.writeFixed64(e);},writeSFixed64Field:function(t,e){this.writeTag(t,ou.Fixed64),this.writeSFixed64(e);},writeVarintField:function(t,e){this.writeTag(t,ou.Varint),this.writeVarint(e);},writeSVarintField:function(t,e){this.writeTag(t,ou.Varint),this.writeSVarint(e);},writeStringField:function(t,e){this.writeTag(t,ou.Bytes),this.writeString(e);},writeFloatField:function(t,e){this.writeTag(t,ou.Fixed32),this.writeFloat(e);},writeDoubleField:function(t,e){this.writeTag(t,ou.Fixed64),this.writeDouble(e);},writeBooleanField:function(t,e){this.writeVarintField(t,Boolean(e));}};var Mu=r(iu);const Iu=3;function zu(t,e,r){1===t&&r.readMessage(Pu,e);}function Pu(t,e,r){if(3===t){const{id:t,bitmap:n,width:i,height:s,left:a,top:o,advance:l}=r.readMessage(Cu,{});e.push({id:t,bitmap:new _o({width:i+2*Iu,height:s+2*Iu},n),metrics:{width:i,height:s,left:a,top:o,advance:l}});}}function Cu(t,e,r){1===t?e.id=r.readVarint():2===t?e.bitmap=r.readBytes():3===t?e.width=r.readVarint():4===t?e.height=r.readVarint():5===t?e.left=r.readSVarint():6===t?e.top=r.readSVarint():7===t&&(e.advance=r.readVarint());}const Bu=Iu;function Vu(t){let e=0,r=0;for(const n of t)e+=n.w*n.h,r=Math.max(r,n.w);t.sort(((t,e)=>e.h-t.h));const n=[{x:0,y:0,w:Math.max(Math.ceil(Math.sqrt(e/.95)),r),h:1/0}];let i=0,s=0;for(const e of t)for(let t=n.length-1;t>=0;t--){const r=n[t];if(!(e.w>r.w||e.h>r.h)){if(e.x=r.x,e.y=r.y,s=Math.max(s,e.y+e.h),i=Math.max(i,e.x+e.w),e.w===r.w&&e.h===r.h){const e=n.pop();t<n.length&&(n[t]=e);}else e.h===r.h?(r.x+=e.w,r.w-=e.w):e.w===r.w?(r.y+=e.h,r.h-=e.h):(n.push({x:r.x+e.w,y:r.y,w:r.w-e.w,h:e.h}),r.y+=e.h,r.h-=e.h);break}}return {w:i,h:s,fill:e/(i*s)||0}}const Eu=1;class Fu{constructor(t,{pixelRatio:e,version:r,stretchX:n,stretchY:i,content:s,textFitWidth:a,textFitHeight:o}){this.paddedRect=t,this.pixelRatio=e,this.stretchX=n,this.stretchY=i,this.content=s,this.version=r,this.textFitWidth=a,this.textFitHeight=o;}get tl(){return [this.paddedRect.x+Eu,this.paddedRect.y+Eu]}get br(){return [this.paddedRect.x+this.paddedRect.w-Eu,this.paddedRect.y+this.paddedRect.h-Eu]}get tlbr(){return this.tl.concat(this.br)}get displaySize(){return [(this.paddedRect.w-2*Eu)/this.pixelRatio,(this.paddedRect.h-2*Eu)/this.pixelRatio]}}class Tu{constructor(t,e){const r={},n={};this.haveRenderCallbacks=[];const i=[];this.addImages(t,r,i),this.addImages(e,n,i);const{w:s,h:a}=Vu(i),o=new Ao({width:s||1,height:a||1});for(const e in t){const n=t[e],i=r[e].paddedRect;Ao.copy(n.data,o,{x:0,y:0},{x:i.x+Eu,y:i.y+Eu},n.data);}for(const t in e){const r=e[t],i=n[t].paddedRect,s=i.x+Eu,a=i.y+Eu,l=r.data.width,u=r.data.height;Ao.copy(r.data,o,{x:0,y:0},{x:s,y:a},r.data),Ao.copy(r.data,o,{x:0,y:u-1},{x:s,y:a-1},{width:l,height:1}),Ao.copy(r.data,o,{x:0,y:0},{x:s,y:a+u},{width:l,height:1}),Ao.copy(r.data,o,{x:l-1,y:0},{x:s-1,y:a},{width:1,height:u}),Ao.copy(r.data,o,{x:0,y:0},{x:s+l,y:a},{width:1,height:u});}this.image=o,this.iconPositions=r,this.patternPositions=n;}addImages(t,e,r){for(const n in t){const i=t[n],s={x:0,y:0,w:i.data.width+2*Eu,h:i.data.height+2*Eu};r.push(s),e[n]=new Fu(s,i),i.hasRenderCallback&&this.haveRenderCallbacks.push(n);}}patchUpdatedImages(t,e){t.dispatchRenderCallbacks(this.haveRenderCallbacks);for(const r in t.updatedImages)this.patchUpdatedImage(this.iconPositions[r],t.getImage(r),e),this.patchUpdatedImage(this.patternPositions[r],t.getImage(r),e);}patchUpdatedImage(t,e,r){if(!t||!e)return;if(t.version===e.version)return;t.version=e.version;const[n,i]=t.tl;r.update(e.data,void 0,{x:n,y:i});}}var $u;wi("ImagePosition",Fu),wi("ImageAtlas",Tu),t.ah=void 0,($u=t.ah||(t.ah={}))[$u.none=0]="none",$u[$u.horizontal=1]="horizontal",$u[$u.vertical=2]="vertical",$u[$u.horizontalOnly=3]="horizontalOnly";const Lu=-17;class Du{constructor(){this.scale=1,this.fontStack="",this.imageName=null;}static forText(t,e){const r=new Du;return r.scale=t||1,r.fontStack=e,r}static forImage(t){const e=new Du;return e.imageName=t,e}}class Ou{constructor(){this.text="",this.sectionIndex=[],this.sections=[],this.imageSectionID=null;}static fromFeature(t,e){const r=new Ou;for(let n=0;n<t.sections.length;n++){const i=t.sections[n];i.image?r.addImageSection(i):r.addTextSection(i,e);}return r}length(){return this.text.length}getSection(t){return this.sections[this.sectionIndex[t]]}getSectionIndex(t){return this.sectionIndex[t]}getCharCode(t){return this.text.charCodeAt(t)}verticalizePunctuation(){this.text=function(t){let e="";for(let r=0;r<t.length;r++){const n=t.charCodeAt(r+1)||null,i=t.charCodeAt(r-1)||null;e+=n&&$i(n)&&!ru[t[r+1]]||i&&$i(i)&&!ru[t[r-1]]||!ru[t[r]]?t[r]:ru[t[r]];}return e}(this.text);}trim(){let t=0;for(let e=0;e<this.text.length&&Ru[this.text.charCodeAt(e)];e++)t++;let e=this.text.length;for(let r=this.text.length-1;r>=0&&r>=t&&Ru[this.text.charCodeAt(r)];r--)e--;this.text=this.text.substring(t,e),this.sectionIndex=this.sectionIndex.slice(t,e);}substring(t,e){const r=new Ou;return r.text=this.text.substring(t,e),r.sectionIndex=this.sectionIndex.slice(t,e),r.sections=this.sections,r}toString(){return this.text}getMaxScale(){return this.sectionIndex.reduce(((t,e)=>Math.max(t,this.sections[e].scale)),0)}addTextSection(t,e){this.text+=t.text,this.sections.push(Du.forText(t.scale,t.fontStack||e));const r=this.sections.length-1;for(let e=0;e<t.text.length;++e)this.sectionIndex.push(r);}addImageSection(t){const e=t.image?t.image.name:"";if(0===e.length)return void A("Can't add FormattedSection with an empty image.");const r=this.getNextImageSectionCharCode();r?(this.text+=String.fromCharCode(r),this.sections.push(Du.forImage(e)),this.sectionIndex.push(this.sections.length-1)):A("Reached maximum number of images 6401");}getNextImageSectionCharCode(){return this.imageSectionID?this.imageSectionID>=63743?null:++this.imageSectionID:(this.imageSectionID=57344,this.imageSectionID)}}function ju(e,r,n,i,s,a,o,l,u,c,h,p,f,d,y){const m=Ou.fromFeature(e,s);let g;p===t.ah.vertical&&m.verticalizePunctuation();const{processBidirectionalText:x,processStyledBidirectionalText:v}=Ri;if(x&&1===m.sections.length){g=[];const t=x(m.toString(),Hu(m,c,a,r,i,d));for(const e of t){const t=new Ou;t.text=e,t.sections=m.sections;for(let r=0;r<e.length;r++)t.sectionIndex.push(0);g.push(t);}}else if(v){g=[];const t=v(m.text,m.sectionIndex,Hu(m,c,a,r,i,d));for(const e of t){const t=new Ou;t.text=e[0],t.sectionIndex=e[1],t.sections=m.sections,g.push(t);}}else g=function(t,e){const r=[],n=t.text;let i=0;for(const n of e)r.push(t.substring(i,n)),i=n;return i<n.length&&r.push(t.substring(i,n.length)),r}(m,Hu(m,c,a,r,i,d));const b=[],w={positionedLines:b,text:m.toString(),top:h[1],bottom:h[1],left:h[0],right:h[0],writingMode:p,iconsInText:!1,verticalizable:!1};return function(e,r,n,i,s,a,o,l,u,c,h,p){let f=0,d=Lu,y=0,m=0;const g="right"===l?1:"left"===l?0:.5;let x=0;for(const o of s){o.trim();const s=o.getMaxScale(),l=(s-1)*nu,b={positionedGlyphs:[],lineOffset:0};e.positionedLines[x]=b;const w=b.positionedGlyphs;let _=0;if(!o.length()){d+=a,++x;continue}for(let a=0;a<o.length();a++){const y=o.getSection(a),m=o.getSectionIndex(a),g=o.getCharCode(a);let x=0,b=null,A=null,S=null,k=nu;const M=!(u===t.ah.horizontal||!h&&!Ti(g)||h&&(Ru[g]||(v=g,/\p{sc=Arab}/u.test(String.fromCodePoint(v)))));if(y.imageName){const t=i[y.imageName];if(!t)continue;S=y.imageName,e.iconsInText=e.iconsInText||!0,A=t.paddedRect;const r=t.displaySize;y.scale=y.scale*nu/p,b={width:r[0],height:r[1],left:Eu,top:-Bu,advance:M?r[1]:r[0]},x=l+(nu-r[1]*y.scale),k=b.advance;const n=M?r[0]*y.scale-nu*s:r[1]*y.scale-nu*s;n>0&&n>_&&(_=n);}else {const t=n[y.fontStack],e=t&&t[g];if(e&&e.rect)A=e.rect,b=e.metrics;else {const t=r[y.fontStack],e=t&&t[g];if(!e)continue;b=e.metrics;}x=(s-y.scale)*nu;}M?(e.verticalizable=!0,w.push({glyph:g,imageName:S,x:f,y:d+x,vertical:M,scale:y.scale,fontStack:y.fontStack,sectionIndex:m,metrics:b,rect:A}),f+=k*y.scale+c):(w.push({glyph:g,imageName:S,x:f,y:d+x,vertical:M,scale:y.scale,fontStack:y.fontStack,sectionIndex:m,metrics:b,rect:A}),f+=b.advance*y.scale+c);}0!==w.length&&(y=Math.max(f-c,y),Ju(w,0,w.length-1,g,_)),f=0;const A=a*s+_;b.lineOffset=Math.max(_,l),d+=A,m=Math.max(A,m),++x;}var v;const b=d-Lu,{horizontalAlign:w,verticalAlign:_}=Yu(o);((function(t,e,r,n,i,s,a,o,l){const u=(e-r)*i;let c=0;c=s!==a?-o*n-Lu:(-n*l+.5)*a;for(const e of t)for(const t of e.positionedGlyphs)t.x+=u,t.y+=c;}))(e.positionedLines,g,w,_,y,m,a,b,s.length),e.top+=-_*b,e.bottom=e.top+b,e.left+=-w*y,e.right=e.left+y;}(w,r,n,i,g,o,l,u,p,c,f,y),!function(t){for(const e of t)if(0!==e.positionedGlyphs.length)return !1;return !0}(b)&&w}const Ru={9:!0,10:!0,11:!0,12:!0,13:!0,32:!0},Uu={10:!0,32:!0,38:!0,41:!0,43:!0,45:!0,47:!0,173:!0,183:!0,8203:!0,8208:!0,8211:!0,8231:!0},qu={40:!0};function Nu(t,e,r,n,i,s){if(e.imageName){const t=n[e.imageName];return t?t.displaySize[0]*e.scale*nu/s+i:0}{const n=r[e.fontStack],s=n&&n[t];return s?s.metrics.advance*e.scale+i:0}}function Zu(t,e,r,n){const i=Math.pow(t-e,2);return n?t<e?i/2:2*i:i+Math.abs(r)*r}function Gu(t,e,r){let n=0;return 10===t&&(n-=1e4),r&&(n+=150),40!==t&&65288!==t||(n+=50),41!==e&&65289!==e||(n+=50),n}function Ku(t,e,r,n,i,s){let a=null,o=Zu(e,r,i,s);for(const t of n){const n=Zu(e-t.x,r,i,s)+t.badness;n<=o&&(a=t,o=n);}return {index:t,x:e,priorBreak:a,badness:o}}function Xu(t){return t?Xu(t.priorBreak).concat(t.index):[]}function Hu(t,e,r,n,i,s){if(!t)return [];const a=[],o=function(t,e,r,n,i,s){let a=0;for(let r=0;r<t.length();r++){const o=t.getSection(r);a+=Nu(t.getCharCode(r),o,n,i,e,s);}return a/Math.max(1,Math.ceil(a/r))}(t,e,r,n,i,s),l=t.text.indexOf("​")>=0;let u=0;for(let r=0;r<t.length();r++){const h=t.getSection(r),p=t.getCharCode(r);if(Ru[p]||(u+=Nu(p,h,n,i,e,s)),r<t.length()-1){const e=!((c=p)<11904)&&(!!zi["CJK Compatibility Forms"](c)||!!zi["CJK Compatibility"](c)||!!zi["CJK Strokes"](c)||!!zi["CJK Symbols and Punctuation"](c)||!!zi["Enclosed CJK Letters and Months"](c)||!!zi["Halfwidth and Fullwidth Forms"](c)||!!zi["Ideographic Description Characters"](c)||!!zi["Vertical Forms"](c)||Fi.test(String.fromCodePoint(c)));(Uu[p]||e||h.imageName||r!==t.length()-2&&qu[t.getCharCode(r+1)])&&a.push(Ku(r+1,u,o,a,Gu(p,t.getCharCode(r+1),e&&l),!1));}}var c;return Xu(Ku(t.length(),u,o,a,0,!0))}function Yu(t){let e=.5,r=.5;switch(t){case"right":case"top-right":case"bottom-right":e=1;break;case"left":case"top-left":case"bottom-left":e=0;}switch(t){case"bottom":case"bottom-right":case"bottom-left":r=1;break;case"top":case"top-right":case"top-left":r=0;}return {horizontalAlign:e,verticalAlign:r}}function Ju(t,e,r,n,i){if(!n&&!i)return;const s=t[r],a=(t[r].x+s.metrics.advance*s.scale)*n;for(let n=e;n<=r;n++)t[n].x-=a,t[n].y+=i;}function Wu(t,e,r){const{horizontalAlign:n,verticalAlign:i}=Yu(r),s=e[0]-t.displaySize[0]*n,a=e[1]-t.displaySize[1]*i;return {image:t,top:a,bottom:a+t.displaySize[1],left:s,right:s+t.displaySize[0]}}function Qu(t){var e,r;let n=t.left,i=t.top,s=t.right-n,a=t.bottom-i;const o=null!==(e=t.image.textFitWidth)&&void 0!==e?e:"stretchOrShrink",l=null!==(r=t.image.textFitHeight)&&void 0!==r?r:"stretchOrShrink",u=(t.image.content[2]-t.image.content[0])/(t.image.content[3]-t.image.content[1]);if("proportional"===l){if("stretchOnly"===o&&s/a<u||"proportional"===o){const t=Math.ceil(a*u);n*=t/s,s=t;}}else if("proportional"===o&&"stretchOnly"===l&&0!==u&&s/a>u){const t=Math.ceil(s/u);i*=t/a,a=t;}return {x1:n,y1:i,x2:n+s,y2:i+a}}function tc(t,e,r,n,i,s){const a=t.image;let o;if(a.content){const t=a.content,e=a.pixelRatio||1;o=[t[0]/e,t[1]/e,a.displaySize[0]-t[2]/e,a.displaySize[1]-t[3]/e];}const l=e.left*s,u=e.right*s;let c,h,p,f;"width"===r||"both"===r?(f=i[0]+l-n[3],h=i[0]+u+n[1]):(f=i[0]+(l+u-a.displaySize[0])/2,h=f+a.displaySize[0]);const d=e.top*s,y=e.bottom*s;return "height"===r||"both"===r?(c=i[1]+d-n[0],p=i[1]+y+n[2]):(c=i[1]+(d+y-a.displaySize[1])/2,p=c+a.displaySize[1]),{image:a,top:c,right:h,bottom:p,left:f,collisionPadding:o}}const ec=255,rc=128,nc=ec*rc;function ic(t,e){const{expression:r}=e;if("constant"===r.kind)return {kind:"constant",layoutSize:r.evaluate(new Ui(t+1))};if("source"===r.kind)return {kind:"source"};{const{zoomStops:e,interpolationType:n}=r;let i=0;for(;i<e.length&&e[i]<=t;)i++;i=Math.max(0,i-1);let s=i;for(;s<e.length&&e[s]<t+1;)s++;s=Math.min(e.length-1,s);const a=e[i],o=e[s];return "composite"===r.kind?{kind:"composite",minZoom:a,maxZoom:o,interpolationType:n}:{kind:"camera",minZoom:a,maxZoom:o,minSize:r.evaluate(new Ui(a)),maxSize:r.evaluate(new Ui(o)),interpolationType:n}}}function sc(t,e,r){let n="never";const i=t.get(e);return i?n=i:t.get(r)&&(n="always"),n}const ac=pl.VectorTileFeature.types,oc=[{name:"a_fade_opacity",components:1,type:"Uint8",offset:0}];function lc(t,e,r,n,i,s,a,o,l,u,c,h,p){const f=o?Math.min(nc,Math.round(o[0])):0,d=o?Math.min(nc,Math.round(o[1])):0;t.emplaceBack(e,r,Math.round(32*n),Math.round(32*i),s,a,(f<<1)+(l?1:0),d,16*u,16*c,256*h,256*p);}function uc(t,e,r){t.emplaceBack(e.x,e.y,r),t.emplaceBack(e.x,e.y,r),t.emplaceBack(e.x,e.y,r),t.emplaceBack(e.x,e.y,r);}function cc(t){for(const e of t.sections)if(ji(e.text))return !0;return !1}class hc{constructor(t){this.layoutVertexArray=new Ws,this.indexArray=new na,this.programConfigurations=t,this.segments=new oa,this.dynamicLayoutVertexArray=new Qs,this.opacityVertexArray=new ta,this.hasVisibleVertices=!1,this.placedSymbolArray=new $s;}isEmpty(){return 0===this.layoutVertexArray.length&&0===this.indexArray.length&&0===this.dynamicLayoutVertexArray.length&&0===this.opacityVertexArray.length}upload(t,e,r,n){this.isEmpty()||(r&&(this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,Yl.members),this.indexBuffer=t.createIndexBuffer(this.indexArray,e),this.dynamicLayoutVertexBuffer=t.createVertexBuffer(this.dynamicLayoutVertexArray,Jl.members,!0),this.opacityVertexBuffer=t.createVertexBuffer(this.opacityVertexArray,oc,!0),this.opacityVertexBuffer.itemSize=1),(r||n)&&this.programConfigurations.upload(t));}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.programConfigurations.destroy(),this.segments.destroy(),this.dynamicLayoutVertexBuffer.destroy(),this.opacityVertexBuffer.destroy());}}wi("SymbolBuffers",hc);class pc{constructor(t,e,r){this.layoutVertexArray=new t,this.layoutAttributes=e,this.indexArray=new r,this.segments=new oa,this.collisionVertexArray=new ra;}upload(t){this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,this.layoutAttributes),this.indexBuffer=t.createIndexBuffer(this.indexArray),this.collisionVertexBuffer=t.createVertexBuffer(this.collisionVertexArray,Wl.members,!0);}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.segments.destroy(),this.collisionVertexBuffer.destroy());}}wi("CollisionBuffers",pc);class fc{constructor(e){this.collisionBoxArray=e.collisionBoxArray,this.zoom=e.zoom,this.overscaling=e.overscaling,this.layers=e.layers,this.layerIds=this.layers.map((t=>t.id)),this.index=e.index,this.pixelRatio=e.pixelRatio,this.sourceLayerIndex=e.sourceLayerIndex,this.hasPattern=!1,this.hasRTLText=!1,this.sortKeyRanges=[],this.collisionCircleArray=[],this.placementInvProjMatrix=lo([]),this.placementViewportMatrix=lo([]);const r=this.layers[0]._unevaluatedLayout._values;this.textSizeData=ic(this.zoom,r["text-size"]),this.iconSizeData=ic(this.zoom,r["icon-size"]);const n=this.layers[0].layout,i=n.get("symbol-sort-key"),s=n.get("symbol-z-order");this.canOverlap="never"!==sc(n,"text-overlap","text-allow-overlap")||"never"!==sc(n,"icon-overlap","icon-allow-overlap")||n.get("text-ignore-placement")||n.get("icon-ignore-placement"),this.sortFeaturesByKey="viewport-y"!==s&&!i.isConstant(),this.sortFeaturesByY=("viewport-y"===s||"auto"===s&&!this.sortFeaturesByKey)&&this.canOverlap,"point"===n.get("symbol-placement")&&(this.writingModes=n.get("text-writing-mode").map((e=>t.ah[e]))),this.stateDependentLayerIds=this.layers.filter((t=>t.isStateDependent())).map((t=>t.id)),this.sourceID=e.sourceID;}createArrays(){this.text=new hc(new Ea(this.layers,this.zoom,(t=>/^text/.test(t)))),this.icon=new hc(new Ea(this.layers,this.zoom,(t=>/^icon/.test(t)))),this.glyphOffsetArray=new Os,this.lineVertexArray=new js,this.symbolInstances=new Ds,this.textAnchorOffsets=new Us;}calculateGlyphDependencies(t,e,r,n,i){for(let s=0;s<t.length;s++)if(e[t.charCodeAt(s)]=!0,(r||n)&&i){const r=ru[t.charAt(s)];r&&(e[r.charCodeAt(0)]=!0);}}populate(e,r,n){const i=this.layers[0],s=i.layout,a=s.get("text-font"),o=s.get("text-field"),l=s.get("icon-image"),u=("constant"!==o.value.kind||o.value.value instanceof Yt&&!o.value.value.isEmpty()||o.value.value.toString().length>0)&&("constant"!==a.value.kind||a.value.value.length>0),c="constant"!==l.value.kind||!!l.value.value||Object.keys(l.parameters).length>0,h=s.get("symbol-sort-key");if(this.features=[],!u&&!c)return;const p=r.iconDependencies,f=r.glyphDependencies,d=r.availableImages,y=new Ui(this.zoom);for(const{feature:r,id:o,index:l,sourceLayerIndex:m}of e){const e=i._featureFilter.needGeometry,g=ja(r,e);if(!i._featureFilter.filter(y,g,n))continue;let x,v;if(e||(g.geometry=Oa(r)),u){const t=i.getValueAndResolveTokens("text-field",g,n,d),e=Yt.factory(t),r=this.hasRTLText=this.hasRTLText||cc(e);(!r||"unavailable"===Ri.getRTLTextPluginStatus()||r&&Ri.isParsed())&&(x=eu(e,i,g));}if(c){const t=i.getValueAndResolveTokens("icon-image",g,n,d);v=t instanceof te?t:te.fromString(t);}if(!x&&!v)continue;const b=this.sortFeaturesByKey?h.evaluate(g,{},n):void 0;if(this.features.push({id:o,text:x,icon:v,index:l,sourceLayerIndex:m,geometry:g.geometry,properties:r.properties,type:ac[r.type],sortKey:b}),v&&(p[v.name]=!0),x){const e=a.evaluate(g,{},n).join(","),r="viewport"!==s.get("text-rotation-alignment")&&"point"!==s.get("symbol-placement");this.allowVerticalPlacement=this.writingModes&&this.writingModes.indexOf(t.ah.vertical)>=0;for(const t of x.sections)if(t.image)p[t.image.name]=!0;else {const n=Pi(x.toString()),i=t.fontStack||e,s=f[i]=f[i]||{};this.calculateGlyphDependencies(t.text,s,r,this.allowVerticalPlacement,n);}}}"line"===s.get("symbol-placement")&&(this.features=function(t){const e={},r={},n=[];let i=0;function s(e){n.push(t[e]),i++;}function a(t,e,i){const s=r[t];return delete r[t],r[e]=s,n[s].geometry[0].pop(),n[s].geometry[0]=n[s].geometry[0].concat(i[0]),s}function o(t,r,i){const s=e[r];return delete e[r],e[t]=s,n[s].geometry[0].shift(),n[s].geometry[0]=i[0].concat(n[s].geometry[0]),s}function l(t,e,r){const n=r?e[0][e[0].length-1]:e[0][0];return `${t}:${n.x}:${n.y}`}for(let u=0;u<t.length;u++){const c=t[u],h=c.geometry,p=c.text?c.text.toString():null;if(!p){s(u);continue}const f=l(p,h),d=l(p,h,!0);if(f in r&&d in e&&r[f]!==e[d]){const t=o(f,d,h),i=a(f,d,n[t].geometry);delete e[f],delete r[d],r[l(p,n[i].geometry,!0)]=i,n[t].geometry=null;}else f in r?a(f,d,h):d in e?o(f,d,h):(s(u),e[f]=i-1,r[d]=i-1);}return n.filter((t=>t.geometry))}(this.features)),this.sortFeaturesByKey&&this.features.sort(((t,e)=>t.sortKey-e.sortKey));}update(t,e,r){this.stateDependentLayers.length&&(this.text.programConfigurations.updatePaintArrays(t,e,this.layers,r),this.icon.programConfigurations.updatePaintArrays(t,e,this.layers,r));}isEmpty(){return 0===this.symbolInstances.length&&!this.hasRTLText}uploadPending(){return !this.uploaded||this.text.programConfigurations.needsUpload||this.icon.programConfigurations.needsUpload}upload(t){!this.uploaded&&this.hasDebugData()&&(this.textCollisionBox.upload(t),this.iconCollisionBox.upload(t)),this.text.upload(t,this.sortFeaturesByY,!this.uploaded,this.text.programConfigurations.needsUpload),this.icon.upload(t,this.sortFeaturesByY,!this.uploaded,this.icon.programConfigurations.needsUpload),this.uploaded=!0;}destroyDebugData(){this.textCollisionBox.destroy(),this.iconCollisionBox.destroy();}destroy(){this.text.destroy(),this.icon.destroy(),this.hasDebugData()&&this.destroyDebugData();}addToLineVertexArray(t,e){const r=this.lineVertexArray.length;if(void 0!==t.segment){let r=t.dist(e[t.segment+1]),n=t.dist(e[t.segment]);const i={};for(let n=t.segment+1;n<e.length;n++)i[n]={x:e[n].x,y:e[n].y,tileUnitDistanceFromAnchor:r},n<e.length-1&&(r+=e[n+1].dist(e[n]));for(let r=t.segment||0;r>=0;r--)i[r]={x:e[r].x,y:e[r].y,tileUnitDistanceFromAnchor:n},r>0&&(n+=e[r-1].dist(e[r]));for(let t=0;t<e.length;t++){const e=i[t];this.lineVertexArray.emplaceBack(e.x,e.y,e.tileUnitDistanceFromAnchor);}}return {lineStartIndex:r,lineLength:this.lineVertexArray.length-r}}addSymbols(e,r,n,i,s,a,o,l,u,c,h,p){const f=e.indexArray,d=e.layoutVertexArray,y=e.segments.prepareSegment(4*r.length,d,f,this.canOverlap?a.sortKey:void 0),m=this.glyphOffsetArray.length,g=y.vertexLength,x=this.allowVerticalPlacement&&o===t.ah.vertical?Math.PI/2:0,v=a.text&&a.text.sections;for(let t=0;t<r.length;t++){const{tl:i,tr:s,bl:o,br:u,tex:c,pixelOffsetTL:h,pixelOffsetBR:m,minFontScaleX:g,minFontScaleY:b,glyphOffset:w,isSDF:_,sectionIndex:A}=r[t],S=y.vertexLength,k=w[1];lc(d,l.x,l.y,i.x,k+i.y,c.x,c.y,n,_,h.x,h.y,g,b),lc(d,l.x,l.y,s.x,k+s.y,c.x+c.w,c.y,n,_,m.x,h.y,g,b),lc(d,l.x,l.y,o.x,k+o.y,c.x,c.y+c.h,n,_,h.x,m.y,g,b),lc(d,l.x,l.y,u.x,k+u.y,c.x+c.w,c.y+c.h,n,_,m.x,m.y,g,b),uc(e.dynamicLayoutVertexArray,l,x),f.emplaceBack(S,S+1,S+2),f.emplaceBack(S+1,S+2,S+3),y.vertexLength+=4,y.primitiveLength+=2,this.glyphOffsetArray.emplaceBack(w[0]),t!==r.length-1&&A===r[t+1].sectionIndex||e.programConfigurations.populatePaintArrays(d.length,a,a.index,{},p,v&&v[A]);}e.placedSymbolArray.emplaceBack(l.x,l.y,m,this.glyphOffsetArray.length-m,g,u,c,l.segment,n?n[0]:0,n?n[1]:0,i[0],i[1],o,0,!1,0,h);}_addCollisionDebugVertex(t,e,r,n,i,s){return e.emplaceBack(0,0),t.emplaceBack(r.x,r.y,n,i,Math.round(s.x),Math.round(s.y))}addCollisionDebugVertices(t,e,r,n,i,a,o){const l=i.segments.prepareSegment(4,i.layoutVertexArray,i.indexArray),u=l.vertexLength,c=i.layoutVertexArray,h=i.collisionVertexArray,p=o.anchorX,f=o.anchorY;this._addCollisionDebugVertex(c,h,a,p,f,new s(t,e)),this._addCollisionDebugVertex(c,h,a,p,f,new s(r,e)),this._addCollisionDebugVertex(c,h,a,p,f,new s(r,n)),this._addCollisionDebugVertex(c,h,a,p,f,new s(t,n)),l.vertexLength+=4;const d=i.indexArray;d.emplaceBack(u,u+1),d.emplaceBack(u+1,u+2),d.emplaceBack(u+2,u+3),d.emplaceBack(u+3,u),l.primitiveLength+=4;}addDebugCollisionBoxes(t,e,r,n){for(let i=t;i<e;i++){const t=this.collisionBoxArray.get(i);this.addCollisionDebugVertices(t.x1,t.y1,t.x2,t.y2,n?this.textCollisionBox:this.iconCollisionBox,t.anchorPoint,r);}}generateCollisionDebugBuffers(){this.hasDebugData()&&this.destroyDebugData(),this.textCollisionBox=new pc(ea,Ql.members,ia),this.iconCollisionBox=new pc(ea,Ql.members,ia);for(let t=0;t<this.symbolInstances.length;t++){const e=this.symbolInstances.get(t);this.addDebugCollisionBoxes(e.textBoxStartIndex,e.textBoxEndIndex,e,!0),this.addDebugCollisionBoxes(e.verticalTextBoxStartIndex,e.verticalTextBoxEndIndex,e,!0),this.addDebugCollisionBoxes(e.iconBoxStartIndex,e.iconBoxEndIndex,e,!1),this.addDebugCollisionBoxes(e.verticalIconBoxStartIndex,e.verticalIconBoxEndIndex,e,!1);}}_deserializeCollisionBoxesForSymbol(t,e,r,n,i,s,a,o,l){const u={};for(let n=e;n<r;n++){const e=t.get(n);u.textBox={x1:e.x1,y1:e.y1,x2:e.x2,y2:e.y2,anchorPointX:e.anchorPointX,anchorPointY:e.anchorPointY},u.textFeatureIndex=e.featureIndex;break}for(let e=n;e<i;e++){const r=t.get(e);u.verticalTextBox={x1:r.x1,y1:r.y1,x2:r.x2,y2:r.y2,anchorPointX:r.anchorPointX,anchorPointY:r.anchorPointY},u.verticalTextFeatureIndex=r.featureIndex;break}for(let e=s;e<a;e++){const r=t.get(e);u.iconBox={x1:r.x1,y1:r.y1,x2:r.x2,y2:r.y2,anchorPointX:r.anchorPointX,anchorPointY:r.anchorPointY},u.iconFeatureIndex=r.featureIndex;break}for(let e=o;e<l;e++){const r=t.get(e);u.verticalIconBox={x1:r.x1,y1:r.y1,x2:r.x2,y2:r.y2,anchorPointX:r.anchorPointX,anchorPointY:r.anchorPointY},u.verticalIconFeatureIndex=r.featureIndex;break}return u}deserializeCollisionBoxes(t){this.collisionArrays=[];for(let e=0;e<this.symbolInstances.length;e++){const r=this.symbolInstances.get(e);this.collisionArrays.push(this._deserializeCollisionBoxesForSymbol(t,r.textBoxStartIndex,r.textBoxEndIndex,r.verticalTextBoxStartIndex,r.verticalTextBoxEndIndex,r.iconBoxStartIndex,r.iconBoxEndIndex,r.verticalIconBoxStartIndex,r.verticalIconBoxEndIndex));}}hasTextData(){return this.text.segments.get().length>0}hasIconData(){return this.icon.segments.get().length>0}hasDebugData(){return this.textCollisionBox&&this.iconCollisionBox}hasTextCollisionBoxData(){return this.hasDebugData()&&this.textCollisionBox.segments.get().length>0}hasIconCollisionBoxData(){return this.hasDebugData()&&this.iconCollisionBox.segments.get().length>0}addIndicesForPlacedSymbol(t,e){const r=t.placedSymbolArray.get(e),n=r.vertexStartIndex+4*r.numGlyphs;for(let e=r.vertexStartIndex;e<n;e+=4)t.indexArray.emplaceBack(e,e+1,e+2),t.indexArray.emplaceBack(e+1,e+2,e+3);}getSortedSymbolIndexes(t){if(this.sortedAngle===t&&void 0!==this.symbolInstanceIndexes)return this.symbolInstanceIndexes;const e=Math.sin(t),r=Math.cos(t),n=[],i=[],s=[];for(let t=0;t<this.symbolInstances.length;++t){s.push(t);const a=this.symbolInstances.get(t);n.push(0|Math.round(e*a.anchorX+r*a.anchorY)),i.push(a.featureIndex);}return s.sort(((t,e)=>n[t]-n[e]||i[e]-i[t])),s}addToSortKeyRanges(t,e){const r=this.sortKeyRanges[this.sortKeyRanges.length-1];r&&r.sortKey===e?r.symbolInstanceEnd=t+1:this.sortKeyRanges.push({sortKey:e,symbolInstanceStart:t,symbolInstanceEnd:t+1});}sortFeatures(t){if(this.sortFeaturesByY&&this.sortedAngle!==t&&!(this.text.segments.get().length>1||this.icon.segments.get().length>1)){this.symbolInstanceIndexes=this.getSortedSymbolIndexes(t),this.sortedAngle=t,this.text.indexArray.clear(),this.icon.indexArray.clear(),this.featureSortOrder=[];for(const t of this.symbolInstanceIndexes){const e=this.symbolInstances.get(t);this.featureSortOrder.push(e.featureIndex),[e.rightJustifiedTextSymbolIndex,e.centerJustifiedTextSymbolIndex,e.leftJustifiedTextSymbolIndex].forEach(((t,e,r)=>{t>=0&&r.indexOf(t)===e&&this.addIndicesForPlacedSymbol(this.text,t);})),e.verticalPlacedTextSymbolIndex>=0&&this.addIndicesForPlacedSymbol(this.text,e.verticalPlacedTextSymbolIndex),e.placedIconSymbolIndex>=0&&this.addIndicesForPlacedSymbol(this.icon,e.placedIconSymbolIndex),e.verticalPlacedIconSymbolIndex>=0&&this.addIndicesForPlacedSymbol(this.icon,e.verticalPlacedIconSymbolIndex);}this.text.indexBuffer&&this.text.indexBuffer.updateData(this.text.indexArray),this.icon.indexBuffer&&this.icon.indexBuffer.updateData(this.icon.indexArray);}}}let dc,yc;wi("SymbolBucket",fc,{omit:["layers","collisionBoxArray","features","compareText"]}),fc.MAX_GLYPHS=65535,fc.addDynamicAttributes=uc;var mc={get paint(){return yc=yc||new rs({"icon-opacity":new Wi(G.paint_symbol["icon-opacity"]),"icon-color":new Wi(G.paint_symbol["icon-color"]),"icon-halo-color":new Wi(G.paint_symbol["icon-halo-color"]),"icon-halo-width":new Wi(G.paint_symbol["icon-halo-width"]),"icon-halo-blur":new Wi(G.paint_symbol["icon-halo-blur"]),"icon-translate":new Ji(G.paint_symbol["icon-translate"]),"icon-translate-anchor":new Ji(G.paint_symbol["icon-translate-anchor"]),"text-opacity":new Wi(G.paint_symbol["text-opacity"]),"text-color":new Wi(G.paint_symbol["text-color"],{runtimeType:pt,getOverride:t=>t.textColor,hasOverride:t=>!!t.textColor}),"text-halo-color":new Wi(G.paint_symbol["text-halo-color"]),"text-halo-width":new Wi(G.paint_symbol["text-halo-width"]),"text-halo-blur":new Wi(G.paint_symbol["text-halo-blur"]),"text-translate":new Ji(G.paint_symbol["text-translate"]),"text-translate-anchor":new Ji(G.paint_symbol["text-translate-anchor"])})},get layout(){return dc=dc||new rs({"symbol-placement":new Ji(G.layout_symbol["symbol-placement"]),"symbol-spacing":new Ji(G.layout_symbol["symbol-spacing"]),"symbol-avoid-edges":new Ji(G.layout_symbol["symbol-avoid-edges"]),"symbol-sort-key":new Wi(G.layout_symbol["symbol-sort-key"]),"symbol-z-order":new Ji(G.layout_symbol["symbol-z-order"]),"icon-allow-overlap":new Ji(G.layout_symbol["icon-allow-overlap"]),"icon-overlap":new Ji(G.layout_symbol["icon-overlap"]),"icon-ignore-placement":new Ji(G.layout_symbol["icon-ignore-placement"]),"icon-optional":new Ji(G.layout_symbol["icon-optional"]),"icon-rotation-alignment":new Ji(G.layout_symbol["icon-rotation-alignment"]),"icon-size":new Wi(G.layout_symbol["icon-size"]),"icon-text-fit":new Ji(G.layout_symbol["icon-text-fit"]),"icon-text-fit-padding":new Ji(G.layout_symbol["icon-text-fit-padding"]),"icon-image":new Wi(G.layout_symbol["icon-image"]),"icon-rotate":new Wi(G.layout_symbol["icon-rotate"]),"icon-padding":new Wi(G.layout_symbol["icon-padding"]),"icon-keep-upright":new Ji(G.layout_symbol["icon-keep-upright"]),"icon-offset":new Wi(G.layout_symbol["icon-offset"]),"icon-anchor":new Wi(G.layout_symbol["icon-anchor"]),"icon-pitch-alignment":new Ji(G.layout_symbol["icon-pitch-alignment"]),"text-pitch-alignment":new Ji(G.layout_symbol["text-pitch-alignment"]),"text-rotation-alignment":new Ji(G.layout_symbol["text-rotation-alignment"]),"text-field":new Wi(G.layout_symbol["text-field"]),"text-font":new Wi(G.layout_symbol["text-font"]),"text-size":new Wi(G.layout_symbol["text-size"]),"text-max-width":new Wi(G.layout_symbol["text-max-width"]),"text-line-height":new Ji(G.layout_symbol["text-line-height"]),"text-letter-spacing":new Wi(G.layout_symbol["text-letter-spacing"]),"text-justify":new Wi(G.layout_symbol["text-justify"]),"text-radial-offset":new Wi(G.layout_symbol["text-radial-offset"]),"text-variable-anchor":new Ji(G.layout_symbol["text-variable-anchor"]),"text-variable-anchor-offset":new Wi(G.layout_symbol["text-variable-anchor-offset"]),"text-anchor":new Wi(G.layout_symbol["text-anchor"]),"text-max-angle":new Ji(G.layout_symbol["text-max-angle"]),"text-writing-mode":new Ji(G.layout_symbol["text-writing-mode"]),"text-rotate":new Wi(G.layout_symbol["text-rotate"]),"text-padding":new Ji(G.layout_symbol["text-padding"]),"text-keep-upright":new Ji(G.layout_symbol["text-keep-upright"]),"text-transform":new Wi(G.layout_symbol["text-transform"]),"text-offset":new Wi(G.layout_symbol["text-offset"]),"text-allow-overlap":new Ji(G.layout_symbol["text-allow-overlap"]),"text-overlap":new Ji(G.layout_symbol["text-overlap"]),"text-ignore-placement":new Ji(G.layout_symbol["text-ignore-placement"]),"text-optional":new Ji(G.layout_symbol["text-optional"])})}};class gc{constructor(t){if(void 0===t.property.overrides)throw new Error("overrides must be provided to instantiate FormatSectionOverride class");this.type=t.property.overrides?t.property.overrides.runtimeType:lt,this.defaultValue=t;}evaluate(t){if(t.formattedSection){const e=this.defaultValue.property.overrides;if(e&&e.hasOverride(t.formattedSection))return e.getOverride(t.formattedSection)}return t.feature&&t.featureState?this.defaultValue.evaluate(t.feature,t.featureState):this.defaultValue.property.specification.default}eachChild(t){this.defaultValue.isConstant()||t(this.defaultValue.value._styleExpression.expression);}outputDefined(){return !1}serialize(){return null}}wi("FormatSectionOverride",gc,{omit:["defaultValue"]});class xc extends is{constructor(t){super(t,mc);}recalculate(t,e){if(super.recalculate(t,e),"auto"===this.layout.get("icon-rotation-alignment")&&(this.layout._values["icon-rotation-alignment"]="point"!==this.layout.get("symbol-placement")?"map":"viewport"),"auto"===this.layout.get("text-rotation-alignment")&&(this.layout._values["text-rotation-alignment"]="point"!==this.layout.get("symbol-placement")?"map":"viewport"),"auto"===this.layout.get("text-pitch-alignment")&&(this.layout._values["text-pitch-alignment"]="map"===this.layout.get("text-rotation-alignment")?"map":"viewport"),"auto"===this.layout.get("icon-pitch-alignment")&&(this.layout._values["icon-pitch-alignment"]=this.layout.get("icon-rotation-alignment")),"point"===this.layout.get("symbol-placement")){const t=this.layout.get("text-writing-mode");if(t){const e=[];for(const r of t)e.indexOf(r)<0&&e.push(r);this.layout._values["text-writing-mode"]=e;}else this.layout._values["text-writing-mode"]=["horizontal"];}this._setPaintOverrides();}getValueAndResolveTokens(t,e,r,n){const i=this.layout.get(t).evaluate(e,{},r,n),s=this._unevaluatedLayout._values[t];return s.isDataDriven()||vn(s.value)||!i?i:function(t,e){return e.replace(/{([^{}]+)}/g,((e,r)=>t&&r in t?String(t[r]):""))}(e.properties,i)}createBucket(t){return new fc(t)}queryRadius(){return 0}queryIntersectsFeature(){throw new Error("Should take a different path in FeatureIndex")}_setPaintOverrides(){for(const t of mc.paint.overridableProperties){if(!xc.hasPaintOverride(this.layout,t))continue;const e=this.paint.get(t),r=new gc(e),n=new xn(r,e.property.specification);let i=null;i="constant"===e.value.kind||"source"===e.value.kind?new wn("source",n):new _n("composite",n,e.value.zoomStops),this.paint._values[t]=new Hi(e.property,i,e.parameters);}}_handleOverridablePaintPropertyUpdate(t,e,r){return !(!this.layout||e.isDataDriven()||r.isDataDriven())&&xc.hasPaintOverride(this.layout,t)}static hasPaintOverride(t,e){const r=t.get("text-field"),n=mc.paint.properties[e];let i=!1;const s=t=>{for(const e of t)if(n.overrides&&n.overrides.hasOverride(e))return void(i=!0)};if("constant"===r.value.kind&&r.value.value instanceof Yt)s(r.value.value.sections);else if("source"===r.value.kind){const t=e=>{i||(e instanceof se&&ne(e.value)===mt?s(e.value.sections):e instanceof Ze?s(e.sections):e.eachChild(t));},e=r.value;e._styleExpression&&t(e._styleExpression.expression);}return i}}let vc;var bc={get paint(){return vc=vc||new rs({"background-color":new Ji(G.paint_background["background-color"]),"background-pattern":new ts(G.paint_background["background-pattern"]),"background-opacity":new Ji(G.paint_background["background-opacity"])})}};class wc extends is{constructor(t){super(t,bc);}}let _c;var Ac={get paint(){return _c=_c||new rs({"raster-opacity":new Ji(G.paint_raster["raster-opacity"]),"raster-hue-rotate":new Ji(G.paint_raster["raster-hue-rotate"]),"raster-brightness-min":new Ji(G.paint_raster["raster-brightness-min"]),"raster-brightness-max":new Ji(G.paint_raster["raster-brightness-max"]),"raster-saturation":new Ji(G.paint_raster["raster-saturation"]),"raster-contrast":new Ji(G.paint_raster["raster-contrast"]),"raster-resampling":new Ji(G.paint_raster["raster-resampling"]),"raster-fade-duration":new Ji(G.paint_raster["raster-fade-duration"])})}};class Sc extends is{constructor(t){super(t,Ac);}}class kc extends is{constructor(t){super(t,{}),this.onAdd=t=>{this.implementation.onAdd&&this.implementation.onAdd(t,t.painter.context.gl);},this.onRemove=t=>{this.implementation.onRemove&&this.implementation.onRemove(t,t.painter.context.gl);},this.implementation=t;}is3D(){return "3d"===this.implementation.renderingMode}hasOffscreenPass(){return void 0!==this.implementation.prerender}recalculate(){}updateTransitions(){}hasTransition(){return !1}serialize(){throw new Error("Custom layers cannot be serialized")}}class Mc{constructor(t){this._methodToThrottle=t,this._triggered=!1,"undefined"!=typeof MessageChannel&&(this._channel=new MessageChannel,this._channel.port2.onmessage=()=>{this._triggered=!1,this._methodToThrottle();});}trigger(){this._triggered||(this._triggered=!0,this._channel?this._channel.port1.postMessage(!0):setTimeout((()=>{this._triggered=!1,this._methodToThrottle();}),0));}remove(){delete this._channel,this._methodToThrottle=()=>{};}}const Ic=6371008.8;class zc{constructor(t,e){if(isNaN(t)||isNaN(e))throw new Error(`Invalid LngLat object: (${t}, ${e})`);if(this.lng=+t,this.lat=+e,this.lat>90||this.lat<-90)throw new Error("Invalid LngLat latitude value: must be between -90 and 90")}wrap(){return new zc(m(this.lng,-180,180),this.lat)}toArray(){return [this.lng,this.lat]}toString(){return `LngLat(${this.lng}, ${this.lat})`}distanceTo(t){const e=Math.PI/180,r=this.lat*e,n=t.lat*e,i=Math.sin(r)*Math.sin(n)+Math.cos(r)*Math.cos(n)*Math.cos((t.lng-this.lng)*e);return Ic*Math.acos(Math.min(i,1))}static convert(t){if(t instanceof zc)return t;if(Array.isArray(t)&&(2===t.length||3===t.length))return new zc(Number(t[0]),Number(t[1]));if(!Array.isArray(t)&&"object"==typeof t&&null!==t)return new zc(Number("lng"in t?t.lng:t.lon),Number(t.lat));throw new Error("`LngLatLike` argument must be specified as a LngLat instance, an object {lng: <lng>, lat: <lat>}, an object {lon: <lng>, lat: <lat>}, or an array of [<lng>, <lat>]")}}const Pc=2*Math.PI*Ic;function Cc(t){return Pc*Math.cos(t*Math.PI/180)}function Bc(t){return (180+t)/360}function Vc(t){return (180-180/Math.PI*Math.log(Math.tan(Math.PI/4+t*Math.PI/360)))/360}function Ec(t,e){return t/Cc(e)}function Fc(t){return 360/Math.PI*Math.atan(Math.exp((180-360*t)*Math.PI/180))-90}class Tc{constructor(t,e,r=0){this.x=+t,this.y=+e,this.z=+r;}static fromLngLat(t,e=0){const r=zc.convert(t);return new Tc(Bc(r.lng),Vc(r.lat),Ec(e,r.lat))}toLngLat(){return new zc(360*this.x-180,Fc(this.y))}toAltitude(){return this.z*Cc(Fc(this.y))}meterInMercatorCoordinateUnits(){return 1/Pc*(t=Fc(this.y),1/Math.cos(t*Math.PI/180));var t;}}function $c(t,e,r){var n=2*Math.PI*6378137/256/Math.pow(2,r);return [t*n-2*Math.PI*6378137/2,e*n-2*Math.PI*6378137/2]}class Lc{constructor(t,e,r){if(!function(t,e,r){return !(t<0||t>25||r<0||r>=Math.pow(2,t)||e<0||e>=Math.pow(2,t))}(t,e,r))throw new Error(`x=${e}, y=${r}, z=${t} outside of bounds. 0<=x<${Math.pow(2,t)}, 0<=y<${Math.pow(2,t)} 0<=z<=25 `);this.z=t,this.x=e,this.y=r,this.key=jc(0,t,t,e,r);}equals(t){return this.z===t.z&&this.x===t.x&&this.y===t.y}url(t,e,r){const n=(s=this.y,a=this.z,o=$c(256*(i=this.x),256*(s=Math.pow(2,a)-s-1),a),l=$c(256*(i+1),256*(s+1),a),o[0]+","+o[1]+","+l[0]+","+l[1]);var i,s,a,o,l;const u=function(t,e,r){let n,i="";for(let s=t;s>0;s--)n=1<<s-1,i+=(e&n?1:0)+(r&n?2:0);return i}(this.z,this.x,this.y);return t[(this.x+this.y)%t.length].replace(/{prefix}/g,(this.x%16).toString(16)+(this.y%16).toString(16)).replace(/{z}/g,String(this.z)).replace(/{x}/g,String(this.x)).replace(/{y}/g,String("tms"===r?Math.pow(2,this.z)-this.y-1:this.y)).replace(/{ratio}/g,e>1?"@2x":"").replace(/{quadkey}/g,u).replace(/{bbox-epsg-3857}/g,n)}isChildOf(t){const e=this.z-t.z;return e>0&&t.x===this.x>>e&&t.y===this.y>>e}getTilePoint(t){const e=Math.pow(2,this.z);return new s((t.x*e-this.x)*$a,(t.y*e-this.y)*$a)}toString(){return `${this.z}/${this.x}/${this.y}`}}class Dc{constructor(t,e){this.wrap=t,this.canonical=e,this.key=jc(t,e.z,e.z,e.x,e.y);}}class Oc{constructor(t,e,r,n,i){if(t<r)throw new Error(`overscaledZ should be >= z; overscaledZ = ${t}; z = ${r}`);this.overscaledZ=t,this.wrap=e,this.canonical=new Lc(r,+n,+i),this.key=jc(e,t,r,n,i);}clone(){return new Oc(this.overscaledZ,this.wrap,this.canonical.z,this.canonical.x,this.canonical.y)}equals(t){return this.overscaledZ===t.overscaledZ&&this.wrap===t.wrap&&this.canonical.equals(t.canonical)}scaledTo(t){if(t>this.overscaledZ)throw new Error(`targetZ > this.overscaledZ; targetZ = ${t}; overscaledZ = ${this.overscaledZ}`);const e=this.canonical.z-t;return t>this.canonical.z?new Oc(t,this.wrap,this.canonical.z,this.canonical.x,this.canonical.y):new Oc(t,this.wrap,t,this.canonical.x>>e,this.canonical.y>>e)}calculateScaledKey(t,e){if(t>this.overscaledZ)throw new Error(`targetZ > this.overscaledZ; targetZ = ${t}; overscaledZ = ${this.overscaledZ}`);const r=this.canonical.z-t;return t>this.canonical.z?jc(this.wrap*+e,t,this.canonical.z,this.canonical.x,this.canonical.y):jc(this.wrap*+e,t,t,this.canonical.x>>r,this.canonical.y>>r)}isChildOf(t){if(t.wrap!==this.wrap)return !1;const e=this.canonical.z-t.canonical.z;return 0===t.overscaledZ||t.overscaledZ<this.overscaledZ&&t.canonical.x===this.canonical.x>>e&&t.canonical.y===this.canonical.y>>e}children(t){if(this.overscaledZ>=t)return [new Oc(this.overscaledZ+1,this.wrap,this.canonical.z,this.canonical.x,this.canonical.y)];const e=this.canonical.z+1,r=2*this.canonical.x,n=2*this.canonical.y;return [new Oc(e,this.wrap,e,r,n),new Oc(e,this.wrap,e,r+1,n),new Oc(e,this.wrap,e,r,n+1),new Oc(e,this.wrap,e,r+1,n+1)]}isLessThan(t){return this.wrap<t.wrap||!(this.wrap>t.wrap)&&(this.overscaledZ<t.overscaledZ||!(this.overscaledZ>t.overscaledZ)&&(this.canonical.x<t.canonical.x||!(this.canonical.x>t.canonical.x)&&this.canonical.y<t.canonical.y))}wrapped(){return new Oc(this.overscaledZ,0,this.canonical.z,this.canonical.x,this.canonical.y)}unwrapTo(t){return new Oc(this.overscaledZ,t,this.canonical.z,this.canonical.x,this.canonical.y)}overscaleFactor(){return Math.pow(2,this.overscaledZ-this.canonical.z)}toUnwrapped(){return new Dc(this.wrap,this.canonical)}toString(){return `${this.overscaledZ}/${this.canonical.x}/${this.canonical.y}`}getTilePoint(t){return this.canonical.getTilePoint(new Tc(t.x-this.wrap,t.y))}}function jc(t,e,r,n,i){(t*=2)<0&&(t=-1*t-1);const s=1<<r;return (s*s*t+s*i+n).toString(36)+r.toString(36)+e.toString(36)}wi("CanonicalTileID",Lc),wi("OverscaledTileID",Oc,{omit:["posMatrix"]});class Rc{constructor(t,e,r,n=1,i=1,s=1,a=0){if(this.uid=t,e.height!==e.width)throw new RangeError("DEM tiles must be square");if(r&&!["mapbox","terrarium","custom"].includes(r))return void A(`"${r}" is not a valid encoding type. Valid types include "mapbox", "terrarium" and "custom".`);this.stride=e.height;const o=this.dim=e.height-2;switch(this.data=new Uint32Array(e.data.buffer),r){case"terrarium":this.redFactor=256,this.greenFactor=1,this.blueFactor=1/256,this.baseShift=32768;break;case"custom":this.redFactor=n,this.greenFactor=i,this.blueFactor=s,this.baseShift=a;break;default:this.redFactor=6553.6,this.greenFactor=25.6,this.blueFactor=.1,this.baseShift=1e4;}for(let t=0;t<o;t++)this.data[this._idx(-1,t)]=this.data[this._idx(0,t)],this.data[this._idx(o,t)]=this.data[this._idx(o-1,t)],this.data[this._idx(t,-1)]=this.data[this._idx(t,0)],this.data[this._idx(t,o)]=this.data[this._idx(t,o-1)];this.data[this._idx(-1,-1)]=this.data[this._idx(0,0)],this.data[this._idx(o,-1)]=this.data[this._idx(o-1,0)],this.data[this._idx(-1,o)]=this.data[this._idx(0,o-1)],this.data[this._idx(o,o)]=this.data[this._idx(o-1,o-1)],this.min=Number.MAX_SAFE_INTEGER,this.max=Number.MIN_SAFE_INTEGER;for(let t=0;t<o;t++)for(let e=0;e<o;e++){const r=this.get(t,e);r>this.max&&(this.max=r),r<this.min&&(this.min=r);}}get(t,e){const r=new Uint8Array(this.data.buffer),n=4*this._idx(t,e);return this.unpack(r[n],r[n+1],r[n+2])}getUnpackVector(){return [this.redFactor,this.greenFactor,this.blueFactor,this.baseShift]}_idx(t,e){if(t<-1||t>=this.dim+1||e<-1||e>=this.dim+1)throw new RangeError("out of range source coordinates for DEM data");return (e+1)*this.stride+(t+1)}unpack(t,e,r){return t*this.redFactor+e*this.greenFactor+r*this.blueFactor-this.baseShift}getPixels(){return new Ao({width:this.stride,height:this.stride},new Uint8Array(this.data.buffer))}backfillBorder(t,e,r){if(this.dim!==t.dim)throw new Error("dem dimension mismatch");let n=e*this.dim,i=e*this.dim+this.dim,s=r*this.dim,a=r*this.dim+this.dim;switch(e){case-1:n=i-1;break;case 1:i=n+1;}switch(r){case-1:s=a-1;break;case 1:a=s+1;}const o=-e*this.dim,l=-r*this.dim;for(let e=s;e<a;e++)for(let r=n;r<i;r++)this.data[this._idx(r,e)]=t.data[this._idx(r+o,e+l)];}}wi("DEMData",Rc);class Uc{constructor(t){this._stringToNumber={},this._numberToString=[];for(let e=0;e<t.length;e++){const r=t[e];this._stringToNumber[r]=e,this._numberToString[e]=r;}}encode(t){return this._stringToNumber[t]}decode(t){if(t>=this._numberToString.length)throw new Error(`Out of bounds. Index requested n=${t} can't be >= this._numberToString.length ${this._numberToString.length}`);return this._numberToString[t]}}class qc{constructor(t,e,r,n,i){this.type="Feature",this._vectorTileFeature=t,t._z=e,t._x=r,t._y=n,this.properties=t.properties,this.id=i;}get geometry(){return void 0===this._geometry&&(this._geometry=this._vectorTileFeature.toGeoJSON(this._vectorTileFeature._x,this._vectorTileFeature._y,this._vectorTileFeature._z).geometry),this._geometry}set geometry(t){this._geometry=t;}toJSON(){const t={geometry:this.geometry};for(const e in this)"_geometry"!==e&&"_vectorTileFeature"!==e&&(t[e]=this[e]);return t}}class Nc{constructor(t,e){this.tileID=t,this.x=t.canonical.x,this.y=t.canonical.y,this.z=t.canonical.z,this.grid=new vi($a,16,0),this.grid3D=new vi($a,16,0),this.featureIndexArray=new Ns,this.promoteId=e;}insert(t,e,r,n,i,s){const a=this.featureIndexArray.length;this.featureIndexArray.emplaceBack(r,n,i);const o=s?this.grid3D:this.grid;for(let t=0;t<e.length;t++){const r=e[t],n=[1/0,1/0,-1/0,-1/0];for(let t=0;t<r.length;t++){const e=r[t];n[0]=Math.min(n[0],e.x),n[1]=Math.min(n[1],e.y),n[2]=Math.max(n[2],e.x),n[3]=Math.max(n[3],e.y);}n[0]<$a&&n[1]<$a&&n[2]>=0&&n[3]>=0&&o.insert(a,n[0],n[1],n[2],n[3]);}}loadVTLayers(){return this.vtLayers||(this.vtLayers=new pl.VectorTile(new Mu(this.rawTileData)).layers,this.sourceLayerCoder=new Uc(this.vtLayers?Object.keys(this.vtLayers).sort():["_geojsonTileLayer"])),this.vtLayers}query(t,e,r,n){this.loadVTLayers();const i=t.params||{},a=$a/t.tileSize/t.scale,o=zn(i.filter),l=t.queryGeometry,u=t.queryPadding*a,c=Gc(l),h=this.grid.query(c.minX-u,c.minY-u,c.maxX+u,c.maxY+u),p=Gc(t.cameraQueryGeometry),f=this.grid3D.query(p.minX-u,p.minY-u,p.maxX+u,p.maxY+u,((e,r,n,i)=>function(t,e,r,n,i){for(const s of t)if(e<=s.x&&r<=s.y&&n>=s.x&&i>=s.y)return !0;const a=[new s(e,r),new s(e,i),new s(n,i),new s(n,r)];if(t.length>2)for(const e of a)if(Wa(t,e))return !0;for(let e=0;e<t.length-1;e++)if(Qa(t[e],t[e+1],a))return !0;return !1}(t.cameraQueryGeometry,e-u,r-u,n+u,i+u)));for(const t of f)h.push(t);h.sort(Kc);const d={};let y;for(let s=0;s<h.length;s++){const u=h[s];if(u===y)continue;y=u;const c=this.featureIndexArray.get(u);let p=null;this.loadMatchingFeature(d,c.bucketIndex,c.sourceLayerIndex,c.featureIndex,o,i.layers,i.availableImages,e,r,n,((e,r,n)=>(p||(p=Oa(e)),r.queryIntersectsFeature(l,e,n,p,this.z,t.transform,a,t.pixelPosMatrix))));}return d}loadMatchingFeature(t,e,r,n,i,s,a,o,l,u,c){const h=this.bucketLayerIDs[e];if(s&&!function(t,e){for(let r=0;r<t.length;r++)if(e.indexOf(t[r])>=0)return !0;return !1}(s,h))return;const p=this.sourceLayerCoder.decode(r),f=this.vtLayers[p].feature(n);if(i.needGeometry){const t=ja(f,!0);if(!i.filter(new Ui(this.tileID.overscaledZ),t,this.tileID.canonical))return}else if(!i.filter(new Ui(this.tileID.overscaledZ),f))return;const d=this.getId(f,p);for(let e=0;e<h.length;e++){const r=h[e];if(s&&s.indexOf(r)<0)continue;const i=o[r];if(!i)continue;let p={};d&&u&&(p=u.getState(i.sourceLayer||"_geojsonTileLayer",d));const y=g({},l[r]);y.paint=Zc(y.paint,i.paint,f,p,a),y.layout=Zc(y.layout,i.layout,f,p,a);const m=!c||c(f,i,p);if(!m)continue;const x=new qc(f,this.z,this.x,this.y,d);x.layer=y;let v=t[r];void 0===v&&(v=t[r]=[]),v.push({featureIndex:n,feature:x,intersectionZ:m});}}lookupSymbolFeatures(t,e,r,n,i,s,a,o){const l={};this.loadVTLayers();const u=zn(i);for(const i of t)this.loadMatchingFeature(l,r,n,i,u,s,a,o,e);return l}hasLayer(t){for(const e of this.bucketLayerIDs)for(const r of e)if(t===r)return !0;return !1}getId(t,e){let r=t.id;return this.promoteId&&(r=t.properties["string"==typeof this.promoteId?this.promoteId:this.promoteId[e]],"boolean"==typeof r&&(r=Number(r))),r}}function Zc(t,e,r,n,i){return v(t,((t,s)=>{const a=e instanceof Yi?e.get(s):null;return a&&a.evaluate?a.evaluate(r,n,i):a}))}function Gc(t){let e=1/0,r=1/0,n=-1/0,i=-1/0;for(const s of t)e=Math.min(e,s.x),r=Math.min(r,s.y),n=Math.max(n,s.x),i=Math.max(i,s.y);return {minX:e,minY:r,maxX:n,maxY:i}}function Kc(t,e){return e-t}function Xc(t,e,r,n,i){const a=[];for(let o=0;o<t.length;o++){const l=t[o];let u;for(let t=0;t<l.length-1;t++){let o=l[t],c=l[t+1];o.x<e&&c.x<e||(o.x<e?o=new s(e,o.y+(e-o.x)/(c.x-o.x)*(c.y-o.y))._round():c.x<e&&(c=new s(e,o.y+(e-o.x)/(c.x-o.x)*(c.y-o.y))._round()),o.y<r&&c.y<r||(o.y<r?o=new s(o.x+(r-o.y)/(c.y-o.y)*(c.x-o.x),r)._round():c.y<r&&(c=new s(o.x+(r-o.y)/(c.y-o.y)*(c.x-o.x),r)._round()),o.x>=n&&c.x>=n||(o.x>=n?o=new s(n,o.y+(n-o.x)/(c.x-o.x)*(c.y-o.y))._round():c.x>=n&&(c=new s(n,o.y+(n-o.x)/(c.x-o.x)*(c.y-o.y))._round()),o.y>=i&&c.y>=i||(o.y>=i?o=new s(o.x+(i-o.y)/(c.y-o.y)*(c.x-o.x),i)._round():c.y>=i&&(c=new s(o.x+(i-o.y)/(c.y-o.y)*(c.x-o.x),i)._round()),u&&o.equals(u[u.length-1])||(u=[o],a.push(u)),u.push(c)))));}}return a}wi("FeatureIndex",Nc,{omit:["rawTileData","sourceLayerCoder"]});class Hc extends s{constructor(t,e,r,n){super(t,e),this.angle=r,void 0!==n&&(this.segment=n);}clone(){return new Hc(this.x,this.y,this.angle,this.segment)}}function Yc(t,e,r,n,i){if(void 0===e.segment||0===r)return !0;let s=e,a=e.segment+1,o=0;for(;o>-r/2;){if(a--,a<0)return !1;o-=t[a].dist(s),s=t[a];}o+=t[a].dist(t[a+1]),a++;const l=[];let u=0;for(;o<r/2;){const e=t[a],r=t[a+1];if(!r)return !1;let s=t[a-1].angleTo(e)-e.angleTo(r);for(s=Math.abs((s+3*Math.PI)%(2*Math.PI)-Math.PI),l.push({distance:o,angleDelta:s}),u+=s;o-l[0].distance>n;)u-=l.shift().angleDelta;if(u>i)return !1;a++,o+=e.dist(r);}return !0}function Jc(t){let e=0;for(let r=0;r<t.length-1;r++)e+=t[r].dist(t[r+1]);return e}function Wc(t,e,r){return t?.6*e*r:0}function Qc(t,e){return Math.max(t?t.right-t.left:0,e?e.right-e.left:0)}function th(t,e,r,n,i,s){const a=Wc(r,i,s),o=Qc(r,n)*s;let l=0;const u=Jc(t)/2;for(let r=0;r<t.length-1;r++){const n=t[r],i=t[r+1],s=n.dist(i);if(l+s>u){const c=(u-l)/s,h=Ce.number(n.x,i.x,c),p=Ce.number(n.y,i.y,c),f=new Hc(h,p,i.angleTo(n),r);return f._round(),!a||Yc(t,f,o,a,e)?f:void 0}l+=s;}}function eh(t,e,r,n,i,s,a,o,l){const u=Wc(n,s,a),c=Qc(n,i),h=c*a,p=0===t[0].x||t[0].x===l||0===t[0].y||t[0].y===l;return e-h<e/4&&(e=h+e/4),rh(t,p?e/2*o%e:(c/2+2*s)*a*o%e,e,u,r,h,p,!1,l)}function rh(t,e,r,n,i,s,a,o,l){const u=s/2,c=Jc(t);let h=0,p=e-r,f=[];for(let e=0;e<t.length-1;e++){const a=t[e],o=t[e+1],d=a.dist(o),y=o.angleTo(a);for(;p+r<h+d;){p+=r;const m=(p-h)/d,g=Ce.number(a.x,o.x,m),x=Ce.number(a.y,o.y,m);if(g>=0&&g<l&&x>=0&&x<l&&p-u>=0&&p+u<=c){const r=new Hc(g,x,y,e);r._round(),n&&!Yc(t,r,s,n,i)||f.push(r);}}h+=d;}return o||f.length||a||(f=rh(t,h/2,r,n,i,s,a,!0,l)),f}wi("Anchor",Hc);const nh=Eu;function ih(t,e,r,n){const i=[],a=t.image,o=a.pixelRatio,l=a.paddedRect.w-2*nh,u=a.paddedRect.h-2*nh;let c={x1:t.left,y1:t.top,x2:t.right,y2:t.bottom};const h=a.stretchX||[[0,l]],p=a.stretchY||[[0,u]],f=(t,e)=>t+e[1]-e[0],d=h.reduce(f,0),y=p.reduce(f,0),m=l-d,g=u-y;let x=0,v=d,b=0,w=y,_=0,A=m,S=0,k=g;if(a.content&&n){const e=a.content,r=e[2]-e[0],n=e[3]-e[1];(a.textFitWidth||a.textFitHeight)&&(c=Qu(t)),x=sh(h,0,e[0]),b=sh(p,0,e[1]),v=sh(h,e[0],e[2]),w=sh(p,e[1],e[3]),_=e[0]-x,S=e[1]-b,A=r-v,k=n-w;}const M=c.x1,I=c.y1,z=c.x2-M,P=c.y2-I,C=(t,n,i,l)=>{const u=oh(t.stretch-x,v,z,M),c=lh(t.fixed-_,A,t.stretch,d),h=oh(n.stretch-b,w,P,I),p=lh(n.fixed-S,k,n.stretch,y),f=oh(i.stretch-x,v,z,M),m=lh(i.fixed-_,A,i.stretch,d),g=oh(l.stretch-b,w,P,I),C=lh(l.fixed-S,k,l.stretch,y),B=new s(u,h),V=new s(f,h),E=new s(f,g),F=new s(u,g),T=new s(c/o,p/o),$=new s(m/o,C/o),L=e*Math.PI/180;if(L){const t=Math.sin(L),e=Math.cos(L),r=[e,-t,t,e];B._matMult(r),V._matMult(r),F._matMult(r),E._matMult(r);}const D=t.stretch+t.fixed,O=n.stretch+n.fixed;return {tl:B,tr:V,bl:F,br:E,tex:{x:a.paddedRect.x+nh+D,y:a.paddedRect.y+nh+O,w:i.stretch+i.fixed-D,h:l.stretch+l.fixed-O},writingMode:void 0,glyphOffset:[0,0],sectionIndex:0,pixelOffsetTL:T,pixelOffsetBR:$,minFontScaleX:A/o/z,minFontScaleY:k/o/P,isSDF:r}};if(n&&(a.stretchX||a.stretchY)){const t=ah(h,m,d),e=ah(p,g,y);for(let r=0;r<t.length-1;r++){const n=t[r],s=t[r+1];for(let t=0;t<e.length-1;t++)i.push(C(n,e[t],s,e[t+1]));}}else i.push(C({fixed:0,stretch:-1},{fixed:0,stretch:-1},{fixed:0,stretch:l+1},{fixed:0,stretch:u+1}));return i}function sh(t,e,r){let n=0;for(const i of t)n+=Math.max(e,Math.min(r,i[1]))-Math.max(e,Math.min(r,i[0]));return n}function ah(t,e,r){const n=[{fixed:-nh,stretch:0}];for(const[e,r]of t){const t=n[n.length-1];n.push({fixed:e-t.stretch,stretch:t.stretch}),n.push({fixed:e-t.stretch,stretch:t.stretch+(r-e)});}return n.push({fixed:e+nh,stretch:r}),n}function oh(t,e,r,n){return t/e*r+n}function lh(t,e,r,n){return t-e*r/n}class uh{constructor(t,e,r,n,i,a,o,l,u,c){var h;if(this.boxStartIndex=t.length,u){let t=a.top,e=a.bottom;const r=a.collisionPadding;r&&(t-=r[1],e+=r[3]);let n=e-t;n>0&&(n=Math.max(10,n),this.circleDiameter=n);}else {const u=(null===(h=a.image)||void 0===h?void 0:h.content)&&(a.image.textFitWidth||a.image.textFitHeight)?Qu(a):{x1:a.left,y1:a.top,x2:a.right,y2:a.bottom};u.y1=u.y1*o-l[0],u.y2=u.y2*o+l[2],u.x1=u.x1*o-l[3],u.x2=u.x2*o+l[1];const p=a.collisionPadding;if(p&&(u.x1-=p[0]*o,u.y1-=p[1]*o,u.x2+=p[2]*o,u.y2+=p[3]*o),c){const t=new s(u.x1,u.y1),e=new s(u.x2,u.y1),r=new s(u.x1,u.y2),n=new s(u.x2,u.y2),i=c*Math.PI/180;t._rotate(i),e._rotate(i),r._rotate(i),n._rotate(i),u.x1=Math.min(t.x,e.x,r.x,n.x),u.x2=Math.max(t.x,e.x,r.x,n.x),u.y1=Math.min(t.y,e.y,r.y,n.y),u.y2=Math.max(t.y,e.y,r.y,n.y);}t.emplaceBack(e.x,e.y,u.x1,u.y1,u.x2,u.y2,r,n,i);}this.boxEndIndex=t.length;}}class ch{constructor(t=[],e=((t,e)=>t<e?-1:t>e?1:0)){if(this.data=t,this.length=this.data.length,this.compare=e,this.length>0)for(let t=(this.length>>1)-1;t>=0;t--)this._down(t);}push(t){this.data.push(t),this._up(this.length++);}pop(){if(0===this.length)return;const t=this.data[0],e=this.data.pop();return --this.length>0&&(this.data[0]=e,this._down(0)),t}peek(){return this.data[0]}_up(t){const{data:e,compare:r}=this,n=e[t];for(;t>0;){const i=t-1>>1,s=e[i];if(r(n,s)>=0)break;e[t]=s,t=i;}e[t]=n;}_down(t){const{data:e,compare:r}=this,n=this.length>>1,i=e[t];for(;t<n;){let n=1+(t<<1);const s=n+1;if(s<this.length&&r(e[s],e[n])<0&&(n=s),r(e[n],i)>=0)break;e[t]=e[n],t=n;}e[t]=i;}}function hh(t,e=1,r=!1){let n=1/0,i=1/0,a=-1/0,o=-1/0;const l=t[0];for(let t=0;t<l.length;t++){const e=l[t];(!t||e.x<n)&&(n=e.x),(!t||e.y<i)&&(i=e.y),(!t||e.x>a)&&(a=e.x),(!t||e.y>o)&&(o=e.y);}const u=Math.min(a-n,o-i);let c=u/2;const h=new ch([],ph);if(0===u)return new s(n,i);for(let e=n;e<a;e+=u)for(let r=i;r<o;r+=u)h.push(new fh(e+c,r+c,c,t));let p=function(t){let e=0,r=0,n=0;const i=t[0];for(let t=0,s=i.length,a=s-1;t<s;a=t++){const s=i[t],o=i[a],l=s.x*o.y-o.x*s.y;r+=(s.x+o.x)*l,n+=(s.y+o.y)*l,e+=3*l;}return new fh(r/e,n/e,0,t)}(t),f=h.length;for(;h.length;){const n=h.pop();(n.d>p.d||!p.d)&&(p=n,r&&console.log("found best %d after %d probes",Math.round(1e4*n.d)/1e4,f)),n.max-p.d<=e||(c=n.h/2,h.push(new fh(n.p.x-c,n.p.y-c,c,t)),h.push(new fh(n.p.x+c,n.p.y-c,c,t)),h.push(new fh(n.p.x-c,n.p.y+c,c,t)),h.push(new fh(n.p.x+c,n.p.y+c,c,t)),f+=4);}return r&&(console.log(`num probes: ${f}`),console.log(`best distance: ${p.d}`)),p.p}function ph(t,e){return e.max-t.max}function fh(t,e,r,n){this.p=new s(t,e),this.h=r,this.d=function(t,e){let r=!1,n=1/0;for(let i=0;i<e.length;i++){const s=e[i];for(let e=0,i=s.length,a=i-1;e<i;a=e++){const i=s[e],o=s[a];i.y>t.y!=o.y>t.y&&t.x<(o.x-i.x)*(t.y-i.y)/(o.y-i.y)+i.x&&(r=!r),n=Math.min(n,Ya(t,i,o));}}return (r?1:-1)*Math.sqrt(n)}(this.p,n),this.max=this.d+this.h*Math.SQRT2;}var dh;t.aq=void 0,(dh=t.aq||(t.aq={}))[dh.center=1]="center",dh[dh.left=2]="left",dh[dh.right=3]="right",dh[dh.top=4]="top",dh[dh.bottom=5]="bottom",dh[dh["top-left"]=6]="top-left",dh[dh["top-right"]=7]="top-right",dh[dh["bottom-left"]=8]="bottom-left",dh[dh["bottom-right"]=9]="bottom-right";const yh=7,mh=Number.POSITIVE_INFINITY;function gh(t,e){return e[1]!==mh?function(t,e,r){let n=0,i=0;switch(e=Math.abs(e),r=Math.abs(r),t){case"top-right":case"top-left":case"top":i=r-yh;break;case"bottom-right":case"bottom-left":case"bottom":i=-r+yh;}switch(t){case"top-right":case"bottom-right":case"right":n=-e;break;case"top-left":case"bottom-left":case"left":n=e;}return [n,i]}(t,e[0],e[1]):function(t,e){let r=0,n=0;e<0&&(e=0);const i=e/Math.SQRT2;switch(t){case"top-right":case"top-left":n=i-yh;break;case"bottom-right":case"bottom-left":n=-i+yh;break;case"bottom":n=-e+yh;break;case"top":n=e-yh;}switch(t){case"top-right":case"bottom-right":r=-i;break;case"top-left":case"bottom-left":r=i;break;case"left":r=e;break;case"right":r=-e;}return [r,n]}(t,e[0])}function xh(t,e,r){var n;const i=t.layout,s=null===(n=i.get("text-variable-anchor-offset"))||void 0===n?void 0:n.evaluate(e,{},r);if(s){const t=s.values,e=[];for(let r=0;r<t.length;r+=2){const n=e[r]=t[r],i=t[r+1].map((t=>t*nu));n.startsWith("top")?i[1]-=yh:n.startsWith("bottom")&&(i[1]+=yh),e[r+1]=i;}return new Qt(e)}const a=i.get("text-variable-anchor");if(a){let n;n=void 0!==t._unevaluatedLayout.getValue("text-radial-offset")?[i.get("text-radial-offset").evaluate(e,{},r)*nu,mh]:i.get("text-offset").evaluate(e,{},r).map((t=>t*nu));const s=[];for(const t of a)s.push(t,gh(t,n));return new Qt(s)}return null}function vh(t){switch(t){case"right":case"top-right":case"bottom-right":return "right";case"left":case"top-left":case"bottom-left":return "left"}return "center"}function bh(e,r,n,i,s,a,o,l,u,c,h){let p=a.textMaxSize.evaluate(r,{});void 0===p&&(p=o);const f=e.layers[0].layout,d=f.get("icon-offset").evaluate(r,{},h),y=_h(n.horizontal),m=o/24,g=e.tilePixelRatio*m,x=e.tilePixelRatio*p/24,v=e.tilePixelRatio*l,b=e.tilePixelRatio*f.get("symbol-spacing"),w=f.get("text-padding")*e.tilePixelRatio,_=function(t,e,r,n=1){const i=t.get("icon-padding").evaluate(e,{},r),s=i&&i.values;return [s[0]*n,s[1]*n,s[2]*n,s[3]*n]}(f,r,h,e.tilePixelRatio),S=f.get("text-max-angle")/180*Math.PI,k="viewport"!==f.get("text-rotation-alignment")&&"point"!==f.get("symbol-placement"),M="map"===f.get("icon-rotation-alignment")&&"point"!==f.get("symbol-placement"),I=f.get("symbol-placement"),z=b/2,P=f.get("icon-text-fit");let C;i&&"none"!==P&&(e.allowVerticalPlacement&&n.vertical&&(C=tc(i,n.vertical,P,f.get("icon-text-fit-padding"),d,m)),y&&(i=tc(i,y,P,f.get("icon-text-fit-padding"),d,m)));const B=(l,p)=>{p.x<0||p.x>=$a||p.y<0||p.y>=$a||function(e,r,n,i,s,a,o,l,u,c,h,p,f,d,y,m,g,x,v,b,w,_,S,k,M){const I=e.addToLineVertexArray(r,n);let z,P,C,B,V=0,E=0,F=0,T=0,$=-1,L=-1;const D={};let O=ma("");if(e.allowVerticalPlacement&&i.vertical){const t=l.layout.get("text-rotate").evaluate(w,{},k)+90;C=new uh(u,r,c,h,p,i.vertical,f,d,y,t),o&&(B=new uh(u,r,c,h,p,o,g,x,y,t));}if(s){const n=l.layout.get("icon-rotate").evaluate(w,{}),i="none"!==l.layout.get("icon-text-fit"),a=ih(s,n,S,i),f=o?ih(o,n,S,i):void 0;P=new uh(u,r,c,h,p,s,g,x,!1,n),V=4*a.length;const d=e.iconSizeData;let y=null;"source"===d.kind?(y=[rc*l.layout.get("icon-size").evaluate(w,{})],y[0]>nc&&A(`${e.layerIds[0]}: Value for "icon-size" is >= ${ec}. Reduce your "icon-size".`)):"composite"===d.kind&&(y=[rc*_.compositeIconSizes[0].evaluate(w,{},k),rc*_.compositeIconSizes[1].evaluate(w,{},k)],(y[0]>nc||y[1]>nc)&&A(`${e.layerIds[0]}: Value for "icon-size" is >= ${ec}. Reduce your "icon-size".`)),e.addSymbols(e.icon,a,y,b,v,w,t.ah.none,r,I.lineStartIndex,I.lineLength,-1,k),$=e.icon.placedSymbolArray.length-1,f&&(E=4*f.length,e.addSymbols(e.icon,f,y,b,v,w,t.ah.vertical,r,I.lineStartIndex,I.lineLength,-1,k),L=e.icon.placedSymbolArray.length-1);}const j=Object.keys(i.horizontal);for(const n of j){const s=i.horizontal[n];if(!z){O=ma(s.text);const t=l.layout.get("text-rotate").evaluate(w,{},k);z=new uh(u,r,c,h,p,s,f,d,y,t);}const o=1===s.positionedLines.length;if(F+=wh(e,r,s,a,l,y,w,m,I,i.vertical?t.ah.horizontal:t.ah.horizontalOnly,o?j:[n],D,$,_,k),o)break}i.vertical&&(T+=wh(e,r,i.vertical,a,l,y,w,m,I,t.ah.vertical,["vertical"],D,L,_,k));const R=z?z.boxStartIndex:e.collisionBoxArray.length,U=z?z.boxEndIndex:e.collisionBoxArray.length,q=C?C.boxStartIndex:e.collisionBoxArray.length,N=C?C.boxEndIndex:e.collisionBoxArray.length,Z=P?P.boxStartIndex:e.collisionBoxArray.length,G=P?P.boxEndIndex:e.collisionBoxArray.length,K=B?B.boxStartIndex:e.collisionBoxArray.length,X=B?B.boxEndIndex:e.collisionBoxArray.length;let H=-1;const Y=(t,e)=>t&&t.circleDiameter?Math.max(t.circleDiameter,e):e;H=Y(z,H),H=Y(C,H),H=Y(P,H),H=Y(B,H);const J=H>-1?1:0;J&&(H*=M/nu),e.glyphOffsetArray.length>=fc.MAX_GLYPHS&&A("Too many glyphs being rendered in a tile. See https://github.com/mapbox/mapbox-gl-js/issues/2907"),void 0!==w.sortKey&&e.addToSortKeyRanges(e.symbolInstances.length,w.sortKey);const W=xh(l,w,k),[Q,tt]=function(e,r){const n=e.length,i=null==r?void 0:r.values;if((null==i?void 0:i.length)>0)for(let r=0;r<i.length;r+=2){const n=i[r+1];e.emplaceBack(t.aq[i[r]],n[0],n[1]);}return [n,e.length]}(e.textAnchorOffsets,W);e.symbolInstances.emplaceBack(r.x,r.y,D.right>=0?D.right:-1,D.center>=0?D.center:-1,D.left>=0?D.left:-1,D.vertical||-1,$,L,O,R,U,q,N,Z,G,K,X,c,F,T,V,E,J,0,f,H,Q,tt);}(e,p,l,n,i,s,C,e.layers[0],e.collisionBoxArray,r.index,r.sourceLayerIndex,e.index,g,[w,w,w,w],k,u,v,_,M,d,r,a,c,h,o);};if("line"===I)for(const t of Xc(r.geometry,0,0,$a,$a)){const r=eh(t,b,S,n.vertical||y,i,24,x,e.overscaling,$a);for(const n of r)y&&Ah(e,y.text,z,n)||B(t,n);}else if("line-center"===I){for(const t of r.geometry)if(t.length>1){const e=th(t,S,n.vertical||y,i,24,x);e&&B(t,e);}}else if("Polygon"===r.type)for(const t of xr(r.geometry,0)){const e=hh(t,16);B(t[0],new Hc(e.x,e.y,0));}else if("LineString"===r.type)for(const t of r.geometry)B(t,new Hc(t[0].x,t[0].y,0));else if("Point"===r.type)for(const t of r.geometry)for(const e of t)B([e],new Hc(e.x,e.y,0));}function wh(t,e,r,n,i,a,o,l,u,c,h,p,f,d,y){const m=function(t,e,r,n,i,a,o,l){const u=n.layout.get("text-rotate").evaluate(a,{})*Math.PI/180,c=[];for(const t of e.positionedLines)for(const n of t.positionedGlyphs){if(!n.rect)continue;const a=n.rect||{};let h=Bu+1,p=!0,f=1,d=0;const y=(i||l)&&n.vertical,m=n.metrics.advance*n.scale/2;if(l&&e.verticalizable&&(d=t.lineOffset/2-(n.imageName?-(nu-n.metrics.width*n.scale)/2:(n.scale-1)*nu)),n.imageName){const t=o[n.imageName];p=t.sdf,f=t.pixelRatio,h=Eu/f;}const g=i?[n.x+m,n.y]:[0,0];let x=i?[0,0]:[n.x+m+r[0],n.y+r[1]-d],v=[0,0];y&&(v=x,x=[0,0]);const b=n.metrics.isDoubleResolution?2:1,w=(n.metrics.left-h)*n.scale-m+x[0],_=(-n.metrics.top-h)*n.scale+x[1],A=w+a.w/b*n.scale/f,S=_+a.h/b*n.scale/f,k=new s(w,_),M=new s(A,_),I=new s(w,S),z=new s(A,S);if(y){const t=new s(-m,m-Lu),e=-Math.PI/2,r=nu/2-m,i=new s(5-Lu-r,-(n.imageName?r:0)),a=new s(...v);k._rotateAround(e,t)._add(i)._add(a),M._rotateAround(e,t)._add(i)._add(a),I._rotateAround(e,t)._add(i)._add(a),z._rotateAround(e,t)._add(i)._add(a);}if(u){const t=Math.sin(u),e=Math.cos(u),r=[e,-t,t,e];k._matMult(r),M._matMult(r),I._matMult(r),z._matMult(r);}const P=new s(0,0),C=new s(0,0);c.push({tl:k,tr:M,bl:I,br:z,tex:a,writingMode:e.writingMode,glyphOffset:g,sectionIndex:n.sectionIndex,isSDF:p,pixelOffsetTL:P,pixelOffsetBR:C,minFontScaleX:0,minFontScaleY:0});}return c}(0,r,l,i,a,o,n,t.allowVerticalPlacement),g=t.textSizeData;let x=null;"source"===g.kind?(x=[rc*i.layout.get("text-size").evaluate(o,{})],x[0]>nc&&A(`${t.layerIds[0]}: Value for "text-size" is >= ${ec}. Reduce your "text-size".`)):"composite"===g.kind&&(x=[rc*d.compositeTextSizes[0].evaluate(o,{},y),rc*d.compositeTextSizes[1].evaluate(o,{},y)],(x[0]>nc||x[1]>nc)&&A(`${t.layerIds[0]}: Value for "text-size" is >= ${ec}. Reduce your "text-size".`)),t.addSymbols(t.text,m,x,l,a,o,c,e,u.lineStartIndex,u.lineLength,f,y);for(const e of h)p[e]=t.text.placedSymbolArray.length-1;return 4*m.length}function _h(t){for(const e in t)return t[e];return null}function Ah(t,e,r,n){const i=t.compareText;if(e in i){const t=i[e];for(let e=t.length-1;e>=0;e--)if(n.dist(t[e])<r)return !0}else i[e]=[];return i[e].push(n),!1}const Sh=[Int8Array,Uint8Array,Uint8ClampedArray,Int16Array,Uint16Array,Int32Array,Uint32Array,Float32Array,Float64Array];class kh{static from(t){if(!(t instanceof ArrayBuffer))throw new Error("Data must be an instance of ArrayBuffer.");const[e,r]=new Uint8Array(t,0,2);if(219!==e)throw new Error("Data does not appear to be in a KDBush format.");const n=r>>4;if(1!==n)throw new Error(`Got v${n} data when expected v1.`);const i=Sh[15&r];if(!i)throw new Error("Unrecognized array type.");const[s]=new Uint16Array(t,2,1),[a]=new Uint32Array(t,4,1);return new kh(a,s,i,t)}constructor(t,e=64,r=Float64Array,n){if(isNaN(t)||t<0)throw new Error(`Unpexpected numItems value: ${t}.`);this.numItems=+t,this.nodeSize=Math.min(Math.max(+e,2),65535),this.ArrayType=r,this.IndexArrayType=t<65536?Uint16Array:Uint32Array;const i=Sh.indexOf(this.ArrayType),s=2*t*this.ArrayType.BYTES_PER_ELEMENT,a=t*this.IndexArrayType.BYTES_PER_ELEMENT,o=(8-a%8)%8;if(i<0)throw new Error(`Unexpected typed array class: ${r}.`);n&&n instanceof ArrayBuffer?(this.data=n,this.ids=new this.IndexArrayType(this.data,8,t),this.coords=new this.ArrayType(this.data,8+a+o,2*t),this._pos=2*t,this._finished=!0):(this.data=new ArrayBuffer(8+s+a+o),this.ids=new this.IndexArrayType(this.data,8,t),this.coords=new this.ArrayType(this.data,8+a+o,2*t),this._pos=0,this._finished=!1,new Uint8Array(this.data,0,2).set([219,16+i]),new Uint16Array(this.data,2,1)[0]=e,new Uint32Array(this.data,4,1)[0]=t);}add(t,e){const r=this._pos>>1;return this.ids[r]=r,this.coords[this._pos++]=t,this.coords[this._pos++]=e,r}finish(){const t=this._pos>>1;if(t!==this.numItems)throw new Error(`Added ${t} items when expected ${this.numItems}.`);return Mh(this.ids,this.coords,this.nodeSize,0,this.numItems-1,0),this._finished=!0,this}range(t,e,r,n){if(!this._finished)throw new Error("Data not yet indexed - call index.finish().");const{ids:i,coords:s,nodeSize:a}=this,o=[0,i.length-1,0],l=[];for(;o.length;){const u=o.pop()||0,c=o.pop()||0,h=o.pop()||0;if(c-h<=a){for(let a=h;a<=c;a++){const o=s[2*a],u=s[2*a+1];o>=t&&o<=r&&u>=e&&u<=n&&l.push(i[a]);}continue}const p=h+c>>1,f=s[2*p],d=s[2*p+1];f>=t&&f<=r&&d>=e&&d<=n&&l.push(i[p]),(0===u?t<=f:e<=d)&&(o.push(h),o.push(p-1),o.push(1-u)),(0===u?r>=f:n>=d)&&(o.push(p+1),o.push(c),o.push(1-u));}return l}within(t,e,r){if(!this._finished)throw new Error("Data not yet indexed - call index.finish().");const{ids:n,coords:i,nodeSize:s}=this,a=[0,n.length-1,0],o=[],l=r*r;for(;a.length;){const u=a.pop()||0,c=a.pop()||0,h=a.pop()||0;if(c-h<=s){for(let r=h;r<=c;r++)Ch(i[2*r],i[2*r+1],t,e)<=l&&o.push(n[r]);continue}const p=h+c>>1,f=i[2*p],d=i[2*p+1];Ch(f,d,t,e)<=l&&o.push(n[p]),(0===u?t-r<=f:e-r<=d)&&(a.push(h),a.push(p-1),a.push(1-u)),(0===u?t+r>=f:e+r>=d)&&(a.push(p+1),a.push(c),a.push(1-u));}return o}}function Mh(t,e,r,n,i,s){if(i-n<=r)return;const a=n+i>>1;Ih(t,e,a,n,i,s),Mh(t,e,r,n,a-1,1-s),Mh(t,e,r,a+1,i,1-s);}function Ih(t,e,r,n,i,s){for(;i>n;){if(i-n>600){const a=i-n+1,o=r-n+1,l=Math.log(a),u=.5*Math.exp(2*l/3),c=.5*Math.sqrt(l*u*(a-u)/a)*(o-a/2<0?-1:1);Ih(t,e,r,Math.max(n,Math.floor(r-o*u/a+c)),Math.min(i,Math.floor(r+(a-o)*u/a+c)),s);}const a=e[2*r+s];let o=n,l=i;for(zh(t,e,n,r),e[2*i+s]>a&&zh(t,e,n,i);o<l;){for(zh(t,e,o,l),o++,l--;e[2*o+s]<a;)o++;for(;e[2*l+s]>a;)l--;}e[2*n+s]===a?zh(t,e,n,l):(l++,zh(t,e,l,i)),l<=r&&(n=l+1),r<=l&&(i=l-1);}}function zh(t,e,r,n){Ph(t,r,n),Ph(e,2*r,2*n),Ph(e,2*r+1,2*n+1);}function Ph(t,e,r){const n=t[e];t[e]=t[r],t[r]=n;}function Ch(t,e,r,n){const i=t-r,s=e-n;return i*i+s*s}var Bh;t.bf=void 0,(Bh=t.bf||(t.bf={})).create="create",Bh.load="load",Bh.fullLoad="fullLoad";let Vh=null,Eh=[];const Fh=1e3/60,Th="loadTime",$h="fullLoadTime",Lh={mark(t){performance.mark(t);},frame(t){const e=t;null!=Vh&&Eh.push(e-Vh),Vh=e;},clearMetrics(){Vh=null,Eh=[],performance.clearMeasures(Th),performance.clearMeasures($h);for(const e in t.bf)performance.clearMarks(t.bf[e]);},getPerformanceMetrics(){performance.measure(Th,t.bf.create,t.bf.load),performance.measure($h,t.bf.create,t.bf.fullLoad);const e=performance.getEntriesByName(Th)[0].duration,r=performance.getEntriesByName($h)[0].duration,n=Eh.length,i=1/(Eh.reduce(((t,e)=>t+e),0)/n/1e3),s=Eh.filter((t=>t>Fh)).reduce(((t,e)=>t+(e-Fh)/Fh),0);return {loadTime:e,fullLoadTime:r,fps:i,percentDroppedFrames:s/(n+s)*100,totalFrames:n}}};t.$=class extends ps{},t.A=oo,t.B=yi,t.C=function(t){if(null==M){const e=t.navigator?t.navigator.userAgent:null;M=!!t.safari||!(!e||!(/\b(iPad|iPhone|iPod)\b/.test(e)||e.match("Safari")&&!e.match("Chrome")));}return M},t.D=Ji,t.E=Z,t.F=class{constructor(t,e){this.target=t,this.mapId=e,this.resolveRejects={},this.tasks={},this.taskQueue=[],this.abortControllers={},this.messageHandlers={},this.invoker=new Mc((()=>this.process())),this.subscription=function(t,e,r,n){return t.addEventListener(e,r,!1),{unsubscribe:()=>{t.removeEventListener(e,r,!1);}}}(this.target,"message",(t=>this.receive(t))),this.globalScope=k(self)?t:window;}registerMessageHandler(t,e){this.messageHandlers[t]=e;}sendAsync(t,e){return new Promise(((r,n)=>{const i=Math.round(1e18*Math.random()).toString(36).substring(0,10);this.resolveRejects[i]={resolve:r,reject:n},e&&e.signal.addEventListener("abort",(()=>{delete this.resolveRejects[i];const e={id:i,type:"<cancel>",origin:location.origin,targetMapId:t.targetMapId,sourceMapId:this.mapId};this.target.postMessage(e);}),{once:!0});const s=[],a=Object.assign(Object.assign({},t),{id:i,sourceMapId:this.mapId,origin:location.origin,data:ki(t.data,s)});this.target.postMessage(a,{transfer:s});}))}receive(t){const e=t.data,r=e.id;if(!("file://"!==e.origin&&"file://"!==location.origin&&"resource://android"!==e.origin&&"resource://android"!==location.origin&&e.origin!==location.origin||e.targetMapId&&this.mapId!==e.targetMapId)){if("<cancel>"===e.type){delete this.tasks[r];const t=this.abortControllers[r];return delete this.abortControllers[r],void(t&&t.abort())}if(k(self)||e.mustQueue)return this.tasks[r]=e,this.taskQueue.push(r),void this.invoker.trigger();this.processTask(r,e);}}process(){if(0===this.taskQueue.length)return;const t=this.taskQueue.shift(),e=this.tasks[t];delete this.tasks[t],this.taskQueue.length>0&&this.invoker.trigger(),e&&this.processTask(t,e);}processTask(t,r){return e(this,void 0,void 0,(function*(){if("<response>"===r.type){const e=this.resolveRejects[t];if(delete this.resolveRejects[t],!e)return;return void(r.error?e.reject(Mi(r.error)):e.resolve(Mi(r.data)))}if(!this.messageHandlers[r.type])return void this.completeTask(t,new Error(`Could not find a registered handler for ${r.type}, map ID: ${this.mapId}, available handlers: ${Object.keys(this.messageHandlers).join(", ")}`));const e=Mi(r.data),n=new AbortController;this.abortControllers[t]=n;try{const i=yield this.messageHandlers[r.type](r.sourceMapId,e,n);this.completeTask(t,null,i);}catch(e){this.completeTask(t,e);}}))}completeTask(t,e,r){const n=[];delete this.abortControllers[t];const i={id:t,type:"<response>",sourceMapId:this.mapId,origin:location.origin,error:e?ki(e):null,data:ki(r,n)};this.target.postMessage(i,{transfer:n});}remove(){this.invoker.remove(),this.subscription.unsubscribe();}},t.G=$,t.H=function(){var t=new oo(16);return oo!=Float32Array&&(t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[11]=0,t[12]=0,t[13]=0,t[14]=0),t[0]=1,t[5]=1,t[10]=1,t[15]=1,t},t.I=Fu,t.J=function(t,e,r){var n,i,s,a,o,l,u,c,h,p,f,d,y=r[0],m=r[1],g=r[2];return e===t?(t[12]=e[0]*y+e[4]*m+e[8]*g+e[12],t[13]=e[1]*y+e[5]*m+e[9]*g+e[13],t[14]=e[2]*y+e[6]*m+e[10]*g+e[14],t[15]=e[3]*y+e[7]*m+e[11]*g+e[15]):(i=e[1],s=e[2],a=e[3],o=e[4],l=e[5],u=e[6],c=e[7],h=e[8],p=e[9],f=e[10],d=e[11],t[0]=n=e[0],t[1]=i,t[2]=s,t[3]=a,t[4]=o,t[5]=l,t[6]=u,t[7]=c,t[8]=h,t[9]=p,t[10]=f,t[11]=d,t[12]=n*y+o*m+h*g+e[12],t[13]=i*y+l*m+p*g+e[13],t[14]=s*y+u*m+f*g+e[14],t[15]=a*y+c*m+d*g+e[15]),t},t.K=function(t,e,r){var n=r[0],i=r[1],s=r[2];return t[0]=e[0]*n,t[1]=e[1]*n,t[2]=e[2]*n,t[3]=e[3]*n,t[4]=e[4]*i,t[5]=e[5]*i,t[6]=e[6]*i,t[7]=e[7]*i,t[8]=e[8]*s,t[9]=e[9]*s,t[10]=e[10]*s,t[11]=e[11]*s,t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t},t.L=uo,t.M=function(t,e){const r={};for(let n=0;n<e.length;n++){const i=e[n];i in t&&(r[i]=t[i]);}return r},t.N=zc,t.O=Bc,t.P=s,t.Q=Vc,t.R=Ao,t.S=Oc,t.T=Zi,t.U=h,t.V=p,t.W=P,t.X=$a,t.Y=ls,t.Z=Tc,t._=e,t.a=F,t.a$=function(t,e){return t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t},t.a0=oa,t.a1=Lc,t.a2=it,t.a3=t=>{const e=window.document.createElement("video");return e.muted=!0,new Promise((r=>{e.onloadstart=()=>{r(e);};for(const r of t){const t=window.document.createElement("source");j(r)||(e.crossOrigin="Anonymous"),t.src=r,e.appendChild(t);}}))},t.a4=function(){return x++},t.a5=Fs,t.a6=fc,t.a7=zn,t.a8=ja,t.a9=qc,t.aA=function(t){if("custom"===t.type)return new kc(t);switch(t.type){case"background":return new wc(t);case"circle":return new fo(t);case"fill":return new ll(t);case"fill-extrusion":return new Vl(t);case"heatmap":return new ko(t);case"hillshade":return new zo(t);case"line":return new Xl(t);case"raster":return new Sc(t);case"symbol":return new xc(t)}},t.aB=w,t.aC=function(t,e){if(!t)return [{command:"setStyle",args:[e]}];let r=[];try{if(!H(t.version,e.version))return [{command:"setStyle",args:[e]}];H(t.center,e.center)||r.push({command:"setCenter",args:[e.center]}),H(t.zoom,e.zoom)||r.push({command:"setZoom",args:[e.zoom]}),H(t.bearing,e.bearing)||r.push({command:"setBearing",args:[e.bearing]}),H(t.pitch,e.pitch)||r.push({command:"setPitch",args:[e.pitch]}),H(t.sprite,e.sprite)||r.push({command:"setSprite",args:[e.sprite]}),H(t.glyphs,e.glyphs)||r.push({command:"setGlyphs",args:[e.glyphs]}),H(t.transition,e.transition)||r.push({command:"setTransition",args:[e.transition]}),H(t.light,e.light)||r.push({command:"setLight",args:[e.light]}),H(t.terrain,e.terrain)||r.push({command:"setTerrain",args:[e.terrain]}),H(t.sky,e.sky)||r.push({command:"setSky",args:[e.sky]}),H(t.projection,e.projection)||r.push({command:"setProjection",args:[e.projection]});const n={},i=[];!function(t,e,r,n){let i;for(i in e=e||{},t=t||{})Object.prototype.hasOwnProperty.call(t,i)&&(Object.prototype.hasOwnProperty.call(e,i)||W(i,r,n));for(i in e)Object.prototype.hasOwnProperty.call(e,i)&&(Object.prototype.hasOwnProperty.call(t,i)?H(t[i],e[i])||("geojson"===t[i].type&&"geojson"===e[i].type&&tt(t,e,i)?Y(r,{command:"setGeoJSONSourceData",args:[i,e[i].data]}):Q(i,e,r,n)):J(i,e,r));}(t.sources,e.sources,i,n);const s=[];t.layers&&t.layers.forEach((t=>{"source"in t&&n[t.source]?r.push({command:"removeLayer",args:[t.id]}):s.push(t);})),r=r.concat(i),function(t,e,r){e=e||[];const n=(t=t||[]).map(rt),i=e.map(rt),s=t.reduce(nt,{}),a=e.reduce(nt,{}),o=n.slice(),l=Object.create(null);let u,c,h,p,f;for(let t=0,e=0;t<n.length;t++)u=n[t],Object.prototype.hasOwnProperty.call(a,u)?e++:(Y(r,{command:"removeLayer",args:[u]}),o.splice(o.indexOf(u,e),1));for(let t=0,e=0;t<i.length;t++)u=i[i.length-1-t],o[o.length-1-t]!==u&&(Object.prototype.hasOwnProperty.call(s,u)?(Y(r,{command:"removeLayer",args:[u]}),o.splice(o.lastIndexOf(u,o.length-e),1)):e++,p=o[o.length-t],Y(r,{command:"addLayer",args:[a[u],p]}),o.splice(o.length-t,0,u),l[u]=!0);for(let t=0;t<i.length;t++)if(u=i[t],c=s[u],h=a[u],!l[u]&&!H(c,h))if(H(c.source,h.source)&&H(c["source-layer"],h["source-layer"])&&H(c.type,h.type)){for(f in et(c.layout,h.layout,r,u,null,"setLayoutProperty"),et(c.paint,h.paint,r,u,null,"setPaintProperty"),H(c.filter,h.filter)||Y(r,{command:"setFilter",args:[u,h.filter]}),H(c.minzoom,h.minzoom)&&H(c.maxzoom,h.maxzoom)||Y(r,{command:"setLayerZoomRange",args:[u,h.minzoom,h.maxzoom]}),c)Object.prototype.hasOwnProperty.call(c,f)&&"layout"!==f&&"paint"!==f&&"filter"!==f&&"metadata"!==f&&"minzoom"!==f&&"maxzoom"!==f&&(0===f.indexOf("paint.")?et(c[f],h[f],r,u,f.slice(6),"setPaintProperty"):H(c[f],h[f])||Y(r,{command:"setLayerProperty",args:[u,f,h[f]]}));for(f in h)Object.prototype.hasOwnProperty.call(h,f)&&!Object.prototype.hasOwnProperty.call(c,f)&&"layout"!==f&&"paint"!==f&&"filter"!==f&&"metadata"!==f&&"minzoom"!==f&&"maxzoom"!==f&&(0===f.indexOf("paint.")?et(c[f],h[f],r,u,f.slice(6),"setPaintProperty"):H(c[f],h[f])||Y(r,{command:"setLayerProperty",args:[u,f,h[f]]}));}else Y(r,{command:"removeLayer",args:[u]}),p=o[o.lastIndexOf(u)+1],Y(r,{command:"addLayer",args:[h,p]});}(s,e.layers,r);}catch(t){console.warn("Unable to compute style diff:",t),r=[{command:"setStyle",args:[e]}];}return r},t.aD=function(t){const e=[],r=t.id;return void 0===r&&e.push({message:`layers.${r}: missing required property "id"`}),void 0===t.render&&e.push({message:`layers.${r}: missing required method "render"`}),t.renderingMode&&"2d"!==t.renderingMode&&"3d"!==t.renderingMode&&e.push({message:`layers.${r}: property "renderingMode" must be either "2d" or "3d"`}),e},t.aE=function t(e,r){if(Array.isArray(e)){if(!Array.isArray(r)||e.length!==r.length)return !1;for(let n=0;n<e.length;n++)if(!t(e[n],r[n]))return !1;return !0}if("object"==typeof e&&null!==e&&null!==r){if("object"!=typeof r)return !1;if(Object.keys(e).length!==Object.keys(r).length)return !1;for(const n in e)if(!t(e[n],r[n]))return !1;return !0}return e===r},t.aF=v,t.aG=b,t.aH=class extends wa{constructor(t,e){super(t,e),this.current=0;}set(t){this.current!==t&&(this.current=t,this.gl.uniform1i(this.location,t));}},t.aI=_a,t.aJ=class extends wa{constructor(t,e){super(t,e),this.current=ka;}set(t){if(t[12]!==this.current[12]||t[0]!==this.current[0])return this.current=t,void this.gl.uniformMatrix4fv(this.location,!1,t);for(let e=1;e<16;e++)if(t[e]!==this.current[e]){this.current=t,this.gl.uniformMatrix4fv(this.location,!1,t);break}}},t.aK=Aa,t.aL=Sa,t.aM=Kt,t.aN=class extends wa{constructor(t,e){super(t,e),this.current=[0,0,0];}set(t){t[0]===this.current[0]&&t[1]===this.current[1]&&t[2]===this.current[2]||(this.current=t,this.gl.uniform3f(this.location,t[0],t[1],t[2]));}},t.aO=class extends wa{constructor(t,e){super(t,e),this.current=[0,0];}set(t){t[0]===this.current[0]&&t[1]===this.current[1]||(this.current=t,this.gl.uniform2f(this.location,t[0],t[1]));}},t.aP=function(t,e,r,n,i,s,a){var o=1/(e-r),l=1/(n-i),u=1/(s-a);return t[0]=-2*o,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=-2*l,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=2*u,t[11]=0,t[12]=(e+r)*o,t[13]=(i+n)*l,t[14]=(a+s)*u,t[15]=1,t},t.aQ=ho,t.aR=class extends _s{},t.aS=tu,t.aT=class extends Ss{},t.aU=function(t){return t<=1?1:Math.pow(2,Math.ceil(Math.log(t)/Math.LN2))},t.aV=So,t.aW=Zs,t.aX=na,t.aY=class extends Bs{},t.aZ=function(t,e){return t[0]===e[0]&&t[1]===e[1]&&t[2]===e[2]&&t[3]===e[3]&&t[4]===e[4]&&t[5]===e[5]&&t[6]===e[6]&&t[7]===e[7]&&t[8]===e[8]&&t[9]===e[9]&&t[10]===e[10]&&t[11]===e[11]&&t[12]===e[12]&&t[13]===e[13]&&t[14]===e[14]&&t[15]===e[15]},t.a_=function(t,e){var r=t[0],n=t[1],i=t[2],s=t[3],a=t[4],o=t[5],l=t[6],u=t[7],c=t[8],h=t[9],p=t[10],f=t[11],d=t[12],y=t[13],m=t[14],g=t[15],x=e[0],v=e[1],b=e[2],w=e[3],_=e[4],A=e[5],S=e[6],k=e[7],M=e[8],I=e[9],z=e[10],P=e[11],C=e[12],B=e[13],V=e[14],E=e[15];return Math.abs(r-x)<=ao*Math.max(1,Math.abs(r),Math.abs(x))&&Math.abs(n-v)<=ao*Math.max(1,Math.abs(n),Math.abs(v))&&Math.abs(i-b)<=ao*Math.max(1,Math.abs(i),Math.abs(b))&&Math.abs(s-w)<=ao*Math.max(1,Math.abs(s),Math.abs(w))&&Math.abs(a-_)<=ao*Math.max(1,Math.abs(a),Math.abs(_))&&Math.abs(o-A)<=ao*Math.max(1,Math.abs(o),Math.abs(A))&&Math.abs(l-S)<=ao*Math.max(1,Math.abs(l),Math.abs(S))&&Math.abs(u-k)<=ao*Math.max(1,Math.abs(u),Math.abs(k))&&Math.abs(c-M)<=ao*Math.max(1,Math.abs(c),Math.abs(M))&&Math.abs(h-I)<=ao*Math.max(1,Math.abs(h),Math.abs(I))&&Math.abs(p-z)<=ao*Math.max(1,Math.abs(p),Math.abs(z))&&Math.abs(f-P)<=ao*Math.max(1,Math.abs(f),Math.abs(P))&&Math.abs(d-C)<=ao*Math.max(1,Math.abs(d),Math.abs(C))&&Math.abs(y-B)<=ao*Math.max(1,Math.abs(y),Math.abs(B))&&Math.abs(m-V)<=ao*Math.max(1,Math.abs(m),Math.abs(V))&&Math.abs(g-E)<=ao*Math.max(1,Math.abs(g),Math.abs(E))},t.aa=function(t){const e={};if(t.replace(/(?:^|(?:\s*\,\s*))([^\x00-\x20\(\)<>@\,;\:\\"\/\[\]\?\=\{\}\x7F]+)(?:\=(?:([^\x00-\x20\(\)<>@\,;\:\\"\/\[\]\?\=\{\}\x7F]+)|(?:\"((?:[^"\\]|\\.)*)\")))?/g,((t,r,n,i)=>{const s=n||i;return e[r]=!s||s.toLowerCase(),""})),e["max-age"]){const t=parseInt(e["max-age"],10);isNaN(t)?delete e["max-age"]:e["max-age"]=t;}return e},t.ab=function(t,e){const r=[];for(const n in t)n in e||r.push(n);return r},t.ac=y,t.ad=function(t,e,r){var n=Math.sin(r),i=Math.cos(r),s=e[0],a=e[1],o=e[2],l=e[3],u=e[4],c=e[5],h=e[6],p=e[7];return e!==t&&(t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15]),t[0]=s*i+u*n,t[1]=a*i+c*n,t[2]=o*i+h*n,t[3]=l*i+p*n,t[4]=u*i-s*n,t[5]=c*i-a*n,t[6]=h*i-o*n,t[7]=p*i-l*n,t},t.ae=function(t){var e=new oo(16);return e[0]=t[0],e[1]=t[1],e[2]=t[2],e[3]=t[3],e[4]=t[4],e[5]=t[5],e[6]=t[6],e[7]=t[7],e[8]=t[8],e[9]=t[9],e[10]=t[10],e[11]=t[11],e[12]=t[12],e[13]=t[13],e[14]=t[14],e[15]=t[15],e},t.af=po,t.ag=function(t,e){let r=0,n=0;if("constant"===t.kind)n=t.layoutSize;else if("source"!==t.kind){const{interpolationType:i,minZoom:s,maxZoom:a}=t,o=i?y(Be.interpolationFactor(i,e,s,a),0,1):0;"camera"===t.kind?n=Ce.number(t.minSize,t.maxSize,o):r=o;}return {uSizeT:r,uSize:n}},t.ai=function(t,{uSize:e,uSizeT:r},{lowerSize:n,upperSize:i}){return "source"===t.kind?n/rc:"composite"===t.kind?Ce.number(n/rc,i/rc,r):e},t.aj=uc,t.ak=function(t,e,r,n){const i=e.y-t.y,a=e.x-t.x,o=n.y-r.y,l=n.x-r.x,u=o*a-l*i;if(0===u)return null;const c=(l*(t.y-r.y)-o*(t.x-r.x))/u;return new s(t.x+c*a,t.y+c*i)},t.al=Xc,t.am=qa,t.an=lo,t.ao=function(t){let e=1/0,r=1/0,n=-1/0,i=-1/0;for(const s of t)e=Math.min(e,s.x),r=Math.min(r,s.y),n=Math.max(n,s.x),i=Math.max(i,s.y);return [e,r,n,i]},t.ap=nu,t.ar=sc,t.as=function(t,e){var r=e[0],n=e[1],i=e[2],s=e[3],a=e[4],o=e[5],l=e[6],u=e[7],c=e[8],h=e[9],p=e[10],f=e[11],d=e[12],y=e[13],m=e[14],g=e[15],x=r*o-n*a,v=r*l-i*a,b=r*u-s*a,w=n*l-i*o,_=n*u-s*o,A=i*u-s*l,S=c*y-h*d,k=c*m-p*d,M=c*g-f*d,I=h*m-p*y,z=h*g-f*y,P=p*g-f*m,C=x*P-v*z+b*I+w*M-_*k+A*S;return C?(t[0]=(o*P-l*z+u*I)*(C=1/C),t[1]=(i*z-n*P-s*I)*C,t[2]=(y*A-m*_+g*w)*C,t[3]=(p*_-h*A-f*w)*C,t[4]=(l*M-a*P-u*k)*C,t[5]=(r*P-i*M+s*k)*C,t[6]=(m*b-d*A-g*v)*C,t[7]=(c*A-p*b+f*v)*C,t[8]=(a*z-o*M+u*S)*C,t[9]=(n*M-r*z-s*S)*C,t[10]=(d*_-y*b+g*x)*C,t[11]=(h*b-c*_-f*x)*C,t[12]=(o*k-a*I-l*S)*C,t[13]=(r*I-n*k+i*S)*C,t[14]=(y*v-d*w-m*x)*C,t[15]=(c*w-h*v+p*x)*C,t):null},t.at=vh,t.au=Yu,t.av=kh,t.aw=function(){const t={},e=G.$version;for(const r in G.$root){const n=G.$root[r];if(n.required){let i=null;i="version"===r?e:"array"===n.type?[]:{},null!=i&&(t[r]=i);}}return t},t.ax=Ii,t.ay=D,t.az=function(t){t=t.slice();const e=Object.create(null);for(let r=0;r<t.length;r++)e[t[r].id]=t[r];for(let r=0;r<t.length;r++)"ref"in t[r]&&(t[r]=X(t[r],e[t[r].ref]));return t},t.b=I,t.b0=function(t,e,r){return t[0]=e[0]*r[0],t[1]=e[1]*r[1],t[2]=e[2]*r[2],t[3]=e[3]*r[3],t},t.b1=function(t,e){return t[0]*e[0]+t[1]*e[1]+t[2]*e[2]+t[3]*e[3]},t.b2=m,t.b3=Dc,t.b4=Ec,t.b5=function(t,e,r,n,i){var s,a=1/Math.tan(e/2);return t[0]=a/r,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=a,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[11]=-1,t[12]=0,t[13]=0,t[15]=0,null!=i&&i!==1/0?(t[10]=(i+n)*(s=1/(n-i)),t[14]=2*i*n*s):(t[10]=-1,t[14]=-2*n),t},t.b6=function(t,e,r){var n=Math.sin(r),i=Math.cos(r),s=e[4],a=e[5],o=e[6],l=e[7],u=e[8],c=e[9],h=e[10],p=e[11];return e!==t&&(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15]),t[4]=s*i+u*n,t[5]=a*i+c*n,t[6]=o*i+h*n,t[7]=l*i+p*n,t[8]=u*i-s*n,t[9]=c*i-a*n,t[10]=h*i-o*n,t[11]=p*i-l*n,t},t.b7=f,t.b8=d,t.b9=function(t){return t*Math.PI/180},t.bA=function(t){return t.message===V},t.bB=bn,t.bC=Ri,t.ba=function(t,e){const{x:r,y:n}=Tc.fromLngLat(e);return !(t<0||t>25||n<0||n>=1||r<0||r>=1)},t.bb=function(t,e){return t[0]=e[0],t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=e[1],t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=e[2],t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t},t.bc=class extends hs{},t.bd=Ic,t.be=Lh,t.bg=L,t.bh=function(t,e){F.REGISTERED_PROTOCOLS[t]=e;},t.bi=function(t){delete F.REGISTERED_PROTOCOLS[t];},t.bj=function(t,e){const r={};for(let n=0;n<t.length;n++){const i=e&&e[t[n].id]||Ln(t[n]);e&&(e[t[n].id]=i);let s=r[i];s||(s=r[i]=[]),s.push(t[n]);}const n=[];for(const t in r)n.push(r[t]);return n},t.bk=wi,t.bl=Uc,t.bm=Nc,t.bn=Tu,t.bo=function(e){e.bucket.createArrays(),e.bucket.tilePixelRatio=$a/(512*e.bucket.overscaling),e.bucket.compareText={},e.bucket.iconsNeedLinear=!1;const r=e.bucket.layers[0],n=r.layout,i=r._unevaluatedLayout._values,s={layoutIconSize:i["icon-size"].possiblyEvaluate(new Ui(e.bucket.zoom+1),e.canonical),layoutTextSize:i["text-size"].possiblyEvaluate(new Ui(e.bucket.zoom+1),e.canonical),textMaxSize:i["text-size"].possiblyEvaluate(new Ui(18))};if("composite"===e.bucket.textSizeData.kind){const{minZoom:t,maxZoom:r}=e.bucket.textSizeData;s.compositeTextSizes=[i["text-size"].possiblyEvaluate(new Ui(t),e.canonical),i["text-size"].possiblyEvaluate(new Ui(r),e.canonical)];}if("composite"===e.bucket.iconSizeData.kind){const{minZoom:t,maxZoom:r}=e.bucket.iconSizeData;s.compositeIconSizes=[i["icon-size"].possiblyEvaluate(new Ui(t),e.canonical),i["icon-size"].possiblyEvaluate(new Ui(r),e.canonical)];}const a=n.get("text-line-height")*nu,o="viewport"!==n.get("text-rotation-alignment")&&"point"!==n.get("symbol-placement"),l=n.get("text-keep-upright"),u=n.get("text-size");for(const i of e.bucket.features){const c=n.get("text-font").evaluate(i,{},e.canonical).join(","),h=u.evaluate(i,{},e.canonical),p=s.layoutTextSize.evaluate(i,{},e.canonical),f=s.layoutIconSize.evaluate(i,{},e.canonical),d={horizontal:{},vertical:void 0},y=i.text;let m,g=[0,0];if(y){const s=y.toString(),u=n.get("text-letter-spacing").evaluate(i,{},e.canonical)*nu,f=Ci(s)?u:0,m=n.get("text-anchor").evaluate(i,{},e.canonical),x=xh(r,i,e.canonical);if(!x){const t=n.get("text-radial-offset").evaluate(i,{},e.canonical);g=t?gh(m,[t*nu,mh]):n.get("text-offset").evaluate(i,{},e.canonical).map((t=>t*nu));}let v=o?"center":n.get("text-justify").evaluate(i,{},e.canonical);const b="point"===n.get("symbol-placement")?n.get("text-max-width").evaluate(i,{},e.canonical)*nu:1/0,w=()=>{e.bucket.allowVerticalPlacement&&Pi(s)&&(d.vertical=ju(y,e.glyphMap,e.glyphPositions,e.imagePositions,c,b,a,m,"left",f,g,t.ah.vertical,!0,p,h));};if(!o&&x){const r=new Set;if("auto"===v)for(let t=0;t<x.values.length;t+=2)r.add(vh(x.values[t]));else r.add(v);let n=!1;for(const i of r)if(!d.horizontal[i])if(n)d.horizontal[i]=d.horizontal[0];else {const r=ju(y,e.glyphMap,e.glyphPositions,e.imagePositions,c,b,a,"center",i,f,g,t.ah.horizontal,!1,p,h);r&&(d.horizontal[i]=r,n=1===r.positionedLines.length);}w();}else {"auto"===v&&(v=vh(m));const r=ju(y,e.glyphMap,e.glyphPositions,e.imagePositions,c,b,a,m,v,f,g,t.ah.horizontal,!1,p,h);r&&(d.horizontal[v]=r),w(),Pi(s)&&o&&l&&(d.vertical=ju(y,e.glyphMap,e.glyphPositions,e.imagePositions,c,b,a,m,v,f,g,t.ah.vertical,!1,p,h));}}let x=!1;if(i.icon&&i.icon.name){const t=e.imageMap[i.icon.name];t&&(m=Wu(e.imagePositions[i.icon.name],n.get("icon-offset").evaluate(i,{},e.canonical),n.get("icon-anchor").evaluate(i,{},e.canonical)),x=!!t.sdf,void 0===e.bucket.sdfIcons?e.bucket.sdfIcons=x:e.bucket.sdfIcons!==x&&A("Style sheet warning: Cannot mix SDF and non-SDF icons in one buffer"),(t.pixelRatio!==e.bucket.pixelRatio||0!==n.get("icon-rotate").constantOr(1))&&(e.bucket.iconsNeedLinear=!0));}const v=_h(d.horizontal)||d.vertical;e.bucket.iconsInText=!!v&&v.iconsInText,(v||m)&&bh(e.bucket,i,d,m,e.imageMap,s,p,f,g,x,e.canonical);}e.showCollisionBoxes&&e.bucket.generateCollisionDebugBuffers();},t.bp=Ul,t.bq=il,t.br=Il,t.bs=pl,t.bt=Mu,t.bu=class{constructor(t){this._marks={start:[t.url,"start"].join("#"),end:[t.url,"end"].join("#"),measure:t.url.toString()},performance.mark(this._marks.start);}finish(){performance.mark(this._marks.end);let t=performance.getEntriesByName(this._marks.measure);return 0===t.length&&(performance.measure(this._marks.measure,this._marks.start,this._marks.end),t=performance.getEntriesByName(this._marks.measure),performance.clearMarks(this._marks.start),performance.clearMarks(this._marks.end),performance.clearMeasures(this._marks.measure)),t}},t.bv=function(t,r,n,i,s){return e(this,void 0,void 0,(function*(){if(p())try{return yield P(t,r,n,i,s)}catch(t){}return function(t,e,r,n,i){const s=t.width,a=t.height;C&&B||(C=new OffscreenCanvas(s,a),B=C.getContext("2d",{willReadFrequently:!0})),C.width=s,C.height=a,B.drawImage(t,0,0,s,a);const o=B.getImageData(e,r,n,i);return B.clearRect(0,0,s,a),o.data}(t,r,n,i,s)}))},t.bw=Rc,t.bx=r,t.by=n,t.bz=iu,t.c=E,t.d=t=>e(void 0,void 0,void 0,(function*(){if(0===t.byteLength)return createImageBitmap(new ImageData(1,1));const e=new Blob([new Uint8Array(t)],{type:"image/png"});try{return createImageBitmap(e)}catch(t){throw new Error(`Could not load image because of ${t.message}. Please make sure to use a supported image type such as PNG or JPEG. Note that SVGs are not supported.`)}})),t.e=g,t.f=t=>new Promise(((e,r)=>{const n=new Image;n.onload=()=>{e(n),URL.revokeObjectURL(n.src),n.onload=null,window.requestAnimationFrame((()=>{n.src=z;}));},n.onerror=()=>r(new Error("Could not load image. Please make sure to use a supported image type such as PNG or JPEG. Note that SVGs are not supported."));const i=new Blob([new Uint8Array(t)],{type:"image/png"});n.src=t.byteLength?URL.createObjectURL(i):z;})),t.g=T,t.h=(t,e)=>O(g(t,{type:"json"}),e),t.i=k,t.j=N,t.k=q,t.l=(t,e)=>O(g(t,{type:"arrayBuffer"}),e),t.m=O,t.n=function(t){return new Mu(t).readFields(zu,[])},t.o=_o,t.p=Vu,t.q=rs,t.r=di,t.s=j,t.t=xi,t.u=fi,t.v=G,t.w=A,t.x=function([t,e,r]){return e+=90,e*=Math.PI/180,r*=Math.PI/180,{x:t*Math.cos(e)*Math.sin(r),y:t*Math.sin(e)*Math.sin(r),z:t*Math.cos(r)}},t.y=Ce,t.z=Ui;}));

define("worker",["./shared"],(function(e){"use strict";class t{constructor(e){this.keyCache={},e&&this.replace(e);}replace(e){this._layerConfigs={},this._layers={},this.update(e,[]);}update(t,o){for(const o of t){this._layerConfigs[o.id]=o;const t=this._layers[o.id]=e.aA(o);t._featureFilter=e.a7(t.filter),this.keyCache[o.id]&&delete this.keyCache[o.id];}for(const e of o)delete this.keyCache[e],delete this._layerConfigs[e],delete this._layers[e];this.familiesBySource={};const i=e.bj(Object.values(this._layerConfigs),this.keyCache);for(const e of i){const t=e.map((e=>this._layers[e.id])),o=t[0];if("none"===o.visibility)continue;const i=o.source||"";let s=this.familiesBySource[i];s||(s=this.familiesBySource[i]={});const r=o.sourceLayer||"_geojsonTileLayer";let n=s[r];n||(n=s[r]=[]),n.push(t);}}}class o{constructor(t){const o={},i=[];for(const e in t){const s=t[e],r=o[e]={};for(const e in s){const t=s[+e];if(!t||0===t.bitmap.width||0===t.bitmap.height)continue;const o={x:0,y:0,w:t.bitmap.width+2,h:t.bitmap.height+2};i.push(o),r[e]={rect:o,metrics:t.metrics};}}const{w:s,h:r}=e.p(i),n=new e.o({width:s||1,height:r||1});for(const i in t){const s=t[i];for(const t in s){const r=s[+t];if(!r||0===r.bitmap.width||0===r.bitmap.height)continue;const a=o[i][t].rect;e.o.copy(r.bitmap,n,{x:0,y:0},{x:a.x+1,y:a.y+1},r.bitmap);}}this.image=n,this.positions=o;}}e.bk("GlyphAtlas",o);class i{constructor(t){this.tileID=new e.S(t.tileID.overscaledZ,t.tileID.wrap,t.tileID.canonical.z,t.tileID.canonical.x,t.tileID.canonical.y),this.uid=t.uid,this.zoom=t.zoom,this.pixelRatio=t.pixelRatio,this.tileSize=t.tileSize,this.source=t.source,this.overscaling=this.tileID.overscaleFactor(),this.showCollisionBoxes=t.showCollisionBoxes,this.collectResourceTiming=!!t.collectResourceTiming,this.returnDependencies=!!t.returnDependencies,this.promoteId=t.promoteId,this.inFlightDependencies=[];}parse(t,i,r,n){return e._(this,void 0,void 0,(function*(){this.status="parsing",this.data=t,this.collisionBoxArray=new e.a5;const a=new e.bl(Object.keys(t.layers).sort()),l=new e.bm(this.tileID,this.promoteId);l.bucketLayerIDs=[];const c={},u={featureIndex:l,iconDependencies:{},patternDependencies:{},glyphDependencies:{},availableImages:r},h=i.familiesBySource[this.source];for(const o in h){const i=t.layers[o];if(!i)continue;1===i.version&&e.w(`Vector tile source "${this.source}" layer "${o}" does not use vector tile spec v2 and therefore may have some rendering errors.`);const n=a.encode(o),d=[];for(let e=0;e<i.length;e++){const t=i.feature(e),s=l.getId(t,o);d.push({feature:t,id:s,index:e,sourceLayerIndex:n});}for(const t of h[o]){const o=t[0];o.source!==this.source&&e.w(`layer.source = ${o.source} does not equal this.source = ${this.source}`),o.minzoom&&this.zoom<Math.floor(o.minzoom)||o.maxzoom&&this.zoom>=o.maxzoom||"none"!==o.visibility&&(s(t,this.zoom,r),(c[o.id]=o.createBucket({index:l.bucketLayerIDs.length,layers:t,zoom:this.zoom,pixelRatio:this.pixelRatio,overscaling:this.overscaling,collisionBoxArray:this.collisionBoxArray,sourceLayerIndex:n,sourceID:this.source})).populate(d,u,this.tileID.canonical),l.bucketLayerIDs.push(t.map((e=>e.id))));}}const d=e.aF(u.glyphDependencies,(e=>Object.keys(e).map(Number)));this.inFlightDependencies.forEach((e=>null==e?void 0:e.abort())),this.inFlightDependencies=[];let f=Promise.resolve({});if(Object.keys(d).length){const e=new AbortController;this.inFlightDependencies.push(e),f=n.sendAsync({type:"GG",data:{stacks:d,source:this.source,tileID:this.tileID,type:"glyphs"}},e);}const g=Object.keys(u.iconDependencies);let p=Promise.resolve({});if(g.length){const e=new AbortController;this.inFlightDependencies.push(e),p=n.sendAsync({type:"GI",data:{icons:g,source:this.source,tileID:this.tileID,type:"icons"}},e);}const m=Object.keys(u.patternDependencies);let y=Promise.resolve({});if(m.length){const e=new AbortController;this.inFlightDependencies.push(e),y=n.sendAsync({type:"GI",data:{icons:m,source:this.source,tileID:this.tileID,type:"patterns"}},e);}const[v,w,x]=yield Promise.all([f,p,y]),b=new o(v),S=new e.bn(w,x);for(const t in c){const o=c[t];o instanceof e.a6?(s(o.layers,this.zoom,r),e.bo({bucket:o,glyphMap:v,glyphPositions:b.positions,imageMap:w,imagePositions:S.iconPositions,showCollisionBoxes:this.showCollisionBoxes,canonical:this.tileID.canonical})):o.hasPattern&&(o instanceof e.bp||o instanceof e.bq||o instanceof e.br)&&(s(o.layers,this.zoom,r),o.addFeatures(u,this.tileID.canonical,S.patternPositions));}return this.status="done",{buckets:Object.values(c).filter((e=>!e.isEmpty())),featureIndex:l,collisionBoxArray:this.collisionBoxArray,glyphAtlasImage:b.image,imageAtlas:S,glyphMap:this.returnDependencies?v:null,iconMap:this.returnDependencies?w:null,glyphPositions:this.returnDependencies?b.positions:null}}))}}function s(t,o,i){const s=new e.z(o);for(const e of t)e.recalculate(s,i);}class r{constructor(e,t,o){this.actor=e,this.layerIndex=t,this.availableImages=o,this.fetching={},this.loading={},this.loaded={};}loadVectorTile(t,o){return e._(this,void 0,void 0,(function*(){const i=yield e.l(t.request,o);try{return {vectorTile:new e.bs.VectorTile(new e.bt(i.data)),rawData:i.data,cacheControl:i.cacheControl,expires:i.expires}}catch(e){const o=new Uint8Array(i.data);let s=`Unable to parse the tile at ${t.request.url}, `;throw s+=31===o[0]&&139===o[1]?"please make sure the data is not gzipped and that you have configured the relevant header in the server":`got error: ${e.message}`,new Error(s)}}))}loadTile(t){return e._(this,void 0,void 0,(function*(){const o=t.uid,s=!!(t&&t.request&&t.request.collectResourceTiming)&&new e.bu(t.request),r=new i(t);this.loading[o]=r;const n=new AbortController;r.abort=n;try{const i=yield this.loadVectorTile(t,n);if(delete this.loading[o],!i)return null;const a=i.rawData,l={};i.expires&&(l.expires=i.expires),i.cacheControl&&(l.cacheControl=i.cacheControl);const c={};if(s){const e=s.finish();e&&(c.resourceTiming=JSON.parse(JSON.stringify(e)));}r.vectorTile=i.vectorTile;const u=r.parse(i.vectorTile,this.layerIndex,this.availableImages,this.actor);this.loaded[o]=r,this.fetching[o]={rawTileData:a,cacheControl:l,resourceTiming:c};try{const t=yield u;return e.e({rawTileData:a.slice(0)},t,l,c)}finally{delete this.fetching[o];}}catch(e){throw delete this.loading[o],r.status="done",this.loaded[o]=r,e}}))}reloadTile(t){return e._(this,void 0,void 0,(function*(){const o=t.uid;if(!this.loaded||!this.loaded[o])throw new Error("Should not be trying to reload a tile that was never loaded or has been removed");const i=this.loaded[o];if(i.showCollisionBoxes=t.showCollisionBoxes,"parsing"===i.status){const t=yield i.parse(i.vectorTile,this.layerIndex,this.availableImages,this.actor);let s;if(this.fetching[o]){const{rawTileData:i,cacheControl:r,resourceTiming:n}=this.fetching[o];delete this.fetching[o],s=e.e({rawTileData:i.slice(0)},t,r,n);}else s=t;return s}if("done"===i.status&&i.vectorTile)return i.parse(i.vectorTile,this.layerIndex,this.availableImages,this.actor)}))}abortTile(t){return e._(this,void 0,void 0,(function*(){const e=this.loading,o=t.uid;e&&e[o]&&e[o].abort&&(e[o].abort.abort(),delete e[o]);}))}removeTile(t){return e._(this,void 0,void 0,(function*(){this.loaded&&this.loaded[t.uid]&&delete this.loaded[t.uid];}))}}class n{constructor(){this.loaded={};}loadTile(t){return e._(this,void 0,void 0,(function*(){const{uid:o,encoding:i,rawImageData:s,redFactor:r,greenFactor:n,blueFactor:a,baseShift:l}=t,c=s.width+2,u=s.height+2,h=e.b(s)?new e.R({width:c,height:u},yield e.bv(s,-1,-1,c,u)):s,d=new e.bw(o,h,i,r,n,a,l);return this.loaded=this.loaded||{},this.loaded[o]=d,d}))}removeTile(e){const t=this.loaded,o=e.uid;t&&t[o]&&delete t[o];}}function a(e,t){if(0!==e.length){l(e[0],t);for(var o=1;o<e.length;o++)l(e[o],!t);}}function l(e,t){for(var o=0,i=0,s=0,r=e.length,n=r-1;s<r;n=s++){var a=(e[s][0]-e[n][0])*(e[n][1]+e[s][1]),l=o+a;i+=Math.abs(o)>=Math.abs(a)?o-l+a:a-l+o,o=l;}o+i>=0!=!!t&&e.reverse();}var c=e.bx((function e(t,o){var i,s=t&&t.type;if("FeatureCollection"===s)for(i=0;i<t.features.length;i++)e(t.features[i],o);else if("GeometryCollection"===s)for(i=0;i<t.geometries.length;i++)e(t.geometries[i],o);else if("Feature"===s)e(t.geometry,o);else if("Polygon"===s)a(t.coordinates,o);else if("MultiPolygon"===s)for(i=0;i<t.coordinates.length;i++)a(t.coordinates[i],o);return t}));const u=e.bs.VectorTileFeature.prototype.toGeoJSON;var h={exports:{}},d=e.by,f=e.bs.VectorTileFeature,g=p;function p(e,t){this.options=t||{},this.features=e,this.length=e.length;}function m(e,t){this.id="number"==typeof e.id?e.id:void 0,this.type=e.type,this.rawGeometry=1===e.type?[e.geometry]:e.geometry,this.properties=e.tags,this.extent=t||4096;}p.prototype.feature=function(e){return new m(this.features[e],this.options.extent)},m.prototype.loadGeometry=function(){var e=this.rawGeometry;this.geometry=[];for(var t=0;t<e.length;t++){for(var o=e[t],i=[],s=0;s<o.length;s++)i.push(new d(o[s][0],o[s][1]));this.geometry.push(i);}return this.geometry},m.prototype.bbox=function(){this.geometry||this.loadGeometry();for(var e=this.geometry,t=1/0,o=-1/0,i=1/0,s=-1/0,r=0;r<e.length;r++)for(var n=e[r],a=0;a<n.length;a++){var l=n[a];t=Math.min(t,l.x),o=Math.max(o,l.x),i=Math.min(i,l.y),s=Math.max(s,l.y);}return [t,i,o,s]},m.prototype.toGeoJSON=f.prototype.toGeoJSON;var y=e.bz,v=g;function w(e){var t=new y;return function(e,t){for(var o in e.layers)t.writeMessage(3,x,e.layers[o]);}(e,t),t.finish()}function x(e,t){var o;t.writeVarintField(15,e.version||1),t.writeStringField(1,e.name||""),t.writeVarintField(5,e.extent||4096);var i={keys:[],values:[],keycache:{},valuecache:{}};for(o=0;o<e.length;o++)i.feature=e.feature(o),t.writeMessage(2,b,i);var s=i.keys;for(o=0;o<s.length;o++)t.writeStringField(3,s[o]);var r=i.values;for(o=0;o<r.length;o++)t.writeMessage(4,P,r[o]);}function b(e,t){var o=e.feature;void 0!==o.id&&t.writeVarintField(1,o.id),t.writeMessage(2,S,e),t.writeVarintField(3,o.type),t.writeMessage(4,I,o);}function S(e,t){var o=e.feature,i=e.keys,s=e.values,r=e.keycache,n=e.valuecache;for(var a in o.properties){var l=o.properties[a],c=r[a];if(null!==l){void 0===c&&(i.push(a),r[a]=c=i.length-1),t.writeVarint(c);var u=typeof l;"string"!==u&&"boolean"!==u&&"number"!==u&&(l=JSON.stringify(l));var h=u+":"+l,d=n[h];void 0===d&&(s.push(l),n[h]=d=s.length-1),t.writeVarint(d);}}}function _(e,t){return (t<<3)+(7&e)}function M(e){return e<<1^e>>31}function I(e,t){for(var o=e.loadGeometry(),i=e.type,s=0,r=0,n=o.length,a=0;a<n;a++){var l=o[a],c=1;1===i&&(c=l.length),t.writeVarint(_(1,c));for(var u=3===i?l.length-1:l.length,h=0;h<u;h++){1===h&&1!==i&&t.writeVarint(_(2,u-1));var d=l[h].x-s,f=l[h].y-r;t.writeVarint(M(d)),t.writeVarint(M(f)),s+=d,r+=f;}3===i&&t.writeVarint(_(7,1));}}function P(e,t){var o=typeof e;"string"===o?t.writeStringField(1,e):"boolean"===o?t.writeBooleanField(7,e):"number"===o&&(e%1!=0?t.writeDoubleField(3,e):e<0?t.writeSVarintField(6,e):t.writeVarintField(5,e));}h.exports=w,h.exports.fromVectorTileJs=w,h.exports.fromGeojsonVt=function(e,t){t=t||{};var o={};for(var i in e)o[i]=new v(e[i].features,t),o[i].name=i,o[i].version=t.version,o[i].extent=t.extent;return w({layers:o})},h.exports.GeoJSONWrapper=v;var k=e.bx(h.exports);const T={minZoom:0,maxZoom:16,minPoints:2,radius:40,extent:512,nodeSize:64,log:!1,generateId:!1,reduce:null,map:e=>e},D=Math.fround||(C=new Float32Array(1),e=>(C[0]=+e,C[0]));var C;const L=3,O=5,F=6;class z{constructor(e){this.options=Object.assign(Object.create(T),e),this.trees=new Array(this.options.maxZoom+1),this.stride=this.options.reduce?7:6,this.clusterProps=[];}load(e){const{log:t,minZoom:o,maxZoom:i}=this.options;t&&console.time("total time");const s=`prepare ${e.length} points`;t&&console.time(s),this.points=e;const r=[];for(let t=0;t<e.length;t++){const o=e[t];if(!o.geometry)continue;const[i,s]=o.geometry.coordinates,n=D(G(i)),a=D(j(s));r.push(n,a,1/0,t,-1,1),this.options.reduce&&r.push(0);}let n=this.trees[i+1]=this._createTree(r);t&&console.timeEnd(s);for(let e=i;e>=o;e--){const o=+Date.now();n=this.trees[e]=this._createTree(this._cluster(n,e)),t&&console.log("z%d: %d clusters in %dms",e,n.numItems,+Date.now()-o);}return t&&console.timeEnd("total time"),this}getClusters(e,t){let o=((e[0]+180)%360+360)%360-180;const i=Math.max(-90,Math.min(90,e[1]));let s=180===e[2]?180:((e[2]+180)%360+360)%360-180;const r=Math.max(-90,Math.min(90,e[3]));if(e[2]-e[0]>=360)o=-180,s=180;else if(o>s){const e=this.getClusters([o,i,180,r],t),n=this.getClusters([-180,i,s,r],t);return e.concat(n)}const n=this.trees[this._limitZoom(t)],a=n.range(G(o),j(r),G(s),j(i)),l=n.data,c=[];for(const e of a){const t=this.stride*e;c.push(l[t+O]>1?A(l,t,this.clusterProps):this.points[l[t+L]]);}return c}getChildren(e){const t=this._getOriginId(e),o=this._getOriginZoom(e),i="No cluster with the specified id.",s=this.trees[o];if(!s)throw new Error(i);const r=s.data;if(t*this.stride>=r.length)throw new Error(i);const n=this.options.radius/(this.options.extent*Math.pow(2,o-1)),a=s.within(r[t*this.stride],r[t*this.stride+1],n),l=[];for(const t of a){const o=t*this.stride;r[o+4]===e&&l.push(r[o+O]>1?A(r,o,this.clusterProps):this.points[r[o+L]]);}if(0===l.length)throw new Error(i);return l}getLeaves(e,t,o){const i=[];return this._appendLeaves(i,e,t=t||10,o=o||0,0),i}getTile(e,t,o){const i=this.trees[this._limitZoom(e)],s=Math.pow(2,e),{extent:r,radius:n}=this.options,a=n/r,l=(o-a)/s,c=(o+1+a)/s,u={features:[]};return this._addTileFeatures(i.range((t-a)/s,l,(t+1+a)/s,c),i.data,t,o,s,u),0===t&&this._addTileFeatures(i.range(1-a/s,l,1,c),i.data,s,o,s,u),t===s-1&&this._addTileFeatures(i.range(0,l,a/s,c),i.data,-1,o,s,u),u.features.length?u:null}getClusterExpansionZoom(e){let t=this._getOriginZoom(e)-1;for(;t<=this.options.maxZoom;){const o=this.getChildren(e);if(t++,1!==o.length)break;e=o[0].properties.cluster_id;}return t}_appendLeaves(e,t,o,i,s){const r=this.getChildren(t);for(const t of r){const r=t.properties;if(r&&r.cluster?s+r.point_count<=i?s+=r.point_count:s=this._appendLeaves(e,r.cluster_id,o,i,s):s<i?s++:e.push(t),e.length===o)break}return s}_createTree(t){const o=new e.av(t.length/this.stride|0,this.options.nodeSize,Float32Array);for(let e=0;e<t.length;e+=this.stride)o.add(t[e],t[e+1]);return o.finish(),o.data=t,o}_addTileFeatures(e,t,o,i,s,r){for(const n of e){const e=n*this.stride,a=t[e+O]>1;let l,c,u;if(a)l=E(t,e,this.clusterProps),c=t[e],u=t[e+1];else {const o=this.points[t[e+L]];l=o.properties;const[i,s]=o.geometry.coordinates;c=G(i),u=j(s);}const h={type:1,geometry:[[Math.round(this.options.extent*(c*s-o)),Math.round(this.options.extent*(u*s-i))]],tags:l};let d;d=a||this.options.generateId?t[e+L]:this.points[t[e+L]].id,void 0!==d&&(h.id=d),r.features.push(h);}}_limitZoom(e){return Math.max(this.options.minZoom,Math.min(Math.floor(+e),this.options.maxZoom+1))}_cluster(e,t){const{radius:o,extent:i,reduce:s,minPoints:r}=this.options,n=o/(i*Math.pow(2,t)),a=e.data,l=[],c=this.stride;for(let o=0;o<a.length;o+=c){if(a[o+2]<=t)continue;a[o+2]=t;const i=a[o],u=a[o+1],h=e.within(a[o],a[o+1],n),d=a[o+O];let f=d;for(const e of h){const o=e*c;a[o+2]>t&&(f+=a[o+O]);}if(f>d&&f>=r){let e,r=i*d,n=u*d,g=-1;const p=((o/c|0)<<5)+(t+1)+this.points.length;for(const i of h){const l=i*c;if(a[l+2]<=t)continue;a[l+2]=t;const u=a[l+O];r+=a[l]*u,n+=a[l+1]*u,a[l+4]=p,s&&(e||(e=this._map(a,o,!0),g=this.clusterProps.length,this.clusterProps.push(e)),s(e,this._map(a,l)));}a[o+4]=p,l.push(r/f,n/f,1/0,p,-1,f),s&&l.push(g);}else {for(let e=0;e<c;e++)l.push(a[o+e]);if(f>1)for(const e of h){const o=e*c;if(!(a[o+2]<=t)){a[o+2]=t;for(let e=0;e<c;e++)l.push(a[o+e]);}}}}return l}_getOriginId(e){return e-this.points.length>>5}_getOriginZoom(e){return (e-this.points.length)%32}_map(e,t,o){if(e[t+O]>1){const i=this.clusterProps[e[t+F]];return o?Object.assign({},i):i}const i=this.points[e[t+L]].properties,s=this.options.map(i);return o&&s===i?Object.assign({},s):s}}function A(e,t,o){return {type:"Feature",id:e[t+L],properties:E(e,t,o),geometry:{type:"Point",coordinates:[(i=e[t],360*(i-.5)),R(e[t+1])]}};var i;}function E(e,t,o){const i=e[t+O],s=i>=1e4?`${Math.round(i/1e3)}k`:i>=1e3?Math.round(i/100)/10+"k":i,r=e[t+F],n=-1===r?{}:Object.assign({},o[r]);return Object.assign(n,{cluster:!0,cluster_id:e[t+L],point_count:i,point_count_abbreviated:s})}function G(e){return e/360+.5}function j(e){const t=Math.sin(e*Math.PI/180),o=.5-.25*Math.log((1+t)/(1-t))/Math.PI;return o<0?0:o>1?1:o}function R(e){const t=(180-360*e)*Math.PI/180;return 360*Math.atan(Math.exp(t))/Math.PI-90}function Z(e,t,o,i){let s=i;const r=t+(o-t>>1);let n,a=o-t;const l=e[t],c=e[t+1],u=e[o],h=e[o+1];for(let i=t+3;i<o;i+=3){const t=N(e[i],e[i+1],l,c,u,h);if(t>s)n=i,s=t;else if(t===s){const e=Math.abs(i-r);e<a&&(n=i,a=e);}}s>i&&(n-t>3&&Z(e,t,n,i),e[n+2]=s,o-n>3&&Z(e,n,o,i));}function N(e,t,o,i,s,r){let n=s-o,a=r-i;if(0!==n||0!==a){const l=((e-o)*n+(t-i)*a)/(n*n+a*a);l>1?(o=s,i=r):l>0&&(o+=n*l,i+=a*l);}return n=e-o,a=t-i,n*n+a*a}function J(e,t,o,i){const s={id:null==e?null:e,type:t,geometry:o,tags:i,minX:1/0,minY:1/0,maxX:-1/0,maxY:-1/0};if("Point"===t||"MultiPoint"===t||"LineString"===t)W(s,o);else if("Polygon"===t)W(s,o[0]);else if("MultiLineString"===t)for(const e of o)W(s,e);else if("MultiPolygon"===t)for(const e of o)W(s,e[0]);return s}function W(e,t){for(let o=0;o<t.length;o+=3)e.minX=Math.min(e.minX,t[o]),e.minY=Math.min(e.minY,t[o+1]),e.maxX=Math.max(e.maxX,t[o]),e.maxY=Math.max(e.maxY,t[o+1]);}function Y(e,t,o,i){if(!t.geometry)return;const s=t.geometry.coordinates;if(s&&0===s.length)return;const r=t.geometry.type,n=Math.pow(o.tolerance/((1<<o.maxZoom)*o.extent),2);let a=[],l=t.id;if(o.promoteId?l=t.properties[o.promoteId]:o.generateId&&(l=i||0),"Point"===r)V(s,a);else if("MultiPoint"===r)for(const e of s)V(e,a);else if("LineString"===r)X(s,a,n,!1);else if("MultiLineString"===r){if(o.lineMetrics){for(const o of s)a=[],X(o,a,n,!1),e.push(J(l,"LineString",a,t.properties));return}q(s,a,n,!1);}else if("Polygon"===r)q(s,a,n,!0);else {if("MultiPolygon"!==r){if("GeometryCollection"===r){for(const s of t.geometry.geometries)Y(e,{id:l,geometry:s,properties:t.properties},o,i);return}throw new Error("Input data is not a valid GeoJSON object.")}for(const e of s){const t=[];q(e,t,n,!0),a.push(t);}}e.push(J(l,r,a,t.properties));}function V(e,t){t.push(B(e[0]),H(e[1]),0);}function X(e,t,o,i){let s,r,n=0;for(let o=0;o<e.length;o++){const a=B(e[o][0]),l=H(e[o][1]);t.push(a,l,0),o>0&&(n+=i?(s*l-a*r)/2:Math.sqrt(Math.pow(a-s,2)+Math.pow(l-r,2))),s=a,r=l;}const a=t.length-3;t[2]=1,Z(t,0,a,o),t[a+2]=1,t.size=Math.abs(n),t.start=0,t.end=t.size;}function q(e,t,o,i){for(let s=0;s<e.length;s++){const r=[];X(e[s],r,o,i),t.push(r);}}function B(e){return e/360+.5}function H(e){const t=Math.sin(e*Math.PI/180),o=.5-.25*Math.log((1+t)/(1-t))/Math.PI;return o<0?0:o>1?1:o}function U(e,t,o,i,s,r,n,a){if(i/=t,r>=(o/=t)&&n<i)return e;if(n<o||r>=i)return null;const l=[];for(const t of e){const e=t.geometry;let r=t.type;const n=0===s?t.minX:t.minY,c=0===s?t.maxX:t.maxY;if(n>=o&&c<i){l.push(t);continue}if(c<o||n>=i)continue;let u=[];if("Point"===r||"MultiPoint"===r)$(e,u,o,i,s);else if("LineString"===r)K(e,u,o,i,s,!1,a.lineMetrics);else if("MultiLineString"===r)ee(e,u,o,i,s,!1);else if("Polygon"===r)ee(e,u,o,i,s,!0);else if("MultiPolygon"===r)for(const t of e){const e=[];ee(t,e,o,i,s,!0),e.length&&u.push(e);}if(u.length){if(a.lineMetrics&&"LineString"===r){for(const e of u)l.push(J(t.id,r,e,t.tags));continue}"LineString"!==r&&"MultiLineString"!==r||(1===u.length?(r="LineString",u=u[0]):r="MultiLineString"),"Point"!==r&&"MultiPoint"!==r||(r=3===u.length?"Point":"MultiPoint"),l.push(J(t.id,r,u,t.tags));}}return l.length?l:null}function $(e,t,o,i,s){for(let r=0;r<e.length;r+=3){const n=e[r+s];n>=o&&n<=i&&te(t,e[r],e[r+1],e[r+2]);}}function K(e,t,o,i,s,r,n){let a=Q(e);const l=0===s?oe:ie;let c,u,h=e.start;for(let d=0;d<e.length-3;d+=3){const f=e[d],g=e[d+1],p=e[d+2],m=e[d+3],y=e[d+4],v=0===s?f:g,w=0===s?m:y;let x=!1;n&&(c=Math.sqrt(Math.pow(f-m,2)+Math.pow(g-y,2))),v<o?w>o&&(u=l(a,f,g,m,y,o),n&&(a.start=h+c*u)):v>i?w<i&&(u=l(a,f,g,m,y,i),n&&(a.start=h+c*u)):te(a,f,g,p),w<o&&v>=o&&(u=l(a,f,g,m,y,o),x=!0),w>i&&v<=i&&(u=l(a,f,g,m,y,i),x=!0),!r&&x&&(n&&(a.end=h+c*u),t.push(a),a=Q(e)),n&&(h+=c);}let d=e.length-3;const f=e[d],g=e[d+1],p=0===s?f:g;p>=o&&p<=i&&te(a,f,g,e[d+2]),d=a.length-3,r&&d>=3&&(a[d]!==a[0]||a[d+1]!==a[1])&&te(a,a[0],a[1],a[2]),a.length&&t.push(a);}function Q(e){const t=[];return t.size=e.size,t.start=e.start,t.end=e.end,t}function ee(e,t,o,i,s,r){for(const n of e)K(n,t,o,i,s,r,!1);}function te(e,t,o,i){e.push(t,o,i);}function oe(e,t,o,i,s,r){const n=(r-t)/(i-t);return te(e,r,o+(s-o)*n,1),n}function ie(e,t,o,i,s,r){const n=(r-o)/(s-o);return te(e,t+(i-t)*n,r,1),n}function se(e,t){const o=[];for(let i=0;i<e.length;i++){const s=e[i],r=s.type;let n;if("Point"===r||"MultiPoint"===r||"LineString"===r)n=re(s.geometry,t);else if("MultiLineString"===r||"Polygon"===r){n=[];for(const e of s.geometry)n.push(re(e,t));}else if("MultiPolygon"===r){n=[];for(const e of s.geometry){const o=[];for(const i of e)o.push(re(i,t));n.push(o);}}o.push(J(s.id,r,n,s.tags));}return o}function re(e,t){const o=[];o.size=e.size,void 0!==e.start&&(o.start=e.start,o.end=e.end);for(let i=0;i<e.length;i+=3)o.push(e[i]+t,e[i+1],e[i+2]);return o}function ne(e,t){if(e.transformed)return e;const o=1<<e.z,i=e.x,s=e.y;for(const r of e.features){const e=r.geometry,n=r.type;if(r.geometry=[],1===n)for(let n=0;n<e.length;n+=2)r.geometry.push(ae(e[n],e[n+1],t,o,i,s));else for(let n=0;n<e.length;n++){const a=[];for(let r=0;r<e[n].length;r+=2)a.push(ae(e[n][r],e[n][r+1],t,o,i,s));r.geometry.push(a);}}return e.transformed=!0,e}function ae(e,t,o,i,s,r){return [Math.round(o*(e*i-s)),Math.round(o*(t*i-r))]}function le(e,t,o,i,s){const r=t===s.maxZoom?0:s.tolerance/((1<<t)*s.extent),n={features:[],numPoints:0,numSimplified:0,numFeatures:e.length,source:null,x:o,y:i,z:t,transformed:!1,minX:2,minY:1,maxX:-1,maxY:0};for(const t of e)ce(n,t,r,s);return n}function ce(e,t,o,i){const s=t.geometry,r=t.type,n=[];if(e.minX=Math.min(e.minX,t.minX),e.minY=Math.min(e.minY,t.minY),e.maxX=Math.max(e.maxX,t.maxX),e.maxY=Math.max(e.maxY,t.maxY),"Point"===r||"MultiPoint"===r)for(let t=0;t<s.length;t+=3)n.push(s[t],s[t+1]),e.numPoints++,e.numSimplified++;else if("LineString"===r)ue(n,s,e,o,!1,!1);else if("MultiLineString"===r||"Polygon"===r)for(let t=0;t<s.length;t++)ue(n,s[t],e,o,"Polygon"===r,0===t);else if("MultiPolygon"===r)for(let t=0;t<s.length;t++){const i=s[t];for(let t=0;t<i.length;t++)ue(n,i[t],e,o,!0,0===t);}if(n.length){let o=t.tags||null;if("LineString"===r&&i.lineMetrics){o={};for(const e in t.tags)o[e]=t.tags[e];o.mapbox_clip_start=s.start/s.size,o.mapbox_clip_end=s.end/s.size;}const a={geometry:n,type:"Polygon"===r||"MultiPolygon"===r?3:"LineString"===r||"MultiLineString"===r?2:1,tags:o};null!==t.id&&(a.id=t.id),e.features.push(a);}}function ue(e,t,o,i,s,r){const n=i*i;if(i>0&&t.size<(s?n:i))return void(o.numPoints+=t.length/3);const a=[];for(let e=0;e<t.length;e+=3)(0===i||t[e+2]>n)&&(o.numSimplified++,a.push(t[e],t[e+1])),o.numPoints++;s&&function(e,t){let o=0;for(let t=0,i=e.length,s=i-2;t<i;s=t,t+=2)o+=(e[t]-e[s])*(e[t+1]+e[s+1]);if(o>0===t)for(let t=0,o=e.length;t<o/2;t+=2){const i=e[t],s=e[t+1];e[t]=e[o-2-t],e[t+1]=e[o-1-t],e[o-2-t]=i,e[o-1-t]=s;}}(a,r),e.push(a);}const he={maxZoom:14,indexMaxZoom:5,indexMaxPoints:1e5,tolerance:3,extent:4096,buffer:64,lineMetrics:!1,promoteId:null,generateId:!1,debug:0};class de{constructor(e,t){const o=(t=this.options=function(e,t){for(const o in t)e[o]=t[o];return e}(Object.create(he),t)).debug;if(o&&console.time("preprocess data"),t.maxZoom<0||t.maxZoom>24)throw new Error("maxZoom should be in the 0-24 range");if(t.promoteId&&t.generateId)throw new Error("promoteId and generateId cannot be used together.");let i=function(e,t){const o=[];if("FeatureCollection"===e.type)for(let i=0;i<e.features.length;i++)Y(o,e.features[i],t,i);else Y(o,"Feature"===e.type?e:{geometry:e},t);return o}(e,t);this.tiles={},this.tileCoords=[],o&&(console.timeEnd("preprocess data"),console.log("index: maxZoom: %d, maxPoints: %d",t.indexMaxZoom,t.indexMaxPoints),console.time("generate tiles"),this.stats={},this.total=0),i=function(e,t){const o=t.buffer/t.extent;let i=e;const s=U(e,1,-1-o,o,0,-1,2,t),r=U(e,1,1-o,2+o,0,-1,2,t);return (s||r)&&(i=U(e,1,-o,1+o,0,-1,2,t)||[],s&&(i=se(s,1).concat(i)),r&&(i=i.concat(se(r,-1)))),i}(i,t),i.length&&this.splitTile(i,0,0,0),o&&(i.length&&console.log("features: %d, points: %d",this.tiles[0].numFeatures,this.tiles[0].numPoints),console.timeEnd("generate tiles"),console.log("tiles generated:",this.total,JSON.stringify(this.stats)));}splitTile(e,t,o,i,s,r,n){const a=[e,t,o,i],l=this.options,c=l.debug;for(;a.length;){i=a.pop(),o=a.pop(),t=a.pop(),e=a.pop();const u=1<<t,h=fe(t,o,i);let d=this.tiles[h];if(!d&&(c>1&&console.time("creation"),d=this.tiles[h]=le(e,t,o,i,l),this.tileCoords.push({z:t,x:o,y:i}),c)){c>1&&(console.log("tile z%d-%d-%d (features: %d, points: %d, simplified: %d)",t,o,i,d.numFeatures,d.numPoints,d.numSimplified),console.timeEnd("creation"));const e=`z${t}`;this.stats[e]=(this.stats[e]||0)+1,this.total++;}if(d.source=e,null==s){if(t===l.indexMaxZoom||d.numPoints<=l.indexMaxPoints)continue}else {if(t===l.maxZoom||t===s)continue;if(null!=s){const e=s-t;if(o!==r>>e||i!==n>>e)continue}}if(d.source=null,0===e.length)continue;c>1&&console.time("clipping");const f=.5*l.buffer/l.extent,g=.5-f,p=.5+f,m=1+f;let y=null,v=null,w=null,x=null,b=U(e,u,o-f,o+p,0,d.minX,d.maxX,l),S=U(e,u,o+g,o+m,0,d.minX,d.maxX,l);e=null,b&&(y=U(b,u,i-f,i+p,1,d.minY,d.maxY,l),v=U(b,u,i+g,i+m,1,d.minY,d.maxY,l),b=null),S&&(w=U(S,u,i-f,i+p,1,d.minY,d.maxY,l),x=U(S,u,i+g,i+m,1,d.minY,d.maxY,l),S=null),c>1&&console.timeEnd("clipping"),a.push(y||[],t+1,2*o,2*i),a.push(v||[],t+1,2*o,2*i+1),a.push(w||[],t+1,2*o+1,2*i),a.push(x||[],t+1,2*o+1,2*i+1);}}getTile(e,t,o){e=+e,t=+t,o=+o;const i=this.options,{extent:s,debug:r}=i;if(e<0||e>24)return null;const n=1<<e,a=fe(e,t=t+n&n-1,o);if(this.tiles[a])return ne(this.tiles[a],s);r>1&&console.log("drilling down to z%d-%d-%d",e,t,o);let l,c=e,u=t,h=o;for(;!l&&c>0;)c--,u>>=1,h>>=1,l=this.tiles[fe(c,u,h)];return l&&l.source?(r>1&&(console.log("found parent tile z%d-%d-%d",c,u,h),console.time("drilling down")),this.splitTile(l.source,c,u,h,e,t,o),r>1&&console.timeEnd("drilling down"),this.tiles[a]?ne(this.tiles[a],s):null):null}}function fe(e,t,o){return 32*((1<<e)*o+t)+e}function ge(e,t){return t?e.properties[t]:e.id}function pe(e,t){if(null==e)return !0;if("Feature"===e.type)return null!=ge(e,t);if("FeatureCollection"===e.type){const o=new Set;for(const i of e.features){const e=ge(i,t);if(null==e)return !1;if(o.has(e))return !1;o.add(e);}return !0}return !1}function me(e,t){const o=new Map;if(null==e);else if("Feature"===e.type)o.set(ge(e,t),e);else for(const i of e.features)o.set(ge(i,t),i);return o}class ye extends r{constructor(){super(...arguments),this._dataUpdateable=new Map;}loadVectorTile(t,o){return e._(this,void 0,void 0,(function*(){const o=t.tileID.canonical;if(!this._geoJSONIndex)throw new Error("Unable to parse the data into a cluster or geojson");const i=this._geoJSONIndex.getTile(o.z,o.x,o.y);if(!i)return null;const s=new class{constructor(t){this.layers={_geojsonTileLayer:this},this.name="_geojsonTileLayer",this.extent=e.X,this.length=t.length,this._features=t;}feature(t){return new class{constructor(t){this._feature=t,this.extent=e.X,this.type=t.type,this.properties=t.tags,"id"in t&&!isNaN(t.id)&&(this.id=parseInt(t.id,10));}loadGeometry(){if(1===this._feature.type){const t=[];for(const o of this._feature.geometry)t.push([new e.P(o[0],o[1])]);return t}{const t=[];for(const o of this._feature.geometry){const i=[];for(const t of o)i.push(new e.P(t[0],t[1]));t.push(i);}return t}}toGeoJSON(e,t,o){return u.call(this,e,t,o)}}(this._features[t])}}(i.features);let r=k(s);return 0===r.byteOffset&&r.byteLength===r.buffer.byteLength||(r=new Uint8Array(r)),{vectorTile:s,rawData:r.buffer}}))}loadData(t){return e._(this,void 0,void 0,(function*(){var o;null===(o=this._pendingRequest)||void 0===o||o.abort();const i=!!(t&&t.request&&t.request.collectResourceTiming)&&new e.bu(t.request);this._pendingRequest=new AbortController;try{this._pendingData=this.loadAndProcessGeoJSON(t,this._pendingRequest),this._geoJSONIndex=t.cluster?new z(function({superclusterOptions:t,clusterProperties:o}){if(!o||!t)return t;const i={},s={},r={accumulated:null,zoom:0},n={properties:null},a=Object.keys(o);for(const t of a){const[r,n]=o[t],a=e.bB(n),l=e.bB("string"==typeof r?[r,["accumulated"],["get",t]]:r);i[t]=a.value,s[t]=l.value;}return t.map=e=>{n.properties=e;const t={};for(const e of a)t[e]=i[e].evaluate(r,n);return t},t.reduce=(e,t)=>{n.properties=t;for(const t of a)r.accumulated=e[t],e[t]=s[t].evaluate(r,n);},t}(t)).load((yield this._pendingData).features):(s=yield this._pendingData,new de(s,t.geojsonVtOptions)),this.loaded={};const o={};if(i){const e=i.finish();e&&(o.resourceTiming={},o.resourceTiming[t.source]=JSON.parse(JSON.stringify(e)));}return o}catch(t){if(delete this._pendingRequest,e.bA(t))return {abandoned:!0};throw t}var s;}))}getData(){return e._(this,void 0,void 0,(function*(){return this._pendingData}))}reloadTile(e){const t=this.loaded;return t&&t[e.uid]?super.reloadTile(e):this.loadTile(e)}loadAndProcessGeoJSON(t,o){return e._(this,void 0,void 0,(function*(){let i=yield this.loadGeoJSON(t,o);if(delete this._pendingRequest,"object"!=typeof i)throw new Error(`Input data given to '${t.source}' is not a valid GeoJSON object.`);if(c(i,!0),t.filter){const o=e.bB(t.filter,{type:"boolean","property-type":"data-driven",overridable:!1,transition:!1});if("error"===o.result)throw new Error(o.value.map((e=>`${e.key}: ${e.message}`)).join(", "));const s=i.features.filter((e=>o.value.evaluate({zoom:0},e)));i={type:"FeatureCollection",features:s};}return i}))}loadGeoJSON(t,o){return e._(this,void 0,void 0,(function*(){const{promoteId:i}=t;if(t.request){const s=yield e.h(t.request,o);return this._dataUpdateable=pe(s.data,i)?me(s.data,i):void 0,s.data}if("string"==typeof t.data)try{const e=JSON.parse(t.data);return this._dataUpdateable=pe(e,i)?me(e,i):void 0,e}catch(e){throw new Error(`Input data given to '${t.source}' is not a valid GeoJSON object.`)}if(!t.dataDiff)throw new Error(`Input data given to '${t.source}' is not a valid GeoJSON object.`);if(!this._dataUpdateable)throw new Error(`Cannot update existing geojson data in ${t.source}`);return function(e,t,o){var i,s,r,n;if(t.removeAll&&e.clear(),t.remove)for(const o of t.remove)e.delete(o);if(t.add)for(const i of t.add){const t=ge(i,o);null!=t&&e.set(t,i);}if(t.update)for(const o of t.update){let t=e.get(o.id);if(null==t)continue;const a=!o.removeAllProperties&&((null===(i=o.removeProperties)||void 0===i?void 0:i.length)>0||(null===(s=o.addOrUpdateProperties)||void 0===s?void 0:s.length)>0);if((o.newGeometry||o.removeAllProperties||a)&&(t=Object.assign({},t),e.set(o.id,t),a&&(t.properties=Object.assign({},t.properties))),o.newGeometry&&(t.geometry=o.newGeometry),o.removeAllProperties)t.properties={};else if((null===(r=o.removeProperties)||void 0===r?void 0:r.length)>0)for(const e of o.removeProperties)Object.prototype.hasOwnProperty.call(t.properties,e)&&delete t.properties[e];if((null===(n=o.addOrUpdateProperties)||void 0===n?void 0:n.length)>0)for(const{key:e,value:i}of o.addOrUpdateProperties)t.properties[e]=i;}}(this._dataUpdateable,t.dataDiff,i),{type:"FeatureCollection",features:Array.from(this._dataUpdateable.values())}}))}removeSource(t){return e._(this,void 0,void 0,(function*(){this._pendingRequest&&this._pendingRequest.abort();}))}getClusterExpansionZoom(e){return this._geoJSONIndex.getClusterExpansionZoom(e.clusterId)}getClusterChildren(e){return this._geoJSONIndex.getChildren(e.clusterId)}getClusterLeaves(e){return this._geoJSONIndex.getLeaves(e.clusterId,e.limit,e.offset)}}class ve{constructor(t){this.self=t,this.actor=new e.F(t),this.layerIndexes={},this.availableImages={},this.workerSources={},this.demWorkerSources={},this.externalWorkerSourceTypes={},this.self.registerWorkerSource=(e,t)=>{if(this.externalWorkerSourceTypes[e])throw new Error(`Worker source with name "${e}" already registered.`);this.externalWorkerSourceTypes[e]=t;},this.self.addProtocol=e.bh,this.self.removeProtocol=e.bi,this.self.registerRTLTextPlugin=t=>{if(e.bC.isParsed())throw new Error("RTL text plugin already registered.");e.bC.setMethods(t);},this.actor.registerMessageHandler("LDT",((e,t)=>this._getDEMWorkerSource(e,t.source).loadTile(t))),this.actor.registerMessageHandler("RDT",((t,o)=>e._(this,void 0,void 0,(function*(){this._getDEMWorkerSource(t,o.source).removeTile(o);})))),this.actor.registerMessageHandler("GCEZ",((t,o)=>e._(this,void 0,void 0,(function*(){return this._getWorkerSource(t,o.type,o.source).getClusterExpansionZoom(o)})))),this.actor.registerMessageHandler("GCC",((t,o)=>e._(this,void 0,void 0,(function*(){return this._getWorkerSource(t,o.type,o.source).getClusterChildren(o)})))),this.actor.registerMessageHandler("GCL",((t,o)=>e._(this,void 0,void 0,(function*(){return this._getWorkerSource(t,o.type,o.source).getClusterLeaves(o)})))),this.actor.registerMessageHandler("LD",((e,t)=>this._getWorkerSource(e,t.type,t.source).loadData(t))),this.actor.registerMessageHandler("GD",((e,t)=>this._getWorkerSource(e,t.type,t.source).getData())),this.actor.registerMessageHandler("LT",((e,t)=>this._getWorkerSource(e,t.type,t.source).loadTile(t))),this.actor.registerMessageHandler("RT",((e,t)=>this._getWorkerSource(e,t.type,t.source).reloadTile(t))),this.actor.registerMessageHandler("AT",((e,t)=>this._getWorkerSource(e,t.type,t.source).abortTile(t))),this.actor.registerMessageHandler("RMT",((e,t)=>this._getWorkerSource(e,t.type,t.source).removeTile(t))),this.actor.registerMessageHandler("RS",((t,o)=>e._(this,void 0,void 0,(function*(){if(!this.workerSources[t]||!this.workerSources[t][o.type]||!this.workerSources[t][o.type][o.source])return;const e=this.workerSources[t][o.type][o.source];delete this.workerSources[t][o.type][o.source],void 0!==e.removeSource&&e.removeSource(o);})))),this.actor.registerMessageHandler("RM",(t=>e._(this,void 0,void 0,(function*(){delete this.layerIndexes[t],delete this.availableImages[t],delete this.workerSources[t],delete this.demWorkerSources[t];})))),this.actor.registerMessageHandler("SR",((t,o)=>e._(this,void 0,void 0,(function*(){this.referrer=o;})))),this.actor.registerMessageHandler("SRPS",((e,t)=>this._syncRTLPluginState(e,t))),this.actor.registerMessageHandler("IS",((t,o)=>e._(this,void 0,void 0,(function*(){this.self.importScripts(o);})))),this.actor.registerMessageHandler("SI",((e,t)=>this._setImages(e,t))),this.actor.registerMessageHandler("UL",((t,o)=>e._(this,void 0,void 0,(function*(){this._getLayerIndex(t).update(o.layers,o.removedIds);})))),this.actor.registerMessageHandler("SL",((t,o)=>e._(this,void 0,void 0,(function*(){this._getLayerIndex(t).replace(o);}))));}_setImages(t,o){return e._(this,void 0,void 0,(function*(){this.availableImages[t]=o;for(const e in this.workerSources[t]){const i=this.workerSources[t][e];for(const e in i)i[e].availableImages=o;}}))}_syncRTLPluginState(t,o){return e._(this,void 0,void 0,(function*(){if(e.bC.isParsed())return e.bC.getState();if("loading"!==o.pluginStatus)return e.bC.setState(o),o;const t=o.pluginURL;if(this.self.importScripts(t),e.bC.isParsed()){const o={pluginStatus:"loaded",pluginURL:t};return e.bC.setState(o),o}throw e.bC.setState({pluginStatus:"error",pluginURL:""}),new Error(`RTL Text Plugin failed to import scripts from ${t}`)}))}_getAvailableImages(e){let t=this.availableImages[e];return t||(t=[]),t}_getLayerIndex(e){let o=this.layerIndexes[e];return o||(o=this.layerIndexes[e]=new t),o}_getWorkerSource(e,t,o){if(this.workerSources[e]||(this.workerSources[e]={}),this.workerSources[e][t]||(this.workerSources[e][t]={}),!this.workerSources[e][t][o]){const i={sendAsync:(t,o)=>(t.targetMapId=e,this.actor.sendAsync(t,o))};switch(t){case"vector":this.workerSources[e][t][o]=new r(i,this._getLayerIndex(e),this._getAvailableImages(e));break;case"geojson":this.workerSources[e][t][o]=new ye(i,this._getLayerIndex(e),this._getAvailableImages(e));break;default:this.workerSources[e][t][o]=new this.externalWorkerSourceTypes[t](i,this._getLayerIndex(e),this._getAvailableImages(e));}}return this.workerSources[e][t][o]}_getDEMWorkerSource(e,t){return this.demWorkerSources[e]||(this.demWorkerSources[e]={}),this.demWorkerSources[e][t]||(this.demWorkerSources[e][t]=new n),this.demWorkerSources[e][t]}}return e.i(self)&&(self.worker=new ve(self)),ve}));

define("index",["exports","./shared"],(function(t,e){"use strict";var i="4.6.0";let a,s;const o={now:"undefined"!=typeof performance&&performance&&performance.now?performance.now.bind(performance):Date.now.bind(Date),frameAsync:t=>new Promise(((i,a)=>{const s=requestAnimationFrame(i);t.signal.addEventListener("abort",(()=>{cancelAnimationFrame(s),a(e.c());}));})),getImageData(t,e=0){return this.getImageCanvasContext(t).getImageData(-e,-e,t.width+2*e,t.height+2*e)},getImageCanvasContext(t){const e=window.document.createElement("canvas"),i=e.getContext("2d",{willReadFrequently:!0});if(!i)throw new Error("failed to create canvas 2d context");return e.width=t.width,e.height=t.height,i.drawImage(t,0,0,t.width,t.height),i},resolveURL:t=>(a||(a=document.createElement("a")),a.href=t,a.href),hardwareConcurrency:"undefined"!=typeof navigator&&navigator.hardwareConcurrency||4,get prefersReducedMotion(){return !!matchMedia&&(null==s&&(s=matchMedia("(prefers-reduced-motion: reduce)")),s.matches)}};class r{static testProp(t){if(!r.docStyle)return t[0];for(let e=0;e<t.length;e++)if(t[e]in r.docStyle)return t[e];return t[0]}static create(t,e,i){const a=window.document.createElement(t);return void 0!==e&&(a.className=e),i&&i.appendChild(a),a}static createNS(t,e){return window.document.createElementNS(t,e)}static disableDrag(){r.docStyle&&r.selectProp&&(r.userSelect=r.docStyle[r.selectProp],r.docStyle[r.selectProp]="none");}static enableDrag(){r.docStyle&&r.selectProp&&(r.docStyle[r.selectProp]=r.userSelect);}static setTransform(t,e){t.style[r.transformProp]=e;}static addEventListener(t,e,i,a={}){t.addEventListener(e,i,"passive"in a?a:a.capture);}static removeEventListener(t,e,i,a={}){t.removeEventListener(e,i,"passive"in a?a:a.capture);}static suppressClickInternal(t){t.preventDefault(),t.stopPropagation(),window.removeEventListener("click",r.suppressClickInternal,!0);}static suppressClick(){window.addEventListener("click",r.suppressClickInternal,!0),window.setTimeout((()=>{window.removeEventListener("click",r.suppressClickInternal,!0);}),0);}static getScale(t){const e=t.getBoundingClientRect();return {x:e.width/t.offsetWidth||1,y:e.height/t.offsetHeight||1,boundingClientRect:e}}static getPoint(t,i,a){const s=i.boundingClientRect;return new e.P((a.clientX-s.left)/i.x-t.clientLeft,(a.clientY-s.top)/i.y-t.clientTop)}static mousePos(t,e){const i=r.getScale(t);return r.getPoint(t,i,e)}static touchPos(t,e){const i=[],a=r.getScale(t);for(let s=0;s<e.length;s++)i.push(r.getPoint(t,a,e[s]));return i}static mouseButton(t){return t.button}static remove(t){t.parentNode&&t.parentNode.removeChild(t);}}r.docStyle="undefined"!=typeof window&&window.document&&window.document.documentElement.style,r.selectProp=r.testProp(["userSelect","MozUserSelect","WebkitUserSelect","msUserSelect"]),r.transformProp=r.testProp(["transform","WebkitTransform"]);const n={supported:!1,testSupport:function(t){!c&&h&&(u?d(t):l=t);}};let l,h,c=!1,u=!1;function d(t){const e=t.createTexture();t.bindTexture(t.TEXTURE_2D,e);try{if(t.texImage2D(t.TEXTURE_2D,0,t.RGBA,t.RGBA,t.UNSIGNED_BYTE,h),t.isContextLost())return;n.supported=!0;}catch(t){}t.deleteTexture(e),c=!0;}var _;"undefined"!=typeof document&&(h=document.createElement("img"),h.onload=()=>{l&&d(l),l=null,u=!0;},h.onerror=()=>{c=!0,l=null;},h.src="data:image/webp;base64,UklGRh4AAABXRUJQVlA4TBEAAAAvAQAAAAfQ//73v/+BiOh/AAA="),function(t){let i,a,s,o;t.resetRequestQueue=()=>{i=[],a=0,s=0,o={};},t.addThrottleControl=t=>{const e=s++;return o[e]=t,e},t.removeThrottleControl=t=>{delete o[t],l();},t.getImage=(t,a,s=!0)=>new Promise(((o,r)=>{n.supported&&(t.headers||(t.headers={}),t.headers.accept="image/webp,*/*"),e.e(t,{type:"image"}),i.push({abortController:a,requestParameters:t,supportImageRefresh:s,state:"queued",onError:t=>{r(t);},onSuccess:t=>{o(t);}}),l();}));const r=t=>e._(this,void 0,void 0,(function*(){t.state="running";const{requestParameters:i,supportImageRefresh:s,onError:o,onSuccess:r,abortController:n}=t,c=!1===s&&!e.i(self)&&!e.g(i.url)&&(!i.headers||Object.keys(i.headers).reduce(((t,e)=>t&&"accept"===e),!0));a++;const u=c?h(i,n):e.m(i,n);try{const i=yield u;delete t.abortController,t.state="completed",i.data instanceof HTMLImageElement||e.b(i.data)?r(i):i.data&&r({data:yield(d=i.data,"function"==typeof createImageBitmap?e.d(d):e.f(d)),cacheControl:i.cacheControl,expires:i.expires});}catch(e){delete t.abortController,o(e);}finally{a--,l();}var d;})),l=()=>{const t=(()=>{for(const t of Object.keys(o))if(o[t]())return !0;return !1})()?e.a.MAX_PARALLEL_IMAGE_REQUESTS_PER_FRAME:e.a.MAX_PARALLEL_IMAGE_REQUESTS;for(let e=a;e<t&&i.length>0;e++){const t=i.shift();t.abortController.signal.aborted?e--:r(t);}},h=(t,i)=>new Promise(((a,s)=>{const o=new Image,r=t.url,n=t.credentials;n&&"include"===n?o.crossOrigin="use-credentials":(n&&"same-origin"===n||!e.s(r))&&(o.crossOrigin="anonymous"),i.signal.addEventListener("abort",(()=>{o.src="",s(e.c());})),o.fetchPriority="high",o.onload=()=>{o.onerror=o.onload=null,a({data:o});},o.onerror=()=>{o.onerror=o.onload=null,i.signal.aborted||s(new Error("Could not load image. Please make sure to use a supported image type such as PNG or JPEG. Note that SVGs are not supported."));},o.src=r;}));}(_||(_={})),_.resetRequestQueue();class p{constructor(t){this._transformRequestFn=t;}transformRequest(t,e){return this._transformRequestFn&&this._transformRequestFn(t,e)||{url:t}}setTransformRequest(t){this._transformRequestFn=t;}}function m(t){var i=new e.A(3);return i[0]=t[0],i[1]=t[1],i[2]=t[2],i}var f,g=function(t,e,i){return t[0]=e[0]-i[0],t[1]=e[1]-i[1],t[2]=e[2]-i[2],t};f=new e.A(3),e.A!=Float32Array&&(f[0]=0,f[1]=0,f[2]=0);var v=function(t){var e=t[0],i=t[1];return e*e+i*i};function x(t){const e=[];if("string"==typeof t)e.push({id:"default",url:t});else if(t&&t.length>0){const i=[];for(const{id:a,url:s}of t){const t=`${a}${s}`;-1===i.indexOf(t)&&(i.push(t),e.push({id:a,url:s}));}}return e}function y(t,e,i){const a=t.split("?");return a[0]+=`${e}${i}`,a.join("?")}!function(){var t=new e.A(2);e.A!=Float32Array&&(t[0]=0,t[1]=0);}();class b{constructor(t,e,i,a){this.context=t,this.format=i,this.texture=t.gl.createTexture(),this.update(e,a);}update(t,i,a){const{width:s,height:o}=t,r=!(this.size&&this.size[0]===s&&this.size[1]===o||a),{context:n}=this,{gl:l}=n;if(this.useMipmap=Boolean(i&&i.useMipmap),l.bindTexture(l.TEXTURE_2D,this.texture),n.pixelStoreUnpackFlipY.set(!1),n.pixelStoreUnpack.set(1),n.pixelStoreUnpackPremultiplyAlpha.set(this.format===l.RGBA&&(!i||!1!==i.premultiply)),r)this.size=[s,o],t instanceof HTMLImageElement||t instanceof HTMLCanvasElement||t instanceof HTMLVideoElement||t instanceof ImageData||e.b(t)?l.texImage2D(l.TEXTURE_2D,0,this.format,this.format,l.UNSIGNED_BYTE,t):l.texImage2D(l.TEXTURE_2D,0,this.format,s,o,0,this.format,l.UNSIGNED_BYTE,t.data);else {const{x:i,y:r}=a||{x:0,y:0};t instanceof HTMLImageElement||t instanceof HTMLCanvasElement||t instanceof HTMLVideoElement||t instanceof ImageData||e.b(t)?l.texSubImage2D(l.TEXTURE_2D,0,i,r,l.RGBA,l.UNSIGNED_BYTE,t):l.texSubImage2D(l.TEXTURE_2D,0,i,r,s,o,l.RGBA,l.UNSIGNED_BYTE,t.data);}this.useMipmap&&this.isSizePowerOfTwo()&&l.generateMipmap(l.TEXTURE_2D);}bind(t,e,i){const{context:a}=this,{gl:s}=a;s.bindTexture(s.TEXTURE_2D,this.texture),i!==s.LINEAR_MIPMAP_NEAREST||this.isSizePowerOfTwo()||(i=s.LINEAR),t!==this.filter&&(s.texParameteri(s.TEXTURE_2D,s.TEXTURE_MAG_FILTER,t),s.texParameteri(s.TEXTURE_2D,s.TEXTURE_MIN_FILTER,i||t),this.filter=t),e!==this.wrap&&(s.texParameteri(s.TEXTURE_2D,s.TEXTURE_WRAP_S,e),s.texParameteri(s.TEXTURE_2D,s.TEXTURE_WRAP_T,e),this.wrap=e);}isSizePowerOfTwo(){return this.size[0]===this.size[1]&&Math.log(this.size[0])/Math.LN2%1==0}destroy(){const{gl:t}=this.context;t.deleteTexture(this.texture),this.texture=null;}}function w(t){const{userImage:e}=t;return !!(e&&e.render&&e.render())&&(t.data.replace(new Uint8Array(e.data.buffer)),!0)}class T extends e.E{constructor(){super(),this.images={},this.updatedImages={},this.callbackDispatchedThisFrame={},this.loaded=!1,this.requestors=[],this.patterns={},this.atlasImage=new e.R({width:1,height:1}),this.dirty=!0;}isLoaded(){return this.loaded}setLoaded(t){if(this.loaded!==t&&(this.loaded=t,t)){for(const{ids:t,promiseResolve:e}of this.requestors)e(this._getImagesForIds(t));this.requestors=[];}}getImage(t){const i=this.images[t];if(i&&!i.data&&i.spriteData){const t=i.spriteData;i.data=new e.R({width:t.width,height:t.height},t.context.getImageData(t.x,t.y,t.width,t.height).data),i.spriteData=null;}return i}addImage(t,e){if(this.images[t])throw new Error(`Image id ${t} already exist, use updateImage instead`);this._validate(t,e)&&(this.images[t]=e);}_validate(t,i){let a=!0;const s=i.data||i.spriteData;return this._validateStretch(i.stretchX,s&&s.width)||(this.fire(new e.j(new Error(`Image "${t}" has invalid "stretchX" value`))),a=!1),this._validateStretch(i.stretchY,s&&s.height)||(this.fire(new e.j(new Error(`Image "${t}" has invalid "stretchY" value`))),a=!1),this._validateContent(i.content,i)||(this.fire(new e.j(new Error(`Image "${t}" has invalid "content" value`))),a=!1),a}_validateStretch(t,e){if(!t)return !0;let i=0;for(const a of t){if(a[0]<i||a[1]<a[0]||e<a[1])return !1;i=a[1];}return !0}_validateContent(t,e){if(!t)return !0;if(4!==t.length)return !1;const i=e.spriteData,a=i&&i.width||e.data.width,s=i&&i.height||e.data.height;return !(t[0]<0||a<t[0]||t[1]<0||s<t[1]||t[2]<0||a<t[2]||t[3]<0||s<t[3]||t[2]<t[0]||t[3]<t[1])}updateImage(t,e,i=!0){const a=this.getImage(t);if(i&&(a.data.width!==e.data.width||a.data.height!==e.data.height))throw new Error(`size mismatch between old image (${a.data.width}x${a.data.height}) and new image (${e.data.width}x${e.data.height}).`);e.version=a.version+1,this.images[t]=e,this.updatedImages[t]=!0;}removeImage(t){const e=this.images[t];delete this.images[t],delete this.patterns[t],e.userImage&&e.userImage.onRemove&&e.userImage.onRemove();}listImages(){return Object.keys(this.images)}getImages(t){return new Promise(((e,i)=>{let a=!0;if(!this.isLoaded())for(const e of t)this.images[e]||(a=!1);this.isLoaded()||a?e(this._getImagesForIds(t)):this.requestors.push({ids:t,promiseResolve:e});}))}_getImagesForIds(t){const i={};for(const a of t){let t=this.getImage(a);t||(this.fire(new e.k("styleimagemissing",{id:a})),t=this.getImage(a)),t?i[a]={data:t.data.clone(),pixelRatio:t.pixelRatio,sdf:t.sdf,version:t.version,stretchX:t.stretchX,stretchY:t.stretchY,content:t.content,textFitWidth:t.textFitWidth,textFitHeight:t.textFitHeight,hasRenderCallback:Boolean(t.userImage&&t.userImage.render)}:e.w(`Image "${a}" could not be loaded. Please make sure you have added the image with map.addImage() or a "sprite" property in your style. You can provide missing images by listening for the "styleimagemissing" map event.`);}return i}getPixelSize(){const{width:t,height:e}=this.atlasImage;return {width:t,height:e}}getPattern(t){const i=this.patterns[t],a=this.getImage(t);if(!a)return null;if(i&&i.position.version===a.version)return i.position;if(i)i.position.version=a.version;else {const i={w:a.data.width+2,h:a.data.height+2,x:0,y:0},s=new e.I(i,a);this.patterns[t]={bin:i,position:s};}return this._updatePatternAtlas(),this.patterns[t].position}bind(t){const e=t.gl;this.atlasTexture?this.dirty&&(this.atlasTexture.update(this.atlasImage),this.dirty=!1):this.atlasTexture=new b(t,this.atlasImage,e.RGBA),this.atlasTexture.bind(e.LINEAR,e.CLAMP_TO_EDGE);}_updatePatternAtlas(){const t=[];for(const e in this.patterns)t.push(this.patterns[e].bin);const{w:i,h:a}=e.p(t),s=this.atlasImage;s.resize({width:i||1,height:a||1});for(const t in this.patterns){const{bin:i}=this.patterns[t],a=i.x+1,o=i.y+1,r=this.getImage(t).data,n=r.width,l=r.height;e.R.copy(r,s,{x:0,y:0},{x:a,y:o},{width:n,height:l}),e.R.copy(r,s,{x:0,y:l-1},{x:a,y:o-1},{width:n,height:1}),e.R.copy(r,s,{x:0,y:0},{x:a,y:o+l},{width:n,height:1}),e.R.copy(r,s,{x:n-1,y:0},{x:a-1,y:o},{width:1,height:l}),e.R.copy(r,s,{x:0,y:0},{x:a+n,y:o},{width:1,height:l});}this.dirty=!0;}beginFrame(){this.callbackDispatchedThisFrame={};}dispatchRenderCallbacks(t){for(const i of t){if(this.callbackDispatchedThisFrame[i])continue;this.callbackDispatchedThisFrame[i]=!0;const t=this.getImage(i);t||e.w(`Image with ID: "${i}" was not found`),w(t)&&this.updateImage(i,t);}}}const I=1e20;function E(t,e,i,a,s,o,r,n,l){for(let h=e;h<e+a;h++)P(t,i*o+h,o,s,r,n,l);for(let h=i;h<i+s;h++)P(t,h*o+e,1,a,r,n,l);}function P(t,e,i,a,s,o,r){o[0]=0,r[0]=-I,r[1]=I,s[0]=t[e];for(let n=1,l=0,h=0;n<a;n++){s[n]=t[e+n*i];const a=n*n;do{const t=o[l];h=(s[n]-s[t]+a-t*t)/(n-t)/2;}while(h<=r[l]&&--l>-1);l++,o[l]=n,r[l]=h,r[l+1]=I;}for(let n=0,l=0;n<a;n++){for(;r[l+1]<n;)l++;const a=o[l],h=n-a;t[e+n*i]=s[a]+h*h;}}class C{constructor(t,e){this.requestManager=t,this.localIdeographFontFamily=e,this.entries={};}setURL(t){this.url=t;}getGlyphs(t){return e._(this,void 0,void 0,(function*(){const e=[];for(const i in t)for(const a of t[i])e.push(this._getAndCacheGlyphsPromise(i,a));const i=yield Promise.all(e),a={};for(const{stack:t,id:e,glyph:s}of i)a[t]||(a[t]={}),a[t][e]=s&&{id:s.id,bitmap:s.bitmap.clone(),metrics:s.metrics};return a}))}_getAndCacheGlyphsPromise(t,i){return e._(this,void 0,void 0,(function*(){let e=this.entries[t];e||(e=this.entries[t]={glyphs:{},requests:{},ranges:{}});let a=e.glyphs[i];if(void 0!==a)return {stack:t,id:i,glyph:a};if(a=this._tinySDF(e,t,i),a)return e.glyphs[i]=a,{stack:t,id:i,glyph:a};const s=Math.floor(i/256);if(256*s>65535)throw new Error("glyphs > 65535 not supported");if(e.ranges[s])return {stack:t,id:i,glyph:a};if(!this.url)throw new Error("glyphsUrl is not set");if(!e.requests[s]){const i=C.loadGlyphRange(t,s,this.url,this.requestManager);e.requests[s]=i;}const o=yield e.requests[s];for(const t in o)this._doesCharSupportLocalGlyph(+t)||(e.glyphs[+t]=o[+t]);return e.ranges[s]=!0,{stack:t,id:i,glyph:o[i]||null}}))}_doesCharSupportLocalGlyph(t){return !!this.localIdeographFontFamily&&/\p{Ideo}|\p{sc=Hang}|\p{sc=Hira}|\p{sc=Kana}/u.test(String.fromCodePoint(t))}_tinySDF(t,i,a){const s=this.localIdeographFontFamily;if(!s)return;if(!this._doesCharSupportLocalGlyph(a))return;let o=t.tinySDF;if(!o){let e="400";/bold/i.test(i)?e="900":/medium/i.test(i)?e="500":/light/i.test(i)&&(e="200"),o=t.tinySDF=new C.TinySDF({fontSize:48,buffer:6,radius:16,cutoff:.25,fontFamily:s,fontWeight:e});}const r=o.draw(String.fromCharCode(a));return {id:a,bitmap:new e.o({width:r.width||60,height:r.height||60},r.data),metrics:{width:r.glyphWidth/2||24,height:r.glyphHeight/2||24,left:r.glyphLeft/2+.5||0,top:r.glyphTop/2-27.5||-8,advance:r.glyphAdvance/2||24,isDoubleResolution:!0}}}}C.loadGlyphRange=function(t,i,a,s){return e._(this,void 0,void 0,(function*(){const o=256*i,r=o+255,n=s.transformRequest(a.replace("{fontstack}",t).replace("{range}",`${o}-${r}`),"Glyphs"),l=yield e.l(n,new AbortController);if(!l||!l.data)throw new Error(`Could not load glyph range. range: ${i}, ${o}-${r}`);const h={};for(const t of e.n(l.data))h[t.id]=t;return h}))},C.TinySDF=class{constructor({fontSize:t=24,buffer:e=3,radius:i=8,cutoff:a=.25,fontFamily:s="sans-serif",fontWeight:o="normal",fontStyle:r="normal"}={}){this.buffer=e,this.cutoff=a,this.radius=i;const n=this.size=t+4*e,l=this._createCanvas(n),h=this.ctx=l.getContext("2d",{willReadFrequently:!0});h.font=`${r} ${o} ${t}px ${s}`,h.textBaseline="alphabetic",h.textAlign="left",h.fillStyle="black",this.gridOuter=new Float64Array(n*n),this.gridInner=new Float64Array(n*n),this.f=new Float64Array(n),this.z=new Float64Array(n+1),this.v=new Uint16Array(n);}_createCanvas(t){const e=document.createElement("canvas");return e.width=e.height=t,e}draw(t){const{width:e,actualBoundingBoxAscent:i,actualBoundingBoxDescent:a,actualBoundingBoxLeft:s,actualBoundingBoxRight:o}=this.ctx.measureText(t),r=Math.ceil(i),n=Math.max(0,Math.min(this.size-this.buffer,Math.ceil(o-s))),l=Math.min(this.size-this.buffer,r+Math.ceil(a)),h=n+2*this.buffer,c=l+2*this.buffer,u=Math.max(h*c,0),d=new Uint8ClampedArray(u),_={data:d,width:h,height:c,glyphWidth:n,glyphHeight:l,glyphTop:r,glyphLeft:0,glyphAdvance:e};if(0===n||0===l)return _;const{ctx:p,buffer:m,gridInner:f,gridOuter:g}=this;p.clearRect(m,m,n,l),p.fillText(t,m,m+r);const v=p.getImageData(m,m,n,l);g.fill(I,0,u),f.fill(0,0,u);for(let t=0;t<l;t++)for(let e=0;e<n;e++){const i=v.data[4*(t*n+e)+3]/255;if(0===i)continue;const a=(t+m)*h+e+m;if(1===i)g[a]=0,f[a]=I;else {const t=.5-i;g[a]=t>0?t*t:0,f[a]=t<0?t*t:0;}}E(g,0,0,h,c,h,this.f,this.v,this.z),E(f,m,m,n,l,h,this.f,this.v,this.z);for(let t=0;t<u;t++){const e=Math.sqrt(g[t])-Math.sqrt(f[t]);d[t]=Math.round(255-255*(e/this.radius+this.cutoff));}return _}};class S{constructor(){this.specification=e.v.light.position;}possiblyEvaluate(t,i){return e.x(t.expression.evaluate(i))}interpolate(t,i,a){return {x:e.y.number(t.x,i.x,a),y:e.y.number(t.y,i.y,a),z:e.y.number(t.z,i.z,a)}}}let z;class D extends e.E{constructor(t){super(),z=z||new e.q({anchor:new e.D(e.v.light.anchor),position:new S,color:new e.D(e.v.light.color),intensity:new e.D(e.v.light.intensity)}),this._transitionable=new e.T(z),this.setLight(t),this._transitioning=this._transitionable.untransitioned();}getLight(){return this._transitionable.serialize()}setLight(t,i={}){if(!this._validate(e.r,t,i))for(const e in t){const i=t[e];e.endsWith("-transition")?this._transitionable.setTransition(e.slice(0,-11),i):this._transitionable.setValue(e,i);}}updateTransitions(t){this._transitioning=this._transitionable.transitioned(t,this._transitioning);}hasTransition(){return this._transitioning.hasTransition()}recalculate(t){this.properties=this._transitioning.possiblyEvaluate(t);}_validate(t,i,a){return (!a||!1!==a.validate)&&e.t(this,t.call(e.u,{value:i,style:{glyphs:!0,sprite:!0},styleSpec:e.v}))}}const M=new e.q({"sky-color":new e.D(e.v.sky["sky-color"]),"horizon-color":new e.D(e.v.sky["horizon-color"]),"fog-color":new e.D(e.v.sky["fog-color"]),"fog-ground-blend":new e.D(e.v.sky["fog-ground-blend"]),"horizon-fog-blend":new e.D(e.v.sky["horizon-fog-blend"]),"sky-horizon-blend":new e.D(e.v.sky["sky-horizon-blend"]),"atmosphere-blend":new e.D(e.v.sky["atmosphere-blend"])});class A extends e.E{constructor(t){super(),this._transitionable=new e.T(M),this.setSky(t),this._transitioning=this._transitionable.untransitioned(),this.recalculate(new e.z(0));}setSky(t,i={}){if(!this._validate(e.B,t,i)){t||(t={"sky-color":"transparent","horizon-color":"transparent","fog-color":"transparent"});for(const e in t){const i=t[e];e.endsWith("-transition")?this._transitionable.setTransition(e.slice(0,-11),i):this._transitionable.setValue(e,i);}}}getSky(){return this._transitionable.serialize()}updateTransitions(t){this._transitioning=this._transitionable.transitioned(t,this._transitioning);}hasTransition(){return this._transitioning.hasTransition()}recalculate(t){this.properties=this._transitioning.possiblyEvaluate(t);}_validate(t,i,a={}){return !1!==(null==a?void 0:a.validate)&&e.t(this,t.call(e.u,e.e({value:i,style:{glyphs:!0,sprite:!0},styleSpec:e.v})))}calculateFogBlendOpacity(t){return t<60?0:t<70?(t-60)/10:1}}class R{constructor(t,e){this.width=t,this.height=e,this.nextRow=0,this.data=new Uint8Array(this.width*this.height),this.dashEntry={};}getDash(t,e){const i=t.join(",")+String(e);return this.dashEntry[i]||(this.dashEntry[i]=this.addDash(t,e)),this.dashEntry[i]}getDashRanges(t,e,i){const a=[];let s=t.length%2==1?-t[t.length-1]*i:0,o=t[0]*i,r=!0;a.push({left:s,right:o,isDash:r,zeroLength:0===t[0]});let n=t[0];for(let e=1;e<t.length;e++){r=!r;const l=t[e];s=n*i,n+=l,o=n*i,a.push({left:s,right:o,isDash:r,zeroLength:0===l});}return a}addRoundDash(t,e,i){const a=e/2;for(let e=-i;e<=i;e++){const s=this.width*(this.nextRow+i+e);let o=0,r=t[o];for(let n=0;n<this.width;n++){n/r.right>1&&(r=t[++o]);const l=Math.abs(n-r.left),h=Math.abs(n-r.right),c=Math.min(l,h);let u;const d=e/i*(a+1);if(r.isDash){const t=a-Math.abs(d);u=Math.sqrt(c*c+t*t);}else u=a-Math.sqrt(c*c+d*d);this.data[s+n]=Math.max(0,Math.min(255,u+128));}}}addRegularDash(t){for(let e=t.length-1;e>=0;--e){const i=t[e],a=t[e+1];i.zeroLength?t.splice(e,1):a&&a.isDash===i.isDash&&(a.left=i.left,t.splice(e,1));}const e=t[0],i=t[t.length-1];e.isDash===i.isDash&&(e.left=i.left-this.width,i.right=e.right+this.width);const a=this.width*this.nextRow;let s=0,o=t[s];for(let e=0;e<this.width;e++){e/o.right>1&&(o=t[++s]);const i=Math.abs(e-o.left),r=Math.abs(e-o.right),n=Math.min(i,r);this.data[a+e]=Math.max(0,Math.min(255,(o.isDash?n:-n)+128));}}addDash(t,i){const a=i?7:0,s=2*a+1;if(this.nextRow+s>this.height)return e.w("LineAtlas out of space"),null;let o=0;for(let e=0;e<t.length;e++)o+=t[e];if(0!==o){const e=this.width/o,s=this.getDashRanges(t,this.width,e);i?this.addRoundDash(s,e,a):this.addRegularDash(s);}const r={y:(this.nextRow+a+.5)/this.height,height:2*a/this.height,width:o};return this.nextRow+=s,this.dirty=!0,r}bind(t){const e=t.gl;this.texture?(e.bindTexture(e.TEXTURE_2D,this.texture),this.dirty&&(this.dirty=!1,e.texSubImage2D(e.TEXTURE_2D,0,0,0,this.width,this.height,e.ALPHA,e.UNSIGNED_BYTE,this.data))):(this.texture=e.createTexture(),e.bindTexture(e.TEXTURE_2D,this.texture),e.texParameteri(e.TEXTURE_2D,e.TEXTURE_WRAP_S,e.REPEAT),e.texParameteri(e.TEXTURE_2D,e.TEXTURE_WRAP_T,e.REPEAT),e.texParameteri(e.TEXTURE_2D,e.TEXTURE_MIN_FILTER,e.LINEAR),e.texParameteri(e.TEXTURE_2D,e.TEXTURE_MAG_FILTER,e.LINEAR),e.texImage2D(e.TEXTURE_2D,0,e.ALPHA,this.width,this.height,0,e.ALPHA,e.UNSIGNED_BYTE,this.data));}}const k="maplibre_preloaded_worker_pool";class L{constructor(){this.active={};}acquire(t){if(!this.workers)for(this.workers=[];this.workers.length<L.workerCount;)this.workers.push(new Worker(e.a.WORKER_URL));return this.active[t]=!0,this.workers.slice()}release(t){delete this.active[t],0===this.numActive()&&(this.workers.forEach((t=>{t.terminate();})),this.workers=null);}isPreloaded(){return !!this.active[k]}numActive(){return Object.keys(this.active).length}}const F=Math.floor(o.hardwareConcurrency/2);let B,O;function N(){return B||(B=new L),B}L.workerCount=e.C(globalThis)?Math.max(Math.min(F,3),1):1;class j{constructor(t,i){this.workerPool=t,this.actors=[],this.currentActor=0,this.id=i;const a=this.workerPool.acquire(i);for(let t=0;t<a.length;t++){const s=new e.F(a[t],i);s.name=`Worker ${t}`,this.actors.push(s);}if(!this.actors.length)throw new Error("No actors found")}broadcast(t,e){const i=[];for(const a of this.actors)i.push(a.sendAsync({type:t,data:e}));return Promise.all(i)}getActor(){return this.currentActor=(this.currentActor+1)%this.actors.length,this.actors[this.currentActor]}remove(t=!0){this.actors.forEach((t=>{t.remove();})),this.actors=[],t&&this.workerPool.release(this.id);}registerMessageHandler(t,e){for(const i of this.actors)i.registerMessageHandler(t,e);}}function U(){return O||(O=new j(N(),e.G),O.registerMessageHandler("GR",((t,i,a)=>e.m(i,a)))),O}function Z(t,i){const a=e.H();return e.J(a,a,[1,1,0]),e.K(a,a,[.5*t.width,.5*t.height,1]),e.L(a,a,t.calculatePosMatrix(i.toUnwrapped()))}function q(t,e,i,a,s,o){const r=function(t,e,i){if(t)for(const a of t){const t=e[a];if(t&&t.source===i&&"fill-extrusion"===t.type)return !0}else for(const t in e){const a=e[t];if(a.source===i&&"fill-extrusion"===a.type)return !0}return !1}(s&&s.layers,e,t.id),n=o.maxPitchScaleFactor(),l=t.tilesIn(a,n,r);l.sort(V);const h=[];for(const a of l)h.push({wrappedTileID:a.tileID.wrapped().key,queryResults:a.tile.queryRenderedFeatures(e,i,t._state,a.queryGeometry,a.cameraQueryGeometry,a.scale,s,o,n,Z(t.transform,a.tileID))});const c=function(t){const e={},i={};for(const a of t){const t=a.queryResults,s=a.wrappedTileID,o=i[s]=i[s]||{};for(const i in t){const a=t[i],s=o[i]=o[i]||{},r=e[i]=e[i]||[];for(const t of a)s[t.featureIndex]||(s[t.featureIndex]=!0,r.push(t));}}return e}(h);for(const e in c)c[e].forEach((e=>{const i=e.feature,a=t.getFeatureState(i.layer["source-layer"],i.id);i.source=i.layer.source,i.layer["source-layer"]&&(i.sourceLayer=i.layer["source-layer"]),i.state=a;}));return c}function V(t,e){const i=t.tileID,a=e.tileID;return i.overscaledZ-a.overscaledZ||i.canonical.y-a.canonical.y||i.wrap-a.wrap||i.canonical.x-a.canonical.x}function G(t,i,a){return e._(this,void 0,void 0,(function*(){let s=t;if(t.url?s=(yield e.h(i.transformRequest(t.url,"Source"),a)).data:yield o.frameAsync(a),!s)return null;const r=e.M(e.e(s,t),["tiles","minzoom","maxzoom","attribution","bounds","scheme","tileSize","encoding"]);return "vector_layers"in s&&s.vector_layers&&(r.vectorLayerIds=s.vector_layers.map((t=>t.id))),r}))}class H{constructor(t,e){t&&(e?this.setSouthWest(t).setNorthEast(e):Array.isArray(t)&&(4===t.length?this.setSouthWest([t[0],t[1]]).setNorthEast([t[2],t[3]]):this.setSouthWest(t[0]).setNorthEast(t[1])));}setNorthEast(t){return this._ne=t instanceof e.N?new e.N(t.lng,t.lat):e.N.convert(t),this}setSouthWest(t){return this._sw=t instanceof e.N?new e.N(t.lng,t.lat):e.N.convert(t),this}extend(t){const i=this._sw,a=this._ne;let s,o;if(t instanceof e.N)s=t,o=t;else {if(!(t instanceof H))return Array.isArray(t)?4===t.length||t.every(Array.isArray)?this.extend(H.convert(t)):this.extend(e.N.convert(t)):t&&("lng"in t||"lon"in t)&&"lat"in t?this.extend(e.N.convert(t)):this;if(s=t._sw,o=t._ne,!s||!o)return this}return i||a?(i.lng=Math.min(s.lng,i.lng),i.lat=Math.min(s.lat,i.lat),a.lng=Math.max(o.lng,a.lng),a.lat=Math.max(o.lat,a.lat)):(this._sw=new e.N(s.lng,s.lat),this._ne=new e.N(o.lng,o.lat)),this}getCenter(){return new e.N((this._sw.lng+this._ne.lng)/2,(this._sw.lat+this._ne.lat)/2)}getSouthWest(){return this._sw}getNorthEast(){return this._ne}getNorthWest(){return new e.N(this.getWest(),this.getNorth())}getSouthEast(){return new e.N(this.getEast(),this.getSouth())}getWest(){return this._sw.lng}getSouth(){return this._sw.lat}getEast(){return this._ne.lng}getNorth(){return this._ne.lat}toArray(){return [this._sw.toArray(),this._ne.toArray()]}toString(){return `LngLatBounds(${this._sw.toString()}, ${this._ne.toString()})`}isEmpty(){return !(this._sw&&this._ne)}contains(t){const{lng:i,lat:a}=e.N.convert(t);let s=this._sw.lng<=i&&i<=this._ne.lng;return this._sw.lng>this._ne.lng&&(s=this._sw.lng>=i&&i>=this._ne.lng),this._sw.lat<=a&&a<=this._ne.lat&&s}static convert(t){return t instanceof H?t:t?new H(t):t}static fromLngLat(t,i=0){const a=360*i/40075017,s=a/Math.cos(Math.PI/180*t.lat);return new H(new e.N(t.lng-s,t.lat-a),new e.N(t.lng+s,t.lat+a))}}class W{constructor(t,e,i){this.bounds=H.convert(this.validateBounds(t)),this.minzoom=e||0,this.maxzoom=i||24;}validateBounds(t){return Array.isArray(t)&&4===t.length?[Math.max(-180,t[0]),Math.max(-90,t[1]),Math.min(180,t[2]),Math.min(90,t[3])]:[-180,-90,180,90]}contains(t){const i=Math.pow(2,t.z),a=Math.floor(e.O(this.bounds.getWest())*i),s=Math.floor(e.Q(this.bounds.getNorth())*i),o=Math.ceil(e.O(this.bounds.getEast())*i),r=Math.ceil(e.Q(this.bounds.getSouth())*i);return t.x>=a&&t.x<o&&t.y>=s&&t.y<r}}class $ extends e.E{constructor(t,i,a,s){if(super(),this.id=t,this.dispatcher=a,this.type="vector",this.minzoom=0,this.maxzoom=22,this.scheme="xyz",this.tileSize=512,this.reparseOverscaled=!0,this.isTileClipped=!0,this._loaded=!1,e.e(this,e.M(i,["url","scheme","tileSize","promoteId"])),this._options=e.e({type:"vector"},i),this._collectResourceTiming=i.collectResourceTiming,512!==this.tileSize)throw new Error("vector tile sources must have a tileSize of 512");this.setEventedParent(s);}load(){return e._(this,void 0,void 0,(function*(){this._loaded=!1,this.fire(new e.k("dataloading",{dataType:"source"})),this._tileJSONRequest=new AbortController;try{const t=yield G(this._options,this.map._requestManager,this._tileJSONRequest);this._tileJSONRequest=null,this._loaded=!0,this.map.style.sourceCaches[this.id].clearTiles(),t&&(e.e(this,t),t.bounds&&(this.tileBounds=new W(t.bounds,this.minzoom,this.maxzoom)),this.fire(new e.k("data",{dataType:"source",sourceDataType:"metadata"})),this.fire(new e.k("data",{dataType:"source",sourceDataType:"content"})));}catch(t){this._tileJSONRequest=null,this.fire(new e.j(t));}}))}loaded(){return this._loaded}hasTile(t){return !this.tileBounds||this.tileBounds.contains(t.canonical)}onAdd(t){this.map=t,this.load();}setSourceProperty(t){this._tileJSONRequest&&this._tileJSONRequest.abort(),t(),this.load();}setTiles(t){return this.setSourceProperty((()=>{this._options.tiles=t;})),this}setUrl(t){return this.setSourceProperty((()=>{this.url=t,this._options.url=t;})),this}onRemove(){this._tileJSONRequest&&(this._tileJSONRequest.abort(),this._tileJSONRequest=null);}serialize(){return e.e({},this._options)}loadTile(t){return e._(this,void 0,void 0,(function*(){const e=t.tileID.canonical.url(this.tiles,this.map.getPixelRatio(),this.scheme),i={request:this.map._requestManager.transformRequest(e,"Tile"),uid:t.uid,tileID:t.tileID,zoom:t.tileID.overscaledZ,tileSize:this.tileSize*t.tileID.overscaleFactor(),type:this.type,source:this.id,pixelRatio:this.map.getPixelRatio(),showCollisionBoxes:this.map.showCollisionBoxes,promoteId:this.promoteId};i.request.collectResourceTiming=this._collectResourceTiming;let a="RT";if(t.actor&&"expired"!==t.state){if("loading"===t.state)return new Promise(((e,i)=>{t.reloadPromise={resolve:e,reject:i};}))}else t.actor=this.dispatcher.getActor(),a="LT";t.abortController=new AbortController;try{const e=yield t.actor.sendAsync({type:a,data:i},t.abortController);if(delete t.abortController,t.aborted)return;this._afterTileLoadWorkerResponse(t,e);}catch(e){if(delete t.abortController,t.aborted)return;if(e&&404!==e.status)throw e;this._afterTileLoadWorkerResponse(t,null);}}))}_afterTileLoadWorkerResponse(t,e){if(e&&e.resourceTiming&&(t.resourceTiming=e.resourceTiming),e&&this.map._refreshExpiredTiles&&t.setExpiryData(e),t.loadVectorData(e,this.map.painter),t.reloadPromise){const e=t.reloadPromise;t.reloadPromise=null,this.loadTile(t).then(e.resolve).catch(e.reject);}}abortTile(t){return e._(this,void 0,void 0,(function*(){t.abortController&&(t.abortController.abort(),delete t.abortController),t.actor&&(yield t.actor.sendAsync({type:"AT",data:{uid:t.uid,type:this.type,source:this.id}}));}))}unloadTile(t){return e._(this,void 0,void 0,(function*(){t.unloadVectorData(),t.actor&&(yield t.actor.sendAsync({type:"RMT",data:{uid:t.uid,type:this.type,source:this.id}}));}))}hasTransition(){return !1}}class X extends e.E{constructor(t,i,a,s){super(),this.id=t,this.dispatcher=a,this.setEventedParent(s),this.type="raster",this.minzoom=0,this.maxzoom=22,this.roundZoom=!0,this.scheme="xyz",this.tileSize=512,this._loaded=!1,this._options=e.e({type:"raster"},i),e.e(this,e.M(i,["url","scheme","tileSize"]));}load(){return e._(this,void 0,void 0,(function*(){this._loaded=!1,this.fire(new e.k("dataloading",{dataType:"source"})),this._tileJSONRequest=new AbortController;try{const t=yield G(this._options,this.map._requestManager,this._tileJSONRequest);this._tileJSONRequest=null,this._loaded=!0,t&&(e.e(this,t),t.bounds&&(this.tileBounds=new W(t.bounds,this.minzoom,this.maxzoom)),this.fire(new e.k("data",{dataType:"source",sourceDataType:"metadata"})),this.fire(new e.k("data",{dataType:"source",sourceDataType:"content"})));}catch(t){this._tileJSONRequest=null,this.fire(new e.j(t));}}))}loaded(){return this._loaded}onAdd(t){this.map=t,this.load();}onRemove(){this._tileJSONRequest&&(this._tileJSONRequest.abort(),this._tileJSONRequest=null);}setSourceProperty(t){this._tileJSONRequest&&(this._tileJSONRequest.abort(),this._tileJSONRequest=null),t(),this.load();}setTiles(t){return this.setSourceProperty((()=>{this._options.tiles=t;})),this}setUrl(t){return this.setSourceProperty((()=>{this.url=t,this._options.url=t;})),this}serialize(){return e.e({},this._options)}hasTile(t){return !this.tileBounds||this.tileBounds.contains(t.canonical)}loadTile(t){return e._(this,void 0,void 0,(function*(){const e=t.tileID.canonical.url(this.tiles,this.map.getPixelRatio(),this.scheme);t.abortController=new AbortController;try{const i=yield _.getImage(this.map._requestManager.transformRequest(e,"Tile"),t.abortController,this.map._refreshExpiredTiles);if(delete t.abortController,t.aborted)return void(t.state="unloaded");if(i&&i.data){this.map._refreshExpiredTiles&&i.cacheControl&&i.expires&&t.setExpiryData({cacheControl:i.cacheControl,expires:i.expires});const e=this.map.painter.context,a=e.gl,s=i.data;t.texture=this.map.painter.getTileTexture(s.width),t.texture?t.texture.update(s,{useMipmap:!0}):(t.texture=new b(e,s,a.RGBA,{useMipmap:!0}),t.texture.bind(a.LINEAR,a.CLAMP_TO_EDGE,a.LINEAR_MIPMAP_NEAREST)),t.state="loaded";}}catch(e){if(delete t.abortController,t.aborted)t.state="unloaded";else if(e)throw t.state="errored",e}}))}abortTile(t){return e._(this,void 0,void 0,(function*(){t.abortController&&(t.abortController.abort(),delete t.abortController);}))}unloadTile(t){return e._(this,void 0,void 0,(function*(){t.texture&&this.map.painter.saveTileTexture(t.texture);}))}hasTransition(){return !1}}class K extends X{constructor(t,i,a,s){super(t,i,a,s),this.type="raster-dem",this.maxzoom=22,this._options=e.e({type:"raster-dem"},i),this.encoding=i.encoding||"mapbox",this.redFactor=i.redFactor,this.greenFactor=i.greenFactor,this.blueFactor=i.blueFactor,this.baseShift=i.baseShift;}loadTile(t){return e._(this,void 0,void 0,(function*(){const i=t.tileID.canonical.url(this.tiles,this.map.getPixelRatio(),this.scheme),a=this.map._requestManager.transformRequest(i,"Tile");t.neighboringTiles=this._getNeighboringTiles(t.tileID),t.abortController=new AbortController;try{const i=yield _.getImage(a,t.abortController,this.map._refreshExpiredTiles);if(delete t.abortController,t.aborted)return void(t.state="unloaded");if(i&&i.data){const a=i.data;this.map._refreshExpiredTiles&&i.cacheControl&&i.expires&&t.setExpiryData({cacheControl:i.cacheControl,expires:i.expires});const s=e.b(a)&&e.U()?a:yield this.readImageNow(a),o={type:this.type,uid:t.uid,source:this.id,rawImageData:s,encoding:this.encoding,redFactor:this.redFactor,greenFactor:this.greenFactor,blueFactor:this.blueFactor,baseShift:this.baseShift};if(!t.actor||"expired"===t.state){t.actor=this.dispatcher.getActor();const e=yield t.actor.sendAsync({type:"LDT",data:o});t.dem=e,t.needsHillshadePrepare=!0,t.needsTerrainPrepare=!0,t.state="loaded";}}}catch(e){if(delete t.abortController,t.aborted)t.state="unloaded";else if(e)throw t.state="errored",e}}))}readImageNow(t){return e._(this,void 0,void 0,(function*(){if("undefined"!=typeof VideoFrame&&e.V()){const i=t.width+2,a=t.height+2;try{return new e.R({width:i,height:a},yield e.W(t,-1,-1,i,a))}catch(t){}}return o.getImageData(t,1)}))}_getNeighboringTiles(t){const i=t.canonical,a=Math.pow(2,i.z),s=(i.x-1+a)%a,o=0===i.x?t.wrap-1:t.wrap,r=(i.x+1+a)%a,n=i.x+1===a?t.wrap+1:t.wrap,l={};return l[new e.S(t.overscaledZ,o,i.z,s,i.y).key]={backfilled:!1},l[new e.S(t.overscaledZ,n,i.z,r,i.y).key]={backfilled:!1},i.y>0&&(l[new e.S(t.overscaledZ,o,i.z,s,i.y-1).key]={backfilled:!1},l[new e.S(t.overscaledZ,t.wrap,i.z,i.x,i.y-1).key]={backfilled:!1},l[new e.S(t.overscaledZ,n,i.z,r,i.y-1).key]={backfilled:!1}),i.y+1<a&&(l[new e.S(t.overscaledZ,o,i.z,s,i.y+1).key]={backfilled:!1},l[new e.S(t.overscaledZ,t.wrap,i.z,i.x,i.y+1).key]={backfilled:!1},l[new e.S(t.overscaledZ,n,i.z,r,i.y+1).key]={backfilled:!1}),l}unloadTile(t){return e._(this,void 0,void 0,(function*(){t.demTexture&&this.map.painter.saveTileTexture(t.demTexture),t.fbo&&(t.fbo.destroy(),delete t.fbo),t.dem&&delete t.dem,delete t.neighboringTiles,t.state="unloaded",t.actor&&(yield t.actor.sendAsync({type:"RDT",data:{type:this.type,uid:t.uid,source:this.id}}));}))}}class J extends e.E{constructor(t,i,a,s){super(),this.id=t,this.type="geojson",this.minzoom=0,this.maxzoom=18,this.tileSize=512,this.isTileClipped=!0,this.reparseOverscaled=!0,this._removed=!1,this._pendingLoads=0,this.actor=a.getActor(),this.setEventedParent(s),this._data=i.data,this._options=e.e({},i),this._collectResourceTiming=i.collectResourceTiming,void 0!==i.maxzoom&&(this.maxzoom=i.maxzoom),i.type&&(this.type=i.type),i.attribution&&(this.attribution=i.attribution),this.promoteId=i.promoteId;const o=e.X/this.tileSize;this.workerOptions=e.e({source:this.id,cluster:i.cluster||!1,geojsonVtOptions:{buffer:(void 0!==i.buffer?i.buffer:128)*o,tolerance:(void 0!==i.tolerance?i.tolerance:.375)*o,extent:e.X,maxZoom:this.maxzoom,lineMetrics:i.lineMetrics||!1,generateId:i.generateId||!1},superclusterOptions:{maxZoom:void 0!==i.clusterMaxZoom?i.clusterMaxZoom:this.maxzoom-1,minPoints:Math.max(2,i.clusterMinPoints||2),extent:e.X,radius:(i.clusterRadius||50)*o,log:!1,generateId:i.generateId||!1},clusterProperties:i.clusterProperties,filter:i.filter},i.workerOptions),"string"==typeof this.promoteId&&(this.workerOptions.promoteId=this.promoteId);}load(){return e._(this,void 0,void 0,(function*(){yield this._updateWorkerData();}))}onAdd(t){this.map=t,this.load();}setData(t){return this._data=t,this._updateWorkerData(),this}updateData(t){return this._updateWorkerData(t),this}getData(){return e._(this,void 0,void 0,(function*(){const t=e.e({type:this.type},this.workerOptions);return this.actor.sendAsync({type:"GD",data:t})}))}setClusterOptions(t){return this.workerOptions.cluster=t.cluster,t&&(void 0!==t.clusterRadius&&(this.workerOptions.superclusterOptions.radius=t.clusterRadius),void 0!==t.clusterMaxZoom&&(this.workerOptions.superclusterOptions.maxZoom=t.clusterMaxZoom)),this._updateWorkerData(),this}getClusterExpansionZoom(t){return this.actor.sendAsync({type:"GCEZ",data:{type:this.type,clusterId:t,source:this.id}})}getClusterChildren(t){return this.actor.sendAsync({type:"GCC",data:{type:this.type,clusterId:t,source:this.id}})}getClusterLeaves(t,e,i){return this.actor.sendAsync({type:"GCL",data:{type:this.type,source:this.id,clusterId:t,limit:e,offset:i}})}_updateWorkerData(t){return e._(this,void 0,void 0,(function*(){const i=e.e({type:this.type},this.workerOptions);t?i.dataDiff=t:"string"==typeof this._data?(i.request=this.map._requestManager.transformRequest(o.resolveURL(this._data),"Source"),i.request.collectResourceTiming=this._collectResourceTiming):i.data=JSON.stringify(this._data),this._pendingLoads++,this.fire(new e.k("dataloading",{dataType:"source"}));try{const t=yield this.actor.sendAsync({type:"LD",data:i});if(this._pendingLoads--,this._removed||t.abandoned)return void this.fire(new e.k("dataabort",{dataType:"source"}));let a=null;t.resourceTiming&&t.resourceTiming[this.id]&&(a=t.resourceTiming[this.id].slice(0));const s={dataType:"source"};this._collectResourceTiming&&a&&a.length>0&&e.e(s,{resourceTiming:a}),this.fire(new e.k("data",Object.assign(Object.assign({},s),{sourceDataType:"metadata"}))),this.fire(new e.k("data",Object.assign(Object.assign({},s),{sourceDataType:"content"})));}catch(t){if(this._pendingLoads--,this._removed)return void this.fire(new e.k("dataabort",{dataType:"source"}));this.fire(new e.j(t));}}))}loaded(){return 0===this._pendingLoads}loadTile(t){return e._(this,void 0,void 0,(function*(){const e=t.actor?"RT":"LT";t.actor=this.actor;const i={type:this.type,uid:t.uid,tileID:t.tileID,zoom:t.tileID.overscaledZ,maxZoom:this.maxzoom,tileSize:this.tileSize,source:this.id,pixelRatio:this.map.getPixelRatio(),showCollisionBoxes:this.map.showCollisionBoxes,promoteId:this.promoteId};t.abortController=new AbortController;const a=yield this.actor.sendAsync({type:e,data:i},t.abortController);delete t.abortController,t.unloadVectorData(),t.aborted||t.loadVectorData(a,this.map.painter,"RT"===e);}))}abortTile(t){return e._(this,void 0,void 0,(function*(){t.abortController&&(t.abortController.abort(),delete t.abortController),t.aborted=!0;}))}unloadTile(t){return e._(this,void 0,void 0,(function*(){t.unloadVectorData(),yield this.actor.sendAsync({type:"RMT",data:{uid:t.uid,type:this.type,source:this.id}});}))}onRemove(){this._removed=!0,this.actor.sendAsync({type:"RS",data:{type:this.type,source:this.id}});}serialize(){return e.e({},this._options,{type:this.type,data:this._data})}hasTransition(){return !1}}var Y=e.Y([{name:"a_pos",type:"Int16",components:2},{name:"a_texture_pos",type:"Int16",components:2}]);class Q extends e.E{constructor(t,e,i,a){super(),this.id=t,this.dispatcher=i,this.coordinates=e.coordinates,this.type="image",this.minzoom=0,this.maxzoom=22,this.tileSize=512,this.tiles={},this._loaded=!1,this.setEventedParent(a),this.options=e;}load(t){return e._(this,void 0,void 0,(function*(){this._loaded=!1,this.fire(new e.k("dataloading",{dataType:"source"})),this.url=this.options.url,this._request=new AbortController;try{const e=yield _.getImage(this.map._requestManager.transformRequest(this.url,"Image"),this._request);this._request=null,this._loaded=!0,e&&e.data&&(this.image=e.data,t&&(this.coordinates=t),this._finishLoading());}catch(t){this._request=null,this._loaded=!0,this.fire(new e.j(t));}}))}loaded(){return this._loaded}updateImage(t){return t.url?(this._request&&(this._request.abort(),this._request=null),this.options.url=t.url,this.load(t.coordinates).finally((()=>{this.texture=null;})),this):this}_finishLoading(){this.map&&(this.setCoordinates(this.coordinates),this.fire(new e.k("data",{dataType:"source",sourceDataType:"metadata"})));}onAdd(t){this.map=t,this.load();}onRemove(){this._request&&(this._request.abort(),this._request=null);}setCoordinates(t){this.coordinates=t;const i=t.map(e.Z.fromLngLat);this.tileID=function(t){let i=1/0,a=1/0,s=-1/0,o=-1/0;for(const e of t)i=Math.min(i,e.x),a=Math.min(a,e.y),s=Math.max(s,e.x),o=Math.max(o,e.y);const r=Math.max(s-i,o-a),n=Math.max(0,Math.floor(-Math.log(r)/Math.LN2)),l=Math.pow(2,n);return new e.a1(n,Math.floor((i+s)/2*l),Math.floor((a+o)/2*l))}(i),this.minzoom=this.maxzoom=this.tileID.z;const a=i.map((t=>this.tileID.getTilePoint(t)._round()));return this._boundsArray=new e.$,this._boundsArray.emplaceBack(a[0].x,a[0].y,0,0),this._boundsArray.emplaceBack(a[1].x,a[1].y,e.X,0),this._boundsArray.emplaceBack(a[3].x,a[3].y,0,e.X),this._boundsArray.emplaceBack(a[2].x,a[2].y,e.X,e.X),this.boundsBuffer&&(this.boundsBuffer.destroy(),delete this.boundsBuffer),this.fire(new e.k("data",{dataType:"source",sourceDataType:"content"})),this}prepare(){if(0===Object.keys(this.tiles).length||!this.image)return;const t=this.map.painter.context,i=t.gl;this.boundsBuffer||(this.boundsBuffer=t.createVertexBuffer(this._boundsArray,Y.members)),this.boundsSegments||(this.boundsSegments=e.a0.simpleSegment(0,0,4,2)),this.texture||(this.texture=new b(t,this.image,i.RGBA),this.texture.bind(i.LINEAR,i.CLAMP_TO_EDGE));let a=!1;for(const t in this.tiles){const e=this.tiles[t];"loaded"!==e.state&&(e.state="loaded",e.texture=this.texture,a=!0);}a&&this.fire(new e.k("data",{dataType:"source",sourceDataType:"idle",sourceId:this.id}));}loadTile(t){return e._(this,void 0,void 0,(function*(){this.tileID&&this.tileID.equals(t.tileID.canonical)?(this.tiles[String(t.tileID.wrap)]=t,t.buckets={}):t.state="errored";}))}serialize(){return {type:"image",url:this.options.url,coordinates:this.coordinates}}hasTransition(){return !1}}class tt extends Q{constructor(t,e,i,a){super(t,e,i,a),this.roundZoom=!0,this.type="video",this.options=e;}load(){return e._(this,void 0,void 0,(function*(){this._loaded=!1;const t=this.options;this.urls=[];for(const e of t.urls)this.urls.push(this.map._requestManager.transformRequest(e,"Source").url);try{const t=yield e.a3(this.urls);if(this._loaded=!0,!t)return;this.video=t,this.video.loop=!0,this.video.addEventListener("playing",(()=>{this.map.triggerRepaint();})),this.map&&this.video.play(),this._finishLoading();}catch(t){this.fire(new e.j(t));}}))}pause(){this.video&&this.video.pause();}play(){this.video&&this.video.play();}seek(t){if(this.video){const i=this.video.seekable;t<i.start(0)||t>i.end(0)?this.fire(new e.j(new e.a2(`sources.${this.id}`,null,`Playback for this video can be set only between the ${i.start(0)} and ${i.end(0)}-second mark.`))):this.video.currentTime=t;}}getVideo(){return this.video}onAdd(t){this.map||(this.map=t,this.load(),this.video&&(this.video.play(),this.setCoordinates(this.coordinates)));}prepare(){if(0===Object.keys(this.tiles).length||this.video.readyState<2)return;const t=this.map.painter.context,i=t.gl;this.boundsBuffer||(this.boundsBuffer=t.createVertexBuffer(this._boundsArray,Y.members)),this.boundsSegments||(this.boundsSegments=e.a0.simpleSegment(0,0,4,2)),this.texture?this.video.paused||(this.texture.bind(i.LINEAR,i.CLAMP_TO_EDGE),i.texSubImage2D(i.TEXTURE_2D,0,0,0,i.RGBA,i.UNSIGNED_BYTE,this.video)):(this.texture=new b(t,this.video,i.RGBA),this.texture.bind(i.LINEAR,i.CLAMP_TO_EDGE));let a=!1;for(const t in this.tiles){const e=this.tiles[t];"loaded"!==e.state&&(e.state="loaded",e.texture=this.texture,a=!0);}a&&this.fire(new e.k("data",{dataType:"source",sourceDataType:"idle",sourceId:this.id}));}serialize(){return {type:"video",urls:this.urls,coordinates:this.coordinates}}hasTransition(){return this.video&&!this.video.paused}}class et extends Q{constructor(t,i,a,s){super(t,i,a,s),i.coordinates?Array.isArray(i.coordinates)&&4===i.coordinates.length&&!i.coordinates.some((t=>!Array.isArray(t)||2!==t.length||t.some((t=>"number"!=typeof t))))||this.fire(new e.j(new e.a2(`sources.${t}`,null,'"coordinates" property must be an array of 4 longitude/latitude array pairs'))):this.fire(new e.j(new e.a2(`sources.${t}`,null,'missing required property "coordinates"'))),i.animate&&"boolean"!=typeof i.animate&&this.fire(new e.j(new e.a2(`sources.${t}`,null,'optional "animate" property must be a boolean value'))),i.canvas?"string"==typeof i.canvas||i.canvas instanceof HTMLCanvasElement||this.fire(new e.j(new e.a2(`sources.${t}`,null,'"canvas" must be either a string representing the ID of the canvas element from which to read, or an HTMLCanvasElement instance'))):this.fire(new e.j(new e.a2(`sources.${t}`,null,'missing required property "canvas"'))),this.options=i,this.animate=void 0===i.animate||i.animate;}load(){return e._(this,void 0,void 0,(function*(){this._loaded=!0,this.canvas||(this.canvas=this.options.canvas instanceof HTMLCanvasElement?this.options.canvas:document.getElementById(this.options.canvas)),this.width=this.canvas.width,this.height=this.canvas.height,this._hasInvalidDimensions()?this.fire(new e.j(new Error("Canvas dimensions cannot be less than or equal to zero."))):(this.play=function(){this._playing=!0,this.map.triggerRepaint();},this.pause=function(){this._playing&&(this.prepare(),this._playing=!1);},this._finishLoading());}))}getCanvas(){return this.canvas}onAdd(t){this.map=t,this.load(),this.canvas&&this.animate&&this.play();}onRemove(){this.pause();}prepare(){let t=!1;if(this.canvas.width!==this.width&&(this.width=this.canvas.width,t=!0),this.canvas.height!==this.height&&(this.height=this.canvas.height,t=!0),this._hasInvalidDimensions())return;if(0===Object.keys(this.tiles).length)return;const i=this.map.painter.context,a=i.gl;this.boundsBuffer||(this.boundsBuffer=i.createVertexBuffer(this._boundsArray,Y.members)),this.boundsSegments||(this.boundsSegments=e.a0.simpleSegment(0,0,4,2)),this.texture?(t||this._playing)&&this.texture.update(this.canvas,{premultiply:!0}):this.texture=new b(i,this.canvas,a.RGBA,{premultiply:!0});let s=!1;for(const t in this.tiles){const e=this.tiles[t];"loaded"!==e.state&&(e.state="loaded",e.texture=this.texture,s=!0);}s&&this.fire(new e.k("data",{dataType:"source",sourceDataType:"idle",sourceId:this.id}));}serialize(){return {type:"canvas",coordinates:this.coordinates}}hasTransition(){return this._playing}_hasInvalidDimensions(){for(const t of [this.canvas.width,this.canvas.height])if(isNaN(t)||t<=0)return !0;return !1}}const it={},at=t=>{switch(t){case"geojson":return J;case"image":return Q;case"raster":return X;case"raster-dem":return K;case"vector":return $;case"video":return tt;case"canvas":return et}return it[t]},st="RTLPluginLoaded";class ot extends e.E{constructor(){super(...arguments),this.status="unavailable",this.url=null,this.dispatcher=U();}_syncState(t){return this.status=t,this.dispatcher.broadcast("SRPS",{pluginStatus:t,pluginURL:this.url}).catch((t=>{throw this.status="error",t}))}getRTLTextPluginStatus(){return this.status}clearRTLTextPlugin(){this.status="unavailable",this.url=null;}setRTLTextPlugin(t){return e._(this,arguments,void 0,(function*(t,e=!1){if(this.url)throw new Error("setRTLTextPlugin cannot be called multiple times.");if(this.url=o.resolveURL(t),!this.url)throw new Error(`requested url ${t} is invalid`);if("unavailable"===this.status){if(!e)return this._requestImport();this.status="deferred",this._syncState(this.status);}else if("requested"===this.status)return this._requestImport()}))}_requestImport(){return e._(this,void 0,void 0,(function*(){yield this._syncState("loading"),this.status="loaded",this.fire(new e.k(st));}))}lazyLoad(){"unavailable"===this.status?this.status="requested":"deferred"===this.status&&this._requestImport();}}let rt=null;function nt(){return rt||(rt=new ot),rt}class lt{constructor(t,i){this.timeAdded=0,this.fadeEndTime=0,this.tileID=t,this.uid=e.a4(),this.uses=0,this.tileSize=i,this.buckets={},this.expirationTime=null,this.queryPadding=0,this.hasSymbolBuckets=!1,this.hasRTLText=!1,this.dependencies={},this.rtt=[],this.rttCoords={},this.expiredRequestCount=0,this.state="loading";}registerFadeDuration(t){const e=t+this.timeAdded;e<this.fadeEndTime||(this.fadeEndTime=e);}wasRequested(){return "errored"===this.state||"loaded"===this.state||"reloading"===this.state}clearTextures(t){this.demTexture&&t.saveTileTexture(this.demTexture),this.demTexture=null;}loadVectorData(t,i,a){if(this.hasData()&&this.unloadVectorData(),this.state="loaded",t){t.featureIndex&&(this.latestFeatureIndex=t.featureIndex,t.rawTileData?(this.latestRawTileData=t.rawTileData,this.latestFeatureIndex.rawTileData=t.rawTileData):this.latestRawTileData&&(this.latestFeatureIndex.rawTileData=this.latestRawTileData)),this.collisionBoxArray=t.collisionBoxArray,this.buckets=function(t,e){const i={};if(!e)return i;for(const a of t){const t=a.layerIds.map((t=>e.getLayer(t))).filter(Boolean);if(0!==t.length){a.layers=t,a.stateDependentLayerIds&&(a.stateDependentLayers=a.stateDependentLayerIds.map((e=>t.filter((t=>t.id===e))[0])));for(const e of t)i[e.id]=a;}}return i}(t.buckets,i.style),this.hasSymbolBuckets=!1;for(const t in this.buckets){const i=this.buckets[t];if(i instanceof e.a6){if(this.hasSymbolBuckets=!0,!a)break;i.justReloaded=!0;}}if(this.hasRTLText=!1,this.hasSymbolBuckets)for(const t in this.buckets){const i=this.buckets[t];if(i instanceof e.a6&&i.hasRTLText){this.hasRTLText=!0,nt().lazyLoad();break}}this.queryPadding=0;for(const t in this.buckets){const e=this.buckets[t];this.queryPadding=Math.max(this.queryPadding,i.style.getLayer(t).queryRadius(e));}t.imageAtlas&&(this.imageAtlas=t.imageAtlas),t.glyphAtlasImage&&(this.glyphAtlasImage=t.glyphAtlasImage);}else this.collisionBoxArray=new e.a5;}unloadVectorData(){for(const t in this.buckets)this.buckets[t].destroy();this.buckets={},this.imageAtlasTexture&&this.imageAtlasTexture.destroy(),this.imageAtlas&&(this.imageAtlas=null),this.glyphAtlasTexture&&this.glyphAtlasTexture.destroy(),this.latestFeatureIndex=null,this.state="unloaded";}getBucket(t){return this.buckets[t.id]}upload(t){for(const e in this.buckets){const i=this.buckets[e];i.uploadPending()&&i.upload(t);}const e=t.gl;this.imageAtlas&&!this.imageAtlas.uploaded&&(this.imageAtlasTexture=new b(t,this.imageAtlas.image,e.RGBA),this.imageAtlas.uploaded=!0),this.glyphAtlasImage&&(this.glyphAtlasTexture=new b(t,this.glyphAtlasImage,e.ALPHA),this.glyphAtlasImage=null);}prepare(t){this.imageAtlas&&this.imageAtlas.patchUpdatedImages(t,this.imageAtlasTexture);}queryRenderedFeatures(t,e,i,a,s,o,r,n,l,h){return this.latestFeatureIndex&&this.latestFeatureIndex.rawTileData?this.latestFeatureIndex.query({queryGeometry:a,cameraQueryGeometry:s,scale:o,tileSize:this.tileSize,pixelPosMatrix:h,transform:n,params:r,queryPadding:this.queryPadding*l},t,e,i):{}}querySourceFeatures(t,i){const a=this.latestFeatureIndex;if(!a||!a.rawTileData)return;const s=a.loadVTLayers(),o=i&&i.sourceLayer?i.sourceLayer:"",r=s._geojsonTileLayer||s[o];if(!r)return;const n=e.a7(i&&i.filter),{z:l,x:h,y:c}=this.tileID.canonical,u={z:l,x:h,y:c};for(let i=0;i<r.length;i++){const s=r.feature(i);if(n.needGeometry){const t=e.a8(s,!0);if(!n.filter(new e.z(this.tileID.overscaledZ),t,this.tileID.canonical))continue}else if(!n.filter(new e.z(this.tileID.overscaledZ),s))continue;const d=a.getId(s,o),_=new e.a9(s,l,h,c,d);_.tile=u,t.push(_);}}hasData(){return "loaded"===this.state||"reloading"===this.state||"expired"===this.state}patternsLoaded(){return this.imageAtlas&&!!Object.keys(this.imageAtlas.patternPositions).length}setExpiryData(t){const i=this.expirationTime;if(t.cacheControl){const i=e.aa(t.cacheControl);i["max-age"]&&(this.expirationTime=Date.now()+1e3*i["max-age"]);}else t.expires&&(this.expirationTime=new Date(t.expires).getTime());if(this.expirationTime){const t=Date.now();let e=!1;if(this.expirationTime>t)e=!1;else if(i)if(this.expirationTime<i)e=!0;else {const a=this.expirationTime-i;a?this.expirationTime=t+Math.max(a,3e4):e=!0;}else e=!0;e?(this.expiredRequestCount++,this.state="expired"):this.expiredRequestCount=0;}}getExpiryTimeout(){if(this.expirationTime)return this.expiredRequestCount?1e3*(1<<Math.min(this.expiredRequestCount-1,31)):Math.min(this.expirationTime-(new Date).getTime(),Math.pow(2,31)-1)}setFeatureState(t,e){if(!this.latestFeatureIndex||!this.latestFeatureIndex.rawTileData||0===Object.keys(t).length)return;const i=this.latestFeatureIndex.loadVTLayers();for(const a in this.buckets){if(!e.style.hasLayer(a))continue;const s=this.buckets[a],o=s.layers[0].sourceLayer||"_geojsonTileLayer",r=i[o],n=t[o];if(!r||!n||0===Object.keys(n).length)continue;s.update(n,r,this.imageAtlas&&this.imageAtlas.patternPositions||{});const l=e&&e.style&&e.style.getLayer(a);l&&(this.queryPadding=Math.max(this.queryPadding,l.queryRadius(s)));}}holdingForFade(){return void 0!==this.symbolFadeHoldUntil}symbolFadeFinished(){return !this.symbolFadeHoldUntil||this.symbolFadeHoldUntil<o.now()}clearFadeHold(){this.symbolFadeHoldUntil=void 0;}setHoldDuration(t){this.symbolFadeHoldUntil=o.now()+t;}setDependencies(t,e){const i={};for(const t of e)i[t]=!0;this.dependencies[t]=i;}hasDependency(t,e){for(const i of t){const t=this.dependencies[i];if(t)for(const i of e)if(t[i])return !0}return !1}}class ht{constructor(t,e){this.max=t,this.onRemove=e,this.reset();}reset(){for(const t in this.data)for(const e of this.data[t])e.timeout&&clearTimeout(e.timeout),this.onRemove(e.value);return this.data={},this.order=[],this}add(t,e,i){const a=t.wrapped().key;void 0===this.data[a]&&(this.data[a]=[]);const s={value:e,timeout:void 0};if(void 0!==i&&(s.timeout=setTimeout((()=>{this.remove(t,s);}),i)),this.data[a].push(s),this.order.push(a),this.order.length>this.max){const t=this._getAndRemoveByKey(this.order[0]);t&&this.onRemove(t);}return this}has(t){return t.wrapped().key in this.data}getAndRemove(t){return this.has(t)?this._getAndRemoveByKey(t.wrapped().key):null}_getAndRemoveByKey(t){const e=this.data[t].shift();return e.timeout&&clearTimeout(e.timeout),0===this.data[t].length&&delete this.data[t],this.order.splice(this.order.indexOf(t),1),e.value}getByKey(t){const e=this.data[t];return e?e[0].value:null}get(t){return this.has(t)?this.data[t.wrapped().key][0].value:null}remove(t,e){if(!this.has(t))return this;const i=t.wrapped().key,a=void 0===e?0:this.data[i].indexOf(e),s=this.data[i][a];return this.data[i].splice(a,1),s.timeout&&clearTimeout(s.timeout),0===this.data[i].length&&delete this.data[i],this.onRemove(s.value),this.order.splice(this.order.indexOf(i),1),this}setMaxSize(t){for(this.max=t;this.order.length>this.max;){const t=this._getAndRemoveByKey(this.order[0]);t&&this.onRemove(t);}return this}filter(t){const e=[];for(const i in this.data)for(const a of this.data[i])t(a.value)||e.push(a);for(const t of e)this.remove(t.value.tileID,t);}}class ct{constructor(){this.state={},this.stateChanges={},this.deletedStates={};}updateState(t,i,a){const s=String(i);if(this.stateChanges[t]=this.stateChanges[t]||{},this.stateChanges[t][s]=this.stateChanges[t][s]||{},e.e(this.stateChanges[t][s],a),null===this.deletedStates[t]){this.deletedStates[t]={};for(const e in this.state[t])e!==s&&(this.deletedStates[t][e]=null);}else if(this.deletedStates[t]&&null===this.deletedStates[t][s]){this.deletedStates[t][s]={};for(const e in this.state[t][s])a[e]||(this.deletedStates[t][s][e]=null);}else for(const e in a)this.deletedStates[t]&&this.deletedStates[t][s]&&null===this.deletedStates[t][s][e]&&delete this.deletedStates[t][s][e];}removeFeatureState(t,e,i){if(null===this.deletedStates[t])return;const a=String(e);if(this.deletedStates[t]=this.deletedStates[t]||{},i&&void 0!==e)null!==this.deletedStates[t][a]&&(this.deletedStates[t][a]=this.deletedStates[t][a]||{},this.deletedStates[t][a][i]=null);else if(void 0!==e)if(this.stateChanges[t]&&this.stateChanges[t][a])for(i in this.deletedStates[t][a]={},this.stateChanges[t][a])this.deletedStates[t][a][i]=null;else this.deletedStates[t][a]=null;else this.deletedStates[t]=null;}getState(t,i){const a=String(i),s=e.e({},(this.state[t]||{})[a],(this.stateChanges[t]||{})[a]);if(null===this.deletedStates[t])return {};if(this.deletedStates[t]){const e=this.deletedStates[t][i];if(null===e)return {};for(const t in e)delete s[t];}return s}initializeTileState(t,e){t.setFeatureState(this.state,e);}coalesceChanges(t,i){const a={};for(const t in this.stateChanges){this.state[t]=this.state[t]||{};const i={};for(const a in this.stateChanges[t])this.state[t][a]||(this.state[t][a]={}),e.e(this.state[t][a],this.stateChanges[t][a]),i[a]=this.state[t][a];a[t]=i;}for(const t in this.deletedStates){this.state[t]=this.state[t]||{};const i={};if(null===this.deletedStates[t])for(const e in this.state[t])i[e]={},this.state[t][e]={};else for(const e in this.deletedStates[t]){if(null===this.deletedStates[t][e])this.state[t][e]={};else for(const i of Object.keys(this.deletedStates[t][e]))delete this.state[t][e][i];i[e]=this.state[t][e];}a[t]=a[t]||{},e.e(a[t],i);}if(this.stateChanges={},this.deletedStates={},0!==Object.keys(a).length)for(const e in t)t[e].setFeatureState(a,i);}}class ut extends e.E{constructor(t,e,i){super(),this.id=t,this.dispatcher=i,this.on("data",(t=>this._dataHandler(t))),this.on("dataloading",(()=>{this._sourceErrored=!1;})),this.on("error",(()=>{this._sourceErrored=this._source.loaded();})),this._source=((t,e,i,a)=>{const s=new(at(e.type))(t,e,i,a);if(s.id!==t)throw new Error(`Expected Source id to be ${t} instead of ${s.id}`);return s})(t,e,i,this),this._tiles={},this._cache=new ht(0,(t=>this._unloadTile(t))),this._timers={},this._cacheTimers={},this._maxTileCacheSize=null,this._maxTileCacheZoomLevels=null,this._loadedParentTiles={},this._coveredTiles={},this._state=new ct,this._didEmitContent=!1,this._updated=!1;}onAdd(t){this.map=t,this._maxTileCacheSize=t?t._maxTileCacheSize:null,this._maxTileCacheZoomLevels=t?t._maxTileCacheZoomLevels:null,this._source&&this._source.onAdd&&this._source.onAdd(t);}onRemove(t){this.clearTiles(),this._source&&this._source.onRemove&&this._source.onRemove(t);}loaded(){if(this._sourceErrored)return !0;if(!this._sourceLoaded)return !1;if(!this._source.loaded())return !1;if(!(void 0===this.used&&void 0===this.usedForTerrain||this.used||this.usedForTerrain))return !0;if(!this._updated)return !1;for(const t in this._tiles){const e=this._tiles[t];if("loaded"!==e.state&&"errored"!==e.state)return !1}return !0}getSource(){return this._source}pause(){this._paused=!0;}resume(){if(!this._paused)return;const t=this._shouldReloadOnResume;this._paused=!1,this._shouldReloadOnResume=!1,t&&this.reload(),this.transform&&this.update(this.transform,this.terrain);}_loadTile(t,i,a){return e._(this,void 0,void 0,(function*(){try{yield this._source.loadTile(t),this._tileLoaded(t,i,a);}catch(i){t.state="errored",404!==i.status?this._source.fire(new e.j(i,{tile:t})):this.update(this.transform,this.terrain);}}))}_unloadTile(t){this._source.unloadTile&&this._source.unloadTile(t);}_abortTile(t){this._source.abortTile&&this._source.abortTile(t),this._source.fire(new e.k("dataabort",{tile:t,coord:t.tileID,dataType:"source"}));}serialize(){return this._source.serialize()}prepare(t){this._source.prepare&&this._source.prepare(),this._state.coalesceChanges(this._tiles,this.map?this.map.painter:null);for(const e in this._tiles){const i=this._tiles[e];i.upload(t),i.prepare(this.map.style.imageManager);}}getIds(){return Object.values(this._tiles).map((t=>t.tileID)).sort(dt).map((t=>t.key))}getRenderableIds(t){const i=[];for(const e in this._tiles)this._isIdRenderable(e,t)&&i.push(this._tiles[e]);return t?i.sort(((t,i)=>{const a=t.tileID,s=i.tileID,o=new e.P(a.canonical.x,a.canonical.y)._rotate(this.transform.angle),r=new e.P(s.canonical.x,s.canonical.y)._rotate(this.transform.angle);return a.overscaledZ-s.overscaledZ||r.y-o.y||r.x-o.x})).map((t=>t.tileID.key)):i.map((t=>t.tileID)).sort(dt).map((t=>t.key))}hasRenderableParent(t){const e=this.findLoadedParent(t,0);return !!e&&this._isIdRenderable(e.tileID.key)}_isIdRenderable(t,e){return this._tiles[t]&&this._tiles[t].hasData()&&!this._coveredTiles[t]&&(e||!this._tiles[t].holdingForFade())}reload(){if(this._paused)this._shouldReloadOnResume=!0;else {this._cache.reset();for(const t in this._tiles)"errored"!==this._tiles[t].state&&this._reloadTile(t,"reloading");}}_reloadTile(t,i){return e._(this,void 0,void 0,(function*(){const e=this._tiles[t];e&&("loading"!==e.state&&(e.state=i),yield this._loadTile(e,t,i));}))}_tileLoaded(t,i,a){t.timeAdded=o.now(),"expired"===a&&(t.refreshedUponExpiration=!0),this._setTileReloadTimer(i,t),"raster-dem"===this.getSource().type&&t.dem&&this._backfillDEM(t),this._state.initializeTileState(t,this.map?this.map.painter:null),t.aborted||this._source.fire(new e.k("data",{dataType:"source",tile:t,coord:t.tileID}));}_backfillDEM(t){const e=this.getRenderableIds();for(let a=0;a<e.length;a++){const s=e[a];if(t.neighboringTiles&&t.neighboringTiles[s]){const e=this.getTileByID(s);i(t,e),i(e,t);}}function i(t,e){t.needsHillshadePrepare=!0,t.needsTerrainPrepare=!0;let i=e.tileID.canonical.x-t.tileID.canonical.x;const a=e.tileID.canonical.y-t.tileID.canonical.y,s=Math.pow(2,t.tileID.canonical.z),o=e.tileID.key;0===i&&0===a||Math.abs(a)>1||(Math.abs(i)>1&&(1===Math.abs(i+s)?i+=s:1===Math.abs(i-s)&&(i-=s)),e.dem&&t.dem&&(t.dem.backfillBorder(e.dem,i,a),t.neighboringTiles&&t.neighboringTiles[o]&&(t.neighboringTiles[o].backfilled=!0)));}}getTile(t){return this.getTileByID(t.key)}getTileByID(t){return this._tiles[t]}_retainLoadedChildren(t,e,i,a){for(const s in this._tiles){let o=this._tiles[s];if(a[s]||!o.hasData()||o.tileID.overscaledZ<=e||o.tileID.overscaledZ>i)continue;let r=o.tileID;for(;o&&o.tileID.overscaledZ>e+1;){const t=o.tileID.scaledTo(o.tileID.overscaledZ-1);o=this._tiles[t.key],o&&o.hasData()&&(r=t);}let n=r;for(;n.overscaledZ>e;)if(n=n.scaledTo(n.overscaledZ-1),t[n.key]){a[r.key]=r;break}}}findLoadedParent(t,e){if(t.key in this._loadedParentTiles){const i=this._loadedParentTiles[t.key];return i&&i.tileID.overscaledZ>=e?i:null}for(let i=t.overscaledZ-1;i>=e;i--){const e=t.scaledTo(i),a=this._getLoadedTile(e);if(a)return a}}findLoadedSibling(t){return this._getLoadedTile(t)}_getLoadedTile(t){const e=this._tiles[t.key];return e&&e.hasData()?e:this._cache.getByKey(t.wrapped().key)}updateCacheSize(t){const i=Math.ceil(t.width/this._source.tileSize)+1,a=Math.ceil(t.height/this._source.tileSize)+1,s=Math.floor(i*a*(null===this._maxTileCacheZoomLevels?e.a.MAX_TILE_CACHE_ZOOM_LEVELS:this._maxTileCacheZoomLevels)),o="number"==typeof this._maxTileCacheSize?Math.min(this._maxTileCacheSize,s):s;this._cache.setMaxSize(o);}handleWrapJump(t){const e=Math.round((t-(void 0===this._prevLng?t:this._prevLng))/360);if(this._prevLng=t,e){const t={};for(const i in this._tiles){const a=this._tiles[i];a.tileID=a.tileID.unwrapTo(a.tileID.wrap+e),t[a.tileID.key]=a;}this._tiles=t;for(const t in this._timers)clearTimeout(this._timers[t]),delete this._timers[t];for(const t in this._tiles)this._setTileReloadTimer(t,this._tiles[t]);}}_updateCoveredAndRetainedTiles(t,e,i,a,s,r){const n={},l={},h=Object.keys(t),c=o.now();for(const i of h){const a=t[i],s=this._tiles[i];if(!s||0!==s.fadeEndTime&&s.fadeEndTime<=c)continue;const o=this.findLoadedParent(a,e),r=this.findLoadedSibling(a),h=o||r||null;h&&(this._addTile(h.tileID),n[h.tileID.key]=h.tileID),l[i]=a;}this._retainLoadedChildren(l,a,i,t);for(const e in n)t[e]||(this._coveredTiles[e]=!0,t[e]=n[e]);if(r){const e={},i={};for(const t of s)this._tiles[t.key].hasData()?e[t.key]=t:i[t.key]=t;for(const a in i){const s=i[a].children(this._source.maxzoom);this._tiles[s[0].key]&&this._tiles[s[1].key]&&this._tiles[s[2].key]&&this._tiles[s[3].key]&&(e[s[0].key]=t[s[0].key]=s[0],e[s[1].key]=t[s[1].key]=s[1],e[s[2].key]=t[s[2].key]=s[2],e[s[3].key]=t[s[3].key]=s[3],delete i[a]);}for(const a in i){const s=i[a],o=this.findLoadedParent(s,this._source.minzoom),r=this.findLoadedSibling(s),n=o||r||null;if(n){e[n.tileID.key]=t[n.tileID.key]=n.tileID;for(const t in e)e[t].isChildOf(n.tileID)&&delete e[t];}}for(const t in this._tiles)e[t]||(this._coveredTiles[t]=!0);}}update(t,i){if(!this._sourceLoaded||this._paused)return;let a;this.transform=t,this.terrain=i,this.updateCacheSize(t),this.handleWrapJump(this.transform.center.lng),this._coveredTiles={},this.used||this.usedForTerrain?this._source.tileID?a=t.getVisibleUnwrappedCoordinates(this._source.tileID).map((t=>new e.S(t.canonical.z,t.wrap,t.canonical.z,t.canonical.x,t.canonical.y))):(a=t.coveringTiles({tileSize:this.usedForTerrain?this.tileSize:this._source.tileSize,minzoom:this._source.minzoom,maxzoom:this._source.maxzoom,roundZoom:!this.usedForTerrain&&this._source.roundZoom,reparseOverscaled:this._source.reparseOverscaled,terrain:i}),this._source.hasTile&&(a=a.filter((t=>this._source.hasTile(t))))):a=[];const s=t.coveringZoomLevel(this._source),o=Math.max(s-ut.maxOverzooming,this._source.minzoom),r=Math.max(s+ut.maxUnderzooming,this._source.minzoom);if(this.usedForTerrain){const t={};for(const e of a)if(e.canonical.z>this._source.minzoom){const i=e.scaledTo(e.canonical.z-1);t[i.key]=i;const a=e.scaledTo(Math.max(this._source.minzoom,Math.min(e.canonical.z,5)));t[a.key]=a;}a=a.concat(Object.values(t));}const n=0===a.length&&!this._updated&&this._didEmitContent;this._updated=!0,n&&this.fire(new e.k("data",{sourceDataType:"idle",dataType:"source",sourceId:this.id}));const l=this._updateRetainedTiles(a,s);_t(this._source.type)&&this._updateCoveredAndRetainedTiles(l,o,r,s,a,i);for(const t in l)this._tiles[t].clearFadeHold();const h=e.ab(this._tiles,l);for(const t of h){const e=this._tiles[t];e.hasSymbolBuckets&&!e.holdingForFade()?e.setHoldDuration(this.map._fadeDuration):e.hasSymbolBuckets&&!e.symbolFadeFinished()||this._removeTile(t);}this._updateLoadedParentTileCache(),this._updateLoadedSiblingTileCache();}releaseSymbolFadeTiles(){for(const t in this._tiles)this._tiles[t].holdingForFade()&&this._removeTile(t);}_updateRetainedTiles(t,e){var i;const a={},s={},o=Math.max(e-ut.maxOverzooming,this._source.minzoom),r=Math.max(e+ut.maxUnderzooming,this._source.minzoom),n={};for(const i of t){const t=this._addTile(i);a[i.key]=i,t.hasData()||e<this._source.maxzoom&&(n[i.key]=i);}this._retainLoadedChildren(n,e,r,a);for(const r of t){let t=this._tiles[r.key];if(t.hasData())continue;if(e+1>this._source.maxzoom){const t=r.children(this._source.maxzoom)[0],e=this.getTile(t);if(e&&e.hasData()){a[t.key]=t;continue}}else {const t=r.children(this._source.maxzoom);if(a[t[0].key]&&a[t[1].key]&&a[t[2].key]&&a[t[3].key])continue}let n=t.wasRequested();for(let e=r.overscaledZ-1;e>=o;--e){const o=r.scaledTo(e);if(s[o.key])break;if(s[o.key]=!0,t=this.getTile(o),!t&&n&&(t=this._addTile(o)),t){const e=t.hasData();if((e||!(null===(i=this.map)||void 0===i?void 0:i.cancelPendingTileRequestsWhileZooming)||n)&&(a[o.key]=o),n=t.wasRequested(),e)break}}}return a}_updateLoadedParentTileCache(){this._loadedParentTiles={};for(const t in this._tiles){const e=[];let i,a=this._tiles[t].tileID;for(;a.overscaledZ>0;){if(a.key in this._loadedParentTiles){i=this._loadedParentTiles[a.key];break}e.push(a.key);const t=a.scaledTo(a.overscaledZ-1);if(i=this._getLoadedTile(t),i)break;a=t;}for(const t of e)this._loadedParentTiles[t]=i;}}_updateLoadedSiblingTileCache(){this._loadedSiblingTiles={};for(const t in this._tiles){const e=this._tiles[t].tileID,i=this._getLoadedTile(e);this._loadedSiblingTiles[e.key]=i;}}_addTile(t){let i=this._tiles[t.key];if(i)return i;i=this._cache.getAndRemove(t),i&&(this._setTileReloadTimer(t.key,i),i.tileID=t,this._state.initializeTileState(i,this.map?this.map.painter:null),this._cacheTimers[t.key]&&(clearTimeout(this._cacheTimers[t.key]),delete this._cacheTimers[t.key],this._setTileReloadTimer(t.key,i)));const a=i;return i||(i=new lt(t,this._source.tileSize*t.overscaleFactor()),this._loadTile(i,t.key,i.state)),i.uses++,this._tiles[t.key]=i,a||this._source.fire(new e.k("dataloading",{tile:i,coord:i.tileID,dataType:"source"})),i}_setTileReloadTimer(t,e){t in this._timers&&(clearTimeout(this._timers[t]),delete this._timers[t]);const i=e.getExpiryTimeout();i&&(this._timers[t]=setTimeout((()=>{this._reloadTile(t,"expired"),delete this._timers[t];}),i));}_removeTile(t){const e=this._tiles[t];e&&(e.uses--,delete this._tiles[t],this._timers[t]&&(clearTimeout(this._timers[t]),delete this._timers[t]),e.uses>0||(e.hasData()&&"reloading"!==e.state?this._cache.add(e.tileID,e,e.getExpiryTimeout()):(e.aborted=!0,this._abortTile(e),this._unloadTile(e))));}_dataHandler(t){const e=t.sourceDataType;"source"===t.dataType&&"metadata"===e&&(this._sourceLoaded=!0),this._sourceLoaded&&!this._paused&&"source"===t.dataType&&"content"===e&&(this.reload(),this.transform&&this.update(this.transform,this.terrain),this._didEmitContent=!0);}clearTiles(){this._shouldReloadOnResume=!1,this._paused=!1;for(const t in this._tiles)this._removeTile(t);this._cache.reset();}tilesIn(t,i,a){const s=[],o=this.transform;if(!o)return s;const r=a?o.getCameraQueryGeometry(t):t,n=t.map((t=>o.pointCoordinate(t,this.terrain))),l=r.map((t=>o.pointCoordinate(t,this.terrain))),h=this.getIds();let c=1/0,u=1/0,d=-1/0,_=-1/0;for(const t of l)c=Math.min(c,t.x),u=Math.min(u,t.y),d=Math.max(d,t.x),_=Math.max(_,t.y);for(let t=0;t<h.length;t++){const a=this._tiles[h[t]];if(a.holdingForFade())continue;const r=a.tileID,p=Math.pow(2,o.zoom-a.tileID.overscaledZ),m=i*a.queryPadding*e.X/a.tileSize/p,f=[r.getTilePoint(new e.Z(c,u)),r.getTilePoint(new e.Z(d,_))];if(f[0].x-m<e.X&&f[0].y-m<e.X&&f[1].x+m>=0&&f[1].y+m>=0){const t=n.map((t=>r.getTilePoint(t))),e=l.map((t=>r.getTilePoint(t)));s.push({tile:a,tileID:r,queryGeometry:t,cameraQueryGeometry:e,scale:p});}}return s}getVisibleCoordinates(t){const e=this.getRenderableIds(t).map((t=>this._tiles[t].tileID));for(const t of e)t.posMatrix=this.transform.calculatePosMatrix(t.toUnwrapped());return e}hasTransition(){if(this._source.hasTransition())return !0;if(_t(this._source.type)){const t=o.now();for(const e in this._tiles)if(this._tiles[e].fadeEndTime>=t)return !0}return !1}setFeatureState(t,e,i){this._state.updateState(t=t||"_geojsonTileLayer",e,i);}removeFeatureState(t,e,i){this._state.removeFeatureState(t=t||"_geojsonTileLayer",e,i);}getFeatureState(t,e){return this._state.getState(t=t||"_geojsonTileLayer",e)}setDependencies(t,e,i){const a=this._tiles[t];a&&a.setDependencies(e,i);}reloadTilesForDependencies(t,e){for(const i in this._tiles)this._tiles[i].hasDependency(t,e)&&this._reloadTile(i,"reloading");this._cache.filter((i=>!i.hasDependency(t,e)));}}function dt(t,e){const i=Math.abs(2*t.wrap)-+(t.wrap<0),a=Math.abs(2*e.wrap)-+(e.wrap<0);return t.overscaledZ-e.overscaledZ||a-i||e.canonical.y-t.canonical.y||e.canonical.x-t.canonical.x}function _t(t){return "raster"===t||"image"===t||"video"===t}ut.maxOverzooming=10,ut.maxUnderzooming=3;class pt{constructor(t,e){this.reset(t,e);}reset(t,e){this.points=t||[],this._distances=[0];for(let t=1;t<this.points.length;t++)this._distances[t]=this._distances[t-1]+this.points[t].dist(this.points[t-1]);this.length=this._distances[this._distances.length-1],this.padding=Math.min(e||0,.5*this.length),this.paddedLength=this.length-2*this.padding;}lerp(t){if(1===this.points.length)return this.points[0];t=e.ac(t,0,1);let i=1,a=this._distances[i];const s=t*this.paddedLength+this.padding;for(;a<s&&i<this._distances.length;)a=this._distances[++i];const o=i-1,r=this._distances[o],n=a-r,l=n>0?(s-r)/n:0;return this.points[o].mult(1-l).add(this.points[i].mult(l))}}function mt(t,e){let i=!0;return "always"===t||"never"!==t&&"never"!==e||(i=!1),i}class ft{constructor(t,e,i){const a=this.boxCells=[],s=this.circleCells=[];this.xCellCount=Math.ceil(t/i),this.yCellCount=Math.ceil(e/i);for(let t=0;t<this.xCellCount*this.yCellCount;t++)a.push([]),s.push([]);this.circleKeys=[],this.boxKeys=[],this.bboxes=[],this.circles=[],this.width=t,this.height=e,this.xScale=this.xCellCount/t,this.yScale=this.yCellCount/e,this.boxUid=0,this.circleUid=0;}keysLength(){return this.boxKeys.length+this.circleKeys.length}insert(t,e,i,a,s){this._forEachCell(e,i,a,s,this._insertBoxCell,this.boxUid++),this.boxKeys.push(t),this.bboxes.push(e),this.bboxes.push(i),this.bboxes.push(a),this.bboxes.push(s);}insertCircle(t,e,i,a){this._forEachCell(e-a,i-a,e+a,i+a,this._insertCircleCell,this.circleUid++),this.circleKeys.push(t),this.circles.push(e),this.circles.push(i),this.circles.push(a);}_insertBoxCell(t,e,i,a,s,o){this.boxCells[s].push(o);}_insertCircleCell(t,e,i,a,s,o){this.circleCells[s].push(o);}_query(t,e,i,a,s,o,r){if(i<0||t>this.width||a<0||e>this.height)return [];const n=[];if(t<=0&&e<=0&&this.width<=i&&this.height<=a){if(s)return [{key:null,x1:t,y1:e,x2:i,y2:a}];for(let t=0;t<this.boxKeys.length;t++)n.push({key:this.boxKeys[t],x1:this.bboxes[4*t],y1:this.bboxes[4*t+1],x2:this.bboxes[4*t+2],y2:this.bboxes[4*t+3]});for(let t=0;t<this.circleKeys.length;t++){const e=this.circles[3*t],i=this.circles[3*t+1],a=this.circles[3*t+2];n.push({key:this.circleKeys[t],x1:e-a,y1:i-a,x2:e+a,y2:i+a});}}else this._forEachCell(t,e,i,a,this._queryCell,n,{hitTest:s,overlapMode:o,seenUids:{box:{},circle:{}}},r);return n}query(t,e,i,a){return this._query(t,e,i,a,!1,null)}hitTest(t,e,i,a,s,o){return this._query(t,e,i,a,!0,s,o).length>0}hitTestCircle(t,e,i,a,s){const o=t-i,r=t+i,n=e-i,l=e+i;if(r<0||o>this.width||l<0||n>this.height)return !1;const h=[];return this._forEachCell(o,n,r,l,this._queryCellCircle,h,{hitTest:!0,overlapMode:a,circle:{x:t,y:e,radius:i},seenUids:{box:{},circle:{}}},s),h.length>0}_queryCell(t,e,i,a,s,o,r,n){const{seenUids:l,hitTest:h,overlapMode:c}=r,u=this.boxCells[s];if(null!==u){const s=this.bboxes;for(const r of u)if(!l.box[r]){l.box[r]=!0;const u=4*r,d=this.boxKeys[r];if(t<=s[u+2]&&e<=s[u+3]&&i>=s[u+0]&&a>=s[u+1]&&(!n||n(d))&&(!h||!mt(c,d.overlapMode))&&(o.push({key:d,x1:s[u],y1:s[u+1],x2:s[u+2],y2:s[u+3]}),h))return !0}}const d=this.circleCells[s];if(null!==d){const s=this.circles;for(const r of d)if(!l.circle[r]){l.circle[r]=!0;const u=3*r,d=this.circleKeys[r];if(this._circleAndRectCollide(s[u],s[u+1],s[u+2],t,e,i,a)&&(!n||n(d))&&(!h||!mt(c,d.overlapMode))){const t=s[u],e=s[u+1],i=s[u+2];if(o.push({key:d,x1:t-i,y1:e-i,x2:t+i,y2:e+i}),h)return !0}}}return !1}_queryCellCircle(t,e,i,a,s,o,r,n){const{circle:l,seenUids:h,overlapMode:c}=r,u=this.boxCells[s];if(null!==u){const t=this.bboxes;for(const e of u)if(!h.box[e]){h.box[e]=!0;const i=4*e,a=this.boxKeys[e];if(this._circleAndRectCollide(l.x,l.y,l.radius,t[i+0],t[i+1],t[i+2],t[i+3])&&(!n||n(a))&&!mt(c,a.overlapMode))return o.push(!0),!0}}const d=this.circleCells[s];if(null!==d){const t=this.circles;for(const e of d)if(!h.circle[e]){h.circle[e]=!0;const i=3*e,a=this.circleKeys[e];if(this._circlesCollide(t[i],t[i+1],t[i+2],l.x,l.y,l.radius)&&(!n||n(a))&&!mt(c,a.overlapMode))return o.push(!0),!0}}}_forEachCell(t,e,i,a,s,o,r,n){const l=this._convertToXCellCoord(t),h=this._convertToYCellCoord(e),c=this._convertToXCellCoord(i),u=this._convertToYCellCoord(a);for(let d=l;d<=c;d++)for(let l=h;l<=u;l++)if(s.call(this,t,e,i,a,this.xCellCount*l+d,o,r,n))return}_convertToXCellCoord(t){return Math.max(0,Math.min(this.xCellCount-1,Math.floor(t*this.xScale)))}_convertToYCellCoord(t){return Math.max(0,Math.min(this.yCellCount-1,Math.floor(t*this.yScale)))}_circlesCollide(t,e,i,a,s,o){const r=a-t,n=s-e,l=i+o;return l*l>r*r+n*n}_circleAndRectCollide(t,e,i,a,s,o,r){const n=(o-a)/2,l=Math.abs(t-(a+n));if(l>n+i)return !1;const h=(r-s)/2,c=Math.abs(e-(s+h));if(c>h+i)return !1;if(l<=n||c<=h)return !0;const u=l-n,d=c-h;return u*u+d*d<=i*i}}function gt(t,i,a,s,o){const r=e.H();return i?(e.K(r,r,[1/o,1/o,1]),a||e.ad(r,r,s.angle)):e.L(r,s.labelPlaneMatrix,t),r}function vt(t,i,a,s,o){if(i){const i=e.ae(t);return e.K(i,i,[o,o,1]),a||e.ad(i,i,-s.angle),i}return s.glCoordMatrix}function xt(t,i,a){let s;a?(s=[t.x,t.y,a(t.x,t.y),1],e.af(s,s,i)):(s=[t.x,t.y,0,1],function(t,e,i){const a=e[0],s=e[1];t[0]=i[0]*a+i[4]*s+i[12],t[1]=i[1]*a+i[5]*s+i[13],t[3]=i[3]*a+i[7]*s+i[15];}(s,s,i));const o=s[3];return {point:new e.P(s[0]/o,s[1]/o),signedDistanceFromCamera:o,isOccluded:!1}}function yt(t,e){return .5+t/e*.5}function bt(t,e){return t.x>=-e[0]&&t.x<=e[0]&&t.y>=-e[1]&&t.y<=e[1]}function wt(t,i,a,s,o,r,n,l,h,c,u,d,_,p,m){const f=s?t.textSizeData:t.iconSizeData,g=e.ag(f,a.transform.zoom),v=[256/a.width*2+1,256/a.height*2+1],x=s?t.text.dynamicLayoutVertexArray:t.icon.dynamicLayoutVertexArray;x.clear();const y=t.lineVertexArray,b=s?t.text.placedSymbolArray:t.icon.placedSymbolArray,w=a.transform.width/a.transform.height;let T=!1;for(let s=0;s<b.length;s++){const I=b.get(s);if(I.hidden||I.writingMode===e.ah.vertical&&!T){Rt(I.numGlyphs,x);continue}T=!1;const E=xt(new e.P(I.anchorX,I.anchorY),i,m);if(!bt(E.point,v)){Rt(I.numGlyphs,x);continue}const P=yt(a.transform.cameraToCenterDistance,E.signedDistanceFromCamera),C=e.ai(f,g,I),S=n?C/P:C*P,z={getElevation:m,labelPlaneMatrix:o,lineVertexArray:y,pitchWithMap:n,projectionCache:{projections:{},offsets:{},cachedAnchorPoint:void 0,anyProjectionOccluded:!1},projection:c,tileAnchorPoint:new e.P(I.anchorX,I.anchorY),unwrappedTileID:u,width:d,height:_,translation:p},D=Et(z,I,S,!1,l,i,r,t.glyphOffsetArray,x,w,h);T=D.useVertical,(D.notEnoughRoom||T||D.needsFlipping&&Et(z,I,S,!0,l,i,r,t.glyphOffsetArray,x,w,h).notEnoughRoom)&&Rt(I.numGlyphs,x);}s?t.text.dynamicLayoutVertexBuffer.updateData(x):t.icon.dynamicLayoutVertexBuffer.updateData(x);}function Tt(t,e,i,a,s,o,r,n){const l=o.glyphStartIndex+o.numGlyphs,h=o.lineStartIndex,c=o.lineStartIndex+o.lineLength,u=e.getoffsetX(o.glyphStartIndex),d=e.getoffsetX(l-1),_=Mt(t*u,i,a,s,o.segment,h,c,n,r);if(!_)return null;const p=Mt(t*d,i,a,s,o.segment,h,c,n,r);return p?n.projectionCache.anyProjectionOccluded?null:{first:_,last:p}:null}function It(t,i,a,s){return t===e.ah.horizontal&&Math.abs(a.y-i.y)>Math.abs(a.x-i.x)*s?{useVertical:!0}:(t===e.ah.vertical?i.y<a.y:i.x>a.x)?{needsFlipping:!0}:null}function Et(t,i,a,s,o,r,n,l,h,c,u){const d=a/24,_=i.lineOffsetX*d,p=i.lineOffsetY*d;let m;if(i.numGlyphs>1){const e=i.glyphStartIndex+i.numGlyphs,a=i.lineStartIndex,r=i.lineStartIndex+i.lineLength,h=Tt(d,l,_,p,s,i,u,t);if(!h)return {notEnoughRoom:!0};const f=xt(h.first.point,n,t.getElevation).point,g=xt(h.last.point,n,t.getElevation).point;if(o&&!s){const t=It(i.writingMode,f,g,c);if(t)return t}m=[h.first];for(let o=i.glyphStartIndex+1;o<e-1;o++)m.push(Mt(d*l.getoffsetX(o),_,p,s,i.segment,a,r,t,u));m.push(h.last);}else {if(o&&!s){const a=xt(t.tileAnchorPoint,r,t.getElevation).point,s=i.lineStartIndex+i.segment+1,o=new e.P(t.lineVertexArray.getx(s),t.lineVertexArray.gety(s)),n=xt(o,r,t.getElevation),l=n.signedDistanceFromCamera>0?n.point:function(t,e,i,a,s,o){return Pt(t,e,i,1,s,o)}(t.tileAnchorPoint,o,a,0,r,t),h=It(i.writingMode,a,l,c);if(h)return h}const a=Mt(d*l.getoffsetX(i.glyphStartIndex),_,p,s,i.segment,i.lineStartIndex,i.lineStartIndex+i.lineLength,t,u);if(!a||t.projectionCache.anyProjectionOccluded)return {notEnoughRoom:!0};m=[a];}for(const t of m)e.aj(h,t.point,t.angle);return {}}function Pt(t,e,i,a,s,o){const r=t.add(t.sub(e)._unit()),n=void 0!==s?xt(r,s,o.getElevation).point:St(r.x,r.y,o).point,l=i.sub(n);return i.add(l._mult(a/l.mag()))}function Ct(t,i,a){const s=i.projectionCache;if(s.projections[t])return s.projections[t];const o=new e.P(i.lineVertexArray.getx(t),i.lineVertexArray.gety(t)),r=St(o.x,o.y,i);if(r.signedDistanceFromCamera>0)return s.projections[t]=r.point,s.anyProjectionOccluded=s.anyProjectionOccluded||r.isOccluded,r.point;const n=t-a.direction;return function(t,e,i,a,s){return Pt(t,e,i,a,void 0,s)}(0===a.distanceFromAnchor?i.tileAnchorPoint:new e.P(i.lineVertexArray.getx(n),i.lineVertexArray.gety(n)),o,a.previousVertex,a.absOffsetX-a.distanceFromAnchor+1,i)}function St(t,i,a){const s=t+a.translation[0],o=i+a.translation[1];let r;return !a.pitchWithMap&&a.projection.useSpecialProjectionForSymbols?(r=a.projection.projectTileCoordinates(s,o,a.unwrappedTileID,a.getElevation),r.point.x=(.5*r.point.x+.5)*a.width,r.point.y=(.5*-r.point.y+.5)*a.height):(r=xt(new e.P(s,o),a.labelPlaneMatrix,a.getElevation),r.isOccluded=!1),r}function zt(t,e,i){return t._unit()._perp()._mult(e*i)}function Dt(t,i,a,s,o,r,n,l,h){if(l.projectionCache.offsets[t])return l.projectionCache.offsets[t];const c=a.add(i);if(t+h.direction<s||t+h.direction>=o)return l.projectionCache.offsets[t]=c,c;const u=Ct(t+h.direction,l,h),d=zt(u.sub(a),n,h.direction),_=a.add(d),p=u.add(d);return l.projectionCache.offsets[t]=e.ak(r,c,_,p)||c,l.projectionCache.offsets[t]}function Mt(t,e,i,a,s,o,r,n,l){const h=a?t-e:t+e;let c=h>0?1:-1,u=0;a&&(c*=-1,u=Math.PI),c<0&&(u+=Math.PI);let d,_=c>0?o+s:o+s+1;n.projectionCache.cachedAnchorPoint?d=n.projectionCache.cachedAnchorPoint:(d=St(n.tileAnchorPoint.x,n.tileAnchorPoint.y,n).point,n.projectionCache.cachedAnchorPoint=d);let p,m,f=d,g=d,v=0,x=0;const y=Math.abs(h),b=[];let w;for(;v+x<=y;){if(_+=c,_<o||_>=r)return null;v+=x,g=f,m=p;const t={absOffsetX:y,direction:c,distanceFromAnchor:v,previousVertex:g};if(f=Ct(_,n,t),0===i)b.push(g),w=f.sub(g);else {let e;const a=f.sub(g);e=0===a.mag()?zt(Ct(_+c,n,t).sub(f),i,c):zt(a,i,c),m||(m=g.add(e)),p=Dt(_,e,f,o,r,m,i,n,t),b.push(m),w=p.sub(m);}x=w.mag();}const T=w._mult((y-v)/x)._add(m||g),I=u+Math.atan2(f.y-g.y,f.x-g.x);return b.push(T),{point:T,angle:l?I:0,path:b}}const At=new Float32Array([-1/0,-1/0,0,-1/0,-1/0,0,-1/0,-1/0,0,-1/0,-1/0,0]);function Rt(t,e){for(let i=0;i<t;i++){const t=e.length;e.resize(t+4),e.float32.set(At,3*t);}}const kt=100;class Lt{constructor(t,e,i=new ft(t.width+200,t.height+200,25),a=new ft(t.width+200,t.height+200,25)){this.transform=t,this.mapProjection=e,this.grid=i,this.ignoredGrid=a,this.pitchFactor=Math.cos(t._pitch)*t.cameraToCenterDistance,this.screenRightBoundary=t.width+kt,this.screenBottomBoundary=t.height+kt,this.gridRightBoundary=t.width+200,this.gridBottomBoundary=t.height+200,this.perspectiveRatioCutoff=.6;}placeCollisionBox(t,e,i,a,s,o,r,n,l,h,c){const u=t.anchorPointX+n[0],d=t.anchorPointY+n[1],_=this.projectAndGetPerspectiveRatio(a,u,d,s,h),p=this._projectCollisionBox(t,i,a,s,o,r,n,_,h,c),[m,f,g,v]=p.box;return this.mapProjection.useSpecialProjectionForSymbols&&(o?p.allPointsOccluded:this.mapProjection.isOccluded(u,d,s))||_.perspectiveRatio<this.perspectiveRatioCutoff||!this.isInsideGrid(m,f,g,v)||"always"!==e&&this.grid.hitTest(m,f,g,v,e,l)?{box:[m,f,g,v],placeable:!1,offscreen:!1}:{box:[m,f,g,v],placeable:!0,offscreen:this.isOffscreen(m,f,g,v)}}placeCollisionCircles(t,i,a,s,o,r,n,l,h,c,u,d,_,p,m,f){const g=[],v=new e.P(i.anchorX,i.anchorY),x=this.getPerspectiveRatio(r,v.x,v.y,n,f),y=(u?o/x:o*x)/e.ap,b={getElevation:f,labelPlaneMatrix:l,lineVertexArray:a,pitchWithMap:u,projectionCache:{projections:{},offsets:{},cachedAnchorPoint:void 0,anyProjectionOccluded:!1},projection:this.mapProjection,tileAnchorPoint:v,unwrappedTileID:n,width:this.transform.width,height:this.transform.height,translation:m},w=Tt(y,s,i.lineOffsetX*y,i.lineOffsetY*y,!1,i,!1,b);let T=!1,I=!1,E=!0;if(w){const i=.5*_*x+p,a=new e.P(-100,-100),s=new e.P(this.screenRightBoundary,this.screenBottomBoundary),o=new pt,r=w.first,n=w.last;let l=[];for(let t=r.path.length-1;t>=1;t--)l.push(r.path[t]);for(let t=1;t<n.path.length;t++)l.push(n.path[t]);const u=2.5*i;if(h){const t=this.projectPathToScreenSpace(l,b,h);l=t.some((t=>t.signedDistanceFromCamera<=0))?[]:t.map((t=>t.point));}let m=[];if(l.length>0){const t=l[0].clone(),i=l[0].clone();for(let e=1;e<l.length;e++)t.x=Math.min(t.x,l[e].x),t.y=Math.min(t.y,l[e].y),i.x=Math.max(i.x,l[e].x),i.y=Math.max(i.y,l[e].y);m=t.x>=a.x&&i.x<=s.x&&t.y>=a.y&&i.y<=s.y?[l]:i.x<a.x||t.x>s.x||i.y<a.y||t.y>s.y?[]:e.al([l],a.x,a.y,s.x,s.y);}for(const e of m){o.reset(e,.25*i);let a=0;a=o.length<=.5*i?1:Math.ceil(o.paddedLength/u)+1;for(let e=0;e<a;e++){const s=e/Math.max(a-1,1),r=o.lerp(s),n=r.x+kt,l=r.y+kt;g.push(n,l,i,0);const h=n-i,u=l-i,_=n+i,p=l+i;if(E=E&&this.isOffscreen(h,u,_,p),I=I||this.isInsideGrid(h,u,_,p),"always"!==t&&this.grid.hitTestCircle(n,l,i,t,d)&&(T=!0,!c))return {circles:[],offscreen:!1,collisionDetected:T}}}}return {circles:!c&&T||!I||x<this.perspectiveRatioCutoff?[]:g,offscreen:E,collisionDetected:T}}projectPathToScreenSpace(t,e,i){return t.map((t=>xt(t,i,e.getElevation)))}queryRenderedSymbols(t){if(0===t.length||0===this.grid.keysLength()&&0===this.ignoredGrid.keysLength())return {};const i=[];let a=1/0,s=1/0,o=-1/0,r=-1/0;for(const n of t){const t=new e.P(n.x+kt,n.y+kt);a=Math.min(a,t.x),s=Math.min(s,t.y),o=Math.max(o,t.x),r=Math.max(r,t.y),i.push(t);}const n=this.grid.query(a,s,o,r).concat(this.ignoredGrid.query(a,s,o,r)),l={},h={};for(const t of n){const a=t.key;if(void 0===l[a.bucketInstanceId]&&(l[a.bucketInstanceId]={}),l[a.bucketInstanceId][a.featureIndex])continue;const s=[new e.P(t.x1,t.y1),new e.P(t.x2,t.y1),new e.P(t.x2,t.y2),new e.P(t.x1,t.y2)];e.am(i,s)&&(l[a.bucketInstanceId][a.featureIndex]=!0,void 0===h[a.bucketInstanceId]&&(h[a.bucketInstanceId]=[]),h[a.bucketInstanceId].push(a.featureIndex));}return h}insertCollisionBox(t,e,i,a,s,o){(i?this.ignoredGrid:this.grid).insert({bucketInstanceId:a,featureIndex:s,collisionGroupID:o,overlapMode:e},t[0],t[1],t[2],t[3]);}insertCollisionCircles(t,e,i,a,s,o){const r=i?this.ignoredGrid:this.grid,n={bucketInstanceId:a,featureIndex:s,collisionGroupID:o,overlapMode:e};for(let e=0;e<t.length;e+=4)r.insertCircle(n,t[e],t[e+1],t[e+2]);}projectAndGetPerspectiveRatio(t,i,a,s,o){const r=this.mapProjection.useSpecialProjectionForSymbols?this.mapProjection.projectTileCoordinates(i,a,s,o):xt(new e.P(i,a),t,o);return {point:new e.P((r.point.x+1)/2*this.transform.width+kt,(1-r.point.y)/2*this.transform.height+kt),perspectiveRatio:.5+this.transform.cameraToCenterDistance/r.signedDistanceFromCamera*.5,isOccluded:r.isOccluded,signedDistanceFromCamera:r.signedDistanceFromCamera}}getPerspectiveRatio(t,i,a,s,o){const r=this.mapProjection.useSpecialProjectionForSymbols?this.mapProjection.projectTileCoordinates(i,a,s,o):xt(new e.P(i,a),t,o);return .5+this.transform.cameraToCenterDistance/r.signedDistanceFromCamera*.5}isOffscreen(t,e,i,a){return i<kt||t>=this.screenRightBoundary||a<kt||e>this.screenBottomBoundary}isInsideGrid(t,e,i,a){return i>=0&&t<this.gridRightBoundary&&a>=0&&e<this.gridBottomBoundary}getViewportMatrix(){const t=e.an([]);return e.J(t,t,[-100,-100,0]),t}_projectCollisionBox(t,i,a,s,o,r,n,l,h,c){const u=i*l.perspectiveRatio;let d=new e.P(1,0),_=new e.P(0,1);const p=new e.P(t.anchorPointX+n[0],t.anchorPointY+n[1]);if(r&&!o){const t=this.projectAndGetPerspectiveRatio(a,p.x+1,p.y,s,h).point.sub(l.point).unit(),i=Math.atan(t.y/t.x)+(t.x<0?Math.PI:0),o=Math.sin(i),r=Math.cos(i);d=new e.P(r,o),_=new e.P(-o,r);}else if(!r&&o){const t=-this.transform.angle,i=Math.sin(t),a=Math.cos(t);d=new e.P(a,i),_=new e.P(-i,a);}let m=l.point,f=u;if(o){m=p;const t=this.transform.zoom-Math.floor(this.transform.zoom);f=Math.pow(2,-t),f*=this.mapProjection.getPitchedTextCorrection(this.transform,p,s),c||(f*=e.ac(.5+l.signedDistanceFromCamera/this.transform.cameraToCenterDistance*.5,0,4));}c&&(m=m.add(d.mult(c.x*f)).add(_.mult(c.y*f)));const g=t.x1*f,v=t.x2*f,x=(g+v)/2,y=t.y1*f,b=t.y2*f,w=(y+b)/2,T=[{offsetX:g,offsetY:y},{offsetX:x,offsetY:y},{offsetX:v,offsetY:y},{offsetX:v,offsetY:w},{offsetX:v,offsetY:b},{offsetX:x,offsetY:b},{offsetX:g,offsetY:b},{offsetX:g,offsetY:w}];let I=[];for(const{offsetX:t,offsetY:i}of T)I.push(new e.P(m.x+d.x*t+_.x*i,m.y+d.y*t+_.y*i));let E=!1;if(o){const t=I.map((t=>this.projectAndGetPerspectiveRatio(a,t.x,t.y,s,h)));E=t.some((t=>!t.isOccluded)),I=t.map((t=>t.point));}else E=!0;return {box:e.ao(I),allPointsOccluded:!E}}}function Ft(t,i,a){return i*(e.X/(t.tileSize*Math.pow(2,a-t.tileID.overscaledZ)))}class Bt{constructor(t,e,i,a){this.opacity=t?Math.max(0,Math.min(1,t.opacity+(t.placed?e:-e))):a&&i?1:0,this.placed=i;}isHidden(){return 0===this.opacity&&!this.placed}}class Ot{constructor(t,e,i,a,s){this.text=new Bt(t?t.text:null,e,i,s),this.icon=new Bt(t?t.icon:null,e,a,s);}isHidden(){return this.text.isHidden()&&this.icon.isHidden()}}class Nt{constructor(t,e,i){this.text=t,this.icon=e,this.skipFade=i;}}class jt{constructor(){this.invProjMatrix=e.H(),this.viewportMatrix=e.H(),this.circles=[];}}class Ut{constructor(t,e,i,a,s){this.bucketInstanceId=t,this.featureIndex=e,this.sourceLayerIndex=i,this.bucketIndex=a,this.tileID=s;}}class Zt{constructor(t){this.crossSourceCollisions=t,this.maxGroupID=0,this.collisionGroups={};}get(t){if(this.crossSourceCollisions)return {ID:0,predicate:null};if(!this.collisionGroups[t]){const e=++this.maxGroupID;this.collisionGroups[t]={ID:e,predicate:t=>t.collisionGroupID===e};}return this.collisionGroups[t]}}function qt(t,i,a,s,o){const{horizontalAlign:r,verticalAlign:n}=e.au(t);return new e.P(-(r-.5)*i+s[0]*o,-(n-.5)*a+s[1]*o)}class Vt{constructor(t,e,i,a,s,o){this.transform=t.clone(),this.terrain=i,this.collisionIndex=new Lt(this.transform,e),this.placements={},this.opacities={},this.variableOffsets={},this.stale=!1,this.commitTime=0,this.fadeDuration=a,this.retainedQueryData={},this.collisionGroups=new Zt(s),this.collisionCircleArrays={},this.collisionBoxArrays=new Map,this.prevPlacement=o,o&&(o.prevPlacement=void 0),this.placedOrientations={};}_getTerrainElevationFunc(t){const e=this.terrain;return e?(i,a)=>e.getElevation(t,i,a):null}getBucketParts(t,i,a,s){const o=a.getBucket(i),r=a.latestFeatureIndex;if(!o||!r||i.id!==o.layerIds[0])return;const n=a.collisionBoxArray,l=o.layers[0].layout,h=o.layers[0].paint,c=Math.pow(2,this.transform.zoom-a.tileID.overscaledZ),u=a.tileSize/e.X,d=a.tileID.toUnwrapped(),_=this.transform.calculatePosMatrix(d),p="map"===l.get("text-pitch-alignment"),m="map"===l.get("text-rotation-alignment"),f=Ft(a,1,this.transform.zoom),g=this.collisionIndex.mapProjection.translatePosition(this.transform,a,h.get("text-translate"),h.get("text-translate-anchor")),v=this.collisionIndex.mapProjection.translatePosition(this.transform,a,h.get("icon-translate"),h.get("icon-translate-anchor")),x=gt(_,p,m,this.transform,f);let y=null;if(p){const t=vt(_,p,m,this.transform,f);y=e.L([],this.transform.labelPlaneMatrix,t);}this.retainedQueryData[o.bucketInstanceId]=new Ut(o.bucketInstanceId,r,o.sourceLayerIndex,o.index,a.tileID);const b={bucket:o,layout:l,translationText:g,translationIcon:v,posMatrix:_,unwrappedTileID:d,textLabelPlaneMatrix:x,labelToScreenMatrix:y,scale:c,textPixelRatio:u,holdingForFade:a.holdingForFade(),collisionBoxArray:n,partiallyEvaluatedTextSize:e.ag(o.textSizeData,this.transform.zoom),collisionGroup:this.collisionGroups.get(o.sourceID)};if(s)for(const e of o.sortKeyRanges){const{sortKey:i,symbolInstanceStart:a,symbolInstanceEnd:s}=e;t.push({sortKey:i,symbolInstanceStart:a,symbolInstanceEnd:s,parameters:b});}else t.push({symbolInstanceStart:0,symbolInstanceEnd:o.symbolInstances.length,parameters:b});}attemptAnchorPlacement(t,i,a,s,o,r,n,l,h,c,u,d,_,p,m,f,g,v,x){const y=e.aq[t.textAnchor],b=[t.textOffset0,t.textOffset1],w=qt(y,a,s,b,o),T=this.collisionIndex.placeCollisionBox(i,d,l,h,c,n,r,f,u.predicate,x,w);if((!v||this.collisionIndex.placeCollisionBox(v,d,l,h,c,n,r,g,u.predicate,x,w).placeable)&&T.placeable){let t;if(this.prevPlacement&&this.prevPlacement.variableOffsets[_.crossTileID]&&this.prevPlacement.placements[_.crossTileID]&&this.prevPlacement.placements[_.crossTileID].text&&(t=this.prevPlacement.variableOffsets[_.crossTileID].anchor),0===_.crossTileID)throw new Error("symbolInstance.crossTileID can't be 0");return this.variableOffsets[_.crossTileID]={textOffset:b,width:a,height:s,anchor:y,textBoxScale:o,prevAnchor:t},this.markUsedJustification(p,y,_,m),p.allowVerticalPlacement&&(this.markUsedOrientation(p,m,_),this.placedOrientations[_.crossTileID]=m),{shift:w,placedGlyphBoxes:T}}}placeLayerBucketPart(t,i,a){const{bucket:s,layout:o,translationText:r,translationIcon:n,posMatrix:l,unwrappedTileID:h,textLabelPlaneMatrix:c,labelToScreenMatrix:u,textPixelRatio:d,holdingForFade:_,collisionBoxArray:p,partiallyEvaluatedTextSize:m,collisionGroup:f}=t.parameters,g=o.get("text-optional"),v=o.get("icon-optional"),x=e.ar(o,"text-overlap","text-allow-overlap"),y="always"===x,b=e.ar(o,"icon-overlap","icon-allow-overlap"),w="always"===b,T="map"===o.get("text-rotation-alignment"),I="map"===o.get("text-pitch-alignment"),E="none"!==o.get("icon-text-fit"),P="viewport-y"===o.get("symbol-z-order"),C=y&&(w||!s.hasIconData()||v),S=w&&(y||!s.hasTextData()||g);!s.collisionArrays&&p&&s.deserializeCollisionBoxes(p);const z=this._getTerrainElevationFunc(this.retainedQueryData[s.bucketInstanceId].tileID),D=(t,p,w)=>{var P,D;if(i[t.crossTileID])return;if(_)return void(this.placements[t.crossTileID]=new Nt(!1,!1,!1));let M=!1,A=!1,R=!0,k=null,L={box:null,placeable:!1,offscreen:null},F={box:null,placeable:!1,offscreen:null},B=null,O=null,N=null,j=0,U=0,Z=0;p.textFeatureIndex?j=p.textFeatureIndex:t.useRuntimeCollisionCircles&&(j=t.featureIndex),p.verticalTextFeatureIndex&&(U=p.verticalTextFeatureIndex);const q=p.textBox;if(q){const i=i=>{let a=e.ah.horizontal;if(s.allowVerticalPlacement&&!i&&this.prevPlacement){const e=this.prevPlacement.placedOrientations[t.crossTileID];e&&(this.placedOrientations[t.crossTileID]=e,a=e,this.markUsedOrientation(s,a,t));}return a},o=(i,a)=>{if(s.allowVerticalPlacement&&t.numVerticalGlyphVertices>0&&p.verticalTextBox){for(const t of s.writingModes)if(t===e.ah.vertical?(L=a(),F=L):L=i(),L&&L.placeable)break}else L=i();},c=t.textAnchorOffsetStartIndex,u=t.textAnchorOffsetEndIndex;if(u===c){const a=(e,i)=>{const a=this.collisionIndex.placeCollisionBox(e,x,d,l,h,I,T,r,f.predicate,z);return a&&a.placeable&&(this.markUsedOrientation(s,i,t),this.placedOrientations[t.crossTileID]=i),a};o((()=>a(q,e.ah.horizontal)),(()=>{const i=p.verticalTextBox;return s.allowVerticalPlacement&&t.numVerticalGlyphVertices>0&&i?a(i,e.ah.vertical):{box:null,offscreen:null}})),i(L&&L.placeable);}else {let _=e.aq[null===(D=null===(P=this.prevPlacement)||void 0===P?void 0:P.variableOffsets[t.crossTileID])||void 0===D?void 0:D.anchor];const m=(i,o,p)=>{const m=i.x2-i.x1,g=i.y2-i.y1,v=t.textBoxScale,y=E&&"never"===b?o:null;let w=null,P="never"===x?1:2,C="never";_&&P++;for(let e=0;e<P;e++){for(let e=c;e<u;e++){const a=s.textAnchorOffsets.get(e);if(_&&a.textAnchor!==_)continue;const o=this.attemptAnchorPlacement(a,i,m,g,v,T,I,d,l,h,f,C,t,s,p,r,n,y,z);if(o&&(w=o.placedGlyphBoxes,w&&w.placeable))return M=!0,k=o.shift,w}_?_=null:C=x;}return a&&!w&&(w={box:this.collisionIndex.placeCollisionBox(q,"always",d,l,h,I,T,r,f.predicate,z,new e.P(0,0)).box,offscreen:!1,placeable:!1}),w};o((()=>m(q,p.iconBox,e.ah.horizontal)),(()=>{const i=p.verticalTextBox;return s.allowVerticalPlacement&&(!L||!L.placeable)&&t.numVerticalGlyphVertices>0&&i?m(i,p.verticalIconBox,e.ah.vertical):{box:null,occluded:!0,offscreen:null}})),L&&(M=L.placeable,R=L.offscreen);const g=i(L&&L.placeable);if(!M&&this.prevPlacement){const e=this.prevPlacement.variableOffsets[t.crossTileID];e&&(this.variableOffsets[t.crossTileID]=e,this.markUsedJustification(s,e.anchor,t,g));}}}if(B=L,M=B&&B.placeable,R=B&&B.offscreen,t.useRuntimeCollisionCircles){const i=s.text.placedSymbolArray.get(t.centerJustifiedTextSymbolIndex),n=e.ai(s.textSizeData,m,i),d=o.get("text-padding");O=this.collisionIndex.placeCollisionCircles(x,i,s.lineVertexArray,s.glyphOffsetArray,n,l,h,c,u,a,I,f.predicate,t.collisionCircleDiameter,d,r,z),O.circles.length&&O.collisionDetected&&!a&&e.w("Collisions detected, but collision boxes are not shown"),M=y||O.circles.length>0&&!O.collisionDetected,R=R&&O.offscreen;}if(p.iconFeatureIndex&&(Z=p.iconFeatureIndex),p.iconBox){const t=t=>this.collisionIndex.placeCollisionBox(t,b,d,l,h,I,T,n,f.predicate,z,E&&k?k:void 0);F&&F.placeable&&p.verticalIconBox?(N=t(p.verticalIconBox),A=N.placeable):(N=t(p.iconBox),A=N.placeable),R=R&&N.offscreen;}const V=g||0===t.numHorizontalGlyphVertices&&0===t.numVerticalGlyphVertices,G=v||0===t.numIconVertices;V||G?G?V||(A=A&&M):M=A&&M:A=M=A&&M;const H=A&&N.placeable;if(M&&B.placeable&&this.collisionIndex.insertCollisionBox(B.box,x,o.get("text-ignore-placement"),s.bucketInstanceId,F&&F.placeable&&U?U:j,f.ID),H&&this.collisionIndex.insertCollisionBox(N.box,b,o.get("icon-ignore-placement"),s.bucketInstanceId,Z,f.ID),O&&M&&this.collisionIndex.insertCollisionCircles(O.circles,x,o.get("text-ignore-placement"),s.bucketInstanceId,j,f.ID),a&&this.storeCollisionData(s.bucketInstanceId,w,p,B,N,O),0===t.crossTileID)throw new Error("symbolInstance.crossTileID can't be 0");if(0===s.bucketInstanceId)throw new Error("bucket.bucketInstanceId can't be 0");this.placements[t.crossTileID]=new Nt(M||C,A||S,R||s.justReloaded),i[t.crossTileID]=!0;};if(P){if(0!==t.symbolInstanceStart)throw new Error("bucket.bucketInstanceId should be 0");const e=s.getSortedSymbolIndexes(this.transform.angle);for(let t=e.length-1;t>=0;--t){const i=e[t];D(s.symbolInstances.get(i),s.collisionArrays[i],i);}}else for(let e=t.symbolInstanceStart;e<t.symbolInstanceEnd;e++)D(s.symbolInstances.get(e),s.collisionArrays[e],e);if(a&&s.bucketInstanceId in this.collisionCircleArrays){const t=this.collisionCircleArrays[s.bucketInstanceId];e.as(t.invProjMatrix,l),t.viewportMatrix=this.collisionIndex.getViewportMatrix();}s.justReloaded=!1;}storeCollisionData(t,e,i,a,s,o){if(i.textBox||i.iconBox){let o,r;this.collisionBoxArrays.has(t)?o=this.collisionBoxArrays.get(t):(o=new Map,this.collisionBoxArrays.set(t,o)),o.has(e)?r=o.get(e):(r={text:null,icon:null},o.set(e,r)),i.textBox&&(r.text=a.box),i.iconBox&&(r.icon=s.box);}if(o){let e=this.collisionCircleArrays[t];void 0===e&&(e=this.collisionCircleArrays[t]=new jt);for(let t=0;t<o.circles.length;t+=4)e.circles.push(o.circles[t+0]),e.circles.push(o.circles[t+1]),e.circles.push(o.circles[t+2]),e.circles.push(o.collisionDetected?1:0);}}markUsedJustification(t,i,a,s){let o;o=s===e.ah.vertical?a.verticalPlacedTextSymbolIndex:{left:a.leftJustifiedTextSymbolIndex,center:a.centerJustifiedTextSymbolIndex,right:a.rightJustifiedTextSymbolIndex}[e.at(i)];const r=[a.leftJustifiedTextSymbolIndex,a.centerJustifiedTextSymbolIndex,a.rightJustifiedTextSymbolIndex,a.verticalPlacedTextSymbolIndex];for(const e of r)e>=0&&(t.text.placedSymbolArray.get(e).crossTileID=o>=0&&e!==o?0:a.crossTileID);}markUsedOrientation(t,i,a){const s=i===e.ah.horizontal||i===e.ah.horizontalOnly?i:0,o=i===e.ah.vertical?i:0,r=[a.leftJustifiedTextSymbolIndex,a.centerJustifiedTextSymbolIndex,a.rightJustifiedTextSymbolIndex];for(const e of r)t.text.placedSymbolArray.get(e).placedOrientation=s;a.verticalPlacedTextSymbolIndex&&(t.text.placedSymbolArray.get(a.verticalPlacedTextSymbolIndex).placedOrientation=o);}commit(t){this.commitTime=t,this.zoomAtLastRecencyCheck=this.transform.zoom;const e=this.prevPlacement;let i=!1;this.prevZoomAdjustment=e?e.zoomAdjustment(this.transform.zoom):0;const a=e?e.symbolFadeChange(t):1,s=e?e.opacities:{},o=e?e.variableOffsets:{},r=e?e.placedOrientations:{};for(const t in this.placements){const e=this.placements[t],o=s[t];o?(this.opacities[t]=new Ot(o,a,e.text,e.icon),i=i||e.text!==o.text.placed||e.icon!==o.icon.placed):(this.opacities[t]=new Ot(null,a,e.text,e.icon,e.skipFade),i=i||e.text||e.icon);}for(const t in s){const e=s[t];if(!this.opacities[t]){const s=new Ot(e,a,!1,!1);s.isHidden()||(this.opacities[t]=s,i=i||e.text.placed||e.icon.placed);}}for(const t in o)this.variableOffsets[t]||!this.opacities[t]||this.opacities[t].isHidden()||(this.variableOffsets[t]=o[t]);for(const t in r)this.placedOrientations[t]||!this.opacities[t]||this.opacities[t].isHidden()||(this.placedOrientations[t]=r[t]);if(e&&void 0===e.lastPlacementChangeTime)throw new Error("Last placement time for previous placement is not defined");i?this.lastPlacementChangeTime=t:"number"!=typeof this.lastPlacementChangeTime&&(this.lastPlacementChangeTime=e?e.lastPlacementChangeTime:t);}updateLayerOpacities(t,e){const i={};for(const a of e){const e=a.getBucket(t);e&&a.latestFeatureIndex&&t.id===e.layerIds[0]&&this.updateBucketOpacities(e,a.tileID,i,a.collisionBoxArray);}}updateBucketOpacities(t,i,a,s){t.hasTextData()&&(t.text.opacityVertexArray.clear(),t.text.hasVisibleVertices=!1),t.hasIconData()&&(t.icon.opacityVertexArray.clear(),t.icon.hasVisibleVertices=!1),t.hasIconCollisionBoxData()&&t.iconCollisionBox.collisionVertexArray.clear(),t.hasTextCollisionBoxData()&&t.textCollisionBox.collisionVertexArray.clear();const o=t.layers[0],r=o.layout,n=new Ot(null,0,!1,!1,!0),l=r.get("text-allow-overlap"),h=r.get("icon-allow-overlap"),c=o._unevaluatedLayout.hasValue("text-variable-anchor")||o._unevaluatedLayout.hasValue("text-variable-anchor-offset"),u="map"===r.get("text-rotation-alignment"),d="map"===r.get("text-pitch-alignment"),_="none"!==r.get("icon-text-fit"),p=new Ot(null,0,l&&(h||!t.hasIconData()||r.get("icon-optional")),h&&(l||!t.hasTextData()||r.get("text-optional")),!0);!t.collisionArrays&&s&&(t.hasIconCollisionBoxData()||t.hasTextCollisionBoxData())&&t.deserializeCollisionBoxes(s);const m=(t,e,i)=>{for(let a=0;a<e/4;a++)t.opacityVertexArray.emplaceBack(i);t.hasVisibleVertices=t.hasVisibleVertices||i!==te;},f=this.collisionBoxArrays.get(t.bucketInstanceId);for(let i=0;i<t.symbolInstances.length;i++){const s=t.symbolInstances.get(i),{numHorizontalGlyphVertices:o,numVerticalGlyphVertices:r,crossTileID:l}=s;let h=this.opacities[l];a[l]?h=n:h||(h=p,this.opacities[l]=h),a[l]=!0;const g=s.numIconVertices>0,v=this.placedOrientations[s.crossTileID],x=v===e.ah.vertical,y=v===e.ah.horizontal||v===e.ah.horizontalOnly;if(o>0||r>0){const e=Qt(h.text);m(t.text,o,x?te:e),m(t.text,r,y?te:e);const i=h.text.isHidden();[s.rightJustifiedTextSymbolIndex,s.centerJustifiedTextSymbolIndex,s.leftJustifiedTextSymbolIndex].forEach((e=>{e>=0&&(t.text.placedSymbolArray.get(e).hidden=i||x?1:0);})),s.verticalPlacedTextSymbolIndex>=0&&(t.text.placedSymbolArray.get(s.verticalPlacedTextSymbolIndex).hidden=i||y?1:0);const a=this.variableOffsets[s.crossTileID];a&&this.markUsedJustification(t,a.anchor,s,v);const n=this.placedOrientations[s.crossTileID];n&&(this.markUsedJustification(t,"left",s,n),this.markUsedOrientation(t,n,s));}if(g){const e=Qt(h.icon),i=!(_&&s.verticalPlacedIconSymbolIndex&&x);s.placedIconSymbolIndex>=0&&(m(t.icon,s.numIconVertices,i?e:te),t.icon.placedSymbolArray.get(s.placedIconSymbolIndex).hidden=h.icon.isHidden()),s.verticalPlacedIconSymbolIndex>=0&&(m(t.icon,s.numVerticalIconVertices,i?te:e),t.icon.placedSymbolArray.get(s.verticalPlacedIconSymbolIndex).hidden=h.icon.isHidden());}const b=f&&f.has(i)?f.get(i):{text:null,icon:null};if(t.hasIconCollisionBoxData()||t.hasTextCollisionBoxData()){const a=t.collisionArrays[i];if(a){let i=new e.P(0,0);if(a.textBox||a.verticalTextBox){let e=!0;if(c){const t=this.variableOffsets[l];t?(i=qt(t.anchor,t.width,t.height,t.textOffset,t.textBoxScale),u&&i._rotate(d?this.transform.angle:-this.transform.angle)):e=!1;}if(a.textBox||a.verticalTextBox){let s;a.textBox&&(s=x),a.verticalTextBox&&(s=y),Gt(t.textCollisionBox.collisionVertexArray,h.text.placed,!e||s,b.text,i.x,i.y);}}if(a.iconBox||a.verticalIconBox){const e=Boolean(!y&&a.verticalIconBox);let s;a.iconBox&&(s=e),a.verticalIconBox&&(s=!e),Gt(t.iconCollisionBox.collisionVertexArray,h.icon.placed,s,b.icon,_?i.x:0,_?i.y:0);}}}}if(t.sortFeatures(this.transform.angle),this.retainedQueryData[t.bucketInstanceId]&&(this.retainedQueryData[t.bucketInstanceId].featureSortOrder=t.featureSortOrder),t.hasTextData()&&t.text.opacityVertexBuffer&&t.text.opacityVertexBuffer.updateData(t.text.opacityVertexArray),t.hasIconData()&&t.icon.opacityVertexBuffer&&t.icon.opacityVertexBuffer.updateData(t.icon.opacityVertexArray),t.hasIconCollisionBoxData()&&t.iconCollisionBox.collisionVertexBuffer&&t.iconCollisionBox.collisionVertexBuffer.updateData(t.iconCollisionBox.collisionVertexArray),t.hasTextCollisionBoxData()&&t.textCollisionBox.collisionVertexBuffer&&t.textCollisionBox.collisionVertexBuffer.updateData(t.textCollisionBox.collisionVertexArray),t.text.opacityVertexArray.length!==t.text.layoutVertexArray.length/4)throw new Error(`bucket.text.opacityVertexArray.length (= ${t.text.opacityVertexArray.length}) !== bucket.text.layoutVertexArray.length (= ${t.text.layoutVertexArray.length}) / 4`);if(t.icon.opacityVertexArray.length!==t.icon.layoutVertexArray.length/4)throw new Error(`bucket.icon.opacityVertexArray.length (= ${t.icon.opacityVertexArray.length}) !== bucket.icon.layoutVertexArray.length (= ${t.icon.layoutVertexArray.length}) / 4`);if(t.bucketInstanceId in this.collisionCircleArrays){const e=this.collisionCircleArrays[t.bucketInstanceId];t.placementInvProjMatrix=e.invProjMatrix,t.placementViewportMatrix=e.viewportMatrix,t.collisionCircleArray=e.circles,delete this.collisionCircleArrays[t.bucketInstanceId];}}symbolFadeChange(t){return 0===this.fadeDuration?1:(t-this.commitTime)/this.fadeDuration+this.prevZoomAdjustment}zoomAdjustment(t){return Math.max(0,(this.transform.zoom-t)/1.5)}hasTransitions(t){return this.stale||t-this.lastPlacementChangeTime<this.fadeDuration}stillRecent(t,e){const i=this.zoomAtLastRecencyCheck===e?1-this.zoomAdjustment(e):1;return this.zoomAtLastRecencyCheck=e,this.commitTime+this.fadeDuration*i>t}setStale(){this.stale=!0;}}function Gt(t,e,i,a,s,o){a&&0!==a.length||(a=[0,0,0,0]);const r=a[0]-kt,n=a[1]-kt,l=a[2]-kt,h=a[3]-kt;t.emplaceBack(e?1:0,i?1:0,s||0,o||0,r,n),t.emplaceBack(e?1:0,i?1:0,s||0,o||0,l,n),t.emplaceBack(e?1:0,i?1:0,s||0,o||0,l,h),t.emplaceBack(e?1:0,i?1:0,s||0,o||0,r,h);}const Ht=Math.pow(2,25),Wt=Math.pow(2,24),$t=Math.pow(2,17),Xt=Math.pow(2,16),Kt=Math.pow(2,9),Jt=Math.pow(2,8),Yt=Math.pow(2,1);function Qt(t){if(0===t.opacity&&!t.placed)return 0;if(1===t.opacity&&t.placed)return 4294967295;const e=t.placed?1:0,i=Math.floor(127*t.opacity);return i*Ht+e*Wt+i*$t+e*Xt+i*Kt+e*Jt+i*Yt+e}const te=0;function ee(){return {isOccluded:(t,e,i)=>!1,getPitchedTextCorrection:(t,e,i)=>1,get useSpecialProjectionForSymbols(){return !1},projectTileCoordinates(t,e,i,a){throw new Error("Not implemented.")},translatePosition:(t,e,i,a)=>function(t,e,i,a,s=!1){if(!i[0]&&!i[1])return [0,0];const o=s?"map"===a?t.angle:0:"viewport"===a?-t.angle:0;if(o){const t=Math.sin(o),e=Math.cos(o);i=[i[0]*e-i[1]*t,i[0]*t+i[1]*e];}return [s?i[0]:Ft(e,i[0],t.zoom),s?i[1]:Ft(e,i[1],t.zoom)]}(t,e,i,a),getCircleRadiusCorrection:t=>1}}class ie{constructor(t){this._sortAcrossTiles="viewport-y"!==t.layout.get("symbol-z-order")&&!t.layout.get("symbol-sort-key").isConstant(),this._currentTileIndex=0,this._currentPartIndex=0,this._seenCrossTileIDs={},this._bucketParts=[];}continuePlacement(t,e,i,a,s){const o=this._bucketParts;for(;this._currentTileIndex<t.length;)if(e.getBucketParts(o,a,t[this._currentTileIndex],this._sortAcrossTiles),this._currentTileIndex++,s())return !0;for(this._sortAcrossTiles&&(this._sortAcrossTiles=!1,o.sort(((t,e)=>t.sortKey-e.sortKey)));this._currentPartIndex<o.length;)if(e.placeLayerBucketPart(o[this._currentPartIndex],this._seenCrossTileIDs,i),this._currentPartIndex++,s())return !0;return !1}}class ae{constructor(t,e,i,a,s,o,r,n){this.placement=new Vt(t,ee(),e,o,r,n),this._currentPlacementIndex=i.length-1,this._forceFullPlacement=a,this._showCollisionBoxes=s,this._done=!1;}isDone(){return this._done}continuePlacement(t,e,i){const a=o.now(),s=()=>!this._forceFullPlacement&&o.now()-a>2;for(;this._currentPlacementIndex>=0;){const a=e[t[this._currentPlacementIndex]],o=this.placement.collisionIndex.transform.zoom;if("symbol"===a.type&&(!a.minzoom||a.minzoom<=o)&&(!a.maxzoom||a.maxzoom>o)){if(this._inProgressLayer||(this._inProgressLayer=new ie(a)),this._inProgressLayer.continuePlacement(i[a.source],this.placement,this._showCollisionBoxes,a,s))return;delete this._inProgressLayer;}this._currentPlacementIndex--;}this._done=!0;}commit(t){return this.placement.commit(t),this.placement}}const se=512/e.X/2;class oe{constructor(t,i,a){this.tileID=t,this.bucketInstanceId=a,this._symbolsByKey={};const s=new Map;for(let t=0;t<i.length;t++){const e=i.get(t),a=e.key,o=s.get(a);o?o.push(e):s.set(a,[e]);}for(const[t,i]of s){const a={positions:i.map((t=>({x:Math.floor(t.anchorX*se),y:Math.floor(t.anchorY*se)}))),crossTileIDs:i.map((t=>t.crossTileID))};if(a.positions.length>128){const t=new e.av(a.positions.length,16,Uint16Array);for(const{x:e,y:i}of a.positions)t.add(e,i);t.finish(),delete a.positions,a.index=t;}this._symbolsByKey[t]=a;}}getScaledCoordinates(t,i){const{x:a,y:s,z:o}=this.tileID.canonical,{x:r,y:n,z:l}=i.canonical,h=se/Math.pow(2,l-o),c=(n*e.X+t.anchorY)*h,u=s*e.X*se;return {x:Math.floor((r*e.X+t.anchorX)*h-a*e.X*se),y:Math.floor(c-u)}}findMatches(t,e,i){const a=this.tileID.canonical.z<e.canonical.z?1:Math.pow(2,this.tileID.canonical.z-e.canonical.z);for(let s=0;s<t.length;s++){const o=t.get(s);if(o.crossTileID)continue;const r=this._symbolsByKey[o.key];if(!r)continue;const n=this.getScaledCoordinates(o,e);if(r.index){const t=r.index.range(n.x-a,n.y-a,n.x+a,n.y+a).sort();for(const e of t){const t=r.crossTileIDs[e];if(!i[t]){i[t]=!0,o.crossTileID=t;break}}}else if(r.positions)for(let t=0;t<r.positions.length;t++){const e=r.positions[t],s=r.crossTileIDs[t];if(Math.abs(e.x-n.x)<=a&&Math.abs(e.y-n.y)<=a&&!i[s]){i[s]=!0,o.crossTileID=s;break}}}}getCrossTileIDsLists(){return Object.values(this._symbolsByKey).map((({crossTileIDs:t})=>t))}}class re{constructor(){this.maxCrossTileID=0;}generate(){return ++this.maxCrossTileID}}class ne{constructor(){this.indexes={},this.usedCrossTileIDs={},this.lng=0;}handleWrapJump(t){const e=Math.round((t-this.lng)/360);if(0!==e)for(const t in this.indexes){const i=this.indexes[t],a={};for(const t in i){const s=i[t];s.tileID=s.tileID.unwrapTo(s.tileID.wrap+e),a[s.tileID.key]=s;}this.indexes[t]=a;}this.lng=t;}addBucket(t,e,i){if(this.indexes[t.overscaledZ]&&this.indexes[t.overscaledZ][t.key]){if(this.indexes[t.overscaledZ][t.key].bucketInstanceId===e.bucketInstanceId)return !1;this.removeBucketCrossTileIDs(t.overscaledZ,this.indexes[t.overscaledZ][t.key]);}for(let t=0;t<e.symbolInstances.length;t++)e.symbolInstances.get(t).crossTileID=0;this.usedCrossTileIDs[t.overscaledZ]||(this.usedCrossTileIDs[t.overscaledZ]={});const a=this.usedCrossTileIDs[t.overscaledZ];for(const i in this.indexes){const s=this.indexes[i];if(Number(i)>t.overscaledZ)for(const i in s){const o=s[i];o.tileID.isChildOf(t)&&o.findMatches(e.symbolInstances,t,a);}else {const o=s[t.scaledTo(Number(i)).key];o&&o.findMatches(e.symbolInstances,t,a);}}for(let t=0;t<e.symbolInstances.length;t++){const s=e.symbolInstances.get(t);s.crossTileID||(s.crossTileID=i.generate(),a[s.crossTileID]=!0);}return void 0===this.indexes[t.overscaledZ]&&(this.indexes[t.overscaledZ]={}),this.indexes[t.overscaledZ][t.key]=new oe(t,e.symbolInstances,e.bucketInstanceId),!0}removeBucketCrossTileIDs(t,e){for(const i of e.getCrossTileIDsLists())for(const e of i)delete this.usedCrossTileIDs[t][e];}removeStaleBuckets(t){let e=!1;for(const i in this.indexes){const a=this.indexes[i];for(const s in a)t[a[s].bucketInstanceId]||(this.removeBucketCrossTileIDs(i,a[s]),delete a[s],e=!0);}return e}}class le{constructor(){this.layerIndexes={},this.crossTileIDs=new re,this.maxBucketInstanceId=0,this.bucketsInCurrentPlacement={};}addLayer(t,e,i){let a=this.layerIndexes[t.id];void 0===a&&(a=this.layerIndexes[t.id]=new ne);let s=!1;const o={};a.handleWrapJump(i);for(const i of e){const e=i.getBucket(t);e&&t.id===e.layerIds[0]&&(e.bucketInstanceId||(e.bucketInstanceId=++this.maxBucketInstanceId),a.addBucket(i.tileID,e,this.crossTileIDs)&&(s=!0),o[e.bucketInstanceId]=!0);}return a.removeStaleBuckets(o)&&(s=!0),s}pruneUnusedLayers(t){const e={};t.forEach((t=>{e[t]=!0;}));for(const t in this.layerIndexes)e[t]||delete this.layerIndexes[t];}}const he=(t,i)=>e.t(t,i&&i.filter((t=>"source.canvas"!==t.identifier))),ce=e.aw();class ue extends e.E{constructor(t,i={}){super(),this._rtlPluginLoaded=()=>{for(const t in this.sourceCaches){const e=this.sourceCaches[t].getSource().type;"vector"!==e&&"geojson"!==e||this.sourceCaches[t].reload();}},this.map=t,this.dispatcher=new j(N(),t._getMapId()),this.dispatcher.registerMessageHandler("GG",((t,e)=>this.getGlyphs(t,e))),this.dispatcher.registerMessageHandler("GI",((t,e)=>this.getImages(t,e))),this.imageManager=new T,this.imageManager.setEventedParent(this),this.glyphManager=new C(t._requestManager,i.localIdeographFontFamily),this.lineAtlas=new R(256,512),this.crossTileSymbolIndex=new le,this._spritesImagesIds={},this._layers={},this._order=[],this.sourceCaches={},this.zoomHistory=new e.ax,this._loaded=!1,this._availableImages=[],this._resetUpdates(),this.dispatcher.broadcast("SR",e.ay()),nt().on(st,this._rtlPluginLoaded),this.on("data",(t=>{if("source"!==t.dataType||"metadata"!==t.sourceDataType)return;const e=this.sourceCaches[t.sourceId];if(!e)return;const i=e.getSource();if(i&&i.vectorLayerIds)for(const t in this._layers){const e=this._layers[t];e.source===i.id&&this._validateLayer(e);}}));}loadURL(t,i={},a){this.fire(new e.k("dataloading",{dataType:"style"})),i.validate="boolean"!=typeof i.validate||i.validate;const s=this.map._requestManager.transformRequest(t,"Style");this._loadStyleRequest=new AbortController;const o=this._loadStyleRequest;e.h(s,this._loadStyleRequest).then((t=>{this._loadStyleRequest=null,this._load(t.data,i,a);})).catch((t=>{this._loadStyleRequest=null,t&&!o.signal.aborted&&this.fire(new e.j(t));}));}loadJSON(t,i={},a){this.fire(new e.k("dataloading",{dataType:"style"})),this._frameRequest=new AbortController,o.frameAsync(this._frameRequest).then((()=>{this._frameRequest=null,i.validate=!1!==i.validate,this._load(t,i,a);})).catch((()=>{}));}loadEmpty(){this.fire(new e.k("dataloading",{dataType:"style"})),this._load(ce,{validate:!1});}_load(t,i,a){var s;const o=i.transformStyle?i.transformStyle(a,t):t;if(!i.validate||!he(this,e.u(o))){this._loaded=!0,this.stylesheet=o;for(const t in o.sources)this.addSource(t,o.sources[t],{validate:!1});o.sprite?this._loadSprite(o.sprite):this.imageManager.setLoaded(!0),this.glyphManager.setURL(o.glyphs),this._createLayers(),this.light=new D(this.stylesheet.light),this.sky=new A(this.stylesheet.sky),this.map.setTerrain(null!==(s=this.stylesheet.terrain)&&void 0!==s?s:null),this.fire(new e.k("data",{dataType:"style"})),this.fire(new e.k("style.load"));}}_createLayers(){const t=e.az(this.stylesheet.layers);this.dispatcher.broadcast("SL",t),this._order=t.map((t=>t.id)),this._layers={},this._serializedLayers=null;for(const i of t){const t=e.aA(i);t.setEventedParent(this,{layer:{id:i.id}}),this._layers[i.id]=t;}}_loadSprite(t,i=!1,a=void 0){let s;this.imageManager.setLoaded(!1),this._spriteRequest=new AbortController,function(t,i,a,s){return e._(this,void 0,void 0,(function*(){const r=x(t),n=a>1?"@2x":"",l={},h={};for(const{id:t,url:a}of r){const o=i.transformRequest(y(a,n,".json"),"SpriteJSON");l[t]=e.h(o,s);const r=i.transformRequest(y(a,n,".png"),"SpriteImage");h[t]=_.getImage(r,s);}return yield Promise.all([...Object.values(l),...Object.values(h)]),function(t,i){return e._(this,void 0,void 0,(function*(){const e={};for(const a in t){e[a]={};const s=o.getImageCanvasContext((yield i[a]).data),r=(yield t[a]).data;for(const t in r){const{width:i,height:o,x:n,y:l,sdf:h,pixelRatio:c,stretchX:u,stretchY:d,content:_,textFitWidth:p,textFitHeight:m}=r[t];e[a][t]={data:null,pixelRatio:c,sdf:h,stretchX:u,stretchY:d,content:_,textFitWidth:p,textFitHeight:m,spriteData:{width:i,height:o,x:n,y:l,context:s}};}}return e}))}(l,h)}))}(t,this.map._requestManager,this.map.getPixelRatio(),this._spriteRequest).then((t=>{if(this._spriteRequest=null,t)for(const e in t){this._spritesImagesIds[e]=[];const a=this._spritesImagesIds[e]?this._spritesImagesIds[e].filter((e=>!(e in t))):[];for(const t of a)this.imageManager.removeImage(t),this._changedImages[t]=!0;for(const a in t[e]){const s="default"===e?a:`${e}:${a}`;this._spritesImagesIds[e].push(s),s in this.imageManager.images?this.imageManager.updateImage(s,t[e][a],!1):this.imageManager.addImage(s,t[e][a]),i&&(this._changedImages[s]=!0);}}})).catch((t=>{this._spriteRequest=null,s=t,this.fire(new e.j(s));})).finally((()=>{this.imageManager.setLoaded(!0),this._availableImages=this.imageManager.listImages(),i&&(this._changed=!0),this.dispatcher.broadcast("SI",this._availableImages),this.fire(new e.k("data",{dataType:"style"})),a&&a(s);}));}_unloadSprite(){for(const t of Object.values(this._spritesImagesIds).flat())this.imageManager.removeImage(t),this._changedImages[t]=!0;this._spritesImagesIds={},this._availableImages=this.imageManager.listImages(),this._changed=!0,this.dispatcher.broadcast("SI",this._availableImages),this.fire(new e.k("data",{dataType:"style"}));}_validateLayer(t){const i=this.sourceCaches[t.source];if(!i)return;const a=t.sourceLayer;if(!a)return;const s=i.getSource();("geojson"===s.type||s.vectorLayerIds&&-1===s.vectorLayerIds.indexOf(a))&&this.fire(new e.j(new Error(`Source layer "${a}" does not exist on source "${s.id}" as specified by style layer "${t.id}".`)));}loaded(){if(!this._loaded)return !1;if(Object.keys(this._updatedSources).length)return !1;for(const t in this.sourceCaches)if(!this.sourceCaches[t].loaded())return !1;return !!this.imageManager.isLoaded()}_serializeByIds(t,i=!1){const a=this._serializedAllLayers();if(!t||0===t.length)return Object.values(i?e.aB(a):a);const s=[];for(const o of t)if(a[o]){const t=i?e.aB(a[o]):a[o];s.push(t);}return s}_serializedAllLayers(){let t=this._serializedLayers;if(t)return t;t=this._serializedLayers={};const e=Object.keys(this._layers);for(const i of e){const e=this._layers[i];"custom"!==e.type&&(t[i]=e.serialize());}return t}hasTransitions(){if(this.light&&this.light.hasTransition())return !0;if(this.sky&&this.sky.hasTransition())return !0;for(const t in this.sourceCaches)if(this.sourceCaches[t].hasTransition())return !0;for(const t in this._layers)if(this._layers[t].hasTransition())return !0;return !1}_checkLoaded(){if(!this._loaded)throw new Error("Style is not done loading.")}update(t){if(!this._loaded)return;const i=this._changed;if(i){const e=Object.keys(this._updatedLayers),i=Object.keys(this._removedLayers);(e.length||i.length)&&this._updateWorkerLayers(e,i);for(const t in this._updatedSources){const e=this._updatedSources[t];if("reload"===e)this._reloadSource(t);else {if("clear"!==e)throw new Error(`Invalid action ${e}`);this._clearSource(t);}}this._updateTilesForChangedImages(),this._updateTilesForChangedGlyphs();for(const e in this._updatedPaintProps)this._layers[e].updateTransitions(t);this.light.updateTransitions(t),this.sky.updateTransitions(t),this._resetUpdates();}const a={};for(const t in this.sourceCaches){const e=this.sourceCaches[t];a[t]=e.used,e.used=!1;}for(const e of this._order){const i=this._layers[e];i.recalculate(t,this._availableImages),!i.isHidden(t.zoom)&&i.source&&(this.sourceCaches[i.source].used=!0);}for(const t in a){const i=this.sourceCaches[t];!!a[t]!=!!i.used&&i.fire(new e.k("data",{sourceDataType:"visibility",dataType:"source",sourceId:t}));}this.light.recalculate(t),this.sky.recalculate(t),this.z=t.zoom,i&&this.fire(new e.k("data",{dataType:"style"}));}_updateTilesForChangedImages(){const t=Object.keys(this._changedImages);if(t.length){for(const e in this.sourceCaches)this.sourceCaches[e].reloadTilesForDependencies(["icons","patterns"],t);this._changedImages={};}}_updateTilesForChangedGlyphs(){if(this._glyphsDidChange){for(const t in this.sourceCaches)this.sourceCaches[t].reloadTilesForDependencies(["glyphs"],[""]);this._glyphsDidChange=!1;}}_updateWorkerLayers(t,e){this.dispatcher.broadcast("UL",{layers:this._serializeByIds(t,!1),removedIds:e});}_resetUpdates(){this._changed=!1,this._updatedLayers={},this._removedLayers={},this._updatedSources={},this._updatedPaintProps={},this._changedImages={},this._glyphsDidChange=!1;}setState(t,i={}){var a;this._checkLoaded();const s=this.serialize();if(t=i.transformStyle?i.transformStyle(s,t):t,(null===(a=i.validate)||void 0===a||a)&&he(this,e.u(t)))return !1;(t=e.aB(t)).layers=e.az(t.layers);const o=e.aC(s,t),r=this._getOperationsToPerform(o);if(r.unimplemented.length>0)throw new Error(`Unimplemented: ${r.unimplemented.join(", ")}.`);if(0===r.operations.length)return !1;for(const t of r.operations)t();return this.stylesheet=t,this._serializedLayers=null,!0}_getOperationsToPerform(t){const e=[],i=[];for(const a of t)switch(a.command){case"setCenter":case"setZoom":case"setBearing":case"setPitch":continue;case"addLayer":e.push((()=>this.addLayer.apply(this,a.args)));break;case"removeLayer":e.push((()=>this.removeLayer.apply(this,a.args)));break;case"setPaintProperty":e.push((()=>this.setPaintProperty.apply(this,a.args)));break;case"setLayoutProperty":e.push((()=>this.setLayoutProperty.apply(this,a.args)));break;case"setFilter":e.push((()=>this.setFilter.apply(this,a.args)));break;case"addSource":e.push((()=>this.addSource.apply(this,a.args)));break;case"removeSource":e.push((()=>this.removeSource.apply(this,a.args)));break;case"setLayerZoomRange":e.push((()=>this.setLayerZoomRange.apply(this,a.args)));break;case"setLight":e.push((()=>this.setLight.apply(this,a.args)));break;case"setGeoJSONSourceData":e.push((()=>this.setGeoJSONSourceData.apply(this,a.args)));break;case"setGlyphs":e.push((()=>this.setGlyphs.apply(this,a.args)));break;case"setSprite":e.push((()=>this.setSprite.apply(this,a.args)));break;case"setSky":e.push((()=>this.setSky.apply(this,a.args)));break;case"setTerrain":e.push((()=>this.map.setTerrain.apply(this,a.args)));break;case"setTransition":e.push((()=>{}));break;default:i.push(a.command);}return {operations:e,unimplemented:i}}addImage(t,i){if(this.getImage(t))return this.fire(new e.j(new Error(`An image named "${t}" already exists.`)));this.imageManager.addImage(t,i),this._afterImageUpdated(t);}updateImage(t,e){this.imageManager.updateImage(t,e);}getImage(t){return this.imageManager.getImage(t)}removeImage(t){if(!this.getImage(t))return this.fire(new e.j(new Error(`An image named "${t}" does not exist.`)));this.imageManager.removeImage(t),this._afterImageUpdated(t);}_afterImageUpdated(t){this._availableImages=this.imageManager.listImages(),this._changedImages[t]=!0,this._changed=!0,this.dispatcher.broadcast("SI",this._availableImages),this.fire(new e.k("data",{dataType:"style"}));}listImages(){return this._checkLoaded(),this.imageManager.listImages()}addSource(t,i,a={}){if(this._checkLoaded(),void 0!==this.sourceCaches[t])throw new Error(`Source "${t}" already exists.`);if(!i.type)throw new Error(`The type property must be defined, but only the following properties were given: ${Object.keys(i).join(", ")}.`);if(["vector","raster","geojson","video","image"].indexOf(i.type)>=0&&this._validate(e.u.source,`sources.${t}`,i,null,a))return;this.map&&this.map._collectResourceTiming&&(i.collectResourceTiming=!0);const s=this.sourceCaches[t]=new ut(t,i,this.dispatcher);s.style=this,s.setEventedParent(this,(()=>({isSourceLoaded:s.loaded(),source:s.serialize(),sourceId:t}))),s.onAdd(this.map),this._changed=!0;}removeSource(t){if(this._checkLoaded(),void 0===this.sourceCaches[t])throw new Error("There is no source with this ID");for(const i in this._layers)if(this._layers[i].source===t)return this.fire(new e.j(new Error(`Source "${t}" cannot be removed while layer "${i}" is using it.`)));const i=this.sourceCaches[t];delete this.sourceCaches[t],delete this._updatedSources[t],i.fire(new e.k("data",{sourceDataType:"metadata",dataType:"source",sourceId:t})),i.setEventedParent(null),i.onRemove(this.map),this._changed=!0;}setGeoJSONSourceData(t,e){if(this._checkLoaded(),void 0===this.sourceCaches[t])throw new Error(`There is no source with this ID=${t}`);const i=this.sourceCaches[t].getSource();if("geojson"!==i.type)throw new Error(`geojsonSource.type is ${i.type}, which is !== 'geojson`);i.setData(e),this._changed=!0;}getSource(t){return this.sourceCaches[t]&&this.sourceCaches[t].getSource()}addLayer(t,i,a={}){this._checkLoaded();const s=t.id;if(this.getLayer(s))return void this.fire(new e.j(new Error(`Layer "${s}" already exists on this map.`)));let o;if("custom"===t.type){if(he(this,e.aD(t)))return;o=e.aA(t);}else {if("source"in t&&"object"==typeof t.source&&(this.addSource(s,t.source),t=e.aB(t),t=e.e(t,{source:s})),this._validate(e.u.layer,`layers.${s}`,t,{arrayIndex:-1},a))return;o=e.aA(t),this._validateLayer(o),o.setEventedParent(this,{layer:{id:s}});}const r=i?this._order.indexOf(i):this._order.length;if(i&&-1===r)this.fire(new e.j(new Error(`Cannot add layer "${s}" before non-existing layer "${i}".`)));else {if(this._order.splice(r,0,s),this._layerOrderChanged=!0,this._layers[s]=o,this._removedLayers[s]&&o.source&&"custom"!==o.type){const t=this._removedLayers[s];delete this._removedLayers[s],t.type!==o.type?this._updatedSources[o.source]="clear":(this._updatedSources[o.source]="reload",this.sourceCaches[o.source].pause());}this._updateLayer(o),o.onAdd&&o.onAdd(this.map);}}moveLayer(t,i){if(this._checkLoaded(),this._changed=!0,!this._layers[t])return void this.fire(new e.j(new Error(`The layer '${t}' does not exist in the map's style and cannot be moved.`)));if(t===i)return;const a=this._order.indexOf(t);this._order.splice(a,1);const s=i?this._order.indexOf(i):this._order.length;i&&-1===s?this.fire(new e.j(new Error(`Cannot move layer "${t}" before non-existing layer "${i}".`))):(this._order.splice(s,0,t),this._layerOrderChanged=!0);}removeLayer(t){this._checkLoaded();const i=this._layers[t];if(!i)return void this.fire(new e.j(new Error(`Cannot remove non-existing layer "${t}".`)));i.setEventedParent(null);const a=this._order.indexOf(t);this._order.splice(a,1),this._layerOrderChanged=!0,this._changed=!0,this._removedLayers[t]=i,delete this._layers[t],this._serializedLayers&&delete this._serializedLayers[t],delete this._updatedLayers[t],delete this._updatedPaintProps[t],i.onRemove&&i.onRemove(this.map);}getLayer(t){return this._layers[t]}getLayersOrder(){return [...this._order]}hasLayer(t){return t in this._layers}setLayerZoomRange(t,i,a){this._checkLoaded();const s=this.getLayer(t);s?s.minzoom===i&&s.maxzoom===a||(null!=i&&(s.minzoom=i),null!=a&&(s.maxzoom=a),this._updateLayer(s)):this.fire(new e.j(new Error(`Cannot set the zoom range of non-existing layer "${t}".`)));}setFilter(t,i,a={}){this._checkLoaded();const s=this.getLayer(t);if(s){if(!e.aE(s.filter,i))return null==i?(s.filter=void 0,void this._updateLayer(s)):void(this._validate(e.u.filter,`layers.${s.id}.filter`,i,null,a)||(s.filter=e.aB(i),this._updateLayer(s)))}else this.fire(new e.j(new Error(`Cannot filter non-existing layer "${t}".`)));}getFilter(t){return e.aB(this.getLayer(t).filter)}setLayoutProperty(t,i,a,s={}){this._checkLoaded();const o=this.getLayer(t);o?e.aE(o.getLayoutProperty(i),a)||(o.setLayoutProperty(i,a,s),this._updateLayer(o)):this.fire(new e.j(new Error(`Cannot style non-existing layer "${t}".`)));}getLayoutProperty(t,i){const a=this.getLayer(t);if(a)return a.getLayoutProperty(i);this.fire(new e.j(new Error(`Cannot get style of non-existing layer "${t}".`)));}setPaintProperty(t,i,a,s={}){this._checkLoaded();const o=this.getLayer(t);o?e.aE(o.getPaintProperty(i),a)||(o.setPaintProperty(i,a,s)&&this._updateLayer(o),this._changed=!0,this._updatedPaintProps[t]=!0,this._serializedLayers=null):this.fire(new e.j(new Error(`Cannot style non-existing layer "${t}".`)));}getPaintProperty(t,e){return this.getLayer(t).getPaintProperty(e)}setFeatureState(t,i){this._checkLoaded();const a=t.source,s=t.sourceLayer,o=this.sourceCaches[a];if(void 0===o)return void this.fire(new e.j(new Error(`The source '${a}' does not exist in the map's style.`)));const r=o.getSource().type;"geojson"===r&&s?this.fire(new e.j(new Error("GeoJSON sources cannot have a sourceLayer parameter."))):"vector"!==r||s?(void 0===t.id&&this.fire(new e.j(new Error("The feature id parameter must be provided."))),o.setFeatureState(s,t.id,i)):this.fire(new e.j(new Error("The sourceLayer parameter must be provided for vector source types.")));}removeFeatureState(t,i){this._checkLoaded();const a=t.source,s=this.sourceCaches[a];if(void 0===s)return void this.fire(new e.j(new Error(`The source '${a}' does not exist in the map's style.`)));const o=s.getSource().type,r="vector"===o?t.sourceLayer:void 0;"vector"!==o||r?i&&"string"!=typeof t.id&&"number"!=typeof t.id?this.fire(new e.j(new Error("A feature id is required to remove its specific state property."))):s.removeFeatureState(r,t.id,i):this.fire(new e.j(new Error("The sourceLayer parameter must be provided for vector source types.")));}getFeatureState(t){this._checkLoaded();const i=t.source,a=t.sourceLayer,s=this.sourceCaches[i];if(void 0!==s)return "vector"!==s.getSource().type||a?(void 0===t.id&&this.fire(new e.j(new Error("The feature id parameter must be provided."))),s.getFeatureState(a,t.id)):void this.fire(new e.j(new Error("The sourceLayer parameter must be provided for vector source types.")));this.fire(new e.j(new Error(`The source '${i}' does not exist in the map's style.`)));}getTransition(){return e.e({duration:300,delay:0},this.stylesheet&&this.stylesheet.transition)}serialize(){if(!this._loaded)return;const t=e.aF(this.sourceCaches,(t=>t.serialize())),i=this._serializeByIds(this._order,!0),a=this.map.getTerrain()||void 0,s=this.stylesheet;return e.aG({version:s.version,name:s.name,metadata:s.metadata,light:s.light,sky:s.sky,center:s.center,zoom:s.zoom,bearing:s.bearing,pitch:s.pitch,sprite:s.sprite,glyphs:s.glyphs,transition:s.transition,sources:t,layers:i,terrain:a},(t=>void 0!==t))}_updateLayer(t){this._updatedLayers[t.id]=!0,t.source&&!this._updatedSources[t.source]&&"raster"!==this.sourceCaches[t.source].getSource().type&&(this._updatedSources[t.source]="reload",this.sourceCaches[t.source].pause()),this._serializedLayers=null,this._changed=!0;}_flattenAndSortRenderedFeatures(t){const e=t=>"fill-extrusion"===this._layers[t].type,i={},a=[];for(let s=this._order.length-1;s>=0;s--){const o=this._order[s];if(e(o)){i[o]=s;for(const e of t){const t=e[o];if(t)for(const e of t)a.push(e);}}}a.sort(((t,e)=>e.intersectionZ-t.intersectionZ));const s=[];for(let o=this._order.length-1;o>=0;o--){const r=this._order[o];if(e(r))for(let t=a.length-1;t>=0;t--){const e=a[t].feature;if(i[e.layer.id]<o)break;s.push(e),a.pop();}else for(const e of t){const t=e[r];if(t)for(const e of t)s.push(e.feature);}}return s}queryRenderedFeatures(t,i,a){i&&i.filter&&this._validate(e.u.filter,"queryRenderedFeatures.filter",i.filter,null,i);const s={};if(i&&i.layers){if(!Array.isArray(i.layers))return this.fire(new e.j(new Error("parameters.layers must be an Array."))),[];for(const t of i.layers){const i=this._layers[t];if(!i)return this.fire(new e.j(new Error(`The layer '${t}' does not exist in the map's style and cannot be queried for features.`))),[];s[i.source]=!0;}}const o=[];i.availableImages=this._availableImages;const r=this._serializedAllLayers();for(const e in this.sourceCaches)i.layers&&!s[e]||o.push(q(this.sourceCaches[e],this._layers,r,t,i,a));return this.placement&&o.push(function(t,e,i,a,s,o,r){const n={},l=o.queryRenderedSymbols(a),h=[];for(const t of Object.keys(l).map(Number))h.push(r[t]);h.sort(V);for(const i of h){const a=i.featureIndex.lookupSymbolFeatures(l[i.bucketInstanceId],e,i.bucketIndex,i.sourceLayerIndex,s.filter,s.layers,s.availableImages,t);for(const t in a){const e=n[t]=n[t]||[],s=a[t];s.sort(((t,e)=>{const a=i.featureSortOrder;if(a){const i=a.indexOf(t.featureIndex);return a.indexOf(e.featureIndex)-i}return e.featureIndex-t.featureIndex}));for(const t of s)e.push(t);}}for(const e in n)n[e].forEach((a=>{const s=a.feature,o=i[t[e].source].getFeatureState(s.layer["source-layer"],s.id);s.source=s.layer.source,s.layer["source-layer"]&&(s.sourceLayer=s.layer["source-layer"]),s.state=o;}));return n}(this._layers,r,this.sourceCaches,t,i,this.placement.collisionIndex,this.placement.retainedQueryData)),this._flattenAndSortRenderedFeatures(o)}querySourceFeatures(t,i){i&&i.filter&&this._validate(e.u.filter,"querySourceFeatures.filter",i.filter,null,i);const a=this.sourceCaches[t];return a?function(t,e){const i=t.getRenderableIds().map((e=>t.getTileByID(e))),a=[],s={};for(let t=0;t<i.length;t++){const o=i[t],r=o.tileID.canonical.key;s[r]||(s[r]=!0,o.querySourceFeatures(a,e));}return a}(a,i):[]}getLight(){return this.light.getLight()}setLight(t,i={}){this._checkLoaded();const a=this.light.getLight();let s=!1;for(const i in t)if(!e.aE(t[i],a[i])){s=!0;break}if(!s)return;const r={now:o.now(),transition:e.e({duration:300,delay:0},this.stylesheet.transition)};this.light.setLight(t,i),this.light.updateTransitions(r);}getSky(){var t;return null===(t=this.stylesheet)||void 0===t?void 0:t.sky}setSky(t,i={}){const a=this.getSky();let s=!1;if(!t&&!a)return;if(t&&!a)s=!0;else if(!t&&a)s=!0;else for(const i in t)if(!e.aE(t[i],a[i])){s=!0;break}if(!s)return;const r={now:o.now(),transition:e.e({duration:300,delay:0},this.stylesheet.transition)};this.stylesheet.sky=t,this.sky.setSky(t,i),this.sky.updateTransitions(r);}_validate(t,i,a,s,o={}){return (!o||!1!==o.validate)&&he(this,t.call(e.u,e.e({key:i,style:this.serialize(),value:a,styleSpec:e.v},s)))}_remove(t=!0){this._frameRequest&&(this._frameRequest.abort(),this._frameRequest=null),this._loadStyleRequest&&(this._loadStyleRequest.abort(),this._loadStyleRequest=null),this._spriteRequest&&(this._spriteRequest.abort(),this._spriteRequest=null),nt().off(st,this._rtlPluginLoaded);for(const t in this._layers)this._layers[t].setEventedParent(null);for(const t in this.sourceCaches){const e=this.sourceCaches[t];e.setEventedParent(null),e.onRemove(this.map);}this.imageManager.setEventedParent(null),this.setEventedParent(null),t&&this.dispatcher.broadcast("RM",void 0),this.dispatcher.remove(t);}_clearSource(t){this.sourceCaches[t].clearTiles();}_reloadSource(t){this.sourceCaches[t].resume(),this.sourceCaches[t].reload();}_updateSources(t){for(const e in this.sourceCaches)this.sourceCaches[e].update(t,this.map.terrain);}_generateCollisionBoxes(){for(const t in this.sourceCaches)this._reloadSource(t);}_updatePlacement(t,e,i,a,s=!1){let r=!1,n=!1;const l={};for(const e of this._order){const i=this._layers[e];if("symbol"!==i.type)continue;if(!l[i.source]){const t=this.sourceCaches[i.source];l[i.source]=t.getRenderableIds(!0).map((e=>t.getTileByID(e))).sort(((t,e)=>e.tileID.overscaledZ-t.tileID.overscaledZ||(t.tileID.isLessThan(e.tileID)?-1:1)));}const a=this.crossTileSymbolIndex.addLayer(i,l[i.source],t.center.lng);r=r||a;}if(this.crossTileSymbolIndex.pruneUnusedLayers(this._order),((s=s||this._layerOrderChanged||0===i)||!this.pauseablePlacement||this.pauseablePlacement.isDone()&&!this.placement.stillRecent(o.now(),t.zoom))&&(this.pauseablePlacement=new ae(t,this.map.terrain,this._order,s,e,i,a,this.placement),this._layerOrderChanged=!1),this.pauseablePlacement.isDone()?this.placement.setStale():(this.pauseablePlacement.continuePlacement(this._order,this._layers,l),this.pauseablePlacement.isDone()&&(this.placement=this.pauseablePlacement.commit(o.now()),n=!0),r&&this.pauseablePlacement.placement.setStale()),n||r)for(const t of this._order){const e=this._layers[t];"symbol"===e.type&&this.placement.updateLayerOpacities(e,l[e.source]);}return !this.pauseablePlacement.isDone()||this.placement.hasTransitions(o.now())}_releaseSymbolFadeTiles(){for(const t in this.sourceCaches)this.sourceCaches[t].releaseSymbolFadeTiles();}getImages(t,i){return e._(this,void 0,void 0,(function*(){const t=yield this.imageManager.getImages(i.icons);this._updateTilesForChangedImages();const e=this.sourceCaches[i.source];return e&&e.setDependencies(i.tileID.key,i.type,i.icons),t}))}getGlyphs(t,i){return e._(this,void 0,void 0,(function*(){const t=yield this.glyphManager.getGlyphs(i.stacks),e=this.sourceCaches[i.source];return e&&e.setDependencies(i.tileID.key,i.type,[""]),t}))}getGlyphsUrl(){return this.stylesheet.glyphs||null}setGlyphs(t,i={}){this._checkLoaded(),t&&this._validate(e.u.glyphs,"glyphs",t,null,i)||(this._glyphsDidChange=!0,this.stylesheet.glyphs=t,this.glyphManager.entries={},this.glyphManager.setURL(t));}addSprite(t,i,a={},s){this._checkLoaded();const o=[{id:t,url:i}],r=[...x(this.stylesheet.sprite),...o];this._validate(e.u.sprite,"sprite",r,null,a)||(this.stylesheet.sprite=r,this._loadSprite(o,!0,s));}removeSprite(t){this._checkLoaded();const i=x(this.stylesheet.sprite);if(i.find((e=>e.id===t))){if(this._spritesImagesIds[t])for(const e of this._spritesImagesIds[t])this.imageManager.removeImage(e),this._changedImages[e]=!0;i.splice(i.findIndex((e=>e.id===t)),1),this.stylesheet.sprite=i.length>0?i:void 0,delete this._spritesImagesIds[t],this._availableImages=this.imageManager.listImages(),this._changed=!0,this.dispatcher.broadcast("SI",this._availableImages),this.fire(new e.k("data",{dataType:"style"}));}else this.fire(new e.j(new Error(`Sprite "${t}" doesn't exists on this map.`)));}getSprite(){return x(this.stylesheet.sprite)}setSprite(t,i={},a){this._checkLoaded(),t&&this._validate(e.u.sprite,"sprite",t,null,i)||(this.stylesheet.sprite=t,t?this._loadSprite(t,!0,a):(this._unloadSprite(),a&&a(null)));}}var de=e.Y([{name:"a_pos",type:"Int16",components:2}]);const _e={prelude:pe("#ifdef GL_ES\nprecision mediump float;\n#else\n#if !defined(lowp)\n#define lowp\n#endif\n#if !defined(mediump)\n#define mediump\n#endif\n#if !defined(highp)\n#define highp\n#endif\n#endif\n","#ifdef GL_ES\nprecision highp float;\n#else\n#if !defined(lowp)\n#define lowp\n#endif\n#if !defined(mediump)\n#define mediump\n#endif\n#if !defined(highp)\n#define highp\n#endif\n#endif\nvec2 unpack_float(const float packedValue) {int packedIntValue=int(packedValue);int v0=packedIntValue/256;return vec2(v0,packedIntValue-v0*256);}vec2 unpack_opacity(const float packedOpacity) {int intOpacity=int(packedOpacity)/2;return vec2(float(intOpacity)/127.0,mod(packedOpacity,2.0));}vec4 decode_color(const vec2 encodedColor) {return vec4(unpack_float(encodedColor[0])/255.0,unpack_float(encodedColor[1])/255.0\n);}float unpack_mix_vec2(const vec2 packedValue,const float t) {return mix(packedValue[0],packedValue[1],t);}vec4 unpack_mix_color(const vec4 packedColors,const float t) {vec4 minColor=decode_color(vec2(packedColors[0],packedColors[1]));vec4 maxColor=decode_color(vec2(packedColors[2],packedColors[3]));return mix(minColor,maxColor,t);}vec2 get_pattern_pos(const vec2 pixel_coord_upper,const vec2 pixel_coord_lower,const vec2 pattern_size,const float tile_units_to_pixels,const vec2 pos) {vec2 offset=mod(mod(mod(pixel_coord_upper,pattern_size)*256.0,pattern_size)*256.0+pixel_coord_lower,pattern_size);return (tile_units_to_pixels*pos+offset)/pattern_size;}\n#ifdef TERRAIN3D\nuniform sampler2D u_terrain;uniform float u_terrain_dim;uniform mat4 u_terrain_matrix;uniform vec4 u_terrain_unpack;uniform float u_terrain_exaggeration;uniform highp sampler2D u_depth;\n#endif\nconst highp vec4 bitSh=vec4(256.*256.*256.,256.*256.,256.,1.);const highp vec4 bitShifts=vec4(1.)/bitSh;highp float unpack(highp vec4 color) {return dot(color,bitShifts);}highp float depthOpacity(vec3 frag) {\n#ifdef TERRAIN3D\nhighp float d=unpack(texture2D(u_depth,frag.xy*0.5+0.5))+0.0001-frag.z;return 1.0-max(0.0,min(1.0,-d*500.0));\n#else\nreturn 1.0;\n#endif\n}float calculate_visibility(vec4 pos) {\n#ifdef TERRAIN3D\nvec3 frag=pos.xyz/pos.w;highp float d=depthOpacity(frag);if (d > 0.95) return 1.0;return (d+depthOpacity(frag+vec3(0.0,0.01,0.0)))/2.0;\n#else\nreturn 1.0;\n#endif\n}float ele(vec2 pos) {\n#ifdef TERRAIN3D\nvec4 rgb=(texture2D(u_terrain,pos)*255.0)*u_terrain_unpack;return rgb.r+rgb.g+rgb.b-u_terrain_unpack.a;\n#else\nreturn 0.0;\n#endif\n}float get_elevation(vec2 pos) {\n#ifdef TERRAIN3D\nvec2 coord=(u_terrain_matrix*vec4(pos,0.0,1.0)).xy*u_terrain_dim+1.0;vec2 f=fract(coord);vec2 c=(floor(coord)+0.5)/(u_terrain_dim+2.0);float d=1.0/(u_terrain_dim+2.0);float tl=ele(c);float tr=ele(c+vec2(d,0.0));float bl=ele(c+vec2(0.0,d));float br=ele(c+vec2(d,d));float elevation=mix(mix(tl,tr,f.x),mix(bl,br,f.x),f.y);return elevation*u_terrain_exaggeration;\n#else\nreturn 0.0;\n#endif\n}"),background:pe("uniform vec4 u_color;uniform float u_opacity;void main() {gl_FragColor=u_color*u_opacity;\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","attribute vec2 a_pos;uniform mat4 u_matrix;void main() {gl_Position=u_matrix*vec4(a_pos,0,1);}"),backgroundPattern:pe("uniform vec2 u_pattern_tl_a;uniform vec2 u_pattern_br_a;uniform vec2 u_pattern_tl_b;uniform vec2 u_pattern_br_b;uniform vec2 u_texsize;uniform float u_mix;uniform float u_opacity;uniform sampler2D u_image;varying vec2 v_pos_a;varying vec2 v_pos_b;void main() {vec2 imagecoord=mod(v_pos_a,1.0);vec2 pos=mix(u_pattern_tl_a/u_texsize,u_pattern_br_a/u_texsize,imagecoord);vec4 color1=texture2D(u_image,pos);vec2 imagecoord_b=mod(v_pos_b,1.0);vec2 pos2=mix(u_pattern_tl_b/u_texsize,u_pattern_br_b/u_texsize,imagecoord_b);vec4 color2=texture2D(u_image,pos2);gl_FragColor=mix(color1,color2,u_mix)*u_opacity;\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","uniform mat4 u_matrix;uniform vec2 u_pattern_size_a;uniform vec2 u_pattern_size_b;uniform vec2 u_pixel_coord_upper;uniform vec2 u_pixel_coord_lower;uniform float u_scale_a;uniform float u_scale_b;uniform float u_tile_units_to_pixels;attribute vec2 a_pos;varying vec2 v_pos_a;varying vec2 v_pos_b;void main() {gl_Position=u_matrix*vec4(a_pos,0,1);v_pos_a=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,u_scale_a*u_pattern_size_a,u_tile_units_to_pixels,a_pos);v_pos_b=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,u_scale_b*u_pattern_size_b,u_tile_units_to_pixels,a_pos);}"),circle:pe("varying vec3 v_data;varying float v_visibility;\n#pragma mapbox: define highp vec4 color\n#pragma mapbox: define mediump float radius\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define highp vec4 stroke_color\n#pragma mapbox: define mediump float stroke_width\n#pragma mapbox: define lowp float stroke_opacity\nvoid main() {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize mediump float radius\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize highp vec4 stroke_color\n#pragma mapbox: initialize mediump float stroke_width\n#pragma mapbox: initialize lowp float stroke_opacity\nvec2 extrude=v_data.xy;float extrude_length=length(extrude);lowp float antialiasblur=v_data.z;float antialiased_blur=-max(blur,antialiasblur);float opacity_t=smoothstep(0.0,antialiased_blur,extrude_length-1.0);float color_t=stroke_width < 0.01 ? 0.0 : smoothstep(antialiased_blur,0.0,extrude_length-radius/(radius+stroke_width));gl_FragColor=v_visibility*opacity_t*mix(color*opacity,stroke_color*stroke_opacity,color_t);\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","uniform mat4 u_matrix;uniform bool u_scale_with_map;uniform bool u_pitch_with_map;uniform vec2 u_extrude_scale;uniform lowp float u_device_pixel_ratio;uniform highp float u_camera_to_center_distance;attribute vec2 a_pos;varying vec3 v_data;varying float v_visibility;\n#pragma mapbox: define highp vec4 color\n#pragma mapbox: define mediump float radius\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define highp vec4 stroke_color\n#pragma mapbox: define mediump float stroke_width\n#pragma mapbox: define lowp float stroke_opacity\nvoid main(void) {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize mediump float radius\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize highp vec4 stroke_color\n#pragma mapbox: initialize mediump float stroke_width\n#pragma mapbox: initialize lowp float stroke_opacity\nvec2 extrude=vec2(mod(a_pos,2.0)*2.0-1.0);vec2 circle_center=floor(a_pos*0.5);float ele=get_elevation(circle_center);v_visibility=calculate_visibility(u_matrix*vec4(circle_center,ele,1.0));if (u_pitch_with_map) {vec2 corner_position=circle_center;if (u_scale_with_map) {corner_position+=extrude*(radius+stroke_width)*u_extrude_scale;} else {vec4 projected_center=u_matrix*vec4(circle_center,0,1);corner_position+=extrude*(radius+stroke_width)*u_extrude_scale*(projected_center.w/u_camera_to_center_distance);}gl_Position=u_matrix*vec4(corner_position,ele,1);} else {gl_Position=u_matrix*vec4(circle_center,ele,1);if (u_scale_with_map) {gl_Position.xy+=extrude*(radius+stroke_width)*u_extrude_scale*u_camera_to_center_distance;} else {gl_Position.xy+=extrude*(radius+stroke_width)*u_extrude_scale*gl_Position.w;}}lowp float antialiasblur=1.0/u_device_pixel_ratio/(radius+stroke_width);v_data=vec3(extrude.x,extrude.y,antialiasblur);}"),clippingMask:pe("void main() {gl_FragColor=vec4(1.0);}","attribute vec2 a_pos;uniform mat4 u_matrix;void main() {gl_Position=u_matrix*vec4(a_pos,0,1);}"),heatmap:pe("uniform highp float u_intensity;varying vec2 v_extrude;\n#pragma mapbox: define highp float weight\n#define GAUSS_COEF 0.3989422804014327\nvoid main() {\n#pragma mapbox: initialize highp float weight\nfloat d=-0.5*3.0*3.0*dot(v_extrude,v_extrude);float val=weight*u_intensity*GAUSS_COEF*exp(d);gl_FragColor=vec4(val,1.0,1.0,1.0);\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","uniform mat4 u_matrix;uniform float u_extrude_scale;uniform float u_opacity;uniform float u_intensity;attribute vec2 a_pos;varying vec2 v_extrude;\n#pragma mapbox: define highp float weight\n#pragma mapbox: define mediump float radius\nconst highp float ZERO=1.0/255.0/16.0;\n#define GAUSS_COEF 0.3989422804014327\nvoid main(void) {\n#pragma mapbox: initialize highp float weight\n#pragma mapbox: initialize mediump float radius\nvec2 unscaled_extrude=vec2(mod(a_pos,2.0)*2.0-1.0);float S=sqrt(-2.0*log(ZERO/weight/u_intensity/GAUSS_COEF))/3.0;v_extrude=S*unscaled_extrude;vec2 extrude=v_extrude*radius*u_extrude_scale;vec4 pos=vec4(floor(a_pos*0.5)+extrude,0,1);gl_Position=u_matrix*pos;}"),heatmapTexture:pe("uniform sampler2D u_image;uniform sampler2D u_color_ramp;uniform float u_opacity;varying vec2 v_pos;void main() {float t=texture2D(u_image,v_pos).r;vec4 color=texture2D(u_color_ramp,vec2(t,0.5));gl_FragColor=color*u_opacity;\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(0.0);\n#endif\n}","uniform mat4 u_matrix;uniform vec2 u_world;attribute vec2 a_pos;varying vec2 v_pos;void main() {gl_Position=u_matrix*vec4(a_pos*u_world,0,1);v_pos.x=a_pos.x;v_pos.y=1.0-a_pos.y;}"),collisionBox:pe("varying float v_placed;varying float v_notUsed;void main() {float alpha=0.5;gl_FragColor=vec4(1.0,0.0,0.0,1.0)*alpha;if (v_placed > 0.5) {gl_FragColor=vec4(0.0,0.0,1.0,0.5)*alpha;}if (v_notUsed > 0.5) {gl_FragColor*=.1;}}","attribute vec2 a_anchor_pos;attribute vec2 a_placed;attribute vec2 a_box_real;uniform mat4 u_matrix;uniform vec2 u_pixel_extrude_scale;varying float v_placed;varying float v_notUsed;vec4 projectTileWithElevation(vec2 posInTile,float elevation) {return u_matrix*vec4(posInTile,elevation,1.0);}void main() {gl_Position=projectTileWithElevation(a_anchor_pos,get_elevation(a_anchor_pos));gl_Position.xy=((a_box_real+0.5)*u_pixel_extrude_scale*2.0-1.0)*vec2(1.0,-1.0)*gl_Position.w;if (gl_Position.z/gl_Position.w < 1.1) {gl_Position.z=0.5;}v_placed=a_placed.x;v_notUsed=a_placed.y;}"),collisionCircle:pe("varying float v_radius;varying vec2 v_extrude;varying float v_perspective_ratio;varying float v_collision;void main() {float alpha=0.5*min(v_perspective_ratio,1.0);float stroke_radius=0.9*max(v_perspective_ratio,1.0);float distance_to_center=length(v_extrude);float distance_to_edge=abs(distance_to_center-v_radius);float opacity_t=smoothstep(-stroke_radius,0.0,-distance_to_edge);vec4 color=mix(vec4(0.0,0.0,1.0,0.5),vec4(1.0,0.0,0.0,1.0),v_collision);gl_FragColor=color*alpha*opacity_t;}","attribute vec2 a_pos;attribute float a_radius;attribute vec2 a_flags;uniform mat4 u_matrix;uniform mat4 u_inv_matrix;uniform vec2 u_viewport_size;uniform float u_camera_to_center_distance;varying float v_radius;varying vec2 v_extrude;varying float v_perspective_ratio;varying float v_collision;vec3 toTilePosition(vec2 screenPos) {vec4 rayStart=u_inv_matrix*vec4(screenPos,-1.0,1.0);vec4 rayEnd  =u_inv_matrix*vec4(screenPos, 1.0,1.0);rayStart.xyz/=rayStart.w;rayEnd.xyz  /=rayEnd.w;highp float t=(0.0-rayStart.z)/(rayEnd.z-rayStart.z);return mix(rayStart.xyz,rayEnd.xyz,t);}void main() {vec2 quadCenterPos=a_pos;float radius=a_radius;float collision=a_flags.x;float vertexIdx=a_flags.y;vec2 quadVertexOffset=vec2(mix(-1.0,1.0,float(vertexIdx >=2.0)),mix(-1.0,1.0,float(vertexIdx >=1.0 && vertexIdx <=2.0)));vec2 quadVertexExtent=quadVertexOffset*radius;vec3 tilePos=toTilePosition(quadCenterPos);vec4 clipPos=u_matrix*vec4(tilePos,1.0);highp float camera_to_anchor_distance=clipPos.w;highp float collision_perspective_ratio=clamp(0.5+0.5*(u_camera_to_center_distance/camera_to_anchor_distance),0.0,4.0);float padding_factor=1.2;v_radius=radius;v_extrude=quadVertexExtent*padding_factor;v_perspective_ratio=collision_perspective_ratio;v_collision=collision;gl_Position=vec4(clipPos.xyz/clipPos.w,1.0)+vec4(quadVertexExtent*padding_factor/u_viewport_size*2.0,0.0,0.0);}"),debug:pe("uniform highp vec4 u_color;uniform sampler2D u_overlay;varying vec2 v_uv;void main() {vec4 overlay_color=texture2D(u_overlay,v_uv);gl_FragColor=mix(u_color,overlay_color,overlay_color.a);}","attribute vec2 a_pos;varying vec2 v_uv;uniform mat4 u_matrix;uniform float u_overlay_scale;void main() {v_uv=a_pos/8192.0;gl_Position=u_matrix*vec4(a_pos*u_overlay_scale,get_elevation(a_pos),1);}"),fill:pe("#pragma mapbox: define highp vec4 color\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize lowp float opacity\ngl_FragColor=color*opacity;\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","attribute vec2 a_pos;uniform mat4 u_matrix;\n#pragma mapbox: define highp vec4 color\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize lowp float opacity\ngl_Position=u_matrix*vec4(a_pos,0,1);}"),fillOutline:pe("varying vec2 v_pos;\n#pragma mapbox: define highp vec4 outline_color\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize highp vec4 outline_color\n#pragma mapbox: initialize lowp float opacity\nfloat dist=length(v_pos-gl_FragCoord.xy);float alpha=1.0-smoothstep(0.0,1.0,dist);gl_FragColor=outline_color*(alpha*opacity);\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","attribute vec2 a_pos;uniform mat4 u_matrix;uniform vec2 u_world;varying vec2 v_pos;\n#pragma mapbox: define highp vec4 outline_color\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize highp vec4 outline_color\n#pragma mapbox: initialize lowp float opacity\ngl_Position=u_matrix*vec4(a_pos,0,1);v_pos=(gl_Position.xy/gl_Position.w+1.0)/2.0*u_world;}"),fillOutlinePattern:pe("uniform vec2 u_texsize;uniform sampler2D u_image;uniform float u_fade;varying vec2 v_pos_a;varying vec2 v_pos_b;varying vec2 v_pos;\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp vec4 pattern_from\n#pragma mapbox: define lowp vec4 pattern_to\nvoid main() {\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump vec4 pattern_from\n#pragma mapbox: initialize mediump vec4 pattern_to\nvec2 pattern_tl_a=pattern_from.xy;vec2 pattern_br_a=pattern_from.zw;vec2 pattern_tl_b=pattern_to.xy;vec2 pattern_br_b=pattern_to.zw;vec2 imagecoord=mod(v_pos_a,1.0);vec2 pos=mix(pattern_tl_a/u_texsize,pattern_br_a/u_texsize,imagecoord);vec4 color1=texture2D(u_image,pos);vec2 imagecoord_b=mod(v_pos_b,1.0);vec2 pos2=mix(pattern_tl_b/u_texsize,pattern_br_b/u_texsize,imagecoord_b);vec4 color2=texture2D(u_image,pos2);float dist=length(v_pos-gl_FragCoord.xy);float alpha=1.0-smoothstep(0.0,1.0,dist);gl_FragColor=mix(color1,color2,u_fade)*alpha*opacity;\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","uniform mat4 u_matrix;uniform vec2 u_world;uniform vec2 u_pixel_coord_upper;uniform vec2 u_pixel_coord_lower;uniform vec3 u_scale;attribute vec2 a_pos;varying vec2 v_pos_a;varying vec2 v_pos_b;varying vec2 v_pos;\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp vec4 pattern_from\n#pragma mapbox: define lowp vec4 pattern_to\n#pragma mapbox: define lowp float pixel_ratio_from\n#pragma mapbox: define lowp float pixel_ratio_to\nvoid main() {\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump vec4 pattern_from\n#pragma mapbox: initialize mediump vec4 pattern_to\n#pragma mapbox: initialize lowp float pixel_ratio_from\n#pragma mapbox: initialize lowp float pixel_ratio_to\nvec2 pattern_tl_a=pattern_from.xy;vec2 pattern_br_a=pattern_from.zw;vec2 pattern_tl_b=pattern_to.xy;vec2 pattern_br_b=pattern_to.zw;float tileRatio=u_scale.x;float fromScale=u_scale.y;float toScale=u_scale.z;gl_Position=u_matrix*vec4(a_pos,0,1);vec2 display_size_a=(pattern_br_a-pattern_tl_a)/pixel_ratio_from;vec2 display_size_b=(pattern_br_b-pattern_tl_b)/pixel_ratio_to;v_pos_a=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,fromScale*display_size_a,tileRatio,a_pos);v_pos_b=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,toScale*display_size_b,tileRatio,a_pos);v_pos=(gl_Position.xy/gl_Position.w+1.0)/2.0*u_world;}"),fillPattern:pe("#ifdef GL_ES\nprecision highp float;\n#endif\nuniform vec2 u_texsize;uniform float u_fade;uniform sampler2D u_image;varying vec2 v_pos_a;varying vec2 v_pos_b;\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp vec4 pattern_from\n#pragma mapbox: define lowp vec4 pattern_to\nvoid main() {\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump vec4 pattern_from\n#pragma mapbox: initialize mediump vec4 pattern_to\nvec2 pattern_tl_a=pattern_from.xy;vec2 pattern_br_a=pattern_from.zw;vec2 pattern_tl_b=pattern_to.xy;vec2 pattern_br_b=pattern_to.zw;vec2 imagecoord=mod(v_pos_a,1.0);vec2 pos=mix(pattern_tl_a/u_texsize,pattern_br_a/u_texsize,imagecoord);vec4 color1=texture2D(u_image,pos);vec2 imagecoord_b=mod(v_pos_b,1.0);vec2 pos2=mix(pattern_tl_b/u_texsize,pattern_br_b/u_texsize,imagecoord_b);vec4 color2=texture2D(u_image,pos2);gl_FragColor=mix(color1,color2,u_fade)*opacity;\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","uniform mat4 u_matrix;uniform vec2 u_pixel_coord_upper;uniform vec2 u_pixel_coord_lower;uniform vec3 u_scale;attribute vec2 a_pos;varying vec2 v_pos_a;varying vec2 v_pos_b;\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp vec4 pattern_from\n#pragma mapbox: define lowp vec4 pattern_to\n#pragma mapbox: define lowp float pixel_ratio_from\n#pragma mapbox: define lowp float pixel_ratio_to\nvoid main() {\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump vec4 pattern_from\n#pragma mapbox: initialize mediump vec4 pattern_to\n#pragma mapbox: initialize lowp float pixel_ratio_from\n#pragma mapbox: initialize lowp float pixel_ratio_to\nvec2 pattern_tl_a=pattern_from.xy;vec2 pattern_br_a=pattern_from.zw;vec2 pattern_tl_b=pattern_to.xy;vec2 pattern_br_b=pattern_to.zw;float tileZoomRatio=u_scale.x;float fromScale=u_scale.y;float toScale=u_scale.z;vec2 display_size_a=(pattern_br_a-pattern_tl_a)/pixel_ratio_from;vec2 display_size_b=(pattern_br_b-pattern_tl_b)/pixel_ratio_to;gl_Position=u_matrix*vec4(a_pos,0,1);v_pos_a=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,fromScale*display_size_a,tileZoomRatio,a_pos);v_pos_b=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,toScale*display_size_b,tileZoomRatio,a_pos);}"),fillExtrusion:pe("varying vec4 v_color;void main() {gl_FragColor=v_color;\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","uniform mat4 u_matrix;uniform vec3 u_lightcolor;uniform lowp vec3 u_lightpos;uniform lowp float u_lightintensity;uniform float u_vertical_gradient;uniform lowp float u_opacity;attribute vec2 a_pos;attribute vec4 a_normal_ed;\n#ifdef TERRAIN3D\nattribute vec2 a_centroid;\n#endif\nvarying vec4 v_color;\n#pragma mapbox: define highp float base\n#pragma mapbox: define highp float height\n#pragma mapbox: define highp vec4 color\nvoid main() {\n#pragma mapbox: initialize highp float base\n#pragma mapbox: initialize highp float height\n#pragma mapbox: initialize highp vec4 color\nvec3 normal=a_normal_ed.xyz;\n#ifdef TERRAIN3D\nfloat height_terrain3d_offset=get_elevation(a_centroid);float base_terrain3d_offset=height_terrain3d_offset-(base > 0.0 ? 0.0 : 10.0);\n#else\nfloat height_terrain3d_offset=0.0;float base_terrain3d_offset=0.0;\n#endif\nbase=max(0.0,base)+base_terrain3d_offset;height=max(0.0,height)+height_terrain3d_offset;float t=mod(normal.x,2.0);gl_Position=u_matrix*vec4(a_pos,t > 0.0 ? height : base,1);float colorvalue=color.r*0.2126+color.g*0.7152+color.b*0.0722;v_color=vec4(0.0,0.0,0.0,1.0);vec4 ambientlight=vec4(0.03,0.03,0.03,1.0);color+=ambientlight;float directional=clamp(dot(normal/16384.0,u_lightpos),0.0,1.0);directional=mix((1.0-u_lightintensity),max((1.0-colorvalue+u_lightintensity),1.0),directional);if (normal.y !=0.0) {directional*=((1.0-u_vertical_gradient)+(u_vertical_gradient*clamp((t+base)*pow(height/150.0,0.5),mix(0.7,0.98,1.0-u_lightintensity),1.0)));}v_color.r+=clamp(color.r*directional*u_lightcolor.r,mix(0.0,0.3,1.0-u_lightcolor.r),1.0);v_color.g+=clamp(color.g*directional*u_lightcolor.g,mix(0.0,0.3,1.0-u_lightcolor.g),1.0);v_color.b+=clamp(color.b*directional*u_lightcolor.b,mix(0.0,0.3,1.0-u_lightcolor.b),1.0);v_color*=u_opacity;}"),fillExtrusionPattern:pe("uniform vec2 u_texsize;uniform float u_fade;uniform sampler2D u_image;varying vec2 v_pos_a;varying vec2 v_pos_b;varying vec4 v_lighting;\n#pragma mapbox: define lowp float base\n#pragma mapbox: define lowp float height\n#pragma mapbox: define lowp vec4 pattern_from\n#pragma mapbox: define lowp vec4 pattern_to\n#pragma mapbox: define lowp float pixel_ratio_from\n#pragma mapbox: define lowp float pixel_ratio_to\nvoid main() {\n#pragma mapbox: initialize lowp float base\n#pragma mapbox: initialize lowp float height\n#pragma mapbox: initialize mediump vec4 pattern_from\n#pragma mapbox: initialize mediump vec4 pattern_to\n#pragma mapbox: initialize lowp float pixel_ratio_from\n#pragma mapbox: initialize lowp float pixel_ratio_to\nvec2 pattern_tl_a=pattern_from.xy;vec2 pattern_br_a=pattern_from.zw;vec2 pattern_tl_b=pattern_to.xy;vec2 pattern_br_b=pattern_to.zw;vec2 imagecoord=mod(v_pos_a,1.0);vec2 pos=mix(pattern_tl_a/u_texsize,pattern_br_a/u_texsize,imagecoord);vec4 color1=texture2D(u_image,pos);vec2 imagecoord_b=mod(v_pos_b,1.0);vec2 pos2=mix(pattern_tl_b/u_texsize,pattern_br_b/u_texsize,imagecoord_b);vec4 color2=texture2D(u_image,pos2);vec4 mixedColor=mix(color1,color2,u_fade);gl_FragColor=mixedColor*v_lighting;\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","uniform mat4 u_matrix;uniform vec2 u_pixel_coord_upper;uniform vec2 u_pixel_coord_lower;uniform float u_height_factor;uniform vec3 u_scale;uniform float u_vertical_gradient;uniform lowp float u_opacity;uniform vec3 u_lightcolor;uniform lowp vec3 u_lightpos;uniform lowp float u_lightintensity;attribute vec2 a_pos;attribute vec4 a_normal_ed;\n#ifdef TERRAIN3D\nattribute vec2 a_centroid;\n#endif\nvarying vec2 v_pos_a;varying vec2 v_pos_b;varying vec4 v_lighting;\n#pragma mapbox: define lowp float base\n#pragma mapbox: define lowp float height\n#pragma mapbox: define lowp vec4 pattern_from\n#pragma mapbox: define lowp vec4 pattern_to\n#pragma mapbox: define lowp float pixel_ratio_from\n#pragma mapbox: define lowp float pixel_ratio_to\nvoid main() {\n#pragma mapbox: initialize lowp float base\n#pragma mapbox: initialize lowp float height\n#pragma mapbox: initialize mediump vec4 pattern_from\n#pragma mapbox: initialize mediump vec4 pattern_to\n#pragma mapbox: initialize lowp float pixel_ratio_from\n#pragma mapbox: initialize lowp float pixel_ratio_to\nvec2 pattern_tl_a=pattern_from.xy;vec2 pattern_br_a=pattern_from.zw;vec2 pattern_tl_b=pattern_to.xy;vec2 pattern_br_b=pattern_to.zw;float tileRatio=u_scale.x;float fromScale=u_scale.y;float toScale=u_scale.z;vec3 normal=a_normal_ed.xyz;float edgedistance=a_normal_ed.w;vec2 display_size_a=(pattern_br_a-pattern_tl_a)/pixel_ratio_from;vec2 display_size_b=(pattern_br_b-pattern_tl_b)/pixel_ratio_to;\n#ifdef TERRAIN3D\nfloat height_terrain3d_offset=get_elevation(a_centroid);float base_terrain3d_offset=height_terrain3d_offset-(base > 0.0 ? 0.0 : 10.0);\n#else\nfloat height_terrain3d_offset=0.0;float base_terrain3d_offset=0.0;\n#endif\nbase=max(0.0,base)+base_terrain3d_offset;height=max(0.0,height)+height_terrain3d_offset;float t=mod(normal.x,2.0);float z=t > 0.0 ? height : base;gl_Position=u_matrix*vec4(a_pos,z,1);vec2 pos=normal.x==1.0 && normal.y==0.0 && normal.z==16384.0\n? a_pos\n: vec2(edgedistance,z*u_height_factor);v_pos_a=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,fromScale*display_size_a,tileRatio,pos);v_pos_b=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,toScale*display_size_b,tileRatio,pos);v_lighting=vec4(0.0,0.0,0.0,1.0);float directional=clamp(dot(normal/16383.0,u_lightpos),0.0,1.0);directional=mix((1.0-u_lightintensity),max((0.5+u_lightintensity),1.0),directional);if (normal.y !=0.0) {directional*=((1.0-u_vertical_gradient)+(u_vertical_gradient*clamp((t+base)*pow(height/150.0,0.5),mix(0.7,0.98,1.0-u_lightintensity),1.0)));}v_lighting.rgb+=clamp(directional*u_lightcolor,mix(vec3(0.0),vec3(0.3),1.0-u_lightcolor),vec3(1.0));v_lighting*=u_opacity;}"),hillshadePrepare:pe("#ifdef GL_ES\nprecision highp float;\n#endif\nuniform sampler2D u_image;varying vec2 v_pos;uniform vec2 u_dimension;uniform float u_zoom;uniform vec4 u_unpack;float getElevation(vec2 coord,float bias) {vec4 data=texture2D(u_image,coord)*255.0;data.a=-1.0;return dot(data,u_unpack)/4.0;}void main() {vec2 epsilon=1.0/u_dimension;float a=getElevation(v_pos+vec2(-epsilon.x,-epsilon.y),0.0);float b=getElevation(v_pos+vec2(0,-epsilon.y),0.0);float c=getElevation(v_pos+vec2(epsilon.x,-epsilon.y),0.0);float d=getElevation(v_pos+vec2(-epsilon.x,0),0.0);float e=getElevation(v_pos,0.0);float f=getElevation(v_pos+vec2(epsilon.x,0),0.0);float g=getElevation(v_pos+vec2(-epsilon.x,epsilon.y),0.0);float h=getElevation(v_pos+vec2(0,epsilon.y),0.0);float i=getElevation(v_pos+vec2(epsilon.x,epsilon.y),0.0);float exaggerationFactor=u_zoom < 2.0 ? 0.4 : u_zoom < 4.5 ? 0.35 : 0.3;float exaggeration=u_zoom < 15.0 ? (u_zoom-15.0)*exaggerationFactor : 0.0;vec2 deriv=vec2((c+f+f+i)-(a+d+d+g),(g+h+h+i)-(a+b+b+c))/pow(2.0,exaggeration+(19.2562-u_zoom));gl_FragColor=clamp(vec4(deriv.x/2.0+0.5,deriv.y/2.0+0.5,1.0,1.0),0.0,1.0);\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","uniform mat4 u_matrix;uniform vec2 u_dimension;attribute vec2 a_pos;attribute vec2 a_texture_pos;varying vec2 v_pos;void main() {gl_Position=u_matrix*vec4(a_pos,0,1);highp vec2 epsilon=1.0/u_dimension;float scale=(u_dimension.x-2.0)/u_dimension.x;v_pos=(a_texture_pos/8192.0)*scale+epsilon;}"),hillshade:pe("uniform sampler2D u_image;varying vec2 v_pos;uniform vec2 u_latrange;uniform vec2 u_light;uniform vec4 u_shadow;uniform vec4 u_highlight;uniform vec4 u_accent;\n#define PI 3.141592653589793\nvoid main() {vec4 pixel=texture2D(u_image,v_pos);vec2 deriv=((pixel.rg*2.0)-1.0);float scaleFactor=cos(radians((u_latrange[0]-u_latrange[1])*(1.0-v_pos.y)+u_latrange[1]));float slope=atan(1.25*length(deriv)/scaleFactor);float aspect=deriv.x !=0.0 ? atan(deriv.y,-deriv.x) : PI/2.0*(deriv.y > 0.0 ? 1.0 :-1.0);float intensity=u_light.x;float azimuth=u_light.y+PI;float base=1.875-intensity*1.75;float maxValue=0.5*PI;float scaledSlope=intensity !=0.5 ? ((pow(base,slope)-1.0)/(pow(base,maxValue)-1.0))*maxValue : slope;float accent=cos(scaledSlope);vec4 accent_color=(1.0-accent)*u_accent*clamp(intensity*2.0,0.0,1.0);float shade=abs(mod((aspect+azimuth)/PI+0.5,2.0)-1.0);vec4 shade_color=mix(u_shadow,u_highlight,shade)*sin(scaledSlope)*clamp(intensity*2.0,0.0,1.0);gl_FragColor=accent_color*(1.0-shade_color.a)+shade_color;\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","uniform mat4 u_matrix;attribute vec2 a_pos;attribute vec2 a_texture_pos;varying vec2 v_pos;void main() {gl_Position=u_matrix*vec4(a_pos,0,1);v_pos=a_texture_pos/8192.0;}"),line:pe("uniform lowp float u_device_pixel_ratio;varying vec2 v_width2;varying vec2 v_normal;varying float v_gamma_scale;\n#pragma mapbox: define highp vec4 color\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\nfloat dist=length(v_normal)*v_width2.s;float blur2=(blur+1.0/u_device_pixel_ratio)*v_gamma_scale;float alpha=clamp(min(dist-(v_width2.t-blur2),v_width2.s-dist)/blur2,0.0,1.0);gl_FragColor=color*(alpha*opacity);\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","\n#define scale 0.015873016\nattribute vec2 a_pos_normal;attribute vec4 a_data;uniform mat4 u_matrix;uniform mediump float u_ratio;uniform vec2 u_units_to_pixels;uniform lowp float u_device_pixel_ratio;varying vec2 v_normal;varying vec2 v_width2;varying float v_gamma_scale;varying highp float v_linesofar;\n#pragma mapbox: define highp vec4 color\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define mediump float gapwidth\n#pragma mapbox: define lowp float offset\n#pragma mapbox: define mediump float width\nvoid main() {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump float gapwidth\n#pragma mapbox: initialize lowp float offset\n#pragma mapbox: initialize mediump float width\nfloat ANTIALIASING=1.0/u_device_pixel_ratio/2.0;vec2 a_extrude=a_data.xy-128.0;float a_direction=mod(a_data.z,4.0)-1.0;v_linesofar=(floor(a_data.z/4.0)+a_data.w*64.0)*2.0;vec2 pos=floor(a_pos_normal*0.5);mediump vec2 normal=a_pos_normal-2.0*pos;normal.y=normal.y*2.0-1.0;v_normal=normal;gapwidth=gapwidth/2.0;float halfwidth=width/2.0;offset=-1.0*offset;float inset=gapwidth+(gapwidth > 0.0 ? ANTIALIASING : 0.0);float outset=gapwidth+halfwidth*(gapwidth > 0.0 ? 2.0 : 1.0)+(halfwidth==0.0 ? 0.0 : ANTIALIASING);mediump vec2 dist=outset*a_extrude*scale;mediump float u=0.5*a_direction;mediump float t=1.0-abs(u);mediump vec2 offset2=offset*a_extrude*scale*normal.y*mat2(t,-u,u,t);vec4 projected_extrude=u_matrix*vec4(dist/u_ratio,0.0,0.0);gl_Position=u_matrix*vec4(pos+offset2/u_ratio,0.0,1.0)+projected_extrude;\n#ifdef TERRAIN3D\nv_gamma_scale=1.0;\n#else\nfloat extrude_length_without_perspective=length(dist);float extrude_length_with_perspective=length(projected_extrude.xy/gl_Position.w*u_units_to_pixels);v_gamma_scale=extrude_length_without_perspective/extrude_length_with_perspective;\n#endif\nv_width2=vec2(outset,inset);}"),lineGradient:pe("uniform lowp float u_device_pixel_ratio;uniform sampler2D u_image;varying vec2 v_width2;varying vec2 v_normal;varying float v_gamma_scale;varying highp vec2 v_uv;\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\nfloat dist=length(v_normal)*v_width2.s;float blur2=(blur+1.0/u_device_pixel_ratio)*v_gamma_scale;float alpha=clamp(min(dist-(v_width2.t-blur2),v_width2.s-dist)/blur2,0.0,1.0);vec4 color=texture2D(u_image,v_uv);gl_FragColor=color*(alpha*opacity);\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","\n#define scale 0.015873016\nattribute vec2 a_pos_normal;attribute vec4 a_data;attribute float a_uv_x;attribute float a_split_index;uniform mat4 u_matrix;uniform mediump float u_ratio;uniform lowp float u_device_pixel_ratio;uniform vec2 u_units_to_pixels;uniform float u_image_height;varying vec2 v_normal;varying vec2 v_width2;varying float v_gamma_scale;varying highp vec2 v_uv;\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define mediump float gapwidth\n#pragma mapbox: define lowp float offset\n#pragma mapbox: define mediump float width\nvoid main() {\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump float gapwidth\n#pragma mapbox: initialize lowp float offset\n#pragma mapbox: initialize mediump float width\nfloat ANTIALIASING=1.0/u_device_pixel_ratio/2.0;vec2 a_extrude=a_data.xy-128.0;float a_direction=mod(a_data.z,4.0)-1.0;highp float texel_height=1.0/u_image_height;highp float half_texel_height=0.5*texel_height;v_uv=vec2(a_uv_x,a_split_index*texel_height-half_texel_height);vec2 pos=floor(a_pos_normal*0.5);mediump vec2 normal=a_pos_normal-2.0*pos;normal.y=normal.y*2.0-1.0;v_normal=normal;gapwidth=gapwidth/2.0;float halfwidth=width/2.0;offset=-1.0*offset;float inset=gapwidth+(gapwidth > 0.0 ? ANTIALIASING : 0.0);float outset=gapwidth+halfwidth*(gapwidth > 0.0 ? 2.0 : 1.0)+(halfwidth==0.0 ? 0.0 : ANTIALIASING);mediump vec2 dist=outset*a_extrude*scale;mediump float u=0.5*a_direction;mediump float t=1.0-abs(u);mediump vec2 offset2=offset*a_extrude*scale*normal.y*mat2(t,-u,u,t);vec4 projected_extrude=u_matrix*vec4(dist/u_ratio,0.0,0.0);gl_Position=u_matrix*vec4(pos+offset2/u_ratio,0.0,1.0)+projected_extrude;\n#ifdef TERRAIN3D\nv_gamma_scale=1.0;\n#else\nfloat extrude_length_without_perspective=length(dist);float extrude_length_with_perspective=length(projected_extrude.xy/gl_Position.w*u_units_to_pixels);v_gamma_scale=extrude_length_without_perspective/extrude_length_with_perspective;\n#endif\nv_width2=vec2(outset,inset);}"),linePattern:pe("#ifdef GL_ES\nprecision highp float;\n#endif\nuniform lowp float u_device_pixel_ratio;uniform vec2 u_texsize;uniform float u_fade;uniform mediump vec3 u_scale;uniform sampler2D u_image;varying vec2 v_normal;varying vec2 v_width2;varying float v_linesofar;varying float v_gamma_scale;varying float v_width;\n#pragma mapbox: define lowp vec4 pattern_from\n#pragma mapbox: define lowp vec4 pattern_to\n#pragma mapbox: define lowp float pixel_ratio_from\n#pragma mapbox: define lowp float pixel_ratio_to\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize mediump vec4 pattern_from\n#pragma mapbox: initialize mediump vec4 pattern_to\n#pragma mapbox: initialize lowp float pixel_ratio_from\n#pragma mapbox: initialize lowp float pixel_ratio_to\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\nvec2 pattern_tl_a=pattern_from.xy;vec2 pattern_br_a=pattern_from.zw;vec2 pattern_tl_b=pattern_to.xy;vec2 pattern_br_b=pattern_to.zw;float tileZoomRatio=u_scale.x;float fromScale=u_scale.y;float toScale=u_scale.z;vec2 display_size_a=(pattern_br_a-pattern_tl_a)/pixel_ratio_from;vec2 display_size_b=(pattern_br_b-pattern_tl_b)/pixel_ratio_to;vec2 pattern_size_a=vec2(display_size_a.x*fromScale/tileZoomRatio,display_size_a.y);vec2 pattern_size_b=vec2(display_size_b.x*toScale/tileZoomRatio,display_size_b.y);float aspect_a=display_size_a.y/v_width;float aspect_b=display_size_b.y/v_width;float dist=length(v_normal)*v_width2.s;float blur2=(blur+1.0/u_device_pixel_ratio)*v_gamma_scale;float alpha=clamp(min(dist-(v_width2.t-blur2),v_width2.s-dist)/blur2,0.0,1.0);float x_a=mod(v_linesofar/pattern_size_a.x*aspect_a,1.0);float x_b=mod(v_linesofar/pattern_size_b.x*aspect_b,1.0);float y=0.5*v_normal.y+0.5;vec2 texel_size=1.0/u_texsize;vec2 pos_a=mix(pattern_tl_a*texel_size-texel_size,pattern_br_a*texel_size+texel_size,vec2(x_a,y));vec2 pos_b=mix(pattern_tl_b*texel_size-texel_size,pattern_br_b*texel_size+texel_size,vec2(x_b,y));vec4 color=mix(texture2D(u_image,pos_a),texture2D(u_image,pos_b),u_fade);gl_FragColor=color*alpha*opacity;\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","\n#define scale 0.015873016\n#define LINE_DISTANCE_SCALE 2.0\nattribute vec2 a_pos_normal;attribute vec4 a_data;uniform mat4 u_matrix;uniform vec2 u_units_to_pixels;uniform mediump float u_ratio;uniform lowp float u_device_pixel_ratio;varying vec2 v_normal;varying vec2 v_width2;varying float v_linesofar;varying float v_gamma_scale;varying float v_width;\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp float offset\n#pragma mapbox: define mediump float gapwidth\n#pragma mapbox: define mediump float width\n#pragma mapbox: define lowp float floorwidth\n#pragma mapbox: define lowp vec4 pattern_from\n#pragma mapbox: define lowp vec4 pattern_to\n#pragma mapbox: define lowp float pixel_ratio_from\n#pragma mapbox: define lowp float pixel_ratio_to\nvoid main() {\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize lowp float offset\n#pragma mapbox: initialize mediump float gapwidth\n#pragma mapbox: initialize mediump float width\n#pragma mapbox: initialize lowp float floorwidth\n#pragma mapbox: initialize mediump vec4 pattern_from\n#pragma mapbox: initialize mediump vec4 pattern_to\n#pragma mapbox: initialize lowp float pixel_ratio_from\n#pragma mapbox: initialize lowp float pixel_ratio_to\nfloat ANTIALIASING=1.0/u_device_pixel_ratio/2.0;vec2 a_extrude=a_data.xy-128.0;float a_direction=mod(a_data.z,4.0)-1.0;float a_linesofar=(floor(a_data.z/4.0)+a_data.w*64.0)*LINE_DISTANCE_SCALE;vec2 pos=floor(a_pos_normal*0.5);mediump vec2 normal=a_pos_normal-2.0*pos;normal.y=normal.y*2.0-1.0;v_normal=normal;gapwidth=gapwidth/2.0;float halfwidth=width/2.0;offset=-1.0*offset;float inset=gapwidth+(gapwidth > 0.0 ? ANTIALIASING : 0.0);float outset=gapwidth+halfwidth*(gapwidth > 0.0 ? 2.0 : 1.0)+(halfwidth==0.0 ? 0.0 : ANTIALIASING);mediump vec2 dist=outset*a_extrude*scale;mediump float u=0.5*a_direction;mediump float t=1.0-abs(u);mediump vec2 offset2=offset*a_extrude*scale*normal.y*mat2(t,-u,u,t);vec4 projected_extrude=u_matrix*vec4(dist/u_ratio,0.0,0.0);gl_Position=u_matrix*vec4(pos+offset2/u_ratio,0.0,1.0)+projected_extrude;\n#ifdef TERRAIN3D\nv_gamma_scale=1.0;\n#else\nfloat extrude_length_without_perspective=length(dist);float extrude_length_with_perspective=length(projected_extrude.xy/gl_Position.w*u_units_to_pixels);v_gamma_scale=extrude_length_without_perspective/extrude_length_with_perspective;\n#endif\nv_linesofar=a_linesofar;v_width2=vec2(outset,inset);v_width=floorwidth;}"),lineSDF:pe("uniform lowp float u_device_pixel_ratio;uniform sampler2D u_image;uniform float u_sdfgamma;uniform float u_mix;varying vec2 v_normal;varying vec2 v_width2;varying vec2 v_tex_a;varying vec2 v_tex_b;varying float v_gamma_scale;\n#pragma mapbox: define highp vec4 color\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define mediump float width\n#pragma mapbox: define lowp float floorwidth\nvoid main() {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump float width\n#pragma mapbox: initialize lowp float floorwidth\nfloat dist=length(v_normal)*v_width2.s;float blur2=(blur+1.0/u_device_pixel_ratio)*v_gamma_scale;float alpha=clamp(min(dist-(v_width2.t-blur2),v_width2.s-dist)/blur2,0.0,1.0);float sdfdist_a=texture2D(u_image,v_tex_a).a;float sdfdist_b=texture2D(u_image,v_tex_b).a;float sdfdist=mix(sdfdist_a,sdfdist_b,u_mix);alpha*=smoothstep(0.5-u_sdfgamma/floorwidth,0.5+u_sdfgamma/floorwidth,sdfdist);gl_FragColor=color*(alpha*opacity);\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","\n#define scale 0.015873016\n#define LINE_DISTANCE_SCALE 2.0\nattribute vec2 a_pos_normal;attribute vec4 a_data;uniform mat4 u_matrix;uniform mediump float u_ratio;uniform lowp float u_device_pixel_ratio;uniform vec2 u_patternscale_a;uniform float u_tex_y_a;uniform vec2 u_patternscale_b;uniform float u_tex_y_b;uniform vec2 u_units_to_pixels;varying vec2 v_normal;varying vec2 v_width2;varying vec2 v_tex_a;varying vec2 v_tex_b;varying float v_gamma_scale;\n#pragma mapbox: define highp vec4 color\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define mediump float gapwidth\n#pragma mapbox: define lowp float offset\n#pragma mapbox: define mediump float width\n#pragma mapbox: define lowp float floorwidth\nvoid main() {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump float gapwidth\n#pragma mapbox: initialize lowp float offset\n#pragma mapbox: initialize mediump float width\n#pragma mapbox: initialize lowp float floorwidth\nfloat ANTIALIASING=1.0/u_device_pixel_ratio/2.0;vec2 a_extrude=a_data.xy-128.0;float a_direction=mod(a_data.z,4.0)-1.0;float a_linesofar=(floor(a_data.z/4.0)+a_data.w*64.0)*LINE_DISTANCE_SCALE;vec2 pos=floor(a_pos_normal*0.5);mediump vec2 normal=a_pos_normal-2.0*pos;normal.y=normal.y*2.0-1.0;v_normal=normal;gapwidth=gapwidth/2.0;float halfwidth=width/2.0;offset=-1.0*offset;float inset=gapwidth+(gapwidth > 0.0 ? ANTIALIASING : 0.0);float outset=gapwidth+halfwidth*(gapwidth > 0.0 ? 2.0 : 1.0)+(halfwidth==0.0 ? 0.0 : ANTIALIASING);mediump vec2 dist=outset*a_extrude*scale;mediump float u=0.5*a_direction;mediump float t=1.0-abs(u);mediump vec2 offset2=offset*a_extrude*scale*normal.y*mat2(t,-u,u,t);vec4 projected_extrude=u_matrix*vec4(dist/u_ratio,0.0,0.0);gl_Position=u_matrix*vec4(pos+offset2/u_ratio,0.0,1.0)+projected_extrude;\n#ifdef TERRAIN3D\nv_gamma_scale=1.0;\n#else\nfloat extrude_length_without_perspective=length(dist);float extrude_length_with_perspective=length(projected_extrude.xy/gl_Position.w*u_units_to_pixels);v_gamma_scale=extrude_length_without_perspective/extrude_length_with_perspective;\n#endif\nv_tex_a=vec2(a_linesofar*u_patternscale_a.x/floorwidth,normal.y*u_patternscale_a.y+u_tex_y_a);v_tex_b=vec2(a_linesofar*u_patternscale_b.x/floorwidth,normal.y*u_patternscale_b.y+u_tex_y_b);v_width2=vec2(outset,inset);}"),raster:pe("uniform float u_fade_t;uniform float u_opacity;uniform sampler2D u_image0;uniform sampler2D u_image1;varying vec2 v_pos0;varying vec2 v_pos1;uniform float u_brightness_low;uniform float u_brightness_high;uniform float u_saturation_factor;uniform float u_contrast_factor;uniform vec3 u_spin_weights;void main() {vec4 color0=texture2D(u_image0,v_pos0);vec4 color1=texture2D(u_image1,v_pos1);if (color0.a > 0.0) {color0.rgb=color0.rgb/color0.a;}if (color1.a > 0.0) {color1.rgb=color1.rgb/color1.a;}vec4 color=mix(color0,color1,u_fade_t);color.a*=u_opacity;vec3 rgb=color.rgb;rgb=vec3(dot(rgb,u_spin_weights.xyz),dot(rgb,u_spin_weights.zxy),dot(rgb,u_spin_weights.yzx));float average=(color.r+color.g+color.b)/3.0;rgb+=(average-rgb)*u_saturation_factor;rgb=(rgb-0.5)*u_contrast_factor+0.5;vec3 u_high_vec=vec3(u_brightness_low,u_brightness_low,u_brightness_low);vec3 u_low_vec=vec3(u_brightness_high,u_brightness_high,u_brightness_high);gl_FragColor=vec4(mix(u_high_vec,u_low_vec,rgb)*color.a,color.a);\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","uniform mat4 u_matrix;uniform vec2 u_tl_parent;uniform float u_scale_parent;uniform float u_buffer_scale;attribute vec2 a_pos;attribute vec2 a_texture_pos;varying vec2 v_pos0;varying vec2 v_pos1;void main() {gl_Position=u_matrix*vec4(a_pos,0,1);v_pos0=(((a_texture_pos/8192.0)-0.5)/u_buffer_scale )+0.5;v_pos1=(v_pos0*u_scale_parent)+u_tl_parent;}"),symbolIcon:pe("uniform sampler2D u_texture;varying vec2 v_tex;varying float v_fade_opacity;\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize lowp float opacity\nlowp float alpha=opacity*v_fade_opacity;gl_FragColor=texture2D(u_texture,v_tex)*alpha;\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","attribute vec4 a_pos_offset;attribute vec4 a_data;attribute vec4 a_pixeloffset;attribute vec3 a_projected_pos;attribute float a_fade_opacity;uniform bool u_is_size_zoom_constant;uniform bool u_is_size_feature_constant;uniform highp float u_size_t;uniform highp float u_size;uniform highp float u_camera_to_center_distance;uniform highp float u_pitch;uniform bool u_rotate_symbol;uniform highp float u_aspect_ratio;uniform float u_fade_change;uniform mat4 u_matrix;uniform mat4 u_label_plane_matrix;uniform mat4 u_coord_matrix;uniform bool u_is_text;uniform bool u_pitch_with_map;uniform vec2 u_texsize;uniform bool u_is_along_line;uniform bool u_is_variable_anchor;uniform vec2 u_translation;uniform float u_pitched_scale;varying vec2 v_tex;varying float v_fade_opacity;vec4 projectTileWithElevation(vec2 posInTile,float elevation) {return u_matrix*vec4(posInTile,elevation,1.0);}\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize lowp float opacity\nvec2 a_pos=a_pos_offset.xy;vec2 a_offset=a_pos_offset.zw;vec2 a_tex=a_data.xy;vec2 a_size=a_data.zw;float a_size_min=floor(a_size[0]*0.5);vec2 a_pxoffset=a_pixeloffset.xy;vec2 a_minFontScale=a_pixeloffset.zw/256.0;float ele=get_elevation(a_pos);highp float segment_angle=-a_projected_pos[2];float size;if (!u_is_size_zoom_constant && !u_is_size_feature_constant) {size=mix(a_size_min,a_size[1],u_size_t)/128.0;} else if (u_is_size_zoom_constant && !u_is_size_feature_constant) {size=a_size_min/128.0;} else {size=u_size;}vec2 translated_a_pos=a_pos+u_translation;vec4 projectedPoint=projectTileWithElevation(translated_a_pos,ele);highp float camera_to_anchor_distance=projectedPoint.w;highp float distance_ratio=u_pitch_with_map ?\ncamera_to_anchor_distance/u_camera_to_center_distance :\nu_camera_to_center_distance/camera_to_anchor_distance;highp float perspective_ratio=clamp(0.5+0.5*distance_ratio,0.0,4.0);size*=perspective_ratio;float fontScale=u_is_text ? size/24.0 : size;highp float symbol_rotation=0.0;if (u_rotate_symbol) {vec4 offsetProjectedPoint=projectTileWithElevation(translated_a_pos+vec2(1,0),ele);vec2 a=projectedPoint.xy/projectedPoint.w;vec2 b=offsetProjectedPoint.xy/offsetProjectedPoint.w;symbol_rotation=atan((b.y-a.y)/u_aspect_ratio,b.x-a.x);}highp float angle_sin=sin(segment_angle+symbol_rotation);highp float angle_cos=cos(segment_angle+symbol_rotation);mat2 rotation_matrix=mat2(angle_cos,-1.0*angle_sin,angle_sin,angle_cos);vec4 projected_pos;if (u_is_along_line || u_is_variable_anchor) {projected_pos=vec4(a_projected_pos.xy,ele,1.0);} else if (u_pitch_with_map) {projected_pos=u_label_plane_matrix*vec4(a_projected_pos.xy+u_translation,ele,1.0);} else {projected_pos=u_label_plane_matrix*projectTileWithElevation(a_projected_pos.xy+u_translation,ele);}float z=float(u_pitch_with_map)*projected_pos.z/projected_pos.w;float projectionScaling=1.0;vec4 finalPos=u_coord_matrix*vec4(projected_pos.xy/projected_pos.w+rotation_matrix*(a_offset/32.0*max(a_minFontScale,fontScale)+a_pxoffset/16.0)*projectionScaling,z,1.0);if(u_pitch_with_map) {finalPos=projectTileWithElevation(finalPos.xy,finalPos.z);}gl_Position=finalPos;v_tex=a_tex/u_texsize;vec2 fade_opacity=unpack_opacity(a_fade_opacity);float fade_change=fade_opacity[1] > 0.5 ? u_fade_change :-u_fade_change;float visibility=calculate_visibility(projectedPoint);v_fade_opacity=max(0.0,min(visibility,fade_opacity[0]+fade_change));}"),symbolSDF:pe("#define SDF_PX 8.0\nuniform bool u_is_halo;uniform sampler2D u_texture;uniform highp float u_gamma_scale;uniform lowp float u_device_pixel_ratio;uniform bool u_is_text;varying vec2 v_data0;varying vec3 v_data1;\n#pragma mapbox: define highp vec4 fill_color\n#pragma mapbox: define highp vec4 halo_color\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp float halo_width\n#pragma mapbox: define lowp float halo_blur\nvoid main() {\n#pragma mapbox: initialize highp vec4 fill_color\n#pragma mapbox: initialize highp vec4 halo_color\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize lowp float halo_width\n#pragma mapbox: initialize lowp float halo_blur\nfloat EDGE_GAMMA=0.105/u_device_pixel_ratio;vec2 tex=v_data0.xy;float gamma_scale=v_data1.x;float size=v_data1.y;float fade_opacity=v_data1[2];float fontScale=u_is_text ? size/24.0 : size;lowp vec4 color=fill_color;highp float gamma=EDGE_GAMMA/(fontScale*u_gamma_scale);lowp float inner_edge=(256.0-64.0)/256.0;if (u_is_halo) {color=halo_color;gamma=(halo_blur*1.19/SDF_PX+EDGE_GAMMA)/(fontScale*u_gamma_scale);inner_edge=inner_edge+gamma*gamma_scale;}lowp float dist=texture2D(u_texture,tex).a;highp float gamma_scaled=gamma*gamma_scale;highp float alpha=smoothstep(inner_edge-gamma_scaled,inner_edge+gamma_scaled,dist);if (u_is_halo) {lowp float halo_edge=(6.0-halo_width/fontScale)/SDF_PX;alpha=min(smoothstep(halo_edge-gamma_scaled,halo_edge+gamma_scaled,dist),1.0-alpha);}gl_FragColor=color*(alpha*opacity*fade_opacity);\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","attribute vec4 a_pos_offset;attribute vec4 a_data;attribute vec4 a_pixeloffset;attribute vec3 a_projected_pos;attribute float a_fade_opacity;uniform bool u_is_size_zoom_constant;uniform bool u_is_size_feature_constant;uniform highp float u_size_t;uniform highp float u_size;uniform mat4 u_matrix;uniform mat4 u_label_plane_matrix;uniform mat4 u_coord_matrix;uniform bool u_is_text;uniform bool u_pitch_with_map;uniform bool u_is_along_line;uniform bool u_is_variable_anchor;uniform highp float u_pitch;uniform bool u_rotate_symbol;uniform highp float u_aspect_ratio;uniform highp float u_camera_to_center_distance;uniform float u_fade_change;uniform vec2 u_texsize;uniform vec2 u_translation;uniform float u_pitched_scale;varying vec2 v_data0;varying vec3 v_data1;vec4 projectTileWithElevation(vec2 posInTile,float elevation) {return u_matrix*vec4(posInTile,elevation,1.0);}\n#pragma mapbox: define highp vec4 fill_color\n#pragma mapbox: define highp vec4 halo_color\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp float halo_width\n#pragma mapbox: define lowp float halo_blur\nvoid main() {\n#pragma mapbox: initialize highp vec4 fill_color\n#pragma mapbox: initialize highp vec4 halo_color\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize lowp float halo_width\n#pragma mapbox: initialize lowp float halo_blur\nvec2 a_pos=a_pos_offset.xy;vec2 a_offset=a_pos_offset.zw;vec2 a_tex=a_data.xy;vec2 a_size=a_data.zw;float a_size_min=floor(a_size[0]*0.5);vec2 a_pxoffset=a_pixeloffset.xy;float ele=get_elevation(a_pos);highp float segment_angle=-a_projected_pos[2];float size;if (!u_is_size_zoom_constant && !u_is_size_feature_constant) {size=mix(a_size_min,a_size[1],u_size_t)/128.0;} else if (u_is_size_zoom_constant && !u_is_size_feature_constant) {size=a_size_min/128.0;} else {size=u_size;}vec2 translated_a_pos=a_pos+u_translation;vec4 projectedPoint=projectTileWithElevation(translated_a_pos,ele);highp float camera_to_anchor_distance=projectedPoint.w;highp float distance_ratio=u_pitch_with_map ?\ncamera_to_anchor_distance/u_camera_to_center_distance :\nu_camera_to_center_distance/camera_to_anchor_distance;highp float perspective_ratio=clamp(0.5+0.5*distance_ratio,0.0,4.0);size*=perspective_ratio;float fontScale=u_is_text ? size/24.0 : size;highp float symbol_rotation=0.0;if (u_rotate_symbol) {vec4 offsetProjectedPoint=projectTileWithElevation(translated_a_pos+vec2(1,0),ele);vec2 a=projectedPoint.xy/projectedPoint.w;vec2 b=offsetProjectedPoint.xy/offsetProjectedPoint.w;symbol_rotation=atan((b.y-a.y)/u_aspect_ratio,b.x-a.x);}highp float angle_sin=sin(segment_angle+symbol_rotation);highp float angle_cos=cos(segment_angle+symbol_rotation);mat2 rotation_matrix=mat2(angle_cos,-1.0*angle_sin,angle_sin,angle_cos);vec4 projected_pos;if (u_is_along_line || u_is_variable_anchor) {projected_pos=vec4(a_projected_pos.xy,ele,1.0);} else if (u_pitch_with_map) {projected_pos=u_label_plane_matrix*vec4(a_projected_pos.xy+u_translation,ele,1.0);} else {projected_pos=u_label_plane_matrix*projectTileWithElevation(a_projected_pos.xy+u_translation,ele);}float z=float(u_pitch_with_map)*projected_pos.z/projected_pos.w;float projectionScaling=1.0;vec4 finalPos=u_coord_matrix*vec4(projected_pos.xy/projected_pos.w+rotation_matrix*(a_offset/32.0*fontScale+a_pxoffset)*projectionScaling,z,1.0);if(u_pitch_with_map) {finalPos=projectTileWithElevation(finalPos.xy,finalPos.z);}float gamma_scale=finalPos.w;gl_Position=finalPos;vec2 fade_opacity=unpack_opacity(a_fade_opacity);float visibility=calculate_visibility(projectedPoint);float fade_change=fade_opacity[1] > 0.5 ? u_fade_change :-u_fade_change;float interpolated_fade_opacity=max(0.0,min(visibility,fade_opacity[0]+fade_change));v_data0=a_tex/u_texsize;v_data1=vec3(gamma_scale,size,interpolated_fade_opacity);}"),symbolTextAndIcon:pe("#define SDF_PX 8.0\n#define SDF 1.0\n#define ICON 0.0\nuniform bool u_is_halo;uniform sampler2D u_texture;uniform sampler2D u_texture_icon;uniform highp float u_gamma_scale;uniform lowp float u_device_pixel_ratio;varying vec4 v_data0;varying vec4 v_data1;\n#pragma mapbox: define highp vec4 fill_color\n#pragma mapbox: define highp vec4 halo_color\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp float halo_width\n#pragma mapbox: define lowp float halo_blur\nvoid main() {\n#pragma mapbox: initialize highp vec4 fill_color\n#pragma mapbox: initialize highp vec4 halo_color\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize lowp float halo_width\n#pragma mapbox: initialize lowp float halo_blur\nfloat fade_opacity=v_data1[2];if (v_data1.w==ICON) {vec2 tex_icon=v_data0.zw;lowp float alpha=opacity*fade_opacity;gl_FragColor=texture2D(u_texture_icon,tex_icon)*alpha;\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\nreturn;}vec2 tex=v_data0.xy;float EDGE_GAMMA=0.105/u_device_pixel_ratio;float gamma_scale=v_data1.x;float size=v_data1.y;float fontScale=size/24.0;lowp vec4 color=fill_color;highp float gamma=EDGE_GAMMA/(fontScale*u_gamma_scale);lowp float buff=(256.0-64.0)/256.0;if (u_is_halo) {color=halo_color;gamma=(halo_blur*1.19/SDF_PX+EDGE_GAMMA)/(fontScale*u_gamma_scale);buff=(6.0-halo_width/fontScale)/SDF_PX;}lowp float dist=texture2D(u_texture,tex).a;highp float gamma_scaled=gamma*gamma_scale;highp float alpha=smoothstep(buff-gamma_scaled,buff+gamma_scaled,dist);gl_FragColor=color*(alpha*opacity*fade_opacity);\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","attribute vec4 a_pos_offset;attribute vec4 a_data;attribute vec3 a_projected_pos;attribute float a_fade_opacity;uniform bool u_is_size_zoom_constant;uniform bool u_is_size_feature_constant;uniform highp float u_size_t;uniform highp float u_size;uniform mat4 u_matrix;uniform mat4 u_label_plane_matrix;uniform mat4 u_coord_matrix;uniform bool u_is_text;uniform bool u_pitch_with_map;uniform highp float u_pitch;uniform bool u_rotate_symbol;uniform highp float u_aspect_ratio;uniform highp float u_camera_to_center_distance;uniform float u_fade_change;uniform vec2 u_texsize;uniform vec2 u_texsize_icon;uniform bool u_is_along_line;uniform bool u_is_variable_anchor;uniform vec2 u_translation;uniform float u_pitched_scale;varying vec4 v_data0;varying vec4 v_data1;vec4 projectTileWithElevation(vec2 posInTile,float elevation) {return u_matrix*vec4(posInTile,elevation,1.0);}\n#pragma mapbox: define highp vec4 fill_color\n#pragma mapbox: define highp vec4 halo_color\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp float halo_width\n#pragma mapbox: define lowp float halo_blur\nvoid main() {\n#pragma mapbox: initialize highp vec4 fill_color\n#pragma mapbox: initialize highp vec4 halo_color\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize lowp float halo_width\n#pragma mapbox: initialize lowp float halo_blur\nvec2 a_pos=a_pos_offset.xy;vec2 a_offset=a_pos_offset.zw;vec2 a_tex=a_data.xy;vec2 a_size=a_data.zw;float a_size_min=floor(a_size[0]*0.5);float is_sdf=a_size[0]-2.0*a_size_min;float ele=get_elevation(a_pos);highp float segment_angle=-a_projected_pos[2];float size;if (!u_is_size_zoom_constant && !u_is_size_feature_constant) {size=mix(a_size_min,a_size[1],u_size_t)/128.0;} else if (u_is_size_zoom_constant && !u_is_size_feature_constant) {size=a_size_min/128.0;} else {size=u_size;}vec2 translated_a_pos=a_pos+u_translation;vec4 projectedPoint=projectTileWithElevation(translated_a_pos,ele);highp float camera_to_anchor_distance=projectedPoint.w;highp float distance_ratio=u_pitch_with_map ?\ncamera_to_anchor_distance/u_camera_to_center_distance :\nu_camera_to_center_distance/camera_to_anchor_distance;highp float perspective_ratio=clamp(0.5+0.5*distance_ratio,0.0,4.0);size*=perspective_ratio;float fontScale=size/24.0;highp float symbol_rotation=0.0;if (u_rotate_symbol) {vec4 offsetProjectedPoint=projectTileWithElevation(translated_a_pos+vec2(1,0),ele);vec2 a=projectedPoint.xy/projectedPoint.w;vec2 b=offsetProjectedPoint.xy/offsetProjectedPoint.w;symbol_rotation=atan((b.y-a.y)/u_aspect_ratio,b.x-a.x);}highp float angle_sin=sin(segment_angle+symbol_rotation);highp float angle_cos=cos(segment_angle+symbol_rotation);mat2 rotation_matrix=mat2(angle_cos,-1.0*angle_sin,angle_sin,angle_cos);vec4 projected_pos;if (u_is_along_line || u_is_variable_anchor) {projected_pos=vec4(a_projected_pos.xy,ele,1.0);} else if (u_pitch_with_map) {projected_pos=u_label_plane_matrix*vec4(a_projected_pos.xy+u_translation,ele,1.0);} else {projected_pos=u_label_plane_matrix*projectTileWithElevation(a_projected_pos.xy+u_translation,ele);}float z=float(u_pitch_with_map)*projected_pos.z/projected_pos.w;float projectionScaling=1.0;vec4 finalPos=u_coord_matrix*vec4(projected_pos.xy/projected_pos.w+rotation_matrix*(a_offset/32.0*fontScale)*projectionScaling,z,1.0);if(u_pitch_with_map) {finalPos=projectTileWithElevation(finalPos.xy,finalPos.z);}float gamma_scale=finalPos.w;gl_Position=finalPos;vec2 fade_opacity=unpack_opacity(a_fade_opacity);float visibility=calculate_visibility(projectedPoint);float fade_change=fade_opacity[1] > 0.5 ? u_fade_change :-u_fade_change;float interpolated_fade_opacity=max(0.0,min(visibility,fade_opacity[0]+fade_change));v_data0.xy=a_tex/u_texsize;v_data0.zw=a_tex/u_texsize_icon;v_data1=vec4(gamma_scale,size,interpolated_fade_opacity,is_sdf);}"),terrain:pe("uniform sampler2D u_texture;uniform vec4 u_fog_color;uniform vec4 u_horizon_color;uniform float u_fog_ground_blend;uniform float u_fog_ground_blend_opacity;uniform float u_horizon_fog_blend;varying vec2 v_texture_pos;varying float v_fog_depth;const float gamma=2.2;vec4 gammaToLinear(vec4 color) {return pow(color,vec4(gamma));}vec4 linearToGamma(vec4 color) {return pow(color,vec4(1.0/gamma));}void main() {vec4 surface_color=texture2D(u_texture,v_texture_pos);if (v_fog_depth > u_fog_ground_blend) {vec4 surface_color_linear=gammaToLinear(surface_color);float blend_color=smoothstep(0.0,1.0,max((v_fog_depth-u_horizon_fog_blend)/(1.0-u_horizon_fog_blend),0.0));vec4 fog_horizon_color_linear=mix(gammaToLinear(u_fog_color),gammaToLinear(u_horizon_color),blend_color);float factor_fog=max(v_fog_depth-u_fog_ground_blend,0.0)/(1.0-u_fog_ground_blend);gl_FragColor=linearToGamma(mix(surface_color_linear,fog_horizon_color_linear,pow(factor_fog,2.0)*u_fog_ground_blend_opacity));} else {gl_FragColor=surface_color;}}","attribute vec3 a_pos3d;uniform mat4 u_matrix;uniform mat4 u_fog_matrix;uniform float u_ele_delta;varying vec2 v_texture_pos;varying float v_fog_depth;void main() {float ele=get_elevation(a_pos3d.xy);float ele_delta=a_pos3d.z==1.0 ? u_ele_delta : 0.0;v_texture_pos=a_pos3d.xy/8192.0;gl_Position=u_matrix*vec4(a_pos3d.xy,ele-ele_delta,1.0);vec4 pos=u_fog_matrix*vec4(a_pos3d.xy,ele,1.0);v_fog_depth=pos.z/pos.w*0.5+0.5;}"),terrainDepth:pe("varying float v_depth;const highp vec4 bitSh=vec4(256.*256.*256.,256.*256.,256.,1.);const highp vec4 bitMsk=vec4(0.,vec3(1./256.0));highp vec4 pack(highp float value) {highp vec4 comp=fract(value*bitSh);comp-=comp.xxyz*bitMsk;return comp;}void main() {gl_FragColor=pack(v_depth);}","attribute vec3 a_pos3d;uniform mat4 u_matrix;uniform float u_ele_delta;varying float v_depth;void main() {float ele=get_elevation(a_pos3d.xy);float ele_delta=a_pos3d.z==1.0 ? u_ele_delta : 0.0;gl_Position=u_matrix*vec4(a_pos3d.xy,ele-ele_delta,1.0);v_depth=gl_Position.z/gl_Position.w;}"),terrainCoords:pe("precision mediump float;uniform sampler2D u_texture;uniform float u_terrain_coords_id;varying vec2 v_texture_pos;void main() {vec4 rgba=texture2D(u_texture,v_texture_pos);gl_FragColor=vec4(rgba.r,rgba.g,rgba.b,u_terrain_coords_id);}","attribute vec3 a_pos3d;uniform mat4 u_matrix;uniform float u_ele_delta;varying vec2 v_texture_pos;void main() {float ele=get_elevation(a_pos3d.xy);float ele_delta=a_pos3d.z==1.0 ? u_ele_delta : 0.0;v_texture_pos=a_pos3d.xy/8192.0;gl_Position=u_matrix*vec4(a_pos3d.xy,ele-ele_delta,1.0);}"),sky:pe("uniform vec4 u_sky_color;uniform vec4 u_horizon_color;uniform float u_horizon;uniform float u_sky_horizon_blend;void main() {float y=gl_FragCoord.y;if (y > u_horizon) {float blend=y-u_horizon;if (blend < u_sky_horizon_blend) {gl_FragColor=mix(u_sky_color,u_horizon_color,pow(1.0-blend/u_sky_horizon_blend,2.0));} else {gl_FragColor=u_sky_color;}}}","attribute vec2 a_pos;void main() {gl_Position=vec4(a_pos,1.0,1.0);}")};function pe(t,e){const i=/#pragma mapbox: ([\w]+) ([\w]+) ([\w]+) ([\w]+)/g,a=e.match(/attribute ([\w]+) ([\w]+)/g),s=t.match(/uniform ([\w]+) ([\w]+)([\s]*)([\w]*)/g),o=e.match(/uniform ([\w]+) ([\w]+)([\s]*)([\w]*)/g),r=o?o.concat(s):s,n={};return {fragmentSource:t=t.replace(i,((t,e,i,a,s)=>(n[s]=!0,"define"===e?`\n#ifndef HAS_UNIFORM_u_${s}\nvarying ${i} ${a} ${s};\n#else\nuniform ${i} ${a} u_${s};\n#endif\n`:`\n#ifdef HAS_UNIFORM_u_${s}\n    ${i} ${a} ${s} = u_${s};\n#endif\n`))),vertexSource:e=e.replace(i,((t,e,i,a,s)=>{const o="float"===a?"vec2":"vec4",r=s.match(/color/)?"color":o;return n[s]?"define"===e?`\n#ifndef HAS_UNIFORM_u_${s}\nuniform lowp float u_${s}_t;\nattribute ${i} ${o} a_${s};\nvarying ${i} ${a} ${s};\n#else\nuniform ${i} ${a} u_${s};\n#endif\n`:"vec4"===r?`\n#ifndef HAS_UNIFORM_u_${s}\n    ${s} = a_${s};\n#else\n    ${i} ${a} ${s} = u_${s};\n#endif\n`:`\n#ifndef HAS_UNIFORM_u_${s}\n    ${s} = unpack_mix_${r}(a_${s}, u_${s}_t);\n#else\n    ${i} ${a} ${s} = u_${s};\n#endif\n`:"define"===e?`\n#ifndef HAS_UNIFORM_u_${s}\nuniform lowp float u_${s}_t;\nattribute ${i} ${o} a_${s};\n#else\nuniform ${i} ${a} u_${s};\n#endif\n`:"vec4"===r?`\n#ifndef HAS_UNIFORM_u_${s}\n    ${i} ${a} ${s} = a_${s};\n#else\n    ${i} ${a} ${s} = u_${s};\n#endif\n`:`\n#ifndef HAS_UNIFORM_u_${s}\n    ${i} ${a} ${s} = unpack_mix_${r}(a_${s}, u_${s}_t);\n#else\n    ${i} ${a} ${s} = u_${s};\n#endif\n`})),staticAttributes:a,staticUniforms:r}}class me{constructor(){this.boundProgram=null,this.boundLayoutVertexBuffer=null,this.boundPaintVertexBuffers=[],this.boundIndexBuffer=null,this.boundVertexOffset=null,this.boundDynamicVertexBuffer=null,this.vao=null;}bind(t,e,i,a,s,o,r,n,l){this.context=t;let h=this.boundPaintVertexBuffers.length!==a.length;for(let t=0;!h&&t<a.length;t++)this.boundPaintVertexBuffers[t]!==a[t]&&(h=!0);!this.vao||this.boundProgram!==e||this.boundLayoutVertexBuffer!==i||h||this.boundIndexBuffer!==s||this.boundVertexOffset!==o||this.boundDynamicVertexBuffer!==r||this.boundDynamicVertexBuffer2!==n||this.boundDynamicVertexBuffer3!==l?this.freshBind(e,i,a,s,o,r,n,l):(t.bindVertexArray.set(this.vao),r&&r.bind(),s&&s.dynamicDraw&&s.bind(),n&&n.bind(),l&&l.bind());}freshBind(t,e,i,a,s,o,r,n){const l=t.numAttributes,h=this.context,c=h.gl;this.vao&&this.destroy(),this.vao=h.createVertexArray(),h.bindVertexArray.set(this.vao),this.boundProgram=t,this.boundLayoutVertexBuffer=e,this.boundPaintVertexBuffers=i,this.boundIndexBuffer=a,this.boundVertexOffset=s,this.boundDynamicVertexBuffer=o,this.boundDynamicVertexBuffer2=r,this.boundDynamicVertexBuffer3=n,e.enableAttributes(c,t);for(const e of i)e.enableAttributes(c,t);o&&o.enableAttributes(c,t),r&&r.enableAttributes(c,t),n&&n.enableAttributes(c,t),e.bind(),e.setVertexAttribPointers(c,t,s);for(const e of i)e.bind(),e.setVertexAttribPointers(c,t,s);o&&(o.bind(),o.setVertexAttribPointers(c,t,s)),a&&a.bind(),r&&(r.bind(),r.setVertexAttribPointers(c,t,s)),n&&(n.bind(),n.setVertexAttribPointers(c,t,s)),h.currentNumAttributes=l;}destroy(){this.vao&&(this.context.deleteVertexArray(this.vao),this.vao=null);}}const fe=(t,i,a,s,o)=>({u_matrix:t,u_texture:0,u_ele_delta:i,u_fog_matrix:a,u_fog_color:s?s.properties.get("fog-color"):e.aM.white,u_fog_ground_blend:s?s.properties.get("fog-ground-blend"):1,u_fog_ground_blend_opacity:s?s.calculateFogBlendOpacity(o):0,u_horizon_color:s?s.properties.get("horizon-color"):e.aM.white,u_horizon_fog_blend:s?s.properties.get("horizon-fog-blend"):1});function ge(t){const e=[];for(let i=0;i<t.length;i++){if(null===t[i])continue;const a=t[i].split(" ");e.push(a.pop());}return e}class ve{constructor(t,i,a,s,o,r){const n=t.gl;this.program=n.createProgram();const l=ge(i.staticAttributes),h=a?a.getBinderAttributes():[],c=l.concat(h),u=_e.prelude.staticUniforms?ge(_e.prelude.staticUniforms):[],d=i.staticUniforms?ge(i.staticUniforms):[],_=a?a.getBinderUniforms():[],p=u.concat(d).concat(_),m=[];for(const t of p)m.indexOf(t)<0&&m.push(t);const f=a?a.defines():[];o&&f.push("#define OVERDRAW_INSPECTOR;"),r&&f.push("#define TERRAIN3D;");const g=f.concat(_e.prelude.fragmentSource,i.fragmentSource).join("\n"),v=f.concat(_e.prelude.vertexSource,i.vertexSource).join("\n"),x=n.createShader(n.FRAGMENT_SHADER);if(n.isContextLost())return void(this.failedToCreate=!0);if(n.shaderSource(x,g),n.compileShader(x),!n.getShaderParameter(x,n.COMPILE_STATUS))throw new Error(`Could not compile fragment shader: ${n.getShaderInfoLog(x)}`);n.attachShader(this.program,x);const y=n.createShader(n.VERTEX_SHADER);if(n.isContextLost())return void(this.failedToCreate=!0);if(n.shaderSource(y,v),n.compileShader(y),!n.getShaderParameter(y,n.COMPILE_STATUS))throw new Error(`Could not compile vertex shader: ${n.getShaderInfoLog(y)}`);n.attachShader(this.program,y),this.attributes={};const b={};this.numAttributes=c.length;for(let t=0;t<this.numAttributes;t++)c[t]&&(n.bindAttribLocation(this.program,t,c[t]),this.attributes[c[t]]=t);if(n.linkProgram(this.program),!n.getProgramParameter(this.program,n.LINK_STATUS))throw new Error(`Program failed to link: ${n.getProgramInfoLog(this.program)}`);n.deleteShader(y),n.deleteShader(x);for(let t=0;t<m.length;t++){const e=m[t];if(e&&!b[e]){const t=n.getUniformLocation(this.program,e);t&&(b[e]=t);}}this.fixedUniforms=s(t,b),this.terrainUniforms=((t,i)=>({u_depth:new e.aH(t,i.u_depth),u_terrain:new e.aH(t,i.u_terrain),u_terrain_dim:new e.aI(t,i.u_terrain_dim),u_terrain_matrix:new e.aJ(t,i.u_terrain_matrix),u_terrain_unpack:new e.aK(t,i.u_terrain_unpack),u_terrain_exaggeration:new e.aI(t,i.u_terrain_exaggeration)}))(t,b),this.binderUniforms=a?a.getUniforms(t,b):[];}draw(t,e,i,a,s,o,r,n,l,h,c,u,d,_,p,m,f,g){const v=t.gl;if(this.failedToCreate)return;if(t.program.set(this.program),t.setDepthMode(i),t.setStencilMode(a),t.setColorMode(s),t.setCullFace(o),n){t.activeTexture.set(v.TEXTURE2),v.bindTexture(v.TEXTURE_2D,n.depthTexture),t.activeTexture.set(v.TEXTURE3),v.bindTexture(v.TEXTURE_2D,n.texture);for(const t in this.terrainUniforms)this.terrainUniforms[t].set(n[t]);}for(const t in this.fixedUniforms)this.fixedUniforms[t].set(r[t]);p&&p.setUniforms(t,this.binderUniforms,d,{zoom:_});let x=0;switch(e){case v.LINES:x=2;break;case v.TRIANGLES:x=3;break;case v.LINE_STRIP:x=1;}for(const i of u.get()){const a=i.vaos||(i.vaos={});(a[l]||(a[l]=new me)).bind(t,this,h,p?p.getPaintVertexBuffers():[],c,i.vertexOffset,m,f,g),v.drawElements(e,i.primitiveLength*x,v.UNSIGNED_SHORT,i.primitiveOffset*x*2);}}}function xe(t,e,i){const a=1/Ft(i,1,e.transform.tileZoom),s=Math.pow(2,i.tileID.overscaledZ),o=i.tileSize*Math.pow(2,e.transform.tileZoom)/s,r=o*(i.tileID.canonical.x+i.tileID.wrap*s),n=o*i.tileID.canonical.y;return {u_image:0,u_texsize:i.imageAtlasTexture.size,u_scale:[a,t.fromScale,t.toScale],u_fade:t.t,u_pixel_coord_upper:[r>>16,n>>16],u_pixel_coord_lower:[65535&r,65535&n]}}const ye=(t,i,a,s)=>{const o=i.style.light,r=o.properties.get("position"),n=[r.x,r.y,r.z],l=function(){var t=new e.A(9);return e.A!=Float32Array&&(t[1]=0,t[2]=0,t[3]=0,t[5]=0,t[6]=0,t[7]=0),t[0]=1,t[4]=1,t[8]=1,t}();"viewport"===o.properties.get("anchor")&&function(t,e){var i=Math.sin(e),a=Math.cos(e);t[0]=a,t[1]=i,t[2]=0,t[3]=-i,t[4]=a,t[5]=0,t[6]=0,t[7]=0,t[8]=1;}(l,-i.transform.angle),function(t,e,i){var a=e[0],s=e[1],o=e[2];t[0]=a*i[0]+s*i[3]+o*i[6],t[1]=a*i[1]+s*i[4]+o*i[7],t[2]=a*i[2]+s*i[5]+o*i[8];}(n,n,l);const h=o.properties.get("color");return {u_matrix:t,u_lightpos:n,u_lightintensity:o.properties.get("intensity"),u_lightcolor:[h.r,h.g,h.b],u_vertical_gradient:+a,u_opacity:s}},be=(t,i,a,s,o,r,n)=>e.e(ye(t,i,a,s),xe(r,i,n),{u_height_factor:-Math.pow(2,o.overscaledZ)/n.tileSize/8}),we=t=>({u_matrix:t}),Te=(t,i,a,s)=>e.e(we(t),xe(a,i,s)),Ie=(t,e)=>({u_matrix:t,u_world:e}),Ee=(t,i,a,s,o)=>e.e(Te(t,i,a,s),{u_world:o}),Pe=(t,e,i,a)=>{const s=t.transform;let o,r;if("map"===a.paint.get("circle-pitch-alignment")){const t=Ft(i,1,s.zoom);o=!0,r=[t,t];}else o=!1,r=s.pixelsToGLUnits;return {u_camera_to_center_distance:s.cameraToCenterDistance,u_scale_with_map:+("map"===a.paint.get("circle-pitch-scale")),u_matrix:t.translatePosMatrix(e.posMatrix,i,a.paint.get("circle-translate"),a.paint.get("circle-translate-anchor")),u_pitch_with_map:+o,u_device_pixel_ratio:t.pixelRatio,u_extrude_scale:r}},Ce=(t,e,i)=>({u_matrix:t,u_inv_matrix:e,u_camera_to_center_distance:i.cameraToCenterDistance,u_viewport_size:[i.width,i.height]}),Se=(t,e,i=1)=>({u_matrix:t,u_color:e,u_overlay:0,u_overlay_scale:i}),ze=t=>({u_matrix:t}),De=(t,e,i,a)=>({u_matrix:t,u_extrude_scale:Ft(e,1,i),u_intensity:a});function Me(t,i){const a=Math.pow(2,i.canonical.z),s=i.canonical.y;return [new e.Z(0,s/a).toLngLat().lat,new e.Z(0,(s+1)/a).toLngLat().lat]}const Ae=(t,e,i,a)=>{const s=t.transform;return {u_matrix:Be(t,e,i,a),u_ratio:1/Ft(e,1,s.zoom),u_device_pixel_ratio:t.pixelRatio,u_units_to_pixels:[1/s.pixelsToGLUnits[0],1/s.pixelsToGLUnits[1]]}},Re=(t,i,a,s,o)=>e.e(Ae(t,i,a,o),{u_image:0,u_image_height:s}),ke=(t,e,i,a,s)=>{const o=t.transform,r=Fe(e,o);return {u_matrix:Be(t,e,i,s),u_texsize:e.imageAtlasTexture.size,u_ratio:1/Ft(e,1,o.zoom),u_device_pixel_ratio:t.pixelRatio,u_image:0,u_scale:[r,a.fromScale,a.toScale],u_fade:a.t,u_units_to_pixels:[1/o.pixelsToGLUnits[0],1/o.pixelsToGLUnits[1]]}},Le=(t,i,a,s,o,r)=>{const n=t.lineAtlas,l=Fe(i,t.transform),h="round"===a.layout.get("line-cap"),c=n.getDash(s.from,h),u=n.getDash(s.to,h),d=c.width*o.fromScale,_=u.width*o.toScale;return e.e(Ae(t,i,a,r),{u_patternscale_a:[l/d,-c.height/2],u_patternscale_b:[l/_,-u.height/2],u_sdfgamma:n.width/(256*Math.min(d,_)*t.pixelRatio)/2,u_image:0,u_tex_y_a:c.y,u_tex_y_b:u.y,u_mix:o.t})};function Fe(t,e){return 1/Ft(t,1,e.tileZoom)}function Be(t,e,i,a){return t.translatePosMatrix(a?a.posMatrix:e.tileID.posMatrix,e,i.paint.get("line-translate"),i.paint.get("line-translate-anchor"))}const Oe=(t,e,i,a,s)=>{return {u_matrix:t,u_tl_parent:e,u_scale_parent:i,u_buffer_scale:1,u_fade_t:a.mix,u_opacity:a.opacity*s.paint.get("raster-opacity"),u_image0:0,u_image1:1,u_brightness_low:s.paint.get("raster-brightness-min"),u_brightness_high:s.paint.get("raster-brightness-max"),u_saturation_factor:(r=s.paint.get("raster-saturation"),r>0?1-1/(1.001-r):-r),u_contrast_factor:(o=s.paint.get("raster-contrast"),o>0?1/(1-o):1+o),u_spin_weights:Ne(s.paint.get("raster-hue-rotate"))};var o,r;};function Ne(t){t*=Math.PI/180;const e=Math.sin(t),i=Math.cos(t);return [(2*i+1)/3,(-Math.sqrt(3)*e-i+1)/3,(Math.sqrt(3)*e-i+1)/3]}const je=(t,e,i,a,s,o,r,n,l,h,c,u,d,_)=>{const p=r.transform;return {u_is_size_zoom_constant:+("constant"===t||"source"===t),u_is_size_feature_constant:+("constant"===t||"camera"===t),u_size_t:e?e.uSizeT:0,u_size:e?e.uSize:0,u_camera_to_center_distance:p.cameraToCenterDistance,u_pitch:p.pitch/360*2*Math.PI,u_rotate_symbol:+i,u_aspect_ratio:p.width/p.height,u_fade_change:r.options.fadeDuration?r.symbolFadeChange:1,u_matrix:n,u_label_plane_matrix:l,u_coord_matrix:h,u_is_text:+u,u_pitch_with_map:+a,u_is_along_line:s,u_is_variable_anchor:o,u_texsize:d,u_texture:0,u_translation:c,u_pitched_scale:_}},Ue=(t,i,a,s,o,r,n,l,h,c,u,d,_,p,m)=>{const f=n.transform;return e.e(je(t,i,a,s,o,r,n,l,h,c,u,d,_,m),{u_gamma_scale:s?Math.cos(f._pitch)*f.cameraToCenterDistance:1,u_device_pixel_ratio:n.pixelRatio,u_is_halo:+p})},Ze=(t,i,a,s,o,r,n,l,h,c,u,d,_,p)=>e.e(Ue(t,i,a,s,o,r,n,l,h,c,u,!0,d,!0,p),{u_texsize_icon:_,u_texture_icon:1}),qe=(t,e,i)=>({u_matrix:t,u_opacity:e,u_color:i}),Ve=(t,i,a,s,o,r)=>e.e(function(t,e,i,a){const s=i.imageManager.getPattern(t.from.toString()),o=i.imageManager.getPattern(t.to.toString()),{width:r,height:n}=i.imageManager.getPixelSize(),l=Math.pow(2,a.tileID.overscaledZ),h=a.tileSize*Math.pow(2,i.transform.tileZoom)/l,c=h*(a.tileID.canonical.x+a.tileID.wrap*l),u=h*a.tileID.canonical.y;return {u_image:0,u_pattern_tl_a:s.tl,u_pattern_br_a:s.br,u_pattern_tl_b:o.tl,u_pattern_br_b:o.br,u_texsize:[r,n],u_mix:e.t,u_pattern_size_a:s.displaySize,u_pattern_size_b:o.displaySize,u_scale_a:e.fromScale,u_scale_b:e.toScale,u_tile_units_to_pixels:1/Ft(a,1,i.transform.tileZoom),u_pixel_coord_upper:[c>>16,u>>16],u_pixel_coord_lower:[65535&c,65535&u]}}(s,r,a,o),{u_matrix:t,u_opacity:i}),Ge={fillExtrusion:(t,i)=>({u_matrix:new e.aJ(t,i.u_matrix),u_lightpos:new e.aN(t,i.u_lightpos),u_lightintensity:new e.aI(t,i.u_lightintensity),u_lightcolor:new e.aN(t,i.u_lightcolor),u_vertical_gradient:new e.aI(t,i.u_vertical_gradient),u_opacity:new e.aI(t,i.u_opacity)}),fillExtrusionPattern:(t,i)=>({u_matrix:new e.aJ(t,i.u_matrix),u_lightpos:new e.aN(t,i.u_lightpos),u_lightintensity:new e.aI(t,i.u_lightintensity),u_lightcolor:new e.aN(t,i.u_lightcolor),u_vertical_gradient:new e.aI(t,i.u_vertical_gradient),u_height_factor:new e.aI(t,i.u_height_factor),u_image:new e.aH(t,i.u_image),u_texsize:new e.aO(t,i.u_texsize),u_pixel_coord_upper:new e.aO(t,i.u_pixel_coord_upper),u_pixel_coord_lower:new e.aO(t,i.u_pixel_coord_lower),u_scale:new e.aN(t,i.u_scale),u_fade:new e.aI(t,i.u_fade),u_opacity:new e.aI(t,i.u_opacity)}),fill:(t,i)=>({u_matrix:new e.aJ(t,i.u_matrix)}),fillPattern:(t,i)=>({u_matrix:new e.aJ(t,i.u_matrix),u_image:new e.aH(t,i.u_image),u_texsize:new e.aO(t,i.u_texsize),u_pixel_coord_upper:new e.aO(t,i.u_pixel_coord_upper),u_pixel_coord_lower:new e.aO(t,i.u_pixel_coord_lower),u_scale:new e.aN(t,i.u_scale),u_fade:new e.aI(t,i.u_fade)}),fillOutline:(t,i)=>({u_matrix:new e.aJ(t,i.u_matrix),u_world:new e.aO(t,i.u_world)}),fillOutlinePattern:(t,i)=>({u_matrix:new e.aJ(t,i.u_matrix),u_world:new e.aO(t,i.u_world),u_image:new e.aH(t,i.u_image),u_texsize:new e.aO(t,i.u_texsize),u_pixel_coord_upper:new e.aO(t,i.u_pixel_coord_upper),u_pixel_coord_lower:new e.aO(t,i.u_pixel_coord_lower),u_scale:new e.aN(t,i.u_scale),u_fade:new e.aI(t,i.u_fade)}),circle:(t,i)=>({u_camera_to_center_distance:new e.aI(t,i.u_camera_to_center_distance),u_scale_with_map:new e.aH(t,i.u_scale_with_map),u_pitch_with_map:new e.aH(t,i.u_pitch_with_map),u_extrude_scale:new e.aO(t,i.u_extrude_scale),u_device_pixel_ratio:new e.aI(t,i.u_device_pixel_ratio),u_matrix:new e.aJ(t,i.u_matrix)}),collisionBox:(t,i)=>({u_matrix:new e.aJ(t,i.u_matrix),u_pixel_extrude_scale:new e.aO(t,i.u_pixel_extrude_scale)}),collisionCircle:(t,i)=>({u_matrix:new e.aJ(t,i.u_matrix),u_inv_matrix:new e.aJ(t,i.u_inv_matrix),u_camera_to_center_distance:new e.aI(t,i.u_camera_to_center_distance),u_viewport_size:new e.aO(t,i.u_viewport_size)}),debug:(t,i)=>({u_color:new e.aL(t,i.u_color),u_matrix:new e.aJ(t,i.u_matrix),u_overlay:new e.aH(t,i.u_overlay),u_overlay_scale:new e.aI(t,i.u_overlay_scale)}),clippingMask:(t,i)=>({u_matrix:new e.aJ(t,i.u_matrix)}),heatmap:(t,i)=>({u_extrude_scale:new e.aI(t,i.u_extrude_scale),u_intensity:new e.aI(t,i.u_intensity),u_matrix:new e.aJ(t,i.u_matrix)}),heatmapTexture:(t,i)=>({u_matrix:new e.aJ(t,i.u_matrix),u_world:new e.aO(t,i.u_world),u_image:new e.aH(t,i.u_image),u_color_ramp:new e.aH(t,i.u_color_ramp),u_opacity:new e.aI(t,i.u_opacity)}),hillshade:(t,i)=>({u_matrix:new e.aJ(t,i.u_matrix),u_image:new e.aH(t,i.u_image),u_latrange:new e.aO(t,i.u_latrange),u_light:new e.aO(t,i.u_light),u_shadow:new e.aL(t,i.u_shadow),u_highlight:new e.aL(t,i.u_highlight),u_accent:new e.aL(t,i.u_accent)}),hillshadePrepare:(t,i)=>({u_matrix:new e.aJ(t,i.u_matrix),u_image:new e.aH(t,i.u_image),u_dimension:new e.aO(t,i.u_dimension),u_zoom:new e.aI(t,i.u_zoom),u_unpack:new e.aK(t,i.u_unpack)}),line:(t,i)=>({u_matrix:new e.aJ(t,i.u_matrix),u_ratio:new e.aI(t,i.u_ratio),u_device_pixel_ratio:new e.aI(t,i.u_device_pixel_ratio),u_units_to_pixels:new e.aO(t,i.u_units_to_pixels)}),lineGradient:(t,i)=>({u_matrix:new e.aJ(t,i.u_matrix),u_ratio:new e.aI(t,i.u_ratio),u_device_pixel_ratio:new e.aI(t,i.u_device_pixel_ratio),u_units_to_pixels:new e.aO(t,i.u_units_to_pixels),u_image:new e.aH(t,i.u_image),u_image_height:new e.aI(t,i.u_image_height)}),linePattern:(t,i)=>({u_matrix:new e.aJ(t,i.u_matrix),u_texsize:new e.aO(t,i.u_texsize),u_ratio:new e.aI(t,i.u_ratio),u_device_pixel_ratio:new e.aI(t,i.u_device_pixel_ratio),u_image:new e.aH(t,i.u_image),u_units_to_pixels:new e.aO(t,i.u_units_to_pixels),u_scale:new e.aN(t,i.u_scale),u_fade:new e.aI(t,i.u_fade)}),lineSDF:(t,i)=>({u_matrix:new e.aJ(t,i.u_matrix),u_ratio:new e.aI(t,i.u_ratio),u_device_pixel_ratio:new e.aI(t,i.u_device_pixel_ratio),u_units_to_pixels:new e.aO(t,i.u_units_to_pixels),u_patternscale_a:new e.aO(t,i.u_patternscale_a),u_patternscale_b:new e.aO(t,i.u_patternscale_b),u_sdfgamma:new e.aI(t,i.u_sdfgamma),u_image:new e.aH(t,i.u_image),u_tex_y_a:new e.aI(t,i.u_tex_y_a),u_tex_y_b:new e.aI(t,i.u_tex_y_b),u_mix:new e.aI(t,i.u_mix)}),raster:(t,i)=>({u_matrix:new e.aJ(t,i.u_matrix),u_tl_parent:new e.aO(t,i.u_tl_parent),u_scale_parent:new e.aI(t,i.u_scale_parent),u_buffer_scale:new e.aI(t,i.u_buffer_scale),u_fade_t:new e.aI(t,i.u_fade_t),u_opacity:new e.aI(t,i.u_opacity),u_image0:new e.aH(t,i.u_image0),u_image1:new e.aH(t,i.u_image1),u_brightness_low:new e.aI(t,i.u_brightness_low),u_brightness_high:new e.aI(t,i.u_brightness_high),u_saturation_factor:new e.aI(t,i.u_saturation_factor),u_contrast_factor:new e.aI(t,i.u_contrast_factor),u_spin_weights:new e.aN(t,i.u_spin_weights)}),symbolIcon:(t,i)=>({u_is_size_zoom_constant:new e.aH(t,i.u_is_size_zoom_constant),u_is_size_feature_constant:new e.aH(t,i.u_is_size_feature_constant),u_size_t:new e.aI(t,i.u_size_t),u_size:new e.aI(t,i.u_size),u_camera_to_center_distance:new e.aI(t,i.u_camera_to_center_distance),u_pitch:new e.aI(t,i.u_pitch),u_rotate_symbol:new e.aH(t,i.u_rotate_symbol),u_aspect_ratio:new e.aI(t,i.u_aspect_ratio),u_fade_change:new e.aI(t,i.u_fade_change),u_matrix:new e.aJ(t,i.u_matrix),u_label_plane_matrix:new e.aJ(t,i.u_label_plane_matrix),u_coord_matrix:new e.aJ(t,i.u_coord_matrix),u_is_text:new e.aH(t,i.u_is_text),u_pitch_with_map:new e.aH(t,i.u_pitch_with_map),u_is_along_line:new e.aH(t,i.u_is_along_line),u_is_variable_anchor:new e.aH(t,i.u_is_variable_anchor),u_texsize:new e.aO(t,i.u_texsize),u_texture:new e.aH(t,i.u_texture),u_translation:new e.aO(t,i.u_translation),u_pitched_scale:new e.aI(t,i.u_pitched_scale)}),symbolSDF:(t,i)=>({u_is_size_zoom_constant:new e.aH(t,i.u_is_size_zoom_constant),u_is_size_feature_constant:new e.aH(t,i.u_is_size_feature_constant),u_size_t:new e.aI(t,i.u_size_t),u_size:new e.aI(t,i.u_size),u_camera_to_center_distance:new e.aI(t,i.u_camera_to_center_distance),u_pitch:new e.aI(t,i.u_pitch),u_rotate_symbol:new e.aH(t,i.u_rotate_symbol),u_aspect_ratio:new e.aI(t,i.u_aspect_ratio),u_fade_change:new e.aI(t,i.u_fade_change),u_matrix:new e.aJ(t,i.u_matrix),u_label_plane_matrix:new e.aJ(t,i.u_label_plane_matrix),u_coord_matrix:new e.aJ(t,i.u_coord_matrix),u_is_text:new e.aH(t,i.u_is_text),u_pitch_with_map:new e.aH(t,i.u_pitch_with_map),u_is_along_line:new e.aH(t,i.u_is_along_line),u_is_variable_anchor:new e.aH(t,i.u_is_variable_anchor),u_texsize:new e.aO(t,i.u_texsize),u_texture:new e.aH(t,i.u_texture),u_gamma_scale:new e.aI(t,i.u_gamma_scale),u_device_pixel_ratio:new e.aI(t,i.u_device_pixel_ratio),u_is_halo:new e.aH(t,i.u_is_halo),u_translation:new e.aO(t,i.u_translation),u_pitched_scale:new e.aI(t,i.u_pitched_scale)}),symbolTextAndIcon:(t,i)=>({u_is_size_zoom_constant:new e.aH(t,i.u_is_size_zoom_constant),u_is_size_feature_constant:new e.aH(t,i.u_is_size_feature_constant),u_size_t:new e.aI(t,i.u_size_t),u_size:new e.aI(t,i.u_size),u_camera_to_center_distance:new e.aI(t,i.u_camera_to_center_distance),u_pitch:new e.aI(t,i.u_pitch),u_rotate_symbol:new e.aH(t,i.u_rotate_symbol),u_aspect_ratio:new e.aI(t,i.u_aspect_ratio),u_fade_change:new e.aI(t,i.u_fade_change),u_matrix:new e.aJ(t,i.u_matrix),u_label_plane_matrix:new e.aJ(t,i.u_label_plane_matrix),u_coord_matrix:new e.aJ(t,i.u_coord_matrix),u_is_text:new e.aH(t,i.u_is_text),u_pitch_with_map:new e.aH(t,i.u_pitch_with_map),u_is_along_line:new e.aH(t,i.u_is_along_line),u_is_variable_anchor:new e.aH(t,i.u_is_variable_anchor),u_texsize:new e.aO(t,i.u_texsize),u_texsize_icon:new e.aO(t,i.u_texsize_icon),u_texture:new e.aH(t,i.u_texture),u_texture_icon:new e.aH(t,i.u_texture_icon),u_gamma_scale:new e.aI(t,i.u_gamma_scale),u_device_pixel_ratio:new e.aI(t,i.u_device_pixel_ratio),u_is_halo:new e.aH(t,i.u_is_halo),u_translation:new e.aO(t,i.u_translation),u_pitched_scale:new e.aI(t,i.u_pitched_scale)}),background:(t,i)=>({u_matrix:new e.aJ(t,i.u_matrix),u_opacity:new e.aI(t,i.u_opacity),u_color:new e.aL(t,i.u_color)}),backgroundPattern:(t,i)=>({u_matrix:new e.aJ(t,i.u_matrix),u_opacity:new e.aI(t,i.u_opacity),u_image:new e.aH(t,i.u_image),u_pattern_tl_a:new e.aO(t,i.u_pattern_tl_a),u_pattern_br_a:new e.aO(t,i.u_pattern_br_a),u_pattern_tl_b:new e.aO(t,i.u_pattern_tl_b),u_pattern_br_b:new e.aO(t,i.u_pattern_br_b),u_texsize:new e.aO(t,i.u_texsize),u_mix:new e.aI(t,i.u_mix),u_pattern_size_a:new e.aO(t,i.u_pattern_size_a),u_pattern_size_b:new e.aO(t,i.u_pattern_size_b),u_scale_a:new e.aI(t,i.u_scale_a),u_scale_b:new e.aI(t,i.u_scale_b),u_pixel_coord_upper:new e.aO(t,i.u_pixel_coord_upper),u_pixel_coord_lower:new e.aO(t,i.u_pixel_coord_lower),u_tile_units_to_pixels:new e.aI(t,i.u_tile_units_to_pixels)}),terrain:(t,i)=>({u_matrix:new e.aJ(t,i.u_matrix),u_texture:new e.aH(t,i.u_texture),u_ele_delta:new e.aI(t,i.u_ele_delta),u_fog_matrix:new e.aJ(t,i.u_fog_matrix),u_fog_color:new e.aL(t,i.u_fog_color),u_fog_ground_blend:new e.aI(t,i.u_fog_ground_blend),u_fog_ground_blend_opacity:new e.aI(t,i.u_fog_ground_blend_opacity),u_horizon_color:new e.aL(t,i.u_horizon_color),u_horizon_fog_blend:new e.aI(t,i.u_horizon_fog_blend)}),terrainDepth:(t,i)=>({u_matrix:new e.aJ(t,i.u_matrix),u_ele_delta:new e.aI(t,i.u_ele_delta)}),terrainCoords:(t,i)=>({u_matrix:new e.aJ(t,i.u_matrix),u_texture:new e.aH(t,i.u_texture),u_terrain_coords_id:new e.aI(t,i.u_terrain_coords_id),u_ele_delta:new e.aI(t,i.u_ele_delta)}),sky:(t,i)=>({u_sky_color:new e.aL(t,i.u_sky_color),u_horizon_color:new e.aL(t,i.u_horizon_color),u_horizon:new e.aI(t,i.u_horizon),u_sky_horizon_blend:new e.aI(t,i.u_sky_horizon_blend)})};class He{constructor(t,e,i){this.context=t;const a=t.gl;this.buffer=a.createBuffer(),this.dynamicDraw=Boolean(i),this.context.unbindVAO(),t.bindElementBuffer.set(this.buffer),a.bufferData(a.ELEMENT_ARRAY_BUFFER,e.arrayBuffer,this.dynamicDraw?a.DYNAMIC_DRAW:a.STATIC_DRAW),this.dynamicDraw||delete e.arrayBuffer;}bind(){this.context.bindElementBuffer.set(this.buffer);}updateData(t){const e=this.context.gl;if(!this.dynamicDraw)throw new Error("Attempted to update data while not in dynamic mode.");this.context.unbindVAO(),this.bind(),e.bufferSubData(e.ELEMENT_ARRAY_BUFFER,0,t.arrayBuffer);}destroy(){this.buffer&&(this.context.gl.deleteBuffer(this.buffer),delete this.buffer);}}const We={Int8:"BYTE",Uint8:"UNSIGNED_BYTE",Int16:"SHORT",Uint16:"UNSIGNED_SHORT",Int32:"INT",Uint32:"UNSIGNED_INT",Float32:"FLOAT"};class $e{constructor(t,e,i,a){this.length=e.length,this.attributes=i,this.itemSize=e.bytesPerElement,this.dynamicDraw=a,this.context=t;const s=t.gl;this.buffer=s.createBuffer(),t.bindVertexBuffer.set(this.buffer),s.bufferData(s.ARRAY_BUFFER,e.arrayBuffer,this.dynamicDraw?s.DYNAMIC_DRAW:s.STATIC_DRAW),this.dynamicDraw||delete e.arrayBuffer;}bind(){this.context.bindVertexBuffer.set(this.buffer);}updateData(t){if(t.length!==this.length)throw new Error(`Length of new data is ${t.length}, which doesn't match current length of ${this.length}`);const e=this.context.gl;this.bind(),e.bufferSubData(e.ARRAY_BUFFER,0,t.arrayBuffer);}enableAttributes(t,e){for(let i=0;i<this.attributes.length;i++){const a=e.attributes[this.attributes[i].name];void 0!==a&&t.enableVertexAttribArray(a);}}setVertexAttribPointers(t,e,i){for(let a=0;a<this.attributes.length;a++){const s=this.attributes[a],o=e.attributes[s.name];void 0!==o&&t.vertexAttribPointer(o,s.components,t[We[s.type]],!1,this.itemSize,s.offset+this.itemSize*(i||0));}}destroy(){this.buffer&&(this.context.gl.deleteBuffer(this.buffer),delete this.buffer);}}const Xe=new WeakMap;function Ke(t){var e;if(Xe.has(t))return Xe.get(t);{const i=null===(e=t.getParameter(t.VERSION))||void 0===e?void 0:e.startsWith("WebGL 2.0");return Xe.set(t,i),i}}class Je{constructor(t){this.gl=t.gl,this.default=this.getDefault(),this.current=this.default,this.dirty=!1;}get(){return this.current}set(t){}getDefault(){return this.default}setDefault(){this.set(this.default);}}class Ye extends Je{getDefault(){return e.aM.transparent}set(t){const e=this.current;(t.r!==e.r||t.g!==e.g||t.b!==e.b||t.a!==e.a||this.dirty)&&(this.gl.clearColor(t.r,t.g,t.b,t.a),this.current=t,this.dirty=!1);}}class Qe extends Je{getDefault(){return 1}set(t){(t!==this.current||this.dirty)&&(this.gl.clearDepth(t),this.current=t,this.dirty=!1);}}class ti extends Je{getDefault(){return 0}set(t){(t!==this.current||this.dirty)&&(this.gl.clearStencil(t),this.current=t,this.dirty=!1);}}class ei extends Je{getDefault(){return [!0,!0,!0,!0]}set(t){const e=this.current;(t[0]!==e[0]||t[1]!==e[1]||t[2]!==e[2]||t[3]!==e[3]||this.dirty)&&(this.gl.colorMask(t[0],t[1],t[2],t[3]),this.current=t,this.dirty=!1);}}class ii extends Je{getDefault(){return !0}set(t){(t!==this.current||this.dirty)&&(this.gl.depthMask(t),this.current=t,this.dirty=!1);}}class ai extends Je{getDefault(){return 255}set(t){(t!==this.current||this.dirty)&&(this.gl.stencilMask(t),this.current=t,this.dirty=!1);}}class si extends Je{getDefault(){return {func:this.gl.ALWAYS,ref:0,mask:255}}set(t){const e=this.current;(t.func!==e.func||t.ref!==e.ref||t.mask!==e.mask||this.dirty)&&(this.gl.stencilFunc(t.func,t.ref,t.mask),this.current=t,this.dirty=!1);}}class oi extends Je{getDefault(){const t=this.gl;return [t.KEEP,t.KEEP,t.KEEP]}set(t){const e=this.current;(t[0]!==e[0]||t[1]!==e[1]||t[2]!==e[2]||this.dirty)&&(this.gl.stencilOp(t[0],t[1],t[2]),this.current=t,this.dirty=!1);}}class ri extends Je{getDefault(){return !1}set(t){if(t===this.current&&!this.dirty)return;const e=this.gl;t?e.enable(e.STENCIL_TEST):e.disable(e.STENCIL_TEST),this.current=t,this.dirty=!1;}}class ni extends Je{getDefault(){return [0,1]}set(t){const e=this.current;(t[0]!==e[0]||t[1]!==e[1]||this.dirty)&&(this.gl.depthRange(t[0],t[1]),this.current=t,this.dirty=!1);}}class li extends Je{getDefault(){return !1}set(t){if(t===this.current&&!this.dirty)return;const e=this.gl;t?e.enable(e.DEPTH_TEST):e.disable(e.DEPTH_TEST),this.current=t,this.dirty=!1;}}class hi extends Je{getDefault(){return this.gl.LESS}set(t){(t!==this.current||this.dirty)&&(this.gl.depthFunc(t),this.current=t,this.dirty=!1);}}class ci extends Je{getDefault(){return !1}set(t){if(t===this.current&&!this.dirty)return;const e=this.gl;t?e.enable(e.BLEND):e.disable(e.BLEND),this.current=t,this.dirty=!1;}}class ui extends Je{getDefault(){const t=this.gl;return [t.ONE,t.ZERO]}set(t){const e=this.current;(t[0]!==e[0]||t[1]!==e[1]||this.dirty)&&(this.gl.blendFunc(t[0],t[1]),this.current=t,this.dirty=!1);}}class di extends Je{getDefault(){return e.aM.transparent}set(t){const e=this.current;(t.r!==e.r||t.g!==e.g||t.b!==e.b||t.a!==e.a||this.dirty)&&(this.gl.blendColor(t.r,t.g,t.b,t.a),this.current=t,this.dirty=!1);}}class _i extends Je{getDefault(){return this.gl.FUNC_ADD}set(t){(t!==this.current||this.dirty)&&(this.gl.blendEquation(t),this.current=t,this.dirty=!1);}}class pi extends Je{getDefault(){return !1}set(t){if(t===this.current&&!this.dirty)return;const e=this.gl;t?e.enable(e.CULL_FACE):e.disable(e.CULL_FACE),this.current=t,this.dirty=!1;}}class mi extends Je{getDefault(){return this.gl.BACK}set(t){(t!==this.current||this.dirty)&&(this.gl.cullFace(t),this.current=t,this.dirty=!1);}}class fi extends Je{getDefault(){return this.gl.CCW}set(t){(t!==this.current||this.dirty)&&(this.gl.frontFace(t),this.current=t,this.dirty=!1);}}class gi extends Je{getDefault(){return null}set(t){(t!==this.current||this.dirty)&&(this.gl.useProgram(t),this.current=t,this.dirty=!1);}}class vi extends Je{getDefault(){return this.gl.TEXTURE0}set(t){(t!==this.current||this.dirty)&&(this.gl.activeTexture(t),this.current=t,this.dirty=!1);}}class xi extends Je{getDefault(){const t=this.gl;return [0,0,t.drawingBufferWidth,t.drawingBufferHeight]}set(t){const e=this.current;(t[0]!==e[0]||t[1]!==e[1]||t[2]!==e[2]||t[3]!==e[3]||this.dirty)&&(this.gl.viewport(t[0],t[1],t[2],t[3]),this.current=t,this.dirty=!1);}}class yi extends Je{getDefault(){return null}set(t){if(t===this.current&&!this.dirty)return;const e=this.gl;e.bindFramebuffer(e.FRAMEBUFFER,t),this.current=t,this.dirty=!1;}}class bi extends Je{getDefault(){return null}set(t){if(t===this.current&&!this.dirty)return;const e=this.gl;e.bindRenderbuffer(e.RENDERBUFFER,t),this.current=t,this.dirty=!1;}}class wi extends Je{getDefault(){return null}set(t){if(t===this.current&&!this.dirty)return;const e=this.gl;e.bindTexture(e.TEXTURE_2D,t),this.current=t,this.dirty=!1;}}class Ti extends Je{getDefault(){return null}set(t){if(t===this.current&&!this.dirty)return;const e=this.gl;e.bindBuffer(e.ARRAY_BUFFER,t),this.current=t,this.dirty=!1;}}class Ii extends Je{getDefault(){return null}set(t){const e=this.gl;e.bindBuffer(e.ELEMENT_ARRAY_BUFFER,t),this.current=t,this.dirty=!1;}}class Ei extends Je{getDefault(){return null}set(t){var e;if(t===this.current&&!this.dirty)return;const i=this.gl;Ke(i)?i.bindVertexArray(t):null===(e=i.getExtension("OES_vertex_array_object"))||void 0===e||e.bindVertexArrayOES(t),this.current=t,this.dirty=!1;}}class Pi extends Je{getDefault(){return 4}set(t){if(t===this.current&&!this.dirty)return;const e=this.gl;e.pixelStorei(e.UNPACK_ALIGNMENT,t),this.current=t,this.dirty=!1;}}class Ci extends Je{getDefault(){return !1}set(t){if(t===this.current&&!this.dirty)return;const e=this.gl;e.pixelStorei(e.UNPACK_PREMULTIPLY_ALPHA_WEBGL,t),this.current=t,this.dirty=!1;}}class Si extends Je{getDefault(){return !1}set(t){if(t===this.current&&!this.dirty)return;const e=this.gl;e.pixelStorei(e.UNPACK_FLIP_Y_WEBGL,t),this.current=t,this.dirty=!1;}}class zi extends Je{constructor(t,e){super(t),this.context=t,this.parent=e;}getDefault(){return null}}class Di extends zi{setDirty(){this.dirty=!0;}set(t){if(t===this.current&&!this.dirty)return;this.context.bindFramebuffer.set(this.parent);const e=this.gl;e.framebufferTexture2D(e.FRAMEBUFFER,e.COLOR_ATTACHMENT0,e.TEXTURE_2D,t,0),this.current=t,this.dirty=!1;}}class Mi extends zi{set(t){if(t===this.current&&!this.dirty)return;this.context.bindFramebuffer.set(this.parent);const e=this.gl;e.framebufferRenderbuffer(e.FRAMEBUFFER,e.DEPTH_ATTACHMENT,e.RENDERBUFFER,t),this.current=t,this.dirty=!1;}}class Ai extends zi{set(t){if(t===this.current&&!this.dirty)return;this.context.bindFramebuffer.set(this.parent);const e=this.gl;e.framebufferRenderbuffer(e.FRAMEBUFFER,e.DEPTH_STENCIL_ATTACHMENT,e.RENDERBUFFER,t),this.current=t,this.dirty=!1;}}class Ri{constructor(t,e,i,a,s){this.context=t,this.width=e,this.height=i;const o=t.gl,r=this.framebuffer=o.createFramebuffer();if(this.colorAttachment=new Di(t,r),a)this.depthAttachment=s?new Ai(t,r):new Mi(t,r);else if(s)throw new Error("Stencil cannot be set without depth");if(o.checkFramebufferStatus(o.FRAMEBUFFER)!==o.FRAMEBUFFER_COMPLETE)throw new Error("Framebuffer is not complete")}destroy(){const t=this.context.gl,e=this.colorAttachment.get();if(e&&t.deleteTexture(e),this.depthAttachment){const e=this.depthAttachment.get();e&&t.deleteRenderbuffer(e);}t.deleteFramebuffer(this.framebuffer);}}class ki{constructor(t,e,i){this.blendFunction=t,this.blendColor=e,this.mask=i;}}ki.Replace=[1,0],ki.disabled=new ki(ki.Replace,e.aM.transparent,[!1,!1,!1,!1]),ki.unblended=new ki(ki.Replace,e.aM.transparent,[!0,!0,!0,!0]),ki.alphaBlended=new ki([1,771],e.aM.transparent,[!0,!0,!0,!0]);class Li{constructor(t){var e,i;if(this.gl=t,this.clearColor=new Ye(this),this.clearDepth=new Qe(this),this.clearStencil=new ti(this),this.colorMask=new ei(this),this.depthMask=new ii(this),this.stencilMask=new ai(this),this.stencilFunc=new si(this),this.stencilOp=new oi(this),this.stencilTest=new ri(this),this.depthRange=new ni(this),this.depthTest=new li(this),this.depthFunc=new hi(this),this.blend=new ci(this),this.blendFunc=new ui(this),this.blendColor=new di(this),this.blendEquation=new _i(this),this.cullFace=new pi(this),this.cullFaceSide=new mi(this),this.frontFace=new fi(this),this.program=new gi(this),this.activeTexture=new vi(this),this.viewport=new xi(this),this.bindFramebuffer=new yi(this),this.bindRenderbuffer=new bi(this),this.bindTexture=new wi(this),this.bindVertexBuffer=new Ti(this),this.bindElementBuffer=new Ii(this),this.bindVertexArray=new Ei(this),this.pixelStoreUnpack=new Pi(this),this.pixelStoreUnpackPremultiplyAlpha=new Ci(this),this.pixelStoreUnpackFlipY=new Si(this),this.extTextureFilterAnisotropic=t.getExtension("EXT_texture_filter_anisotropic")||t.getExtension("MOZ_EXT_texture_filter_anisotropic")||t.getExtension("WEBKIT_EXT_texture_filter_anisotropic"),this.extTextureFilterAnisotropic&&(this.extTextureFilterAnisotropicMax=t.getParameter(this.extTextureFilterAnisotropic.MAX_TEXTURE_MAX_ANISOTROPY_EXT)),this.maxTextureSize=t.getParameter(t.MAX_TEXTURE_SIZE),Ke(t)){this.HALF_FLOAT=t.HALF_FLOAT;const a=t.getExtension("EXT_color_buffer_half_float");this.RGBA16F=null!==(e=t.RGBA16F)&&void 0!==e?e:null==a?void 0:a.RGBA16F_EXT,this.RGB16F=null!==(i=t.RGB16F)&&void 0!==i?i:null==a?void 0:a.RGB16F_EXT,t.getExtension("EXT_color_buffer_float");}else {t.getExtension("EXT_color_buffer_half_float"),t.getExtension("OES_texture_half_float_linear");const e=t.getExtension("OES_texture_half_float");this.HALF_FLOAT=null==e?void 0:e.HALF_FLOAT_OES;}}setDefault(){this.unbindVAO(),this.clearColor.setDefault(),this.clearDepth.setDefault(),this.clearStencil.setDefault(),this.colorMask.setDefault(),this.depthMask.setDefault(),this.stencilMask.setDefault(),this.stencilFunc.setDefault(),this.stencilOp.setDefault(),this.stencilTest.setDefault(),this.depthRange.setDefault(),this.depthTest.setDefault(),this.depthFunc.setDefault(),this.blend.setDefault(),this.blendFunc.setDefault(),this.blendColor.setDefault(),this.blendEquation.setDefault(),this.cullFace.setDefault(),this.cullFaceSide.setDefault(),this.frontFace.setDefault(),this.program.setDefault(),this.activeTexture.setDefault(),this.bindFramebuffer.setDefault(),this.pixelStoreUnpack.setDefault(),this.pixelStoreUnpackPremultiplyAlpha.setDefault(),this.pixelStoreUnpackFlipY.setDefault();}setDirty(){this.clearColor.dirty=!0,this.clearDepth.dirty=!0,this.clearStencil.dirty=!0,this.colorMask.dirty=!0,this.depthMask.dirty=!0,this.stencilMask.dirty=!0,this.stencilFunc.dirty=!0,this.stencilOp.dirty=!0,this.stencilTest.dirty=!0,this.depthRange.dirty=!0,this.depthTest.dirty=!0,this.depthFunc.dirty=!0,this.blend.dirty=!0,this.blendFunc.dirty=!0,this.blendColor.dirty=!0,this.blendEquation.dirty=!0,this.cullFace.dirty=!0,this.cullFaceSide.dirty=!0,this.frontFace.dirty=!0,this.program.dirty=!0,this.activeTexture.dirty=!0,this.viewport.dirty=!0,this.bindFramebuffer.dirty=!0,this.bindRenderbuffer.dirty=!0,this.bindTexture.dirty=!0,this.bindVertexBuffer.dirty=!0,this.bindElementBuffer.dirty=!0,this.bindVertexArray.dirty=!0,this.pixelStoreUnpack.dirty=!0,this.pixelStoreUnpackPremultiplyAlpha.dirty=!0,this.pixelStoreUnpackFlipY.dirty=!0;}createIndexBuffer(t,e){return new He(this,t,e)}createVertexBuffer(t,e,i){return new $e(this,t,e,i)}createRenderbuffer(t,e,i){const a=this.gl,s=a.createRenderbuffer();return this.bindRenderbuffer.set(s),a.renderbufferStorage(a.RENDERBUFFER,t,e,i),this.bindRenderbuffer.set(null),s}createFramebuffer(t,e,i,a){return new Ri(this,t,e,i,a)}clear({color:t,depth:e,stencil:i}){const a=this.gl;let s=0;t&&(s|=a.COLOR_BUFFER_BIT,this.clearColor.set(t),this.colorMask.set([!0,!0,!0,!0])),void 0!==e&&(s|=a.DEPTH_BUFFER_BIT,this.depthRange.set([0,1]),this.clearDepth.set(e),this.depthMask.set(!0)),void 0!==i&&(s|=a.STENCIL_BUFFER_BIT,this.clearStencil.set(i),this.stencilMask.set(255)),a.clear(s);}setCullFace(t){!1===t.enable?this.cullFace.set(!1):(this.cullFace.set(!0),this.cullFaceSide.set(t.mode),this.frontFace.set(t.frontFace));}setDepthMode(t){t.func!==this.gl.ALWAYS||t.mask?(this.depthTest.set(!0),this.depthFunc.set(t.func),this.depthMask.set(t.mask),this.depthRange.set(t.range)):this.depthTest.set(!1);}setStencilMode(t){t.test.func!==this.gl.ALWAYS||t.mask?(this.stencilTest.set(!0),this.stencilMask.set(t.mask),this.stencilOp.set([t.fail,t.depthFail,t.pass]),this.stencilFunc.set({func:t.test.func,ref:t.ref,mask:t.test.mask})):this.stencilTest.set(!1);}setColorMode(t){e.aE(t.blendFunction,ki.Replace)?this.blend.set(!1):(this.blend.set(!0),this.blendFunc.set(t.blendFunction),this.blendColor.set(t.blendColor)),this.colorMask.set(t.mask);}createVertexArray(){var t;return Ke(this.gl)?this.gl.createVertexArray():null===(t=this.gl.getExtension("OES_vertex_array_object"))||void 0===t?void 0:t.createVertexArrayOES()}deleteVertexArray(t){var e;return Ke(this.gl)?this.gl.deleteVertexArray(t):null===(e=this.gl.getExtension("OES_vertex_array_object"))||void 0===e?void 0:e.deleteVertexArrayOES(t)}unbindVAO(){this.bindVertexArray.set(null);}}class Fi{constructor(t,e,i){this.func=t,this.mask=e,this.range=i;}}Fi.ReadOnly=!1,Fi.ReadWrite=!0,Fi.disabled=new Fi(519,Fi.ReadOnly,[0,1]);const Bi=7680;class Oi{constructor(t,e,i,a,s,o){this.test=t,this.ref=e,this.mask=i,this.fail=a,this.depthFail=s,this.pass=o;}}Oi.disabled=new Oi({func:519,mask:0},0,0,Bi,Bi,Bi);class Ni{constructor(t,e,i){this.enable=t,this.mode=e,this.frontFace=i;}}let ji;function Ui(t,i,a,s,o){const r=t.context,n=r.gl,l=t.useProgram("collisionBox"),h=[];let c=0,u=0;for(let _=0;_<s.length;_++){const p=s[_],m=i.getTile(p).getBucket(a);if(!m)continue;const f=o?m.textCollisionBox:m.iconCollisionBox,g=m.collisionCircleArray;if(g.length>0){const i=e.H();e.aQ(i,m.placementInvProjMatrix,t.transform.glCoordMatrix),e.aQ(i,i,m.placementViewportMatrix),h.push({circleArray:g,circleOffset:u,transform:p.posMatrix,invTransform:i,coord:p}),c+=g.length/4,u=c;}f&&l.draw(r,n.LINES,Fi.disabled,Oi.disabled,t.colorModeForRenderPass(),Ni.disabled,{u_matrix:p.posMatrix,u_pixel_extrude_scale:[1/(d=t.transform).width,1/d.height]},t.style.map.terrain&&t.style.map.terrain.getTerrainData(p),a.id,f.layoutVertexBuffer,f.indexBuffer,f.segments,null,t.transform.zoom,null,null,f.collisionVertexBuffer);}var d;if(!o||!h.length)return;const _=t.useProgram("collisionCircle"),p=new e.aR;p.resize(4*c),p._trim();let m=0;for(const t of h)for(let e=0;e<t.circleArray.length/4;e++){const i=4*e,a=t.circleArray[i+0],s=t.circleArray[i+1],o=t.circleArray[i+2],r=t.circleArray[i+3];p.emplace(m++,a,s,o,r,0),p.emplace(m++,a,s,o,r,1),p.emplace(m++,a,s,o,r,2),p.emplace(m++,a,s,o,r,3);}(!ji||ji.length<2*c)&&(ji=function(t){const i=2*t,a=new e.aT;a.resize(i),a._trim();for(let t=0;t<i;t++){const e=6*t;a.uint16[e+0]=4*t+0,a.uint16[e+1]=4*t+1,a.uint16[e+2]=4*t+2,a.uint16[e+3]=4*t+2,a.uint16[e+4]=4*t+3,a.uint16[e+5]=4*t+0;}return a}(c));const f=r.createIndexBuffer(ji,!0),g=r.createVertexBuffer(p,e.aS.members,!0);for(const i of h){const s=Ce(i.transform,i.invTransform,t.transform);_.draw(r,n.TRIANGLES,Fi.disabled,Oi.disabled,t.colorModeForRenderPass(),Ni.disabled,s,t.style.map.terrain&&t.style.map.terrain.getTerrainData(i.coord),a.id,g,f,e.a0.simpleSegment(0,2*i.circleOffset,i.circleArray.length,i.circleArray.length/2),null,t.transform.zoom,null,null,null);}g.destroy(),f.destroy();}Ni.disabled=new Ni(!1,1029,2305),Ni.backCCW=new Ni(!0,1029,2305);const Zi=e.an(new Float32Array(16));function qi(t,i,a,s,o,r){const{horizontalAlign:n,verticalAlign:l}=e.au(t);return new e.P((-(n-.5)*i/o+s[0])*r,(-(l-.5)*a/o+s[1])*r)}function Vi(t,i,a,s,o,r){const n=i.tileAnchorPoint.add(new e.P(i.translation[0],i.translation[1]));if(i.pitchWithMap){let t=s.mult(r);return a||(t=t.rotate(-o)),xt(n.add(t),i.labelPlaneMatrix,i.getElevation).point}if(a){const e=St(i.tileAnchorPoint.x+1,i.tileAnchorPoint.y,i).point.sub(t),a=Math.atan(e.y/e.x)+(e.x<0?Math.PI:0);return t.add(s.rotate(a))}return t.add(s)}function Gi(t,i,a,s,o,r,n,l,h,c,u,d,_,p){const m=t.text.placedSymbolArray,f=t.text.dynamicLayoutVertexArray,g=t.icon.dynamicLayoutVertexArray,v={};f.clear();for(let g=0;g<m.length;g++){const x=m.get(g),y=x.hidden||!x.crossTileID||t.allowVerticalPlacement&&!x.placedOrientation?null:s[x.crossTileID];if(y){const s=new e.P(x.anchorX,x.anchorY),m={getElevation:p,width:o.width,height:o.height,labelPlaneMatrix:r,lineVertexArray:null,pitchWithMap:a,projection:u,projectionCache:null,tileAnchorPoint:s,translation:d,unwrappedTileID:_},g=a?xt(s,n,p):St(s.x,s.y,m),b=yt(o.cameraToCenterDistance,g.signedDistanceFromCamera);let w=e.ai(t.textSizeData,h,x)*b/e.ap;a&&(w*=t.tilePixelRatio/l);const{width:T,height:I,anchor:E,textOffset:P,textBoxScale:C}=y,S=qi(E,T,I,P,C,w),z=u.getPitchedTextCorrection(o,s.add(new e.P(d[0],d[1])),_),D=Vi(g.point,m,i,S,o.angle,z),M=t.allowVerticalPlacement&&x.placedOrientation===e.ah.vertical?Math.PI/2:0;for(let t=0;t<x.numGlyphs;t++)e.aj(f,D,M);c&&x.associatedIconIndex>=0&&(v[x.associatedIconIndex]={shiftedAnchor:D,angle:M});}else Rt(x.numGlyphs,f);}if(c){g.clear();const i=t.icon.placedSymbolArray;for(let t=0;t<i.length;t++){const a=i.get(t);if(a.hidden)Rt(a.numGlyphs,g);else {const i=v[t];if(i)for(let t=0;t<a.numGlyphs;t++)e.aj(g,i.shiftedAnchor,i.angle);else Rt(a.numGlyphs,g);}}t.icon.dynamicLayoutVertexBuffer.updateData(g);}t.text.dynamicLayoutVertexBuffer.updateData(f);}function Hi(t,e,i){return i.iconsInText&&e?"symbolTextAndIcon":t?"symbolSDF":"symbolIcon"}function Wi(t,i,a,s,o,r,n,l,h,c,u,d){const _=t.context,p=_.gl,m=t.transform,f=ee(),g="map"===l,v="map"===h,x="viewport"!==l&&"point"!==a.layout.get("symbol-placement"),y=g&&!v&&!x,b=!v&&x,w=!a.layout.get("symbol-sort-key").isConstant();let T=!1;const I=t.depthModeForSublayer(0,Fi.ReadOnly),E=a._unevaluatedLayout.hasValue("text-variable-anchor")||a._unevaluatedLayout.hasValue("text-variable-anchor-offset"),P=[],C=f.getCircleRadiusCorrection(m);for(const l of s){const s=i.getTile(l),h=s.getBucket(a);if(!h)continue;const u=o?h.text:h.icon;if(!u||!u.segments.get().length||!u.hasVisibleVertices)continue;const d=u.programConfigurations.get(a.id),_=o||h.sdfIcons,I=o?h.textSizeData:h.iconSizeData,S=v||0!==m.pitch,z=t.useProgram(Hi(_,o,h),d),D=e.ag(I,m.zoom),M=t.style.map.terrain&&t.style.map.terrain.getTerrainData(l);let A,R,k,L,F=[0,0],B=null;if(o)R=s.glyphAtlasTexture,k=p.LINEAR,A=s.glyphAtlasTexture.size,h.iconsInText&&(F=s.imageAtlasTexture.size,B=s.imageAtlasTexture,L=S||t.options.rotating||t.options.zooming||"composite"===I.kind||"camera"===I.kind?p.LINEAR:p.NEAREST);else {const e=1!==a.layout.get("icon-size").constantOr(0)||h.iconsNeedLinear;R=s.imageAtlasTexture,k=_||t.options.rotating||t.options.zooming||e||S?p.LINEAR:p.NEAREST,A=s.imageAtlasTexture.size;}const O=Ft(s,1,t.transform.zoom),N=b?l.posMatrix:Zi,j=gt(N,v,g,t.transform,O),U=vt(N,v,g,t.transform,O),Z=vt(l.posMatrix,v,g,t.transform,O),q=f.translatePosition(t.transform,s,r,n),V=E&&h.hasTextData(),G="none"!==a.layout.get("icon-text-fit")&&V&&h.hasIconData();if(x){const e=t.style.map.terrain?(e,i)=>t.style.map.terrain.getElevation(l,e,i):null,i="map"===a.layout.get("text-rotation-alignment");wt(h,l.posMatrix,t,o,j,Z,v,c,i,f,l.toUnwrapped(),m.width,m.height,q,e);}const H=l.posMatrix,W=o&&E||G,$=x||W?Zi:j,X=U,K=_&&0!==a.paint.get(o?"text-halo-width":"icon-halo-width").constantOr(1);let J;J=_?h.iconsInText?Ze(I.kind,D,y,v,x,W,t,H,$,X,q,A,F,C):Ue(I.kind,D,y,v,x,W,t,H,$,X,q,o,A,!0,C):je(I.kind,D,y,v,x,W,t,H,$,X,q,o,A,C);const Y={program:z,buffers:u,uniformValues:J,atlasTexture:R,atlasTextureIcon:B,atlasInterpolation:k,atlasInterpolationIcon:L,isSDF:_,hasHalo:K};if(w&&h.canOverlap){T=!0;const t=u.segments.get();for(const i of t)P.push({segments:new e.a0([i]),sortKey:i.sortKey,state:Y,terrainData:M});}else P.push({segments:u.segments,sortKey:0,state:Y,terrainData:M});}T&&P.sort(((t,e)=>t.sortKey-e.sortKey));for(const e of P){const i=e.state;if(_.activeTexture.set(p.TEXTURE0),i.atlasTexture.bind(i.atlasInterpolation,p.CLAMP_TO_EDGE),i.atlasTextureIcon&&(_.activeTexture.set(p.TEXTURE1),i.atlasTextureIcon&&i.atlasTextureIcon.bind(i.atlasInterpolationIcon,p.CLAMP_TO_EDGE)),i.isSDF){const s=i.uniformValues;i.hasHalo&&(s.u_is_halo=1,$i(i.buffers,e.segments,a,t,i.program,I,u,d,s,e.terrainData)),s.u_is_halo=0;}$i(i.buffers,e.segments,a,t,i.program,I,u,d,i.uniformValues,e.terrainData);}}function $i(t,e,i,a,s,o,r,n,l,h){const c=a.context;s.draw(c,c.gl.TRIANGLES,o,r,n,Ni.disabled,l,h,i.id,t.layoutVertexBuffer,t.indexBuffer,e,i.paint,a.transform.zoom,t.programConfigurations.get(i.id),t.dynamicLayoutVertexBuffer,t.opacityVertexBuffer);}function Xi(t,e,i,a,s){if(!i||!a||!a.imageAtlas)return;const o=a.imageAtlas.patternPositions;let r=o[i.to.toString()],n=o[i.from.toString()];if(!r&&n&&(r=n),!n&&r&&(n=r),!r||!n){const t=s.getPaintProperty(e);r=o[t],n=o[t];}r&&n&&t.setConstantPatternPositions(r,n);}function Ki(t,e,i,a,s,o,r){const n=t.context.gl,l="fill-pattern",h=i.paint.get(l),c=h&&h.constantOr(1),u=i.getCrossfadeParameters();let d,_,p,m,f;r?(_=c&&!i.getPaintProperty("fill-outline-color")?"fillOutlinePattern":"fillOutline",d=n.LINES):(_=c?"fillPattern":"fill",d=n.TRIANGLES);const g=h.constantOr(null);for(const h of a){const a=e.getTile(h);if(c&&!a.patternsLoaded())continue;const v=a.getBucket(i);if(!v)continue;const x=v.programConfigurations.get(i.id),y=t.useProgram(_,x),b=t.style.map.terrain&&t.style.map.terrain.getTerrainData(h);c&&(t.context.activeTexture.set(n.TEXTURE0),a.imageAtlasTexture.bind(n.LINEAR,n.CLAMP_TO_EDGE),x.updatePaintBuffers(u)),Xi(x,l,g,a,i);const w=b?h:null,T=t.translatePosMatrix(w?w.posMatrix:h.posMatrix,a,i.paint.get("fill-translate"),i.paint.get("fill-translate-anchor"));if(r){m=v.indexBuffer2,f=v.segments2;const e=[n.drawingBufferWidth,n.drawingBufferHeight];p="fillOutlinePattern"===_&&c?Ee(T,t,u,a,e):Ie(T,e);}else m=v.indexBuffer,f=v.segments,p=c?Te(T,t,u,a):we(T);y.draw(t.context,d,s,t.stencilModeForClipping(h),o,Ni.disabled,p,b,i.id,v.layoutVertexBuffer,m,f,i.paint,t.transform.zoom,x);}}function Ji(t,e,i,a,s,o,r){const n=t.context,l=n.gl,h="fill-extrusion-pattern",c=i.paint.get(h),u=c.constantOr(1),d=i.getCrossfadeParameters(),_=i.paint.get("fill-extrusion-opacity"),p=c.constantOr(null);for(const c of a){const a=e.getTile(c),m=a.getBucket(i);if(!m)continue;const f=t.style.map.terrain&&t.style.map.terrain.getTerrainData(c),g=m.programConfigurations.get(i.id),v=t.useProgram(u?"fillExtrusionPattern":"fillExtrusion",g);u&&(t.context.activeTexture.set(l.TEXTURE0),a.imageAtlasTexture.bind(l.LINEAR,l.CLAMP_TO_EDGE),g.updatePaintBuffers(d)),Xi(g,h,p,a,i);const x=t.translatePosMatrix(c.posMatrix,a,i.paint.get("fill-extrusion-translate"),i.paint.get("fill-extrusion-translate-anchor")),y=i.paint.get("fill-extrusion-vertical-gradient"),b=u?be(x,t,y,_,c,d,a):ye(x,t,y,_);v.draw(n,n.gl.TRIANGLES,s,o,r,Ni.backCCW,b,f,i.id,m.layoutVertexBuffer,m.indexBuffer,m.segments,i.paint,t.transform.zoom,g,t.style.map.terrain&&m.centroidVertexBuffer);}}function Yi(t,e,i,a,s,o,r){const n=t.context,l=n.gl,h=i.fbo;if(!h)return;const c=t.useProgram("hillshade"),u=t.style.map.terrain&&t.style.map.terrain.getTerrainData(e);n.activeTexture.set(l.TEXTURE0),l.bindTexture(l.TEXTURE_2D,h.colorAttachment.get()),c.draw(n,l.TRIANGLES,s,o,r,Ni.disabled,((t,e,i,a)=>{const s=i.paint.get("hillshade-shadow-color"),o=i.paint.get("hillshade-highlight-color"),r=i.paint.get("hillshade-accent-color");let n=i.paint.get("hillshade-illumination-direction")*(Math.PI/180);"viewport"===i.paint.get("hillshade-illumination-anchor")&&(n-=t.transform.angle);const l=!t.options.moving;return {u_matrix:a?a.posMatrix:t.transform.calculatePosMatrix(e.tileID.toUnwrapped(),l),u_image:0,u_latrange:Me(0,e.tileID),u_light:[i.paint.get("hillshade-exaggeration"),n],u_shadow:s,u_highlight:o,u_accent:r}})(t,i,a,u?e:null),u,a.id,t.rasterBoundsBuffer,t.quadTriangleIndexBuffer,t.rasterBoundsSegments);}function Qi(t,i,a,s,o,r){const n=t.context,l=n.gl,h=i.dem;if(h&&h.data){const c=h.dim,u=h.stride,d=h.getPixels();if(n.activeTexture.set(l.TEXTURE1),n.pixelStoreUnpackPremultiplyAlpha.set(!1),i.demTexture=i.demTexture||t.getTileTexture(u),i.demTexture){const t=i.demTexture;t.update(d,{premultiply:!1}),t.bind(l.NEAREST,l.CLAMP_TO_EDGE);}else i.demTexture=new b(n,d,l.RGBA,{premultiply:!1}),i.demTexture.bind(l.NEAREST,l.CLAMP_TO_EDGE);n.activeTexture.set(l.TEXTURE0);let _=i.fbo;if(!_){const t=new b(n,{width:c,height:c,data:null},l.RGBA);t.bind(l.LINEAR,l.CLAMP_TO_EDGE),_=i.fbo=n.createFramebuffer(c,c,!0,!1),_.colorAttachment.set(t.texture);}n.bindFramebuffer.set(_.framebuffer),n.viewport.set([0,0,c,c]),t.useProgram("hillshadePrepare").draw(n,l.TRIANGLES,s,o,r,Ni.disabled,((t,i)=>{const a=i.stride,s=e.H();return e.aP(s,0,e.X,-e.X,0,0,1),e.J(s,s,[0,-e.X,0]),{u_matrix:s,u_image:1,u_dimension:[a,a],u_zoom:t.overscaledZ,u_unpack:i.getUnpackVector()}})(i.tileID,h),null,a.id,t.rasterBoundsBuffer,t.quadTriangleIndexBuffer,t.rasterBoundsSegments),i.needsHillshadePrepare=!1;}}function ta(t,i,a,s,r,n){const l=s.paint.get("raster-fade-duration");if(!n&&l>0){const s=o.now(),n=(s-t.timeAdded)/l,h=i?(s-i.timeAdded)/l:-1,c=a.getSource(),u=r.coveringZoomLevel({tileSize:c.tileSize,roundZoom:c.roundZoom}),d=!i||Math.abs(i.tileID.overscaledZ-u)>Math.abs(t.tileID.overscaledZ-u),_=d&&t.refreshedUponExpiration?1:e.ac(d?n:1-h,0,1);return t.refreshedUponExpiration&&n>=1&&(t.refreshedUponExpiration=!1),i?{opacity:1,mix:1-_}:{opacity:_,mix:0}}return {opacity:1,mix:0}}const ea=new e.aM(1,0,0,1),ia=new e.aM(0,1,0,1),aa=new e.aM(0,0,1,1),sa=new e.aM(1,0,1,1),oa=new e.aM(0,1,1,1);function ra(t,e,i,a){la(t,0,e+i/2,t.transform.width,i,a);}function na(t,e,i,a){la(t,e-i/2,0,i,t.transform.height,a);}function la(t,e,i,a,s,o){const r=t.context,n=r.gl;n.enable(n.SCISSOR_TEST),n.scissor(e*t.pixelRatio,i*t.pixelRatio,a*t.pixelRatio,s*t.pixelRatio),r.clear({color:o}),n.disable(n.SCISSOR_TEST);}function ha(t,i,a){const s=t.context,o=s.gl,r=a.posMatrix,n=t.useProgram("debug"),l=Fi.disabled,h=Oi.disabled,c=t.colorModeForRenderPass(),u="$debug",d=t.style.map.terrain&&t.style.map.terrain.getTerrainData(a);s.activeTexture.set(o.TEXTURE0);const _=i.getTileByID(a.key).latestRawTileData,p=Math.floor((_&&_.byteLength||0)/1024),m=i.getTile(a).tileSize,f=512/Math.min(m,512)*(a.overscaledZ/t.transform.zoom)*.5;let g=a.canonical.toString();a.overscaledZ!==a.canonical.z&&(g+=` => ${a.overscaledZ}`),function(t,e){t.initDebugOverlayCanvas();const i=t.debugOverlayCanvas,a=t.context.gl,s=t.debugOverlayCanvas.getContext("2d");s.clearRect(0,0,i.width,i.height),s.shadowColor="white",s.shadowBlur=2,s.lineWidth=1.5,s.strokeStyle="white",s.textBaseline="top",s.font="bold 36px Open Sans, sans-serif",s.fillText(e,5,5),s.strokeText(e,5,5),t.debugOverlayTexture.update(i),t.debugOverlayTexture.bind(a.LINEAR,a.CLAMP_TO_EDGE);}(t,`${g} ${p}kB`),n.draw(s,o.TRIANGLES,l,h,ki.alphaBlended,Ni.disabled,Se(r,e.aM.transparent,f),null,u,t.debugBuffer,t.quadTriangleIndexBuffer,t.debugSegments),n.draw(s,o.LINE_STRIP,l,h,c,Ni.disabled,Se(r,e.aM.red),d,u,t.debugBuffer,t.tileBorderIndexBuffer,t.debugSegments);}function ca(t,e,i){const a=t.context,s=a.gl,o=t.colorModeForRenderPass(),r=new Fi(s.LEQUAL,Fi.ReadWrite,t.depthRangeFor3D),n=t.useProgram("terrain"),l=e.getTerrainMesh();a.bindFramebuffer.set(null),a.viewport.set([0,0,t.width,t.height]);for(const h of i){const i=t.renderToTexture.getTexture(h),c=e.getTerrainData(h.tileID);a.activeTexture.set(s.TEXTURE0),s.bindTexture(s.TEXTURE_2D,i.texture);const u=t.transform.calculatePosMatrix(h.tileID.toUnwrapped()),d=e.getMeshFrameDelta(t.transform.zoom),_=t.transform.calculateFogMatrix(h.tileID.toUnwrapped()),p=fe(u,d,_,t.style.sky,t.transform.pitch);n.draw(a,s.TRIANGLES,r,Oi.disabled,o,Ni.backCCW,p,c,"terrain",l.vertexBuffer,l.indexBuffer,l.segments);}}class ua{constructor(t,e,i){this.vertexBuffer=t,this.indexBuffer=e,this.segments=i;}destroy(){this.vertexBuffer.destroy(),this.indexBuffer.destroy(),this.segments.destroy(),this.vertexBuffer=null,this.indexBuffer=null,this.segments=null;}}class da{constructor(t,i){this.context=new Li(t),this.transform=i,this._tileTextures={},this.terrainFacilitator={dirty:!0,matrix:e.an(new Float64Array(16)),renderTime:0},this.setup(),this.numSublayers=ut.maxUnderzooming+ut.maxOverzooming+1,this.depthEpsilon=1/Math.pow(2,16),this.crossTileSymbolIndex=new le;}resize(t,e,i){if(this.width=Math.floor(t*i),this.height=Math.floor(e*i),this.pixelRatio=i,this.context.viewport.set([0,0,this.width,this.height]),this.style)for(const t of this.style._order)this.style._layers[t].resize();}setup(){const t=this.context,i=new e.aW;i.emplaceBack(0,0),i.emplaceBack(e.X,0),i.emplaceBack(0,e.X),i.emplaceBack(e.X,e.X),this.tileExtentBuffer=t.createVertexBuffer(i,de.members),this.tileExtentSegments=e.a0.simpleSegment(0,0,4,2);const a=new e.aW;a.emplaceBack(0,0),a.emplaceBack(e.X,0),a.emplaceBack(0,e.X),a.emplaceBack(e.X,e.X),this.debugBuffer=t.createVertexBuffer(a,de.members),this.debugSegments=e.a0.simpleSegment(0,0,4,5);const s=new e.$;s.emplaceBack(0,0,0,0),s.emplaceBack(e.X,0,e.X,0),s.emplaceBack(0,e.X,0,e.X),s.emplaceBack(e.X,e.X,e.X,e.X),this.rasterBoundsBuffer=t.createVertexBuffer(s,Y.members),this.rasterBoundsSegments=e.a0.simpleSegment(0,0,4,2);const o=new e.aW;o.emplaceBack(0,0),o.emplaceBack(1,0),o.emplaceBack(0,1),o.emplaceBack(1,1),this.viewportBuffer=t.createVertexBuffer(o,de.members),this.viewportSegments=e.a0.simpleSegment(0,0,4,2);const r=new e.aY;r.emplaceBack(0),r.emplaceBack(1),r.emplaceBack(3),r.emplaceBack(2),r.emplaceBack(0),this.tileBorderIndexBuffer=t.createIndexBuffer(r);const n=new e.aX;n.emplaceBack(0,1,2),n.emplaceBack(2,1,3),this.quadTriangleIndexBuffer=t.createIndexBuffer(n);const l=this.context.gl;this.stencilClearMode=new Oi({func:l.ALWAYS,mask:0},0,255,l.ZERO,l.ZERO,l.ZERO);}clearStencil(){const t=this.context,i=t.gl;this.nextStencilID=1,this.currentStencilSource=void 0;const a=e.H();e.aP(a,0,this.width,this.height,0,0,1),e.K(a,a,[i.drawingBufferWidth,i.drawingBufferHeight,0]),this.useProgram("clippingMask").draw(t,i.TRIANGLES,Fi.disabled,this.stencilClearMode,ki.disabled,Ni.disabled,ze(a),null,"$clipping",this.viewportBuffer,this.quadTriangleIndexBuffer,this.viewportSegments);}_renderTileClippingMasks(t,e){if(this.currentStencilSource===t.source||!t.isTileClipped()||!e||!e.length)return;this.currentStencilSource=t.source;const i=this.context,a=i.gl;this.nextStencilID+e.length>256&&this.clearStencil(),i.setColorMode(ki.disabled),i.setDepthMode(Fi.disabled);const s=this.useProgram("clippingMask");this._tileClippingMaskIDs={};for(const t of e){const e=this._tileClippingMaskIDs[t.key]=this.nextStencilID++,o=this.style.map.terrain&&this.style.map.terrain.getTerrainData(t);s.draw(i,a.TRIANGLES,Fi.disabled,new Oi({func:a.ALWAYS,mask:0},e,255,a.KEEP,a.KEEP,a.REPLACE),ki.disabled,Ni.disabled,ze(t.posMatrix),o,"$clipping",this.tileExtentBuffer,this.quadTriangleIndexBuffer,this.tileExtentSegments);}}stencilModeFor3D(){this.currentStencilSource=void 0,this.nextStencilID+1>256&&this.clearStencil();const t=this.nextStencilID++,e=this.context.gl;return new Oi({func:e.NOTEQUAL,mask:255},t,255,e.KEEP,e.KEEP,e.REPLACE)}stencilModeForClipping(t){const e=this.context.gl;return new Oi({func:e.EQUAL,mask:255},this._tileClippingMaskIDs[t.key],0,e.KEEP,e.KEEP,e.REPLACE)}stencilConfigForOverlap(t){const e=this.context.gl,i=t.sort(((t,e)=>e.overscaledZ-t.overscaledZ)),a=i[i.length-1].overscaledZ,s=i[0].overscaledZ-a+1;if(s>1){this.currentStencilSource=void 0,this.nextStencilID+s>256&&this.clearStencil();const t={};for(let i=0;i<s;i++)t[i+a]=new Oi({func:e.GEQUAL,mask:255},i+this.nextStencilID,255,e.KEEP,e.KEEP,e.REPLACE);return this.nextStencilID+=s,[t,i]}return [{[a]:Oi.disabled},i]}colorModeForRenderPass(){const t=this.context.gl;if(this._showOverdrawInspector){const i=1/8;return new ki([t.CONSTANT_COLOR,t.ONE],new e.aM(i,i,i,0),[!0,!0,!0,!0])}return "opaque"===this.renderPass?ki.unblended:ki.alphaBlended}depthModeForSublayer(t,e,i){if(!this.opaquePassEnabledForLayer())return Fi.disabled;const a=1-((1+this.currentLayer)*this.numSublayers+t)*this.depthEpsilon;return new Fi(i||this.context.gl.LEQUAL,e,[a,a])}opaquePassEnabledForLayer(){return this.currentLayer<this.opaquePassCutoff}render(t,i){this.style=t,this.options=i,this.lineAtlas=t.lineAtlas,this.imageManager=t.imageManager,this.glyphManager=t.glyphManager,this.symbolFadeChange=t.placement.symbolFadeChange(o.now()),this.imageManager.beginFrame();const a=this.style._order,s=this.style.sourceCaches,r={},n={},l={};for(const t in s){const e=s[t];e.used&&e.prepare(this.context),r[t]=e.getVisibleCoordinates(),n[t]=r[t].slice().reverse(),l[t]=e.getVisibleCoordinates(!0).reverse();}this.opaquePassCutoff=1/0;for(let t=0;t<a.length;t++)if(this.style._layers[a[t]].is3D()){this.opaquePassCutoff=t;break}this.maybeDrawDepthAndCoords(!1),this.renderToTexture&&(this.renderToTexture.prepareForRender(this.style,this.transform.zoom),this.opaquePassCutoff=0),this.renderPass="offscreen";for(const t of a){const e=this.style._layers[t];if(!e.hasOffscreenPass()||e.isHidden(this.transform.zoom))continue;const i=n[e.source];("custom"===e.type||i.length)&&this.renderLayer(this,s[e.source],e,i);}if(this.context.bindFramebuffer.set(null),this.context.clear({color:i.showOverdrawInspector?e.aM.black:e.aM.transparent,depth:1}),this.clearStencil(),this.style.sky&&function(t,i){const a=t.context,s=a.gl,o=((t,e,i)=>({u_sky_color:t.properties.get("sky-color"),u_horizon_color:t.properties.get("horizon-color"),u_horizon:(e.height/2+e.getHorizon())*i,u_sky_horizon_blend:t.properties.get("sky-horizon-blend")*e.height/2*i}))(i,t.style.map.transform,t.pixelRatio),r=new Fi(s.LEQUAL,Fi.ReadWrite,[0,1]),n=Oi.disabled,l=t.colorModeForRenderPass(),h=t.useProgram("sky");if(!i.mesh){const t=new e.aW;t.emplaceBack(-1,-1),t.emplaceBack(1,-1),t.emplaceBack(1,1),t.emplaceBack(-1,1);const s=new e.aX;s.emplaceBack(0,1,2),s.emplaceBack(0,2,3),i.mesh=new ua(a.createVertexBuffer(t,de.members),a.createIndexBuffer(s),e.a0.simpleSegment(0,0,t.length,s.length));}h.draw(a,s.TRIANGLES,r,n,l,Ni.disabled,o,void 0,"sky",i.mesh.vertexBuffer,i.mesh.indexBuffer,i.mesh.segments);}(this,this.style.sky),this._showOverdrawInspector=i.showOverdrawInspector,this.depthRangeFor3D=[0,1-(t._order.length+2)*this.numSublayers*this.depthEpsilon],!this.renderToTexture)for(this.renderPass="opaque",this.currentLayer=a.length-1;this.currentLayer>=0;this.currentLayer--){const t=this.style._layers[a[this.currentLayer]],e=s[t.source],i=r[t.source];this._renderTileClippingMasks(t,i),this.renderLayer(this,e,t,i);}for(this.renderPass="translucent",this.currentLayer=0;this.currentLayer<a.length;this.currentLayer++){const t=this.style._layers[a[this.currentLayer]],e=s[t.source];if(this.renderToTexture&&this.renderToTexture.renderLayer(t))continue;const i=("symbol"===t.type?l:n)[t.source];this._renderTileClippingMasks(t,r[t.source]),this.renderLayer(this,e,t,i);}if(this.options.showTileBoundaries){const t=function(t,e){let i=null;const a=Object.values(t._layers).flatMap((i=>i.source&&!i.isHidden(e)?[t.sourceCaches[i.source]]:[])),s=a.filter((t=>"vector"===t.getSource().type)),o=a.filter((t=>"vector"!==t.getSource().type)),r=t=>{(!i||i.getSource().maxzoom<t.getSource().maxzoom)&&(i=t);};return s.forEach((t=>r(t))),i||o.forEach((t=>r(t))),i}(this.style,this.transform.zoom);t&&function(t,e,i){for(let a=0;a<i.length;a++)ha(t,e,i[a]);}(this,t,t.getVisibleCoordinates());}this.options.showPadding&&function(t){const e=t.transform.padding;ra(t,t.transform.height-(e.top||0),3,ea),ra(t,e.bottom||0,3,ia),na(t,e.left||0,3,aa),na(t,t.transform.width-(e.right||0),3,sa);const i=t.transform.centerPoint;!function(t,e,i,a){la(t,e-1,i-10,2,20,a),la(t,e-10,i-1,20,2,a);}(t,i.x,t.transform.height-i.y,oa);}(this),this.context.setDefault();}maybeDrawDepthAndCoords(t){if(!this.style||!this.style.map||!this.style.map.terrain)return;const i=this.terrainFacilitator.matrix,a=this.transform.modelViewProjectionMatrix;let s=this.terrainFacilitator.dirty;s||(s=t?!e.aZ(i,a):!e.a_(i,a)),s||(s=this.style.map.terrain.sourceCache.tilesAfterTime(this.terrainFacilitator.renderTime).length>0),s&&(e.a$(i,a),this.terrainFacilitator.renderTime=Date.now(),this.terrainFacilitator.dirty=!1,function(t,i){const a=t.context,s=a.gl,o=ki.unblended,r=new Fi(s.LEQUAL,Fi.ReadWrite,[0,1]),n=i.getTerrainMesh(),l=i.sourceCache.getRenderableTiles(),h=t.useProgram("terrainDepth");a.bindFramebuffer.set(i.getFramebuffer("depth").framebuffer),a.viewport.set([0,0,t.width/devicePixelRatio,t.height/devicePixelRatio]),a.clear({color:e.aM.transparent,depth:1});for(const e of l){const l=i.getTerrainData(e.tileID),c={u_matrix:t.transform.calculatePosMatrix(e.tileID.toUnwrapped()),u_ele_delta:i.getMeshFrameDelta(t.transform.zoom)};h.draw(a,s.TRIANGLES,r,Oi.disabled,o,Ni.backCCW,c,l,"terrain",n.vertexBuffer,n.indexBuffer,n.segments);}a.bindFramebuffer.set(null),a.viewport.set([0,0,t.width,t.height]);}(this,this.style.map.terrain),function(t,i){const a=t.context,s=a.gl,o=ki.unblended,r=new Fi(s.LEQUAL,Fi.ReadWrite,[0,1]),n=i.getTerrainMesh(),l=i.getCoordsTexture(),h=i.sourceCache.getRenderableTiles(),c=t.useProgram("terrainCoords");a.bindFramebuffer.set(i.getFramebuffer("coords").framebuffer),a.viewport.set([0,0,t.width/devicePixelRatio,t.height/devicePixelRatio]),a.clear({color:e.aM.transparent,depth:1}),i.coordsIndex=[];for(const e of h){const h=i.getTerrainData(e.tileID);a.activeTexture.set(s.TEXTURE0),s.bindTexture(s.TEXTURE_2D,l.texture);const u={u_matrix:t.transform.calculatePosMatrix(e.tileID.toUnwrapped()),u_terrain_coords_id:(255-i.coordsIndex.length)/255,u_texture:0,u_ele_delta:i.getMeshFrameDelta(t.transform.zoom)};c.draw(a,s.TRIANGLES,r,Oi.disabled,o,Ni.backCCW,u,h,"terrain",n.vertexBuffer,n.indexBuffer,n.segments),i.coordsIndex.push(e.tileID.key);}a.bindFramebuffer.set(null),a.viewport.set([0,0,t.width,t.height]);}(this,this.style.map.terrain));}renderLayer(t,i,a,s){if(!a.isHidden(this.transform.zoom)&&("background"===a.type||"custom"===a.type||(s||[]).length))switch(this.id=a.id,a.type){case"symbol":!function(t,i,a,s,o){if("translucent"!==t.renderPass)return;const r=Oi.disabled,n=t.colorModeForRenderPass();(a._unevaluatedLayout.hasValue("text-variable-anchor")||a._unevaluatedLayout.hasValue("text-variable-anchor-offset"))&&function(t,i,a,s,o,r,n,l,h){const c=i.transform,u=ee(),d="map"===o,_="map"===r;for(const o of t){const t=s.getTile(o),r=t.getBucket(a);if(!r||!r.text||!r.text.segments.get().length)continue;const p=e.ag(r.textSizeData,c.zoom),m=Ft(t,1,i.transform.zoom),f=gt(o.posMatrix,_,d,i.transform,m),g="none"!==a.layout.get("icon-text-fit")&&r.hasIconData();if(p){const e=Math.pow(2,c.zoom-t.tileID.overscaledZ),a=i.style.map.terrain?(t,e)=>i.style.map.terrain.getElevation(o,t,e):null,s=u.translatePosition(c,t,n,l);Gi(r,d,_,h,c,f,o.posMatrix,e,p,g,u,s,o.toUnwrapped(),a);}}}(s,t,a,i,a.layout.get("text-rotation-alignment"),a.layout.get("text-pitch-alignment"),a.paint.get("text-translate"),a.paint.get("text-translate-anchor"),o),0!==a.paint.get("icon-opacity").constantOr(1)&&Wi(t,i,a,s,!1,a.paint.get("icon-translate"),a.paint.get("icon-translate-anchor"),a.layout.get("icon-rotation-alignment"),a.layout.get("icon-pitch-alignment"),a.layout.get("icon-keep-upright"),r,n),0!==a.paint.get("text-opacity").constantOr(1)&&Wi(t,i,a,s,!0,a.paint.get("text-translate"),a.paint.get("text-translate-anchor"),a.layout.get("text-rotation-alignment"),a.layout.get("text-pitch-alignment"),a.layout.get("text-keep-upright"),r,n),i.map.showCollisionBoxes&&(Ui(t,i,a,s,!0),Ui(t,i,a,s,!1));}(t,i,a,s,this.style.placement.variableOffsets);break;case"circle":!function(t,i,a,s){if("translucent"!==t.renderPass)return;const o=a.paint.get("circle-opacity"),r=a.paint.get("circle-stroke-width"),n=a.paint.get("circle-stroke-opacity"),l=!a.layout.get("circle-sort-key").isConstant();if(0===o.constantOr(1)&&(0===r.constantOr(1)||0===n.constantOr(1)))return;const h=t.context,c=h.gl,u=t.depthModeForSublayer(0,Fi.ReadOnly),d=Oi.disabled,_=t.colorModeForRenderPass(),p=[];for(let o=0;o<s.length;o++){const r=s[o],n=i.getTile(r),h=n.getBucket(a);if(!h)continue;const c=h.programConfigurations.get(a.id),u=t.useProgram("circle",c),d=h.layoutVertexBuffer,_=h.indexBuffer,m=t.style.map.terrain&&t.style.map.terrain.getTerrainData(r),f={programConfiguration:c,program:u,layoutVertexBuffer:d,indexBuffer:_,uniformValues:Pe(t,r,n,a),terrainData:m};if(l){const t=h.segments.get();for(const i of t)p.push({segments:new e.a0([i]),sortKey:i.sortKey,state:f});}else p.push({segments:h.segments,sortKey:0,state:f});}l&&p.sort(((t,e)=>t.sortKey-e.sortKey));for(const e of p){const{programConfiguration:i,program:s,layoutVertexBuffer:o,indexBuffer:r,uniformValues:n,terrainData:l}=e.state;s.draw(h,c.TRIANGLES,u,d,_,Ni.disabled,n,l,a.id,o,r,e.segments,a.paint,t.transform.zoom,i);}}(t,i,a,s);break;case"heatmap":!function(t,i,a,s){if(0!==a.paint.get("heatmap-opacity"))if("offscreen"===t.renderPass){const o=t.context,r=o.gl,n=Oi.disabled,l=new ki([r.ONE,r.ONE],e.aM.transparent,[!0,!0,!0,!0]);!function(t,e,i){const a=t.gl;t.activeTexture.set(a.TEXTURE1),t.viewport.set([0,0,e.width/4,e.height/4]);let s=i.heatmapFbo;if(s)a.bindTexture(a.TEXTURE_2D,s.colorAttachment.get()),t.bindFramebuffer.set(s.framebuffer);else {const o=a.createTexture();a.bindTexture(a.TEXTURE_2D,o),a.texParameteri(a.TEXTURE_2D,a.TEXTURE_WRAP_S,a.CLAMP_TO_EDGE),a.texParameteri(a.TEXTURE_2D,a.TEXTURE_WRAP_T,a.CLAMP_TO_EDGE),a.texParameteri(a.TEXTURE_2D,a.TEXTURE_MIN_FILTER,a.LINEAR),a.texParameteri(a.TEXTURE_2D,a.TEXTURE_MAG_FILTER,a.LINEAR),s=i.heatmapFbo=t.createFramebuffer(e.width/4,e.height/4,!1,!1),function(t,e,i,a){var s,o;const r=t.gl,n=null!==(s=t.HALF_FLOAT)&&void 0!==s?s:r.UNSIGNED_BYTE,l=null!==(o=t.RGBA16F)&&void 0!==o?o:r.RGBA;r.texImage2D(r.TEXTURE_2D,0,l,e.width/4,e.height/4,0,r.RGBA,n,null),a.colorAttachment.set(i);}(t,e,o,s);}}(o,t,a),o.clear({color:e.aM.transparent});for(let e=0;e<s.length;e++){const h=s[e];if(i.hasRenderableParent(h))continue;const c=i.getTile(h),u=c.getBucket(a);if(!u)continue;const d=u.programConfigurations.get(a.id),_=t.useProgram("heatmap",d),{zoom:p}=t.transform;_.draw(o,r.TRIANGLES,Fi.disabled,n,l,Ni.disabled,De(h.posMatrix,c,p,a.paint.get("heatmap-intensity")),null,a.id,u.layoutVertexBuffer,u.indexBuffer,u.segments,a.paint,t.transform.zoom,d);}o.viewport.set([0,0,t.width,t.height]);}else "translucent"===t.renderPass&&(t.context.setColorMode(t.colorModeForRenderPass()),function(t,i){const a=t.context,s=a.gl,o=i.heatmapFbo;if(!o)return;a.activeTexture.set(s.TEXTURE0),s.bindTexture(s.TEXTURE_2D,o.colorAttachment.get()),a.activeTexture.set(s.TEXTURE1);let r=i.colorRampTexture;r||(r=i.colorRampTexture=new b(a,i.colorRamp,s.RGBA)),r.bind(s.LINEAR,s.CLAMP_TO_EDGE),t.useProgram("heatmapTexture").draw(a,s.TRIANGLES,Fi.disabled,Oi.disabled,t.colorModeForRenderPass(),Ni.disabled,((t,i,a,s)=>{const o=e.H();e.aP(o,0,t.width,t.height,0,0,1);const r=t.context.gl;return {u_matrix:o,u_world:[r.drawingBufferWidth,r.drawingBufferHeight],u_image:0,u_color_ramp:1,u_opacity:i.paint.get("heatmap-opacity")}})(t,i),null,i.id,t.viewportBuffer,t.quadTriangleIndexBuffer,t.viewportSegments,i.paint,t.transform.zoom);}(t,a));}(t,i,a,s);break;case"line":!function(t,i,a,s){if("translucent"!==t.renderPass)return;const o=a.paint.get("line-opacity"),r=a.paint.get("line-width");if(0===o.constantOr(1)||0===r.constantOr(1))return;const n=t.depthModeForSublayer(0,Fi.ReadOnly),l=t.colorModeForRenderPass(),h=a.paint.get("line-dasharray"),c=a.paint.get("line-pattern"),u=c.constantOr(1),d=a.paint.get("line-gradient"),_=a.getCrossfadeParameters(),p=u?"linePattern":h?"lineSDF":d?"lineGradient":"line",m=t.context,f=m.gl;let g=!0;for(const o of s){const s=i.getTile(o);if(u&&!s.patternsLoaded())continue;const r=s.getBucket(a);if(!r)continue;const v=r.programConfigurations.get(a.id),x=t.context.program.get(),y=t.useProgram(p,v),w=g||y.program!==x,T=t.style.map.terrain&&t.style.map.terrain.getTerrainData(o),I=c.constantOr(null);if(I&&s.imageAtlas){const t=s.imageAtlas,e=t.patternPositions[I.to.toString()],i=t.patternPositions[I.from.toString()];e&&i&&v.setConstantPatternPositions(e,i);}const E=T?o:null,P=u?ke(t,s,a,_,E):h?Le(t,s,a,h,_,E):d?Re(t,s,a,r.lineClipsArray.length,E):Ae(t,s,a,E);if(u)m.activeTexture.set(f.TEXTURE0),s.imageAtlasTexture.bind(f.LINEAR,f.CLAMP_TO_EDGE),v.updatePaintBuffers(_);else if(h&&(w||t.lineAtlas.dirty))m.activeTexture.set(f.TEXTURE0),t.lineAtlas.bind(m);else if(d){const s=r.gradients[a.id];let n=s.texture;if(a.gradientVersion!==s.version){let l=256;if(a.stepInterpolant){const a=i.getSource().maxzoom,s=o.canonical.z===a?Math.ceil(1<<t.transform.maxZoom-o.canonical.z):1;l=e.ac(e.aU(r.maxLineLength/e.X*1024*s),256,m.maxTextureSize);}s.gradient=e.aV({expression:a.gradientExpression(),evaluationKey:"lineProgress",resolution:l,image:s.gradient||void 0,clips:r.lineClipsArray}),s.texture?s.texture.update(s.gradient):s.texture=new b(m,s.gradient,f.RGBA),s.version=a.gradientVersion,n=s.texture;}m.activeTexture.set(f.TEXTURE0),n.bind(a.stepInterpolant?f.NEAREST:f.LINEAR,f.CLAMP_TO_EDGE);}y.draw(m,f.TRIANGLES,n,t.stencilModeForClipping(o),l,Ni.disabled,P,T,a.id,r.layoutVertexBuffer,r.indexBuffer,r.segments,a.paint,t.transform.zoom,v,r.layoutVertexBuffer2),g=!1;}}(t,i,a,s);break;case"fill":!function(t,i,a,s){const o=a.paint.get("fill-color"),r=a.paint.get("fill-opacity");if(0===r.constantOr(1))return;const n=t.colorModeForRenderPass(),l=a.paint.get("fill-pattern"),h=t.opaquePassEnabledForLayer()&&!l.constantOr(1)&&1===o.constantOr(e.aM.transparent).a&&1===r.constantOr(0)?"opaque":"translucent";if(t.renderPass===h){const e=t.depthModeForSublayer(1,"opaque"===t.renderPass?Fi.ReadWrite:Fi.ReadOnly);Ki(t,i,a,s,e,n,!1);}if("translucent"===t.renderPass&&a.paint.get("fill-antialias")){const e=t.depthModeForSublayer(a.getPaintProperty("fill-outline-color")?2:0,Fi.ReadOnly);Ki(t,i,a,s,e,n,!0);}}(t,i,a,s);break;case"fill-extrusion":!function(t,e,i,a){const s=i.paint.get("fill-extrusion-opacity");if(0!==s&&"translucent"===t.renderPass){const o=new Fi(t.context.gl.LEQUAL,Fi.ReadWrite,t.depthRangeFor3D);if(1!==s||i.paint.get("fill-extrusion-pattern").constantOr(1))Ji(t,e,i,a,o,Oi.disabled,ki.disabled),Ji(t,e,i,a,o,t.stencilModeFor3D(),t.colorModeForRenderPass());else {const s=t.colorModeForRenderPass();Ji(t,e,i,a,o,Oi.disabled,s);}}}(t,i,a,s);break;case"hillshade":!function(t,e,i,a){if("offscreen"!==t.renderPass&&"translucent"!==t.renderPass)return;const s=t.context,o=t.depthModeForSublayer(0,Fi.ReadOnly),r=t.colorModeForRenderPass(),[n,l]="translucent"===t.renderPass?t.stencilConfigForOverlap(a):[{},a];for(const a of l){const s=e.getTile(a);void 0!==s.needsHillshadePrepare&&s.needsHillshadePrepare&&"offscreen"===t.renderPass?Qi(t,s,i,o,Oi.disabled,r):"translucent"===t.renderPass&&Yi(t,a,s,i,o,n[a.overscaledZ],r);}s.viewport.set([0,0,t.width,t.height]);}(t,i,a,s);break;case"raster":!function(t,e,i,a){if("translucent"!==t.renderPass)return;if(0===i.paint.get("raster-opacity"))return;if(!a.length)return;const s=t.context,o=s.gl,r=e.getSource(),n=t.useProgram("raster"),l=t.colorModeForRenderPass(),[h,c]=r instanceof Q?[{},a]:t.stencilConfigForOverlap(a),u=c[c.length-1].overscaledZ,d=!t.options.moving;for(const a of c){const c=t.depthModeForSublayer(a.overscaledZ-u,1===i.paint.get("raster-opacity")?Fi.ReadWrite:Fi.ReadOnly,o.LESS),_=e.getTile(a);_.registerFadeDuration(i.paint.get("raster-fade-duration"));const p=e.findLoadedParent(a,0),m=e.findLoadedSibling(a),f=ta(_,p||m||null,e,i,t.transform,t.style.map.terrain);let g,v;const x="nearest"===i.paint.get("raster-resampling")?o.NEAREST:o.LINEAR;s.activeTexture.set(o.TEXTURE0),_.texture.bind(x,o.CLAMP_TO_EDGE,o.LINEAR_MIPMAP_NEAREST),s.activeTexture.set(o.TEXTURE1),p?(p.texture.bind(x,o.CLAMP_TO_EDGE,o.LINEAR_MIPMAP_NEAREST),g=Math.pow(2,p.tileID.overscaledZ-_.tileID.overscaledZ),v=[_.tileID.canonical.x*g%1,_.tileID.canonical.y*g%1]):_.texture.bind(x,o.CLAMP_TO_EDGE,o.LINEAR_MIPMAP_NEAREST),_.texture.useMipmap&&s.extTextureFilterAnisotropic&&t.transform.pitch>20&&o.texParameterf(o.TEXTURE_2D,s.extTextureFilterAnisotropic.TEXTURE_MAX_ANISOTROPY_EXT,s.extTextureFilterAnisotropicMax);const y=t.style.map.terrain&&t.style.map.terrain.getTerrainData(a),b=y?a:null,w=b?b.posMatrix:t.transform.calculatePosMatrix(a.toUnwrapped(),d),T=Oe(w,v||[0,0],g||1,f,i);r instanceof Q?n.draw(s,o.TRIANGLES,c,Oi.disabled,l,Ni.disabled,T,y,i.id,r.boundsBuffer,t.quadTriangleIndexBuffer,r.boundsSegments):n.draw(s,o.TRIANGLES,c,h[a.overscaledZ],l,Ni.disabled,T,y,i.id,t.rasterBoundsBuffer,t.quadTriangleIndexBuffer,t.rasterBoundsSegments);}}(t,i,a,s);break;case"background":!function(t,e,i,a){const s=i.paint.get("background-color"),o=i.paint.get("background-opacity");if(0===o)return;const r=t.context,n=r.gl,l=t.transform,h=l.tileSize,c=i.paint.get("background-pattern");if(t.isPatternMissing(c))return;const u=!c&&1===s.a&&1===o&&t.opaquePassEnabledForLayer()?"opaque":"translucent";if(t.renderPass!==u)return;const d=Oi.disabled,_=t.depthModeForSublayer(0,"opaque"===u?Fi.ReadWrite:Fi.ReadOnly),p=t.colorModeForRenderPass(),m=t.useProgram(c?"backgroundPattern":"background"),f=a||l.coveringTiles({tileSize:h,terrain:t.style.map.terrain});c&&(r.activeTexture.set(n.TEXTURE0),t.imageManager.bind(t.context));const g=i.getCrossfadeParameters();for(const e of f){const l=a?e.posMatrix:t.transform.calculatePosMatrix(e.toUnwrapped()),u=c?Ve(l,o,t,c,{tileID:e,tileSize:h},g):qe(l,o,s),f=t.style.map.terrain&&t.style.map.terrain.getTerrainData(e);m.draw(r,n.TRIANGLES,_,d,p,Ni.disabled,u,f,i.id,t.tileExtentBuffer,t.quadTriangleIndexBuffer,t.tileExtentSegments);}}(t,0,a,s);break;case"custom":!function(t,e,i){const a=t.context,s=i.implementation;if("offscreen"===t.renderPass){const e=s.prerender;e&&(t.setCustomLayerDefaults(),a.setColorMode(t.colorModeForRenderPass()),e.call(s,a.gl,t.transform.customLayerMatrix()),a.setDirty(),t.setBaseState());}else if("translucent"===t.renderPass){t.setCustomLayerDefaults(),a.setColorMode(t.colorModeForRenderPass()),a.setStencilMode(Oi.disabled);const e="3d"===s.renderingMode?new Fi(t.context.gl.LEQUAL,Fi.ReadWrite,t.depthRangeFor3D):t.depthModeForSublayer(0,Fi.ReadOnly);a.setDepthMode(e),s.render(a.gl,t.transform.customLayerMatrix(),{farZ:t.transform.farZ,nearZ:t.transform.nearZ,fov:t.transform._fov,modelViewProjectionMatrix:t.transform.modelViewProjectionMatrix,projectionMatrix:t.transform.projectionMatrix}),a.setDirty(),t.setBaseState(),a.bindFramebuffer.set(null);}}(t,0,a);}}translatePosMatrix(t,i,a,s,o){if(!a[0]&&!a[1])return t;const r=o?"map"===s?this.transform.angle:0:"viewport"===s?-this.transform.angle:0;if(r){const t=Math.sin(r),e=Math.cos(r);a=[a[0]*e-a[1]*t,a[0]*t+a[1]*e];}const n=[o?a[0]:Ft(i,a[0],this.transform.zoom),o?a[1]:Ft(i,a[1],this.transform.zoom),0],l=new Float32Array(16);return e.J(l,t,n),l}saveTileTexture(t){const e=this._tileTextures[t.size[0]];e?e.push(t):this._tileTextures[t.size[0]]=[t];}getTileTexture(t){const e=this._tileTextures[t];return e&&e.length>0?e.pop():null}isPatternMissing(t){if(!t)return !1;if(!t.from||!t.to)return !0;const e=this.imageManager.getPattern(t.from.toString()),i=this.imageManager.getPattern(t.to.toString());return !e||!i}useProgram(t,e){this.cache=this.cache||{};const i=t+(e?e.cacheKey:"")+(this._showOverdrawInspector?"/overdraw":"")+(this.style.map.terrain?"/terrain":"");return this.cache[i]||(this.cache[i]=new ve(this.context,_e[t],e,Ge[t],this._showOverdrawInspector,this.style.map.terrain)),this.cache[i]}setCustomLayerDefaults(){this.context.unbindVAO(),this.context.cullFace.setDefault(),this.context.activeTexture.setDefault(),this.context.pixelStoreUnpack.setDefault(),this.context.pixelStoreUnpackPremultiplyAlpha.setDefault(),this.context.pixelStoreUnpackFlipY.setDefault();}setBaseState(){const t=this.context.gl;this.context.cullFace.set(!1),this.context.viewport.set([0,0,this.width,this.height]),this.context.blendEquation.set(t.FUNC_ADD);}initDebugOverlayCanvas(){null==this.debugOverlayCanvas&&(this.debugOverlayCanvas=document.createElement("canvas"),this.debugOverlayCanvas.width=512,this.debugOverlayCanvas.height=512,this.debugOverlayTexture=new b(this.context,this.debugOverlayCanvas,this.context.gl.RGBA));}destroy(){this.debugOverlayTexture&&this.debugOverlayTexture.destroy();}overLimit(){const{drawingBufferWidth:t,drawingBufferHeight:e}=this.context.gl;return this.width!==t||this.height!==e}}class _a{constructor(t,e){this.points=t,this.planes=e;}static fromInvProjectionMatrix(t,i,a){const s=Math.pow(2,a),o=[[-1,1,-1,1],[1,1,-1,1],[1,-1,-1,1],[-1,-1,-1,1],[-1,1,1,1],[1,1,1,1],[1,-1,1,1],[-1,-1,1,1]].map((a=>{const o=1/(a=e.af([],a,t))[3]/i*s;return e.b0(a,a,[o,o,1/a[3],o])})),r=[[0,1,2],[6,5,4],[0,3,7],[2,1,5],[3,2,6],[0,4,5]].map((t=>{const e=function(t,e){var i=e[0],a=e[1],s=e[2],o=i*i+a*a+s*s;return o>0&&(o=1/Math.sqrt(o)),t[0]=e[0]*o,t[1]=e[1]*o,t[2]=e[2]*o,t}([],function(t,e,i){var a=e[0],s=e[1],o=e[2],r=i[0],n=i[1],l=i[2];return t[0]=s*l-o*n,t[1]=o*r-a*l,t[2]=a*n-s*r,t}([],g([],o[t[0]],o[t[1]]),g([],o[t[2]],o[t[1]]))),i=-((a=e)[0]*(s=o[t[1]])[0]+a[1]*s[1]+a[2]*s[2]);var a,s;return e.concat(i)}));return new _a(o,r)}}class pa{constructor(t,e){this.min=t,this.max=e,this.center=function(t,e,i){return t[0]=.5*e[0],t[1]=.5*e[1],t[2]=.5*e[2],t}([],function(t,e,i){return t[0]=e[0]+i[0],t[1]=e[1]+i[1],t[2]=e[2]+i[2],t}([],this.min,this.max));}quadrant(t){const e=[t%2==0,t<2],i=m(this.min),a=m(this.max);for(let t=0;t<e.length;t++)i[t]=e[t]?this.min[t]:this.center[t],a[t]=e[t]?this.center[t]:this.max[t];return a[2]=this.max[2],new pa(i,a)}distanceX(t){return Math.max(Math.min(this.max[0],t[0]),this.min[0])-t[0]}distanceY(t){return Math.max(Math.min(this.max[1],t[1]),this.min[1])-t[1]}intersects(t){const i=[[this.min[0],this.min[1],this.min[2],1],[this.max[0],this.min[1],this.min[2],1],[this.max[0],this.max[1],this.min[2],1],[this.min[0],this.max[1],this.min[2],1],[this.min[0],this.min[1],this.max[2],1],[this.max[0],this.min[1],this.max[2],1],[this.max[0],this.max[1],this.max[2],1],[this.min[0],this.max[1],this.max[2],1]];let a=!0;for(let s=0;s<t.planes.length;s++){const o=t.planes[s];let r=0;for(let t=0;t<i.length;t++)e.b1(o,i[t])>=0&&r++;if(0===r)return 0;r!==i.length&&(a=!1);}if(a)return 2;for(let e=0;e<3;e++){let i=Number.MAX_VALUE,a=-Number.MAX_VALUE;for(let s=0;s<t.points.length;s++){const o=t.points[s][e]-this.min[e];i=Math.min(i,o),a=Math.max(a,o);}if(a<0||i>this.max[e]-this.min[e])return 0}return 1}}class ma{constructor(t=0,e=0,i=0,a=0){if(isNaN(t)||t<0||isNaN(e)||e<0||isNaN(i)||i<0||isNaN(a)||a<0)throw new Error("Invalid value for edge-insets, top, bottom, left and right must all be numbers");this.top=t,this.bottom=e,this.left=i,this.right=a;}interpolate(t,i,a){return null!=i.top&&null!=t.top&&(this.top=e.y.number(t.top,i.top,a)),null!=i.bottom&&null!=t.bottom&&(this.bottom=e.y.number(t.bottom,i.bottom,a)),null!=i.left&&null!=t.left&&(this.left=e.y.number(t.left,i.left,a)),null!=i.right&&null!=t.right&&(this.right=e.y.number(t.right,i.right,a)),this}getCenter(t,i){const a=e.ac((this.left+t-this.right)/2,0,t),s=e.ac((this.top+i-this.bottom)/2,0,i);return new e.P(a,s)}equals(t){return this.top===t.top&&this.bottom===t.bottom&&this.left===t.left&&this.right===t.right}clone(){return new ma(this.top,this.bottom,this.left,this.right)}toJSON(){return {top:this.top,bottom:this.bottom,left:this.left,right:this.right}}}const fa=85.051129;class ga{constructor(t,i,a,s,o){this.tileSize=512,this._renderWorldCopies=void 0===o||!!o,this._minZoom=t||0,this._maxZoom=i||22,this._minPitch=null==a?0:a,this._maxPitch=null==s?60:s,this.setMaxBounds(),this.width=0,this.height=0,this._center=new e.N(0,0),this._elevation=0,this.zoom=0,this.angle=0,this._fov=.6435011087932844,this._pitch=0,this._unmodified=!0,this._edgeInsets=new ma,this._posMatrixCache={},this._alignedPosMatrixCache={},this._fogMatrixCache={},this.minElevationForCurrentTile=0;}clone(){const t=new ga(this._minZoom,this._maxZoom,this._minPitch,this.maxPitch,this._renderWorldCopies);return t.apply(this),t}apply(t){this.tileSize=t.tileSize,this.latRange=t.latRange,this.width=t.width,this.height=t.height,this._center=t._center,this._elevation=t._elevation,this.minElevationForCurrentTile=t.minElevationForCurrentTile,this.zoom=t.zoom,this.angle=t.angle,this._fov=t._fov,this._pitch=t._pitch,this._unmodified=t._unmodified,this._edgeInsets=t._edgeInsets.clone(),this._calcMatrices();}get minZoom(){return this._minZoom}set minZoom(t){this._minZoom!==t&&(this._minZoom=t,this.zoom=Math.max(this.zoom,t));}get maxZoom(){return this._maxZoom}set maxZoom(t){this._maxZoom!==t&&(this._maxZoom=t,this.zoom=Math.min(this.zoom,t));}get minPitch(){return this._minPitch}set minPitch(t){this._minPitch!==t&&(this._minPitch=t,this.pitch=Math.max(this.pitch,t));}get maxPitch(){return this._maxPitch}set maxPitch(t){this._maxPitch!==t&&(this._maxPitch=t,this.pitch=Math.min(this.pitch,t));}get renderWorldCopies(){return this._renderWorldCopies}set renderWorldCopies(t){void 0===t?t=!0:null===t&&(t=!1),this._renderWorldCopies=t;}get worldSize(){return this.tileSize*this.scale}get centerOffset(){return this.centerPoint._sub(this.size._div(2))}get size(){return new e.P(this.width,this.height)}get bearing(){return -this.angle/Math.PI*180}set bearing(t){const i=-e.b2(t,-180,180)*Math.PI/180;this.angle!==i&&(this._unmodified=!1,this.angle=i,this._calcMatrices(),this.rotationMatrix=function(){var t=new e.A(4);return e.A!=Float32Array&&(t[1]=0,t[2]=0),t[0]=1,t[3]=1,t}(),function(t,e,i){var a=e[0],s=e[1],o=e[2],r=e[3],n=Math.sin(i),l=Math.cos(i);t[0]=a*l+o*n,t[1]=s*l+r*n,t[2]=a*-n+o*l,t[3]=s*-n+r*l;}(this.rotationMatrix,this.rotationMatrix,this.angle));}get pitch(){return this._pitch/Math.PI*180}set pitch(t){const i=e.ac(t,this.minPitch,this.maxPitch)/180*Math.PI;this._pitch!==i&&(this._unmodified=!1,this._pitch=i,this._calcMatrices());}get fov(){return this._fov/Math.PI*180}set fov(t){t=Math.max(.01,Math.min(60,t)),this._fov!==t&&(this._unmodified=!1,this._fov=t/180*Math.PI,this._calcMatrices());}get zoom(){return this._zoom}set zoom(t){const e=Math.min(Math.max(t,this.minZoom),this.maxZoom);this._zoom!==e&&(this._unmodified=!1,this._zoom=e,this.tileZoom=Math.max(0,Math.floor(e)),this.scale=this.zoomScale(e),this._constrain(),this._calcMatrices());}get center(){return this._center}set center(t){t.lat===this._center.lat&&t.lng===this._center.lng||(this._unmodified=!1,this._center=t,this._constrain(),this._calcMatrices());}get elevation(){return this._elevation}set elevation(t){t!==this._elevation&&(this._elevation=t,this._constrain(),this._calcMatrices());}get padding(){return this._edgeInsets.toJSON()}set padding(t){this._edgeInsets.equals(t)||(this._unmodified=!1,this._edgeInsets.interpolate(this._edgeInsets,t,1),this._calcMatrices());}get centerPoint(){return this._edgeInsets.getCenter(this.width,this.height)}isPaddingEqual(t){return this._edgeInsets.equals(t)}interpolatePadding(t,e,i){this._unmodified=!1,this._edgeInsets.interpolate(t,e,i),this._constrain(),this._calcMatrices();}coveringZoomLevel(t){const e=(t.roundZoom?Math.round:Math.floor)(this.zoom+this.scaleZoom(this.tileSize/t.tileSize));return Math.max(0,e)}getVisibleUnwrappedCoordinates(t){const i=[new e.b3(0,t)];if(this._renderWorldCopies){const a=this.pointCoordinate(new e.P(0,0)),s=this.pointCoordinate(new e.P(this.width,0)),o=this.pointCoordinate(new e.P(this.width,this.height)),r=this.pointCoordinate(new e.P(0,this.height)),n=Math.floor(Math.min(a.x,s.x,o.x,r.x)),l=Math.floor(Math.max(a.x,s.x,o.x,r.x)),h=1;for(let a=n-h;a<=l+h;a++)0!==a&&i.push(new e.b3(a,t));}return i}coveringTiles(t){var i,a;let s=this.coveringZoomLevel(t);const o=s;if(void 0!==t.minzoom&&s<t.minzoom)return [];void 0!==t.maxzoom&&s>t.maxzoom&&(s=t.maxzoom);const r=this.pointCoordinate(this.getCameraPoint()),n=e.Z.fromLngLat(this.center),l=Math.pow(2,s),h=[l*r.x,l*r.y,0],c=[l*n.x,l*n.y,0],u=_a.fromInvProjectionMatrix(this.invModelViewProjectionMatrix,this.worldSize,s);let d=t.minzoom||0;!t.terrain&&this.pitch<=60&&this._edgeInsets.top<.1&&(d=s);const _=t.terrain?2/Math.min(this.tileSize,t.tileSize)*this.tileSize:3,p=t=>({aabb:new pa([t*l,0,0],[(t+1)*l,l,0]),zoom:0,x:0,y:0,wrap:t,fullyVisible:!1}),m=[],f=[],g=s,x=t.reparseOverscaled?o:s;if(this._renderWorldCopies)for(let t=1;t<=3;t++)m.push(p(-t)),m.push(p(t));for(m.push(p(0));m.length>0;){const s=m.pop(),o=s.x,r=s.y;let n=s.fullyVisible;if(!n){const t=s.aabb.intersects(u);if(0===t)continue;n=2===t;}const l=t.terrain?h:c,p=s.aabb.distanceX(l),y=s.aabb.distanceY(l),b=Math.max(Math.abs(p),Math.abs(y));if(s.zoom===g||b>_+(1<<g-s.zoom)-2&&s.zoom>=d){const t=g-s.zoom,i=h[0]-.5-(o<<t),a=h[1]-.5-(r<<t);f.push({tileID:new e.S(s.zoom===g?x:s.zoom,s.wrap,s.zoom,o,r),distanceSq:v([c[0]-.5-o,c[1]-.5-r]),tileDistanceToCamera:Math.sqrt(i*i+a*a)});}else for(let l=0;l<4;l++){const h=(o<<1)+l%2,c=(r<<1)+(l>>1),u=s.zoom+1;let d=s.aabb.quadrant(l);if(t.terrain){const o=new e.S(u,s.wrap,u,h,c),r=t.terrain.getMinMaxElevation(o),n=null!==(i=r.minElevation)&&void 0!==i?i:this.elevation,l=null!==(a=r.maxElevation)&&void 0!==a?a:this.elevation;d=new pa([d.min[0],d.min[1],n],[d.max[0],d.max[1],l]);}m.push({aabb:d,zoom:u,x:h,y:c,wrap:s.wrap,fullyVisible:n});}}return f.sort(((t,e)=>t.distanceSq-e.distanceSq)).map((t=>t.tileID))}resize(t,e){this.width=t,this.height=e,this.pixelsToGLUnits=[2/t,-2/e],this._constrain(),this._calcMatrices();}get unmodified(){return this._unmodified}zoomScale(t){return Math.pow(2,t)}scaleZoom(t){return Math.log(t)/Math.LN2}project(t){const i=e.ac(t.lat,-85.051129,fa);return new e.P(e.O(t.lng)*this.worldSize,e.Q(i)*this.worldSize)}unproject(t){return new e.Z(t.x/this.worldSize,t.y/this.worldSize).toLngLat()}get point(){return this.project(this.center)}getCameraPosition(){return {lngLat:this.pointLocation(this.getCameraPoint()),altitude:Math.cos(this._pitch)*this.cameraToCenterDistance/this._pixelPerMeter+this.elevation}}recalculateZoom(t){const i=this.elevation,a=Math.cos(this._pitch)*this.cameraToCenterDistance/this._pixelPerMeter,s=this.pointLocation(this.centerPoint,t),o=t.getElevationForLngLatZoom(s,this.tileZoom);if(!(this.elevation-o))return;const r=a+i-o,n=Math.cos(this._pitch)*this.cameraToCenterDistance/r/e.b4(1,s.lat),l=this.scaleZoom(n/this.tileSize);this._elevation=o,this._center=s,this.zoom=l;}setLocationAtPoint(t,i){const a=this.pointCoordinate(i),s=this.pointCoordinate(this.centerPoint),o=this.locationCoordinate(t),r=new e.Z(o.x-(a.x-s.x),o.y-(a.y-s.y));this.center=this.coordinateLocation(r),this._renderWorldCopies&&(this.center=this.center.wrap());}locationPoint(t,e){return e?this.coordinatePoint(this.locationCoordinate(t),e.getElevationForLngLatZoom(t,this.tileZoom),this.pixelMatrix3D):this.coordinatePoint(this.locationCoordinate(t))}pointLocation(t,e){return this.coordinateLocation(this.pointCoordinate(t,e))}locationCoordinate(t){return e.Z.fromLngLat(t)}coordinateLocation(t){return t&&t.toLngLat()}pointCoordinate(t,i){if(i){const e=i.pointCoordinate(t);if(null!=e)return e}const a=[t.x,t.y,0,1],s=[t.x,t.y,1,1];e.af(a,a,this.pixelMatrixInverse),e.af(s,s,this.pixelMatrixInverse);const o=a[3],r=s[3],n=a[1]/o,l=s[1]/r,h=a[2]/o,c=s[2]/r,u=h===c?0:(0-h)/(c-h);return new e.Z(e.y.number(a[0]/o,s[0]/r,u)/this.worldSize,e.y.number(n,l,u)/this.worldSize)}coordinatePoint(t,i=0,a=this.pixelMatrix){const s=[t.x*this.worldSize,t.y*this.worldSize,i,1];return e.af(s,s,a),new e.P(s[0]/s[3],s[1]/s[3])}getBounds(){const t=Math.max(0,this.height/2-this.getHorizon());return (new H).extend(this.pointLocation(new e.P(0,t))).extend(this.pointLocation(new e.P(this.width,t))).extend(this.pointLocation(new e.P(this.width,this.height))).extend(this.pointLocation(new e.P(0,this.height)))}getMaxBounds(){return this.latRange&&2===this.latRange.length&&this.lngRange&&2===this.lngRange.length?new H([this.lngRange[0],this.latRange[0]],[this.lngRange[1],this.latRange[1]]):null}getHorizon(){return Math.tan(Math.PI/2-this._pitch)*this.cameraToCenterDistance*.85}setMaxBounds(t){t?(this.lngRange=[t.getWest(),t.getEast()],this.latRange=[t.getSouth(),t.getNorth()],this._constrain()):(this.lngRange=null,this.latRange=[-85.051129,fa]);}calculateTileMatrix(t){const i=t.canonical,a=this.worldSize/this.zoomScale(i.z),s=i.x+Math.pow(2,i.z)*t.wrap,o=e.an(new Float64Array(16));return e.J(o,o,[s*a,i.y*a,0]),e.K(o,o,[a/e.X,a/e.X,1]),o}calculatePosMatrix(t,i=!1){const a=t.key,s=i?this._alignedPosMatrixCache:this._posMatrixCache;if(s[a])return s[a];const o=this.calculateTileMatrix(t);return e.L(o,i?this.alignedModelViewProjectionMatrix:this.modelViewProjectionMatrix,o),s[a]=new Float32Array(o),s[a]}calculateFogMatrix(t){const i=t.key,a=this._fogMatrixCache;if(a[i])return a[i];const s=this.calculateTileMatrix(t);return e.L(s,this.fogMatrix,s),a[i]=new Float32Array(s),a[i]}customLayerMatrix(){return this.mercatorMatrix.slice()}getConstrained(t,i){i=e.ac(+i,this.minZoom,this.maxZoom);const a={center:new e.N(t.lng,t.lat),zoom:i};let s=this.lngRange;if(!this._renderWorldCopies&&null===s){const t=180-1e-10;s=[-t,t];}const o=this.tileSize*this.zoomScale(a.zoom);let r=0,n=o,l=0,h=o,c=0,u=0;const{x:d,y:_}=this.size;if(this.latRange){const t=this.latRange;r=e.Q(t[1])*o,n=e.Q(t[0])*o,n-r<_&&(c=_/(n-r));}s&&(l=e.b2(e.O(s[0])*o,0,o),h=e.b2(e.O(s[1])*o,0,o),h<l&&(h+=o),h-l<d&&(u=d/(h-l)));const{x:p,y:m}=this.project.call({worldSize:o},t);let f,g;const v=Math.max(u||0,c||0);if(v){const t=new e.P(u?(h+l)/2:p,c?(n+r)/2:m);return a.center=this.unproject.call({worldSize:o},t).wrap(),a.zoom+=this.scaleZoom(v),a}if(this.latRange){const t=_/2;m-t<r&&(g=r+t),m+t>n&&(g=n-t);}if(s){const t=(l+h)/2;let i=p;this._renderWorldCopies&&(i=e.b2(p,t-o/2,t+o/2));const a=d/2;i-a<l&&(f=l+a),i+a>h&&(f=h-a);}if(void 0!==f||void 0!==g){const t=new e.P(null!=f?f:p,null!=g?g:m);a.center=this.unproject.call({worldSize:o},t).wrap();}return a}_constrain(){if(!this.center||!this.width||!this.height||this._constraining)return;this._constraining=!0;const t=this._unmodified,{center:e,zoom:i}=this.getConstrained(this.center,this.zoom);this.center=e,this.zoom=i,this._unmodified=t,this._constraining=!1;}_calcMatrices(){if(!this.height)return;const t=this.centerOffset,i=this.point.x,a=this.point.y;this.cameraToCenterDistance=.5/Math.tan(this._fov/2)*this.height,this._pixelPerMeter=e.b4(1,this.center.lat)*this.worldSize;let s=e.an(new Float64Array(16));e.K(s,s,[this.width/2,-this.height/2,1]),e.J(s,s,[1,-1,0]),this.labelPlaneMatrix=s,s=e.an(new Float64Array(16)),e.K(s,s,[1,-1,1]),e.J(s,s,[-1,-1,0]),e.K(s,s,[2/this.width,2/this.height,1]),this.glCoordMatrix=s;const o=this.cameraToCenterDistance+this._elevation*this._pixelPerMeter/Math.cos(this._pitch),r=Math.min(this.elevation,this.minElevationForCurrentTile),n=o-r*this._pixelPerMeter/Math.cos(this._pitch),l=r<0?n:o,h=Math.PI/2+this._pitch,c=this._fov*(.5+t.y/this.height),u=Math.sin(c)*l/Math.sin(e.ac(Math.PI-h-c,.01,Math.PI-.01)),d=this.getHorizon(),_=2*Math.atan(d/this.cameraToCenterDistance)*(.5+t.y/(2*d)),p=Math.sin(_)*l/Math.sin(e.ac(Math.PI-h-_,.01,Math.PI-.01)),m=Math.min(u,p);this.farZ=1.01*(Math.cos(Math.PI/2-this._pitch)*m+l),this.nearZ=this.height/50,s=new Float64Array(16),e.b5(s,this._fov,this.width/this.height,this.nearZ,this.farZ),s[8]=2*-t.x/this.width,s[9]=2*t.y/this.height,this.projectionMatrix=e.ae(s),e.K(s,s,[1,-1,1]),e.J(s,s,[0,0,-this.cameraToCenterDistance]),e.b6(s,s,this._pitch),e.ad(s,s,this.angle),e.J(s,s,[-i,-a,0]),this.mercatorMatrix=e.K([],s,[this.worldSize,this.worldSize,this.worldSize]),e.K(s,s,[1,1,this._pixelPerMeter]),this.pixelMatrix=e.L(new Float64Array(16),this.labelPlaneMatrix,s),e.J(s,s,[0,0,-this.elevation]),this.modelViewProjectionMatrix=s,this.invModelViewProjectionMatrix=e.as([],s),this.fogMatrix=new Float64Array(16),e.b5(this.fogMatrix,this._fov,this.width/this.height,o,this.farZ),this.fogMatrix[8]=2*-t.x/this.width,this.fogMatrix[9]=2*t.y/this.height,e.K(this.fogMatrix,this.fogMatrix,[1,-1,1]),e.J(this.fogMatrix,this.fogMatrix,[0,0,-this.cameraToCenterDistance]),e.b6(this.fogMatrix,this.fogMatrix,this._pitch),e.ad(this.fogMatrix,this.fogMatrix,this.angle),e.J(this.fogMatrix,this.fogMatrix,[-i,-a,0]),e.K(this.fogMatrix,this.fogMatrix,[1,1,this._pixelPerMeter]),e.J(this.fogMatrix,this.fogMatrix,[0,0,-this.elevation]),this.pixelMatrix3D=e.L(new Float64Array(16),this.labelPlaneMatrix,s);const f=this.width%2/2,g=this.height%2/2,v=Math.cos(this.angle),x=Math.sin(this.angle),y=i-Math.round(i)+v*f+x*g,b=a-Math.round(a)+v*g+x*f,w=new Float64Array(s);if(e.J(w,w,[y>.5?y-1:y,b>.5?b-1:b,0]),this.alignedModelViewProjectionMatrix=w,s=e.as(new Float64Array(16),this.pixelMatrix),!s)throw new Error("failed to invert matrix");this.pixelMatrixInverse=s,this._posMatrixCache={},this._alignedPosMatrixCache={},this._fogMatrixCache={};}maxPitchScaleFactor(){if(!this.pixelMatrixInverse)return 1;const t=this.pointCoordinate(new e.P(0,0)),i=[t.x*this.worldSize,t.y*this.worldSize,0,1];return e.af(i,i,this.pixelMatrix)[3]/this.cameraToCenterDistance}getCameraPoint(){const t=Math.tan(this._pitch)*(this.cameraToCenterDistance||1);return this.centerPoint.add(new e.P(0,t))}getCameraQueryGeometry(t){const i=this.getCameraPoint();if(1===t.length)return [t[0],i];{let a=i.x,s=i.y,o=i.x,r=i.y;for(const e of t)a=Math.min(a,e.x),s=Math.min(s,e.y),o=Math.max(o,e.x),r=Math.max(r,e.y);return [new e.P(a,s),new e.P(o,s),new e.P(o,r),new e.P(a,r),new e.P(a,s)]}}lngLatToCameraDepth(t,i){const a=this.locationCoordinate(t),s=[a.x*this.worldSize,a.y*this.worldSize,i,1];return e.af(s,s,this.modelViewProjectionMatrix),s[2]/s[3]}}function va(t,e){let i,a=!1,s=null,o=null;const r=()=>{s=null,a&&(t.apply(o,i),s=setTimeout(r,e),a=!1);};return (...t)=>(a=!0,o=this,i=t,s||r(),s)}class xa{constructor(t){this._getCurrentHash=()=>{const t=window.location.hash.replace("#","");if(this._hashName){let e;return t.split("&").map((t=>t.split("="))).forEach((t=>{t[0]===this._hashName&&(e=t);})),(e&&e[1]||"").split("/")}return t.split("/")},this._onHashChange=()=>{const t=this._getCurrentHash();if(t.length>=3&&!t.some((t=>isNaN(t)))){const e=this._map.dragRotate.isEnabled()&&this._map.touchZoomRotate.isEnabled()?+(t[3]||0):this._map.getBearing();return this._map.jumpTo({center:[+t[2],+t[1]],zoom:+t[0],bearing:e,pitch:+(t[4]||0)}),!0}return !1},this._updateHashUnthrottled=()=>{const t=window.location.href.replace(/(#.+)?$/,this.getHashString());window.history.replaceState(window.history.state,null,t);},this._removeHash=()=>{const t=this._getCurrentHash();if(0===t.length)return;const e=t.join("/");let i=e;i.split("&").length>0&&(i=i.split("&")[0]),this._hashName&&(i=`${this._hashName}=${e}`);let a=window.location.hash.replace(i,"");a.startsWith("#&")?a=a.slice(0,1)+a.slice(2):"#"===a&&(a="");let s=window.location.href.replace(/(#.+)?$/,a);s=s.replace("&&","&"),window.history.replaceState(window.history.state,null,s);},this._updateHash=va(this._updateHashUnthrottled,300),this._hashName=t&&encodeURIComponent(t);}addTo(t){return this._map=t,addEventListener("hashchange",this._onHashChange,!1),this._map.on("moveend",this._updateHash),this}remove(){return removeEventListener("hashchange",this._onHashChange,!1),this._map.off("moveend",this._updateHash),clearTimeout(this._updateHash()),this._removeHash(),delete this._map,this}getHashString(t){const e=this._map.getCenter(),i=Math.round(100*this._map.getZoom())/100,a=Math.ceil((i*Math.LN2+Math.log(512/360/.5))/Math.LN10),s=Math.pow(10,a),o=Math.round(e.lng*s)/s,r=Math.round(e.lat*s)/s,n=this._map.getBearing(),l=this._map.getPitch();let h="";if(h+=t?`/${o}/${r}/${i}`:`${i}/${r}/${o}`,(n||l)&&(h+="/"+Math.round(10*n)/10),l&&(h+=`/${Math.round(l)}`),this._hashName){const t=this._hashName;let e=!1;const i=window.location.hash.slice(1).split("&").map((i=>{const a=i.split("=")[0];return a===t?(e=!0,`${a}=${h}`):i})).filter((t=>t));return e||i.push(`${t}=${h}`),`#${i.join("&")}`}return `#${h}`}}const ya={linearity:.3,easing:e.b7(0,0,.3,1)},ba=e.e({deceleration:2500,maxSpeed:1400},ya),wa=e.e({deceleration:20,maxSpeed:1400},ya),Ta=e.e({deceleration:1e3,maxSpeed:360},ya),Ia=e.e({deceleration:1e3,maxSpeed:90},ya);class Ea{constructor(t){this._map=t,this.clear();}clear(){this._inertiaBuffer=[];}record(t){this._drainInertiaBuffer(),this._inertiaBuffer.push({time:o.now(),settings:t});}_drainInertiaBuffer(){const t=this._inertiaBuffer,e=o.now();for(;t.length>0&&e-t[0].time>160;)t.shift();}_onMoveEnd(t){if(this._drainInertiaBuffer(),this._inertiaBuffer.length<2)return;const i={zoom:0,bearing:0,pitch:0,pan:new e.P(0,0),pinchAround:void 0,around:void 0};for(const{settings:t}of this._inertiaBuffer)i.zoom+=t.zoomDelta||0,i.bearing+=t.bearingDelta||0,i.pitch+=t.pitchDelta||0,t.panDelta&&i.pan._add(t.panDelta),t.around&&(i.around=t.around),t.pinchAround&&(i.pinchAround=t.pinchAround);const a=this._inertiaBuffer[this._inertiaBuffer.length-1].time-this._inertiaBuffer[0].time,s={};if(i.pan.mag()){const o=Ca(i.pan.mag(),a,e.e({},ba,t||{}));s.offset=i.pan.mult(o.amount/i.pan.mag()),s.center=this._map.transform.center,Pa(s,o);}if(i.zoom){const t=Ca(i.zoom,a,wa);s.zoom=this._map.transform.zoom+t.amount,Pa(s,t);}if(i.bearing){const t=Ca(i.bearing,a,Ta);s.bearing=this._map.transform.bearing+e.ac(t.amount,-179,179),Pa(s,t);}if(i.pitch){const t=Ca(i.pitch,a,Ia);s.pitch=this._map.transform.pitch+t.amount,Pa(s,t);}if(s.zoom||s.bearing){const t=void 0===i.pinchAround?i.around:i.pinchAround;s.around=t?this._map.unproject(t):this._map.getCenter();}return this.clear(),e.e(s,{noMoveStart:!0})}}function Pa(t,e){(!t.duration||t.duration<e.duration)&&(t.duration=e.duration,t.easing=e.easing);}function Ca(t,i,a){const{maxSpeed:s,linearity:o,deceleration:r}=a,n=e.ac(t*o/(i/1e3),-s,s),l=Math.abs(n)/(r*o);return {easing:a.easing,duration:1e3*l,amount:n*(l/2)}}class Sa extends e.k{preventDefault(){this._defaultPrevented=!0;}get defaultPrevented(){return this._defaultPrevented}constructor(t,i,a,s={}){const o=r.mousePos(i.getCanvas(),a),n=i.unproject(o);super(t,e.e({point:o,lngLat:n,originalEvent:a},s)),this._defaultPrevented=!1,this.target=i;}}class za extends e.k{preventDefault(){this._defaultPrevented=!0;}get defaultPrevented(){return this._defaultPrevented}constructor(t,i,a){const s="touchend"===t?a.changedTouches:a.touches,o=r.touchPos(i.getCanvasContainer(),s),n=o.map((t=>i.unproject(t))),l=o.reduce(((t,e,i,a)=>t.add(e.div(a.length))),new e.P(0,0));super(t,{points:o,point:l,lngLats:n,lngLat:i.unproject(l),originalEvent:a}),this._defaultPrevented=!1;}}class Da extends e.k{preventDefault(){this._defaultPrevented=!0;}get defaultPrevented(){return this._defaultPrevented}constructor(t,e,i){super(t,{originalEvent:i}),this._defaultPrevented=!1;}}class Ma{constructor(t,e){this._map=t,this._clickTolerance=e.clickTolerance;}reset(){delete this._mousedownPos;}wheel(t){return this._firePreventable(new Da(t.type,this._map,t))}mousedown(t,e){return this._mousedownPos=e,this._firePreventable(new Sa(t.type,this._map,t))}mouseup(t){this._map.fire(new Sa(t.type,this._map,t));}click(t,e){this._mousedownPos&&this._mousedownPos.dist(e)>=this._clickTolerance||this._map.fire(new Sa(t.type,this._map,t));}dblclick(t){return this._firePreventable(new Sa(t.type,this._map,t))}mouseover(t){this._map.fire(new Sa(t.type,this._map,t));}mouseout(t){this._map.fire(new Sa(t.type,this._map,t));}touchstart(t){return this._firePreventable(new za(t.type,this._map,t))}touchmove(t){this._map.fire(new za(t.type,this._map,t));}touchend(t){this._map.fire(new za(t.type,this._map,t));}touchcancel(t){this._map.fire(new za(t.type,this._map,t));}_firePreventable(t){if(this._map.fire(t),t.defaultPrevented)return {}}isEnabled(){return !0}isActive(){return !1}enable(){}disable(){}}class Aa{constructor(t){this._map=t;}reset(){this._delayContextMenu=!1,this._ignoreContextMenu=!0,delete this._contextMenuEvent;}mousemove(t){this._map.fire(new Sa(t.type,this._map,t));}mousedown(){this._delayContextMenu=!0,this._ignoreContextMenu=!1;}mouseup(){this._delayContextMenu=!1,this._contextMenuEvent&&(this._map.fire(new Sa("contextmenu",this._map,this._contextMenuEvent)),delete this._contextMenuEvent);}contextmenu(t){this._delayContextMenu?this._contextMenuEvent=t:this._ignoreContextMenu||this._map.fire(new Sa(t.type,this._map,t)),this._map.listens("contextmenu")&&t.preventDefault();}isEnabled(){return !0}isActive(){return !1}enable(){}disable(){}}class Ra{constructor(t){this._map=t;}get transform(){return this._map._requestedCameraState||this._map.transform}get center(){return {lng:this.transform.center.lng,lat:this.transform.center.lat}}get zoom(){return this.transform.zoom}get pitch(){return this.transform.pitch}get bearing(){return this.transform.bearing}unproject(t){return this.transform.pointLocation(e.P.convert(t),this._map.terrain)}}class ka{constructor(t,e){this._map=t,this._tr=new Ra(t),this._el=t.getCanvasContainer(),this._container=t.getContainer(),this._clickTolerance=e.clickTolerance||1;}isEnabled(){return !!this._enabled}isActive(){return !!this._active}enable(){this.isEnabled()||(this._enabled=!0);}disable(){this.isEnabled()&&(this._enabled=!1);}mousedown(t,e){this.isEnabled()&&t.shiftKey&&0===t.button&&(r.disableDrag(),this._startPos=this._lastPos=e,this._active=!0);}mousemoveWindow(t,e){if(!this._active)return;const i=e;if(this._lastPos.equals(i)||!this._box&&i.dist(this._startPos)<this._clickTolerance)return;const a=this._startPos;this._lastPos=i,this._box||(this._box=r.create("div","maplibregl-boxzoom",this._container),this._container.classList.add("maplibregl-crosshair"),this._fireEvent("boxzoomstart",t));const s=Math.min(a.x,i.x),o=Math.max(a.x,i.x),n=Math.min(a.y,i.y),l=Math.max(a.y,i.y);r.setTransform(this._box,`translate(${s}px,${n}px)`),this._box.style.width=o-s+"px",this._box.style.height=l-n+"px";}mouseupWindow(t,i){if(!this._active)return;if(0!==t.button)return;const a=this._startPos,s=i;if(this.reset(),r.suppressClick(),a.x!==s.x||a.y!==s.y)return this._map.fire(new e.k("boxzoomend",{originalEvent:t})),{cameraAnimation:t=>t.fitScreenCoordinates(a,s,this._tr.bearing,{linear:!0})};this._fireEvent("boxzoomcancel",t);}keydown(t){this._active&&27===t.keyCode&&(this.reset(),this._fireEvent("boxzoomcancel",t));}reset(){this._active=!1,this._container.classList.remove("maplibregl-crosshair"),this._box&&(r.remove(this._box),this._box=null),r.enableDrag(),delete this._startPos,delete this._lastPos;}_fireEvent(t,i){return this._map.fire(new e.k(t,{originalEvent:i}))}}function La(t,e){if(t.length!==e.length)throw new Error(`The number of touches and points are not equal - touches ${t.length}, points ${e.length}`);const i={};for(let a=0;a<t.length;a++)i[t[a].identifier]=e[a];return i}class Fa{constructor(t){this.reset(),this.numTouches=t.numTouches;}reset(){delete this.centroid,delete this.startTime,delete this.touches,this.aborted=!1;}touchstart(t,i,a){(this.centroid||a.length>this.numTouches)&&(this.aborted=!0),this.aborted||(void 0===this.startTime&&(this.startTime=t.timeStamp),a.length===this.numTouches&&(this.centroid=function(t){const i=new e.P(0,0);for(const e of t)i._add(e);return i.div(t.length)}(i),this.touches=La(a,i)));}touchmove(t,e,i){if(this.aborted||!this.centroid)return;const a=La(i,e);for(const t in this.touches){const e=a[t];(!e||e.dist(this.touches[t])>30)&&(this.aborted=!0);}}touchend(t,e,i){if((!this.centroid||t.timeStamp-this.startTime>500)&&(this.aborted=!0),0===i.length){const t=!this.aborted&&this.centroid;if(this.reset(),t)return t}}}class Ba{constructor(t){this.singleTap=new Fa(t),this.numTaps=t.numTaps,this.reset();}reset(){this.lastTime=1/0,delete this.lastTap,this.count=0,this.singleTap.reset();}touchstart(t,e,i){this.singleTap.touchstart(t,e,i);}touchmove(t,e,i){this.singleTap.touchmove(t,e,i);}touchend(t,e,i){const a=this.singleTap.touchend(t,e,i);if(a){const e=t.timeStamp-this.lastTime<500,i=!this.lastTap||this.lastTap.dist(a)<30;if(e&&i||this.reset(),this.count++,this.lastTime=t.timeStamp,this.lastTap=a,this.count===this.numTaps)return this.reset(),a}}}class Oa{constructor(t){this._tr=new Ra(t),this._zoomIn=new Ba({numTouches:1,numTaps:2}),this._zoomOut=new Ba({numTouches:2,numTaps:1}),this.reset();}reset(){this._active=!1,this._zoomIn.reset(),this._zoomOut.reset();}touchstart(t,e,i){this._zoomIn.touchstart(t,e,i),this._zoomOut.touchstart(t,e,i);}touchmove(t,e,i){this._zoomIn.touchmove(t,e,i),this._zoomOut.touchmove(t,e,i);}touchend(t,e,i){const a=this._zoomIn.touchend(t,e,i),s=this._zoomOut.touchend(t,e,i),o=this._tr;return a?(this._active=!0,t.preventDefault(),setTimeout((()=>this.reset()),0),{cameraAnimation:e=>e.easeTo({duration:300,zoom:o.zoom+1,around:o.unproject(a)},{originalEvent:t})}):s?(this._active=!0,t.preventDefault(),setTimeout((()=>this.reset()),0),{cameraAnimation:e=>e.easeTo({duration:300,zoom:o.zoom-1,around:o.unproject(s)},{originalEvent:t})}):void 0}touchcancel(){this.reset();}enable(){this._enabled=!0;}disable(){this._enabled=!1,this.reset();}isEnabled(){return this._enabled}isActive(){return this._active}}class Na{constructor(t){this._enabled=!!t.enable,this._moveStateManager=t.moveStateManager,this._clickTolerance=t.clickTolerance||1,this._moveFunction=t.move,this._activateOnStart=!!t.activateOnStart,t.assignEvents(this),this.reset();}reset(t){this._active=!1,this._moved=!1,delete this._lastPoint,this._moveStateManager.endMove(t);}_move(...t){const e=this._moveFunction(...t);if(e.bearingDelta||e.pitchDelta||e.around||e.panDelta)return this._active=!0,e}dragStart(t,e){this.isEnabled()&&!this._lastPoint&&this._moveStateManager.isValidStartEvent(t)&&(this._moveStateManager.startMove(t),this._lastPoint=e.length?e[0]:e,this._activateOnStart&&this._lastPoint&&(this._active=!0));}dragMove(t,e){if(!this.isEnabled())return;const i=this._lastPoint;if(!i)return;if(t.preventDefault(),!this._moveStateManager.isValidMoveEvent(t))return void this.reset(t);const a=e.length?e[0]:e;return !this._moved&&a.dist(i)<this._clickTolerance?void 0:(this._moved=!0,this._lastPoint=a,this._move(i,a))}dragEnd(t){this.isEnabled()&&this._lastPoint&&this._moveStateManager.isValidEndEvent(t)&&(this._moved&&r.suppressClick(),this.reset(t));}enable(){this._enabled=!0;}disable(){this._enabled=!1,this.reset();}isEnabled(){return this._enabled}isActive(){return this._active}getClickTolerance(){return this._clickTolerance}}const ja={0:1,2:2};class Ua{constructor(t){this._correctEvent=t.checkCorrectEvent;}startMove(t){const e=r.mouseButton(t);this._eventButton=e;}endMove(t){delete this._eventButton;}isValidStartEvent(t){return this._correctEvent(t)}isValidMoveEvent(t){return !function(t,e){const i=ja[e];return void 0===t.buttons||(t.buttons&i)!==i}(t,this._eventButton)}isValidEndEvent(t){return r.mouseButton(t)===this._eventButton}}class Za{constructor(){this._firstTouch=void 0;}_isOneFingerTouch(t){return 1===t.targetTouches.length}_isSameTouchEvent(t){return t.targetTouches[0].identifier===this._firstTouch}startMove(t){this._firstTouch=t.targetTouches[0].identifier;}endMove(t){delete this._firstTouch;}isValidStartEvent(t){return this._isOneFingerTouch(t)}isValidMoveEvent(t){return this._isOneFingerTouch(t)&&this._isSameTouchEvent(t)}isValidEndEvent(t){return this._isOneFingerTouch(t)&&this._isSameTouchEvent(t)}}const qa=t=>{t.mousedown=t.dragStart,t.mousemoveWindow=t.dragMove,t.mouseup=t.dragEnd,t.contextmenu=t=>{t.preventDefault();};},Va=({enable:t,clickTolerance:e,bearingDegreesPerPixelMoved:i=.8})=>{const a=new Ua({checkCorrectEvent:t=>0===r.mouseButton(t)&&t.ctrlKey||2===r.mouseButton(t)});return new Na({clickTolerance:e,move:(t,e)=>({bearingDelta:(e.x-t.x)*i}),moveStateManager:a,enable:t,assignEvents:qa})},Ga=({enable:t,clickTolerance:e,pitchDegreesPerPixelMoved:i=-.5})=>{const a=new Ua({checkCorrectEvent:t=>0===r.mouseButton(t)&&t.ctrlKey||2===r.mouseButton(t)});return new Na({clickTolerance:e,move:(t,e)=>({pitchDelta:(e.y-t.y)*i}),moveStateManager:a,enable:t,assignEvents:qa})};class Ha{constructor(t,e){this._clickTolerance=t.clickTolerance||1,this._map=e,this.reset();}reset(){this._active=!1,this._touches={},this._sum=new e.P(0,0);}_shouldBePrevented(t){return t<(this._map.cooperativeGestures.isEnabled()?2:1)}touchstart(t,e,i){return this._calculateTransform(t,e,i)}touchmove(t,e,i){if(this._active){if(!this._shouldBePrevented(i.length))return t.preventDefault(),this._calculateTransform(t,e,i);this._map.cooperativeGestures.notifyGestureBlocked("touch_pan",t);}}touchend(t,e,i){this._calculateTransform(t,e,i),this._active&&this._shouldBePrevented(i.length)&&this.reset();}touchcancel(){this.reset();}_calculateTransform(t,i,a){a.length>0&&(this._active=!0);const s=La(a,i),o=new e.P(0,0),r=new e.P(0,0);let n=0;for(const t in s){const e=s[t],i=this._touches[t];i&&(o._add(e),r._add(e.sub(i)),n++,s[t]=e);}if(this._touches=s,this._shouldBePrevented(n)||!r.mag())return;const l=r.div(n);return this._sum._add(l),this._sum.mag()<this._clickTolerance?void 0:{around:o.div(n),panDelta:l}}enable(){this._enabled=!0;}disable(){this._enabled=!1,this.reset();}isEnabled(){return this._enabled}isActive(){return this._active}}class Wa{constructor(){this.reset();}reset(){this._active=!1,delete this._firstTwoTouches;}touchstart(t,e,i){this._firstTwoTouches||i.length<2||(this._firstTwoTouches=[i[0].identifier,i[1].identifier],this._start([e[0],e[1]]));}touchmove(t,e,i){if(!this._firstTwoTouches)return;t.preventDefault();const[a,s]=this._firstTwoTouches,o=$a(i,e,a),r=$a(i,e,s);if(!o||!r)return;const n=this._aroundCenter?null:o.add(r).div(2);return this._move([o,r],n,t)}touchend(t,e,i){if(!this._firstTwoTouches)return;const[a,s]=this._firstTwoTouches,o=$a(i,e,a),n=$a(i,e,s);o&&n||(this._active&&r.suppressClick(),this.reset());}touchcancel(){this.reset();}enable(t){this._enabled=!0,this._aroundCenter=!!t&&"center"===t.around;}disable(){this._enabled=!1,this.reset();}isEnabled(){return !!this._enabled}isActive(){return !!this._active}}function $a(t,e,i){for(let a=0;a<t.length;a++)if(t[a].identifier===i)return e[a]}function Xa(t,e){return Math.log(t/e)/Math.LN2}class Ka extends Wa{reset(){super.reset(),delete this._distance,delete this._startDistance;}_start(t){this._startDistance=this._distance=t[0].dist(t[1]);}_move(t,e){const i=this._distance;if(this._distance=t[0].dist(t[1]),this._active||!(Math.abs(Xa(this._distance,this._startDistance))<.1))return this._active=!0,{zoomDelta:Xa(this._distance,i),pinchAround:e}}}function Ja(t,e){return 180*t.angleWith(e)/Math.PI}class Ya extends Wa{reset(){super.reset(),delete this._minDiameter,delete this._startVector,delete this._vector;}_start(t){this._startVector=this._vector=t[0].sub(t[1]),this._minDiameter=t[0].dist(t[1]);}_move(t,e,i){const a=this._vector;if(this._vector=t[0].sub(t[1]),this._active||!this._isBelowThreshold(this._vector))return this._active=!0,{bearingDelta:Ja(this._vector,a),pinchAround:e}}_isBelowThreshold(t){this._minDiameter=Math.min(this._minDiameter,t.mag());const e=25/(Math.PI*this._minDiameter)*360,i=Ja(t,this._startVector);return Math.abs(i)<e}}function Qa(t){return Math.abs(t.y)>Math.abs(t.x)}class ts extends Wa{constructor(t){super(),this._currentTouchCount=0,this._map=t;}reset(){super.reset(),this._valid=void 0,delete this._firstMove,delete this._lastPoints;}touchstart(t,e,i){super.touchstart(t,e,i),this._currentTouchCount=i.length;}_start(t){this._lastPoints=t,Qa(t[0].sub(t[1]))&&(this._valid=!1);}_move(t,e,i){if(this._map.cooperativeGestures.isEnabled()&&this._currentTouchCount<3)return;const a=t[0].sub(this._lastPoints[0]),s=t[1].sub(this._lastPoints[1]);return this._valid=this.gestureBeginsVertically(a,s,i.timeStamp),this._valid?(this._lastPoints=t,this._active=!0,{pitchDelta:(a.y+s.y)/2*-.5}):void 0}gestureBeginsVertically(t,e,i){if(void 0!==this._valid)return this._valid;const a=t.mag()>=2,s=e.mag()>=2;if(!a&&!s)return;if(!a||!s)return void 0===this._firstMove&&(this._firstMove=i),i-this._firstMove<100&&void 0;const o=t.y>0==e.y>0;return Qa(t)&&Qa(e)&&o}}const es={panStep:100,bearingStep:15,pitchStep:10};class is{constructor(t){this._tr=new Ra(t);const e=es;this._panStep=e.panStep,this._bearingStep=e.bearingStep,this._pitchStep=e.pitchStep,this._rotationDisabled=!1;}reset(){this._active=!1;}keydown(t){if(t.altKey||t.ctrlKey||t.metaKey)return;let e=0,i=0,a=0,s=0,o=0;switch(t.keyCode){case 61:case 107:case 171:case 187:e=1;break;case 189:case 109:case 173:e=-1;break;case 37:t.shiftKey?i=-1:(t.preventDefault(),s=-1);break;case 39:t.shiftKey?i=1:(t.preventDefault(),s=1);break;case 38:t.shiftKey?a=1:(t.preventDefault(),o=-1);break;case 40:t.shiftKey?a=-1:(t.preventDefault(),o=1);break;default:return}return this._rotationDisabled&&(i=0,a=0),{cameraAnimation:r=>{const n=this._tr;r.easeTo({duration:300,easeId:"keyboardHandler",easing:as,zoom:e?Math.round(n.zoom)+e*(t.shiftKey?2:1):n.zoom,bearing:n.bearing+i*this._bearingStep,pitch:n.pitch+a*this._pitchStep,offset:[-s*this._panStep,-o*this._panStep],center:n.center},{originalEvent:t});}}}enable(){this._enabled=!0;}disable(){this._enabled=!1,this.reset();}isEnabled(){return this._enabled}isActive(){return this._active}disableRotation(){this._rotationDisabled=!0;}enableRotation(){this._rotationDisabled=!1;}}function as(t){return t*(2-t)}const ss=4.000244140625;class os{constructor(t,e){this._onTimeout=t=>{this._type="wheel",this._delta-=this._lastValue,this._active||this._start(t);},this._map=t,this._tr=new Ra(t),this._triggerRenderFrame=e,this._delta=0,this._defaultZoomRate=.01,this._wheelZoomRate=.0022222222222222222;}setZoomRate(t){this._defaultZoomRate=t;}setWheelZoomRate(t){this._wheelZoomRate=t;}isEnabled(){return !!this._enabled}isActive(){return !!this._active||void 0!==this._finishTimeout}isZooming(){return !!this._zooming}enable(t){this.isEnabled()||(this._enabled=!0,this._aroundCenter=!!t&&"center"===t.around);}disable(){this.isEnabled()&&(this._enabled=!1);}_shouldBePrevented(t){return !!this._map.cooperativeGestures.isEnabled()&&!(t.ctrlKey||this._map.cooperativeGestures.isBypassed(t))}wheel(t){if(!this.isEnabled())return;if(this._shouldBePrevented(t))return void this._map.cooperativeGestures.notifyGestureBlocked("wheel_zoom",t);let e=t.deltaMode===WheelEvent.DOM_DELTA_LINE?40*t.deltaY:t.deltaY;const i=o.now(),a=i-(this._lastWheelEventTime||0);this._lastWheelEventTime=i,0!==e&&e%ss==0?this._type="wheel":0!==e&&Math.abs(e)<4?this._type="trackpad":a>400?(this._type=null,this._lastValue=e,this._timeout=setTimeout(this._onTimeout,40,t)):this._type||(this._type=Math.abs(a*e)<200?"trackpad":"wheel",this._timeout&&(clearTimeout(this._timeout),this._timeout=null,e+=this._lastValue)),t.shiftKey&&e&&(e/=4),this._type&&(this._lastWheelEvent=t,this._delta-=e,this._active||this._start(t)),t.preventDefault();}_start(t){if(!this._delta)return;this._frameId&&(this._frameId=null),this._active=!0,this.isZooming()||(this._zooming=!0),this._finishTimeout&&(clearTimeout(this._finishTimeout),delete this._finishTimeout);const i=r.mousePos(this._map.getCanvas(),t),a=this._tr;this._around=i.y>a.transform.height/2-a.transform.getHorizon()?e.N.convert(this._aroundCenter?a.center:a.unproject(i)):e.N.convert(a.center),this._aroundPoint=a.transform.locationPoint(this._around),this._frameId||(this._frameId=!0,this._triggerRenderFrame());}renderFrame(){if(!this._frameId)return;if(this._frameId=null,!this.isActive())return;const t=this._tr.transform;if(0!==this._delta){const e="wheel"===this._type&&Math.abs(this._delta)>ss?this._wheelZoomRate:this._defaultZoomRate;let i=2/(1+Math.exp(-Math.abs(this._delta*e)));this._delta<0&&0!==i&&(i=1/i);const a="number"==typeof this._targetZoom?t.zoomScale(this._targetZoom):t.scale;this._targetZoom=Math.min(t.maxZoom,Math.max(t.minZoom,t.scaleZoom(a*i))),"wheel"===this._type&&(this._startZoom=t.zoom,this._easing=this._smoothOutEasing(200)),this._delta=0;}const i="number"==typeof this._targetZoom?this._targetZoom:t.zoom,a=this._startZoom,s=this._easing;let r,n=!1;const l=o.now()-this._lastWheelEventTime;if("wheel"===this._type&&a&&s&&l){const t=Math.min(l/200,1),o=s(t);r=e.y.number(a,i,o),t<1?this._frameId||(this._frameId=!0):n=!0;}else r=i,n=!0;return this._active=!0,n&&(this._active=!1,this._finishTimeout=setTimeout((()=>{this._zooming=!1,this._triggerRenderFrame(),delete this._targetZoom,delete this._finishTimeout;}),200)),{noInertia:!0,needsRenderFrame:!n,zoomDelta:r-t.zoom,around:this._aroundPoint,originalEvent:this._lastWheelEvent}}_smoothOutEasing(t){let i=e.b8;if(this._prevEase){const t=this._prevEase,a=(o.now()-t.start)/t.duration,s=t.easing(a+.01)-t.easing(a),r=.27/Math.sqrt(s*s+1e-4)*.01,n=Math.sqrt(.0729-r*r);i=e.b7(r,n,.25,1);}return this._prevEase={start:o.now(),duration:t,easing:i},i}reset(){this._active=!1,this._zooming=!1,delete this._targetZoom,this._finishTimeout&&(clearTimeout(this._finishTimeout),delete this._finishTimeout);}}class rs{constructor(t,e){this._clickZoom=t,this._tapZoom=e;}enable(){this._clickZoom.enable(),this._tapZoom.enable();}disable(){this._clickZoom.disable(),this._tapZoom.disable();}isEnabled(){return this._clickZoom.isEnabled()&&this._tapZoom.isEnabled()}isActive(){return this._clickZoom.isActive()||this._tapZoom.isActive()}}class ns{constructor(t){this._tr=new Ra(t),this.reset();}reset(){this._active=!1;}dblclick(t,e){return t.preventDefault(),{cameraAnimation:i=>{i.easeTo({duration:300,zoom:this._tr.zoom+(t.shiftKey?-1:1),around:this._tr.unproject(e)},{originalEvent:t});}}}enable(){this._enabled=!0;}disable(){this._enabled=!1,this.reset();}isEnabled(){return this._enabled}isActive(){return this._active}}class ls{constructor(){this._tap=new Ba({numTouches:1,numTaps:1}),this.reset();}reset(){this._active=!1,delete this._swipePoint,delete this._swipeTouch,delete this._tapTime,delete this._tapPoint,this._tap.reset();}touchstart(t,e,i){if(!this._swipePoint)if(this._tapTime){const a=e[0],s=t.timeStamp-this._tapTime<500,o=this._tapPoint.dist(a)<30;s&&o?i.length>0&&(this._swipePoint=a,this._swipeTouch=i[0].identifier):this.reset();}else this._tap.touchstart(t,e,i);}touchmove(t,e,i){if(this._tapTime){if(this._swipePoint){if(i[0].identifier!==this._swipeTouch)return;const a=e[0],s=a.y-this._swipePoint.y;return this._swipePoint=a,t.preventDefault(),this._active=!0,{zoomDelta:s/128}}}else this._tap.touchmove(t,e,i);}touchend(t,e,i){if(this._tapTime)this._swipePoint&&0===i.length&&this.reset();else {const a=this._tap.touchend(t,e,i);a&&(this._tapTime=t.timeStamp,this._tapPoint=a);}}touchcancel(){this.reset();}enable(){this._enabled=!0;}disable(){this._enabled=!1,this.reset();}isEnabled(){return this._enabled}isActive(){return this._active}}class hs{constructor(t,e,i){this._el=t,this._mousePan=e,this._touchPan=i;}enable(t){this._inertiaOptions=t||{},this._mousePan.enable(),this._touchPan.enable(),this._el.classList.add("maplibregl-touch-drag-pan");}disable(){this._mousePan.disable(),this._touchPan.disable(),this._el.classList.remove("maplibregl-touch-drag-pan");}isEnabled(){return this._mousePan.isEnabled()&&this._touchPan.isEnabled()}isActive(){return this._mousePan.isActive()||this._touchPan.isActive()}}class cs{constructor(t,e,i){this._pitchWithRotate=t.pitchWithRotate,this._mouseRotate=e,this._mousePitch=i;}enable(){this._mouseRotate.enable(),this._pitchWithRotate&&this._mousePitch.enable();}disable(){this._mouseRotate.disable(),this._mousePitch.disable();}isEnabled(){return this._mouseRotate.isEnabled()&&(!this._pitchWithRotate||this._mousePitch.isEnabled())}isActive(){return this._mouseRotate.isActive()||this._mousePitch.isActive()}}class us{constructor(t,e,i,a){this._el=t,this._touchZoom=e,this._touchRotate=i,this._tapDragZoom=a,this._rotationDisabled=!1,this._enabled=!0;}enable(t){this._touchZoom.enable(t),this._rotationDisabled||this._touchRotate.enable(t),this._tapDragZoom.enable(),this._el.classList.add("maplibregl-touch-zoom-rotate");}disable(){this._touchZoom.disable(),this._touchRotate.disable(),this._tapDragZoom.disable(),this._el.classList.remove("maplibregl-touch-zoom-rotate");}isEnabled(){return this._touchZoom.isEnabled()&&(this._rotationDisabled||this._touchRotate.isEnabled())&&this._tapDragZoom.isEnabled()}isActive(){return this._touchZoom.isActive()||this._touchRotate.isActive()||this._tapDragZoom.isActive()}disableRotation(){this._rotationDisabled=!0,this._touchRotate.disable();}enableRotation(){this._rotationDisabled=!1,this._touchZoom.isEnabled()&&this._touchRotate.enable();}}class ds{constructor(t,e){this._bypassKey=-1!==navigator.userAgent.indexOf("Mac")?"metaKey":"ctrlKey",this._map=t,this._options=e,this._enabled=!1;}isActive(){return !1}reset(){}_setupUI(){if(this._container)return;const t=this._map.getCanvasContainer();t.classList.add("maplibregl-cooperative-gestures"),this._container=r.create("div","maplibregl-cooperative-gesture-screen",t);let e=this._map._getUIString("CooperativeGesturesHandler.WindowsHelpText");"metaKey"===this._bypassKey&&(e=this._map._getUIString("CooperativeGesturesHandler.MacHelpText"));const i=this._map._getUIString("CooperativeGesturesHandler.MobileHelpText"),a=document.createElement("div");a.className="maplibregl-desktop-message",a.textContent=e,this._container.appendChild(a);const s=document.createElement("div");s.className="maplibregl-mobile-message",s.textContent=i,this._container.appendChild(s),this._container.setAttribute("aria-hidden","true");}_destroyUI(){this._container&&(r.remove(this._container),this._map.getCanvasContainer().classList.remove("maplibregl-cooperative-gestures")),delete this._container;}enable(){this._setupUI(),this._enabled=!0;}disable(){this._enabled=!1,this._destroyUI();}isEnabled(){return this._enabled}isBypassed(t){return t[this._bypassKey]}notifyGestureBlocked(t,i){this._enabled&&(this._map.fire(new e.k("cooperativegestureprevented",{gestureType:t,originalEvent:i})),this._container.classList.add("maplibregl-show"),setTimeout((()=>{this._container.classList.remove("maplibregl-show");}),100));}}const _s=t=>t.zoom||t.drag||t.pitch||t.rotate;class ps extends e.k{}function ms(t){return t.panDelta&&t.panDelta.mag()||t.zoomDelta||t.bearingDelta||t.pitchDelta}class fs{constructor(t,e){this.handleWindowEvent=t=>{this.handleEvent(t,`${t.type}Window`);},this.handleEvent=(t,e)=>{if("blur"===t.type)return void this.stop(!0);this._updatingCamera=!0;const i="renderFrame"===t.type?void 0:t,a={needsRenderFrame:!1},s={},o={},n=t.touches,l=n?this._getMapTouches(n):void 0,h=l?r.touchPos(this._map.getCanvas(),l):r.mousePos(this._map.getCanvas(),t);for(const{handlerName:r,handler:n,allowed:c}of this._handlers){if(!n.isEnabled())continue;let u;this._blockedByActive(o,c,r)?n.reset():n[e||t.type]&&(u=n[e||t.type](t,h,l),this.mergeHandlerResult(a,s,u,r,i),u&&u.needsRenderFrame&&this._triggerRenderFrame()),(u||n.isActive())&&(o[r]=n);}const c={};for(const t in this._previousActiveHandlers)o[t]||(c[t]=i);this._previousActiveHandlers=o,(Object.keys(c).length||ms(a))&&(this._changes.push([a,s,c]),this._triggerRenderFrame()),(Object.keys(o).length||ms(a))&&this._map._stop(!0),this._updatingCamera=!1;const{cameraAnimation:u}=a;u&&(this._inertia.clear(),this._fireEvents({},{},!0),this._changes=[],u(this._map));},this._map=t,this._el=this._map.getCanvasContainer(),this._handlers=[],this._handlersById={},this._changes=[],this._inertia=new Ea(t),this._bearingSnap=e.bearingSnap,this._previousActiveHandlers={},this._eventsInProgress={},this._addDefaultHandlers(e);const i=this._el;this._listeners=[[i,"touchstart",{passive:!0}],[i,"touchmove",{passive:!1}],[i,"touchend",void 0],[i,"touchcancel",void 0],[i,"mousedown",void 0],[i,"mousemove",void 0],[i,"mouseup",void 0],[document,"mousemove",{capture:!0}],[document,"mouseup",void 0],[i,"mouseover",void 0],[i,"mouseout",void 0],[i,"dblclick",void 0],[i,"click",void 0],[i,"keydown",{capture:!1}],[i,"keyup",void 0],[i,"wheel",{passive:!1}],[i,"contextmenu",void 0],[window,"blur",void 0]];for(const[t,e,i]of this._listeners)r.addEventListener(t,e,t===document?this.handleWindowEvent:this.handleEvent,i);}destroy(){for(const[t,e,i]of this._listeners)r.removeEventListener(t,e,t===document?this.handleWindowEvent:this.handleEvent,i);}_addDefaultHandlers(t){const e=this._map,i=e.getCanvasContainer();this._add("mapEvent",new Ma(e,t));const a=e.boxZoom=new ka(e,t);this._add("boxZoom",a),t.interactive&&t.boxZoom&&a.enable();const s=e.cooperativeGestures=new ds(e,t.cooperativeGestures);this._add("cooperativeGestures",s),t.cooperativeGestures&&s.enable();const o=new Oa(e),n=new ns(e);e.doubleClickZoom=new rs(n,o),this._add("tapZoom",o),this._add("clickZoom",n),t.interactive&&t.doubleClickZoom&&e.doubleClickZoom.enable();const l=new ls;this._add("tapDragZoom",l);const h=e.touchPitch=new ts(e);this._add("touchPitch",h),t.interactive&&t.touchPitch&&e.touchPitch.enable(t.touchPitch);const c=Va(t),u=Ga(t);e.dragRotate=new cs(t,c,u),this._add("mouseRotate",c,["mousePitch"]),this._add("mousePitch",u,["mouseRotate"]),t.interactive&&t.dragRotate&&e.dragRotate.enable();const d=(({enable:t,clickTolerance:e})=>{const i=new Ua({checkCorrectEvent:t=>0===r.mouseButton(t)&&!t.ctrlKey});return new Na({clickTolerance:e,move:(t,e)=>({around:e,panDelta:e.sub(t)}),activateOnStart:!0,moveStateManager:i,enable:t,assignEvents:qa})})(t),_=new Ha(t,e);e.dragPan=new hs(i,d,_),this._add("mousePan",d),this._add("touchPan",_,["touchZoom","touchRotate"]),t.interactive&&t.dragPan&&e.dragPan.enable(t.dragPan);const p=new Ya,m=new Ka;e.touchZoomRotate=new us(i,m,p,l),this._add("touchRotate",p,["touchPan","touchZoom"]),this._add("touchZoom",m,["touchPan","touchRotate"]),t.interactive&&t.touchZoomRotate&&e.touchZoomRotate.enable(t.touchZoomRotate);const f=e.scrollZoom=new os(e,(()=>this._triggerRenderFrame()));this._add("scrollZoom",f,["mousePan"]),t.interactive&&t.scrollZoom&&e.scrollZoom.enable(t.scrollZoom);const g=e.keyboard=new is(e);this._add("keyboard",g),t.interactive&&t.keyboard&&e.keyboard.enable(),this._add("blockableMapEvent",new Aa(e));}_add(t,e,i){this._handlers.push({handlerName:t,handler:e,allowed:i}),this._handlersById[t]=e;}stop(t){if(!this._updatingCamera){for(const{handler:t}of this._handlers)t.reset();this._inertia.clear(),this._fireEvents({},{},t),this._changes=[];}}isActive(){for(const{handler:t}of this._handlers)if(t.isActive())return !0;return !1}isZooming(){return !!this._eventsInProgress.zoom||this._map.scrollZoom.isZooming()}isRotating(){return !!this._eventsInProgress.rotate}isMoving(){return Boolean(_s(this._eventsInProgress))||this.isZooming()}_blockedByActive(t,e,i){for(const a in t)if(a!==i&&(!e||e.indexOf(a)<0))return !0;return !1}_getMapTouches(t){const e=[];for(const i of t)this._el.contains(i.target)&&e.push(i);return e}mergeHandlerResult(t,i,a,s,o){if(!a)return;e.e(t,a);const r={handlerName:s,originalEvent:a.originalEvent||o};void 0!==a.zoomDelta&&(i.zoom=r),void 0!==a.panDelta&&(i.drag=r),void 0!==a.pitchDelta&&(i.pitch=r),void 0!==a.bearingDelta&&(i.rotate=r);}_applyChanges(){const t={},i={},a={};for(const[s,o,r]of this._changes)s.panDelta&&(t.panDelta=(t.panDelta||new e.P(0,0))._add(s.panDelta)),s.zoomDelta&&(t.zoomDelta=(t.zoomDelta||0)+s.zoomDelta),s.bearingDelta&&(t.bearingDelta=(t.bearingDelta||0)+s.bearingDelta),s.pitchDelta&&(t.pitchDelta=(t.pitchDelta||0)+s.pitchDelta),void 0!==s.around&&(t.around=s.around),void 0!==s.pinchAround&&(t.pinchAround=s.pinchAround),s.noInertia&&(t.noInertia=s.noInertia),e.e(i,o),e.e(a,r);this._updateMapTransform(t,i,a),this._changes=[];}_updateMapTransform(t,e,i){const a=this._map,s=a._getTransformForUpdate(),o=a.terrain;if(!(ms(t)||o&&this._terrainMovement))return this._fireEvents(e,i,!0);let{panDelta:r,zoomDelta:n,bearingDelta:l,pitchDelta:h,around:c,pinchAround:u}=t;void 0!==u&&(c=u),a._stop(!0),c=c||a.transform.centerPoint;const d=s.pointLocation(r?c.sub(r):c);l&&(s.bearing+=l),h&&(s.pitch+=h),n&&(s.zoom+=n),o?this._terrainMovement||!e.drag&&!e.zoom?e.drag&&this._terrainMovement?s.center=s.pointLocation(s.centerPoint.sub(r)):s.setLocationAtPoint(d,c):(this._terrainMovement=!0,this._map._elevationFreeze=!0,s.setLocationAtPoint(d,c)):s.setLocationAtPoint(d,c),a._applyUpdatedTransform(s),this._map._update(),t.noInertia||this._inertia.record(t),this._fireEvents(e,i,!0);}_fireEvents(t,i,a){const s=_s(this._eventsInProgress),r=_s(t),n={};for(const e in t){const{originalEvent:i}=t[e];this._eventsInProgress[e]||(n[`${e}start`]=i),this._eventsInProgress[e]=t[e];}!s&&r&&this._fireEvent("movestart",r.originalEvent);for(const t in n)this._fireEvent(t,n[t]);r&&this._fireEvent("move",r.originalEvent);for(const e in t){const{originalEvent:i}=t[e];this._fireEvent(e,i);}const l={};let h;for(const t in this._eventsInProgress){const{handlerName:e,originalEvent:a}=this._eventsInProgress[t];this._handlersById[e].isActive()||(delete this._eventsInProgress[t],h=i[e]||a,l[`${t}end`]=h);}for(const t in l)this._fireEvent(t,l[t]);const c=_s(this._eventsInProgress),u=(s||r)&&!c;if(u&&this._terrainMovement){this._map._elevationFreeze=!1,this._terrainMovement=!1;const t=this._map._getTransformForUpdate();t.recalculateZoom(this._map.terrain),this._map._applyUpdatedTransform(t);}if(a&&u){this._updatingCamera=!0;const t=this._inertia._onMoveEnd(this._map.dragPan._inertiaOptions),i=t=>0!==t&&-this._bearingSnap<t&&t<this._bearingSnap;!t||!t.essential&&o.prefersReducedMotion?(this._map.fire(new e.k("moveend",{originalEvent:h})),i(this._map.getBearing())&&this._map.resetNorth()):(i(t.bearing||this._map.getBearing())&&(t.bearing=0),t.freezeElevation=!0,this._map.easeTo(t,{originalEvent:h})),this._updatingCamera=!1;}}_fireEvent(t,i){this._map.fire(new e.k(t,i?{originalEvent:i}:{}));}_requestFrame(){return this._map.triggerRepaint(),this._map._renderTaskQueue.add((t=>{delete this._frameId,this.handleEvent(new ps("renderFrame",{timeStamp:t})),this._applyChanges();}))}_triggerRenderFrame(){void 0===this._frameId&&(this._frameId=this._requestFrame());}}class gs extends e.E{constructor(t,e){super(),this._renderFrameCallback=()=>{const t=Math.min((o.now()-this._easeStart)/this._easeOptions.duration,1);this._onEaseFrame(this._easeOptions.easing(t)),t<1&&this._easeFrameId?this._easeFrameId=this._requestRenderFrame(this._renderFrameCallback):this.stop();},this._moving=!1,this._zooming=!1,this.transform=t,this._bearingSnap=e.bearingSnap,this.on("moveend",(()=>{delete this._requestedCameraState;}));}getCenter(){return new e.N(this.transform.center.lng,this.transform.center.lat)}setCenter(t,e){return this.jumpTo({center:t},e)}panBy(t,i,a){return t=e.P.convert(t).mult(-1),this.panTo(this.transform.center,e.e({offset:t},i),a)}panTo(t,i,a){return this.easeTo(e.e({center:t},i),a)}getZoom(){return this.transform.zoom}setZoom(t,e){return this.jumpTo({zoom:t},e),this}zoomTo(t,i,a){return this.easeTo(e.e({zoom:t},i),a)}zoomIn(t,e){return this.zoomTo(this.getZoom()+1,t,e),this}zoomOut(t,e){return this.zoomTo(this.getZoom()-1,t,e),this}getBearing(){return this.transform.bearing}setBearing(t,e){return this.jumpTo({bearing:t},e),this}getPadding(){return this.transform.padding}setPadding(t,e){return this.jumpTo({padding:t},e),this}rotateTo(t,i,a){return this.easeTo(e.e({bearing:t},i),a)}resetNorth(t,i){return this.rotateTo(0,e.e({duration:1e3},t),i),this}resetNorthPitch(t,i){return this.easeTo(e.e({bearing:0,pitch:0,duration:1e3},t),i),this}snapToNorth(t,e){return Math.abs(this.getBearing())<this._bearingSnap?this.resetNorth(t,e):this}getPitch(){return this.transform.pitch}setPitch(t,e){return this.jumpTo({pitch:t},e),this}cameraForBounds(t,e){t=H.convert(t);const i=e&&e.bearing||0;return this._cameraForBoxAndBearing(t.getNorthWest(),t.getSouthEast(),i,e)}_cameraForBoxAndBearing(t,i,a,s){const o={top:0,bottom:0,right:0,left:0};if("number"==typeof(s=e.e({padding:o,offset:[0,0],maxZoom:this.transform.maxZoom},s)).padding){const t=s.padding;s.padding={top:t,bottom:t,right:t,left:t};}s.padding=e.e(o,s.padding);const r=this.transform,n=r.padding,l=new H(t,i),h=r.project(l.getNorthWest()),c=r.project(l.getNorthEast()),u=r.project(l.getSouthEast()),d=r.project(l.getSouthWest()),_=e.b9(-a),p=h.rotate(_),m=c.rotate(_),f=u.rotate(_),g=d.rotate(_),v=new e.P(Math.max(p.x,m.x,g.x,f.x),Math.max(p.y,m.y,g.y,f.y)),x=new e.P(Math.min(p.x,m.x,g.x,f.x),Math.min(p.y,m.y,g.y,f.y)),y=v.sub(x),b=(r.width-(n.left+n.right+s.padding.left+s.padding.right))/y.x,w=(r.height-(n.top+n.bottom+s.padding.top+s.padding.bottom))/y.y;if(w<0||b<0)return void e.w("Map cannot fit within canvas with the given bounds, padding, and/or offset.");const T=Math.min(r.scaleZoom(r.scale*Math.min(b,w)),s.maxZoom),I=e.P.convert(s.offset),E=new e.P((s.padding.left-s.padding.right)/2,(s.padding.top-s.padding.bottom)/2).rotate(e.b9(a)),P=I.add(E).mult(r.scale/r.zoomScale(T));return {center:r.unproject(h.add(u).div(2).sub(P)),zoom:T,bearing:a}}fitBounds(t,e,i){return this._fitInternal(this.cameraForBounds(t,e),e,i)}fitScreenCoordinates(t,i,a,s,o){return this._fitInternal(this._cameraForBoxAndBearing(this.transform.pointLocation(e.P.convert(t)),this.transform.pointLocation(e.P.convert(i)),a,s),s,o)}_fitInternal(t,i,a){return t?(delete(i=e.e(t,i)).padding,i.linear?this.easeTo(i,a):this.flyTo(i,a)):this}jumpTo(t,i){this.stop();const a=this._getTransformForUpdate();let s=!1,o=!1,r=!1;return "zoom"in t&&a.zoom!==+t.zoom&&(s=!0,a.zoom=+t.zoom),void 0!==t.center&&(a.center=e.N.convert(t.center)),"bearing"in t&&a.bearing!==+t.bearing&&(o=!0,a.bearing=+t.bearing),"pitch"in t&&a.pitch!==+t.pitch&&(r=!0,a.pitch=+t.pitch),null==t.padding||a.isPaddingEqual(t.padding)||(a.padding=t.padding),this._applyUpdatedTransform(a),this.fire(new e.k("movestart",i)).fire(new e.k("move",i)),s&&this.fire(new e.k("zoomstart",i)).fire(new e.k("zoom",i)).fire(new e.k("zoomend",i)),o&&this.fire(new e.k("rotatestart",i)).fire(new e.k("rotate",i)).fire(new e.k("rotateend",i)),r&&this.fire(new e.k("pitchstart",i)).fire(new e.k("pitch",i)).fire(new e.k("pitchend",i)),this.fire(new e.k("moveend",i))}calculateCameraOptionsFromTo(t,i,a,s=0){const o=e.Z.fromLngLat(t,i),r=e.Z.fromLngLat(a,s),n=r.x-o.x,l=r.y-o.y,h=r.z-o.z,c=Math.hypot(n,l,h);if(0===c)throw new Error("Can't calculate camera options with same From and To");const u=Math.hypot(n,l),d=this.transform.scaleZoom(this.transform.cameraToCenterDistance/c/this.transform.tileSize),_=180*Math.atan2(n,-l)/Math.PI;let p=180*Math.acos(u/c)/Math.PI;return p=h<0?90-p:90+p,{center:r.toLngLat(),zoom:d,pitch:p,bearing:_}}easeTo(t,i){var a;this._stop(!1,t.easeId),(!1===(t=e.e({offset:[0,0],duration:500,easing:e.b8},t)).animate||!t.essential&&o.prefersReducedMotion)&&(t.duration=0);const s=this._getTransformForUpdate(),r=s.zoom,n=s.bearing,l=s.pitch,h=s.padding,c="bearing"in t?this._normalizeBearing(t.bearing,n):n,u="pitch"in t?+t.pitch:l,d="padding"in t?t.padding:s.padding,_=e.P.convert(t.offset);let p=s.centerPoint.add(_);const m=s.pointLocation(p),{center:f,zoom:g}=s.getConstrained(e.N.convert(t.center||m),null!==(a=t.zoom)&&void 0!==a?a:r);this._normalizeCenter(f,s);const v=s.project(m),x=s.project(f).sub(v),y=s.zoomScale(g-r);let b,w;t.around&&(b=e.N.convert(t.around),w=s.locationPoint(b));const T={moving:this._moving,zooming:this._zooming,rotating:this._rotating,pitching:this._pitching};return this._zooming=this._zooming||g!==r,this._rotating=this._rotating||n!==c,this._pitching=this._pitching||u!==l,this._padding=!s.isPaddingEqual(d),this._easeId=t.easeId,this._prepareEase(i,t.noMoveStart,T),this.terrain&&this._prepareElevation(f),this._ease((a=>{if(this._zooming&&(s.zoom=e.y.number(r,g,a)),this._rotating&&(s.bearing=e.y.number(n,c,a)),this._pitching&&(s.pitch=e.y.number(l,u,a)),this._padding&&(s.interpolatePadding(h,d,a),p=s.centerPoint.add(_)),this.terrain&&!t.freezeElevation&&this._updateElevation(a),b)s.setLocationAtPoint(b,w);else {const t=s.zoomScale(s.zoom-r),e=g>r?Math.min(2,y):Math.max(.5,y),i=Math.pow(e,1-a),o=s.unproject(v.add(x.mult(a*i)).mult(t));s.setLocationAtPoint(s.renderWorldCopies?o.wrap():o,p);}this._applyUpdatedTransform(s),this._fireMoveEvents(i);}),(e=>{this.terrain&&t.freezeElevation&&this._finalizeElevation(),this._afterEase(i,e);}),t),this}_prepareEase(t,i,a={}){this._moving=!0,i||a.moving||this.fire(new e.k("movestart",t)),this._zooming&&!a.zooming&&this.fire(new e.k("zoomstart",t)),this._rotating&&!a.rotating&&this.fire(new e.k("rotatestart",t)),this._pitching&&!a.pitching&&this.fire(new e.k("pitchstart",t));}_prepareElevation(t){this._elevationCenter=t,this._elevationStart=this.transform.elevation,this._elevationTarget=this.terrain.getElevationForLngLatZoom(t,this.transform.tileZoom),this._elevationFreeze=!0;}_updateElevation(t){this.transform.minElevationForCurrentTile=this.terrain.getMinTileElevationForLngLatZoom(this._elevationCenter,this.transform.tileZoom);const i=this.terrain.getElevationForLngLatZoom(this._elevationCenter,this.transform.tileZoom);if(t<1&&i!==this._elevationTarget){const e=this._elevationTarget-this._elevationStart;this._elevationStart+=t*(e-(i-(e*t+this._elevationStart))/(1-t)),this._elevationTarget=i;}this.transform.elevation=e.y.number(this._elevationStart,this._elevationTarget,t);}_finalizeElevation(){this._elevationFreeze=!1,this.transform.recalculateZoom(this.terrain);}_getTransformForUpdate(){return this.transformCameraUpdate||this.terrain?(this._requestedCameraState||(this._requestedCameraState=this.transform.clone()),this._requestedCameraState):this.transform}_elevateCameraIfInsideTerrain(t){const e=t.getCameraPosition(),i=this.terrain.getElevationForLngLatZoom(e.lngLat,t.zoom);if(e.altitude<i){const a=this.calculateCameraOptionsFromTo(e.lngLat,i,t.center,t.elevation);return {pitch:a.pitch,zoom:a.zoom}}return {}}_applyUpdatedTransform(t){const e=[];if(this.terrain&&e.push((t=>this._elevateCameraIfInsideTerrain(t))),this.transformCameraUpdate&&e.push((t=>this.transformCameraUpdate(t))),!e.length)return;const i=t.clone();for(const t of e){const e=i.clone(),{center:a,zoom:s,pitch:o,bearing:r,elevation:n}=t(e);a&&(e.center=a),void 0!==s&&(e.zoom=s),void 0!==o&&(e.pitch=o),void 0!==r&&(e.bearing=r),void 0!==n&&(e.elevation=n),i.apply(e);}this.transform.apply(i);}_fireMoveEvents(t){this.fire(new e.k("move",t)),this._zooming&&this.fire(new e.k("zoom",t)),this._rotating&&this.fire(new e.k("rotate",t)),this._pitching&&this.fire(new e.k("pitch",t));}_afterEase(t,i){if(this._easeId&&i&&this._easeId===i)return;delete this._easeId;const a=this._zooming,s=this._rotating,o=this._pitching;this._moving=!1,this._zooming=!1,this._rotating=!1,this._pitching=!1,this._padding=!1,a&&this.fire(new e.k("zoomend",t)),s&&this.fire(new e.k("rotateend",t)),o&&this.fire(new e.k("pitchend",t)),this.fire(new e.k("moveend",t));}flyTo(t,i){var a;if(!t.essential&&o.prefersReducedMotion){const a=e.M(t,["center","zoom","bearing","pitch","around"]);return this.jumpTo(a,i)}this.stop(),t=e.e({offset:[0,0],speed:1.2,curve:1.42,easing:e.b8},t);const s=this._getTransformForUpdate(),r=s.zoom,n=s.bearing,l=s.pitch,h=s.padding,c="bearing"in t?this._normalizeBearing(t.bearing,n):n,u="pitch"in t?+t.pitch:l,d="padding"in t?t.padding:s.padding,_=e.P.convert(t.offset);let p=s.centerPoint.add(_);const m=s.pointLocation(p),{center:f,zoom:g}=s.getConstrained(e.N.convert(t.center||m),null!==(a=t.zoom)&&void 0!==a?a:r);this._normalizeCenter(f,s);const v=s.zoomScale(g-r),x=s.project(m),y=s.project(f).sub(x);let b=t.curve;const w=Math.max(s.width,s.height),T=w/v,I=y.mag();if("minZoom"in t){const i=e.ac(Math.min(t.minZoom,r,g),s.minZoom,s.maxZoom),a=w/s.zoomScale(i-r);b=Math.sqrt(a/I*2);}const E=b*b;function P(t){const e=(T*T-w*w+(t?-1:1)*E*E*I*I)/(2*(t?T:w)*E*I);return Math.log(Math.sqrt(e*e+1)-e)}function C(t){return (Math.exp(t)-Math.exp(-t))/2}function S(t){return (Math.exp(t)+Math.exp(-t))/2}const z=P(!1);let D=function(t){return S(z)/S(z+b*t)},M=function(t){return w*((S(z)*(C(e=z+b*t)/S(e))-C(z))/E)/I;var e;},A=(P(!0)-z)/b;if(Math.abs(I)<1e-6||!isFinite(A)){if(Math.abs(w-T)<1e-6)return this.easeTo(t,i);const e=T<w?-1:1;A=Math.abs(Math.log(T/w))/b,M=()=>0,D=t=>Math.exp(e*b*t);}return t.duration="duration"in t?+t.duration:1e3*A/("screenSpeed"in t?+t.screenSpeed/b:+t.speed),t.maxDuration&&t.duration>t.maxDuration&&(t.duration=0),this._zooming=!0,this._rotating=n!==c,this._pitching=u!==l,this._padding=!s.isPaddingEqual(d),this._prepareEase(i,!1),this.terrain&&this._prepareElevation(f),this._ease((a=>{const o=a*A,m=1/D(o);s.zoom=1===a?g:r+s.scaleZoom(m),this._rotating&&(s.bearing=e.y.number(n,c,a)),this._pitching&&(s.pitch=e.y.number(l,u,a)),this._padding&&(s.interpolatePadding(h,d,a),p=s.centerPoint.add(_)),this.terrain&&!t.freezeElevation&&this._updateElevation(a);const v=1===a?f:s.unproject(x.add(y.mult(M(o))).mult(m));s.setLocationAtPoint(s.renderWorldCopies?v.wrap():v,p),this._applyUpdatedTransform(s),this._fireMoveEvents(i);}),(()=>{this.terrain&&t.freezeElevation&&this._finalizeElevation(),this._afterEase(i);}),t),this}isEasing(){return !!this._easeFrameId}stop(){return this._stop()}_stop(t,e){var i;if(this._easeFrameId&&(this._cancelRenderFrame(this._easeFrameId),delete this._easeFrameId,delete this._onEaseFrame),this._onEaseEnd){const t=this._onEaseEnd;delete this._onEaseEnd,t.call(this,e);}return t||null===(i=this.handlers)||void 0===i||i.stop(!1),this}_ease(t,e,i){!1===i.animate||0===i.duration?(t(1),e()):(this._easeStart=o.now(),this._easeOptions=i,this._onEaseFrame=t,this._onEaseEnd=e,this._easeFrameId=this._requestRenderFrame(this._renderFrameCallback));}_normalizeBearing(t,i){t=e.b2(t,-180,180);const a=Math.abs(t-i);return Math.abs(t-360-i)<a&&(t-=360),Math.abs(t+360-i)<a&&(t+=360),t}_normalizeCenter(t,e){if(!e.renderWorldCopies||e.lngRange)return;const i=t.lng-e.center.lng;t.lng+=i>180?-360:i<-180?360:0;}queryTerrainElevation(t){return this.terrain?this.terrain.getElevationForLngLatZoom(e.N.convert(t),this.transform.tileZoom)-this.transform.elevation:null}}const vs={compact:!0,customAttribution:'<a href="https://maplibre.org/" target="_blank">MapLibre</a>'};class xs{constructor(t=vs){this._toggleAttribution=()=>{this._container.classList.contains("maplibregl-compact")&&(this._container.classList.contains("maplibregl-compact-show")?(this._container.setAttribute("open",""),this._container.classList.remove("maplibregl-compact-show")):(this._container.classList.add("maplibregl-compact-show"),this._container.removeAttribute("open")));},this._updateData=t=>{!t||"metadata"!==t.sourceDataType&&"visibility"!==t.sourceDataType&&"style"!==t.dataType&&"terrain"!==t.type||this._updateAttributions();},this._updateCompact=()=>{this._map.getCanvasContainer().offsetWidth<=640||this._compact?!1===this._compact?this._container.setAttribute("open",""):this._container.classList.contains("maplibregl-compact")||this._container.classList.contains("maplibregl-attrib-empty")||(this._container.setAttribute("open",""),this._container.classList.add("maplibregl-compact","maplibregl-compact-show")):(this._container.setAttribute("open",""),this._container.classList.contains("maplibregl-compact")&&this._container.classList.remove("maplibregl-compact","maplibregl-compact-show"));},this._updateCompactMinimize=()=>{this._container.classList.contains("maplibregl-compact")&&this._container.classList.contains("maplibregl-compact-show")&&this._container.classList.remove("maplibregl-compact-show");},this.options=t;}getDefaultPosition(){return "bottom-right"}onAdd(t){return this._map=t,this._compact=this.options.compact,this._container=r.create("details","maplibregl-ctrl maplibregl-ctrl-attrib"),this._compactButton=r.create("summary","maplibregl-ctrl-attrib-button",this._container),this._compactButton.addEventListener("click",this._toggleAttribution),this._setElementTitle(this._compactButton,"ToggleAttribution"),this._innerContainer=r.create("div","maplibregl-ctrl-attrib-inner",this._container),this._updateAttributions(),this._updateCompact(),this._map.on("styledata",this._updateData),this._map.on("sourcedata",this._updateData),this._map.on("terrain",this._updateData),this._map.on("resize",this._updateCompact),this._map.on("drag",this._updateCompactMinimize),this._container}onRemove(){r.remove(this._container),this._map.off("styledata",this._updateData),this._map.off("sourcedata",this._updateData),this._map.off("terrain",this._updateData),this._map.off("resize",this._updateCompact),this._map.off("drag",this._updateCompactMinimize),this._map=void 0,this._compact=void 0,this._attribHTML=void 0;}_setElementTitle(t,e){const i=this._map._getUIString(`AttributionControl.${e}`);t.title=i,t.setAttribute("aria-label",i);}_updateAttributions(){if(!this._map.style)return;let t=[];if(this.options.customAttribution&&(Array.isArray(this.options.customAttribution)?t=t.concat(this.options.customAttribution.map((t=>"string"!=typeof t?"":t))):"string"==typeof this.options.customAttribution&&t.push(this.options.customAttribution)),this._map.style.stylesheet){const t=this._map.style.stylesheet;this.styleOwner=t.owner,this.styleId=t.id;}const e=this._map.style.sourceCaches;for(const i in e){const a=e[i];if(a.used||a.usedForTerrain){const e=a.getSource();e.attribution&&t.indexOf(e.attribution)<0&&t.push(e.attribution);}}t=t.filter((t=>String(t).trim())),t.sort(((t,e)=>t.length-e.length)),t=t.filter(((e,i)=>{for(let a=i+1;a<t.length;a++)if(t[a].indexOf(e)>=0)return !1;return !0}));const i=t.join(" | ");i!==this._attribHTML&&(this._attribHTML=i,t.length?(this._innerContainer.innerHTML=i,this._container.classList.remove("maplibregl-attrib-empty")):this._container.classList.add("maplibregl-attrib-empty"),this._updateCompact(),this._editLink=null);}}class ys{constructor(t={}){this._updateCompact=()=>{const t=this._container.children;if(t.length){const e=t[0];this._map.getCanvasContainer().offsetWidth<=640||this._compact?!1!==this._compact&&e.classList.add("maplibregl-compact"):e.classList.remove("maplibregl-compact");}},this.options=t;}getDefaultPosition(){return "bottom-left"}onAdd(t){this._map=t,this._compact=this.options&&this.options.compact,this._container=r.create("div","maplibregl-ctrl");const e=r.create("a","maplibregl-ctrl-logo");return e.target="_blank",e.rel="noopener nofollow",e.href="https://maplibre.org/",e.setAttribute("aria-label",this._map._getUIString("LogoControl.Title")),e.setAttribute("rel","noopener nofollow"),this._container.appendChild(e),this._container.style.display="block",this._map.on("resize",this._updateCompact),this._updateCompact(),this._container}onRemove(){r.remove(this._container),this._map.off("resize",this._updateCompact),this._map=void 0,this._compact=void 0;}}class bs{constructor(){this._queue=[],this._id=0,this._cleared=!1,this._currentlyRunning=!1;}add(t){const e=++this._id;return this._queue.push({callback:t,id:e,cancelled:!1}),e}remove(t){const e=this._currentlyRunning,i=e?this._queue.concat(e):this._queue;for(const e of i)if(e.id===t)return void(e.cancelled=!0)}run(t=0){if(this._currentlyRunning)throw new Error("Attempting to run(), but is already running.");const e=this._currentlyRunning=this._queue;this._queue=[];for(const i of e)if(!i.cancelled&&(i.callback(t),this._cleared))break;this._cleared=!1,this._currentlyRunning=!1;}clear(){this._currentlyRunning&&(this._cleared=!0),this._queue=[];}}var ws=e.Y([{name:"a_pos3d",type:"Int16",components:3}]);class Ts extends e.E{constructor(t){super(),this.sourceCache=t,this._tiles={},this._renderableTilesKeys=[],this._sourceTileCache={},this.minzoom=0,this.maxzoom=22,this.tileSize=512,this.deltaZoom=1,t.usedForTerrain=!0,t.tileSize=this.tileSize*2**this.deltaZoom;}destruct(){this.sourceCache.usedForTerrain=!1,this.sourceCache.tileSize=null;}update(t,i){this.sourceCache.update(t,i),this._renderableTilesKeys=[];const a={};for(const s of t.coveringTiles({tileSize:this.tileSize,minzoom:this.minzoom,maxzoom:this.maxzoom,reparseOverscaled:!1,terrain:i}))a[s.key]=!0,this._renderableTilesKeys.push(s.key),this._tiles[s.key]||(s.posMatrix=new Float64Array(16),e.aP(s.posMatrix,0,e.X,0,e.X,0,1),this._tiles[s.key]=new lt(s,this.tileSize));for(const t in this._tiles)a[t]||delete this._tiles[t];}freeRtt(t){for(const e in this._tiles){const i=this._tiles[e];(!t||i.tileID.equals(t)||i.tileID.isChildOf(t)||t.isChildOf(i.tileID))&&(i.rtt=[]);}}getRenderableTiles(){return this._renderableTilesKeys.map((t=>this.getTileByID(t)))}getTileByID(t){return this._tiles[t]}getTerrainCoords(t){const i={};for(const a of this._renderableTilesKeys){const s=this._tiles[a].tileID;if(s.canonical.equals(t.canonical)){const s=t.clone();s.posMatrix=new Float64Array(16),e.aP(s.posMatrix,0,e.X,0,e.X,0,1),i[a]=s;}else if(s.canonical.isChildOf(t.canonical)){const o=t.clone();o.posMatrix=new Float64Array(16);const r=s.canonical.z-t.canonical.z,n=s.canonical.x-(s.canonical.x>>r<<r),l=s.canonical.y-(s.canonical.y>>r<<r),h=e.X>>r;e.aP(o.posMatrix,0,h,0,h,0,1),e.J(o.posMatrix,o.posMatrix,[-n*h,-l*h,0]),i[a]=o;}else if(t.canonical.isChildOf(s.canonical)){const o=t.clone();o.posMatrix=new Float64Array(16);const r=t.canonical.z-s.canonical.z,n=t.canonical.x-(t.canonical.x>>r<<r),l=t.canonical.y-(t.canonical.y>>r<<r),h=e.X>>r;e.aP(o.posMatrix,0,e.X,0,e.X,0,1),e.J(o.posMatrix,o.posMatrix,[n*h,l*h,0]),e.K(o.posMatrix,o.posMatrix,[1/2**r,1/2**r,0]),i[a]=o;}}return i}getSourceTile(t,e){const i=this.sourceCache._source;let a=t.overscaledZ-this.deltaZoom;if(a>i.maxzoom&&(a=i.maxzoom),a<i.minzoom)return null;this._sourceTileCache[t.key]||(this._sourceTileCache[t.key]=t.scaledTo(a).key);let s=this.sourceCache.getTileByID(this._sourceTileCache[t.key]);if((!s||!s.dem)&&e)for(;a>=i.minzoom&&(!s||!s.dem);)s=this.sourceCache.getTileByID(t.scaledTo(a--).key);return s}tilesAfterTime(t=Date.now()){return Object.values(this._tiles).filter((e=>e.timeAdded>=t))}}class Is{constructor(t,e,i){this.painter=t,this.sourceCache=new Ts(e),this.options=i,this.exaggeration="number"==typeof i.exaggeration?i.exaggeration:1,this.qualityFactor=2,this.meshSize=128,this._demMatrixCache={},this.coordsIndex=[],this._coordsTextureSize=1024;}getDEMElevation(t,i,a,s=e.X){var o;if(!(i>=0&&i<s&&a>=0&&a<s))return 0;const r=this.getTerrainData(t),n=null===(o=r.tile)||void 0===o?void 0:o.dem;if(!n)return 0;const l=function(t,e,i){var a=e[0],s=e[1];return t[0]=i[0]*a+i[4]*s+i[12],t[1]=i[1]*a+i[5]*s+i[13],t}([],[i/s*e.X,a/s*e.X],r.u_terrain_matrix),h=[l[0]*n.dim,l[1]*n.dim],c=Math.floor(h[0]),u=Math.floor(h[1]),d=h[0]-c,_=h[1]-u;return n.get(c,u)*(1-d)*(1-_)+n.get(c+1,u)*d*(1-_)+n.get(c,u+1)*(1-d)*_+n.get(c+1,u+1)*d*_}getElevationForLngLatZoom(t,i){if(!e.ba(i,t.wrap()))return 0;const{tileID:a,mercatorX:s,mercatorY:o}=this._getOverscaledTileIDFromLngLatZoom(t,i);return this.getElevation(a,s%e.X,o%e.X,e.X)}getElevation(t,i,a,s=e.X){return this.getDEMElevation(t,i,a,s)*this.exaggeration}getTerrainData(t){if(!this._emptyDemTexture){const t=this.painter.context,i=new e.R({width:1,height:1},new Uint8Array(4));this._emptyDepthTexture=new b(t,i,t.gl.RGBA,{premultiply:!1}),this._emptyDemUnpack=[0,0,0,0],this._emptyDemTexture=new b(t,new e.R({width:1,height:1}),t.gl.RGBA,{premultiply:!1}),this._emptyDemTexture.bind(t.gl.NEAREST,t.gl.CLAMP_TO_EDGE),this._emptyDemMatrix=e.an([]);}const i=this.sourceCache.getSourceTile(t,!0);if(i&&i.dem&&(!i.demTexture||i.needsTerrainPrepare)){const t=this.painter.context;i.demTexture=this.painter.getTileTexture(i.dem.stride),i.demTexture?i.demTexture.update(i.dem.getPixels(),{premultiply:!1}):i.demTexture=new b(t,i.dem.getPixels(),t.gl.RGBA,{premultiply:!1}),i.demTexture.bind(t.gl.NEAREST,t.gl.CLAMP_TO_EDGE),i.needsTerrainPrepare=!1;}const a=i&&i+i.tileID.key+t.key;if(a&&!this._demMatrixCache[a]){const a=this.sourceCache.sourceCache._source.maxzoom;let s=t.canonical.z-i.tileID.canonical.z;t.overscaledZ>t.canonical.z&&(t.canonical.z>=a?s=t.canonical.z-a:e.w("cannot calculate elevation if elevation maxzoom > source.maxzoom"));const o=t.canonical.x-(t.canonical.x>>s<<s),r=t.canonical.y-(t.canonical.y>>s<<s),n=e.bb(new Float64Array(16),[1/(e.X<<s),1/(e.X<<s),0]);e.J(n,n,[o*e.X,r*e.X,0]),this._demMatrixCache[t.key]={matrix:n,coord:t};}return {u_depth:2,u_terrain:3,u_terrain_dim:i&&i.dem&&i.dem.dim||1,u_terrain_matrix:a?this._demMatrixCache[t.key].matrix:this._emptyDemMatrix,u_terrain_unpack:i&&i.dem&&i.dem.getUnpackVector()||this._emptyDemUnpack,u_terrain_exaggeration:this.exaggeration,texture:(i&&i.demTexture||this._emptyDemTexture).texture,depthTexture:(this._fboDepthTexture||this._emptyDepthTexture).texture,tile:i}}getFramebuffer(t){const e=this.painter,i=e.width/devicePixelRatio,a=e.height/devicePixelRatio;return !this._fbo||this._fbo.width===i&&this._fbo.height===a||(this._fbo.destroy(),this._fboCoordsTexture.destroy(),this._fboDepthTexture.destroy(),delete this._fbo,delete this._fboDepthTexture,delete this._fboCoordsTexture),this._fboCoordsTexture||(this._fboCoordsTexture=new b(e.context,{width:i,height:a,data:null},e.context.gl.RGBA,{premultiply:!1}),this._fboCoordsTexture.bind(e.context.gl.NEAREST,e.context.gl.CLAMP_TO_EDGE)),this._fboDepthTexture||(this._fboDepthTexture=new b(e.context,{width:i,height:a,data:null},e.context.gl.RGBA,{premultiply:!1}),this._fboDepthTexture.bind(e.context.gl.NEAREST,e.context.gl.CLAMP_TO_EDGE)),this._fbo||(this._fbo=e.context.createFramebuffer(i,a,!0,!1),this._fbo.depthAttachment.set(e.context.createRenderbuffer(e.context.gl.DEPTH_COMPONENT16,i,a))),this._fbo.colorAttachment.set("coords"===t?this._fboCoordsTexture.texture:this._fboDepthTexture.texture),this._fbo}getCoordsTexture(){const t=this.painter.context;if(this._coordsTexture)return this._coordsTexture;const i=new Uint8Array(this._coordsTextureSize*this._coordsTextureSize*4);for(let t=0,e=0;t<this._coordsTextureSize;t++)for(let a=0;a<this._coordsTextureSize;a++,e+=4)i[e+0]=255&a,i[e+1]=255&t,i[e+2]=a>>8<<4|t>>8,i[e+3]=0;const a=new e.R({width:this._coordsTextureSize,height:this._coordsTextureSize},new Uint8Array(i.buffer)),s=new b(t,a,t.gl.RGBA,{premultiply:!1});return s.bind(t.gl.NEAREST,t.gl.CLAMP_TO_EDGE),this._coordsTexture=s,s}pointCoordinate(t){this.painter.maybeDrawDepthAndCoords(!0);const i=new Uint8Array(4),a=this.painter.context,s=a.gl,o=Math.round(t.x*this.painter.pixelRatio/devicePixelRatio),r=Math.round(t.y*this.painter.pixelRatio/devicePixelRatio),n=Math.round(this.painter.height/devicePixelRatio);a.bindFramebuffer.set(this.getFramebuffer("coords").framebuffer),s.readPixels(o,n-r-1,1,1,s.RGBA,s.UNSIGNED_BYTE,i),a.bindFramebuffer.set(null);const l=i[0]+(i[2]>>4<<8),h=i[1]+((15&i[2])<<8),c=this.coordsIndex[255-i[3]],u=c&&this.sourceCache.getTileByID(c);if(!u)return null;const d=this._coordsTextureSize,_=(1<<u.tileID.canonical.z)*d;return new e.Z((u.tileID.canonical.x*d+l)/_+u.tileID.wrap,(u.tileID.canonical.y*d+h)/_,this.getElevation(u.tileID,l,h,d))}depthAtPoint(t){const e=new Uint8Array(4),i=this.painter.context,a=i.gl;return i.bindFramebuffer.set(this.getFramebuffer("depth").framebuffer),a.readPixels(t.x,this.painter.height/devicePixelRatio-t.y-1,1,1,a.RGBA,a.UNSIGNED_BYTE,e),i.bindFramebuffer.set(null),(e[0]/16777216+e[1]/65536+e[2]/256+e[3])/256}getTerrainMesh(){if(this._mesh)return this._mesh;const t=this.painter.context,i=new e.bc,a=new e.aX,s=this.meshSize,o=e.X/s,r=s*s;for(let t=0;t<=s;t++)for(let e=0;e<=s;e++)i.emplaceBack(e*o,t*o,0);for(let t=0;t<r;t+=s+1)for(let e=0;e<s;e++)a.emplaceBack(e+t,s+e+t+1,s+e+t+2),a.emplaceBack(e+t,s+e+t+2,e+t+1);const n=i.length,l=n+2*(s+1);for(const t of [0,1])for(let a=0;a<=s;a++)for(const s of [0,1])i.emplaceBack(a*o,t*e.X,s);for(let t=0;t<2*s;t+=2)a.emplaceBack(l+t,l+t+1,l+t+3),a.emplaceBack(l+t,l+t+3,l+t+2),a.emplaceBack(n+t,n+t+3,n+t+1),a.emplaceBack(n+t,n+t+2,n+t+3);const h=i.length,c=h+2*(s+1);for(const t of [0,1])for(let a=0;a<=s;a++)for(const s of [0,1])i.emplaceBack(t*e.X,a*o,s);for(let t=0;t<2*s;t+=2)a.emplaceBack(h+t,h+t+1,h+t+3),a.emplaceBack(h+t,h+t+3,h+t+2),a.emplaceBack(c+t,c+t+3,c+t+1),a.emplaceBack(c+t,c+t+2,c+t+3);return this._mesh=new ua(t.createVertexBuffer(i,ws.members),t.createIndexBuffer(a),e.a0.simpleSegment(0,0,i.length,a.length)),this._mesh}getMeshFrameDelta(t){return 2*Math.PI*e.bd/Math.pow(2,t)/5}getMinTileElevationForLngLatZoom(t,e){var i;const{tileID:a}=this._getOverscaledTileIDFromLngLatZoom(t,e);return null!==(i=this.getMinMaxElevation(a).minElevation)&&void 0!==i?i:0}getMinMaxElevation(t){const e=this.getTerrainData(t).tile,i={minElevation:null,maxElevation:null};return e&&e.dem&&(i.minElevation=e.dem.min*this.exaggeration,i.maxElevation=e.dem.max*this.exaggeration),i}_getOverscaledTileIDFromLngLatZoom(t,i){const a=e.Z.fromLngLat(t.wrap()),s=(1<<i)*e.X,o=a.x*s,r=a.y*s,n=Math.floor(o/e.X),l=Math.floor(r/e.X);return {tileID:new e.S(i,0,i,n,l),mercatorX:o,mercatorY:r}}}class Es{constructor(t,e,i){this._context=t,this._size=e,this._tileSize=i,this._objects=[],this._recentlyUsed=[],this._stamp=0;}destruct(){for(const t of this._objects)t.texture.destroy(),t.fbo.destroy();}_createObject(t){const e=this._context.createFramebuffer(this._tileSize,this._tileSize,!0,!0),i=new b(this._context,{width:this._tileSize,height:this._tileSize,data:null},this._context.gl.RGBA);return i.bind(this._context.gl.LINEAR,this._context.gl.CLAMP_TO_EDGE),e.depthAttachment.set(this._context.createRenderbuffer(this._context.gl.DEPTH_STENCIL,this._tileSize,this._tileSize)),e.colorAttachment.set(i.texture),{id:t,fbo:e,texture:i,stamp:-1,inUse:!1}}getObjectForId(t){return this._objects[t]}useObject(t){t.inUse=!0,this._recentlyUsed=this._recentlyUsed.filter((e=>t.id!==e)),this._recentlyUsed.push(t.id);}stampObject(t){t.stamp=++this._stamp;}getOrCreateFreeObject(){for(const t of this._recentlyUsed)if(!this._objects[t].inUse)return this._objects[t];if(this._objects.length>=this._size)throw new Error("No free RenderPool available, call freeAllObjects() required!");const t=this._createObject(this._objects.length);return this._objects.push(t),t}freeObject(t){t.inUse=!1;}freeAllObjects(){for(const t of this._objects)this.freeObject(t);}isFull(){return !(this._objects.length<this._size)&&!1===this._objects.some((t=>!t.inUse))}}const Ps={background:!0,fill:!0,line:!0,raster:!0,hillshade:!0};class Cs{constructor(t,e){this.painter=t,this.terrain=e,this.pool=new Es(t.context,30,e.sourceCache.tileSize*e.qualityFactor);}destruct(){this.pool.destruct();}getTexture(t){return this.pool.getObjectForId(t.rtt[this._stacks.length-1].id).texture}prepareForRender(t,e){this._stacks=[],this._prevType=null,this._rttTiles=[],this._renderableTiles=this.terrain.sourceCache.getRenderableTiles(),this._renderableLayerIds=t._order.filter((i=>!t._layers[i].isHidden(e))),this._coordsDescendingInv={};for(const e in t.sourceCaches){this._coordsDescendingInv[e]={};const i=t.sourceCaches[e].getVisibleCoordinates();for(const t of i){const i=this.terrain.sourceCache.getTerrainCoords(t);for(const t in i)this._coordsDescendingInv[e][t]||(this._coordsDescendingInv[e][t]=[]),this._coordsDescendingInv[e][t].push(i[t]);}}this._coordsDescendingInvStr={};for(const e of t._order){const i=t._layers[e],a=i.source;if(Ps[i.type]&&!this._coordsDescendingInvStr[a]){this._coordsDescendingInvStr[a]={};for(const t in this._coordsDescendingInv[a])this._coordsDescendingInvStr[a][t]=this._coordsDescendingInv[a][t].map((t=>t.key)).sort().join();}}for(const t of this._renderableTiles)for(const e in this._coordsDescendingInvStr){const i=this._coordsDescendingInvStr[e][t.tileID.key];i&&i!==t.rttCoords[e]&&(t.rtt=[]);}}renderLayer(t){if(t.isHidden(this.painter.transform.zoom))return !1;const i=t.type,a=this.painter,s=this._renderableLayerIds[this._renderableLayerIds.length-1]===t.id;if(Ps[i]&&(this._prevType&&Ps[this._prevType]||this._stacks.push([]),this._prevType=i,this._stacks[this._stacks.length-1].push(t.id),!s))return !0;if(Ps[this._prevType]||Ps[i]&&s){this._prevType=i;const t=this._stacks.length-1,s=this._stacks[t]||[];for(const i of this._renderableTiles){if(this.pool.isFull()&&(ca(this.painter,this.terrain,this._rttTiles),this._rttTiles=[],this.pool.freeAllObjects()),this._rttTiles.push(i),i.rtt[t]){const e=this.pool.getObjectForId(i.rtt[t].id);if(e.stamp===i.rtt[t].stamp){this.pool.useObject(e);continue}}const o=this.pool.getOrCreateFreeObject();this.pool.useObject(o),this.pool.stampObject(o),i.rtt[t]={id:o.id,stamp:o.stamp},a.context.bindFramebuffer.set(o.fbo.framebuffer),a.context.clear({color:e.aM.transparent,stencil:0}),a.currentStencilSource=void 0;for(let t=0;t<s.length;t++){const e=a.style._layers[s[t]],r=e.source?this._coordsDescendingInv[e.source][i.tileID.key]:[i.tileID];a.context.viewport.set([0,0,o.fbo.width,o.fbo.height]),a._renderTileClippingMasks(e,r),a.renderLayer(a,a.style.sourceCaches[e.source],e,r),e.source&&(i.rttCoords[e.source]=this._coordsDescendingInvStr[e.source][i.tileID.key]);}}return ca(this.painter,this.terrain,this._rttTiles),this._rttTiles=[],this.pool.freeAllObjects(),Ps[i]}return !1}}const Ss={"AttributionControl.ToggleAttribution":"Toggle attribution","AttributionControl.MapFeedback":"Map feedback","FullscreenControl.Enter":"Enter fullscreen","FullscreenControl.Exit":"Exit fullscreen","GeolocateControl.FindMyLocation":"Find my location","GeolocateControl.LocationNotAvailable":"Location not available","LogoControl.Title":"MapLibre logo","Map.Title":"Map","Marker.Title":"Map marker","NavigationControl.ResetBearing":"Reset bearing to north","NavigationControl.ZoomIn":"Zoom in","NavigationControl.ZoomOut":"Zoom out","Popup.Close":"Close popup","ScaleControl.Feet":"ft","ScaleControl.Meters":"m","ScaleControl.Kilometers":"km","ScaleControl.Miles":"mi","ScaleControl.NauticalMiles":"nm","TerrainControl.Enable":"Enable terrain","TerrainControl.Disable":"Disable terrain","CooperativeGesturesHandler.WindowsHelpText":"Use Ctrl + scroll to zoom the map","CooperativeGesturesHandler.MacHelpText":"Use ⌘ + scroll to zoom the map","CooperativeGesturesHandler.MobileHelpText":"Use two fingers to move the map"},zs=i,Ds={hash:!1,interactive:!0,bearingSnap:7,attributionControl:vs,maplibreLogo:!1,failIfMajorPerformanceCaveat:!1,preserveDrawingBuffer:!1,refreshExpiredTiles:!0,scrollZoom:!0,minZoom:-2,maxZoom:22,minPitch:0,maxPitch:60,boxZoom:!0,dragRotate:!0,dragPan:!0,keyboard:!0,doubleClickZoom:!0,touchZoomRotate:!0,touchPitch:!0,cooperativeGestures:!1,trackResize:!0,center:[0,0],zoom:0,bearing:0,pitch:0,renderWorldCopies:!0,maxTileCacheSize:null,maxTileCacheZoomLevels:e.a.MAX_TILE_CACHE_ZOOM_LEVELS,transformRequest:null,transformCameraUpdate:null,fadeDuration:300,crossSourceCollisions:!0,clickTolerance:3,localIdeographFontFamily:"sans-serif",pitchWithRotate:!0,validateStyle:!0,maxCanvasSize:[4096,4096],cancelPendingTileRequestsWhileZooming:!0},Ms=t=>{t.touchstart=t.dragStart,t.touchmoveWindow=t.dragMove,t.touchend=t.dragEnd;},As={showCompass:!0,showZoom:!0,visualizePitch:!1};class Rs{constructor(t,i,a=!1){this.mousedown=t=>{this.startMouse(e.e({},t,{ctrlKey:!0,preventDefault:()=>t.preventDefault()}),r.mousePos(this.element,t)),r.addEventListener(window,"mousemove",this.mousemove),r.addEventListener(window,"mouseup",this.mouseup);},this.mousemove=t=>{this.moveMouse(t,r.mousePos(this.element,t));},this.mouseup=t=>{this.mouseRotate.dragEnd(t),this.mousePitch&&this.mousePitch.dragEnd(t),this.offTemp();},this.touchstart=t=>{1!==t.targetTouches.length?this.reset():(this._startPos=this._lastPos=r.touchPos(this.element,t.targetTouches)[0],this.startTouch(t,this._startPos),r.addEventListener(window,"touchmove",this.touchmove,{passive:!1}),r.addEventListener(window,"touchend",this.touchend));},this.touchmove=t=>{1!==t.targetTouches.length?this.reset():(this._lastPos=r.touchPos(this.element,t.targetTouches)[0],this.moveTouch(t,this._lastPos));},this.touchend=t=>{0===t.targetTouches.length&&this._startPos&&this._lastPos&&this._startPos.dist(this._lastPos)<this._clickTolerance&&this.element.click(),delete this._startPos,delete this._lastPos,this.offTemp();},this.reset=()=>{this.mouseRotate.reset(),this.mousePitch&&this.mousePitch.reset(),this.touchRotate.reset(),this.touchPitch&&this.touchPitch.reset(),delete this._startPos,delete this._lastPos,this.offTemp();},this._clickTolerance=10;const s=t.dragRotate._mouseRotate.getClickTolerance(),o=t.dragRotate._mousePitch.getClickTolerance();this.element=i,this.mouseRotate=Va({clickTolerance:s,enable:!0}),this.touchRotate=(({enable:t,clickTolerance:e,bearingDegreesPerPixelMoved:i=.8})=>{const a=new Za;return new Na({clickTolerance:e,move:(t,e)=>({bearingDelta:(e.x-t.x)*i}),moveStateManager:a,enable:t,assignEvents:Ms})})({clickTolerance:s,enable:!0}),this.map=t,a&&(this.mousePitch=Ga({clickTolerance:o,enable:!0}),this.touchPitch=(({enable:t,clickTolerance:e,pitchDegreesPerPixelMoved:i=-.5})=>{const a=new Za;return new Na({clickTolerance:e,move:(t,e)=>({pitchDelta:(e.y-t.y)*i}),moveStateManager:a,enable:t,assignEvents:Ms})})({clickTolerance:o,enable:!0})),r.addEventListener(i,"mousedown",this.mousedown),r.addEventListener(i,"touchstart",this.touchstart,{passive:!1}),r.addEventListener(i,"touchcancel",this.reset);}startMouse(t,e){this.mouseRotate.dragStart(t,e),this.mousePitch&&this.mousePitch.dragStart(t,e),r.disableDrag();}startTouch(t,e){this.touchRotate.dragStart(t,e),this.touchPitch&&this.touchPitch.dragStart(t,e),r.disableDrag();}moveMouse(t,e){const i=this.map,{bearingDelta:a}=this.mouseRotate.dragMove(t,e)||{};if(a&&i.setBearing(i.getBearing()+a),this.mousePitch){const{pitchDelta:a}=this.mousePitch.dragMove(t,e)||{};a&&i.setPitch(i.getPitch()+a);}}moveTouch(t,e){const i=this.map,{bearingDelta:a}=this.touchRotate.dragMove(t,e)||{};if(a&&i.setBearing(i.getBearing()+a),this.touchPitch){const{pitchDelta:a}=this.touchPitch.dragMove(t,e)||{};a&&i.setPitch(i.getPitch()+a);}}off(){const t=this.element;r.removeEventListener(t,"mousedown",this.mousedown),r.removeEventListener(t,"touchstart",this.touchstart,{passive:!1}),r.removeEventListener(window,"touchmove",this.touchmove,{passive:!1}),r.removeEventListener(window,"touchend",this.touchend),r.removeEventListener(t,"touchcancel",this.reset),this.offTemp();}offTemp(){r.enableDrag(),r.removeEventListener(window,"mousemove",this.mousemove),r.removeEventListener(window,"mouseup",this.mouseup),r.removeEventListener(window,"touchmove",this.touchmove,{passive:!1}),r.removeEventListener(window,"touchend",this.touchend);}}let ks;function Ls(t,i,a){const s=new e.N(t.lng,t.lat);if(t=new e.N(t.lng,t.lat),i){const s=new e.N(t.lng-360,t.lat),o=new e.N(t.lng+360,t.lat),r=a.locationPoint(t).distSqr(i);a.locationPoint(s).distSqr(i)<r?t=s:a.locationPoint(o).distSqr(i)<r&&(t=o);}for(;Math.abs(t.lng-a.center.lng)>180;){const e=a.locationPoint(t);if(e.x>=0&&e.y>=0&&e.x<=a.width&&e.y<=a.height)break;t.lng>a.center.lng?t.lng-=360:t.lng+=360;}return t.lng!==s.lng&&a.locationPoint(t).y>a.height/2-a.getHorizon()?t:s}const Fs={center:"translate(-50%,-50%)",top:"translate(-50%,0)","top-left":"translate(0,0)","top-right":"translate(-100%,0)",bottom:"translate(-50%,-100%)","bottom-left":"translate(0,-100%)","bottom-right":"translate(-100%,-100%)",left:"translate(0,-50%)",right:"translate(-100%,-50%)"};function Bs(t,e,i){const a=t.classList;for(const t in Fs)a.remove(`maplibregl-${i}-anchor-${t}`);a.add(`maplibregl-${i}-anchor-${e}`);}class Os extends e.E{constructor(t){if(super(),this._onKeyPress=t=>{const e=t.code,i=t.charCode||t.keyCode;"Space"!==e&&"Enter"!==e&&32!==i&&13!==i||this.togglePopup();},this._onMapClick=t=>{const e=t.originalEvent.target,i=this._element;this._popup&&(e===i||i.contains(e))&&this.togglePopup();},this._update=t=>{var e;if(!this._map)return;const i=this._map.loaded()&&!this._map.isMoving();("terrain"===(null==t?void 0:t.type)||"render"===(null==t?void 0:t.type)&&!i)&&this._map.once("render",this._update),this._lngLat=this._map.transform.renderWorldCopies?Ls(this._lngLat,this._flatPos,this._map.transform):null===(e=this._lngLat)||void 0===e?void 0:e.wrap(),this._flatPos=this._pos=this._map.project(this._lngLat)._add(this._offset),this._map.terrain&&(this._flatPos=this._map.transform.locationPoint(this._lngLat)._add(this._offset));let a="";"viewport"===this._rotationAlignment||"auto"===this._rotationAlignment?a=`rotateZ(${this._rotation}deg)`:"map"===this._rotationAlignment&&(a=`rotateZ(${this._rotation-this._map.getBearing()}deg)`);let s="";"viewport"===this._pitchAlignment||"auto"===this._pitchAlignment?s="rotateX(0deg)":"map"===this._pitchAlignment&&(s=`rotateX(${this._map.getPitch()}deg)`),this._subpixelPositioning||t&&"moveend"!==t.type||(this._pos=this._pos.round()),r.setTransform(this._element,`${Fs[this._anchor]} translate(${this._pos.x}px, ${this._pos.y}px) ${s} ${a}`),o.frameAsync(new AbortController).then((()=>{this._updateOpacity(t&&"moveend"===t.type);})).catch((()=>{}));},this._onMove=t=>{if(!this._isDragging){const e=this._clickTolerance||this._map._clickTolerance;this._isDragging=t.point.dist(this._pointerdownPos)>=e;}this._isDragging&&(this._pos=t.point.sub(this._positionDelta),this._lngLat=this._map.unproject(this._pos),this.setLngLat(this._lngLat),this._element.style.pointerEvents="none","pending"===this._state&&(this._state="active",this.fire(new e.k("dragstart"))),this.fire(new e.k("drag")));},this._onUp=()=>{this._element.style.pointerEvents="auto",this._positionDelta=null,this._pointerdownPos=null,this._isDragging=!1,this._map.off("mousemove",this._onMove),this._map.off("touchmove",this._onMove),"active"===this._state&&this.fire(new e.k("dragend")),this._state="inactive";},this._addDragHandler=t=>{this._element.contains(t.originalEvent.target)&&(t.preventDefault(),this._positionDelta=t.point.sub(this._pos).add(this._offset),this._pointerdownPos=t.point,this._state="pending",this._map.on("mousemove",this._onMove),this._map.on("touchmove",this._onMove),this._map.once("mouseup",this._onUp),this._map.once("touchend",this._onUp));},this._anchor=t&&t.anchor||"center",this._color=t&&t.color||"#3FB1CE",this._scale=t&&t.scale||1,this._draggable=t&&t.draggable||!1,this._clickTolerance=t&&t.clickTolerance||0,this._subpixelPositioning=t&&t.subpixelPositioning||!1,this._isDragging=!1,this._state="inactive",this._rotation=t&&t.rotation||0,this._rotationAlignment=t&&t.rotationAlignment||"auto",this._pitchAlignment=t&&t.pitchAlignment&&"auto"!==t.pitchAlignment?t.pitchAlignment:this._rotationAlignment,this.setOpacity(),this.setOpacity(null==t?void 0:t.opacity,null==t?void 0:t.opacityWhenCovered),t&&t.element)this._element=t.element,this._offset=e.P.convert(t&&t.offset||[0,0]);else {this._defaultMarker=!0,this._element=r.create("div");const i=r.createNS("http://www.w3.org/2000/svg","svg"),a=41,s=27;i.setAttributeNS(null,"display","block"),i.setAttributeNS(null,"height",`${a}px`),i.setAttributeNS(null,"width",`${s}px`),i.setAttributeNS(null,"viewBox",`0 0 ${s} ${a}`);const o=r.createNS("http://www.w3.org/2000/svg","g");o.setAttributeNS(null,"stroke","none"),o.setAttributeNS(null,"stroke-width","1"),o.setAttributeNS(null,"fill","none"),o.setAttributeNS(null,"fill-rule","evenodd");const n=r.createNS("http://www.w3.org/2000/svg","g");n.setAttributeNS(null,"fill-rule","nonzero");const l=r.createNS("http://www.w3.org/2000/svg","g");l.setAttributeNS(null,"transform","translate(3.0, 29.0)"),l.setAttributeNS(null,"fill","#000000");const h=[{rx:"10.5",ry:"5.25002273"},{rx:"10.5",ry:"5.25002273"},{rx:"9.5",ry:"4.77275007"},{rx:"8.5",ry:"4.29549936"},{rx:"7.5",ry:"3.81822308"},{rx:"6.5",ry:"3.34094679"},{rx:"5.5",ry:"2.86367051"},{rx:"4.5",ry:"2.38636864"}];for(const t of h){const e=r.createNS("http://www.w3.org/2000/svg","ellipse");e.setAttributeNS(null,"opacity","0.04"),e.setAttributeNS(null,"cx","10.5"),e.setAttributeNS(null,"cy","5.80029008"),e.setAttributeNS(null,"rx",t.rx),e.setAttributeNS(null,"ry",t.ry),l.appendChild(e);}const c=r.createNS("http://www.w3.org/2000/svg","g");c.setAttributeNS(null,"fill",this._color);const u=r.createNS("http://www.w3.org/2000/svg","path");u.setAttributeNS(null,"d","M27,13.5 C27,19.074644 20.250001,27.000002 14.75,34.500002 C14.016665,35.500004 12.983335,35.500004 12.25,34.500002 C6.7499993,27.000002 0,19.222562 0,13.5 C0,6.0441559 6.0441559,0 13.5,0 C20.955844,0 27,6.0441559 27,13.5 Z"),c.appendChild(u);const d=r.createNS("http://www.w3.org/2000/svg","g");d.setAttributeNS(null,"opacity","0.25"),d.setAttributeNS(null,"fill","#000000");const _=r.createNS("http://www.w3.org/2000/svg","path");_.setAttributeNS(null,"d","M13.5,0 C6.0441559,0 0,6.0441559 0,13.5 C0,19.222562 6.7499993,27 12.25,34.5 C13,35.522727 14.016664,35.500004 14.75,34.5 C20.250001,27 27,19.074644 27,13.5 C27,6.0441559 20.955844,0 13.5,0 Z M13.5,1 C20.415404,1 26,6.584596 26,13.5 C26,15.898657 24.495584,19.181431 22.220703,22.738281 C19.945823,26.295132 16.705119,30.142167 13.943359,33.908203 C13.743445,34.180814 13.612715,34.322738 13.5,34.441406 C13.387285,34.322738 13.256555,34.180814 13.056641,33.908203 C10.284481,30.127985 7.4148684,26.314159 5.015625,22.773438 C2.6163816,19.232715 1,15.953538 1,13.5 C1,6.584596 6.584596,1 13.5,1 Z"),d.appendChild(_);const p=r.createNS("http://www.w3.org/2000/svg","g");p.setAttributeNS(null,"transform","translate(6.0, 7.0)"),p.setAttributeNS(null,"fill","#FFFFFF");const m=r.createNS("http://www.w3.org/2000/svg","g");m.setAttributeNS(null,"transform","translate(8.0, 8.0)");const f=r.createNS("http://www.w3.org/2000/svg","circle");f.setAttributeNS(null,"fill","#000000"),f.setAttributeNS(null,"opacity","0.25"),f.setAttributeNS(null,"cx","5.5"),f.setAttributeNS(null,"cy","5.5"),f.setAttributeNS(null,"r","5.4999962");const g=r.createNS("http://www.w3.org/2000/svg","circle");g.setAttributeNS(null,"fill","#FFFFFF"),g.setAttributeNS(null,"cx","5.5"),g.setAttributeNS(null,"cy","5.5"),g.setAttributeNS(null,"r","5.4999962"),m.appendChild(f),m.appendChild(g),n.appendChild(l),n.appendChild(c),n.appendChild(d),n.appendChild(p),n.appendChild(m),i.appendChild(n),i.setAttributeNS(null,"height",a*this._scale+"px"),i.setAttributeNS(null,"width",s*this._scale+"px"),this._element.appendChild(i),this._offset=e.P.convert(t&&t.offset||[0,-14]);}if(this._element.classList.add("maplibregl-marker"),this._element.addEventListener("dragstart",(t=>{t.preventDefault();})),this._element.addEventListener("mousedown",(t=>{t.preventDefault();})),Bs(this._element,this._anchor,"marker"),t&&t.className)for(const e of t.className.split(" "))this._element.classList.add(e);this._popup=null;}addTo(t){return this.remove(),this._map=t,this._element.setAttribute("aria-label",t._getUIString("Marker.Title")),t.getCanvasContainer().appendChild(this._element),t.on("move",this._update),t.on("moveend",this._update),t.on("terrain",this._update),this.setDraggable(this._draggable),this._update(),this._map.on("click",this._onMapClick),this}remove(){return this._opacityTimeout&&(clearTimeout(this._opacityTimeout),delete this._opacityTimeout),this._map&&(this._map.off("click",this._onMapClick),this._map.off("move",this._update),this._map.off("moveend",this._update),this._map.off("terrain",this._update),this._map.off("mousedown",this._addDragHandler),this._map.off("touchstart",this._addDragHandler),this._map.off("mouseup",this._onUp),this._map.off("touchend",this._onUp),this._map.off("mousemove",this._onMove),this._map.off("touchmove",this._onMove),delete this._map),r.remove(this._element),this._popup&&this._popup.remove(),this}getLngLat(){return this._lngLat}setLngLat(t){return this._lngLat=e.N.convert(t),this._pos=null,this._popup&&this._popup.setLngLat(this._lngLat),this._update(),this}getElement(){return this._element}setPopup(t){if(this._popup&&(this._popup.remove(),this._popup=null,this._element.removeEventListener("keypress",this._onKeyPress),this._originalTabIndex||this._element.removeAttribute("tabindex")),t){if(!("offset"in t.options)){const e=38.1,i=13.5,a=Math.abs(i)/Math.SQRT2;t.options.offset=this._defaultMarker?{top:[0,0],"top-left":[0,0],"top-right":[0,0],bottom:[0,-e],"bottom-left":[a,-1*(e-i+a)],"bottom-right":[-a,-1*(e-i+a)],left:[i,-1*(e-i)],right:[-i,-1*(e-i)]}:this._offset;}this._popup=t,this._originalTabIndex=this._element.getAttribute("tabindex"),this._originalTabIndex||this._element.setAttribute("tabindex","0"),this._element.addEventListener("keypress",this._onKeyPress);}return this}setSubpixelPositioning(t){return this._subpixelPositioning=t,this}getPopup(){return this._popup}togglePopup(){const t=this._popup;return this._element.style.opacity===this._opacityWhenCovered?this:t?(t.isOpen()?t.remove():(t.setLngLat(this._lngLat),t.addTo(this._map)),this):this}_updateOpacity(t=!1){var i,a;if(!(null===(i=this._map)||void 0===i?void 0:i.terrain))return void(this._element.style.opacity!==this._opacity&&(this._element.style.opacity=this._opacity));if(t)this._opacityTimeout=null;else {if(this._opacityTimeout)return;this._opacityTimeout=setTimeout((()=>{this._opacityTimeout=null;}),100);}const s=this._map,o=s.terrain.depthAtPoint(this._pos),r=s.terrain.getElevationForLngLatZoom(this._lngLat,s.transform.tileZoom);if(s.transform.lngLatToCameraDepth(this._lngLat,r)-o<.006)return void(this._element.style.opacity=this._opacity);const n=-this._offset.y/s.transform._pixelPerMeter,l=Math.sin(s.getPitch()*Math.PI/180)*n,h=s.terrain.depthAtPoint(new e.P(this._pos.x,this._pos.y-this._offset.y)),c=s.transform.lngLatToCameraDepth(this._lngLat,r+l)-h>.006;(null===(a=this._popup)||void 0===a?void 0:a.isOpen())&&c&&this._popup.remove(),this._element.style.opacity=c?this._opacityWhenCovered:this._opacity;}getOffset(){return this._offset}setOffset(t){return this._offset=e.P.convert(t),this._update(),this}addClassName(t){this._element.classList.add(t);}removeClassName(t){this._element.classList.remove(t);}toggleClassName(t){return this._element.classList.toggle(t)}setDraggable(t){return this._draggable=!!t,this._map&&(t?(this._map.on("mousedown",this._addDragHandler),this._map.on("touchstart",this._addDragHandler)):(this._map.off("mousedown",this._addDragHandler),this._map.off("touchstart",this._addDragHandler))),this}isDraggable(){return this._draggable}setRotation(t){return this._rotation=t||0,this._update(),this}getRotation(){return this._rotation}setRotationAlignment(t){return this._rotationAlignment=t||"auto",this._update(),this}getRotationAlignment(){return this._rotationAlignment}setPitchAlignment(t){return this._pitchAlignment=t&&"auto"!==t?t:this._rotationAlignment,this._update(),this}getPitchAlignment(){return this._pitchAlignment}setOpacity(t,e){return void 0===t&&void 0===e&&(this._opacity="1",this._opacityWhenCovered="0.2"),void 0!==t&&(this._opacity=t),void 0!==e&&(this._opacityWhenCovered=e),this._map&&this._updateOpacity(!0),this}}const Ns={positionOptions:{enableHighAccuracy:!1,maximumAge:0,timeout:6e3},fitBoundsOptions:{maxZoom:15},trackUserLocation:!1,showAccuracyCircle:!0,showUserLocation:!0};let js=0,Us=!1;const Zs={maxWidth:100,unit:"metric"};function qs(t,e,i){const a=i&&i.maxWidth||100,s=t._container.clientHeight/2,o=t.unproject([0,s]),r=t.unproject([a,s]),n=o.distanceTo(r);if(i&&"imperial"===i.unit){const i=3.2808*n;i>5280?Vs(e,a,i/5280,t._getUIString("ScaleControl.Miles")):Vs(e,a,i,t._getUIString("ScaleControl.Feet"));}else i&&"nautical"===i.unit?Vs(e,a,n/1852,t._getUIString("ScaleControl.NauticalMiles")):n>=1e3?Vs(e,a,n/1e3,t._getUIString("ScaleControl.Kilometers")):Vs(e,a,n,t._getUIString("ScaleControl.Meters"));}function Vs(t,e,i,a){const s=function(t){const e=Math.pow(10,`${Math.floor(t)}`.length-1);let i=t/e;return i=i>=10?10:i>=5?5:i>=3?3:i>=2?2:i>=1?1:function(t){const e=Math.pow(10,Math.ceil(-Math.log(t)/Math.LN10));return Math.round(t*e)/e}(i),e*i}(i);t.style.width=e*(s/i)+"px",t.innerHTML=`${s}&nbsp;${a}`;}const Gs={closeButton:!0,closeOnClick:!0,focusAfterOpen:!0,className:"",maxWidth:"240px",subpixelPositioning:!1},Hs=["a[href]","[tabindex]:not([tabindex='-1'])","[contenteditable]:not([contenteditable='false'])","button:not([disabled])","input:not([disabled])","select:not([disabled])","textarea:not([disabled])"].join(", ");function Ws(t){if(t){if("number"==typeof t){const i=Math.round(Math.abs(t)/Math.SQRT2);return {center:new e.P(0,0),top:new e.P(0,t),"top-left":new e.P(i,i),"top-right":new e.P(-i,i),bottom:new e.P(0,-t),"bottom-left":new e.P(i,-i),"bottom-right":new e.P(-i,-i),left:new e.P(t,0),right:new e.P(-t,0)}}if(t instanceof e.P||Array.isArray(t)){const i=e.P.convert(t);return {center:i,top:i,"top-left":i,"top-right":i,bottom:i,"bottom-left":i,"bottom-right":i,left:i,right:i}}return {center:e.P.convert(t.center||[0,0]),top:e.P.convert(t.top||[0,0]),"top-left":e.P.convert(t["top-left"]||[0,0]),"top-right":e.P.convert(t["top-right"]||[0,0]),bottom:e.P.convert(t.bottom||[0,0]),"bottom-left":e.P.convert(t["bottom-left"]||[0,0]),"bottom-right":e.P.convert(t["bottom-right"]||[0,0]),left:e.P.convert(t.left||[0,0]),right:e.P.convert(t.right||[0,0])}}return Ws(new e.P(0,0))}const $s=i;t.AJAXError=e.bg,t.Evented=e.E,t.LngLat=e.N,t.MercatorCoordinate=e.Z,t.Point=e.P,t.addProtocol=e.bh,t.config=e.a,t.removeProtocol=e.bi,t.AttributionControl=xs,t.BoxZoomHandler=ka,t.CanvasSource=et,t.CooperativeGesturesHandler=ds,t.DoubleClickZoomHandler=rs,t.DragPanHandler=hs,t.DragRotateHandler=cs,t.EdgeInsets=ma,t.FullscreenControl=class extends e.E{constructor(t={}){super(),this._onFullscreenChange=()=>{var t;let e=window.document.fullscreenElement||window.document.mozFullScreenElement||window.document.webkitFullscreenElement||window.document.msFullscreenElement;for(;null===(t=null==e?void 0:e.shadowRoot)||void 0===t?void 0:t.fullscreenElement;)e=e.shadowRoot.fullscreenElement;e===this._container!==this._fullscreen&&this._handleFullscreenChange();},this._onClickFullscreen=()=>{this._isFullscreen()?this._exitFullscreen():this._requestFullscreen();},this._fullscreen=!1,t&&t.container&&(t.container instanceof HTMLElement?this._container=t.container:e.w("Full screen control 'container' must be a DOM element.")),"onfullscreenchange"in document?this._fullscreenchange="fullscreenchange":"onmozfullscreenchange"in document?this._fullscreenchange="mozfullscreenchange":"onwebkitfullscreenchange"in document?this._fullscreenchange="webkitfullscreenchange":"onmsfullscreenchange"in document&&(this._fullscreenchange="MSFullscreenChange");}onAdd(t){return this._map=t,this._container||(this._container=this._map.getContainer()),this._controlContainer=r.create("div","maplibregl-ctrl maplibregl-ctrl-group"),this._setupUI(),this._controlContainer}onRemove(){r.remove(this._controlContainer),this._map=null,window.document.removeEventListener(this._fullscreenchange,this._onFullscreenChange);}_setupUI(){const t=this._fullscreenButton=r.create("button","maplibregl-ctrl-fullscreen",this._controlContainer);r.create("span","maplibregl-ctrl-icon",t).setAttribute("aria-hidden","true"),t.type="button",this._updateTitle(),this._fullscreenButton.addEventListener("click",this._onClickFullscreen),window.document.addEventListener(this._fullscreenchange,this._onFullscreenChange);}_updateTitle(){const t=this._getTitle();this._fullscreenButton.setAttribute("aria-label",t),this._fullscreenButton.title=t;}_getTitle(){return this._map._getUIString(this._isFullscreen()?"FullscreenControl.Exit":"FullscreenControl.Enter")}_isFullscreen(){return this._fullscreen}_handleFullscreenChange(){this._fullscreen=!this._fullscreen,this._fullscreenButton.classList.toggle("maplibregl-ctrl-shrink"),this._fullscreenButton.classList.toggle("maplibregl-ctrl-fullscreen"),this._updateTitle(),this._fullscreen?(this.fire(new e.k("fullscreenstart")),this._prevCooperativeGesturesEnabled=this._map.cooperativeGestures.isEnabled(),this._map.cooperativeGestures.disable()):(this.fire(new e.k("fullscreenend")),this._prevCooperativeGesturesEnabled&&this._map.cooperativeGestures.enable());}_exitFullscreen(){window.document.exitFullscreen?window.document.exitFullscreen():window.document.mozCancelFullScreen?window.document.mozCancelFullScreen():window.document.msExitFullscreen?window.document.msExitFullscreen():window.document.webkitCancelFullScreen?window.document.webkitCancelFullScreen():this._togglePseudoFullScreen();}_requestFullscreen(){this._container.requestFullscreen?this._container.requestFullscreen():this._container.mozRequestFullScreen?this._container.mozRequestFullScreen():this._container.msRequestFullscreen?this._container.msRequestFullscreen():this._container.webkitRequestFullscreen?this._container.webkitRequestFullscreen():this._togglePseudoFullScreen();}_togglePseudoFullScreen(){this._container.classList.toggle("maplibregl-pseudo-fullscreen"),this._handleFullscreenChange(),this._map.resize();}},t.GeoJSONSource=J,t.GeolocateControl=class extends e.E{constructor(t){super(),this._onSuccess=t=>{if(this._map){if(this._isOutOfMapMaxBounds(t))return this._setErrorState(),this.fire(new e.k("outofmaxbounds",t)),this._updateMarker(),void this._finish();if(this.options.trackUserLocation)switch(this._lastKnownPosition=t,this._watchState){case"WAITING_ACTIVE":case"ACTIVE_LOCK":case"ACTIVE_ERROR":this._watchState="ACTIVE_LOCK",this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-waiting"),this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-active-error"),this._geolocateButton.classList.add("maplibregl-ctrl-geolocate-active");break;case"BACKGROUND":case"BACKGROUND_ERROR":this._watchState="BACKGROUND",this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-waiting"),this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-background-error"),this._geolocateButton.classList.add("maplibregl-ctrl-geolocate-background");break;default:throw new Error(`Unexpected watchState ${this._watchState}`)}this.options.showUserLocation&&"OFF"!==this._watchState&&this._updateMarker(t),this.options.trackUserLocation&&"ACTIVE_LOCK"!==this._watchState||this._updateCamera(t),this.options.showUserLocation&&this._dotElement.classList.remove("maplibregl-user-location-dot-stale"),this.fire(new e.k("geolocate",t)),this._finish();}},this._updateCamera=t=>{const i=new e.N(t.coords.longitude,t.coords.latitude),a=t.coords.accuracy,s=this._map.getBearing(),o=e.e({bearing:s},this.options.fitBoundsOptions),r=H.fromLngLat(i,a);this._map.fitBounds(r,o,{geolocateSource:!0});},this._updateMarker=t=>{if(t){const i=new e.N(t.coords.longitude,t.coords.latitude);this._accuracyCircleMarker.setLngLat(i).addTo(this._map),this._userLocationDotMarker.setLngLat(i).addTo(this._map),this._accuracy=t.coords.accuracy,this.options.showUserLocation&&this.options.showAccuracyCircle&&this._updateCircleRadius();}else this._userLocationDotMarker.remove(),this._accuracyCircleMarker.remove();},this._onZoom=()=>{this.options.showUserLocation&&this.options.showAccuracyCircle&&this._updateCircleRadius();},this._onError=t=>{if(this._map){if(this.options.trackUserLocation)if(1===t.code){this._watchState="OFF",this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-waiting"),this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-active"),this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-active-error"),this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-background"),this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-background-error"),this._geolocateButton.disabled=!0;const t=this._map._getUIString("GeolocateControl.LocationNotAvailable");this._geolocateButton.title=t,this._geolocateButton.setAttribute("aria-label",t),void 0!==this._geolocationWatchID&&this._clearWatch();}else {if(3===t.code&&Us)return;this._setErrorState();}"OFF"!==this._watchState&&this.options.showUserLocation&&this._dotElement.classList.add("maplibregl-user-location-dot-stale"),this.fire(new e.k("error",t)),this._finish();}},this._finish=()=>{this._timeoutId&&clearTimeout(this._timeoutId),this._timeoutId=void 0;},this._setupUI=()=>{this._map&&(this._container.addEventListener("contextmenu",(t=>t.preventDefault())),this._geolocateButton=r.create("button","maplibregl-ctrl-geolocate",this._container),r.create("span","maplibregl-ctrl-icon",this._geolocateButton).setAttribute("aria-hidden","true"),this._geolocateButton.type="button",this._geolocateButton.disabled=!0);},this._finishSetupUI=t=>{if(this._map){if(!1===t){e.w("Geolocation support is not available so the GeolocateControl will be disabled.");const t=this._map._getUIString("GeolocateControl.LocationNotAvailable");this._geolocateButton.disabled=!0,this._geolocateButton.title=t,this._geolocateButton.setAttribute("aria-label",t);}else {const t=this._map._getUIString("GeolocateControl.FindMyLocation");this._geolocateButton.disabled=!1,this._geolocateButton.title=t,this._geolocateButton.setAttribute("aria-label",t);}this.options.trackUserLocation&&(this._geolocateButton.setAttribute("aria-pressed","false"),this._watchState="OFF"),this.options.showUserLocation&&(this._dotElement=r.create("div","maplibregl-user-location-dot"),this._userLocationDotMarker=new Os({element:this._dotElement}),this._circleElement=r.create("div","maplibregl-user-location-accuracy-circle"),this._accuracyCircleMarker=new Os({element:this._circleElement,pitchAlignment:"map"}),this.options.trackUserLocation&&(this._watchState="OFF"),this._map.on("zoom",this._onZoom)),this._geolocateButton.addEventListener("click",(()=>this.trigger())),this._setup=!0,this.options.trackUserLocation&&this._map.on("movestart",(t=>{t.geolocateSource||"ACTIVE_LOCK"!==this._watchState||t.originalEvent&&"resize"===t.originalEvent.type||(this._watchState="BACKGROUND",this._geolocateButton.classList.add("maplibregl-ctrl-geolocate-background"),this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-active"),this.fire(new e.k("trackuserlocationend")),this.fire(new e.k("userlocationlostfocus")));}));}},this.options=e.e({},Ns,t);}onAdd(t){return this._map=t,this._container=r.create("div","maplibregl-ctrl maplibregl-ctrl-group"),this._setupUI(),function(){return e._(this,arguments,void 0,(function*(t=!1){if(void 0!==ks&&!t)return ks;if(void 0===window.navigator.permissions)return ks=!!window.navigator.geolocation,ks;try{const t=yield window.navigator.permissions.query({name:"geolocation"});ks="denied"!==t.state;}catch(t){ks=!!window.navigator.geolocation;}return ks}))}().then((t=>this._finishSetupUI(t))),this._container}onRemove(){void 0!==this._geolocationWatchID&&(window.navigator.geolocation.clearWatch(this._geolocationWatchID),this._geolocationWatchID=void 0),this.options.showUserLocation&&this._userLocationDotMarker&&this._userLocationDotMarker.remove(),this.options.showAccuracyCircle&&this._accuracyCircleMarker&&this._accuracyCircleMarker.remove(),r.remove(this._container),this._map.off("zoom",this._onZoom),this._map=void 0,js=0,Us=!1;}_isOutOfMapMaxBounds(t){const e=this._map.getMaxBounds(),i=t.coords;return e&&(i.longitude<e.getWest()||i.longitude>e.getEast()||i.latitude<e.getSouth()||i.latitude>e.getNorth())}_setErrorState(){switch(this._watchState){case"WAITING_ACTIVE":this._watchState="ACTIVE_ERROR",this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-active"),this._geolocateButton.classList.add("maplibregl-ctrl-geolocate-active-error");break;case"ACTIVE_LOCK":this._watchState="ACTIVE_ERROR",this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-active"),this._geolocateButton.classList.add("maplibregl-ctrl-geolocate-active-error"),this._geolocateButton.classList.add("maplibregl-ctrl-geolocate-waiting");break;case"BACKGROUND":this._watchState="BACKGROUND_ERROR",this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-background"),this._geolocateButton.classList.add("maplibregl-ctrl-geolocate-background-error"),this._geolocateButton.classList.add("maplibregl-ctrl-geolocate-waiting");break;case"ACTIVE_ERROR":break;default:throw new Error(`Unexpected watchState ${this._watchState}`)}}_updateCircleRadius(){const t=this._map.getBounds(),e=t.getSouthEast(),i=t.getNorthEast(),a=e.distanceTo(i),s=Math.ceil(this._accuracy/(a/this._map._container.clientHeight)*2);this._circleElement.style.width=`${s}px`,this._circleElement.style.height=`${s}px`;}trigger(){if(!this._setup)return e.w("Geolocate control triggered before added to a map"),!1;if(this.options.trackUserLocation){switch(this._watchState){case"OFF":this._watchState="WAITING_ACTIVE",this.fire(new e.k("trackuserlocationstart"));break;case"WAITING_ACTIVE":case"ACTIVE_LOCK":case"ACTIVE_ERROR":case"BACKGROUND_ERROR":js--,Us=!1,this._watchState="OFF",this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-waiting"),this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-active"),this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-active-error"),this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-background"),this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-background-error"),this.fire(new e.k("trackuserlocationend"));break;case"BACKGROUND":this._watchState="ACTIVE_LOCK",this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-background"),this._lastKnownPosition&&this._updateCamera(this._lastKnownPosition),this.fire(new e.k("trackuserlocationstart")),this.fire(new e.k("userlocationfocus"));break;default:throw new Error(`Unexpected watchState ${this._watchState}`)}switch(this._watchState){case"WAITING_ACTIVE":this._geolocateButton.classList.add("maplibregl-ctrl-geolocate-waiting"),this._geolocateButton.classList.add("maplibregl-ctrl-geolocate-active");break;case"ACTIVE_LOCK":this._geolocateButton.classList.add("maplibregl-ctrl-geolocate-active");break;case"OFF":break;default:throw new Error(`Unexpected watchState ${this._watchState}`)}if("OFF"===this._watchState&&void 0!==this._geolocationWatchID)this._clearWatch();else if(void 0===this._geolocationWatchID){let t;this._geolocateButton.classList.add("maplibregl-ctrl-geolocate-waiting"),this._geolocateButton.setAttribute("aria-pressed","true"),js++,js>1?(t={maximumAge:6e5,timeout:0},Us=!0):(t=this.options.positionOptions,Us=!1),this._geolocationWatchID=window.navigator.geolocation.watchPosition(this._onSuccess,this._onError,t);}}else window.navigator.geolocation.getCurrentPosition(this._onSuccess,this._onError,this.options.positionOptions),this._timeoutId=setTimeout(this._finish,1e4);return !0}_clearWatch(){window.navigator.geolocation.clearWatch(this._geolocationWatchID),this._geolocationWatchID=void 0,this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-waiting"),this._geolocateButton.setAttribute("aria-pressed","false"),this.options.showUserLocation&&this._updateMarker(null);}},t.Hash=xa,t.ImageSource=Q,t.KeyboardHandler=is,t.LngLatBounds=H,t.LogoControl=ys,t.Map=class extends gs{constructor(t){e.be.mark(e.bf.create);const i=Object.assign(Object.assign({},Ds),t);if(null!=i.minZoom&&null!=i.maxZoom&&i.minZoom>i.maxZoom)throw new Error("maxZoom must be greater than or equal to minZoom");if(null!=i.minPitch&&null!=i.maxPitch&&i.minPitch>i.maxPitch)throw new Error("maxPitch must be greater than or equal to minPitch");if(null!=i.minPitch&&i.minPitch<0)throw new Error("minPitch must be greater than or equal to 0");if(null!=i.maxPitch&&i.maxPitch>85)throw new Error("maxPitch must be less than or equal to 85");if(super(new ga(i.minZoom,i.maxZoom,i.minPitch,i.maxPitch,i.renderWorldCopies),{bearingSnap:i.bearingSnap}),this._idleTriggered=!1,this._crossFadingFactor=1,this._renderTaskQueue=new bs,this._controls=[],this._mapId=e.a4(),this._contextLost=t=>{t.preventDefault(),this._frameRequest&&(this._frameRequest.abort(),this._frameRequest=null),this.fire(new e.k("webglcontextlost",{originalEvent:t}));},this._contextRestored=t=>{this._setupPainter(),this.resize(),this._update(),this.fire(new e.k("webglcontextrestored",{originalEvent:t}));},this._onMapScroll=t=>{if(t.target===this._container)return this._container.scrollTop=0,this._container.scrollLeft=0,!1},this._onWindowOnline=()=>{this._update();},this._interactive=i.interactive,this._maxTileCacheSize=i.maxTileCacheSize,this._maxTileCacheZoomLevels=i.maxTileCacheZoomLevels,this._failIfMajorPerformanceCaveat=!0===i.failIfMajorPerformanceCaveat,this._preserveDrawingBuffer=!0===i.preserveDrawingBuffer,this._antialias=!0===i.antialias,this._trackResize=!0===i.trackResize,this._bearingSnap=i.bearingSnap,this._refreshExpiredTiles=!0===i.refreshExpiredTiles,this._fadeDuration=i.fadeDuration,this._crossSourceCollisions=!0===i.crossSourceCollisions,this._collectResourceTiming=!0===i.collectResourceTiming,this._locale=Object.assign(Object.assign({},Ss),i.locale),this._clickTolerance=i.clickTolerance,this._overridePixelRatio=i.pixelRatio,this._maxCanvasSize=i.maxCanvasSize,this.transformCameraUpdate=i.transformCameraUpdate,this.cancelPendingTileRequestsWhileZooming=!0===i.cancelPendingTileRequestsWhileZooming,this._imageQueueHandle=_.addThrottleControl((()=>this.isMoving())),this._requestManager=new p(i.transformRequest),"string"==typeof i.container){if(this._container=document.getElementById(i.container),!this._container)throw new Error(`Container '${i.container}' not found.`)}else {if(!(i.container instanceof HTMLElement))throw new Error("Invalid type: 'container' must be a String or HTMLElement.");this._container=i.container;}if(i.maxBounds&&this.setMaxBounds(i.maxBounds),this._setupContainer(),this._setupPainter(),this.on("move",(()=>this._update(!1))).on("moveend",(()=>this._update(!1))).on("zoom",(()=>this._update(!0))).on("terrain",(()=>{this.painter.terrainFacilitator.dirty=!0,this._update(!0);})).once("idle",(()=>{this._idleTriggered=!0;})),"undefined"!=typeof window){addEventListener("online",this._onWindowOnline,!1);let t=!1;const e=va((t=>{this._trackResize&&!this._removed&&this.resize(t)._update();}),50);this._resizeObserver=new ResizeObserver((i=>{t?e(i):t=!0;})),this._resizeObserver.observe(this._container);}this.handlers=new fs(this,i),this._hash=i.hash&&new xa("string"==typeof i.hash&&i.hash||void 0).addTo(this),this._hash&&this._hash._onHashChange()||(this.jumpTo({center:i.center,zoom:i.zoom,bearing:i.bearing,pitch:i.pitch}),i.bounds&&(this.resize(),this.fitBounds(i.bounds,e.e({},i.fitBoundsOptions,{duration:0})))),this.resize(),this._localIdeographFontFamily=i.localIdeographFontFamily,this._validateStyle=i.validateStyle,i.style&&this.setStyle(i.style,{localIdeographFontFamily:i.localIdeographFontFamily}),i.attributionControl&&this.addControl(new xs("boolean"==typeof i.attributionControl?void 0:i.attributionControl)),i.maplibreLogo&&this.addControl(new ys,i.logoPosition),this.on("style.load",(()=>{this.transform.unmodified&&this.jumpTo(this.style.stylesheet);})),this.on("data",(t=>{this._update("style"===t.dataType),this.fire(new e.k(`${t.dataType}data`,t));})),this.on("dataloading",(t=>{this.fire(new e.k(`${t.dataType}dataloading`,t));})),this.on("dataabort",(t=>{this.fire(new e.k("sourcedataabort",t));}));}_getMapId(){return this._mapId}addControl(t,i){if(void 0===i&&(i=t.getDefaultPosition?t.getDefaultPosition():"top-right"),!t||!t.onAdd)return this.fire(new e.j(new Error("Invalid argument to map.addControl(). Argument must be a control with onAdd and onRemove methods.")));const a=t.onAdd(this);this._controls.push(t);const s=this._controlPositions[i];return -1!==i.indexOf("bottom")?s.insertBefore(a,s.firstChild):s.appendChild(a),this}removeControl(t){if(!t||!t.onRemove)return this.fire(new e.j(new Error("Invalid argument to map.removeControl(). Argument must be a control with onAdd and onRemove methods.")));const i=this._controls.indexOf(t);return i>-1&&this._controls.splice(i,1),t.onRemove(this),this}hasControl(t){return this._controls.indexOf(t)>-1}calculateCameraOptionsFromTo(t,e,i,a){return null==a&&this.terrain&&(a=this.terrain.getElevationForLngLatZoom(i,this.transform.tileZoom)),super.calculateCameraOptionsFromTo(t,e,i,a)}resize(t){var i;const a=this._containerDimensions(),s=a[0],o=a[1],r=this._getClampedPixelRatio(s,o);if(this._resizeCanvas(s,o,r),this.painter.resize(s,o,r),this.painter.overLimit()){const t=this.painter.context.gl;this._maxCanvasSize=[t.drawingBufferWidth,t.drawingBufferHeight];const e=this._getClampedPixelRatio(s,o);this._resizeCanvas(s,o,e),this.painter.resize(s,o,e);}this.transform.resize(s,o),null===(i=this._requestedCameraState)||void 0===i||i.resize(s,o);const n=!this._moving;return n&&(this.stop(),this.fire(new e.k("movestart",t)).fire(new e.k("move",t))),this.fire(new e.k("resize",t)),n&&this.fire(new e.k("moveend",t)),this}_getClampedPixelRatio(t,e){const{0:i,1:a}=this._maxCanvasSize,s=this.getPixelRatio(),o=t*s,r=e*s;return Math.min(o>i?i/o:1,r>a?a/r:1)*s}getPixelRatio(){var t;return null!==(t=this._overridePixelRatio)&&void 0!==t?t:devicePixelRatio}setPixelRatio(t){this._overridePixelRatio=t,this.resize();}getBounds(){return this.transform.getBounds()}getMaxBounds(){return this.transform.getMaxBounds()}setMaxBounds(t){return this.transform.setMaxBounds(H.convert(t)),this._update()}setMinZoom(t){if((t=null==t?-2:t)>=-2&&t<=this.transform.maxZoom)return this.transform.minZoom=t,this._update(),this.getZoom()<t&&this.setZoom(t),this;throw new Error("minZoom must be between -2 and the current maxZoom, inclusive")}getMinZoom(){return this.transform.minZoom}setMaxZoom(t){if((t=null==t?22:t)>=this.transform.minZoom)return this.transform.maxZoom=t,this._update(),this.getZoom()>t&&this.setZoom(t),this;throw new Error("maxZoom must be greater than the current minZoom")}getMaxZoom(){return this.transform.maxZoom}setMinPitch(t){if((t=null==t?0:t)<0)throw new Error("minPitch must be greater than or equal to 0");if(t>=0&&t<=this.transform.maxPitch)return this.transform.minPitch=t,this._update(),this.getPitch()<t&&this.setPitch(t),this;throw new Error("minPitch must be between 0 and the current maxPitch, inclusive")}getMinPitch(){return this.transform.minPitch}setMaxPitch(t){if((t=null==t?60:t)>85)throw new Error("maxPitch must be less than or equal to 85");if(t>=this.transform.minPitch)return this.transform.maxPitch=t,this._update(),this.getPitch()>t&&this.setPitch(t),this;throw new Error("maxPitch must be greater than the current minPitch")}getMaxPitch(){return this.transform.maxPitch}getRenderWorldCopies(){return this.transform.renderWorldCopies}setRenderWorldCopies(t){return this.transform.renderWorldCopies=t,this._update()}project(t){return this.transform.locationPoint(e.N.convert(t),this.style&&this.terrain)}unproject(t){return this.transform.pointLocation(e.P.convert(t),this.terrain)}isMoving(){var t;return this._moving||(null===(t=this.handlers)||void 0===t?void 0:t.isMoving())}isZooming(){var t;return this._zooming||(null===(t=this.handlers)||void 0===t?void 0:t.isZooming())}isRotating(){var t;return this._rotating||(null===(t=this.handlers)||void 0===t?void 0:t.isRotating())}_createDelegatedListener(t,e,i){if("mouseenter"===t||"mouseover"===t){let a=!1;const s=s=>{const o=this.getLayer(e)?this.queryRenderedFeatures(s.point,{layers:[e]}):[];o.length?a||(a=!0,i.call(this,new Sa(t,this,s.originalEvent,{features:o}))):a=!1;};return {layer:e,listener:i,delegates:{mousemove:s,mouseout:()=>{a=!1;}}}}if("mouseleave"===t||"mouseout"===t){let a=!1;const s=s=>{(this.getLayer(e)?this.queryRenderedFeatures(s.point,{layers:[e]}):[]).length?a=!0:a&&(a=!1,i.call(this,new Sa(t,this,s.originalEvent)));},o=e=>{a&&(a=!1,i.call(this,new Sa(t,this,e.originalEvent)));};return {layer:e,listener:i,delegates:{mousemove:s,mouseout:o}}}{const a=t=>{const a=this.getLayer(e)?this.queryRenderedFeatures(t.point,{layers:[e]}):[];a.length&&(t.features=a,i.call(this,t),delete t.features);};return {layer:e,listener:i,delegates:{[t]:a}}}}on(t,e,i){if(void 0===i)return super.on(t,e);const a=this._createDelegatedListener(t,e,i);this._delegatedListeners=this._delegatedListeners||{},this._delegatedListeners[t]=this._delegatedListeners[t]||[],this._delegatedListeners[t].push(a);for(const t in a.delegates)this.on(t,a.delegates[t]);return this}once(t,e,i){if(void 0===i)return super.once(t,e);const a=this._createDelegatedListener(t,e,i);for(const t in a.delegates)this.once(t,a.delegates[t]);return this}off(t,e,i){return void 0===i?super.off(t,e):(this._delegatedListeners&&this._delegatedListeners[t]&&(a=>{const s=this._delegatedListeners[t];for(let t=0;t<s.length;t++){const a=s[t];if(a.layer===e&&a.listener===i){for(const t in a.delegates)this.off(t,a.delegates[t]);return s.splice(t,1),this}}})(),this)}queryRenderedFeatures(t,i){if(!this.style)return [];let a;const s=t instanceof e.P||Array.isArray(t),o=s?t:[[0,0],[this.transform.width,this.transform.height]];if(i=i||(s?{}:t)||{},o instanceof e.P||"number"==typeof o[0])a=[e.P.convert(o)];else {const t=e.P.convert(o[0]),i=e.P.convert(o[1]);a=[t,new e.P(i.x,t.y),i,new e.P(t.x,i.y),t];}return this.style.queryRenderedFeatures(a,i,this.transform)}querySourceFeatures(t,e){return this.style.querySourceFeatures(t,e)}setStyle(t,i){return !1!==(i=e.e({},{localIdeographFontFamily:this._localIdeographFontFamily,validate:this._validateStyle},i)).diff&&i.localIdeographFontFamily===this._localIdeographFontFamily&&this.style&&t?(this._diffStyle(t,i),this):(this._localIdeographFontFamily=i.localIdeographFontFamily,this._updateStyle(t,i))}setTransformRequest(t){return this._requestManager.setTransformRequest(t),this}_getUIString(t){const e=this._locale[t];if(null==e)throw new Error(`Missing UI string '${t}'`);return e}_updateStyle(t,e){if(e.transformStyle&&this.style&&!this.style._loaded)return void this.style.once("style.load",(()=>this._updateStyle(t,e)));const i=this.style&&e.transformStyle?this.style.serialize():void 0;return this.style&&(this.style.setEventedParent(null),this.style._remove(!t)),t?(this.style=new ue(this,e||{}),this.style.setEventedParent(this,{style:this.style}),"string"==typeof t?this.style.loadURL(t,e,i):this.style.loadJSON(t,e,i),this):(delete this.style,this)}_lazyInitEmptyStyle(){this.style||(this.style=new ue(this,{}),this.style.setEventedParent(this,{style:this.style}),this.style.loadEmpty());}_diffStyle(t,i){if("string"==typeof t){const a=this._requestManager.transformRequest(t,"Style");e.h(a,new AbortController).then((t=>{this._updateDiff(t.data,i);})).catch((t=>{t&&this.fire(new e.j(t));}));}else "object"==typeof t&&this._updateDiff(t,i);}_updateDiff(t,i){try{this.style.setState(t,i)&&this._update(!0);}catch(a){e.w(`Unable to perform style diff: ${a.message||a.error||a}.  Rebuilding the style from scratch.`),this._updateStyle(t,i);}}getStyle(){if(this.style)return this.style.serialize()}isStyleLoaded(){return this.style?this.style.loaded():e.w("There is no style added to the map.")}addSource(t,e){return this._lazyInitEmptyStyle(),this.style.addSource(t,e),this._update(!0)}isSourceLoaded(t){const i=this.style&&this.style.sourceCaches[t];if(void 0!==i)return i.loaded();this.fire(new e.j(new Error(`There is no source with ID '${t}'`)));}setTerrain(t){if(this.style._checkLoaded(),this._terrainDataCallback&&this.style.off("data",this._terrainDataCallback),t){const i=this.style.sourceCaches[t.source];if(!i)throw new Error(`cannot load terrain, because there exists no source with ID: ${t.source}`);null===this.terrain&&i.reload();for(const i in this.style._layers){const a=this.style._layers[i];"hillshade"===a.type&&a.source===t.source&&e.w("You are using the same source for a hillshade layer and for 3D terrain. Please consider using two separate sources to improve rendering quality.");}this.terrain=new Is(this.painter,i,t),this.painter.renderToTexture=new Cs(this.painter,this.terrain),this.transform.minElevationForCurrentTile=this.terrain.getMinTileElevationForLngLatZoom(this.transform.center,this.transform.tileZoom),this.transform.elevation=this.terrain.getElevationForLngLatZoom(this.transform.center,this.transform.tileZoom),this._terrainDataCallback=e=>{"style"===e.dataType?this.terrain.sourceCache.freeRtt():"source"===e.dataType&&e.tile&&(e.sourceId!==t.source||this._elevationFreeze||(this.transform.minElevationForCurrentTile=this.terrain.getMinTileElevationForLngLatZoom(this.transform.center,this.transform.tileZoom),this.transform.elevation=this.terrain.getElevationForLngLatZoom(this.transform.center,this.transform.tileZoom)),this.terrain.sourceCache.freeRtt(e.tile.tileID));},this.style.on("data",this._terrainDataCallback);}else this.terrain&&this.terrain.sourceCache.destruct(),this.terrain=null,this.painter.renderToTexture&&this.painter.renderToTexture.destruct(),this.painter.renderToTexture=null,this.transform.minElevationForCurrentTile=0,this.transform.elevation=0;return this.fire(new e.k("terrain",{terrain:t})),this}getTerrain(){var t,e;return null!==(e=null===(t=this.terrain)||void 0===t?void 0:t.options)&&void 0!==e?e:null}areTilesLoaded(){const t=this.style&&this.style.sourceCaches;for(const e in t){const i=t[e]._tiles;for(const t in i){const e=i[t];if("loaded"!==e.state&&"errored"!==e.state)return !1}}return !0}removeSource(t){return this.style.removeSource(t),this._update(!0)}getSource(t){return this.style.getSource(t)}addImage(t,i,a={}){const{pixelRatio:s=1,sdf:r=!1,stretchX:n,stretchY:l,content:h,textFitWidth:c,textFitHeight:u}=a;if(this._lazyInitEmptyStyle(),!(i instanceof HTMLImageElement||e.b(i))){if(void 0===i.width||void 0===i.height)return this.fire(new e.j(new Error("Invalid arguments to map.addImage(). The second argument must be an `HTMLImageElement`, `ImageData`, `ImageBitmap`, or object with `width`, `height`, and `data` properties with the same format as `ImageData`")));{const{width:a,height:o,data:d}=i,_=i;return this.style.addImage(t,{data:new e.R({width:a,height:o},new Uint8Array(d)),pixelRatio:s,stretchX:n,stretchY:l,content:h,textFitWidth:c,textFitHeight:u,sdf:r,version:0,userImage:_}),_.onAdd&&_.onAdd(this,t),this}}{const{width:a,height:d,data:_}=o.getImageData(i);this.style.addImage(t,{data:new e.R({width:a,height:d},_),pixelRatio:s,stretchX:n,stretchY:l,content:h,textFitWidth:c,textFitHeight:u,sdf:r,version:0});}}updateImage(t,i){const a=this.style.getImage(t);if(!a)return this.fire(new e.j(new Error("The map has no image with that id. If you are adding a new image use `map.addImage(...)` instead.")));const s=i instanceof HTMLImageElement||e.b(i)?o.getImageData(i):i,{width:r,height:n,data:l}=s;if(void 0===r||void 0===n)return this.fire(new e.j(new Error("Invalid arguments to map.updateImage(). The second argument must be an `HTMLImageElement`, `ImageData`, `ImageBitmap`, or object with `width`, `height`, and `data` properties with the same format as `ImageData`")));if(r!==a.data.width||n!==a.data.height)return this.fire(new e.j(new Error("The width and height of the updated image must be that same as the previous version of the image")));const h=!(i instanceof HTMLImageElement||e.b(i));return a.data.replace(l,h),this.style.updateImage(t,a),this}getImage(t){return this.style.getImage(t)}hasImage(t){return t?!!this.style.getImage(t):(this.fire(new e.j(new Error("Missing required image id"))),!1)}removeImage(t){this.style.removeImage(t);}loadImage(t){return _.getImage(this._requestManager.transformRequest(t,"Image"),new AbortController)}listImages(){return this.style.listImages()}addLayer(t,e){return this._lazyInitEmptyStyle(),this.style.addLayer(t,e),this._update(!0)}moveLayer(t,e){return this.style.moveLayer(t,e),this._update(!0)}removeLayer(t){return this.style.removeLayer(t),this._update(!0)}getLayer(t){return this.style.getLayer(t)}getLayersOrder(){return this.style.getLayersOrder()}setLayerZoomRange(t,e,i){return this.style.setLayerZoomRange(t,e,i),this._update(!0)}setFilter(t,e,i={}){return this.style.setFilter(t,e,i),this._update(!0)}getFilter(t){return this.style.getFilter(t)}setPaintProperty(t,e,i,a={}){return this.style.setPaintProperty(t,e,i,a),this._update(!0)}getPaintProperty(t,e){return this.style.getPaintProperty(t,e)}setLayoutProperty(t,e,i,a={}){return this.style.setLayoutProperty(t,e,i,a),this._update(!0)}getLayoutProperty(t,e){return this.style.getLayoutProperty(t,e)}setGlyphs(t,e={}){return this._lazyInitEmptyStyle(),this.style.setGlyphs(t,e),this._update(!0)}getGlyphs(){return this.style.getGlyphsUrl()}addSprite(t,e,i={}){return this._lazyInitEmptyStyle(),this.style.addSprite(t,e,i,(t=>{t||this._update(!0);})),this}removeSprite(t){return this._lazyInitEmptyStyle(),this.style.removeSprite(t),this._update(!0)}getSprite(){return this.style.getSprite()}setSprite(t,e={}){return this._lazyInitEmptyStyle(),this.style.setSprite(t,e,(t=>{t||this._update(!0);})),this}setLight(t,e={}){return this._lazyInitEmptyStyle(),this.style.setLight(t,e),this._update(!0)}getLight(){return this.style.getLight()}setSky(t){return this._lazyInitEmptyStyle(),this.style.setSky(t),this._update(!0)}getSky(){return this.style.getSky()}setFeatureState(t,e){return this.style.setFeatureState(t,e),this._update()}removeFeatureState(t,e){return this.style.removeFeatureState(t,e),this._update()}getFeatureState(t){return this.style.getFeatureState(t)}getContainer(){return this._container}getCanvasContainer(){return this._canvasContainer}getCanvas(){return this._canvas}_containerDimensions(){let t=0,e=0;return this._container&&(t=this._container.clientWidth||400,e=this._container.clientHeight||300),[t,e]}_setupContainer(){const t=this._container;t.classList.add("maplibregl-map");const e=this._canvasContainer=r.create("div","maplibregl-canvas-container",t);this._interactive&&e.classList.add("maplibregl-interactive"),this._canvas=r.create("canvas","maplibregl-canvas",e),this._canvas.addEventListener("webglcontextlost",this._contextLost,!1),this._canvas.addEventListener("webglcontextrestored",this._contextRestored,!1),this._canvas.setAttribute("tabindex",this._interactive?"0":"-1"),this._canvas.setAttribute("aria-label",this._getUIString("Map.Title")),this._canvas.setAttribute("role","region");const i=this._containerDimensions(),a=this._getClampedPixelRatio(i[0],i[1]);this._resizeCanvas(i[0],i[1],a);const s=this._controlContainer=r.create("div","maplibregl-control-container",t),o=this._controlPositions={};["top-left","top-right","bottom-left","bottom-right"].forEach((t=>{o[t]=r.create("div",`maplibregl-ctrl-${t} `,s);})),this._container.addEventListener("scroll",this._onMapScroll,!1);}_resizeCanvas(t,e,i){this._canvas.width=Math.floor(i*t),this._canvas.height=Math.floor(i*e),this._canvas.style.width=`${t}px`,this._canvas.style.height=`${e}px`;}_setupPainter(){const t={alpha:!0,stencil:!0,depth:!0,failIfMajorPerformanceCaveat:this._failIfMajorPerformanceCaveat,preserveDrawingBuffer:this._preserveDrawingBuffer,antialias:this._antialias||!1};let e=null;this._canvas.addEventListener("webglcontextcreationerror",(i=>{e={requestedAttributes:t},i&&(e.statusMessage=i.statusMessage,e.type=i.type);}),{once:!0});const i=this._canvas.getContext("webgl2",t)||this._canvas.getContext("webgl",t);if(!i){const t="Failed to initialize WebGL";throw e?(e.message=t,new Error(JSON.stringify(e))):new Error(t)}this.painter=new da(i,this.transform),n.testSupport(i);}loaded(){return !this._styleDirty&&!this._sourcesDirty&&!!this.style&&this.style.loaded()}_update(t){return this.style&&this.style._loaded?(this._styleDirty=this._styleDirty||t,this._sourcesDirty=!0,this.triggerRepaint(),this):this}_requestRenderFrame(t){return this._update(),this._renderTaskQueue.add(t)}_cancelRenderFrame(t){this._renderTaskQueue.remove(t);}_render(t){const i=this._idleTriggered?this._fadeDuration:0;if(this.painter.context.setDirty(),this.painter.setBaseState(),this._renderTaskQueue.run(t),this._removed)return;let a=!1;if(this.style&&this._styleDirty){this._styleDirty=!1;const t=this.transform.zoom,s=o.now();this.style.zoomHistory.update(t,s);const r=new e.z(t,{now:s,fadeDuration:i,zoomHistory:this.style.zoomHistory,transition:this.style.getTransition()}),n=r.crossFadingFactor();1===n&&n===this._crossFadingFactor||(a=!0,this._crossFadingFactor=n),this.style.update(r);}this.style&&this._sourcesDirty&&(this._sourcesDirty=!1,this.style._updateSources(this.transform)),this.terrain?(this.terrain.sourceCache.update(this.transform,this.terrain),this.transform.minElevationForCurrentTile=this.terrain.getMinTileElevationForLngLatZoom(this.transform.center,this.transform.tileZoom),this._elevationFreeze||(this.transform.elevation=this.terrain.getElevationForLngLatZoom(this.transform.center,this.transform.tileZoom))):(this.transform.minElevationForCurrentTile=0,this.transform.elevation=0),this._placementDirty=this.style&&this.style._updatePlacement(this.painter.transform,this.showCollisionBoxes,i,this._crossSourceCollisions),this.painter.render(this.style,{showTileBoundaries:this.showTileBoundaries,showOverdrawInspector:this._showOverdrawInspector,rotating:this.isRotating(),zooming:this.isZooming(),moving:this.isMoving(),fadeDuration:i,showPadding:this.showPadding}),this.fire(new e.k("render")),this.loaded()&&!this._loaded&&(this._loaded=!0,e.be.mark(e.bf.load),this.fire(new e.k("load"))),this.style&&(this.style.hasTransitions()||a)&&(this._styleDirty=!0),this.style&&!this._placementDirty&&this.style._releaseSymbolFadeTiles();const s=this._sourcesDirty||this._styleDirty||this._placementDirty;return s||this._repaint?this.triggerRepaint():!this.isMoving()&&this.loaded()&&this.fire(new e.k("idle")),!this._loaded||this._fullyLoaded||s||(this._fullyLoaded=!0,e.be.mark(e.bf.fullLoad)),this}redraw(){return this.style&&(this._frameRequest&&(this._frameRequest.abort(),this._frameRequest=null),this._render(0)),this}remove(){var t;this._hash&&this._hash.remove();for(const t of this._controls)t.onRemove(this);this._controls=[],this._frameRequest&&(this._frameRequest.abort(),this._frameRequest=null),this._renderTaskQueue.clear(),this.painter.destroy(),this.handlers.destroy(),delete this.handlers,this.setStyle(null),"undefined"!=typeof window&&removeEventListener("online",this._onWindowOnline,!1),_.removeThrottleControl(this._imageQueueHandle),null===(t=this._resizeObserver)||void 0===t||t.disconnect();const i=this.painter.context.gl.getExtension("WEBGL_lose_context");(null==i?void 0:i.loseContext)&&i.loseContext(),this._canvas.removeEventListener("webglcontextrestored",this._contextRestored,!1),this._canvas.removeEventListener("webglcontextlost",this._contextLost,!1),r.remove(this._canvasContainer),r.remove(this._controlContainer),this._container.classList.remove("maplibregl-map"),e.be.clearMetrics(),this._removed=!0,this.fire(new e.k("remove"));}triggerRepaint(){this.style&&!this._frameRequest&&(this._frameRequest=new AbortController,o.frameAsync(this._frameRequest).then((t=>{e.be.frame(t),this._frameRequest=null,this._render(t);})).catch((()=>{})));}get showTileBoundaries(){return !!this._showTileBoundaries}set showTileBoundaries(t){this._showTileBoundaries!==t&&(this._showTileBoundaries=t,this._update());}get showPadding(){return !!this._showPadding}set showPadding(t){this._showPadding!==t&&(this._showPadding=t,this._update());}get showCollisionBoxes(){return !!this._showCollisionBoxes}set showCollisionBoxes(t){this._showCollisionBoxes!==t&&(this._showCollisionBoxes=t,t?this.style._generateCollisionBoxes():this._update());}get showOverdrawInspector(){return !!this._showOverdrawInspector}set showOverdrawInspector(t){this._showOverdrawInspector!==t&&(this._showOverdrawInspector=t,this._update());}get repaint(){return !!this._repaint}set repaint(t){this._repaint!==t&&(this._repaint=t,this.triggerRepaint());}get vertices(){return !!this._vertices}set vertices(t){this._vertices=t,this._update();}get version(){return zs}getCameraTargetElevation(){return this.transform.elevation}},t.MapMouseEvent=Sa,t.MapTouchEvent=za,t.MapWheelEvent=Da,t.Marker=Os,t.NavigationControl=class{constructor(t){this._updateZoomButtons=()=>{const t=this._map.getZoom(),e=t===this._map.getMaxZoom(),i=t===this._map.getMinZoom();this._zoomInButton.disabled=e,this._zoomOutButton.disabled=i,this._zoomInButton.setAttribute("aria-disabled",e.toString()),this._zoomOutButton.setAttribute("aria-disabled",i.toString());},this._rotateCompassArrow=()=>{const t=this.options.visualizePitch?`scale(${1/Math.pow(Math.cos(this._map.transform.pitch*(Math.PI/180)),.5)}) rotateX(${this._map.transform.pitch}deg) rotateZ(${this._map.transform.angle*(180/Math.PI)}deg)`:`rotate(${this._map.transform.angle*(180/Math.PI)}deg)`;this._compassIcon.style.transform=t;},this._setButtonTitle=(t,e)=>{const i=this._map._getUIString(`NavigationControl.${e}`);t.title=i,t.setAttribute("aria-label",i);},this.options=e.e({},As,t),this._container=r.create("div","maplibregl-ctrl maplibregl-ctrl-group"),this._container.addEventListener("contextmenu",(t=>t.preventDefault())),this.options.showZoom&&(this._zoomInButton=this._createButton("maplibregl-ctrl-zoom-in",(t=>this._map.zoomIn({},{originalEvent:t}))),r.create("span","maplibregl-ctrl-icon",this._zoomInButton).setAttribute("aria-hidden","true"),this._zoomOutButton=this._createButton("maplibregl-ctrl-zoom-out",(t=>this._map.zoomOut({},{originalEvent:t}))),r.create("span","maplibregl-ctrl-icon",this._zoomOutButton).setAttribute("aria-hidden","true")),this.options.showCompass&&(this._compass=this._createButton("maplibregl-ctrl-compass",(t=>{this.options.visualizePitch?this._map.resetNorthPitch({},{originalEvent:t}):this._map.resetNorth({},{originalEvent:t});})),this._compassIcon=r.create("span","maplibregl-ctrl-icon",this._compass),this._compassIcon.setAttribute("aria-hidden","true"));}onAdd(t){return this._map=t,this.options.showZoom&&(this._setButtonTitle(this._zoomInButton,"ZoomIn"),this._setButtonTitle(this._zoomOutButton,"ZoomOut"),this._map.on("zoom",this._updateZoomButtons),this._updateZoomButtons()),this.options.showCompass&&(this._setButtonTitle(this._compass,"ResetBearing"),this.options.visualizePitch&&this._map.on("pitch",this._rotateCompassArrow),this._map.on("rotate",this._rotateCompassArrow),this._rotateCompassArrow(),this._handler=new Rs(this._map,this._compass,this.options.visualizePitch)),this._container}onRemove(){r.remove(this._container),this.options.showZoom&&this._map.off("zoom",this._updateZoomButtons),this.options.showCompass&&(this.options.visualizePitch&&this._map.off("pitch",this._rotateCompassArrow),this._map.off("rotate",this._rotateCompassArrow),this._handler.off(),delete this._handler),delete this._map;}_createButton(t,e){const i=r.create("button",t,this._container);return i.type="button",i.addEventListener("click",e),i}},t.Popup=class extends e.E{constructor(t){super(),this.remove=()=>(this._content&&r.remove(this._content),this._container&&(r.remove(this._container),delete this._container),this._map&&(this._map.off("move",this._update),this._map.off("move",this._onClose),this._map.off("click",this._onClose),this._map.off("remove",this.remove),this._map.off("mousemove",this._onMouseMove),this._map.off("mouseup",this._onMouseUp),this._map.off("drag",this._onDrag),this._map._canvasContainer.classList.remove("maplibregl-track-pointer"),delete this._map,this.fire(new e.k("close"))),this),this._onMouseUp=t=>{this._update(t.point);},this._onMouseMove=t=>{this._update(t.point);},this._onDrag=t=>{this._update(t.point);},this._update=t=>{var e;if(!this._map||!this._lngLat&&!this._trackPointer||!this._content)return;if(!this._container){if(this._container=r.create("div","maplibregl-popup",this._map.getContainer()),this._tip=r.create("div","maplibregl-popup-tip",this._container),this._container.appendChild(this._content),this.options.className)for(const t of this.options.className.split(" "))this._container.classList.add(t);this._closeButton&&this._closeButton.setAttribute("aria-label",this._map._getUIString("Popup.Close")),this._trackPointer&&this._container.classList.add("maplibregl-popup-track-pointer");}if(this.options.maxWidth&&this._container.style.maxWidth!==this.options.maxWidth&&(this._container.style.maxWidth=this.options.maxWidth),this._lngLat=this._map.transform.renderWorldCopies&&!this._trackPointer?Ls(this._lngLat,this._flatPos,this._map.transform):null===(e=this._lngLat)||void 0===e?void 0:e.wrap(),this._trackPointer&&!t)return;const i=this._flatPos=this._pos=this._trackPointer&&t?t:this._map.project(this._lngLat);this._map.terrain&&(this._flatPos=this._trackPointer&&t?t:this._map.transform.locationPoint(this._lngLat));let a=this.options.anchor;const s=Ws(this.options.offset);if(!a){const t=this._container.offsetWidth,e=this._container.offsetHeight;let o;o=i.y+s.bottom.y<e?["top"]:i.y>this._map.transform.height-e?["bottom"]:[],i.x<t/2?o.push("left"):i.x>this._map.transform.width-t/2&&o.push("right"),a=0===o.length?"bottom":o.join("-");}let o=i.add(s[a]);this.options.subpixelPositioning||(o=o.round()),r.setTransform(this._container,`${Fs[a]} translate(${o.x}px,${o.y}px)`),Bs(this._container,a,"popup");},this._onClose=()=>{this.remove();},this.options=e.e(Object.create(Gs),t);}addTo(t){return this._map&&this.remove(),this._map=t,this.options.closeOnClick&&this._map.on("click",this._onClose),this.options.closeOnMove&&this._map.on("move",this._onClose),this._map.on("remove",this.remove),this._update(),this._focusFirstElement(),this._trackPointer?(this._map.on("mousemove",this._onMouseMove),this._map.on("mouseup",this._onMouseUp),this._container&&this._container.classList.add("maplibregl-popup-track-pointer"),this._map._canvasContainer.classList.add("maplibregl-track-pointer")):this._map.on("move",this._update),this.fire(new e.k("open")),this}isOpen(){return !!this._map}getLngLat(){return this._lngLat}setLngLat(t){return this._lngLat=e.N.convert(t),this._pos=null,this._flatPos=null,this._trackPointer=!1,this._update(),this._map&&(this._map.on("move",this._update),this._map.off("mousemove",this._onMouseMove),this._container&&this._container.classList.remove("maplibregl-popup-track-pointer"),this._map._canvasContainer.classList.remove("maplibregl-track-pointer")),this}trackPointer(){return this._trackPointer=!0,this._pos=null,this._flatPos=null,this._update(),this._map&&(this._map.off("move",this._update),this._map.on("mousemove",this._onMouseMove),this._map.on("drag",this._onDrag),this._container&&this._container.classList.add("maplibregl-popup-track-pointer"),this._map._canvasContainer.classList.add("maplibregl-track-pointer")),this}getElement(){return this._container}setText(t){return this.setDOMContent(document.createTextNode(t))}setHTML(t){const e=document.createDocumentFragment(),i=document.createElement("body");let a;for(i.innerHTML=t;a=i.firstChild,a;)e.appendChild(a);return this.setDOMContent(e)}getMaxWidth(){var t;return null===(t=this._container)||void 0===t?void 0:t.style.maxWidth}setMaxWidth(t){return this.options.maxWidth=t,this._update(),this}setDOMContent(t){if(this._content)for(;this._content.hasChildNodes();)this._content.firstChild&&this._content.removeChild(this._content.firstChild);else this._content=r.create("div","maplibregl-popup-content",this._container);return this._content.appendChild(t),this._createCloseButton(),this._update(),this._focusFirstElement(),this}addClassName(t){return this._container&&this._container.classList.add(t),this}removeClassName(t){return this._container&&this._container.classList.remove(t),this}setOffset(t){return this.options.offset=t,this._update(),this}toggleClassName(t){if(this._container)return this._container.classList.toggle(t)}setSubpixelPositioning(t){this.options.subpixelPositioning=t;}_createCloseButton(){this.options.closeButton&&(this._closeButton=r.create("button","maplibregl-popup-close-button",this._content),this._closeButton.type="button",this._closeButton.innerHTML="&#215;",this._closeButton.addEventListener("click",this._onClose));}_focusFirstElement(){if(!this.options.focusAfterOpen||!this._container)return;const t=this._container.querySelector(Hs);t&&t.focus();}},t.RasterDEMTileSource=K,t.RasterTileSource=X,t.ScaleControl=class{constructor(t){this._onMove=()=>{qs(this._map,this._container,this.options);},this.setUnit=t=>{this.options.unit=t,qs(this._map,this._container,this.options);},this.options=Object.assign(Object.assign({},Zs),t);}getDefaultPosition(){return "bottom-left"}onAdd(t){return this._map=t,this._container=r.create("div","maplibregl-ctrl maplibregl-ctrl-scale",t.getContainer()),this._map.on("move",this._onMove),this._onMove(),this._container}onRemove(){r.remove(this._container),this._map.off("move",this._onMove),this._map=void 0;}},t.ScrollZoomHandler=os,t.Style=ue,t.TerrainControl=class{constructor(t){this._toggleTerrain=()=>{this._map.getTerrain()?this._map.setTerrain(null):this._map.setTerrain(this.options),this._updateTerrainIcon();},this._updateTerrainIcon=()=>{this._terrainButton.classList.remove("maplibregl-ctrl-terrain"),this._terrainButton.classList.remove("maplibregl-ctrl-terrain-enabled"),this._map.terrain?(this._terrainButton.classList.add("maplibregl-ctrl-terrain-enabled"),this._terrainButton.title=this._map._getUIString("TerrainControl.Disable")):(this._terrainButton.classList.add("maplibregl-ctrl-terrain"),this._terrainButton.title=this._map._getUIString("TerrainControl.Enable"));},this.options=t;}onAdd(t){return this._map=t,this._container=r.create("div","maplibregl-ctrl maplibregl-ctrl-group"),this._terrainButton=r.create("button","maplibregl-ctrl-terrain",this._container),r.create("span","maplibregl-ctrl-icon",this._terrainButton).setAttribute("aria-hidden","true"),this._terrainButton.type="button",this._terrainButton.addEventListener("click",this._toggleTerrain),this._updateTerrainIcon(),this._map.on("terrain",this._updateTerrainIcon),this._container}onRemove(){r.remove(this._container),this._map.off("terrain",this._updateTerrainIcon),this._map=void 0;}},t.TwoFingersTouchPitchHandler=ts,t.TwoFingersTouchRotateHandler=Ya,t.TwoFingersTouchZoomHandler=Ka,t.TwoFingersTouchZoomRotateHandler=us,t.VectorTileSource=$,t.VideoSource=tt,t.addSourceType=(t,i)=>e._(void 0,void 0,void 0,(function*(){if(at(t))throw new Error(`A source type called "${t}" already exists.`);((t,e)=>{it[t]=e;})(t,i);})),t.clearPrewarmedResources=function(){const t=B;t&&(t.isPreloaded()&&1===t.numActive()?(t.release(k),B=null):console.warn("Could not clear WebWorkers since there are active Map instances that still reference it. The pre-warmed WebWorker pool can only be cleared when all map instances have been removed with map.remove()"));},t.getMaxParallelImageRequests=function(){return e.a.MAX_PARALLEL_IMAGE_REQUESTS},t.getRTLTextPluginStatus=function(){return nt().getRTLTextPluginStatus()},t.getVersion=function(){return $s},t.getWorkerCount=function(){return L.workerCount},t.getWorkerUrl=function(){return e.a.WORKER_URL},t.importScriptInWorkers=function(t){return U().broadcast("IS",t)},t.prewarm=function(){N().acquire(k);},t.setMaxParallelImageRequests=function(t){e.a.MAX_PARALLEL_IMAGE_REQUESTS=t;},t.setRTLTextPlugin=function(t,e){return nt().setRTLTextPlugin(t,e)},t.setWorkerCount=function(t){L.workerCount=t;},t.setWorkerUrl=function(t){e.a.WORKER_URL=t;};}));

//
// Our custom intro provides a specialized "define()" function, called by the
// AMD modules below, that sets up the worker blob URL and then executes the
// main module, storing its exported value as 'maplibregl'


var maplibregl$1 = maplibregl;

return maplibregl$1;

}));
//# sourceMappingURL=maplibre-gl.js.map
