% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/maps.R
\name{query_tiles}
\alias{query_tiles}
\title{Get information about features in a tileset using the Tilequery API}
\usage{
query_tiles(
  location,
  tileset_id,
  radius = 0,
  limit = 5,
  dedupe = TRUE,
  geometry = NULL,
  layers = NULL,
  access_token = NULL
)
}
\arguments{
\item{location}{The location for which you'd like to query tiles, expressed as either a length-2 vector of longitude and latitude or an address you'd like to geocode.}

\item{tileset_id}{The tileset ID to query.}

\item{radius}{The radius around the point (in meters) for which you'd like to query features.  For point-in-polygon queries (e.g. "what county is my point located in?") the default of 0 should be used.}

\item{limit}{How many features to return (defaults to 5). Can be an integer between 1 and 50.}

\item{dedupe}{Whether or not to return duplicate features as identified by their IDs.  The default, TRUE, will de-duplicate your dataset.}

\item{geometry}{The feature geometry type to query - can be \code{"point"}, \code{"linestring"}, or \code{"polygon"}. If left blank, all geometry types will be queried.}

\item{layers}{A vector of layer IDs you'd like to query (recommended); if left blank will query all layers, with the limitation that at most 50 features can be returned.}

\item{access_token}{Your Mapbox access token, which can be set with \code{mb_access_token()}.}
}
\value{
An R list containing the API response, which includes information about the requested features.  Parse the list to extract desired elements.
}
\description{
Get information about features in a tileset using the Tilequery API
}
\examples{
\dontrun{

library(mapboxapi)

elevation <- query_tiles(
  location = "Breckenridge, Colorado",
  tileset_id = "mapbox.mapbox-terrain-v2",
  layer = "contour",
  limit = 50
)

max(elevation$features$properties$ele)

}

}
\seealso{
\url{https://docs.mapbox.com/help/tutorials/find-elevations-with-tilequery-api/}
}
