% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addProviderEspTiles.R
\name{addProviderEspTiles}
\alias{addProviderEspTiles}
\alias{providerEspTileOptions}
\title{Include base tiles of Spanish public administrations on a \CRANpkg{leaflet}
map}
\source{
\url{https://dieghernan.github.io/leaflet-providersESP/} leaflet plugin,
\strong{v1.3.3}.
}
\usage{
addProviderEspTiles(
  map,
  provider,
  layerId = NULL,
  group = NULL,
  options = providerEspTileOptions()
)

providerEspTileOptions(...)
}
\arguments{
\item{map}{the map to add the tile layer to}

\item{provider}{Name of the provider, see \link{esp_tiles_providers} for
values available.}

\item{layerId}{the layer id to assign}

\item{group}{the name of the group the newly created layers should belong to
(for \code{\link[leaflet]{clearGroup}} and \code{\link[leaflet]{addLayersControl}} purposes).
Human-friendly group names are permitted--they need not be short,
identifier-style names.}

\item{options}{tile options}

\item{...}{Arguments passed on to \code{\link[leaflet:addProviderTiles]{leaflet::providerTileOptions()}}.}
}
\value{
A modified \code{\link[leaflet:leaflet]{leaflet::leaflet()}} \code{map} object.
}
\description{
Include tiles of public Spanish organisms to a \code{\link[leaflet:leaflet]{leaflet::leaflet()}} map.
}
\details{
\code{\link[=providerEspTileOptions]{providerEspTileOptions()}} is a wrapper of \code{\link[leaflet:addProviderTiles]{leaflet::providerTileOptions()}}.
}
\examples{
library(leaflet)
leafmap <- leaflet(width = "100\%", height = "60vh") \%>\%
  setView(lat = 40.4166, lng = -3.7038400, zoom = 10) \%>\%
  addTiles(group = "Default (OSM)") \%>\%
  addProviderEspTiles(
    provider = "IDErioja.Claro",
    group = "IDErioja Claro"
  ) \%>\%
  addProviderEspTiles(
    provider = "RedTransporte.Carreteras",
    group = "Carreteras"
  ) \%>\%
  addLayersControl(
    baseGroups = c("IDErioja Claro", "Default (OSM)"),
    overlayGroups = "Carreteras",
    options = layersControlOptions(collapsed = FALSE)
  )

leafmap
}
\seealso{
\code{\link[leaflet:leaflet]{leaflet::leaflet()}}, \code{\link[leaflet:map-layers]{leaflet::addTiles()}}

\code{\link[leaflet:addProviderTiles]{leaflet::providerTileOptions()}}, \code{\link[leaflet:map-options]{leaflet::tileOptions()}}

Other imagery utilities: 
\code{\link{esp_getTiles}()},
\code{\link{esp_make_provider}()},
\code{\link{esp_tiles_providers}}
}
\concept{imagery utilities}
