% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epmeans.R
\name{epmeans}
\alias{epmeans}
\title{EP-means Algorithm for Clustering Empirical Distributions}
\usage{
epmeans(elist, k = 2)
}
\arguments{
\item{elist}{a length \eqn{N} list of either vector or \code{ecdf} objects.}

\item{k}{the number of clusters.}
}
\value{
a named list containing \describe{
\item{cluster}{an integer vector indicating the cluster to which each \code{ecdf} is allocated.}
\item{centers}{a length \eqn{k} list of centroid \code{ecdf} objects.}
}
}
\description{
EP-means is a variant of k-means algorithm adapted to cluster 
multiple empirical cumulative distribution functions under metric structure 
induced by Earth Mover's Distance.
}
\examples{
## two sets of 1d samples, 10 each and add some noise
#    set 1 : mixture of two gaussians
#    set 2 : gamma 

# generate data
elist = list()
for (i in 1:10){
   elist[[i]] = stats::ecdf(c(rnorm(100, mean=-2), rnorm(50, mean=2)))
}
for (j in 11:20){
   elist[[j]] = stats::ecdf(rgamma(100,1) + rnorm(100, sd=sqrt(0.5)))
}

# run EP-means with k clusters 
# change the value below to see different settings
myk   = 2
epout = epmeans(elist, k=myk)

# visualize
opar = par(mfrow=c(1,myk))
for (k in 1:myk){
  idk = which(epout$cluster==k)
  for (i in 1:length(idk)){
    if (i<2){
      plot(elist[[idk[i]]], verticals=TRUE, lwd=0.25, do.points=FALSE, main=paste("class",k))
    } else {
      plot(elist[[idk[i]]], add=TRUE, verticals=TRUE, lwd=0.25, do.points=FALSE)
    }
    plot(epout$centers[[k]], add=TRUE, verticals=TRUE, lwd=2, col="red", do.points=FALSE)
  }
}
par(opar)

}
\references{
\insertRef{henderson_ep-means:_2015}{maotai}
}
