% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_fict.R
\docType{data}
\name{fict_friends}
\alias{fict_friends}
\title{One-mode undirected Friends character scene co-appearances (McNulty, 2020)}
\format{
\if{html}{\out{<div class="sourceCode">}}\preformatted{#> -- # Friends network -----------------------------------------------------------
#> # A labelled, weighted, undirected network of 650 characters and 2976 scene
#> co-appearance ties
#> 
#> -- Nodes
#> # A tibble: 650 x 1
#>   name        
#>   <chr>       
#> 1 Actor       
#> 2 Alan        
#> 3 Andrea      
#> 4 Angela      
#> 5 Aunt Iris   
#> 6 Aunt Lillian
#> # i 644 more rows
#> 
#> -- Ties
#> # A tibble: 2,976 x 3
#>    from    to weight
#>   <int> <int>  <dbl>
#> 1     8     9      3
#> 2     4    10      1
#> 3     8    12      1
#> 4     9    12      1
#> 5     2    14      1
#> 6     3    14      1
#> # i 2,970 more rows
#> 
}\if{html}{\out{</div>}}
}
\usage{
data(fict_friends)
}
\description{
One-mode network collected by \href{https://github.com/keithmcnulty/friends_analysis/}{McNulty (2020)}
on the connections between the Friends TV series characters
from Seasons 1 to 10.
The \code{fict_friends} is an undirected network
containing connections between characters organised by season number,
which is reflected in the tie attribute 'wave'.
The network contains 650 nodes
Each tie represents the connection between a character pair (appear in the same scene),
and the 'weight' of the tie is the number of scenes the character pair appears in together.
For all networks, characters are named (eg. Phoebe, Ross, Rachel).
}
\references{
McNulty, K. (2020).
\emph{Network analysis of Friends scripts.}.
}
\keyword{datasets}
