% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/manip_from.R
\name{from}
\alias{from}
\alias{from_subgraphs}
\alias{from_egos}
\alias{from_waves}
\alias{from_slices}
\alias{from_ties}
\title{Joining lists of networks, graphs, and matrices}
\usage{
from_subgraphs(netlist)

from_egos(netlist)

from_waves(netlist)

from_slices(netlist, remove.duplicates = FALSE)

from_ties(netlist, netnames)
}
\arguments{
\item{netlist}{A list of network, igraph, tidygraph, matrix, or edgelist objects.}

\item{remove.duplicates}{Should duplicates be removed?
By default FALSE.
If TRUE, duplicated edges are removed.}

\item{netnames}{A character vector of names for the different network objects,
if not already named within the list.}
}
\value{
A tidygraph object combining the list of network data.
}
\description{
These functions offer tools for joining lists of manynet-consistent objects
(matrices, igraph, tidygraph, or network objects) into a single object.
\itemize{
\item \code{from_subgraphs()} modifies a list of subgraphs into a single tidygraph.
\item \code{from_egos()} modifies a list of ego networks into a whole tidygraph
\item \code{from_waves()} modifies a list of network waves into a longitudinal tidygraph.
\item \code{from_slices()} modifies a list of time slices of a network into
a dynamic tidygraph.
\item \code{from_ties()} modifies a list of different ties into a multiplex tidygraph
}
}
\examples{
ison_adolescents \%>\%
  mutate(unicorn = sample(c("yes", "no"), 8, replace = TRUE)) \%>\%
  to_subgraphs(attribute = "unicorn") \%>\%
  from_subgraphs()
ison_adolescents \%>\%
  to_egos() \%>\%
  from_egos()
ison_adolescents \%>\%
  mutate_ties(wave = sample(1:4, 10, replace = TRUE)) \%>\%
  to_waves(attribute = "wave") \%>\%
  from_waves()
ison_adolescents \%>\%
  mutate_ties(time = 1:10, increment = 1) \%>\% 
  add_ties(c(1,2), list(time = 3, increment = -1)) \%>\% 
  to_slices(slice = c(5,7)) \%>\%
  from_slices()
}
\seealso{
Other modifications: 
\code{\link{add_nodes}()},
\code{\link{add_ties}()},
\code{\link{as}()},
\code{\link{miss}},
\code{\link{reformat}},
\code{\link{split}()},
\code{\link{to_levels}},
\code{\link{to_paths}},
\code{\link{to_project}},
\code{\link{to_scope}}
}
\concept{modifications}
