% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_properties.R
\name{properties}
\alias{properties}
\alias{network_nodes}
\alias{network_ties}
\alias{network_dims}
\alias{network_node_attributes}
\alias{network_tie_attributes}
\title{Describing network properties}
\usage{
network_nodes(.data)

network_ties(.data)

network_dims(.data)

network_node_attributes(.data)

network_tie_attributes(.data)
}
\arguments{
\item{.data}{An object of a manynet-consistent class:
\itemize{
\item matrix (adjacency or incidence) from \code{{base}} R
\item edgelist, a data frame from \code{{base}} R or tibble from \code{{tibble}}
\item igraph, from the \code{{igraph}} package
\item network, from the \code{{network}} package
\item tbl_graph, from the \code{{tidygraph}} package
}}
}
\value{
\verb{network_*()} functions always relate to the overall graph or network,
usually returning a scalar.
\code{network_dims()} returns an integer of the number of nodes in a one-mode network,
or two integers representing the number of nodes in each nodeset
in the case of a two-mode network.
\verb{network_*_attributes()} returns a string vector with the names
of all node or tie attributes in the network.
}
\description{
These functions extract certain attributes from given network data.
They are also useful as helpers within other functions.
}
\section{Functions}{
\itemize{
\item \code{network_nodes()}: Returns the total number of nodes (of any mode) in a network.

\item \code{network_ties()}: Returns the number of edges in a network.

\item \code{network_dims()}: Returns the dimensions of a network in a vector
as long as the number of modes in the network.

\item \code{network_node_attributes()}: Returns a vector of nodal attributes in a network

\item \code{network_tie_attributes()}: Returns a vector of edge attributes in a network

}}
\examples{
network_nodes(ison_southern_women)
network_ties(ison_southern_women)
network_dims(ison_southern_women)
network_dims(to_mode1(ison_southern_women))
  network_node_attributes(ison_lotr)
  network_tie_attributes(ison_algebra)
}
\seealso{
Other mapping: 
\code{\link{attributes}()},
\code{\link{auto_graph}},
\code{\link{is}()}
}
\concept{mapping}
