% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cond_indirect_diff.R
\name{print.cond_indirect_diff}
\alias{print.cond_indirect_diff}
\title{Print the Output of
'cond_indirect_diff'}
\usage{
\method{print}{cond_indirect_diff}(x, digits = 3, pvalue = FALSE, pvalue_digits = 3, ...)
}
\arguments{
\item{x}{The output of
\code{\link[=cond_indirect_diff]{cond_indirect_diff()}}.}

\item{digits}{The number of decimal
places in the printout.}

\item{pvalue}{Logical. If \code{TRUE},
asymmetric \emph{p}-value based on
bootstrapping will be printed if
available. Default is \code{FALSE.}}

\item{pvalue_digits}{Number of decimal
places to display for the \emph{p}-value.
Default is 3.}

\item{...}{Optional arguments.
Ignored.}
}
\value{
It returns \code{x} invisibly.
Called for its side effect.
}
\description{
Print the output of
\code{\link[=cond_indirect_diff]{cond_indirect_diff()}}.
}
\details{
The \code{print} method of the
\code{cond_indirect_diff}-class object.

If bootstrapping confidence interval
was requested, this method has the
option to print a
\emph{p}-value computed by the
method presented in Asparouhov and Muthén (2021).
Note that this \emph{p}-value is asymmetric
bootstrap \emph{p}-value based on the
distribution of the bootstrap estimates.
It is not computed based on the
distribution under the null hypothesis.

For a \emph{p}-value of \emph{a}, it means that
a 100(1 - \emph{a})\% bootstrapping confidence
interval
will have one of its limits equal to
0. A confidence interval
with a higher confidence level will
include zero, while a confidence
interval with a lower confidence level
will exclude zero.
}
\references{
Asparouhov, A., & Muthén, B. (2021). Bootstrap p-value computation.
Retrieved from https://www.statmodel.com/download/FAQ-Bootstrap\%20-\%20Pvalue.pdf
}
\seealso{
\code{\link[=cond_indirect_diff]{cond_indirect_diff()}}
}
