battles <- messydates::battles
test_that("report function work properly", {
  expect_error(mreport("a"), "Data must be a `data.frame` or `tibble`.")
  report <- mreport(battles)
  column <- c("Battle", "Date", "Parties", "US_party", "N_actors")
  type <- c("character", "mdate", "character", "numeric", "numeric")
  obs <- c(20, 20, 20, 20, 20)
  missing <- c(0, 0, 0, 0, 0)
  missingp <- c(0, 0, 0, 0, 0)
  names(type) <- c("Battle", "Date", "Parties", "US_party", "N_actors")
  names(obs) <- c("Battle", "Date", "Parties", "US_party", "N_actors")
  names(missing) <- c("Battle", "Date", "Parties", "US_party", "N_actors")
  names(missingp) <- c("Battle", "Date", "Parties", "US_party", "N_actors")
  expect_true(is.list(report))
  expect_s3_class(mreport(battles), "mreport")
  expect_equal(report$Rows, 20)
  expect_equal(report$Columns, 5)
  expect_equal(report$Variables, column)
  expect_equal(report$Types, type)
  expect_equal(report$Count, obs)
  expect_equal(report$Missing, missing)
  expect_equal(report$MissingPer, missingp)
  expect_length(mreport(battles), 7)
})
