// Generated by using Rcpp::compileAttributes() -> do not edit by hand
// Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#include "malan_types.h"
#include <RcppArmadillo.h>
#include <Rcpp.h>

using namespace Rcpp;

#ifdef RCPP_USE_GLOBAL_ROSTREAM
Rcpp::Rostream<true>&  Rcpp::Rcout = Rcpp::Rcpp_cout_get();
Rcpp::Rostream<false>& Rcpp::Rcerr = Rcpp::Rcpp_cerr_get();
#endif

// build_pedigrees
Rcpp::XPtr< std::vector<Pedigree*> > build_pedigrees(Rcpp::XPtr<Population> population, bool progress);
RcppExport SEXP _malan_build_pedigrees(SEXP populationSEXP, SEXP progressSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::XPtr<Population> >::type population(populationSEXP);
    Rcpp::traits::input_parameter< bool >::type progress(progressSEXP);
    rcpp_result_gen = Rcpp::wrap(build_pedigrees(population, progress));
    return rcpp_result_gen;
END_RCPP
}
// from_igraph_rcpp
Rcpp::XPtr<Population> from_igraph_rcpp(Rcpp::IntegerVector vertices, Rcpp::IntegerMatrix edges);
RcppExport SEXP _malan_from_igraph_rcpp(SEXP verticesSEXP, SEXP edgesSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::IntegerVector >::type vertices(verticesSEXP);
    Rcpp::traits::input_parameter< Rcpp::IntegerMatrix >::type edges(edgesSEXP);
    rcpp_result_gen = Rcpp::wrap(from_igraph_rcpp(vertices, edges));
    return rcpp_result_gen;
END_RCPP
}
// infer_generations
void infer_generations(Rcpp::XPtr< std::vector<Pedigree*> > peds);
RcppExport SEXP _malan_infer_generations(SEXP pedsSEXP) {
BEGIN_RCPP
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::XPtr< std::vector<Pedigree*> > >::type peds(pedsSEXP);
    infer_generations(peds);
    return R_NilValue;
END_RCPP
}
// load_individuals
Rcpp::XPtr<Population> load_individuals(IntegerVector pid, IntegerVector pid_dad, bool progress, bool error_on_pid_not_found);
RcppExport SEXP _malan_load_individuals(SEXP pidSEXP, SEXP pid_dadSEXP, SEXP progressSEXP, SEXP error_on_pid_not_foundSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< IntegerVector >::type pid(pidSEXP);
    Rcpp::traits::input_parameter< IntegerVector >::type pid_dad(pid_dadSEXP);
    Rcpp::traits::input_parameter< bool >::type progress(progressSEXP);
    Rcpp::traits::input_parameter< bool >::type error_on_pid_not_found(error_on_pid_not_foundSEXP);
    rcpp_result_gen = Rcpp::wrap(load_individuals(pid, pid_dad, progress, error_on_pid_not_found));
    return rcpp_result_gen;
END_RCPP
}
// load_haplotypes
void load_haplotypes(Rcpp::XPtr<Population> population, IntegerVector pid, IntegerMatrix haplotypes, bool progress);
RcppExport SEXP _malan_load_haplotypes(SEXP populationSEXP, SEXP pidSEXP, SEXP haplotypesSEXP, SEXP progressSEXP) {
BEGIN_RCPP
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::XPtr<Population> >::type population(populationSEXP);
    Rcpp::traits::input_parameter< IntegerVector >::type pid(pidSEXP);
    Rcpp::traits::input_parameter< IntegerMatrix >::type haplotypes(haplotypesSEXP);
    Rcpp::traits::input_parameter< bool >::type progress(progressSEXP);
    load_haplotypes(population, pid, haplotypes, progress);
    return R_NilValue;
END_RCPP
}
// infer_generation
void infer_generation(Rcpp::List final_generation);
RcppExport SEXP _malan_infer_generation(SEXP final_generationSEXP) {
BEGIN_RCPP
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::List >::type final_generation(final_generationSEXP);
    infer_generation(final_generation);
    return R_NilValue;
END_RCPP
}
// set_generation
void set_generation(Rcpp::XPtr<Individual> individual, int generation);
RcppExport SEXP _malan_set_generation(SEXP individualSEXP, SEXP generationSEXP) {
BEGIN_RCPP
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::XPtr<Individual> >::type individual(individualSEXP);
    Rcpp::traits::input_parameter< int >::type generation(generationSEXP);
    set_generation(individual, generation);
    return R_NilValue;
END_RCPP
}
// sample_geneology
List sample_geneology(size_t population_size, int generations, int generations_full, int generations_return, bool enable_gamma_variance_extension, double gamma_parameter_shape, double gamma_parameter_scale, bool progress, bool verbose_result);
RcppExport SEXP _malan_sample_geneology(SEXP population_sizeSEXP, SEXP generationsSEXP, SEXP generations_fullSEXP, SEXP generations_returnSEXP, SEXP enable_gamma_variance_extensionSEXP, SEXP gamma_parameter_shapeSEXP, SEXP gamma_parameter_scaleSEXP, SEXP progressSEXP, SEXP verbose_resultSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< size_t >::type population_size(population_sizeSEXP);
    Rcpp::traits::input_parameter< int >::type generations(generationsSEXP);
    Rcpp::traits::input_parameter< int >::type generations_full(generations_fullSEXP);
    Rcpp::traits::input_parameter< int >::type generations_return(generations_returnSEXP);
    Rcpp::traits::input_parameter< bool >::type enable_gamma_variance_extension(enable_gamma_variance_extensionSEXP);
    Rcpp::traits::input_parameter< double >::type gamma_parameter_shape(gamma_parameter_shapeSEXP);
    Rcpp::traits::input_parameter< double >::type gamma_parameter_scale(gamma_parameter_scaleSEXP);
    Rcpp::traits::input_parameter< bool >::type progress(progressSEXP);
    Rcpp::traits::input_parameter< bool >::type verbose_result(verbose_resultSEXP);
    rcpp_result_gen = Rcpp::wrap(sample_geneology(population_size, generations, generations_full, generations_return, enable_gamma_variance_extension, gamma_parameter_shape, gamma_parameter_scale, progress, verbose_result));
    return rcpp_result_gen;
END_RCPP
}
// sample_geneology_varying_size
List sample_geneology_varying_size(IntegerVector population_sizes, int generations_full, int generations_return, bool enable_gamma_variance_extension, double gamma_parameter_shape, double gamma_parameter_scale, bool progress);
RcppExport SEXP _malan_sample_geneology_varying_size(SEXP population_sizesSEXP, SEXP generations_fullSEXP, SEXP generations_returnSEXP, SEXP enable_gamma_variance_extensionSEXP, SEXP gamma_parameter_shapeSEXP, SEXP gamma_parameter_scaleSEXP, SEXP progressSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< IntegerVector >::type population_sizes(population_sizesSEXP);
    Rcpp::traits::input_parameter< int >::type generations_full(generations_fullSEXP);
    Rcpp::traits::input_parameter< int >::type generations_return(generations_returnSEXP);
    Rcpp::traits::input_parameter< bool >::type enable_gamma_variance_extension(enable_gamma_variance_extensionSEXP);
    Rcpp::traits::input_parameter< double >::type gamma_parameter_shape(gamma_parameter_shapeSEXP);
    Rcpp::traits::input_parameter< double >::type gamma_parameter_scale(gamma_parameter_scaleSEXP);
    Rcpp::traits::input_parameter< bool >::type progress(progressSEXP);
    rcpp_result_gen = Rcpp::wrap(sample_geneology_varying_size(population_sizes, generations_full, generations_return, enable_gamma_variance_extension, gamma_parameter_shape, gamma_parameter_scale, progress));
    return rcpp_result_gen;
END_RCPP
}
// calc_autosomal_genotype_probs
std::vector<double> calc_autosomal_genotype_probs(Rcpp::NumericVector allele_dist, double theta);
RcppExport SEXP _malan_calc_autosomal_genotype_probs(SEXP allele_distSEXP, SEXP thetaSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::NumericVector >::type allele_dist(allele_distSEXP);
    Rcpp::traits::input_parameter< double >::type theta(thetaSEXP);
    rcpp_result_gen = Rcpp::wrap(calc_autosomal_genotype_probs(allele_dist, theta));
    return rcpp_result_gen;
END_RCPP
}
// calc_autosomal_genotype_conditional_cumdist
Rcpp::NumericMatrix calc_autosomal_genotype_conditional_cumdist(Rcpp::NumericVector allele_dist, double theta);
RcppExport SEXP _malan_calc_autosomal_genotype_conditional_cumdist(SEXP allele_distSEXP, SEXP thetaSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::NumericVector >::type allele_dist(allele_distSEXP);
    Rcpp::traits::input_parameter< double >::type theta(thetaSEXP);
    rcpp_result_gen = Rcpp::wrap(calc_autosomal_genotype_conditional_cumdist(allele_dist, theta));
    return rcpp_result_gen;
END_RCPP
}
// sample_autosomal_genotype
std::vector<int> sample_autosomal_genotype(Rcpp::NumericVector allele_dist, double theta);
RcppExport SEXP _malan_sample_autosomal_genotype(SEXP allele_distSEXP, SEXP thetaSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::NumericVector >::type allele_dist(allele_distSEXP);
    Rcpp::traits::input_parameter< double >::type theta(thetaSEXP);
    rcpp_result_gen = Rcpp::wrap(sample_autosomal_genotype(allele_dist, theta));
    return rcpp_result_gen;
END_RCPP
}
// pedigrees_all_populate_autosomal
void pedigrees_all_populate_autosomal(Rcpp::XPtr< std::vector<Pedigree*> > pedigrees, Rcpp::NumericVector allele_dist, double theta, double mutation_rate, bool progress);
RcppExport SEXP _malan_pedigrees_all_populate_autosomal(SEXP pedigreesSEXP, SEXP allele_distSEXP, SEXP thetaSEXP, SEXP mutation_rateSEXP, SEXP progressSEXP) {
BEGIN_RCPP
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::XPtr< std::vector<Pedigree*> > >::type pedigrees(pedigreesSEXP);
    Rcpp::traits::input_parameter< Rcpp::NumericVector >::type allele_dist(allele_distSEXP);
    Rcpp::traits::input_parameter< double >::type theta(thetaSEXP);
    Rcpp::traits::input_parameter< double >::type mutation_rate(mutation_rateSEXP);
    Rcpp::traits::input_parameter< bool >::type progress(progressSEXP);
    pedigrees_all_populate_autosomal(pedigrees, allele_dist, theta, mutation_rate, progress);
    return R_NilValue;
END_RCPP
}
// population_populate_autosomal_infinite_alleles
void population_populate_autosomal_infinite_alleles(Rcpp::XPtr<Population> population, double mutation_rate, bool progress);
RcppExport SEXP _malan_population_populate_autosomal_infinite_alleles(SEXP populationSEXP, SEXP mutation_rateSEXP, SEXP progressSEXP) {
BEGIN_RCPP
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::XPtr<Population> >::type population(populationSEXP);
    Rcpp::traits::input_parameter< double >::type mutation_rate(mutation_rateSEXP);
    Rcpp::traits::input_parameter< bool >::type progress(progressSEXP);
    population_populate_autosomal_infinite_alleles(population, mutation_rate, progress);
    return R_NilValue;
END_RCPP
}
// estimate_autotheta_subpops_unweighted_genotypes
double estimate_autotheta_subpops_unweighted_genotypes(Rcpp::ListOf<Rcpp::IntegerMatrix> subpops, bool assume_HWE);
RcppExport SEXP _malan_estimate_autotheta_subpops_unweighted_genotypes(SEXP subpopsSEXP, SEXP assume_HWESEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::ListOf<Rcpp::IntegerMatrix> >::type subpops(subpopsSEXP);
    Rcpp::traits::input_parameter< bool >::type assume_HWE(assume_HWESEXP);
    rcpp_result_gen = Rcpp::wrap(estimate_autotheta_subpops_unweighted_genotypes(subpops, assume_HWE));
    return rcpp_result_gen;
END_RCPP
}
// estimate_autotheta_subpops_unweighted_pids
double estimate_autotheta_subpops_unweighted_pids(Rcpp::XPtr<Population> population, Rcpp::ListOf<Rcpp::IntegerVector> subpops, bool assume_HWE);
RcppExport SEXP _malan_estimate_autotheta_subpops_unweighted_pids(SEXP populationSEXP, SEXP subpopsSEXP, SEXP assume_HWESEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::XPtr<Population> >::type population(populationSEXP);
    Rcpp::traits::input_parameter< Rcpp::ListOf<Rcpp::IntegerVector> >::type subpops(subpopsSEXP);
    Rcpp::traits::input_parameter< bool >::type assume_HWE(assume_HWESEXP);
    rcpp_result_gen = Rcpp::wrap(estimate_autotheta_subpops_unweighted_pids(population, subpops, assume_HWE));
    return rcpp_result_gen;
END_RCPP
}
// get_allele_counts_genotypes
Rcpp::IntegerMatrix get_allele_counts_genotypes(Rcpp::ListOf<Rcpp::IntegerMatrix> subpops);
RcppExport SEXP _malan_get_allele_counts_genotypes(SEXP subpopsSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::ListOf<Rcpp::IntegerMatrix> >::type subpops(subpopsSEXP);
    rcpp_result_gen = Rcpp::wrap(get_allele_counts_genotypes(subpops));
    return rcpp_result_gen;
END_RCPP
}
// get_allele_counts_pids
Rcpp::IntegerMatrix get_allele_counts_pids(Rcpp::XPtr<Population> population, Rcpp::ListOf<Rcpp::IntegerVector> subpops);
RcppExport SEXP _malan_get_allele_counts_pids(SEXP populationSEXP, SEXP subpopsSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::XPtr<Population> >::type population(populationSEXP);
    Rcpp::traits::input_parameter< Rcpp::ListOf<Rcpp::IntegerVector> >::type subpops(subpopsSEXP);
    rcpp_result_gen = Rcpp::wrap(get_allele_counts_pids(population, subpops));
    return rcpp_result_gen;
END_RCPP
}
// hash_colisions
std::unordered_map<int, int> hash_colisions(int p);
RcppExport SEXP _malan_hash_colisions(SEXP pSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< int >::type p(pSEXP);
    rcpp_result_gen = Rcpp::wrap(hash_colisions(p));
    return rcpp_result_gen;
END_RCPP
}
// estimate_autotheta_1subpop_genotypes
Rcpp::List estimate_autotheta_1subpop_genotypes(Rcpp::IntegerMatrix genotypes, bool return_estimation_info);
RcppExport SEXP _malan_estimate_autotheta_1subpop_genotypes(SEXP genotypesSEXP, SEXP return_estimation_infoSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::IntegerMatrix >::type genotypes(genotypesSEXP);
    Rcpp::traits::input_parameter< bool >::type return_estimation_info(return_estimation_infoSEXP);
    rcpp_result_gen = Rcpp::wrap(estimate_autotheta_1subpop_genotypes(genotypes, return_estimation_info));
    return rcpp_result_gen;
END_RCPP
}
// estimate_autotheta_1subpop_individuals
Rcpp::List estimate_autotheta_1subpop_individuals(Rcpp::ListOf< Rcpp::XPtr<Individual> > individuals, bool return_estimation_info);
RcppExport SEXP _malan_estimate_autotheta_1subpop_individuals(SEXP individualsSEXP, SEXP return_estimation_infoSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::ListOf< Rcpp::XPtr<Individual> > >::type individuals(individualsSEXP);
    Rcpp::traits::input_parameter< bool >::type return_estimation_info(return_estimation_infoSEXP);
    rcpp_result_gen = Rcpp::wrap(estimate_autotheta_1subpop_individuals(individuals, return_estimation_info));
    return rcpp_result_gen;
END_RCPP
}
// estimate_autotheta_subpops_individuals
Rcpp::List estimate_autotheta_subpops_individuals(Rcpp::List subpops, Rcpp::IntegerVector subpops_sizes);
RcppExport SEXP _malan_estimate_autotheta_subpops_individuals(SEXP subpopsSEXP, SEXP subpops_sizesSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::List >::type subpops(subpopsSEXP);
    Rcpp::traits::input_parameter< Rcpp::IntegerVector >::type subpops_sizes(subpops_sizesSEXP);
    rcpp_result_gen = Rcpp::wrap(estimate_autotheta_subpops_individuals(subpops, subpops_sizes));
    return rcpp_result_gen;
END_RCPP
}
// estimate_autotheta_subpops_genotypes
Rcpp::List estimate_autotheta_subpops_genotypes(Rcpp::ListOf<Rcpp::IntegerMatrix> subpops, Rcpp::IntegerVector subpops_sizes);
RcppExport SEXP _malan_estimate_autotheta_subpops_genotypes(SEXP subpopsSEXP, SEXP subpops_sizesSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::ListOf<Rcpp::IntegerMatrix> >::type subpops(subpopsSEXP);
    Rcpp::traits::input_parameter< Rcpp::IntegerVector >::type subpops_sizes(subpops_sizesSEXP);
    rcpp_result_gen = Rcpp::wrap(estimate_autotheta_subpops_genotypes(subpops, subpops_sizes));
    return rcpp_result_gen;
END_RCPP
}
// estimate_autotheta_subpops_pids
Rcpp::List estimate_autotheta_subpops_pids(Rcpp::XPtr<Population> population, Rcpp::ListOf<Rcpp::IntegerVector> subpops, Rcpp::IntegerVector subpops_sizes);
RcppExport SEXP _malan_estimate_autotheta_subpops_pids(SEXP populationSEXP, SEXP subpopsSEXP, SEXP subpops_sizesSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::XPtr<Population> >::type population(populationSEXP);
    Rcpp::traits::input_parameter< Rcpp::ListOf<Rcpp::IntegerVector> >::type subpops(subpopsSEXP);
    Rcpp::traits::input_parameter< Rcpp::IntegerVector >::type subpops_sizes(subpops_sizesSEXP);
    rcpp_result_gen = Rcpp::wrap(estimate_autotheta_subpops_pids(population, subpops, subpops_sizes));
    return rcpp_result_gen;
END_RCPP
}
// pedigrees_all_populate_haplotypes
void pedigrees_all_populate_haplotypes(Rcpp::XPtr< std::vector<Pedigree*> > pedigrees, const int loci, const Rcpp::NumericVector& mutation_rates, const double prob_two_step, const double prob_genealogical_error, const bool progress);
RcppExport SEXP _malan_pedigrees_all_populate_haplotypes(SEXP pedigreesSEXP, SEXP lociSEXP, SEXP mutation_ratesSEXP, SEXP prob_two_stepSEXP, SEXP prob_genealogical_errorSEXP, SEXP progressSEXP) {
BEGIN_RCPP
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::XPtr< std::vector<Pedigree*> > >::type pedigrees(pedigreesSEXP);
    Rcpp::traits::input_parameter< const int >::type loci(lociSEXP);
    Rcpp::traits::input_parameter< const Rcpp::NumericVector& >::type mutation_rates(mutation_ratesSEXP);
    Rcpp::traits::input_parameter< const double >::type prob_two_step(prob_two_stepSEXP);
    Rcpp::traits::input_parameter< const double >::type prob_genealogical_error(prob_genealogical_errorSEXP);
    Rcpp::traits::input_parameter< const bool >::type progress(progressSEXP);
    pedigrees_all_populate_haplotypes(pedigrees, loci, mutation_rates, prob_two_step, prob_genealogical_error, progress);
    return R_NilValue;
END_RCPP
}
// pedigrees_all_populate_haplotypes_custom_founders
void pedigrees_all_populate_haplotypes_custom_founders(Rcpp::XPtr< std::vector<Pedigree*> > pedigrees, const Rcpp::NumericVector mutation_rates, const Rcpp::Nullable<Rcpp::Function>& get_founder_haplotype, const double prob_two_step, const double prob_genealogical_error, const bool progress);
RcppExport SEXP _malan_pedigrees_all_populate_haplotypes_custom_founders(SEXP pedigreesSEXP, SEXP mutation_ratesSEXP, SEXP get_founder_haplotypeSEXP, SEXP prob_two_stepSEXP, SEXP prob_genealogical_errorSEXP, SEXP progressSEXP) {
BEGIN_RCPP
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::XPtr< std::vector<Pedigree*> > >::type pedigrees(pedigreesSEXP);
    Rcpp::traits::input_parameter< const Rcpp::NumericVector >::type mutation_rates(mutation_ratesSEXP);
    Rcpp::traits::input_parameter< const Rcpp::Nullable<Rcpp::Function>& >::type get_founder_haplotype(get_founder_haplotypeSEXP);
    Rcpp::traits::input_parameter< const double >::type prob_two_step(prob_two_stepSEXP);
    Rcpp::traits::input_parameter< const double >::type prob_genealogical_error(prob_genealogical_errorSEXP);
    Rcpp::traits::input_parameter< const bool >::type progress(progressSEXP);
    pedigrees_all_populate_haplotypes_custom_founders(pedigrees, mutation_rates, get_founder_haplotype, prob_two_step, prob_genealogical_error, progress);
    return R_NilValue;
END_RCPP
}
// pedigrees_all_populate_haplotypes_ladder_bounded
void pedigrees_all_populate_haplotypes_ladder_bounded(Rcpp::XPtr< std::vector<Pedigree*> > pedigrees, const Rcpp::NumericVector& mutation_rates, const Rcpp::IntegerVector& ladder_min, const Rcpp::IntegerVector& ladder_max, const Rcpp::Nullable<Rcpp::Function>& get_founder_haplotype, const double prob_two_step, const double prob_genealogical_error, const bool progress);
RcppExport SEXP _malan_pedigrees_all_populate_haplotypes_ladder_bounded(SEXP pedigreesSEXP, SEXP mutation_ratesSEXP, SEXP ladder_minSEXP, SEXP ladder_maxSEXP, SEXP get_founder_haplotypeSEXP, SEXP prob_two_stepSEXP, SEXP prob_genealogical_errorSEXP, SEXP progressSEXP) {
BEGIN_RCPP
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::XPtr< std::vector<Pedigree*> > >::type pedigrees(pedigreesSEXP);
    Rcpp::traits::input_parameter< const Rcpp::NumericVector& >::type mutation_rates(mutation_ratesSEXP);
    Rcpp::traits::input_parameter< const Rcpp::IntegerVector& >::type ladder_min(ladder_minSEXP);
    Rcpp::traits::input_parameter< const Rcpp::IntegerVector& >::type ladder_max(ladder_maxSEXP);
    Rcpp::traits::input_parameter< const Rcpp::Nullable<Rcpp::Function>& >::type get_founder_haplotype(get_founder_haplotypeSEXP);
    Rcpp::traits::input_parameter< const double >::type prob_two_step(prob_two_stepSEXP);
    Rcpp::traits::input_parameter< const double >::type prob_genealogical_error(prob_genealogical_errorSEXP);
    Rcpp::traits::input_parameter< const bool >::type progress(progressSEXP);
    pedigrees_all_populate_haplotypes_ladder_bounded(pedigrees, mutation_rates, ladder_min, ladder_max, get_founder_haplotype, prob_two_step, prob_genealogical_error, progress);
    return R_NilValue;
END_RCPP
}
// get_haplotype
std::vector<int> get_haplotype(Rcpp::XPtr<Individual> individual);
RcppExport SEXP _malan_get_haplotype(SEXP individualSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::XPtr<Individual> >::type individual(individualSEXP);
    rcpp_result_gen = Rcpp::wrap(get_haplotype(individual));
    return rcpp_result_gen;
END_RCPP
}
// get_haplotypes_individuals
Rcpp::IntegerMatrix get_haplotypes_individuals(Rcpp::ListOf< Rcpp::XPtr<Individual> > individuals);
RcppExport SEXP _malan_get_haplotypes_individuals(SEXP individualsSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::ListOf< Rcpp::XPtr<Individual> > >::type individuals(individualsSEXP);
    rcpp_result_gen = Rcpp::wrap(get_haplotypes_individuals(individuals));
    return rcpp_result_gen;
END_RCPP
}
// get_haplotypes_pids
Rcpp::IntegerMatrix get_haplotypes_pids(Rcpp::XPtr<Population> population, Rcpp::IntegerVector pids);
RcppExport SEXP _malan_get_haplotypes_pids(SEXP populationSEXP, SEXP pidsSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::XPtr<Population> >::type population(populationSEXP);
    Rcpp::traits::input_parameter< Rcpp::IntegerVector >::type pids(pidsSEXP);
    rcpp_result_gen = Rcpp::wrap(get_haplotypes_pids(population, pids));
    return rcpp_result_gen;
END_RCPP
}
// count_haplotype_occurrences_individuals
int count_haplotype_occurrences_individuals(const Rcpp::List individuals, const Rcpp::IntegerVector haplotype);
RcppExport SEXP _malan_count_haplotype_occurrences_individuals(SEXP individualsSEXP, SEXP haplotypeSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< const Rcpp::List >::type individuals(individualsSEXP);
    Rcpp::traits::input_parameter< const Rcpp::IntegerVector >::type haplotype(haplotypeSEXP);
    rcpp_result_gen = Rcpp::wrap(count_haplotype_occurrences_individuals(individuals, haplotype));
    return rcpp_result_gen;
END_RCPP
}
// count_haplotype_near_matches_individuals
int count_haplotype_near_matches_individuals(const Rcpp::List individuals, const Rcpp::IntegerVector haplotype, const int max_dist);
RcppExport SEXP _malan_count_haplotype_near_matches_individuals(SEXP individualsSEXP, SEXP haplotypeSEXP, SEXP max_distSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< const Rcpp::List >::type individuals(individualsSEXP);
    Rcpp::traits::input_parameter< const Rcpp::IntegerVector >::type haplotype(haplotypeSEXP);
    Rcpp::traits::input_parameter< const int >::type max_dist(max_distSEXP);
    rcpp_result_gen = Rcpp::wrap(count_haplotype_near_matches_individuals(individuals, haplotype, max_dist));
    return rcpp_result_gen;
END_RCPP
}
// haplotype_matches_individuals
Rcpp::List haplotype_matches_individuals(const Rcpp::List individuals, const Rcpp::IntegerVector haplotype);
RcppExport SEXP _malan_haplotype_matches_individuals(SEXP individualsSEXP, SEXP haplotypeSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< const Rcpp::List >::type individuals(individualsSEXP);
    Rcpp::traits::input_parameter< const Rcpp::IntegerVector >::type haplotype(haplotypeSEXP);
    rcpp_result_gen = Rcpp::wrap(haplotype_matches_individuals(individuals, haplotype));
    return rcpp_result_gen;
END_RCPP
}
// count_haplotype_occurrences_pedigree
int count_haplotype_occurrences_pedigree(Rcpp::XPtr<Pedigree> pedigree, const Rcpp::IntegerVector haplotype, int generation_upper_bound_in_result);
RcppExport SEXP _malan_count_haplotype_occurrences_pedigree(SEXP pedigreeSEXP, SEXP haplotypeSEXP, SEXP generation_upper_bound_in_resultSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::XPtr<Pedigree> >::type pedigree(pedigreeSEXP);
    Rcpp::traits::input_parameter< const Rcpp::IntegerVector >::type haplotype(haplotypeSEXP);
    Rcpp::traits::input_parameter< int >::type generation_upper_bound_in_result(generation_upper_bound_in_resultSEXP);
    rcpp_result_gen = Rcpp::wrap(count_haplotype_occurrences_pedigree(pedigree, haplotype, generation_upper_bound_in_result));
    return rcpp_result_gen;
END_RCPP
}
// pedigree_haplotype_matches_in_pedigree_meiosis_L1_dists
Rcpp::IntegerMatrix pedigree_haplotype_matches_in_pedigree_meiosis_L1_dists(const Rcpp::XPtr<Individual> suspect, int generation_upper_bound_in_result, bool error_on_no_haplotype);
RcppExport SEXP _malan_pedigree_haplotype_matches_in_pedigree_meiosis_L1_dists(SEXP suspectSEXP, SEXP generation_upper_bound_in_resultSEXP, SEXP error_on_no_haplotypeSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< const Rcpp::XPtr<Individual> >::type suspect(suspectSEXP);
    Rcpp::traits::input_parameter< int >::type generation_upper_bound_in_result(generation_upper_bound_in_resultSEXP);
    Rcpp::traits::input_parameter< bool >::type error_on_no_haplotype(error_on_no_haplotypeSEXP);
    rcpp_result_gen = Rcpp::wrap(pedigree_haplotype_matches_in_pedigree_meiosis_L1_dists(suspect, generation_upper_bound_in_result, error_on_no_haplotype));
    return rcpp_result_gen;
END_RCPP
}
// pedigree_haplotype_near_matches_meiosis
Rcpp::IntegerMatrix pedigree_haplotype_near_matches_meiosis(const Rcpp::XPtr<Individual> suspect, const int max_dist, int generation_upper_bound_in_result);
RcppExport SEXP _malan_pedigree_haplotype_near_matches_meiosis(SEXP suspectSEXP, SEXP max_distSEXP, SEXP generation_upper_bound_in_resultSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< const Rcpp::XPtr<Individual> >::type suspect(suspectSEXP);
    Rcpp::traits::input_parameter< const int >::type max_dist(max_distSEXP);
    Rcpp::traits::input_parameter< int >::type generation_upper_bound_in_result(generation_upper_bound_in_resultSEXP);
    rcpp_result_gen = Rcpp::wrap(pedigree_haplotype_near_matches_meiosis(suspect, max_dist, generation_upper_bound_in_result));
    return rcpp_result_gen;
END_RCPP
}
// meiotic_dist
int meiotic_dist(Rcpp::XPtr<Individual> ind1, Rcpp::XPtr<Individual> ind2);
RcppExport SEXP _malan_meiotic_dist(SEXP ind1SEXP, SEXP ind2SEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::XPtr<Individual> >::type ind1(ind1SEXP);
    Rcpp::traits::input_parameter< Rcpp::XPtr<Individual> >::type ind2(ind2SEXP);
    rcpp_result_gen = Rcpp::wrap(meiotic_dist(ind1, ind2));
    return rcpp_result_gen;
END_RCPP
}
// meiotic_dist_threshold
int meiotic_dist_threshold(Rcpp::XPtr<Individual> ind1, Rcpp::XPtr<Individual> ind2, int threshold);
RcppExport SEXP _malan_meiotic_dist_threshold(SEXP ind1SEXP, SEXP ind2SEXP, SEXP thresholdSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::XPtr<Individual> >::type ind1(ind1SEXP);
    Rcpp::traits::input_parameter< Rcpp::XPtr<Individual> >::type ind2(ind2SEXP);
    Rcpp::traits::input_parameter< int >::type threshold(thresholdSEXP);
    rcpp_result_gen = Rcpp::wrap(meiotic_dist_threshold(ind1, ind2, threshold));
    return rcpp_result_gen;
END_RCPP
}
// meiotic_radius
Rcpp::IntegerMatrix meiotic_radius(Rcpp::XPtr<Individual> ind, int radius);
RcppExport SEXP _malan_meiotic_radius(SEXP indSEXP, SEXP radiusSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::XPtr<Individual> >::type ind(indSEXP);
    Rcpp::traits::input_parameter< int >::type radius(radiusSEXP);
    rcpp_result_gen = Rcpp::wrap(meiotic_radius(ind, radius));
    return rcpp_result_gen;
END_RCPP
}
// haplotypes_to_hashes
Rcpp::IntegerVector haplotypes_to_hashes(Rcpp::XPtr<Population> population, Rcpp::IntegerVector pids);
RcppExport SEXP _malan_haplotypes_to_hashes(SEXP populationSEXP, SEXP pidsSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::XPtr<Population> >::type population(populationSEXP);
    Rcpp::traits::input_parameter< Rcpp::IntegerVector >::type pids(pidsSEXP);
    rcpp_result_gen = Rcpp::wrap(haplotypes_to_hashes(population, pids));
    return rcpp_result_gen;
END_RCPP
}
// split_by_haplotypes
Rcpp::List split_by_haplotypes(Rcpp::XPtr<Population> population, Rcpp::IntegerVector pids);
RcppExport SEXP _malan_split_by_haplotypes(SEXP populationSEXP, SEXP pidsSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::XPtr<Population> >::type population(populationSEXP);
    Rcpp::traits::input_parameter< Rcpp::IntegerVector >::type pids(pidsSEXP);
    rcpp_result_gen = Rcpp::wrap(split_by_haplotypes(population, pids));
    return rcpp_result_gen;
END_RCPP
}
// haplotype_partially_matches_individuals
Rcpp::List haplotype_partially_matches_individuals(const Rcpp::List individuals, const Rcpp::IntegerVector haplotype, const Rcpp::IntegerVector ignore_loci);
RcppExport SEXP _malan_haplotype_partially_matches_individuals(SEXP individualsSEXP, SEXP haplotypeSEXP, SEXP ignore_lociSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< const Rcpp::List >::type individuals(individualsSEXP);
    Rcpp::traits::input_parameter< const Rcpp::IntegerVector >::type haplotype(haplotypeSEXP);
    Rcpp::traits::input_parameter< const Rcpp::IntegerVector >::type ignore_loci(ignore_lociSEXP);
    rcpp_result_gen = Rcpp::wrap(haplotype_partially_matches_individuals(individuals, haplotype, ignore_loci));
    return rcpp_result_gen;
END_RCPP
}
// build_haplotype_hashmap
Rcpp::XPtr< std::unordered_map< std::vector<int>, std::vector<int>* > > build_haplotype_hashmap(const Rcpp::List& individuals, bool progress);
RcppExport SEXP _malan_build_haplotype_hashmap(SEXP individualsSEXP, SEXP progressSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< const Rcpp::List& >::type individuals(individualsSEXP);
    Rcpp::traits::input_parameter< bool >::type progress(progressSEXP);
    rcpp_result_gen = Rcpp::wrap(build_haplotype_hashmap(individuals, progress));
    return rcpp_result_gen;
END_RCPP
}
// delete_haplotypeids_hashmap
void delete_haplotypeids_hashmap(Rcpp::XPtr< std::unordered_map< std::vector<int>, std::vector<int>* > > hashmap);
RcppExport SEXP _malan_delete_haplotypeids_hashmap(SEXP hashmapSEXP) {
BEGIN_RCPP
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::XPtr< std::unordered_map< std::vector<int>, std::vector<int>* > > >::type hashmap(hashmapSEXP);
    delete_haplotypeids_hashmap(hashmap);
    return R_NilValue;
END_RCPP
}
// get_matching_pids_from_hashmap
Rcpp::IntegerVector get_matching_pids_from_hashmap(const Rcpp::XPtr< std::unordered_map< std::vector<int>, std::vector<int>* > >& hashmap, const Rcpp::IntegerVector haplotype);
RcppExport SEXP _malan_get_matching_pids_from_hashmap(SEXP hashmapSEXP, SEXP haplotypeSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< const Rcpp::XPtr< std::unordered_map< std::vector<int>, std::vector<int>* > >& >::type hashmap(hashmapSEXP);
    Rcpp::traits::input_parameter< const Rcpp::IntegerVector >::type haplotype(haplotypeSEXP);
    rcpp_result_gen = Rcpp::wrap(get_matching_pids_from_hashmap(hashmap, haplotype));
    return rcpp_result_gen;
END_RCPP
}
// get_individual
Rcpp::XPtr<Individual> get_individual(Rcpp::XPtr<Population> population, int pid);
RcppExport SEXP _malan_get_individual(SEXP populationSEXP, SEXP pidSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::XPtr<Population> >::type population(populationSEXP);
    Rcpp::traits::input_parameter< int >::type pid(pidSEXP);
    rcpp_result_gen = Rcpp::wrap(get_individual(population, pid));
    return rcpp_result_gen;
END_RCPP
}
// get_pid
int get_pid(Rcpp::XPtr<Individual> individual);
RcppExport SEXP _malan_get_pid(SEXP individualSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::XPtr<Individual> >::type individual(individualSEXP);
    rcpp_result_gen = Rcpp::wrap(get_pid(individual));
    return rcpp_result_gen;
END_RCPP
}
// print_individual
void print_individual(Rcpp::XPtr<Individual> individual);
RcppExport SEXP _malan_print_individual(SEXP individualSEXP) {
BEGIN_RCPP
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::XPtr<Individual> >::type individual(individualSEXP);
    print_individual(individual);
    return R_NilValue;
END_RCPP
}
// get_generation
int get_generation(Rcpp::XPtr<Individual> individual);
RcppExport SEXP _malan_get_generation(SEXP individualSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::XPtr<Individual> >::type individual(individualSEXP);
    rcpp_result_gen = Rcpp::wrap(get_generation(individual));
    return rcpp_result_gen;
END_RCPP
}
// get_pedigree_from_individual
Rcpp::XPtr<Pedigree> get_pedigree_from_individual(Rcpp::XPtr<Individual> individual);
RcppExport SEXP _malan_get_pedigree_from_individual(SEXP individualSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::XPtr<Individual> >::type individual(individualSEXP);
    rcpp_result_gen = Rcpp::wrap(get_pedigree_from_individual(individual));
    return rcpp_result_gen;
END_RCPP
}
// get_pedigree_id_from_pid
Rcpp::IntegerVector get_pedigree_id_from_pid(Rcpp::XPtr<Population> population, Rcpp::IntegerVector pids);
RcppExport SEXP _malan_get_pedigree_id_from_pid(SEXP populationSEXP, SEXP pidsSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::XPtr<Population> >::type population(populationSEXP);
    Rcpp::traits::input_parameter< Rcpp::IntegerVector >::type pids(pidsSEXP);
    rcpp_result_gen = Rcpp::wrap(get_pedigree_id_from_pid(population, pids));
    return rcpp_result_gen;
END_RCPP
}
// get_family_info
Rcpp::List get_family_info(Rcpp::XPtr<Individual> individual);
RcppExport SEXP _malan_get_family_info(SEXP individualSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::XPtr<Individual> >::type individual(individualSEXP);
    rcpp_result_gen = Rcpp::wrap(get_family_info(individual));
    return rcpp_result_gen;
END_RCPP
}
// get_father
Rcpp::XPtr<Individual> get_father(Rcpp::XPtr<Individual> individual);
RcppExport SEXP _malan_get_father(SEXP individualSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::XPtr<Individual> >::type individual(individualSEXP);
    rcpp_result_gen = Rcpp::wrap(get_father(individual));
    return rcpp_result_gen;
END_RCPP
}
// get_children
Rcpp::List get_children(Rcpp::XPtr<Individual> individual);
RcppExport SEXP _malan_get_children(SEXP individualSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::XPtr<Individual> >::type individual(individualSEXP);
    rcpp_result_gen = Rcpp::wrap(get_children(individual));
    return rcpp_result_gen;
END_RCPP
}
// count_brothers
int count_brothers(Rcpp::XPtr<Individual> individual);
RcppExport SEXP _malan_count_brothers(SEXP individualSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::XPtr<Individual> >::type individual(individualSEXP);
    rcpp_result_gen = Rcpp::wrap(count_brothers(individual));
    return rcpp_result_gen;
END_RCPP
}
// get_brothers
Rcpp::List get_brothers(Rcpp::XPtr<Individual> individual);
RcppExport SEXP _malan_get_brothers(SEXP individualSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::XPtr<Individual> >::type individual(individualSEXP);
    rcpp_result_gen = Rcpp::wrap(get_brothers(individual));
    return rcpp_result_gen;
END_RCPP
}
// brothers_matching
int brothers_matching(Rcpp::XPtr<Individual> individual);
RcppExport SEXP _malan_brothers_matching(SEXP individualSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::XPtr<Individual> >::type individual(individualSEXP);
    rcpp_result_gen = Rcpp::wrap(brothers_matching(individual));
    return rcpp_result_gen;
END_RCPP
}
// father_matches
bool father_matches(Rcpp::XPtr<Individual> individual);
RcppExport SEXP _malan_father_matches(SEXP individualSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::XPtr<Individual> >::type individual(individualSEXP);
    rcpp_result_gen = Rcpp::wrap(father_matches(individual));
    return rcpp_result_gen;
END_RCPP
}
// grandfather_matches
bool grandfather_matches(Rcpp::XPtr<Individual> individual);
RcppExport SEXP _malan_grandfather_matches(SEXP individualSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::XPtr<Individual> >::type individual(individualSEXP);
    rcpp_result_gen = Rcpp::wrap(grandfather_matches(individual));
    return rcpp_result_gen;
END_RCPP
}
// count_uncles
int count_uncles(Rcpp::XPtr<Individual> individual);
RcppExport SEXP _malan_count_uncles(SEXP individualSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::XPtr<Individual> >::type individual(individualSEXP);
    rcpp_result_gen = Rcpp::wrap(count_uncles(individual));
    return rcpp_result_gen;
END_RCPP
}
// get_uncles
Rcpp::List get_uncles(Rcpp::XPtr<Individual> individual);
RcppExport SEXP _malan_get_uncles(SEXP individualSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::XPtr<Individual> >::type individual(individualSEXP);
    rcpp_result_gen = Rcpp::wrap(get_uncles(individual));
    return rcpp_result_gen;
END_RCPP
}
// get_cousins
Rcpp::List get_cousins(Rcpp::XPtr<Individual> individual);
RcppExport SEXP _malan_get_cousins(SEXP individualSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::XPtr<Individual> >::type individual(individualSEXP);
    rcpp_result_gen = Rcpp::wrap(get_cousins(individual));
    return rcpp_result_gen;
END_RCPP
}
// pop_size
int pop_size(Rcpp::XPtr<Population> population);
RcppExport SEXP _malan_pop_size(SEXP populationSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::XPtr<Population> >::type population(populationSEXP);
    rcpp_result_gen = Rcpp::wrap(pop_size(population));
    return rcpp_result_gen;
END_RCPP
}
// get_individuals
Rcpp::ListOf< Rcpp::XPtr<Individual> > get_individuals(Rcpp::XPtr<Population> population);
RcppExport SEXP _malan_get_individuals(SEXP populationSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::XPtr<Population> >::type population(populationSEXP);
    rcpp_result_gen = Rcpp::wrap(get_individuals(population));
    return rcpp_result_gen;
END_RCPP
}
// meioses_generation_distribution
Rcpp::IntegerMatrix meioses_generation_distribution(Rcpp::XPtr<Individual> individual, int generation_upper_bound_in_result);
RcppExport SEXP _malan_meioses_generation_distribution(SEXP individualSEXP, SEXP generation_upper_bound_in_resultSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::XPtr<Individual> >::type individual(individualSEXP);
    Rcpp::traits::input_parameter< int >::type generation_upper_bound_in_result(generation_upper_bound_in_resultSEXP);
    rcpp_result_gen = Rcpp::wrap(meioses_generation_distribution(individual, generation_upper_bound_in_result));
    return rcpp_result_gen;
END_RCPP
}
// population_size_generation
int population_size_generation(Rcpp::XPtr<Population> population, int generation_upper_bound_in_result);
RcppExport SEXP _malan_population_size_generation(SEXP populationSEXP, SEXP generation_upper_bound_in_resultSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::XPtr<Population> >::type population(populationSEXP);
    Rcpp::traits::input_parameter< int >::type generation_upper_bound_in_result(generation_upper_bound_in_resultSEXP);
    rcpp_result_gen = Rcpp::wrap(population_size_generation(population, generation_upper_bound_in_result));
    return rcpp_result_gen;
END_RCPP
}
// pedigree_size_generation
int pedigree_size_generation(Rcpp::XPtr<Pedigree> pedigree, int generation_upper_bound_in_result);
RcppExport SEXP _malan_pedigree_size_generation(SEXP pedigreeSEXP, SEXP generation_upper_bound_in_resultSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::XPtr<Pedigree> >::type pedigree(pedigreeSEXP);
    Rcpp::traits::input_parameter< int >::type generation_upper_bound_in_result(generation_upper_bound_in_resultSEXP);
    rcpp_result_gen = Rcpp::wrap(pedigree_size_generation(pedigree, generation_upper_bound_in_result));
    return rcpp_result_gen;
END_RCPP
}
// mixture_info_by_individuals_2pers
Rcpp::List mixture_info_by_individuals_2pers(const Rcpp::List individuals, Rcpp::XPtr<Individual>& donor1, Rcpp::XPtr<Individual>& donor2, bool include_genealogy_info);
RcppExport SEXP _malan_mixture_info_by_individuals_2pers(SEXP individualsSEXP, SEXP donor1SEXP, SEXP donor2SEXP, SEXP include_genealogy_infoSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< const Rcpp::List >::type individuals(individualsSEXP);
    Rcpp::traits::input_parameter< Rcpp::XPtr<Individual>& >::type donor1(donor1SEXP);
    Rcpp::traits::input_parameter< Rcpp::XPtr<Individual>& >::type donor2(donor2SEXP);
    Rcpp::traits::input_parameter< bool >::type include_genealogy_info(include_genealogy_infoSEXP);
    rcpp_result_gen = Rcpp::wrap(mixture_info_by_individuals_2pers(individuals, donor1, donor2, include_genealogy_info));
    return rcpp_result_gen;
END_RCPP
}
// mixture_info_by_individuals_3pers
Rcpp::List mixture_info_by_individuals_3pers(const Rcpp::List individuals, Rcpp::XPtr<Individual>& donor1, Rcpp::XPtr<Individual>& donor2, Rcpp::XPtr<Individual>& donor3);
RcppExport SEXP _malan_mixture_info_by_individuals_3pers(SEXP individualsSEXP, SEXP donor1SEXP, SEXP donor2SEXP, SEXP donor3SEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< const Rcpp::List >::type individuals(individualsSEXP);
    Rcpp::traits::input_parameter< Rcpp::XPtr<Individual>& >::type donor1(donor1SEXP);
    Rcpp::traits::input_parameter< Rcpp::XPtr<Individual>& >::type donor2(donor2SEXP);
    Rcpp::traits::input_parameter< Rcpp::XPtr<Individual>& >::type donor3(donor3SEXP);
    rcpp_result_gen = Rcpp::wrap(mixture_info_by_individuals_3pers(individuals, donor1, donor2, donor3));
    return rcpp_result_gen;
END_RCPP
}
// mixture_info_by_individuals_4pers
Rcpp::List mixture_info_by_individuals_4pers(const Rcpp::List individuals, Rcpp::XPtr<Individual>& donor1, Rcpp::XPtr<Individual>& donor2, Rcpp::XPtr<Individual>& donor3, Rcpp::XPtr<Individual>& donor4);
RcppExport SEXP _malan_mixture_info_by_individuals_4pers(SEXP individualsSEXP, SEXP donor1SEXP, SEXP donor2SEXP, SEXP donor3SEXP, SEXP donor4SEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< const Rcpp::List >::type individuals(individualsSEXP);
    Rcpp::traits::input_parameter< Rcpp::XPtr<Individual>& >::type donor1(donor1SEXP);
    Rcpp::traits::input_parameter< Rcpp::XPtr<Individual>& >::type donor2(donor2SEXP);
    Rcpp::traits::input_parameter< Rcpp::XPtr<Individual>& >::type donor3(donor3SEXP);
    Rcpp::traits::input_parameter< Rcpp::XPtr<Individual>& >::type donor4(donor4SEXP);
    rcpp_result_gen = Rcpp::wrap(mixture_info_by_individuals_4pers(individuals, donor1, donor2, donor3, donor4));
    return rcpp_result_gen;
END_RCPP
}
// mixture_info_by_individuals_5pers
Rcpp::List mixture_info_by_individuals_5pers(const Rcpp::List individuals, Rcpp::XPtr<Individual>& donor1, Rcpp::XPtr<Individual>& donor2, Rcpp::XPtr<Individual>& donor3, Rcpp::XPtr<Individual>& donor4, Rcpp::XPtr<Individual>& donor5);
RcppExport SEXP _malan_mixture_info_by_individuals_5pers(SEXP individualsSEXP, SEXP donor1SEXP, SEXP donor2SEXP, SEXP donor3SEXP, SEXP donor4SEXP, SEXP donor5SEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< const Rcpp::List >::type individuals(individualsSEXP);
    Rcpp::traits::input_parameter< Rcpp::XPtr<Individual>& >::type donor1(donor1SEXP);
    Rcpp::traits::input_parameter< Rcpp::XPtr<Individual>& >::type donor2(donor2SEXP);
    Rcpp::traits::input_parameter< Rcpp::XPtr<Individual>& >::type donor3(donor3SEXP);
    Rcpp::traits::input_parameter< Rcpp::XPtr<Individual>& >::type donor4(donor4SEXP);
    Rcpp::traits::input_parameter< Rcpp::XPtr<Individual>& >::type donor5(donor5SEXP);
    rcpp_result_gen = Rcpp::wrap(mixture_info_by_individuals_5pers(individuals, donor1, donor2, donor3, donor4, donor5));
    return rcpp_result_gen;
END_RCPP
}
// analyse_mixture_result
Rcpp::List analyse_mixture_result(Rcpp::List& mix_res, const Rcpp::List& unique_haps_in_mixture, const Rcpp::List& unique_haps_in_mixture_counts);
RcppExport SEXP _malan_analyse_mixture_result(SEXP mix_resSEXP, SEXP unique_haps_in_mixtureSEXP, SEXP unique_haps_in_mixture_countsSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::List& >::type mix_res(mix_resSEXP);
    Rcpp::traits::input_parameter< const Rcpp::List& >::type unique_haps_in_mixture(unique_haps_in_mixtureSEXP);
    Rcpp::traits::input_parameter< const Rcpp::List& >::type unique_haps_in_mixture_counts(unique_haps_in_mixture_countsSEXP);
    rcpp_result_gen = Rcpp::wrap(analyse_mixture_result(mix_res, unique_haps_in_mixture, unique_haps_in_mixture_counts));
    return rcpp_result_gen;
END_RCPP
}
// analyse_mixture_results
Rcpp::List analyse_mixture_results(Rcpp::List& mixture_results, const Rcpp::List& unique_haps_in_mixture_list, const Rcpp::List& unique_haps_in_mixture_counts_list);
RcppExport SEXP _malan_analyse_mixture_results(SEXP mixture_resultsSEXP, SEXP unique_haps_in_mixture_listSEXP, SEXP unique_haps_in_mixture_counts_listSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::List& >::type mixture_results(mixture_resultsSEXP);
    Rcpp::traits::input_parameter< const Rcpp::List& >::type unique_haps_in_mixture_list(unique_haps_in_mixture_listSEXP);
    Rcpp::traits::input_parameter< const Rcpp::List& >::type unique_haps_in_mixture_counts_list(unique_haps_in_mixture_counts_listSEXP);
    rcpp_result_gen = Rcpp::wrap(analyse_mixture_results(mixture_results, unique_haps_in_mixture_list, unique_haps_in_mixture_counts_list));
    return rcpp_result_gen;
END_RCPP
}
// get_pedigree_id
int get_pedigree_id(Rcpp::XPtr<Pedigree> ped);
RcppExport SEXP _malan_get_pedigree_id(SEXP pedSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::XPtr<Pedigree> >::type ped(pedSEXP);
    rcpp_result_gen = Rcpp::wrap(get_pedigree_id(ped));
    return rcpp_result_gen;
END_RCPP
}
// pedigrees_count
int pedigrees_count(Rcpp::XPtr< std::vector<Pedigree*> > pedigrees);
RcppExport SEXP _malan_pedigrees_count(SEXP pedigreesSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::XPtr< std::vector<Pedigree*> > >::type pedigrees(pedigreesSEXP);
    rcpp_result_gen = Rcpp::wrap(pedigrees_count(pedigrees));
    return rcpp_result_gen;
END_RCPP
}
// pedigree_size
int pedigree_size(Rcpp::XPtr<Pedigree> ped);
RcppExport SEXP _malan_pedigree_size(SEXP pedSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::XPtr<Pedigree> >::type ped(pedSEXP);
    rcpp_result_gen = Rcpp::wrap(pedigree_size(ped));
    return rcpp_result_gen;
END_RCPP
}
// pedigrees_table
std::unordered_map<int, int> pedigrees_table(Rcpp::XPtr< std::vector<Pedigree*> > pedigrees);
RcppExport SEXP _malan_pedigrees_table(SEXP pedigreesSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::XPtr< std::vector<Pedigree*> > >::type pedigrees(pedigreesSEXP);
    rcpp_result_gen = Rcpp::wrap(pedigrees_table(pedigrees));
    return rcpp_result_gen;
END_RCPP
}
// get_pedigree
Rcpp::XPtr<Pedigree> get_pedigree(Rcpp::XPtr< std::vector<Pedigree*> > pedigrees, int index);
RcppExport SEXP _malan_get_pedigree(SEXP pedigreesSEXP, SEXP indexSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::XPtr< std::vector<Pedigree*> > >::type pedigrees(pedigreesSEXP);
    Rcpp::traits::input_parameter< int >::type index(indexSEXP);
    rcpp_result_gen = Rcpp::wrap(get_pedigree(pedigrees, index));
    return rcpp_result_gen;
END_RCPP
}
// print_pedigree
void print_pedigree(Rcpp::XPtr<Pedigree> ped);
RcppExport SEXP _malan_print_pedigree(SEXP pedSEXP) {
BEGIN_RCPP
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::XPtr<Pedigree> >::type ped(pedSEXP);
    print_pedigree(ped);
    return R_NilValue;
END_RCPP
}
// get_pids_in_pedigree
Rcpp::IntegerVector get_pids_in_pedigree(Rcpp::XPtr<Pedigree> ped);
RcppExport SEXP _malan_get_pids_in_pedigree(SEXP pedSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::XPtr<Pedigree> >::type ped(pedSEXP);
    rcpp_result_gen = Rcpp::wrap(get_pids_in_pedigree(ped));
    return rcpp_result_gen;
END_RCPP
}
// get_haplotypes_in_pedigree
Rcpp::List get_haplotypes_in_pedigree(Rcpp::XPtr<Pedigree> ped);
RcppExport SEXP _malan_get_haplotypes_in_pedigree(SEXP pedSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::XPtr<Pedigree> >::type ped(pedSEXP);
    rcpp_result_gen = Rcpp::wrap(get_haplotypes_in_pedigree(ped));
    return rcpp_result_gen;
END_RCPP
}
// get_pedigree_edgelist
Rcpp::CharacterMatrix get_pedigree_edgelist(Rcpp::XPtr<Pedigree> ped);
RcppExport SEXP _malan_get_pedigree_edgelist(SEXP pedSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::XPtr<Pedigree> >::type ped(pedSEXP);
    rcpp_result_gen = Rcpp::wrap(get_pedigree_edgelist(ped));
    return rcpp_result_gen;
END_RCPP
}
// get_pedigree_as_graph
Rcpp::List get_pedigree_as_graph(Rcpp::XPtr<Pedigree> ped);
RcppExport SEXP _malan_get_pedigree_as_graph(SEXP pedSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::XPtr<Pedigree> >::type ped(pedSEXP);
    rcpp_result_gen = Rcpp::wrap(get_pedigree_as_graph(ped));
    return rcpp_result_gen;
END_RCPP
}
// get_pedigrees_tidy
Rcpp::List get_pedigrees_tidy(Rcpp::XPtr< std::vector<Pedigree*> > pedigrees);
RcppExport SEXP _malan_get_pedigrees_tidy(SEXP pedigreesSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Rcpp::XPtr< std::vector<Pedigree*> > >::type pedigrees(pedigreesSEXP);
    rcpp_result_gen = Rcpp::wrap(get_pedigrees_tidy(pedigrees));
    return rcpp_result_gen;
END_RCPP
}
// test_create_population
Rcpp::XPtr<Population> test_create_population();
RcppExport SEXP _malan_test_create_population() {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    rcpp_result_gen = Rcpp::wrap(test_create_population());
    return rcpp_result_gen;
END_RCPP
}

static const R_CallMethodDef CallEntries[] = {
    {"_malan_build_pedigrees", (DL_FUNC) &_malan_build_pedigrees, 2},
    {"_malan_from_igraph_rcpp", (DL_FUNC) &_malan_from_igraph_rcpp, 2},
    {"_malan_infer_generations", (DL_FUNC) &_malan_infer_generations, 1},
    {"_malan_load_individuals", (DL_FUNC) &_malan_load_individuals, 4},
    {"_malan_load_haplotypes", (DL_FUNC) &_malan_load_haplotypes, 4},
    {"_malan_infer_generation", (DL_FUNC) &_malan_infer_generation, 1},
    {"_malan_set_generation", (DL_FUNC) &_malan_set_generation, 2},
    {"_malan_sample_geneology", (DL_FUNC) &_malan_sample_geneology, 9},
    {"_malan_sample_geneology_varying_size", (DL_FUNC) &_malan_sample_geneology_varying_size, 7},
    {"_malan_calc_autosomal_genotype_probs", (DL_FUNC) &_malan_calc_autosomal_genotype_probs, 2},
    {"_malan_calc_autosomal_genotype_conditional_cumdist", (DL_FUNC) &_malan_calc_autosomal_genotype_conditional_cumdist, 2},
    {"_malan_sample_autosomal_genotype", (DL_FUNC) &_malan_sample_autosomal_genotype, 2},
    {"_malan_pedigrees_all_populate_autosomal", (DL_FUNC) &_malan_pedigrees_all_populate_autosomal, 5},
    {"_malan_population_populate_autosomal_infinite_alleles", (DL_FUNC) &_malan_population_populate_autosomal_infinite_alleles, 3},
    {"_malan_estimate_autotheta_subpops_unweighted_genotypes", (DL_FUNC) &_malan_estimate_autotheta_subpops_unweighted_genotypes, 2},
    {"_malan_estimate_autotheta_subpops_unweighted_pids", (DL_FUNC) &_malan_estimate_autotheta_subpops_unweighted_pids, 3},
    {"_malan_get_allele_counts_genotypes", (DL_FUNC) &_malan_get_allele_counts_genotypes, 1},
    {"_malan_get_allele_counts_pids", (DL_FUNC) &_malan_get_allele_counts_pids, 2},
    {"_malan_hash_colisions", (DL_FUNC) &_malan_hash_colisions, 1},
    {"_malan_estimate_autotheta_1subpop_genotypes", (DL_FUNC) &_malan_estimate_autotheta_1subpop_genotypes, 2},
    {"_malan_estimate_autotheta_1subpop_individuals", (DL_FUNC) &_malan_estimate_autotheta_1subpop_individuals, 2},
    {"_malan_estimate_autotheta_subpops_individuals", (DL_FUNC) &_malan_estimate_autotheta_subpops_individuals, 2},
    {"_malan_estimate_autotheta_subpops_genotypes", (DL_FUNC) &_malan_estimate_autotheta_subpops_genotypes, 2},
    {"_malan_estimate_autotheta_subpops_pids", (DL_FUNC) &_malan_estimate_autotheta_subpops_pids, 3},
    {"_malan_pedigrees_all_populate_haplotypes", (DL_FUNC) &_malan_pedigrees_all_populate_haplotypes, 6},
    {"_malan_pedigrees_all_populate_haplotypes_custom_founders", (DL_FUNC) &_malan_pedigrees_all_populate_haplotypes_custom_founders, 6},
    {"_malan_pedigrees_all_populate_haplotypes_ladder_bounded", (DL_FUNC) &_malan_pedigrees_all_populate_haplotypes_ladder_bounded, 8},
    {"_malan_get_haplotype", (DL_FUNC) &_malan_get_haplotype, 1},
    {"_malan_get_haplotypes_individuals", (DL_FUNC) &_malan_get_haplotypes_individuals, 1},
    {"_malan_get_haplotypes_pids", (DL_FUNC) &_malan_get_haplotypes_pids, 2},
    {"_malan_count_haplotype_occurrences_individuals", (DL_FUNC) &_malan_count_haplotype_occurrences_individuals, 2},
    {"_malan_count_haplotype_near_matches_individuals", (DL_FUNC) &_malan_count_haplotype_near_matches_individuals, 3},
    {"_malan_haplotype_matches_individuals", (DL_FUNC) &_malan_haplotype_matches_individuals, 2},
    {"_malan_count_haplotype_occurrences_pedigree", (DL_FUNC) &_malan_count_haplotype_occurrences_pedigree, 3},
    {"_malan_pedigree_haplotype_matches_in_pedigree_meiosis_L1_dists", (DL_FUNC) &_malan_pedigree_haplotype_matches_in_pedigree_meiosis_L1_dists, 3},
    {"_malan_pedigree_haplotype_near_matches_meiosis", (DL_FUNC) &_malan_pedigree_haplotype_near_matches_meiosis, 3},
    {"_malan_meiotic_dist", (DL_FUNC) &_malan_meiotic_dist, 2},
    {"_malan_meiotic_dist_threshold", (DL_FUNC) &_malan_meiotic_dist_threshold, 3},
    {"_malan_meiotic_radius", (DL_FUNC) &_malan_meiotic_radius, 2},
    {"_malan_haplotypes_to_hashes", (DL_FUNC) &_malan_haplotypes_to_hashes, 2},
    {"_malan_split_by_haplotypes", (DL_FUNC) &_malan_split_by_haplotypes, 2},
    {"_malan_haplotype_partially_matches_individuals", (DL_FUNC) &_malan_haplotype_partially_matches_individuals, 3},
    {"_malan_build_haplotype_hashmap", (DL_FUNC) &_malan_build_haplotype_hashmap, 2},
    {"_malan_delete_haplotypeids_hashmap", (DL_FUNC) &_malan_delete_haplotypeids_hashmap, 1},
    {"_malan_get_matching_pids_from_hashmap", (DL_FUNC) &_malan_get_matching_pids_from_hashmap, 2},
    {"_malan_get_individual", (DL_FUNC) &_malan_get_individual, 2},
    {"_malan_get_pid", (DL_FUNC) &_malan_get_pid, 1},
    {"_malan_print_individual", (DL_FUNC) &_malan_print_individual, 1},
    {"_malan_get_generation", (DL_FUNC) &_malan_get_generation, 1},
    {"_malan_get_pedigree_from_individual", (DL_FUNC) &_malan_get_pedigree_from_individual, 1},
    {"_malan_get_pedigree_id_from_pid", (DL_FUNC) &_malan_get_pedigree_id_from_pid, 2},
    {"_malan_get_family_info", (DL_FUNC) &_malan_get_family_info, 1},
    {"_malan_get_father", (DL_FUNC) &_malan_get_father, 1},
    {"_malan_get_children", (DL_FUNC) &_malan_get_children, 1},
    {"_malan_count_brothers", (DL_FUNC) &_malan_count_brothers, 1},
    {"_malan_get_brothers", (DL_FUNC) &_malan_get_brothers, 1},
    {"_malan_brothers_matching", (DL_FUNC) &_malan_brothers_matching, 1},
    {"_malan_father_matches", (DL_FUNC) &_malan_father_matches, 1},
    {"_malan_grandfather_matches", (DL_FUNC) &_malan_grandfather_matches, 1},
    {"_malan_count_uncles", (DL_FUNC) &_malan_count_uncles, 1},
    {"_malan_get_uncles", (DL_FUNC) &_malan_get_uncles, 1},
    {"_malan_get_cousins", (DL_FUNC) &_malan_get_cousins, 1},
    {"_malan_pop_size", (DL_FUNC) &_malan_pop_size, 1},
    {"_malan_get_individuals", (DL_FUNC) &_malan_get_individuals, 1},
    {"_malan_meioses_generation_distribution", (DL_FUNC) &_malan_meioses_generation_distribution, 2},
    {"_malan_population_size_generation", (DL_FUNC) &_malan_population_size_generation, 2},
    {"_malan_pedigree_size_generation", (DL_FUNC) &_malan_pedigree_size_generation, 2},
    {"_malan_mixture_info_by_individuals_2pers", (DL_FUNC) &_malan_mixture_info_by_individuals_2pers, 4},
    {"_malan_mixture_info_by_individuals_3pers", (DL_FUNC) &_malan_mixture_info_by_individuals_3pers, 4},
    {"_malan_mixture_info_by_individuals_4pers", (DL_FUNC) &_malan_mixture_info_by_individuals_4pers, 5},
    {"_malan_mixture_info_by_individuals_5pers", (DL_FUNC) &_malan_mixture_info_by_individuals_5pers, 6},
    {"_malan_analyse_mixture_result", (DL_FUNC) &_malan_analyse_mixture_result, 3},
    {"_malan_analyse_mixture_results", (DL_FUNC) &_malan_analyse_mixture_results, 3},
    {"_malan_get_pedigree_id", (DL_FUNC) &_malan_get_pedigree_id, 1},
    {"_malan_pedigrees_count", (DL_FUNC) &_malan_pedigrees_count, 1},
    {"_malan_pedigree_size", (DL_FUNC) &_malan_pedigree_size, 1},
    {"_malan_pedigrees_table", (DL_FUNC) &_malan_pedigrees_table, 1},
    {"_malan_get_pedigree", (DL_FUNC) &_malan_get_pedigree, 2},
    {"_malan_print_pedigree", (DL_FUNC) &_malan_print_pedigree, 1},
    {"_malan_get_pids_in_pedigree", (DL_FUNC) &_malan_get_pids_in_pedigree, 1},
    {"_malan_get_haplotypes_in_pedigree", (DL_FUNC) &_malan_get_haplotypes_in_pedigree, 1},
    {"_malan_get_pedigree_edgelist", (DL_FUNC) &_malan_get_pedigree_edgelist, 1},
    {"_malan_get_pedigree_as_graph", (DL_FUNC) &_malan_get_pedigree_as_graph, 1},
    {"_malan_get_pedigrees_tidy", (DL_FUNC) &_malan_get_pedigrees_tidy, 1},
    {"_malan_test_create_population", (DL_FUNC) &_malan_test_create_population, 0},
    {NULL, NULL, 0}
};

RcppExport void R_init_malan(DllInfo *dll) {
    R_registerRoutines(dll, NULL, CallEntries, NULL, NULL);
    R_useDynamicSymbols(dll, FALSE);
}
