% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{get_haplotype}
\alias{get_haplotype}
\title{Get haplotype from an individual}
\usage{
get_haplotype(individual)
}
\arguments{
\item{individual}{Individual to get haplotypes for.}
}
\value{
Haplotype for \code{individual}.
}
\description{
Requires that haplotypes are first populated, e.g.
with \code{\link[=pedigrees_all_populate_haplotypes]{pedigrees_all_populate_haplotypes()}},
\code{\link[=pedigrees_all_populate_haplotypes_custom_founders]{pedigrees_all_populate_haplotypes_custom_founders()}}, or
\code{\link[=pedigrees_all_populate_haplotypes_ladder_bounded]{pedigrees_all_populate_haplotypes_ladder_bounded()}}.
}
\examples{
sim <- sample_geneology(100, 10)
peds <- build_pedigrees(sim$population)
pedigrees_all_populate_haplotypes(peds, 2, c(1, 1))
get_haplotype(sim$end_generation_individuals[[1]])

}
\seealso{
\code{\link[=get_haplotypes_individuals]{get_haplotypes_individuals()}} and \code{\link[=get_haplotypes_pids]{get_haplotypes_pids()}}.
}
