% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make.R
\name{make_with_recipe}
\alias{make_with_recipe}
\title{Make targets out of dependencies using a recipe}
\usage{
make_with_recipe(
  recipe,
  targets,
  dependencies = NULL,
  packages = NULL,
  envir = new.env(parent = parent.frame()),
  quiet = getOption("makepipe.quiet"),
  force = FALSE,
  label = NULL,
  note = NULL,
  ...
)
}
\arguments{
\item{recipe}{A chunk of R code which makes the \code{targets}}

\item{targets}{A character vector of paths to files}

\item{dependencies}{A character vector of paths to files which the \code{targets}
depend on}

\item{packages}{A character vector of names of packages which \code{targets}
depend on}

\item{envir}{The environment in which to execute the \code{source} or \code{recipe}. By
default, execution will take place in a fresh environment whose parent is
the calling environment.}

\item{quiet}{A logical determining whether or not messages are signaled}

\item{force}{A logical determining whether or not execution of the \code{source}
or \code{recipe} will be forced (i.e. happen whether or not the targets are
out-of-date)}

\item{label}{A short label for the \code{source} or \code{recipe}, displayed in pipeline
visualisations. If \code{NULL}, the \code{basename(source)} or 'Recipe' will be used.}

\item{note}{A description of what the \code{recipe} does, displayed in pipeline
visualisations. If \code{NULL}, the \code{recipe} code is used.}

\item{...}{Additional parameters to pass to \code{base::eval()}}
}
\value{
A \code{Segment} object containing execution metadata.
}
\description{
Make targets out of dependencies using a recipe
}
\examples{
\dontrun{
# Merge files in fresh environment if raw data has been updated since last
# merged
make_with_recipe(
  recipe = {
    dat <- readRDS("data/raw_data.Rds")
    pop <- readRDS("data/pop_data.Rds")
    merged_dat <- merge(dat, pop, by = "id")
    saveRDS(merged_dat, "data/merged_data.Rds")
  },
  targets = "data/merged_data.Rds",
  dependencies = c("data/raw_data.Rds", "data/raw_pop.Rds")
)

# Merge files in current environment if raw data has been updated since last
# merged. (If recipe executed, all objects bound in source will be available
# in current env).
make_with_recipe(
  recipe = {
    dat <- readRDS("data/raw_data.Rds")
    pop <- readRDS("data/pop_data.Rds")
    merged_dat <- merge(dat, pop, by = "id")
    saveRDS(merged_dat, "data/merged_data.Rds")
  },
  targets = "data/merged_data.Rds",
  dependencies = c("data/raw_data.Rds", "data/raw_pop.Rds"),
  envir = environment()
)

# Merge files in global environment if raw data has been updated since last
# merged. (If source executed, all objects bound in source will be available
# in global env).
make_with_recipe(
  recipe = {
    dat <- readRDS("data/raw_data.Rds")
    pop <- readRDS("data/pop_data.Rds")
    merged_dat <- merge(dat, pop, by = "id")
    saveRDS(merged_dat, "data/merged_data.Rds")
  },
  targets = "data/merged_data.Rds",
  dependencies = c("data/raw_data.Rds", "data/raw_pop.Rds"),
  envir = globalenv()
)
}
}
\seealso{
Other make: 
\code{\link{make_with_dir}()},
\code{\link{make_with_source}()}
}
\concept{make}
