% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_prior_object_functions.R
\name{find_pc_prior_param}
\alias{find_pc_prior_param}
\title{Find suitable PC prior parameters}
\usage{
find_pc_prior_param(
  lower,
  upper,
  alpha = 0.05,
  func = exp,
  N = 10000,
  prob = 0.95
)
}
\arguments{
\item{lower}{lower end of credible interval}

\item{upper}{upper end of credible interval}

\item{alpha}{tail probability of the PC prior (default = \code{0.05})}

\item{func}{function to scale Gaussian variables to match desired credible interval scale,
default is the exponential function}

\item{N}{number of samples to use when sampling sigma and x, default is \code{1e4}}

\item{prob}{amount of mass to put in the credible interval, default is \code{0.95}}
}
\value{
The \code{U}-value to pass to the PC prior. NB! Store result to avoid rerunning this function, as it uses sampling.
The function also prints (sampled) quantiles for the U-value that is returned.
}
\description{
Returns the \code{U} value in P(\code{U} > sigma) = \code{alpha} for a PC prior on standard deviation given an
equal-tailed credible interval
P(\code{lower} < \code{func}(x) < \code{upper}) = \code{prob} where x is a Gaussian variable with
zero mean standard deviation sigma.
Note that this function uses sampling.
}
\examples{
find_pc_prior_param(0.1, 10)

}
