% Generated by roxygen2 (4.0.2): do not edit by hand
\name{send.mail}
\alias{send.mail}
\title{Send emails from R}
\usage{
send.mail(from, to, subject = "", body = "", encoding = "iso-8859-1",
  html = FALSE, inline = FALSE, smtp = list(), authenticate = FALSE,
  send = TRUE, attach.files = NULL, debug = FALSE, ...)
}
\arguments{
\item{from}{A valid email address of the sender.}

\item{to}{A character vector of recipient valid email addresses.}

\item{subject}{Subject of the email.}

\item{body}{Body of the email as text. If the parameter body refers to an existing file location, the text of the file is parsed as body of the email.}

\item{encoding}{Character encoding to use for the email. Supported encodings include iso-8859-1 (default), utf-8, us-ascii, and koi8-r.}

\item{html}{A boolean indicating whether the body of the email should be parsed as HTML.}

\item{inline}{A boolean indicating whether images in the HTML file should be embedded inline.}

\item{smtp}{A list of configuration parameters to establish and authorize a connection with the SMTP server. See details for the various parameters.}

\item{authenticate}{A boolean variable to indicate whether authorization is required to connect to the SMTP server. If set to true, see details on parameters required in smtp parameter.}

\item{send}{A boolean indicating whether the email should be sent at the end of the function (default behaviour). If set to false, function returns the email object to the parent environment.}

\item{attach.files}{A character vector of paths in the file system linking to files or *valid* URLs to be attached to the email (see details for more info on attaching URLs)}

\item{debug}{A boolean indicating whether you wish to see detailed debug info}

\item{...}{Optional arguments to be passed related to file attachments. See details for more info.}
}
\value{
email A Java object of class org.apache.commons.mail.SimpleEmail or org.apache.commons.mail.MultiPartEmail
}
\description{
Send emails from R
}
\details{
The only mandatory value in the list 'smtp' is host.name that is the SMTP server address. A port number can also be provided via the list item 'port'. In case the SMTP server requires authorization, the parameter 'authenticate' must be set to TRUE and the list 'smtp' must include items 'user.name' and 'passwd'. If SSL or TLS encryption is required by the SMTP server, these can be indicated by setting a list item 'ssl' as TRUE or 'tls' as TRUE respectively.

Using 'attach.files' you can attach files or webpages hosted on the web (for e.g. on Dropbox). Currently, URLs hostnames must be prepending with http:// or https://. Two optional paramters relevant to attachments can be supplied. Parameter 'file.names' can be provided to assign names to the files listed in the parameter 'attach.files'. A description can be provided further as 'file.descriptions' to further describe the file. Both parameters must have the same length as 'attach.files'. In case attach.file is NULL, then these two parameters will be ignored.

HTML formatted emails can be sent by setting the parameters html and inline (if embedding images) to TRUE. The body of the email can either be a HTML string or point to a HTML file in the local file system.
}
\note{
For more examples, see https://github.com/rpremraj/mailR
}
\examples{
sender <- "sender@gmail.com"  # Replace with a valid address
recipients <- c("receiver1@gmail.com")  # Replace with one or more valid addresses
email <- send.mail(from = sender,
                   to = recipients,
                   subject="Subject of the email",
                   body = "Body of the email",
                   smtp = list(host.name = "aspmx.l.google.com", port = 25),
                   authenticate = FALSE,
                   send = FALSE)
\dontrun{email$send() # execute to send email}
}

