% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interactive_annotate.R
\name{interactive_annotate}
\alias{interactive_annotate}
\title{interactive annotation}
\usage{
interactive_annotate(
  image,
  text,
  gravity = "northwest",
  font = "",
  style = "normal",
  decoration = NULL,
  color = NULL,
  strokecolor = NULL,
  boxcolor = NULL,
  range_max_size = 1000,
  range_max_weight = 850,
  range_max_kerning = 300,
  resolution = 0.1,
  return_param = FALSE
)
}
\arguments{
\item{image}{a magick image object}

\item{text}{character vector of length equal to 'image' or length 1}

\item{gravity}{string with gravity value from gravity_types.}

\item{font}{string with font family such as "sans", "mono", "serif", "Times", "Helvetica", "Trebuchet", "Georgia", "Palatino" or "Comic Sans".}

\item{style}{value of style_types for example "italic"}

\item{decoration}{value of decoration_types for example "underline"}

\item{color}{a valid color string such as "navyblue" or "#000080". Use "none" for transparency.}

\item{strokecolor}{a color string adds a stroke (border around the text)}

\item{boxcolor}{a color string for background color that annotation text is rendered on.}

\item{range_max_size}{define maximum of size in slider. must be positive.}

\item{range_max_weight}{define maximum of weight in slider. must be positive.}

\item{range_max_kerning}{define maximum of kerning in slider. must be positive.}

\item{resolution}{resolution of slider}

\item{return_param}{If return_param is TRUE, returns a list of values of location, degrees, size, weight, and kerning. If return_param is FALSE, returns a magick image object.}
}
\value{
a magick image object or a list of values of location, degrees, size, weight, and kerning
}
\description{
Using image_annotate of 'magick' interactively.
location, degrees, size, weight, and kerning are parameters of image_annotate. See reference manual of 'magick' for detail.
}
\examples{
\donttest{
interactive_annotate(wizard, "hello")
}
}
\author{
Shota Ochi
}
