% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_schedule.R
\name{get_schedule}
\alias{get_schedule}
\title{Get the schedule from a MaestroSchedule object}
\usage{
get_schedule(schedule)
}
\arguments{
\item{schedule}{object of type MaestroSchedule created using \code{build_schedule()}}
}
\value{
data.frame
}
\description{
A schedule is represented as a table where each row is a pipeline and
the columns contain scheduling parameters such as the frequency and start time.
}
\details{
The schedule table is used internally in a MaestroSchedule object but can be
accessed using this function or accessing the R6 method of the MaestroSchedule
object.
}
\examples{
if (interactive()) {
  pipeline_dir <- tempdir()
  create_pipeline("my_new_pipeline", pipeline_dir, open = FALSE)
  schedule <- build_schedule(pipeline_dir = pipeline_dir)

  get_schedule(schedule)

  # Alternatively, use the underlying R6 method
  schedule$get_schedule()
}
}
