% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/08-data_visualize.R
\name{open_visual_report}
\alias{open_visual_report}
\title{Open a visual report in a browser}
\usage{
open_visual_report(report_path)
}
\arguments{
\item{report_path}{A character string specifying the path of the report to
be opened.}
}
\value{
Nothing to be returned. The function opens a web page.
}
\description{
Opens a previously generated HTML bookdown document. This is a shortcut
function to access an existing visual report.
}
\examples{
{

# use DEMO_files provided by the package

dataset <- DEMO_files$dataset_TOKYO['height']
data_dict <- 
  data_dict_filter(
    DEMO_files$dd_TOKYO_format_maelstrom_tagged,
    filter_var = "name == 'height'")
      
.summary_var <- DEMO_files$summary_var
  
to <- tempdir()
dataset_visualize(dataset, data_dict,.summary_var =.summary_var, to = to)
      
# To open the file in browser, you can also open 'to/docs/index.html'. 
open_visual_report(to)

}

}
\seealso{
\code{\link[=dataset_visualize]{dataset_visualize()}}
}
