% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03-catalogue_functions.R
\name{is_valueType}
\alias{is_valueType}
\title{Test if a character object is one of the valid valueType values}
\usage{
is_valueType(object)
}
\arguments{
\item{object}{A potential valueType name to be evaluated.}
}
\value{
A logical.
}
\description{
Confirms whether the input object is a valid valueType. This function mainly
helps validate input within other functions of the package but could be used
to check if a valueType is valid.
}
\details{
The valueType is a property of a variable and is required in certain
functions to determine the handling of the variables. The valueType refers
to the OBiBa-internal type of a variable. It is specified in a data
dictionary in a column \code{valueType} and can be associated with variables as
attributes. Acceptable valueTypes include 'text', 'integer', 'decimal',
'boolean', datetime', 'date'). The full list of OBiBa valueType
possibilities and their correspondence with R data types are available using
\link{valueType_list}.
}
\examples{
{

is_valueType('integer')
is_valueType('integre')

}

}
\seealso{
\href{https://opaldoc.obiba.org/en/dev/magma-user-guide/value/type.html}{Opal documentation}
}
