% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getDependencies.R
\name{getDependencies}
\alias{getDependencies}
\title{getDependencies}
\usage{
getDependencies(
  name,
  direction = "in",
  graph = NULL,
  type = NULL,
  self = FALSE,
  ...
)
}
\arguments{
\item{name}{name of the function to be analyzed}

\item{direction}{Character string, either “in”, “out”, "both", “full”, "din" or
"dout". If “in” all sources feeding into the function are listed. If “out”
consumer of the function are listed. If “both” the union of "in" and "out" is returned.
If "full" the full network this function is connected to is shown, including
indirect connections to functions which neither source nor consume the given
function but serve as sources to other consumer functions. "din" and "dout" (short
for "direct in" and "direct out") behave like "in" and "out" but only show direct
calls in or from the function (ignoring the network of functions attached to it).}

\item{graph}{A madrat graph as returned by \code{\link{getMadratGraph}}.
Will be created with \code{\link{getMadratGraph}} if not provided.}

\item{type}{type filter. Only dependencies of that type will be returned. Currently available
types are "calc", "read" and "tool"}

\item{self}{boolean defining whether the function itself, which is analyzed, should be
included in the output, or not}

\item{...}{Additional arguments for \code{\link{getMadratGraph}} in case
that no graph is provided (otherwise ignored)}
}
\description{
Returns information about dependencies of a
madrat-based calc- read- or full-function.
}
\seealso{
\code{\link{getCalculations}}, \code{\link{getMadratGraph}},  \code{\link{getMadratInfo}}
}
\author{
Jan Philipp Dietrich
}
