% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mable-multivar.r
\name{mable.mvar}
\alias{mable.mvar}
\title{Maximum Approximate Bernstein Likelihood Estimate
 of Multivariate Density Function}
\usage{
mable.mvar(x, M, search = TRUE, interval = NULL,
  controls = mable.ctrl(), progress = TRUE)
}
\arguments{
\item{x}{an \code{n x d} matrix or \code{data.frame} of multivariate sample of size \code{n}}

\item{M}{a positive integer or a vector of \code{d} positive integers specify
the maximum candidate or the given model degrees for the joint density.}

\item{search}{logical, whether to search optimal degrees using \code{M} as maximum candidate 
degrees or not but use \code{M} as the given model degrees for the joint density.}

\item{interval}{a vector of two endpoints or a \code{d x 2} matrix, each row containing 
the endpoints of support/truncation interval for each marginal density.
If missing, the i-th row is assigned as \code{c(min(x[,i]), max(x[,i]))}.}

\item{controls}{Object of class \code{mable.ctrl()} specifying iteration limit
and the convergence criterion \code{eps}. Default is \code{\link{mable.ctrl}}. See Details.}

\item{progress}{if TRUE a text progressbar is displayed}
}
\value{
A list with components
\itemize{
 \item \code{dim} the dimension \code{d} of the data
 \item \code{m} a vector of the selected optimal degrees by the method of change-point
 \item \code{p} a vector of the mixture proportions \eqn{p(j_1, \ldots, j_d)}, arranged in the 
  column-major order of \eqn{j = (j_1, \ldots, j_d)}, \eqn{0 \le j_i \le m_i, i = 1, \ldots, d}.
 \item \code{mloglik}  the maximum log-likelihood at an optimal degree \code{m}
 \item \code{pval}  the p-values of change-points for choosing the optimal degrees for the 
   marginal densities
 \item \code{M} the vector \code{(m1, m2, ... , md)}, where \code{mi} is the largest candidate 
   degree when the search stoped for the \code{i}-th marginal density
 \item \code{interval} support hyperrectangle \eqn{[a, b]=[a_1, b_1] \times \cdots \times [a_d, b_d]}
 \item \code{convergence} An integer code. 0 indicates successful completion(the EM iteration is   
   convergent). 1 indicates that the iteration limit \code{maxit} had been reached in the EM iteration;
}
}
\description{
Maximum Approximate Bernstein Likelihood Estimate
 of Multivariate Density Function
}
\details{
A \eqn{d}-variate density \eqn{f} on a hyperrectangle \eqn{[a, b]
  =[a_1, b_1] \times \cdots \times [a_d, b_d]} can be approximated 
  by a mixture of \eqn{d}-variate beta densities on \eqn{[a, b]}, 
  \eqn{\beta_{mj}(x) = \prod_{i=1}^d\beta_{m_i,j_i}[(x_i-a_i)/(b_i-a_i)]/(b_i-a_i)},
  with proportion \eqn{p(j_1, \ldots, j_d)}, \eqn{0 \le j_i \le m_i, i = 1, \ldots, d}. 
  If \code{search=TRUE}, we start with \eqn{M_0}\code{=rep(2,d)} and select  
  \eqn{M_1} which maximizes the likelohood with degrees \eqn{M_1=M_0+e_i}, where
  \eqn{e_i}, \eqn{i=1,\ldots,d}, form the basis of \eqn{R^n}.  The above procedure
  are repeated at least four times to \eqn{M_s} and loglikelihood \eqn{\ell_s}, 
  \eqn{s=0, 1,\ldots,k}, and stop whenever the p-value of the change point of
  \eqn{\ell_{s+1}-\ell_s} is small or a component of \eqn{M_k} reached its maximum 
  value specified by \code{M}. For each \eqn{M_s+e_i} the data are fitted using 
  EM algorithm and the multivariate Bernstein polynomial model with a vector of the    
  mixture proportions \eqn{p(j_1, \ldots, j_d)}, arranged in the 
  column-major order of \eqn{j = (j_1, \ldots, j_d)}, \eqn{p_0, \ldots, p_{K-1}}, 
  where \eqn{K=\prod_{i=1}^d (m_i+1)}, to obtain likelihood.
}
\examples{
## Old Faithful Data
\donttest{
 a<-c(0, 40); b<-c(7, 110)
 #ans<-mable.mvar(faithful, M = c(100, 100), interval = cbind(a, b))
 ans<- mable.mvar(faithful, M = c(46,19), search =FALSE, interval = cbind(a,b))
 plot(ans, which="density") 
 plot(ans, which="cumulative")
}
}
\references{
Wang, T. and Guan, Z.,(2019) Bernstein Polynomial Model for Nonparametric Multivariate Density,    
   \emph{Statistics}, Vol. 53, no. 2, 321-338
}
\author{
Zhong Guan <zguan@iusb.edu>
}
\concept{density estimation}
\concept{multivariate Bernstein polynomial model}
\keyword{distribution}
\keyword{multivariate}
\keyword{nonparametric}
