% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/copy-msg.R
\name{copy_msg}
\alias{copy_msg}
\title{Copy Messages}
\usage{
copy_msg(imapconf, msg_id, by = "MSN", to_mbox, reselect_mbox = FALSE,
  retries = 2)
}
\arguments{
\item{imapconf}{An object of class \code{imapconf} generated with
\link{configure_imap} and with a \code{mbox} item added after a
mailbox selection with \link{select_mailbox}.}

\item{msg_id}{A numeric vetor containing one or more messages ids.}

\item{by}{Which id (\code{MSN} or \code{UID}) to use when searching for
messages. \code{"MSN"} or message squence number is a message's relative
position to the older message in the mailbox. It may change after deleting
or moving messages. For instance, if a message is deleted, message sequence
numbers are reordered to fill the gap. \code{"UID"} or unique identifier
is always the same during the life cycle of a message. Default is
\code{"MSN"}.}

\item{to_mbox}{A character string specifying the mailbox to which messages
will be copied to.}

\item{reselect_mbox}{If \code{TRUE}, calls \code{select_mailbox(mbox = to_mbox)}
before returning the output. Default is \code{FALSE} for moving and
copying operations, whereas it is \code{TRUE} for renaming mailboxes.}

\item{retries}{Number of attempts to connect and execute the command. Default
is \code{2}.}
}
\value{
An (invisible) \code{list} of length \code{2} containing the
    \code{imapconf} object and the previously inputed message ids
    (parameter \code{msg_id}).
}
\description{
Copies messages form a mailbox to another.
}
\examples{

\dontrun{

# configure IMAP
library(mRpostman)
imapconf <- configure_imap(url="imaps://your.imap.server.com",
                           username="your_username",
                           password=rstudioapi::askForPassword()
                          )

# copy search results from "Sent" to "INBOX"
results <- imapconf \%>\%
    select_mailbox(mbox = "Sent") \%>\%
    search_before(date_char = "10-may-2012") \%$\% #exposition pipe operator - pass two argg
    copy_msg(imapconf = imapconf, msg_id = msg_id, to_mbox = "INBOX")

}

}
\seealso{
Other miscellaneous: \code{\link{add_flags}},
  \code{\link{count_msgs}}, \code{\link{delete_msg}},
  \code{\link{expunge}}, \code{\link{get_max_id}},
  \code{\link{get_min_id}}, \code{\link{move_msg}},
  \code{\link{remove_flags}}, \code{\link{replace_flags}}
}
\concept{miscellaneous}
