% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/module3_data_shrink.R
\name{DataShrink}
\alias{DataShrink}
\title{Annotating the merged data for all accelerometer files in the GGIR output}
\usage{
DataShrink(
  studyname,
  outputdir,
  workdir,
  QCdays.alpha = 7,
  QChours.alpha = 16,
  summaryFN = "../summary/part24daysummary.info.csv",
  epochIn = 5,
  epochOut = 60,
  useIDs.FN = NULL,
  RemoveDaySleeper = FALSE,
  trace = FALSE,
  Step = 1
)
}
\arguments{
\item{studyname}{\code{character} Specify the study name that used in the output file names}

\item{outputdir}{\code{character} Directory where the GGIR output was stored.}

\item{workdir}{\code{character} Directory where the output needs to be stored. Note that this directory must exist.}

\item{QCdays.alpha}{\code{number}  Minimum required number of valid days in subject specific analysis as a quality control step in module2. Default is 7 days.}

\item{QChours.alpha}{\code{number}  Minimum required number of valid hours in day specific analysis as a quality control step in module2. Default is 16 hours.}

\item{summaryFN}{\code{character} Filename with or without directory for sample information in CSV format, which includes summary description of each accelerometer file. Some description will be extracted and merged into the ENMO/ANGLEZ data.}

\item{epochIn}{\code{number}  Epoch size to which acceleration was averaged (seconds) in GGIR output. Defaut is 5 seconds.}

\item{epochOut}{\code{number}  Epoch size to which acceleration was averaged (seconds) in module1. Defaut is 60 seconds.}

\item{useIDs.FN}{\code{character} Filename with or without directory for sample information in CSV format, which inclues "filename" and "duplicate" in the headlines at least. If duplicate="remove",  the accelerometer files will not be used in the data analysis of module 5-7. Defaut is NULL, which makes all accelerometer files will be used in module 5-7.}

\item{RemoveDaySleeper}{\code{logical}  Specify if the daysleeper nights are removed from the calculation of number of valid days for each subject. Default is FALSE.}

\item{trace}{\code{logical}  Specify if the intermediate results is printed when the function was executed. Default is FALSE.}

\item{Step}{\code{number}  Specify which of the varaible need to be cleaned. For example, Step = 1 for the "anglez" variable, and Step = 2 for the "enmo" variable.}
}
\value{
Files were written to the specified sub-directory, named as flag_ALL_studyname_ENMO.data.Xs.csv and flag_ALL_studyname_ANGLEZ.data.Xs.csv, which Xs is the epoch size to which acceleration was averaged (seconds) in GGIR output.  This excel file includs the following columns, 
\item{          filename}{accelerometer file name } 
\item{          Date}{date recored from the GGIR part2.summary file }
\item{          id}{IDs recored from the GGIR part2.summary file }
\item{          calender_date}{date in the format of yyyy-mm-dd }
\item{          N.valid.hours}{number of hours with valid data recored from the part2_daysummary.csv file in the GGIR output }
\item{          N.hours}{number of hours of measurement recored from the part2_daysummary.csv file in the GGIR output }
\item{          weekday}{day of the week-Day of the week }
\item{          measurementday}{day of measurement-Day number relative to start of the measurement }
\item{          newID}{new IDs defined as the user-defined function of filename2id(), e.g. substrings of the filename } 
\item{          Nmiss_c9_c31}{number of NAs from the 9th to 31th column in the part2_daysummary.csv file in the GGIR output} 
\item{          missing}{"M" indicates missing for an invalid day, and  "C" indicates completeness for a valid day }
\item{          Ndays}{number of days of measurement  }
\item{          ith_day}{rank of the measurementday, for example, the value is 1,2,3,4,-3,-2,-1 for measurementday = 1,...,7 }
\item{          Nmissday}{number of missing (invalid) days  }
\item{          Nnonmiss}{number of non-missing (valid) days } 
\item{          misspattern}{indicators of missing/nonmissing for all measurement days at the subject level }
\item{          RowNonWear}{number of columnns in the non-wearing matrix }
\item{          NonWearMin}{number of minutes of non-wearing}
\item{          Nvalid.day}{number of valid days with/without removing daysleeper nights; It is equal to Nnonmiss when RemoveDaySleeper=FALSE.}	
\item{          daysleeper}{If 0 then the person is a nightsleeper (sleep period did not overlap with noon) if value=1 then the person is a daysleeper (sleep period did overlap with noon) at the night. This is a night-level varialbe.}  
\item{          remove16h7day}{indicator of a key qulity control output. If remove16h7day=1, the day need to be removed. If remove16h7day=0, the day need to be kept.}   
\item{          duplicate}{If duplicate="remove",  the accelerometer files will not be used in the data analysis of module5-7.}
}
\description{
Annotating the merged ENMO/ANGLEZ data by adding some descriptive variables such as number of valid days and missing pattern.
}
