% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist_to_df.R
\name{dist.to.df}
\alias{dist.to.df}
\title{Merge distance object(s) into a single data frame}
\usage{
dist.to.df(list_dist)
}
\arguments{
\item{list_dist}{a list of dist object(s). All dist objects should have a
name (e.g. name of distance metric) and the same labels (i.e. names of
sets between which distance was computed).}
}
\value{
A data frame which first and second columns (names \code{x1} and \code{x2})
contain names of the 2 sets involved in each pair, and with one column for
each dist object (named after its name in \code{list_dist}.
}
\description{
This function merges distance object(s) into a single data frame which rows
are pairs of elements and column(s) distance metric(s). It stands on the
\code{\link[dendextend]{dist_long}} function.
}
\examples{
# Create dist objects: 
dist_A <- round(dist(matrix(runif(10, 0, 1), 5, 2, 
                      dimnames = list(letters[1:5], NULL))), 2)
dist_B <- round(dist(matrix(runif(10, 0, 1), 5, 2, 
                      dimnames = list(letters[1:5], NULL))), 2)
dist_C <- round(dist(matrix(runif(10, 0, 1), 5, 2, 
                      dimnames = list(letters[1:5], NULL))), 2)

# First example with only 1 distance:
dist.to.df(list(dA = dist_A))

# Second example with 3 distances:
dist.to.df(list(d1 = dist_A, d2 = dist_B, d3 = dist_C))
}
\author{
Sebastien Villeger
}
