% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xytb-class.R
\name{extractRF}
\alias{extractRF}
\title{Extract the random forest model from an xytb object}
\usage{
extractRF(xytb)
}
\arguments{
\item{xytb}{an xytb object with a model.}
}
\value{
a randomForest object as defined by the randomForest package.
}
\description{
The random forest model is extracted from the xytb object to a randomForest
object.
}
\examples{
#track_CAGA_005 is dataset
#generate a complete xytb object with derived (over moving windows of 3, 5
#and 9 points, with quantile at 0, 50 and 100\%) and shifted information on 10
#and 100 points
xytb<-xytb(track_CAGA_005,"a track",c(3,5,9),c(0,.5,1),c(10,100))
#compute a random forest model to predict behaviour (b, where -1 is
#unobserved behaviour) using the derived
#parameters ("actual")
xytb<-modelRF(xytb,"actual",nob="-1",colin=TRUE,varkeep=c("v","thetarel"),zerovar=TRUE)
#extract the model
modRF<-extractRF(xytb)
# results from randomForest package:
print(modRF)
plot(modRF)
}
\seealso{
See \link[randomForest]{randomForest}
}
\author{
Laurent Dubroca
}
