% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/r2.R
\name{r2}
\alias{r2}
\alias{r2.default}
\alias{r2.lm}
\alias{r2.lmerMod}
\title{Compute R squared}
\usage{
r2(model)

\method{r2}{default}(model)

\method{r2}{lm}(model)

\method{r2}{lmerMod}(model)
}
\arguments{
\item{model}{An object containing a model.}
}
\value{
If the model is a linear model, it returns a \code{data.frame}
with the R squared and adjusted R squared values. If the model is a
linear mixed model it return a \code{data.frame} with the marginal and
conditional R squared values as described by Nakagawa and Schielzeth
(2013). See the formulas for the computations in "Details".
}
\description{
Returns the R squared values according to the model class.
}
\details{
R squared computations.
}
\section{R squared}{

\deqn{R^2 = \frac{var(\hat{y})}{var(\epsilon)}}
Where \eqn{var(\hat{y})} is the variance explained by the model and
\eqn{var(\epsilon)} is the residual variance.
}

\section{Adjusted R squared}{

\deqn{R_{adj}^{2} = 1 - (1 - R^2)\frac{n - 1}{n - p - 1}}
Where \eqn{n} is the number of data points and \eqn{p} is the number of
predictors in the model.
}

\section{Marginal R squared}{

\deqn{R_{marg}^{2} = \frac{var(f)}{var(f) + var(r) + var(\epsilon)}}
Where \eqn{var(f)} is the variance of the fixed effects, \eqn{var(r)} is
the variance of the random effects and \eqn{var(\epsilon)} is the
residual variance.
}

\section{Conditional R squared}{

\deqn{R_{cond}^{2} = \frac{var(f) + var(r)}{var(f) + var(r) + var(\epsilon)}}
}

\examples{
m1 <- lm(Sepal.Length ~ Species, data = iris)
r2(m1)
if (require(lme4, quietly = TRUE)) {
  m2 <- lmer(
    Sepal.Length ~ Sepal.Width + Petal.Length + (1 | Species), data = iris
  )
  r2(m2)
}
}
\references{
\itemize{
\item Nakagawa, S., & Schielzeth, H. (2013). A general and simple method
for obtaining R2 from generalized linear mixed-effects models. Methods
in Ecology and Evolution, 4(2), 133–142.
\doi{10.1111/j.2041-210x.2012.00261.x}.
}
}
