% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/attr.R
\name{rattr}
\alias{rattr}
\alias{rattr<-}
\title{Set and get attributes of the original R-vector stored in an lvec}
\usage{
rattr(x, which)

rattr(x, which) <- value
}
\arguments{
\item{x}{and object of type \code{\link{lvec}}}

\item{which}{a character vector of length one giving the name of the 
attribute.}

\item{value}{the new value of the attribute}
}
\description{
Set and get attributes of the original R-vector stored in an lvec
}
\details{
The attributes of the \code{\link{lvec}} can be set and obtained using the 
standard functions \code{\link{attr}} and \code{\link{attributes}}. However 
when an lvec is converted to an R-vector using, for example, 
\code{\link{as_rvec}}, the attributes of the resulting R-vector are set using 
the result of \code{rattr}. This can be used to store vectors such as 
factors and dates (POSIXct) in \code{lvec} objects, as these are basically 
integer and numeric vectors with a number of additional attributes.
}
\examples{
dates <- as_lvec(as.Date("2016-12-05", "2016-12-24"))
# When printing and reading the result is converted back to a date object
print(dates)
as_rvec(dates)

# make a factor of an integer lvec 
a <- as_lvec(1:3)
rattr(a, "class") <- "factor"
rattr(a, "levels") <- c("a", "b", "c")
print(a)

}
