% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filedump.R
\docType{class}
\name{filedump}
\alias{filedump}
\title{The file dumping logger.}
\format{An \code{R6} class object.}
\usage{
filedump
}
\description{
The file dumping logger dumps the most recent version of a dataset to csv 
in a directory of choice.
}
\section{Creating a logger}{


\code{filedump$new(dir=file.path(tempdir(),"timber"), prefix="step\%03d.csv", verbose=TRUE)}
\tabular{ll}{
  \code{dir}\tab Where to write the file dumps.\cr
  \code{filename}\tab filename template, used with \code{\link{sprintf}} 
     to create a file name.\cr
  \code{verbose}\tab toggle verbosity
}
}

\section{Dump options}{
 

\code{$dump(...)}
\tabular{ll}{
  \code{...}\tab Currently unused.\cr
}
}

\section{Retrieve log data}{


\code{$logdata()} returns a list of data frames, sorted in the order returned by
 \code{base::dir()}
}

\section{Details}{


If \code{dir} does not exist it is created. If
}

\seealso{
Other loggers: \code{\link{cellwise}}, \code{\link{simple}}
}
\keyword{datasets}
