% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/guess.r
\name{guess_formats}
\alias{guess_formats}
\title{Guess formats from the supplied date-time character vector.}
\usage{
guess_formats(x, orders, locale = Sys.getlocale("LC_TIME"),
  preproc_wday = TRUE, print_matches = FALSE)
}
\arguments{
\item{x}{input vector of date-times}

\item{orders}{format orders to look for. See examples.}

\item{locale}{locale to use, default to the current locale (also checks en_US)}

\item{preproc_wday}{whether to preprocess week days names. Internal
optimization used by ymd_hms family of functions. If true week days are
substituted with %a or %A accordingly, so that there is no need to supply
this format explicitly.}

\item{print_matches}{for development purpose mainly. If TRUE prints a matrix
of matched templates.}
}
\value{
a vector of matched formats
}
\description{
Guess formats from the supplied date-time character vector.
}
\examples{

x <- c('February 20th 1973',
       "february  14, 2004",
       "Sunday, May 1, 2000",
       "Sunday, May 1, 2000",
       "february  14, 04",
       'Feb 20th 73',
       "January 5 1999 at 7pm",
       "jan 3 2010",
       "Jan 1, 1999",
       "jan 3   10",
       "01 3 2010",
       "1 3 10",
       '1 13 89',
       "5/27/1979",
       "12/31/99",
       "DOB:12/11/00",
       "-----------",
       'Thu, 1 July 2004 22:30:00',
       'Thu, 1st of July 2004 at 22:30:00',
       'Thu, 1July 2004 at 22:30:00',
       'Thu, 1July2004 22:30:00',
       'Thu, 1July04 22:30:00',
       "21 Aug 2011, 11:15:34 pm",
       "-----------",
       "1979-05-27 05:00:59",
       "1979-05-27",
       "-----------",
       "3 jan 2000",
       "17 april 85",
       "27/5/1979",
       '20 01 89',
       '00/13/10',
       "-------",
       "14 12 00",
       "03:23:22 pm")

guess_formats(x, "BdY")
guess_formats(x, "Bdy")
## m also matches b and B; y also matches Y
guess_formats(x, "mdy", print_matches = TRUE)

## T also matches IMSp order
guess_formats(x, "T", print_matches = TRUE)

## b and B are equivalent and match, both, abreviated and full names
guess_formats(x, c("mdY", "BdY", "Bdy", "bdY", "bdy"), print_matches = TRUE)
guess_formats(x, c("dmy", "dbY", "dBy", "dBY"), print_matches = TRUE)


guess_formats(x, c("dBY HMS", "dbY HMS", "dmyHMS", "BdY H"), print_matches = TRUE)

guess_formats(x, c("ymd HMS"), print_matches = TRUE)

}

