% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intrm1pl_o.R
\name{intrm1pl_o}
\alias{intrm1pl_o}
\title{1pl LSIRM model using multiplicative effect}
\usage{
intrm1pl_o(
  data,
  ndim = 2,
  niter = 15000,
  nburn = 2500,
  nthin = 5,
  nprint = 500,
  jump_beta = 0.4,
  jump_theta = 1,
  jump_delta = 1,
  pr_mean_beta = 0,
  pr_sd_beta = 1,
  pr_mean_theta = 0,
  pr_mean_delta = 0,
  pr_sd_delta = 1,
  pr_a_theta = 0.001,
  pr_b_theta = 0.001
)
}
\arguments{
\item{data}{Matrix; binary item response matrix to be analyzed. Each row is assumed to be respondent and its column values are assumed to be response to the corresponding item.}

\item{ndim}{Numeric; dimension of latent space. default value is 2.}

\item{niter}{Numeric; number of iterations to run MCMC sampling. default value is 15000.}

\item{nburn}{Numeric; number of initial, pre-thinning, MCMC iterations to discard. default value is 2500.}

\item{nthin}{Numeric;number of thinning, MCMC iterations to discard. default value is 5.}

\item{nprint}{Numeric; MCMC samples is displayed during execution of MCMC chain for each \code{nprint}. default value is 500.}

\item{jump_beta}{Numeric; jumping rule of the proposal density for beta. default value is 0.4.}

\item{jump_theta}{Numeric; jumping rule of the proposal density for theta. default value is 1.0.}

\item{jump_delta}{Numeric; jumping rule of the proposal density for delta default value is 1.0.}

\item{pr_mean_beta}{Numeric; mean of normal prior for beta. default value is 0.}

\item{pr_sd_beta}{Numeric; standard deviation of normal prior for beta. default value is 1.0.}

\item{pr_mean_theta}{Numeric; mean of normal prior for theta. default value is 0.}

\item{pr_mean_delta}{Numeric; mean of normal prior for delta. default value is 0.}

\item{pr_sd_delta}{Numeric; standard deviation of normal prior for delta. default value is 1.0.}

\item{pr_a_theta}{Numeric; shape parameter of inverse gamma prior for variance of theta. default value is 0.001.}

\item{pr_b_theta}{Numeric; scale parameter of inverse gamma prior for variance of theta. default value is 0.001.}
}
\value{
\code{intrm1pl_o} returns an object of  list containing the following components:
 \item{beta_estimate}{posterior estimation of beta.}
 \item{theta_estimate}{posterior estimation of theta.}
 \item{sigma_theta_estimate}{posterior estimation of standard deviation of theta.}
 \item{delta_estimate}{posterior estimation of delta.}
 \item{beta}{posterior samples of beta.}
 \item{theta}{posterior samples of theta.}
 \item{theta_sd}{posterior samples of standard deviation of theta.}
 \item{delta}{posterior samples of delta.}
 \item{accept_beta}{accept ratio of beta.}
 \item{accept_theta}{accept ratio of theta.}
 \item{ls_mean_item}{posterior estimation of latent position of item.}
 \item{ls_mean_respondent}{posterior estimation of latent position of respondent.}
 \item{ls_mean_lambda}{posterior estimation lambda. The  singular value of the decomposition.}
 \item{ls_respondent}{posterior samples of latent positon of respondent.}
 \item{ls_item}{posterior samples of latent positon of item.}
 \item{ls_lambda}{posterior samples of lambda which is singular value of decomposition.}
}
\description{
\link{intrm1pl_o} is used to fit 1pl LSIRM model using multiplicative effect. 
\link{intrm1pl_o} factorizes item response matrix into column-wise item effect, row-wise respondent effect and further embeds multiplicative effect in a latent space. The resulting latent space provides an interaction map that represents interactions between respondents and items.
}
\details{
\code{intrm1pl_o} models the probability of correct response by respondent \eqn{j} to item \eqn{i} with item effect \eqn{\beta_i}, respondent effect \eqn{\theta_j} in the shared metric space: \deqn{logit(P(Y_{j,i} = 1|\theta_j,\beta_i,\delta_{j,i}))=\theta_j+\beta_i+\delta_{j,i}} The final latent positions of respondents and items are the singular vectors of matrix with its \eqn{j,i} element \eqn{\delta_{j,i}}.
}
\examples{
\donttest{
# generate example item response matrix
data     <- matrix(rbinom(500, size = 1, prob = 0.5), ncol=10, nrow=50)

lsirm_result <- intrm1pl_o(data)

# The code following can achieve the same result.
lsirm_result <- intrm1pl(data)
}

}
