#' Marginal proportions from the PISA 2012 background questionnaire
#'
#' @format A list of 19 named numeric vectors.
#' 
#' @section Details:
#' 
#' A list containing the marginal cumulative proportions for each response category from the PISA 2012 background questionnaire.
#' Elements 1 - 18 are the marginal proportions for the selected items from the background questionnaire.
#' Element 19 is the marginal proportion for the selected mathematics plausible value.
#' 
#'  \tabular{llll}{
#'  \strong{Row/Col} \tab   \strong{Name}  \tab  \strong{Label}                 \tab  \strong{Length} \cr
#'   1               \tab   ST93Q01        \tab  Perseverance                   \tab  5    \cr  
#'   2               \tab   ST93Q03        \tab  Perseverance                   \tab  5    \cr  
#'   3               \tab   ST93Q04        \tab  Perseverance                   \tab  5    \cr  
#'   4               \tab   ST93Q06        \tab  Perseverance                   \tab  5    \cr  
#'   5               \tab   ST93Q07        \tab  Perseverance                   \tab  5    \cr  
#'   6               \tab   ST94Q05        \tab  Openness for Problem Solving   \tab  5    \cr
#'   7               \tab   ST94Q06        \tab  Openness for Problem Solving   \tab  5    \cr
#'   8               \tab   ST94Q09        \tab  Openness for Problem Solving   \tab  5    \cr
#'   9               \tab   ST94Q10        \tab  Openness for Problem Solving   \tab  5    \cr
#'   10              \tab   ST94Q14        \tab  Openness for Problem Solving   \tab  5    \cr  
#'   11              \tab   ST88Q01        \tab  Attitude toward School         \tab  4    \cr     
#'   12              \tab   ST88Q02        \tab  Attitude toward School         \tab  4    \cr     
#'   13              \tab   ST88Q03        \tab  Attitude toward School         \tab  4    \cr     
#'   14              \tab   ST88Q04        \tab  Attitude toward School         \tab  4    \cr     
#'   15              \tab   ST89Q02        \tab  Attitude toward School         \tab  4    \cr   
#'   16              \tab   ST89Q03        \tab  Attitude toward School         \tab  4    \cr      
#'   17              \tab   ST89Q04        \tab  Attitude toward School         \tab  4    \cr     
#'   18              \tab   ST89Q05        \tab  Attitude toward School         \tab  4    \cr     
#'   19              \tab   1PV1MATH       \tab  Mathematics Plausible Value 1  \tab  1    \cr
#'  }
#' 
#' @section Warning:
#' 
#' These data are for illustration purposes only.  Handling of missing data may not be suitable for valid inferences. 
#' 
#' @source 
#' Raw data can be found at \url{https://www.oecd.org/pisa/pisaproducts/pisa2012database-downloadabledata.htm}
#' Codebook can be found at \url{https://www.oecd.org/pisa/pisaproducts/PISA12_stu_codebook.pdf}
#'
"pisa2012_q_marginal"