% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{findInterval3}
\alias{findInterval3}
\title{Find interval numbers of indices}
\usage{
findInterval3(x, v)
}
\arguments{
\item{x}{The numeric vector of interest.}

\item{v}{The vector of break points.}
}
\value{
A vector of \code{length(x)} with values in \code{0:N} where
\code{N = length(v)}.
}
\description{
The implementation of \code{findInterval()} in R from
Advanced R by Hadley Wickham. Given a vector of non-decreasing
breakpoints in v, find the interval containing each element of x; i.e.,
if \code{i <- findInterval3(x,v)}, for each index \code{j} in \code{x},
\code{v[i[j]] <= x[j] < v[i[j] + 1]}, where \code{v[0] := -Inf},
\code{v[N+1] := +Inf}, and \code{N = length(v)}.
}
\examples{
x <- 2:18
v <- c(5, 10, 15) # create two bins [5,10) and [10,15)
cbind(x, findInterval3(x, v))

}
\author{
Kaifeng Lu, \email{kaifenglu@gmail.com}
}
\keyword{internal}
