% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getDesignProportions.R
\name{getDesignUnorderedBinom}
\alias{getDesignUnorderedBinom}
\title{Power and sample size for unordered multi-sample binomial response}
\usage{
getDesignUnorderedBinom(
  beta = NA_real_,
  n = NA_real_,
  ngroups = NA_integer_,
  pi = NA_real_,
  allocationRatioPlanned = NA_integer_,
  rounding = TRUE,
  alpha = 0.05
)
}
\arguments{
\item{beta}{The type II error.}

\item{n}{The total sample size.}

\item{ngroups}{The number of treatment groups.}

\item{pi}{The response probabilities for the treatment groups.}

\item{allocationRatioPlanned}{Allocation ratio for the treatment groups.}

\item{rounding}{Whether to round up sample size. Defaults to 1 for
sample size rounding.}

\item{alpha}{The two-sided significance level. Defaults to 0.05.}
}
\value{
An S3 class \code{designUnorderedBinom} object with the following
components:
\itemize{
\item \code{power}: The power to reject the null hypothesis.
\item \code{alpha}: The two-sided significance level.
\item \code{n}: The maximum number of subjects.
\item \code{ngroups}: The number of treatment groups.
\item \code{pi}: The response probabilities for the treatment groups.
\item \code{effectsize}: The effect size for the chi-square test.
\item \code{calculationTarget}: The calculation target, \code{beta} or
\code{n}.
\item \code{allocationRatioPlanned}: Allocation ratio for the treatment
groups.
\item \code{rounding}: Whether to round up sample size.
}
}
\description{
Obtains the power given sample size or obtains the sample
size given power for the chi-square test for unordered multi-sample
binomial response.
}
\examples{

(design1 <- getDesignUnorderedBinom(
  beta = 0.1, ngroups = 3, pi = c(0.1, 0.25, 0.5), alpha = 0.05))

}
\author{
Kaifeng Lu, \email{kaifenglu@gmail.com}
}
