% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrappers.R
\name{rtpwexp}
\alias{rtpwexp}
\title{Random number generation function of truncated piecewise
exponential distribution}
\usage{
rtpwexp(n, piecewiseSurvivalTime = 0, lambda = 0.0578, lowerBound = 0)
}
\arguments{
\item{n}{The number of observations.}

\item{piecewiseSurvivalTime}{A vector that specifies the starting time of
piecewise exponential survival time intervals. Must start with 0, e.g.,
\code{c(0, 6)} breaks the time axis into 2 event intervals:
[0, 6) and [6, Inf).
Defaults to 0 for exponential distribution.}

\item{lambda}{A vector of hazard rates for the event. One for
each analysis time interval.}

\item{lowerBound}{The left truncation time point for the survival time.
Defaults to 0 for no truncation.}
}
\description{
Obtains random samples from a truncated piecewise
exponential distribution.
}
\examples{
rtpwexp(n = 10, piecewiseSurvivalTime = c(0, 6, 9, 15),
        lambda = c(0.025, 0.04, 0.015, 0.007))

}
\author{
Kaifeng Lu, \email{kaifenglu@gmail.com}
}
