% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_config.R
\name{read_config}
\alias{read_config}
\title{Read an LPJmL configuration file}
\usage{
read_config(filename, from_restart = FALSE, macro = "")
}
\arguments{
\item{filename}{Character string representing path
(if different from current working directory) and filename.}

\item{from_restart}{Logical defining whether config files should be read as
from_restart (transient run) or without (spinup run). Defaults to \code{FALSE}
(spinup run). Used only if file is not pre-compiled (no json).}

\item{macro}{Optional character string to pass one or several macros to the
pre-compiler, e.g. ("-DFROM_RESTART"). Used only if file is not
pre-compiled (no json).}
}
\value{
A nested list object representing the LPJmL configuration read from
\code{filename}.
}
\description{
Reads a configuration (config) file (compilable csjon/js file or json file)
and turns it into a nested list object.
}
\examples{
\dontrun{
 config <- read_config(filename = "config_spinup.json")

 config[["version"]]
 # [1] "5.3"

 config[["pftpar"]][[1]][["name"]]
 # [1] "tropical broadleaved evergreen tree"

 config[["input"]][["coord"]][["name"]]
 # [1] "input_VERSION2/grid.bin"

 # visualize configuration as tree view
 View(config)
}
}
