% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lclphom.R
\name{lclphom}
\alias{lclphom}
\title{Implements lclphom algorithm}
\usage{
lclphom(
  votes_election1,
  votes_election2,
  new_and_exit_voters = c("raw", "regular", "simultaneous", "full", "gold"),
  structural_zeros = NULL,
  iter.max = 1000,
  uniform = TRUE,
  distance.local = c("abs", "max", "none"),
  integers = FALSE,
  solver = "lp_solve",
  integers.solver = "symphony",
  verbose = FALSE,
  ...
)
}
\arguments{
\item{votes_election1}{data.frame (or matrix) of order IxJ (likely of final order Ix(J-1)
in \code{regular} and \code{raw} scenarios when net entries are
estimated by the function) with the votes gained by the \emph{J}
political options competing on election 1 (or origin) in the \emph{I}
territorial units considered. In general, the row marginals
of the \emph{I} tables.}

\item{votes_election2}{data.frame (or matrix) of order IxK (likely of final order Ix(K-1)
in \code{regular} and \code{raw} scenarios  when net exits are
estimated by the function) with the votes gained by
the \emph{K} political options competing on election 2 (or destination)
in the \emph{I} territorial units considered. In general, the column marginals
of the \emph{I} tables.}

\item{new_and_exit_voters}{A character string indicating the level of information available
regarding new entries and exits of the election censuses between the
two elections. This argument captures the different options discussed
on Section 3 of Romero et al. (2020). This argument admits five values:
\code{raw}, \code{regular}, \code{simultaneous}, \code{full} and \code{gold}. Default, \code{raw}.
The argument \code{simultaneous} should be used in a typical ecological inference
problem.}

\item{structural_zeros}{Default, NULL. A list of vectors of length two, indicating the election options
for which no transfer of votes are allowed between election 1 and election 2.
For instance, when new_and_exit_voters is set to \code{"regular"},
lphom implicitly states \code{structural_zeros = list(c(J, K))} in case exits and/or
entries are computed because the sum by rows of \code{votes_election1} and
\code{votes_election2} does not coincide.}

\item{iter.max}{Maximum number of iterations to be performed. The process ends when either the
number of iterations reaches \code{iter.max} or when there is no error reduction in any
local unit between two consecutive iterations. By default, 1000.}

\item{uniform}{A TRUE/FALSE value that indicates if census exits affects all the electoral options in a
(relatively) similar fashion in each voting unit: equation (13) of Pavia and Romero (2021a).
Default, TRUE.}

\item{distance.local}{A string argument that indicates whether the second step of the lphom_local algorithm
should be performed to solve potential indeterminacies of local solutions.
Default, \code{"abs"}.
If \code{distance.local = "abs"} lphom_local selects in its second step the matrix
closer to the temporary global solution under L_1 norm, among the first step compatible matrices.
If \code{distance.local = "max"} lphom_local selects in its second step the matrix
closer to the temporary global solution under L_Inf norm, among the first step compatible matrices.
If \code{distance.local = "none"}, the second step of lphom_local is not performed.}

\item{integers}{A TRUE/FALSE value that indicates whether the problem is solved in integer values in
each iteration, including zero (lphom) and local solutions. Initial LP matrices are
approximate to the closest integer solution solving the corresponding Integer Linear Program.
Default, FALSE.}

\item{solver}{A character string indicating the linear programming solver to be used, only
\code{lp_solve} and \code{symphony}  are allowed. By default, \code{lp_solve}. The package \code{Rsymphony}
needs to be installed for the option \code{symphony} to be used.}

\item{integers.solver}{A character string indicating the linear programming solver to be used to approximate
to the closest integer solution, only \code{symphony} and \code{lp_solve} are allowed.
By default, \code{symphony}. The package \code{Rsymphony} needs to be installed for the option \code{symphony}
to be used. Only used when \code{integers = TRUE}.}

\item{verbose}{A TRUE/FALSE value that indicates if the main outputs of the function should be
printed on the screen. Default, FALSE.}

\item{...}{Other arguments to be passed to the function. Not currently used.}
}
\value{
A list with the following components
\item{VTM}{ A matrix of order JxK with the estimated percentages of row-standardized vote transitions from election 1 to election 2.}
\item{VTM.votes}{ A matrix of order JxK with the estimated vote transitions from election 1 to election 2.}
\item{OTM}{ A matrix of order KxJ with the estimated percentages of the origin of the votes obtained for the different options of election 2.}
\item{HETe}{ The estimated heterogeneity index as defined in equation (15) of Pavia and Romero (2021a).}
\item{VTM.complete}{ A matrix of order J'xK' with the estimated proportions of row-standardized vote transitions from election 1 to election 2, including in \code{regular} and \code{raw} scenarios the row and the column corresponding to net_entries and net_exits even when they are really small, less than 1\% in all units.}
\item{VTM.complete.votes}{ A matrix of order J'xK' with the estimated vote transitions from election 1 to election 2, including in \code{regular} and \code{raw} scenarios the row and the column corresponding to net_entries and net_exits even when they are really small, less than 1\% in all units.}
\item{VTM.prop.units}{ An array of order J'xK'xI with the estimated proportions of vote transitions from election 1 to election 2 attained for each unit in the solution.}
\item{VTM.votes.units}{ An array of order J'xK'xI with the estimated matrix of vote transitions from election 1 to election 2 attained for for each unit in the solution.}
\item{VTM.complete.last.iter}{ A matrix of order J'xK' with the estimated proportions of vote transitions from election 1 to election 2, including in \code{regular} and \code{raw} scenarios the row and the column corresponding to net_entries and net_exits even when they are really small, less than 1\% in all units, corresponding to the final iteration.}
\item{VTM.sequence}{ Array of order J'xK'x(iter+1) (where \code{iter} is the efective number of iterations performed) of the intermediate estimated matrices corresponding to each iteration.}
\item{HETe.sequence}{ Numeric vector of length \code{iter+1} with the \code{HETe} coefficients corresponding to the matrices in \code{VTM.sequence}.}
\item{VTM.prop.units.last.iter}{ An array of order J'xK'xI with the estimated proportions of vote transitions from election 1 to election 2 attained for each unit in the final iteration.}
\item{VTM.votes.units.last.iter}{ An array of order J'xK'xI with the estimated matrix of vote transitions from election 1 to election 2 attained for each unit in the final iteration.}
\item{zeros}{ A list of vectors of length two, indicating the election options for which no transfer of votes are allowed between election 1 and election 2.}
\item{iter}{ The real final number of iterations performed before ending the process.}
\item{iter.units}{ A matrix of order Ix(iter+1) with the number of iteration corresponding to the solution selected for each unit
in each iteration.}
\item{errors}{ A vector of length I with the minimal error observed in the sequence for each unit. It corresponds to
the unit-error associated with the solution linked with either \code{VTM.prop.units} or \code{VTM.votes.units}.}
\item{inputs}{ A list containing all the objects with the values used as arguments by the function.}
\item{origin}{ A matrix with the final data used as votes of the origin election after taking into account the level of information available regarding to new entries and exits of the election censuses between the two elections.}
\item{destination}{ A matrix with the final data used as votes of the origin election after taking into account the level of information available regarding to new entries and exits of the election censuses between the two elections.}
\item{EHet}{ A matrix of order IxK measuring in each spatial unit a distance to the homogeneity hypothesis, that is, the differences under the homogeneity hypothesis between the actual recorded results and the expected results with the solution in each territorial unit for each option of election 2.}
\item{solution_init}{ A list with the main outputs produced by \strong{lphom()}.}
\itemize{
\item{\code{VTM_init}:}{ A matrix of order JxK with the estimated percentages of vote transitions from election 1 to election 2 initially obtained by \strong{lphom()}.}
\item{\code{VTM.votes_init}:}{ A matrix of order JxK with the estimated vote transitions from election 1 to election 2 initially obtained by \strong{lphom()}.}
\item{\code{OTM_init}:}{ A matrix of order KxJ with the estimated percentages of the origin of the votes obtained for the different options of election 2 initially obtained by \strong{lphom()}.}
\item{\code{HETe_init}:}{ The estimated heterogeneity index defined in equation (10) of Romero et al. (2020). }
\item{\code{EHet_init}:}{ A matrix of order IxK measuring in each spatial unit the distance to the homogeneity hypothesis, that is, the differences under the homogeneity hypothesis between the actual recorded results and the expected results, using the \strong{lphom()} solution, in each territorial unit for each option of election 2.}
\item{\code{VTM.complete_init}:}{ A matrix of order J'xK' with the estimated proportions of vote transitions from election 1 to election 2 initially obtained by \strong{lphom()}, including in \code{regular} and \code{raw} scenarios the row and the column corresponding to net_entries and net_exits even when they are really small, less than 1\% in all units.}
\item{\code{VTM.complete.votes_init}:}{ A matrix of order J'xK' with the estimated vote transitions from election 1 to election 2 initially obtained by \strong{lphom()}, including in \code{regular} and \code{raw} scenarios the row and the column corresponding to net_entries and net_exits even when they are really small, less than 1\% in all units.}
}
}
\description{
Estimates RxC vote transfer matrices (ecological contingency tables) with lclphom
}
\details{
Description of the \code{new_and_exit_voters} argument in more detail.
\itemize{
\item{\code{raw}: }{The default value. This argument accounts for the most plausible scenario when
estimating vote transfer matrices: A scenario with two elections elapsed at least some
months where only the raw election data recorded in the \emph{I} territorial units,
in which the area under study is divided, are available.
In this scenario, net exits (basically deaths) and net entries (basically
new young voters) are estimated according to equation (7) of Romero et al. (2020).
Constraints defined by equations (8) and (9) of Romero et al. (2020) and (13) of Pavia
and Romero (2021a) are imposed. In this scenario, when net exits and/or net entries
are negligible (such as between the first- and second-round of French Presidential
elections), they are omitted in the outputs.}
\item{\code{regular}: }{For estimating vote transfer matrices, this value accounts for a scenario with
two elections elapsed at least some months where (i) the column \emph{J} of \code{votes_election1}
corresponds to new young electors who have the right to vote for the first time, (ii)
net exits (basically a consequence of mortality), and maybe other additional net entries,
are computed according equation (7) of Romero et al. (2020), and (iii), when
\code{uniform = TRUE}, within each unit it is assummed that net exits affect
equally all the first \emph{J-1} options of election 1, i.e., equation (13) of Pavia
and Romero (2021a) is applied. Constraints (8) and (9) of Romero et al. (2020)
are imposed to start the process.}
\item{\code{simultaneous}: }{This is the value to be used in a classical ecological inference problems,
such as for racial voting, and in a scenario with two simultaneous elections.
In this scenario, the sum by rows of \code{votes_election1} and \code{votes_election2} must coincide.
Constraints defined by equations (8) and (9) of Romero et al. (2020) and (13) of Pavia and
Romero (2021a) are not included in the model.}
\item{\code{full}: }{This value accounts for a scenario with two elections elapsed at least some
months, where: (i) the column \emph{J-1} of \code{votes_election1} totals new young
electors that have the right to vote for the first time; (ii) the column \emph{J}
of \code{votes_election1} measures new immigrants that have the right to vote; and
(iii) the column \emph{K} of \code{votes_election2} corresponds to total exits of the census
lists (due to death or emigration). In this scenario, the sum by rows of
\code{votes_election1} and \code{votes_election2} must agree and constraints (8)
and (9) of Romero et al. (2020) are imposed.}
\item{\code{gold}: }{This value accounts for a scenario similar to full, where total exits are
separated out between exits due to emigration (column \emph{K-1} of \code{votes_election2})
and death (column \emph{K} of \code{votes_election2}). In this scenario, the sum by rows
of \code{votes_election1} and \code{votes_election2} must agree. The same restrictions
as in the above scenario apply but for both columns \emph{K-1} and \emph{K} of the vote
transition probability matrix}
}
}
\examples{
mt.lc <- lclphom(France2017P[, 1:8] , France2017P[, 9:12], new_and_exit_voters= "raw")
mt.lc$VTM
mt.lc$HETe
mt.lc$solution_init$HETe_init

}
\seealso{
\code{\link{lphom}} \code{\link{tslphom}} \code{\link{nslphom}}

Other linear programing ecological inference functions: 
\code{\link{lp_apriori}()},
\code{\link{lphom_dual}()},
\code{\link{lphom_joint}()},
\code{\link{lphom}()},
\code{\link{nslphom_dual}()},
\code{\link{nslphom_joint}()},
\code{\link{nslphom}()},
\code{\link{tslphom_dual}()},
\code{\link{tslphom_joint}()},
\code{\link{tslphom}()}
}
\author{
Jose M. Pavia, \email{pavia@uv.es}
}
\concept{linear programing ecological inference functions}
