% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lotri.R
\name{lotriMat}
\alias{lotriMat}
\title{Create a matrix from a list of matrices}
\usage{
lotriMat(matList, format = NULL, start = 1L)
}
\arguments{
\item{matList}{list of symmetric named matrices}

\item{format}{The format of dimension names when a sub-matrix is
repeated. The format will be called with the dimension number,
so "ETA[\%d]" would represent "ETA[1]", "ETA[2]", etc}

\item{start}{The number the counter of each repeated dimension
should start.}
}
\value{
Named symmetric block diagonal matrix based on
  concatenating the list of matrices together
}
\description{
This creates a named banded symmetric matrix from a list of named
symmetric matrices.
}
\examples{

testList <- list(lotri({et2 + et3 + et4 ~ c(40,
                           0.1, 20,
                           0.1, 0.1, 30)}),
                 lotri(et5 ~ 6))

testList

lotriMat(testList)


# Another option is to repeat a matrix a number of times.  This
# can be done with list(matrix, # times to repeat).

# In the example below, the first matrix is repeated 3 times
testList <- list(list(lotri({et2 + et3 + et4 ~ c(40,
                           0.1, 20,
                           0.1, 0.1, 30)}), 3),
                 lotri(et5 ~ 6))

lotriMat(testList)

# Notice that the dimension names `et2`, `et3` and `et4` are
# repeated.

# Another option is to name the dimensions.  For example it could
# be `ETA[1]`, `ETA[2]`, etc by using the 'format' option:

lotriMat(testList, "ETA[\%d]")

# Or could start with ETA[2]:

lotriMat(testList, "ETA[\%d]", 2)

}
\author{
Matthew Fidler
}
