% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/l_configure.R
\name{l_configure}
\alias{l_configure}
\alias{[<-.loon}
\alias{"[<-.loon"}
\title{Modify one or multiple plot states}
\usage{
l_configure(target, ...)
}
\arguments{
\item{target}{either an object of class loon or a vector that specifies the
widget, layer, glyph, navigator or context completely. The widget is
specified by the widget path name (e.g. \code{'.l0.plot'}), the remaining
objects by their ids.}

\item{...}{state=value pairs}
}
\description{
All of loon's displays have plot states. Plot states specify
  what is displayed, how it is displayed and if and how the plot is linked
  with other loon plots. Layers, glyphs, navigators and contexts have states
  too (also refered to as plot states). This function modifies one or
  multiple plot states.
}
\examples{
if(interactive()){

p <- l_plot(iris, color = iris$Species)
l_configure(p, color='red')
p['size'] <- ifelse(iris$Species == "versicolor", 2, 8)
}
}
\seealso{
\code{\link{l_cget}}, \code{\link{l_info_states}},
  \code{\link{l_create_handle}}
}
