% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/l_layer_smooth.R
\name{l_layer_smooth}
\alias{l_layer_smooth}
\title{Layer a smooth line for \code{loon}}
\usage{
l_layer_smooth(
  widget,
  x = NULL,
  y = NULL,
  method = "loess",
  group = "",
  formula = y ~ x,
  interval = c("none", "confidence", "prediction"),
  n = 80,
  span = 0.75,
  level = 0.95,
  methodArgs = list(),
  linecolor = "steelblue",
  linewidth = 2,
  linedash = "",
  confidenceIntervalArgs = list(linecolor = "gray80", linewidth = 4, linedash = ""),
  predictionIntervalArgs = list(linecolor = "gray50", linewidth = 3, linedash = 1),
  label = "smooth",
  parent = "root",
  index = 0,
  ...
)
}
\arguments{
\item{widget}{widget path name as a string}

\item{x}{The \code{x} coordinates of line. If it is not provided, \code{x} will be inherited from widget}

\item{y}{The \code{y} coordinates of line. If it is not provided, \code{y} will be inherited from widget}

\item{method}{Smoothing method (function) to use, accepts either a character vector,
e.g. "lm", "glm", "loess" or a function, e.g. MASS::rlm or mgcv::gam, stats::lm, or stats::loess.}

\item{group}{Data can be grouped by n dimensional aesthetics attributes, e.g. "color", "size".
In addition, any length n vector or data.frame is accommodated.}

\item{formula}{Formula to use in smoothing function, eg. y ~ x, y ~ poly(x, 2), y ~ log(x)}

\item{interval}{type of interval, could be "none", "confidence" or "prediction" (not for \code{glm})}

\item{n}{Number of points at which to evaluate smoother.}

\item{span}{Controls the amount of smoothing for the default \code{loess} smoother.
Smaller numbers produce wigglier lines, larger numbers produce smoother lines.}

\item{level}{Level of confidence interval to use (0.95 by default).}

\item{methodArgs}{List of additional arguments passed on to the modelling function defined by method.}

\item{linecolor}{fitted line color.}

\item{linewidth}{fitted line width}

\item{linedash}{fitted line dash}

\item{confidenceIntervalArgs}{the line color, width and dash for confidence interval}

\item{predictionIntervalArgs}{the line color, width and dash for prediction interval}

\item{label}{label used in the layers inspector}

\item{parent}{group layer}

\item{index}{index of the newly added layer in its parent group}

\item{...}{additional state initialization arguments, see \code{\link{l_info_states}}}
}
\description{
Display a smooth line layer
}
\examples{
if(interactive()) {
# loess fit
p <- l_plot(iris, color = iris$Species)
l1 <- l_layer_smooth(p, interval = "confidence")
l_layer_hide(l1)

# the fits are grouped by points color
l2 <- l_layer_smooth(p, group = "color",
                     method = "lm")

# so far, all intervals are hidden
ls <- l_layer_getChildren(l2)
intervals <- l_layer_getChildren(l_create_handle(c(p,ls[3])))
ci <- l_create_handle(c(p,intervals[3]))
l_layer_show(ci)
# show prediction interval
pi <- l_create_handle(c(p,intervals[2]))
l_layer_show(pi)
# hide all
l_layer_hide(l2)

# Draw a fitted line based on a new data set
shortSepalLength <- (iris$Sepal.Length < 5)
l3 <- l_layer_smooth(p,
                     x = iris$Sepal.Length[shortSepalLength],
                     y = iris$Sepal.Width[shortSepalLength],
                     method = "lm",
                     linecolor = "firebrick",
                     interval = "prediction")
l_layer_hide(l3)

if(require(mgcv)) {
  # a full tensor product smooth
  ## linecolor is the same with the points color
  l4 <- l_layer_smooth(p,
                       method = "gam",
                       formula = y~te(x))
  l_layer_hide(l4)
}

# facets
fp <- l_facet(p, by = iris$Species, inheritLayers = FALSE)
l5 <- l_layer_smooth(fp, method = "lm")

# generalized linear model
if(require("loon.data")) {
  data("SAheart")
  # logit regression
  chd <- as.numeric(SAheart$chd) - 1
  age <- SAheart$age
  p1 <- l_plot(age, chd,
               title = "logit regression")
  gl1 <- l_layer_smooth(p1,
                        method = "glm",
                        methodArgs = list(family = binomial()),
                        interval = "conf")

  # log linear regression
  counts <- c(18,17,15,20,10,20,25,13,12)
  age <- c(40,35,53,46,20,33,48,25,23)
  p2 <- l_plot(age, counts,
               title = "log-linear regression")
  gl2 <- l_layer_smooth(p2,
                        method = "glm",
                        methodArgs = list(family = poisson()),
                        interval = "conf")
}
}
}
