% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/l_plot.R
\name{l_plot}
\alias{l_plot}
\title{Create an interactive loon plot widget}
\usage{
l_plot(x, y, ...)
}
\arguments{
\item{x}{the coordinates of points in the \code{\link{l_plot}}.
Alternatively, a single plotting structure, function, or any R object having an \code{\link{l_plot}}
method can be provided.}

\item{y}{the y coordinates of points in the \code{\link{l_plot}}, optional if x is an
appropriate structure.}

\item{...}{named arguments to modify plot states. See \code{\link{l_info_states}}
of any instantiated \code{l_plot} for examples of names and values.}
}
\value{
widget handle
}
\description{
\code{l_plot} is a generic function for creating interactive
  visualization environments for \R objects.
}
\details{
Like \code{\link{plot}} in \R, \code{\link{l_plot}} is
the generic plotting function for objects in loon.
The default method \code{\link{l_plot.default}} produces the interactive
scatterplot in loon.
This is the workhorse of `loon` and is often a key part of many
other displays (e.g. \code{\link{l_pairs}} and \code{\link{l_navgraph}}).

For example, the  methods include \code{\link{l_plot.default}} (the basic interactive scatterplot),
\code{\link{l_plot.density}} (layers output of \code{\link{density}} in an empty scatterplot),
 \code{\link{l_plot.map}}  (layers a map in an empty scatterplot), and
\code{\link{l_plot.stl}} (a compound display of the output of \code{\link{stl}}).


A complete list is had from \code{methods(l_plot)}.

\ifelse{html}{
\out{<div style="background: #dff0d8; padding: 15px;"> To get started with loon
  it is recommended to follow the introductory loon vignette <code>vignette(topic = "introduction", package  = "loon")</code>
  and to explore loon's website accessible via <code>l_help()</code>. </div>
}}{
To get started with loon it is recommended to follow the introductory loon vignette
\code{vignette(topic = "introduction", package  = "loon")}
  and to explore loon's website accessible via \code{l_help()}.
}


  \if{html}{ The general direct manipulation and interaction gestures are
  outlined in the following figures.

  Zooming and Panning

  \figure{gestures_zoom_pan.png}{options: alt="Zoom pan gestures"}

  Selecting Points/Objects

  \figure{gestures_select.png}{options: alt="Select gestures"}

  Moving Points on the Scatterplot Display

  \figure{gestures_move.png}{options: alt="Move gestures"}

  }
}
\examples{
if(interactive()){

# ordinary use
p <- with(iris, l_plot(Sepal.Width, Petal.Length, color=Species))

versi <- iris$Species == "versicolor"
p["glyph"][versi] <- "ctriangle"

# Get an R (grid) graphics plot of the current loon plot
plot(p)
# or with more control about grid parameters
grid.loon(p)
# or to save the grid data structure (grob) for later use
pg <- loonGrob(p)

# plot a density estimate
set.seed(314159)
ds <- density(rnorm(1000))
p <- l_plot(ds,  title = "density estimate",
            xlabel = "x", ylabel = "density",
            showScales = TRUE)
plot(p)

}
}
\seealso{
\code{\link{l_plot_arguments}} and \code{\link{l_plot.default}}.

Other two-dimensional plotting functions: 
\code{\link{l_plot.decomposed.ts}()},
\code{\link{l_plot.default}()},
\code{\link{l_plot.density}()},
\code{\link{l_plot.stl}()}

Other loon interactive states: 
\code{\link{l_info_states}()},
\code{\link{l_plot.default}()},
\code{\link{l_state_names}()},
\code{\link{names.loon}()}
}
\concept{loon interactive states}
\concept{two-dimensional plotting functions}
