% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/l_navigator.R
\name{l_navigator_add}
\alias{l_navigator_add}
\title{Add a Navigator to a Graph}
\usage{
l_navigator_add(widget, from = "", to = "", proportion = 0,
  color = "orange", ...)
}
\arguments{
\item{widget}{graph widget}

\item{from}{The position of the navigator on the graph is defined by the
states \code{from}, \code{to} and \code{proportion}. The states \code{from}
and \code{to} hold vectors of node names of the graph. The
\code{proportion} state is a number between and including \code{0} and 
\code{1} and defines how far the navigator is between the last element of 
\code{from} and the first element of \code{to}. The \code{to} state can 
also be an empty string \code{''} if there is no further node to go to. 
Hence, the concatenation of \code{from} and \code{to} define a path on the 
graph.}

\item{to}{see descriptoin above for \code{from}}

\item{proportion}{see descriptoin above for \code{from}}

\item{color}{of navigator}

\item{...}{named arguments passed on to modify navigator states}
}
\value{
navigator handle with navigator id
}
\description{
To turn a graph into a navigation graph you need to add one or 
  more navigators. Navigator have their own set of states that can be queried
  and modified.
}
\details{
For more information run: \code{l_help("learn_R_display_graph.html#navigators")}
}
\seealso{
\code{\link{l_navigator_delete}}, \code{\link{l_navigator_ids}},
  \code{\link{l_navigator_walk_path}},
  \code{\link{l_navigator_walk_forward}},
  \code{\link{l_navigator_walk_backward}}, \code{\link{l_navigator_relabel}},
  \code{\link{l_navigator_getLabel}}
}
