% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/l_layer.R
\name{l_layer_bbox}
\alias{l_layer_bbox}
\title{Get the bounding box of a layer.}
\usage{
l_layer_bbox(widget, layer = "root")
}
\arguments{
\item{widget}{widget path or layer object of class \code{'l_layer'}}

\item{layer}{layer id. If the widget argument is of class \code{'l_layer'}
then the layer argument is not used}
}
\value{
Numeric vector of length 4 with (xmin, ymin, xmax, ymax) of the
  bounding box
}
\description{
The bounding box of a layer returns the coordinates of the
  smallest rectangle that encloses all the elements of the layer.
}
\examples{
p <- with(iris, l_plot(Sepal.Length ~ Sepal.Width, color=Species))
l_layer_bbox(p, layer='model')

l <- l_layer_rectangle(p, x=0:1, y=30:31)
l_layer_bbox(p, l)

l_layer_bbox(p, 'root')
}
