% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loon2ggplot-l_compound.R,
%   R/loon2ggplot-l_facet_ggplot.R, R/loon2ggplot-l_facet_grid.R,
%   R/loon2ggplot-l_facet_wrap.R, R/loon2ggplot-l_layer_graph.R,
%   R/loon2ggplot-l_layer_histogram.R, R/loon2ggplot-l_layer_scatterplot.R,
%   R/loon2ggplot-l_pairs.R, R/loon2ggplot-l_patchwork.R,
%   R/loon2ggplot-l_serialaxes.R, R/loon2ggplot-zenLoon.R, R/loon2ggplot.R
\name{loon2ggplot.l_compound}
\alias{loon2ggplot.l_compound}
\alias{loon2ggplot.l_facet_ggplot}
\alias{loon2ggplot.l_facet_grid}
\alias{loon2ggplot.l_facet_wrap}
\alias{loon2ggplot.l_layer_graph}
\alias{loon2ggplot.l_layer_histogram}
\alias{loon2ggplot.l_layer_scatterplot}
\alias{loon2ggplot.l_pairs}
\alias{loon2ggplot.l_patchwork}
\alias{loon2ggplot.l_serialaxes}
\alias{loon2ggplot.zenLoon}
\alias{loon2ggplot}
\alias{loon2ggplot.default}
\alias{loon2ggplot.l_plot}
\alias{loon2ggplot.l_hist}
\alias{loon2ggplot.l_plot3D}
\title{Turn a \code{loon} widget to a \code{ggplot} object}
\usage{
\method{loon2ggplot}{l_compound}(
  target,
  asAes = TRUE,
  selectedOnTop = TRUE,
  showNearestColor = FALSE,
  ...
)

\method{loon2ggplot}{l_facet_ggplot}(
  target,
  asAes = TRUE,
  selectedOnTop = TRUE,
  showNearestColor = FALSE,
  ...
)

\method{loon2ggplot}{l_facet_grid}(
  target,
  asAes = TRUE,
  selectedOnTop = TRUE,
  showNearestColor = FALSE,
  ...
)

\method{loon2ggplot}{l_facet_wrap}(
  target,
  asAes = TRUE,
  selectedOnTop = TRUE,
  showNearestColor = FALSE,
  ...
)

\method{loon2ggplot}{l_layer_graph}(
  target,
  asAes = TRUE,
  selectedOnTop = TRUE,
  showNearestColor = FALSE,
  ...
)

\method{loon2ggplot}{l_layer_histogram}(
  target,
  asAes = TRUE,
  selectedOnTop = TRUE,
  showNearestColor = FALSE,
  ...
)

\method{loon2ggplot}{l_layer_scatterplot}(
  target,
  asAes = TRUE,
  selectedOnTop = TRUE,
  showNearestColor = FALSE,
  ...
)

\method{loon2ggplot}{l_pairs}(
  target,
  asAes = TRUE,
  selectedOnTop = TRUE,
  showNearestColor = FALSE,
  ...
)

\method{loon2ggplot}{l_patchwork}(
  target,
  asAes = TRUE,
  selectedOnTop = TRUE,
  showNearestColor = FALSE,
  ...
)

\method{loon2ggplot}{l_serialaxes}(
  target,
  asAes = TRUE,
  selectedOnTop = TRUE,
  showNearestColor = FALSE,
  ...
)

\method{loon2ggplot}{zenLoon}(
  target,
  asAes = TRUE,
  selectedOnTop = TRUE,
  showNearestColor = FALSE,
  ...
)

loon2ggplot(
  target,
  asAes = TRUE,
  selectedOnTop = TRUE,
  showNearestColor = FALSE,
  ...
)

\method{loon2ggplot}{default}(
  target,
  asAes = TRUE,
  selectedOnTop = TRUE,
  showNearestColor = FALSE,
  ...
)

\method{loon2ggplot}{l_plot}(
  target,
  asAes = TRUE,
  selectedOnTop = TRUE,
  showNearestColor = FALSE,
  ...
)

\method{loon2ggplot}{l_hist}(
  target,
  asAes = TRUE,
  selectedOnTop = TRUE,
  showNearestColor = FALSE,
  ...
)

\method{loon2ggplot}{l_plot3D}(
  target,
  asAes = TRUE,
  selectedOnTop = TRUE,
  showNearestColor = FALSE,
  ...
)
}
\arguments{
\item{target}{a \code{loon} or a vector that specifies the
widget, layer, glyph, navigator or context completely.
The widget is specified by the widget path name (e.g. '.l0.plot'),
the remaining objects by their ids.}

\item{asAes}{logical; set aesthetics attributes, i.e. `color`, `fill` as
variables (default \code{TRUE}) or general visual properties (\code{FALSE}).
See details}

\item{selectedOnTop}{logical and default is \code{TRUE}; whether to display the
selected points on top. See details.}

\item{showNearestColor}{logical and default is \code{FALSE}; if \code{TRUE},
the legend of color and fill (hex code) would be converted to the \code{R} built-in
color names. For some hex codes, there are no precise matching.
Consequently, these colors will be converted to the \code{R} built-in color names
which are the "nearest" of these hex codes.}

\item{...}{arguments used inside \code{loon2ggplot()}, not used by this method}
}
\value{
a \code{ggplot} object (or a \code{patchwork} object, a extension of \code{ggplot2})
}
\description{
Create a \code{ggplot} object from a \code{loon} widget
}
\details{
In \code{ggplot2}, typically, there are two ways to set the
aesthetic attributes, either take them as variables \code{asAes = TRUE}
(set in the function \code{aes()}) or constants \code{asAes = FALSE}.
The main benefits to consider them as variables are that 1. legend could be displayed;
2. convenient for further analysis.

In \code{loon}, when points were \code{selected} (highlighted),
the order would be changed so that
the highlighted points would be displayed at the front.
To turn the \code{loon} plot static, if \code{selectedOnTop = TRUE},
the points would be partitioned into two
groups -- one group representing the un-highlighted points,
and the other group representing the highlighted points.
The un-highlighted group would be drawn first,
then the selected group;
if \code{selectedOnTop = FALSE}, no partition would be applied so that
the displayed order remained. However, the highlighted points could be
displayed at the back. See examples.
}
\examples{
if(interactive()) {
######## Basic ########
lp <- l_plot(iris,
             color = iris$Species,
             glyph = "circle")
gp <- loon2ggplot(lp)
gp # a ggplot object

# add smooth layer, grouped by color
gp +
  geom_smooth(aes(color = color)) +
  # give meaningful legend label names
  scale_color_manual(
    # make sure the order is correct
    values = unique(hex12tohex6(lp['color'])),
    labels = c("setosa", "versicolor", "virginica")
  )

# histogram
lh <- l_hist(mtcars$mpg,
             color = factor(mtcars$gear))

gh0 <- loon2ggplot(lh)
# facet by `fill`
gh0 + facet_wrap(~fill)

######## Argument `asAes` ########
gh1 <- loon2ggplot(lh, asAes = FALSE)
gh1
\dontrun{
# The bins are constructed by `ggplot2::geom_rect()`
# Very limited manipulations can be made
# ERROR
gh1 + facet_wrap(~fill)
}

######## Argument `selectedOnTop` ########
p <- l_plot(iris, color = iris$Species)
p['selected'][iris$Petal.Length > 5] <- TRUE
g <- loon.ggplot(p)
# It looks correct.
g
# facet by "Species"
\dontrun{
g + facet_wrap(iris$Species)
}
# Something is wrong here. There is a pink point (at least one)
# in species "versicolor"! It is because after points are
# highlighted, the displayed order has been changed.
# Set `selectedOnTop` as FALSE, as in
loon.ggplot(p, selectedOnTop = FALSE) +
  facet_wrap(iris$Species)

\donttest{
######## l_patchwork --> ggplot ########
library(patchwork)
p1 <- ggplot(mtcars) + geom_point(aes(mpg, disp))
p2 <- ggplot(mtcars) +
   geom_boxplot(aes(gear, disp, group = gear))
p3 <- ggplot(mtcars) + geom_smooth(aes(disp, qsec))
design <- c(
  area(1,1),
  area(1,2),
  area(2,1,2,2)
)
pp <- p1 + p2 + p3 + plot_layout(design = design)

# turn a patchwork obj to a loon (l_compound)
lp <- ggplot2loon(pp)
# turn a loon (l_compound) back to a patchwork
plp <- loon2ggplot(lp)
plp # almost identical to pp


######## zneplots --> ggplot ########
library(zenplots)
stopifnot(packageVersion("zenplots") > "1.0.4")
zen <- zenplots::zenplot(iris, plot1d = "density", pkg = "loon")
ggzen <- loon.ggplot(zen)
ggzen +
  patchwork::plot_annotation(title = "This is a ggplot")
}
}
}
