% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot2loon_ggplot.R
\name{ggplot2loon}
\alias{ggplot2loon}
\title{\code{ggplot} to \code{loon}}
\usage{
ggplot2loon(
  ggObj,
  ...,
  activeGeomLayers = integer(0),
  layerId = NULL,
  scaleToFun = NULL,
  ggGuides = FALSE,
  parent = NULL,
  pack = TRUE,
  exteriorLabelProportion = 1/5,
  canvasHeight = 700,
  canvasWidth = 850,
  tkLabels = NULL
)
}
\arguments{
\item{ggObj}{a \code{ggplot} or \code{ggmatrix} object}

\item{...}{named arguments to modify loon plot states}

\item{activeGeomLayers}{to determine which geom layer is active. Only \code{geom_point()}
 and \code{geom_histogram()} can be set as active geom layer(s) so far.
(Notice, more than one \code{geom_point()} layers can be set as active layers,
 but only one \code{geom_histogram()} can be set as an active geom layer)}

\item{layerId}{numerical; which layer to scale to}

\item{scaleToFun}{scale to function. See \code{\link{zoom}}.}

\item{ggGuides}{logical (default \code{FALSE}) to determine whether to draw a ggplot background or not.}

\item{parent}{parent widget path (Tk toplevel)}

\item{pack}{logical (default \code{TRUE}) to pack widgets.
If \code{FALSE}, widgets will be produced but won't be packed and so will not appear in the display.}

\item{exteriorLabelProportion}{space assigned to the vertical height/horizontal width of each exterior label
expressed as a proportion of a single plot's height/width.  Default is 0.2.
This is translated to a row/column span = 1 / exteriorLabelProportion for the plot size in
\code{tkgrid()}.}

\item{canvasHeight}{the height of canvas}

\item{canvasWidth}{the width of canvas}

\item{tkLabels}{Deprecated: logical (or \code{NULL}) to indicate whether the plot(s) are to be wrapped by
exterior labels (title, subtitle, xlabel or ylabel) using \code{tk.grid()}}
}
\value{
a \code{loon} single or compound widget
}
\description{
Create an interactive `loon` widget from a \code{ggplot} object
}
\examples{

if(interactive()) {
  p <- ggplot(mtcars, aes(wt, mpg)) + geom_point()
  g <- ggplot2loon(p)

  p <- ggplot(mtcars) + geom_point(aes(x = wt, y = mpg,
     colour = factor(gear))) + facet_wrap(~am)
  g1 <- ggplot2loon(p)
}

\donttest{
df <- data.frame(
  x = rnorm(120, c(0, 2, 4)),
  y = rnorm(120, c(1, 2, 1)),
  z = letters[1:3]
)
df2 <- dplyr::select(df, -z)
scatterplots <- ggplot(df, aes(x, y)) +
  geom_point(data = df2, colour = "grey70") +
  geom_point(aes(colour = z)) +
  facet_wrap(~z)

# We can select the first geom_point layer to be
# the active layer as in
suppressWarnings(
  lp_scatterplots_active1 <- ggplot2loon(scatterplots,
                               activeGeomLayers = 1,
                               linkingGroup = "test")
)
# Here the grey points are linked (not the coloured ones)

# We can select the second geom_point layer to be
# the active layer as in
lp_scatterplots_active2 <- ggplot2loon(scatterplots, activeGeomLayers = 2)
# Here the colour points are linked

# We can also select the both geom_point layers to be
# the active layer as in
suppressWarnings(
 lp_scatterplots_active12 <- ggplot2loon(scatterplots, activeGeomLayers = c(1,2))
)
# Here the colour points and grey points are both linked

########### ggmatrix to loon ###########
pm <- GGally::ggpairs(iris, column = 1:4, ggplot2::aes(colour=Species))
lg <- ggplot2loon(pm)
}


}
