% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/endpoint.R
\name{endpoint.tstab}
\alias{endpoint.tstab}
\alias{prof_gp_endpt}
\title{Threshold stability plots for endpoint}
\usage{
endpoint.tstab(
  time,
  time2 = NULL,
  event = NULL,
  thresh = 0,
  type = c("right", "left", "interval", "interval2"),
  ltrunc = NULL,
  rtrunc = NULL,
  weights = rep(1, length(time)),
  psi = NULL,
  confint = FALSE,
  level = 0.95,
  arguments = NULL,
  plot = TRUE,
  ...
)

prof_gp_endpt(
  time,
  time2 = NULL,
  event = NULL,
  thresh = 0,
  type = c("right", "left", "interval", "interval2"),
  ltrunc = NULL,
  rtrunc = NULL,
  weights = rep(1, length(time)),
  psi = NULL,
  confint = FALSE,
  level = 0.95,
  arguments = NULL,
  ...
)
}
\arguments{
\item{time}{excess time of the event of follow-up time, depending on the value of event}

\item{time2}{ending excess time of the interval for interval censored data only.}

\item{event}{status indicator, normally 0=alive, 1=dead. Other choices are \code{TRUE}/\code{FALSE} (\code{TRUE} for death).
For interval censored data, the status indicator is 0=right censored, 1=event at time, 2=left censored, 3=interval censored.
Although unusual, the event indicator can be omitted, in which case all subjects are assumed to have experienced an event.}

\item{thresh}{vector of thresholds}

\item{type}{character string specifying the type of censoring. Possible values are "\code{right}", "\code{left}", "\code{interval}", "\code{interval2}".}

\item{ltrunc}{lower truncation limit, default to \code{NULL}}

\item{rtrunc}{upper truncation limit, default to \code{NULL}}

\item{weights}{weights for observations}

\item{psi}{mandatory vector of endpoints at which to compute the profile}

\item{confint}{logical; if \code{TRUE}, return a \code{level} confidence interval instead of a list with the profile log-likelihood components}

\item{level}{numeric; the level for the confidence intervals}

\item{arguments}{a named list specifying default arguments of the function that are common to all \code{elife} calls}

\item{plot}{logical; if \code{TRUE}, return a plot}

\item{...}{additional parameters, currently ignored}
}
\value{
a data frame with the threshold, endpoint estimates and profile confidence intervals
}
\description{
This function calls \code{endpoint.profile} to compute
the endpoint with profile likelihood confidence intervals
at each threshold. It then returns a data frame and
a plot
}
\keyword{internal}
