% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lrcca.R
\name{lol.project.lrcca}
\alias{lol.project.lrcca}
\title{Low-rank Canonical Correlation Analysis (LR-CCA)}
\usage{
lol.project.lrcca(X, Y, r, ...)
}
\arguments{
\item{X}{[n, d] the data with \code{n} samples in \code{d} dimensions.}

\item{Y}{[n] the labels of the samples with \code{K} unique labels.}

\item{r}{the rank of the projection.}

\item{...}{trailing args.}
}
\value{
A list containing the following:
\item{\code{A}}{\code{[d, r]} the projection matrix from \code{d} to \code{r} dimensions.}
\item{\code{d}}{the eigen values associated with the eigendecomposition.}
\item{\code{ylabs}}{\code{[K]} vector containing the \code{K} unique, ordered class labels.}
\item{\code{centroids}}{\code{[K, d]} centroid matrix of the \code{K} unique, ordered classes in native \code{d} dimensions.}
\item{\code{priors}}{\code{[K]} vector containing the \code{K} prior probabilities for the unique, ordered classes.}
\item{\code{Xr}}{\code{[n, r]} the \code{n} data points in reduced dimensionality \code{r}.}
\item{\code{cr}}{\code{[K, r]} the \code{K} centroids in reduced dimensionality \code{r}.}
}
\description{
A function for implementing the Low-rank Canonical Correlation Analysis (LR-CCA) Algorithm.
}
\section{Details}{

For more details see the help vignette:
\code{vignette("lrcca", package = "lolR")}
}

\examples{
library(lolR)
data <- lol.sims.rtrunk(n=200, d=30)  # 200 examples of 30 dimensions
X <- data$X; Y <- data$Y
model <- lol.project.lrcca(X=X, Y=Y, r=5)  # use lrcca to project into 5 dimensions
}
\author{
Eric Bridgeford and Minh Tang
}
