% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logr.R
\name{log_open}
\alias{log_open}
\title{Open a log}
\usage{
log_open(file_name = "", logdir = TRUE, show_notes = TRUE)
}
\arguments{
\item{file_name}{The name of the log file.  If no path is specified, the
working directory will be used.}

\item{logdir}{Send the log to a log directory named "log".  If the log
directory does not exist, the function will create it.  Valid values are
TRUE and FALSE. The default is TRUE.}

\item{show_notes}{If true, will write notes to the log.  Valid values are
TRUE and FALSE. Default is TRUE.}
}
\value{
The path of the log.
}
\description{
A function to initialize the log file.
}
\details{
The \code{log_open} function initializes and opens the log file.
This function must be called first, before any logging can occur.
The function determines the log path, attaches event handlers,
clears existing log files, and initiates a new log.

The \code{file_name} parameter may be a full path, a relative path, or
a file name.  An relative path or file name will be assumed to be relative
to the current working directory.  If the \code{file_name} does
not have a '.log' extension, the \code{log_open} function will add it.

If requested in the \code{logdir} parameter, the \code{log_open}
function will write to a 'log' subdirectory of the path specified in the
\code{file_name}.  If the 'log' subdirectory does not exist,
the function will create it.

The log file will be initialized with a header that shows the log file name,
the current working directory, the current user, and a timestamp of
when the \code{log_open} function was called.

All errors, the last warning, and any \code{log_print} output will be
written to the log.  The log file will exist in the location specified in the
file_name parameter, and will normally have a '.log' extension.

If errors or warnings are generated, a second file will
be written that contains only error and warning messages.  This second file
will have a '.msg' extension and will exist in the specified log directory.
If the log is clean, the msg file will not be created.
The purpose of the msg file is to give the user a visual indicator from
the file system that an error or warning occurred.  This indicator
msg file is useful when running programs in batch.

To use \strong{logr}, call \code{log_open}, and then make calls to
\code{log_print} as needed to print variables or data frames to the log.
The \code{log_print} function can be used in place of a standard
\code{print} function.  Anything printed with \code{log_print} will
be printed to the log, and to the console if working interactively.

This package provides the functionality of \code{sink}, but in much more
user-friendly way.  Recommended usage is to call \code{log_open} at the top
of the script, call \code{log_print} as needed to log interim state,
and call \code{log_close} at the bottom of the script.
}
\examples{
# Create temp file location
tmp <- file.path(tempdir(), "test.log")

# Open log
lf <- log_open(tmp)

# Send message to log
log_print("High Mileage Cars Subset")

# Perform operations
hmc <- subset(mtcars, mtcars$mpg > 20)

# Print data to log
log_print(hmc)

# Close log
log_close()

# View results
writeLines(readLines(lf))
}
\seealso{
\code{\link{log_print}} for printing to the log (and console),
and \code{\link{log_close}} to close the log.
}
