% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wtp.R
\name{wtpCompare}
\alias{wtpCompare}
\title{Compare WTP from preference and WTP space models}
\usage{
wtpCompare(model_pref, model_wtp, scalePar)
}
\arguments{
\item{model_pref}{The output of a "preference space" model estimated using
the \code{logitr()} function.}

\item{model_wtp}{The output of a "willingness to pay space" model estimated
using the \code{logitr()} function.}

\item{scalePar}{The name of the column that identifies the scale variable,
which is typically "price" for WTP space models, but could be any
continuous variable, such as "time".}
}
\value{
A data frame comparing the WTP estimates from preference space and
WTP space models.
}
\description{
Returns a comparison of the WTP between a preference space and WTP space
model.
}
\details{
Willingness to pay (WTP) is first computed from the preference space model
by dividing the estimated parameters by the scale parameter (typically
"price" to obtain WTP estimates). Then those estimates are compared against
the WTP values directly estimated from the "WTP" space model. Uncertainty is
handled via simulation.
}
\examples{
library(logitr)

# Estimate a MNL model in the Preference space
mnl_pref <- logitr(
  data    = yogurt,
  outcome = "choice",
  obsID   = "obsID",
  pars    = c("price", "feat", "brand")
)

# Compute the WTP implied from the preference space model
wtp_mnl_pref <- wtp(mnl_pref, scalePar = "price")

# Estimate a MNL model in the WTP Space, using the computed WTP values
# from the preference space model as starting points
mnl_wtp <- logitr(
  data      = yogurt,
  outcome   = "choice",
  obsID     = "obsID",
  pars      = c("feat", "brand"),
  scalePar  = "price",
  startVals = wtp_mnl_pref$Estimate
)

# Compare the WTP between the two spaces
wtpCompare(mnl_pref, mnl_wtp, scalePar = "price")
}
\keyword{logitr}
\keyword{wtp}
