% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{apolloModeChoiceData}
\alias{apolloModeChoiceData}
\title{Simulated SP dataset of mode choice (from the {apollo} package).}
\format{
\tabular{ll}{
   Variable \tab Description \cr
   \code{ID} \tab individual identifiers \cr
   \code{obsID} \tab identifier for unique choice observation \cr
   \code{altID} \tab alternative in each choice observation \cr
   \code{qID} \tab Numeric. Consecutive ID of SP choice tasks. \cr
   \code{choice} \tab dummy code for choice (1 or 0) \cr
   \code{mode} \tab Character describing mode: "air", "rail", "car", "bus" \cr
   \code{time} \tab Travel time in minutes. \cr
   \code{cost} \tab cost (in GBP) of trip. \cr
   \code{access} \tab Access time in minutes. \cr
   \code{service} \tab Numeric. Additional services: 1 for no-frills, 2 for wifi, 3 for food. \cr
   \code{mode_air} \tab Dummy coefficient for "air" mode. \cr
   \code{mode_bus} \tab Dummy coefficient for "bus" mode. \cr
   \code{mode_car} \tab Dummy coefficient for "car" mode. \cr
   \code{mode_rail} \tab Dummy coefficient for "rail" mode. \cr
   \code{service_no_frills} \tab Dummy coefficient for "no-frills" additional service. \cr
   \code{service_wifi} \tab Dummy coefficient for "wifi" additional service. \cr
   \code{service_food} \tab Dummy coefficient for "food" additional service. \cr
   \code{time_car} \tab Travel time (in minutes) for car trip. \cr
   \code{time_bus} \tab Travel time (in minutes) for bus trip. \cr
   \code{time_air} \tab Travel time (in minutes) for air trip. \cr
   \code{time_rail} \tab Travel time (in minutes) for rail trip. \cr
   \code{female} \tab Numeric. Sex of individual. 1 for female, 0 for male. \cr
   \code{business} \tab Numeric. Purpose of the trip. 1 for business, 0 for other. \cr
   \code{income} \tab Numeric. Income (in GBP per annum) of the individual. \cr
}
}
\source{
Data imported from the apollo package \href{https://www.rdocumentation.org/packages/apollo/versions/0.2.6/topics/apollo_modeChoiceData}{archive}
}
\usage{
data(apolloModeChoiceData)
}
\description{
A simulated dataset containing 7,000 mode choices among four alternatives.
Data comes from 500 individuals, each with 14 stated stated preference
(SP) observations. There are 7,000 choices in total.
Each observation contains attributes for the alternatives,
availability of alternatives, and characteristics of the
individuals.
}
\examples{
data(apolloModeChoiceData)

head(apolloModeChoiceData)
}
\references{
Hess, S. & Palma, D. (2019), Apollo: a flexible, powerful and customisable freeware package for choice model estimation and application, Journal of Choice Modelling, Volume 32, September 2019.
\doi{10.1016/j.jocm.2019.100170}
}
\keyword{datasets}
