% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wtp.R
\name{wtpCompare}
\alias{wtpCompare}
\title{Compare WTP from preference and WTP space models}
\usage{
wtpCompare(model_pref, model_wtp, priceName)
}
\arguments{
\item{model_pref}{The output of a "preference space" model estimated using
the \code{logitr()} function.}

\item{model_wtp}{The output of a "willingness to pay space" model estimated
using the \code{logitr()} function.}

\item{priceName}{The name of the parameter that identifies price.}
}
\value{
A data frame comparing the WTP estimates from preference space and
WTP space models.
}
\description{
Returns a comparison of the WTP between a preference space and WTP space
model.
}
\details{
Willingness to pay (WTP) is first computed from the preference space model
by dividing the estimated parameters by the price parameter. Then those
estimates are compared against the WTP values directly estimated from the
"WTP" space model. Uncertainty is handled via simulation.
}
\examples{
# Run a MNL model in the Preference Space:
library(logitr)

mnl_pref <- logitr(
  data = yogurt,
  choiceName = "choice",
  obsIDName = "obsID",
  parNames = c("price", "feat", "dannon", "hiland", "yoplait")
)

# Get the WTP implied from the preference space model
wtp_mnl_pref <- wtp(mnl_pref, priceName = "price")

# Run a MNL model in the WTP Space:
mnl_wtp <- logitr(
  data = yogurt,
  choiceName = "choice",
  obsIDName = "obsID",
  parNames = c("feat", "dannon", "hiland", "yoplait"),
  priceName = "price",
  modelSpace = "wtp",
  options = list(startVals = wtp_mnl_pref$Estimate)
)

# Compare the WTP between the two spaces:
wtpCompare(mnl_pref, mnl_wtp, priceName = "price")
}
\keyword{logitr}
\keyword{wtp}
